DEFINT A-Z

DECLARE SUB AMenu (BYVAL Address, Start, Count, ScanCode, FileColr, HiLiteColr, Rows, Columns, Spacing, Row, Column)
DECLARE SUB BarPrint (Choice$(), BarColor)
DECLARE SUB Box0 (Y1, X1, Y2, X2, Char, Colr)
DECLARE SUB CDir (NewDir$)
DECLARE SUB ChangeDir ()
DECLARE SUB ClearMsgLine ()
DECLARE SUB ClearScr0 (Y1, X1, Y2, X2, Colr)
DECLARE SUB DeleteAll (DirName$)
DECLARE SUB DirFile (BYVAL Address, Count, ScanCode, MessageColor, FileColor, HiLite, BoxColor)
DECLARE SUB Editor (Edit$, Length, ScanCode, NumOnly, CapsOn, NormColor, EditColor, Row, Column)
DECLARE SUB FCopy (Source$, Dest$, Buffer$, ErrCode%)
DECLARE SUB Find (BYVAL Address, NumEls, Search$)
DECLARE SUB HideCursor ()
DECLARE SUB KillDir (DirName$)
DECLARE SUB KillFile (FileName$)
DECLARE SUB MakeDIR (DirName$)
DECLARE SUB NameFile (OldName$, NewName$)
DECLARE SUB PullDown (Choice$(), Stat(), Menu, Choice, Ky$, Action, Cnf AS ANY)
DECLARE SUB QPrint0 (X$, Colr)
DECLARE SUB ReadDir (BYVAL Address)
DECLARE SUB ReadFile (BYVAL Address)
DECLARE SUB ReadScrn0 (Row, Column, X$)
DECLARE SUB ShowCursor ()
DECLARE SUB SortStr (BYVAL Address, Size, Direction)
DECLARE SUB YesNo (YN$, Prompt$, ScanCode, NormalColr, EditColr, Row, Column)

DECLARE FUNCTION DCount (DirSpec$)
DECLARE FUNCTION DOSError ()
DECLARE FUNCTION Exist (FileName$)
DECLARE FUNCTION FCount (FSpec$)
DECLARE FUNCTION GetAttr (FileName$)
DECLARE FUNCTION GetDir$ (Drive$)
DECLARE FUNCTION GetDrive ()
DECLARE FUNCTION InstrTbl (Start, Source$, Table$)
DECLARE FUNCTION OneColor (Fg, Bg)

'$INCLUDE: 'DefCnf.BI'
'$INCLUDE: 'SetCnf.BI'

IF NOT Exist("SHELL.RUN") THEN
  CLS
  PRINT "No SHELL.RUN, read ZIPPER.DOC"
  END
END IF

OrigDir$ = GetDir$(CHR$(GetDrive))   'get the current directory

HideCursor


DO
  ClearScr0 1, 1, 25, 80, OneColor(1, 7)  'clear screen to blue on light grey
  Box0 2, 1, 25, 80, 2, OneColor(4, 7)    'main box

  Box0 4, 6, 23, 75, 1, OneColor(1, 7)    'sub box
  
  LineToPrint$ = "ZIP File Manager created by David Newcum"
  LOCATE 3, (80 - LEN(LineToPrint$)) / 2
  QPrint0 LineToPrint$, OneColor(15, 7)

  In$ = " "
  ReadScrn0 24, 1, In$
LOOP WHILE In$ = "" OR In$ = " "



'SETUP FOR AMENU

Count = FCount("*.ZIP")         'first count the number of matching files

DO
  IF Count > 0 THEN
      N = Count                       'save the count in N for later
      REDIM Array$(Count)               'dim a string array to hold the file names
      Array$(0) = "*.ZIP"              'put the file spec into element zero

      FOR X = 1 TO Count              'make room for the names
	  Array$(X) = SPACE$(12)
      NEXT
      ReadFile VARPTR(Array$(0))      'get the file names

      SortStr VARPTR(Array$(1)), Count, 0         'sort ascending

      N = Count
    ELSE
      ClearMsgLine
      LOCATE 1, 1
      QPrint0 SPACE$(80), OneColor(1, 7)
      LOCATE 1, 6
      QPrint0 "No ZIPs in current directory.  Press any key to choose new directory", OneColor(4, 7)
      
      DO
      LOOP WHILE INKEY$ = ""

      ChangeDir

      Count = FCount("*.ZIP")         'first count the number of matching files
      IF Count > 0 THEN
	N = Count                       'save the count in N for later
	REDIM Array$(Count)               'dim a string array to hold the file names
	Array$(0) = "*.ZIP"              'put the file spec into element zero

	FOR X = 1 TO Count              'make room for the names
	  Array$(X) = SPACE$(12)
	NEXT
	ReadFile VARPTR(Array$(0))      'get the file names

	SortStr VARPTR(Array$(1)), Count, 0         'sort ascending

	N = Count
      END IF
    END IF
LOOP WHILE Count = 0

CONST NumRows = 16
CONST NumColumns = 5
CONST Gap = 1
CONST MenuY = 6
CONST MenuX = 9


'SETUP FOR PULLDOWN
'----- Define the Menu Choices here
REDIM Stat(4, 2)                      'define the choice status array
REDIM Choice$(4, 2)                    'Allocate space for the Menu Choices
Choice$(0, 0) = " ZIP "
Choice$(1, 0) = " Copy "
Choice$(2, 0) = " Move "
Choice$(3, 0) = " Delete "
Choice$(4, 0) = " Rename "

Choice$(0, 1) = " Change Directory "
Choice$(0, 2) = " Quit "

BarPrint Choice$(), Cnf.PulBar 'Print the Bar Choices

Action = 0                'Action 0 is the easiest way to use PullDown
Menu = 0                  'start PullDown by displaying Menu 1
Choice = 1                'start with Choice #1 highlighted

DO
  ClearMsgLine

  LineToPrint$ = "<Tab=Menu>  <Enter=Unzip>  <Escape=Quit>"
  LOCATE 24, (80 - LEN(LineToPrint$)) / 2
  QPrint0 LineToPrint$, OneColor(8, 7)

  CurrentDir$ = GetDir$(CHR$(GetDrive))
  LOCATE 23, 9
  QPrint0 CHR$(180) + " " + CurrentDir$ + " " + CHR$(195) + STRING$(56 - LEN(CurrentDir$), 196), OneColor(1, 7)
  
  ClearScr0 5, 7, 22, 74, OneColor(7, 7)  'clear inner box
  AMenu VARPTR(Array$(1)), 1, Count, ScanCode, OneColor(1, 7), OneColor(15, 1), NumRows, NumColumns, Gap, MenuY, MenuX

  Dot = INSTR(Array$(Count), ".")
  ZIPName$ = LEFT$(Array$(Count), Dot - 1)      'get the name of the new directory

  SELECT CASE ScanCode
    CASE 27     'Escape
       CLS
       END
    CASE 13     'Enter
	'Unzip and go into a shell
	LOCATE 24, 6
	QPrint0 "Wait..." + SPACE$(60), OneColor(3, 7) + OneColor(16, 16)

	CurrentDir$ = GetDir$(CHR$(GetDrive))   'get the current directory
	Directory$ = ZIPName$      'get the name of the new directory
	MakeDIR CurrentDir$ + "\" + Directory$                      'make the new directory

	K$ = ""

	IF DOSError THEN
	  LOCATE 24, 6
	  QPrint0 "Subdirectory already exists.  Delete?", OneColor(4, 7)
	  DO
	    K$ = INKEY$
	  LOOP UNTIL K$ = "y" OR K$ = "Y" OR K$ = "n" OR K$ = "N"

	  K$ = UCASE$(K$)

	  LOCATE 24, 45
	  QPrint0 K$, OneColor(4, 7)

	  IF K$ = "Y" THEN
	    DeleteAll Directory$             'Delete all of the files in the directory
	    KillDir Directory$
	  END IF
	  MakeDIR CurrentDir$ + "\" + Directory$                      'make the new directory
	END IF

	IF K$ = "" OR K$ = "Y" THEN
	  CDir CurrentDir$ + "\" + Directory$    'change to the new directory

	  ClearScr0 1, 1, 25, 80, OneColor(1, 7)  'clear screen to blue on light grey
	  SHELL "PKUNZIP ..\" + Directory$       'unzip the file
	
	  CDir CurrentDir$
	  OPEN OrigDir$ + "\SHELL.RUN" FOR INPUT AS #1
	  DO UNTIL EOF(1)
	    TotalLines = TotalLines + 1
	    LINE INPUT #1, LineIn$        'how to run shell

	    IF TotalLines > 1 THEN
		RunShell$ = RunShell$ + CHR$(13) + LineIn$
	      ELSE
		RunShell$ = LineIn$
	    END IF
	  LOOP
	 
	  CLOSE #1

	  OPEN "SHELL.BAT" FOR OUTPUT AS #1
	  PRINT #1, "@ECHO OFF"
	  PRINT #1, "CD " + Directory$
	  PRINT #1, RunShell$
	  PRINT #1, CHR$(GetDrive) + ":"
	  PRINT #1, "CD" + CurrentDir$
	  PRINT #1, "CLS"
	  PRINT #1, "ECHO The subdirecory and files in " + CurrentDir$ + "\" + Directory$
	  PRINT #1, "ECHO are about to be deleted"
	  PRINT #1, "DEL " + Directory$
	  PRINT #1, "RD " + Directory$ + ">NUL"
	  PRINT #1, "ZIPPER"
	  CLOSE #1

	  CLS
	  END 1
	END IF

	Count = N

    CASE 9     'Tab
	LineToPrint$ = "                     <Tab=File List>  <Escape=Quit>                     "
	LOCATE 24, (80 - LEN(LineToPrint$)) / 2
	QPrint0 LineToPrint$, OneColor(8, 7)

	DO
	  ShowCursor
	  PullDown Choice$(), Stat(), Menu, Choice, Ky$, Action, Cnf
	  HideCursor

	  SELECT CASE Ky$
	    CASE CHR$(13)
	      SELECT CASE Menu
		CASE 0  'ZIP
		  SELECT CASE Choice
		    CASE 1      'Copy
		      OrigDir$ = GetDir$(CHR$(GetDrive))   'get the current directory

		      ChangeDir
		      BarPrint Choice$(), Cnf.PulBar 'Print the Bar Choices

		      ToDir$ = GetDir$(CHR$(GetDrive))   'get the current directory

		      CDir OrigDir$


		      IF Exist(ToDir$ + "\" + ZIPName$) THEN
			ClearMsgLine
			LOCATE 24, 6
			QPrint0 "File already exists.  Overwrite? ", OneColor(4, 7)

			DO
			  DO
			    K$ = INKEY$
			  LOOP WHILE K$ = ""
			LOOP UNTIL UCASE$(K$) = "Y" OR UCASE$(K$) = "N"

			K$ = UCASE$(K$)

			LOCATE 24, 39
			QPrint0 K$, OneColor(4, 7)

			IF K$ = "Y" THEN KillFile ToDir$ + "\" + ZIPName$
		      END IF

		      IF NOT Exist(ToDir$ + "\" + ZIPName$) THEN        'do it again, so if file was deleted
			Buffer$ = SPACE$(4096)
			FCopy OrigDir$ + "\" + Array$(Count), ToDir$ + "\" + Array$(Count), Buffer$, ErrCode
			Buffer$ = ""
		      END IF
		      
		      Ky$ = CHR$(9)
		    CASE 2      'Move
		      OrigDir$ = GetDir$(CHR$(GetDrive))   'get the current directory

		      ChangeDir
		      BarPrint Choice$(), Cnf.PulBar 'Print the Bar Choices

		      ToDir$ = GetDir$(CHR$(GetDrive))   'get the current directory

		      CDir OrigDir$


		      IF Exist(ToDir$ + "\" + ZIPName$) THEN
			ClearMsgLine
			LOCATE 24, 6
			QPrint0 "File already exists.  Overwrite? ", OneColor(4, 7)

			DO
			  DO
			    K$ = INKEY$
			  LOOP WHILE K$ = ""
			LOOP UNTIL UCASE$(K$) = "Y" OR UCASE$(K$) = "N"

			K$ = UCASE$(K$)

			LOCATE 24, 39
			QPrint0 K$, OneColor(4, 7)

			IF K$ = "Y" THEN KillFile ToDir$ + "\" + ZIPName$
		      END IF

		      IF NOT Exist(ToDir$ + "\" + ZIPName$) THEN        'do it again, so if file was deleted
			Buffer$ = SPACE$(4096)
			FCopy OrigDir$ + "\" + Array$(Count), ToDir$ + "\" + Array$(Count), Buffer$, ErrCode
			Buffer$ = ""
			KillFile OrigDir$ + "\" + Array$(Count)
		      END IF

		      DO
			IF Count > 0 THEN
			    Count = FCount("*.ZIP")         'first count the number of matching files
			    N = Count                       'save the count in N for later
			    REDIM Array$(Count)               'dim a string array to hold the file names
			    Array$(0) = "*.ZIP"              'put the file spec into element zero

			    FOR X = 1 TO Count              'make room for the names
			      Array$(X) = SPACE$(12)
			    NEXT
			    ReadFile VARPTR(Array$(0))      'get the file names

			    SortStr VARPTR(Array$(1)), Count, 0         'sort ascending

			    N = Count
			  ELSE
			    ClearMsgLine
			    LOCATE 1, 1
			    QPrint0 SPACE$(80), OneColor(1, 7)
			    LOCATE 1, 6
			    QPrint0 "No ZIPs in current directory.  Press any key to choose another directory.", OneColor(4, 7)

			    DO
			    LOOP WHILE INKEY$ = ""

			    ChangeDir

			    Count = FCount("*.ZIP")         'first count the number of matching files
			    IF Count > 0 THEN
			      N = Count                       'save the count in N for later
			      REDIM Array$(Count)               'dim a string array to hold the file names
			      Array$(0) = "*.ZIP"              'put the file spec into element zero

			      FOR X = 1 TO Count              'make room for the names
				Array$(X) = SPACE$(12)
			      NEXT
			      ReadFile VARPTR(Array$(0))      'get the file names

			      SortStr VARPTR(Array$(1)), Count, 0         'sort ascending

			  END IF
			END IF
		      LOOP WHILE Count = 0
		      
		      Ky$ = CHR$(9)                      'set it so it returns to the bottom
		      ClearMsgLine

		    CASE 3      'Delete
		      LOCATE 24, 6
		      QPrint0 "Are you sure? " + SPACE$(60), OneColor(4, 7)

		      DO
			DO
			  K$ = INKEY$
			LOOP WHILE K$ = ""
		      LOOP UNTIL UCASE$(K$) = "Y" OR UCASE$(K$) = "N"

		      K$ = UCASE$(K$)

		      LOCATE 24, 20
		      QPrint0 K$, OneColor(4, 7)
		  
		      IF K$ = "Y" THEN
			  KillFile RTRIM$(Array$(Count))    'delete it, then
							    'rescan the directory, and return

			  DO
			    IF Count > 0 THEN
				Count = FCount("*.ZIP")         'first count the number of matching files
				N = Count                       'save the count in N for later
				REDIM Array$(Count)               'dim a string array to hold the file names
				Array$(0) = "*.ZIP"              'put the file spec into element zero
    
				FOR X = 1 TO Count              'make room for the names
				    Array$(X) = SPACE$(12)
				NEXT
				ReadFile VARPTR(Array$(0))      'get the file names
    
				SortStr VARPTR(Array$(1)), Count, 0         'sort ascending
    
				N = Count
			      ELSE
				ClearMsgLine
				LOCATE 1, 1
				QPrint0 SPACE$(80), OneColor(1, 7)
				LOCATE 1, 6
				QPrint0 "No ZIPs in current directory.  Press any key to choose another directory.", OneColor(4, 7)
		    
				DO
				LOOP WHILE INKEY$ = ""

				ChangeDir
				
				Count = FCount("*.ZIP")         'first count the number of matching files
				IF Count > 0 THEN
				  N = Count                       'save the count in N for later
				  REDIM Array$(Count)               'dim a string array to hold the file names
				  Array$(0) = "*.ZIP"              'put the file spec into element zero
    
				  FOR X = 1 TO Count              'make room for the names
				    Array$(X) = SPACE$(12)
				  NEXT
				  ReadFile VARPTR(Array$(0))      'get the file names
    
				  SortStr VARPTR(Array$(1)), Count, 0         'sort ascending
			      
				END IF
			      END IF
			  LOOP WHILE Count = 0



			  Ky$ = CHR$(9)                      'set it so it returns to the bottom
			  ClearMsgLine
			ELSE
			  'reset message line
			  LOCATE 24, (80 - LEN(LineToPrint$)) / 2
			  QPrint0 LineToPrint$, OneColor(8, 7)
		      END IF
		    CASE 4      'Rename
		      LOCATE 24, 4
		      QPrint0 SPACE$(70), OneColor(4, 7)

		      Max = 12                'the maximum number of characters to accept
		      NumOnly = 0             'allow both letters and numbers
		      CapsOn = 1              'don't automatically capitalize letters
		      EditColor = OneColor(4, 7)         'use color 112 (black on white) while editing
		      NormColor = OneColor(7, 7)         'restore the field to color 7 when done

		      FileName$ = RTRIM$(Array$(Count))  'initial string for editing
		      FileName$ = FileName$ + SPACE$(Max - LEN(FileName$))     'pad with spaces to the
						    'desired length
		      Editor FileName$, Length, ScanCode, NumOnly, CapsOn, NormColor, EditColor, 24, 6
		      FileName$ = LEFT$(FileName$, Length)  'keep only as much as Editor says was entered

		      WherePeriod = INSTR(FileName$, ".")
		      IF WherePeriod > 0 THEN
			  FileName$ = LEFT$(FileName$, WherePeriod - 1) + ".ZIP"
			ELSE
			  FileName$ = FileName$ + ".ZIP"
		      END IF
		  
		      NameFile Array$(Count), FileName$

		      Count = FCount("*.ZIP")         'first count the number of matching files
		      N = Count                       'save the count in N for later
		      REDIM Array$(Count)               'dim a string array to hold the file names
		      Array$(0) = "*.ZIP"              'put the file spec into element zero

		      FOR X = 1 TO Count              'make room for the names
			  Array$(X) = SPACE$(12)
			  NEXT
		      ReadFile VARPTR(Array$(0))      'get the file names

		      SortStr VARPTR(Array$(1)), Count, 0         'sort ascending

		      N = Count

		      Ky$ = CHR$(9)                      'set it so it returns to the bottom
		  END SELECT
		CASE 1  'Change directory
		  ChangeDir
		  BarPrint Choice$(), Cnf.PulBar 'Print the Bar Choices

		  Count = FCount("*.ZIP")         'first count the number of matching files
		  DO
		    IF Count = 0 THEN               'no zip files in the dir
		      ClearMsgLine
		      LOCATE 1, 1
		      QPrint0 SPACE$(80), OneColor(1, 7)
		      LOCATE 1, 6
		      QPrint0 "No ZIPs in current directory.  Press any key to choose new directory", OneColor(4, 7)

		      DO
		      LOOP WHILE INKEY$ = ""

		      ChangeDir

		      Count = FCount("*.ZIP")         'first count the number of matching files
		    END IF
		  LOOP WHILE Count = 0

		  N = Count                       'save the count in N for later
		  REDIM Array$(Count)               'dim a string array to hold the file names
		  Array$(0) = "*.ZIP"              'put the file spec into element zero

		  FOR X = 1 TO Count              'make room for the names
		    Array$(X) = SPACE$(12)
		  NEXT
		  ReadFile VARPTR(Array$(0))      'get the file names

		  SortStr VARPTR(Array$(1)), Count, 0         'sort ascending

		  N = Count

		  Ky$ = CHR$(9)                      'set it so it returns to the bottom
		CASE 2  'Quit
		  CLS
		  END
	      END SELECT
	    CASE CHR$(27)       'ESCAPE
	      CLS
	      END
	    CASE CHR$(9)
	    CASE ELSE
	      BEEP
	  END SELECT
	LOOP UNTIL Ky$ = CHR$(9)

	LineToPrint$ = "<Tab=Menu>  <Enter=Unzip>  <Escape=Quit>"
	LOCATE 24, (80 - LEN(LineToPrint$)) / 2
	QPrint0 LineToPrint$, OneColor(8, 7)
	
	Count = N
    CASE ELSE
	BEEP
	Count = N
  END SELECT
LOOP

SUB ChangeDir
  ClearScr0 5, 7, 22, 74, OneColor(1, 7)  'clear screen to blue on light grey
  ClearMsgLine

  LOCATE 1, 1
  QPrint0 SPACE$(80), OneColor(1, 7)    'Clear first line to show # of zips


  OrigDir$ = GetDir$(CHR$(GetDrive))   'get the current directory

  Msg$ = "<Space=Change Directory>  <Enter=Exit>  <Escape=Cancel>"
  LOCATE 24, 40 - (LEN(Msg$) / 2)
  QPrint0 Msg$, OneColor(8, 7)

  DO
    Count = DCount("*.*")         'first count the number of matching files
    IF Count > 0 THEN
      N = Count                       'save the count in N for later
      REDIM Dirs$(0 TO Count)
      Dirs$(0) = "*.*"
      
      FOR X = 1 TO Count              'make room for the names
	Dirs$(X) = SPACE$(12)
      NEXT

      ReadDir BYVAL VARPTR(Dirs$(0))      'get the dir names
    END IF

    SortStr VARPTR(Dirs$(1)), Count, 0         'sort ascending

    Dirs$(0) = "..          "

    CurrentDir$ = GetDir$(CHR$(GetDrive))
    IF CurrentDir$ <> "\" THEN
	REDIM Array$(Count + 1)
	FOR X = 0 TO Count
	  Array$(X + 1) = Dirs$(X)
	NEXT X

	Count = Count + 1
      ELSE
	REDIM Array$(Count)
	FOR X = 0 TO Count
	  Array$(X) = Dirs$(X)
	NEXT X
    END IF

    LOCATE 23, 9
    QPrint0 CHR$(180) + " " + CurrentDir$ + " " + CHR$(195) + STRING$(56 - LEN(CurrentDir$), 196), OneColor(1, 7)

    LOCATE 1, 1
    QPrint0 "Number of ZIPs: " + STR$(FCount("*.ZIP")) + "   ", OneColor(1, 7)
    
    
    N = Count
    DO
      AMenu VARPTR(Array$(1)), 1, Count, ScanCode, OneColor(1, 7), OneColor(15, 1), NumRows, NumColumns, Gap, MenuY, MenuX
      IF ScanCode <> 32 THEN DirCount = N
    LOOP WHILE ScanCode <> 13 AND ScanCode <> 32 AND ScanCode <> 27

    IF ScanCode = 32 THEN       'Space
      CDir Array$(Count)
    END IF

    IF ScanCode = 27 THEN       'Escape
      CDir OrigDir$
      EXIT SUB
    END IF

  LOOP UNTIL ScanCode = 13      'Enter

  ClearMsgLine
END SUB

SUB ClearMsgLine
  LOCATE 24, 2
  QPrint0 SPACE$(78), OneColor(1, 7)
END SUB

SUB DeleteAll (DirName$)
  Count = FCount("*.ZIP")         'first count the number of matching files
  IF Count > 0 THEN
    N = Count                       'save the count in N for later
    REDIM Array$(Count)               'dim a string array to hold the file names
    Array$(0) = DirName$ + "\*.*"              'put the file spec into element zero

    FOR X = 1 TO Count              'make room for the names
      Array$(X) = SPACE$(12)
    NEXT

    ReadFile VARPTR(Array$(0))      'get the file names

    FOR X = 1 TO Count
      Array$(X) = LTRIM$(Array$(X))
      KillFile DirName$ + "\" + Array$(X)
    NEXT X
  END IF
END SUB

