' HUFFD.BAS - Huffman data de-compression routines.

' Version 1.00  05/05/91

' (C) Copyright 1991 K.A.T., Inc.
'                    502 NW 75th Street, Suite 214
'                    Gainesville, FL  32607

'                and William D. Hileman
'                    Route 2, Box 504
'                    Newberry, FL  32669
'                    (904) 472-6401

DEFINT A-Z

TYPE HTree
  Char  AS INTEGER
  Right AS INTEGER
  Left  AS INTEGER
END TYPE

' $INCLUDE: 'HUFFDECL.BAS'

DECLARE FUNCTION Exist (FileSpec$)
DECLARE FUNCTION FUsing$ (Num$, Image$)
DECLARE FUNCTION GetBit (InFile, Lin, Col, Msk$)
DECLARE FUNCTION GetChar$ (Bytes, Lin, Col, Msk$)

DECLARE SUB DiskInfo (Drv$, Bytes, Sectors, FreeClust, TotClust)
DECLARE SUB FGetA (Handle, SEG Address, NumBytes)
DECLARE SUB FPutA (Handle, SEG Address, NumBytes)
DECLARE SUB ShiftIR (Value, Places)

COMMON SHARED BytesIn&, InFile, BytePtr, OptBuf, InBytes()

FUNCTION GetBit (InFile, Lin, Col, Msk$) STATIC

  IF BitCount = 0 OR BitCount = 8 THEN
    BitCount = 0
    IF BytePtr = 0 OR BytePtr = OptBuf THEN
      FGetA FILEATTR(InFile, 2), SEG InBytes(0), OptBuf
      BytePtr = 0
    END IF
    BytePtr = BytePtr + 1
    BytesIn& = BytesIn& + 1
    IF Lin THEN
      IF (BytesIn& MOD OptBuf) = 0 THEN
        LOCATE Lin, Col
        PRINT FUsing$(" " + STR$(BytesIn&), Msk$);
      END IF
    END IF
    BitsIn = InBytes((BytePtr - 1) \ 2)
    IF (BytePtr MOD 2) THEN
      BitsIn = BitsIn AND 255
    ELSE
      ShiftIR BitsIn, 8
    END IF
  END IF
  OutBit = BitsIn AND 128
  BitsIn = BitsIn * 2
  BitCount = BitCount + 1
  GetBit = OutBit

END FUNCTION

FUNCTION GetChar$ (Bytes, Lin, Col, Msk$) STATIC

  Char$ = ""
  FOR Cnt = 1 TO Bytes
    IF BytePtr = 0 OR BytePtr = OptBuf THEN
      FGetA FILEATTR(InFile, 2), SEG InBytes(0), OptBuf
      BytePtr = 0
    END IF
    BytePtr = BytePtr + 1
    BytesIn& = BytesIn& + 1
    IF Lin THEN
      IF (BytesIn& MOD OptBuf) = 0 THEN
        LOCATE Lin, Col
        PRINT FUsing$(" " + STR$(BytesIn&), Msk$);
      END IF
    END IF
    BitsIn = InBytes((BytePtr - 1) \ 2)
    IF (BytePtr MOD 2) THEN
      BitsIn = BitsIn AND 255
    ELSE
      ShiftIR BitsIn, 8
    END IF
    Char$ = Char$ + CHR$(BitsIn)
  NEXT Cnt
  GetChar$ = Char$

END FUNCTION

SUB HuffDeCompress (InFile$, OutFile$, Mask$, Huff AS HuffType) STATIC

  Huff.Stat = 0
  Huff.BytesIn = 0
  Huff.BytesOut = 0

  IF NOT Exist(InFile$) THEN
    Huff.Stat = 1
    EXIT SUB
  END IF

  REDIM HT(0 TO 511) AS HTree

  FOR i = 0 TO 511
    HT(i).Char = i
    HT(i).Right = -1
    HT(i).Left = -1
  NEXT i

  Drv$ = ""
  IF LEN(InFile$) > 1 THEN
    IF MID$(InFile$, 2, 1) = ":" THEN
      Drv$ = LEFT$(InFile$, 1)
    END IF
  END IF

  DiskInfo Drv$, Bytes, Sectors, FreeClust, TotClust
  OptBuf = Bytes * Sectors

  DIM InBytes((OptBuf \ 2) - 1), OutBytes((OptBuf \ 2) - 1)

  InFile = FREEFILE
  OPEN InFile$ FOR BINARY AS InFile

  BytesIn& = 0
  BytesOut& = 0

  TotBytes& = CVL(GetChar$(4, Huff.InLin, Huff.InCol, Mask$))
  Root = CVI(GetChar$(2, Huff.InLin, Huff.InCol, Mask$))
  FOR Cnt = 256 TO Root
    HT(Cnt).Right = CVI(GetChar$(2, Huff.InLin, Huff.InCol, Mask$))
    HT(Cnt).Left = CVI(GetChar$(2, Huff.InLin, Huff.InCol, Mask$))
  NEXT Cnt

  IF Exist(OutFile$) THEN
    KILL OutFile$
  END IF

  OutFile = FREEFILE
  OPEN OutFile$ FOR BINARY AS OutFile

  WHILE BytesOut& < TotBytes&
    Hsb = Root
    WHILE HT(Hsb).Right <> -1
      IF GetBit(InFile, Huff.InLin, Huff.InCol, Mask$) THEN
        Hsb = HT(Hsb).Right
      ELSE
        Hsb = HT(Hsb).Left
      END IF
    WEND
    OutChar = HT(Hsb).Char
    Sb = OutPtr \ 2
    IF (OutPtr MOD 2) THEN
      OutBytes(Sb) = OutBytes(Sb) OR ((OutChar AND 255) * 256)
    ELSE
      OutBytes(Sb) = OutChar
    END IF
    BytesOut& = BytesOut& + 1
    OutPtr = OutPtr + 1
    IF OutPtr = OptBuf THEN
      FPutA FILEATTR(OutFile, 2), SEG OutBytes(0), OutPtr
      OutPtr = 0
      IF Huff.OutLin THEN
        LOCATE Huff.OutLin, Huff.OutCol
        PRINT FUsing$(" " + STR$(BytesOut&), Mask$);
      END IF
    END IF
  WEND

  IF OutPtr > 0 THEN
    FPutA FILEATTR(OutFile, 2), SEG OutBytes(0), OutPtr
  END IF

  IF Huff.InLin THEN
    LOCATE Huff.InLin, Huff.InCol
    PRINT FUsing$(" " + STR$(BytesIn&), Mask$);
  END IF
  IF Huff.OutLin THEN
    LOCATE Huff.OutLin, Huff.OutCol
    PRINT FUsing$(" " + STR$(BytesOut&), Mask$);
  END IF

  CLOSE InFile, OutFile

  Huff.BytesIn = BytesIn&
  Huff.BytesOut = BytesOut&

END SUB

