' LZWC.BAS - Lempel-Ziv-Welch data compression routines.

' Version 1.00  05/05/91

' (C) Copyright 1991 K.A.T., Inc.
'                    502 NW 75th Street, Suite 214
'                    Gainesville, FL  32607

'                and William D. Hileman
'                    Route 2, Box 504
'                    Newberry, FL  32669
'                    (904) 472-6401

DEFINT A-Z

COMMON SHARED Bits, HashingShift, MaxValue, MaxCode, TableSize
COMMON SHARED OptBuf, BytesIn&, BytesOut&, FileSize&, CodeValue()
COMMON SHARED PrefixCode(), AppendChar(), InBytes(), OutBytes()

' $INCLUDE: 'LZWDECL.BAS'

DECLARE FUNCTION Exist (FileSpec$)
DECLARE FUNCTION FUsing$ (Num$, Image$)
DECLARE FUNCTION FindMatch (Code1, Code2)
DECLARE FUNCTION CGetChar (InCh)

DECLARE SUB DiskInfo (Drv$, Bytes, Sectors, FreeClust, TotClust)
DECLARE SUB Fill2 (SEG Address, Value, Size)
DECLARE SUB FGetA (Handle, SEG Address, NumBytes)
DECLARE SUB FPutA (Handle, SEG Address, NumBytes)
DECLARE SUB OutputCode (OutCh, Code, Flush)
DECLARE SUB ShiftIL (IntVar, NumBits)
DECLARE SUB ShiftIR (IntVar, NumBits)
DECLARE SUB ShiftLL (LongVar&, NumBits)
DECLARE SUB ShiftLR (LongVar&, NumBits)

FUNCTION CGetChar (InCh) STATIC

  IF BytesIn& = FileSize& THEN
    CGetChar = -1
  ELSE
    IF CPos = 0 OR CPos = OptBuf THEN
      FGetA FILEATTR(InCh, 2), SEG InBytes(0), OptBuf
      CPos = 0
    END IF
    CPos = CPos + 1
    C = InBytes((CPos - 1) \ 2)
    IF (CPos MOD 2) THEN
      C = C AND 255
    ELSE
      ShiftIR C, 8
    END IF
    BytesIn& = BytesIn& + 1
    CGetChar = C
  END IF

END FUNCTION

FUNCTION FindMatch (HashPrefix, HashChar) STATIC

  Index = HashChar
  ShiftIL Index, HashingShift
  Index = Index OR HashPrefix
  IF Index THEN
    Offset = TableSize - Index
  ELSE
    Offset = 1
  END IF
  DO
    IF CodeValue(Index) = -1 THEN
      EXIT DO
    ELSEIF PrefixCode(Index) = HashPrefix AND AppendChar(Index) = HashChar THEN
      EXIT DO
    ELSE
      Index = Index - Offset
      IF Index < 0 THEN
        Index = Index + TableSize
      END IF
    END IF
  LOOP WHILE -1
  FindMatch = Index

END FUNCTION

SUB LZWCompress (Source$, Dest$, Mask$, LZW AS LZWType) STATIC

  LZW.Stat = 0
  LZW.BytesIn = 0
  LZW.BytesOut = 0

  IF NOT Exist(Source$) THEN
    LZW.Stat = 1
    EXIT SUB
  END IF

  Bits = LZW.Bits
  IF Bits < 12 OR Bits > 14 THEN
    Bits = 12
  END IF
  HashingShift = Bits - 8
  MaxValue = 1
  ShiftIL MaxValue, Bits
  MaxValue = MaxValue - 1
  MaxCode = MaxValue - 1

  IF Bits = 14 THEN
    TableSize = 18041
  ELSEIF Bits = 13 THEN
    TableSize = 9029
  ELSE
    TableSize = 5021
  END IF

  REDIM CodeValue(TableSize), PrefixCode(TableSize), AppendChar(TableSize)

  InCh = FREEFILE
  OPEN Source$ FOR BINARY AS InCh

  Drv$ = ""
  IF LEN(Source$) > 1 THEN
    IF MID$(Source$, 2, 1) = ":" THEN
      Drv$ = LEFT$(Source$, 1)
    END IF
  END IF

  DiskInfo Drv$, Bytes, Sectors, FreeClust, TotClust
  OptBuf = Bytes * Sectors
  FileSize& = LOF(InCh)

  REDIM InBytes((OptBuf \ 2) - 1), OutBytes((OptBuf \ 2) - 1)

  IF Exist(Dest$) THEN
    KILL Dest$
  END IF

  OutCh = FREEFILE
  OPEN Dest$ FOR BINARY AS OutCh

  NextCode = 256
  Fill2 SEG CodeValue(0), -1, TableSize - 1

  BytesIn& = 0
  BytesOut& = 0

  StringCode = CGetChar(InCh)

  DO
    Character = CGetChar(InCh)
    IF Character <> -1 THEN
      IF LZW.InLin THEN
        IF (BytesIn& MOD OptBuf) = 0 THEN
          LOCATE LZW.InLin, LZW.InCol
          PRINT FUsing(" " + STR$(BytesIn&), Mask$);
        END IF
      END IF
      Index = FindMatch(StringCode, Character)
      IF CodeValue(Index) <> -1 THEN
        StringCode = CodeValue(Index)
      ELSE
        IF NextCode <= MaxCode THEN
          CodeValue(Index) = NextCode
          NextCode = NextCode + 1
          PrefixCode(Index) = StringCode
          AppendChar(Index) = Character
        END IF
        OutputCode OutCh, StringCode, 0
        IF LZW.OutLin THEN
          IF (BytesOut& MOD OptBuf) = 0 THEN
            LOCATE LZW.OutLin, LZW.OutCol
            PRINT FUsing(" " + STR$(BytesOut&), Mask$);
          END IF
        END IF
        StringCode = Character
      END IF
    END IF
  LOOP UNTIL Character = -1

  OutputCode OutCh, StringCode, 0
  OutputCode OutCh, MaxValue, 0
  OutputCode OutCh, 0, -1

  IF LZW.InLin THEN
    LOCATE LZW.InLin, LZW.InCol
    PRINT FUsing(" " + STR$(BytesIn&), Mask$);
  END IF
  IF LZW.OutLin THEN
    LOCATE LZW.OutLin, LZW.OutCol
    PRINT FUsing(" " + STR$(BytesOut&), Mask$);
  END IF

  CLOSE InCh, OutCh

  LZW.BytesIn = BytesIn&
  LZW.BytesOut = BytesOut&

END SUB

SUB OutputCode (OutCh, Code, Flush) STATIC

  LCode& = CLNG(Code)
  ShiftLL LCode&, (32 - Bits - OutputBitCount)
  OutputBitBuffer& = OutputBitBuffer& OR LCode&
  OutputBitCount = OutputBitCount + Bits
  WHILE OutputBitCount >= 8
    TmpOBB& = OutputBitBuffer&
    ShiftLR TmpOBB&, 24
    OutBuf = CINT(TmpOBB&)
    sb = OutPtr \ 2
    IF (OutPtr MOD 2) THEN
      ShiftIL OutBuf, 8
      OutBytes(sb) = OutBytes(sb) OR OutBuf
    ELSE
      OutBytes(sb) = OutBuf
    END IF
    OutPtr = OutPtr + 1
    ShiftLL OutputBitBuffer&, 8
    OutputBitCount = OutputBitCount - 8
    BytesOut& = BytesOut& + 1
    IF (OutPtr = OptBuf) OR Flush THEN
      FPutA FILEATTR(OutCh, 2), SEG OutBytes(0), OutPtr
      OutPtr = 0
    END IF
  WEND

END SUB

