/*

    ARJWALK - a program that looks for things to compress.
    ------------------------------------------------------

    I wrote this program for myself because, from time to time,
    I need to free up disk space without deleting anything.

    This program goes from directory to directory looking for
    things to "ARJ" ("ARJ" is a great utility written by Robert
    Jung, and the word "ARJ" belongs to him).

    To use the program, go to the disk you want to work with
    and type ARJWALK.  When you use it the first time, answer
    NO to all the questions just to get a feel for what's happening.

    Other suggestions are:

        1.  Don't ARJ directories in your PATH unless
            you really know what you are doing.
        2.  Don't use this program when other programs
            are running because they may be using
            some files you want to ARJ and they
            may get confused if the files are gone.

    Needless to say, you need to have ARJ installed on your
    machine.

    This program is provided as is without liability of
    any sort.  It may or may not perform as described
    on your machine due to any number of factors.  There
    are no guarantees that you received an unmodified
    version of this software, an unmodified version of
    ARJ, or that your machine is free from virus.

    The "C" language source code for this program is
    given below.  If you modify it, please rename the
    product and remove my comments.
*/
/***************************************************************/
/*                                                             */
/*                                                             */
/*                                                             */
/*                                                             */
/***************************************************************/
#include  <stdio.h>  // some basic rtl includes
#include <stdlib.h>
#include <string.h>
#include  <ctype.h>
#include  <conio.h>
#include    <dir.h>
#include    <dos.h>
/***************************************************************/
/*                                                             */
/*                                                             */
/*                                                             */
/*                                                             */
/***************************************************************/
#define TYPE_FILE 0
#define TYPE_DIR  1
/***************************************************************/
/*                                                             */
/*                                                             */
/*                                                             */
/*                                                             */
/***************************************************************/
typedef struct sFI {
        struct find_t blk;
        char dirof[ 128 ];
        int count;
        int what;  // FILE OR DIR
        struct sFI *files;
        struct sFI *next;
        }sfxxx;
/***************************************************************/
/*                                                             */
/*                                                             */
/*                                                             */
/*                                                             */
/***************************************************************/
typedef struct sCMD {
        char *cmdstring;
        struct sCMD *next;
        }scmdxxx;
/***************************************************************/
/*                                                             */
/*                                                             */
/*                                                             */
/*                                                             */
/***************************************************************/
struct sCMD *Cmdroot = NULL;
struct sFI *Rootdirs = NULL;   // some global variables
char Cmd[ 200 ];
char Basecwd[ 128 ];
char Spec[ 128 ];
char Temp[ 128 ];
/***************************************************************/
/*                                                             */
/*                                                             */
/*                                                             */
/*                                                             */
/***************************************************************/
int removedoubles( char *s )  // the lazy programmer's method
{                             // for getting path names correct
    if( !strlen( s ) ) return( 0 );
    char *p = strstr( s, "\\\\" );
    while( p ) {
           strcpy( p, p + 1 );
           removedoubles( s );
           p = strstr( s, "\\\\" );
    }
    return( 1 );
}
/***************************************************************/
/*                                                             */
/*                                                             */
/*                                                             */
/*                                                             */
/***************************************************************/
int quit( void ) // hmmmm...  I can't remember what this does...
{
    chdir( Basecwd );
    printf( "You are now in %s\n", Basecwd );
    exit( 0 );
    return( 1 );
}
/***************************************************************/
/*                                                             */
/*                                                             */
/*                                                             */
/*                                                             */
/***************************************************************/
int drainget( void )
{
    while( kbhit() );
    while( 1 ) {
           int c = toupper( getch() );
           switch( c ) {
                   case 'Y':
                   case 'J':
                   case 'N':
                        printf( "\n" );
                        return( c );
           }
    }
    return( 0 );
}
/***************************************************************/
/*                                                             */
/*                                                             */
/*                                                             */
/*                                                             */
/***************************************************************/
int insertcmd( char *c )
{
struct sCMD *n = (struct sCMD *) malloc( sizeof( struct sCMD ) );
    if( n ) {
        n -> cmdstring = strdup( c );
        n -> next = NULL;
        if( !Cmdroot ) {
            Cmdroot = n;
        } else {
            for( struct sCMD *i = Cmdroot; i; i = i -> next ) {
                 if( !i -> next ) {
                     i -> next = n;
                     return( 1 );
                 }
            }
        }
    } else {
        printf( "Cannot get enough memory!\n" );
        return( quit() );
    }
    return( 1 );
}
/***************************************************************/
/*                                                             */
/*                                                             */
/*                                                             */
/*                                                             */
/***************************************************************/
int walkcmdlist( void )
{
    for( struct sCMD *i = Cmdroot; i; i = i -> next ) {
         printf( "%s\n", i -> cmdstring );
         system( i -> cmdstring );
    }
    return( 1 );
}

/***************************************************************/
/*                                                             */
/*                                                             */
/*                                                             */
/*                                                             */
/***************************************************************/
int walkdirlist( struct sFI *n )
{
    if( !n ) {
        return( 0 );
    }
    for( struct sFI *i = n; i; i = i -> next ) {
         switch( i -> what ) {
                 case TYPE_DIR:
                      if( i -> count > 1 ) {
                          if( !strlen( i -> blk.name ) ) {
                              printf( "\tRoot skipped\n" );
                          } else {
                              printf( "\t%s\\%s contains %d files.  ARJ them?", i -> dirof, i -> blk.name, i -> count );
                              switch( drainget() ) {
                                      case 'Y':
                                      case 'J':
                                           sprintf( Cmd, "CD  %s\\%s", i -> dirof, i -> blk.name );
                                           removedoubles( Cmd );
                                           insertcmd( Cmd );
                                           sprintf( Cmd, "ARJ m  %s *.*", i -> blk.name );
                                           removedoubles( Cmd );
                                           insertcmd( Cmd );
                              }
                          }
                      } else if( i -> count == 0 && !i -> files ) {
                          printf( "\t%s\\%s is empty.  Remove it? (Y/N) ", i -> dirof, i -> blk.name );
                          switch( drainget() ) {
                                  case 'Y':
                                  case 'J':
                                       sprintf( Cmd, "RD %s\\%s", i -> dirof, i -> blk.name );
                                       removedoubles( Cmd );
                                       insertcmd( Cmd );
                          }
                      }
                      walkdirlist( i -> files );
                      break;
                 case TYPE_FILE:
                      break;
                 default:
                      break;
         }
    }
    return( 1 );
}
/***************************************************************/
/*                                                             */
/*                                                             */
/*                                                             */
/*                                                             */
/***************************************************************/
struct sFI *insertlist( struct sFI *node, struct find_t *b, int wh )
{
    struct sFI *n;
    n = (struct sFI *)malloc( sizeof( struct sFI ) );
    if( n ) {
        memmove( &n -> blk, b, sizeof( struct find_t ) );
        sprintf( n -> dirof, "%s\\%s", node -> dirof, node -> blk.name );
        removedoubles( n -> dirof );
        n -> count = 0;
        n -> what = wh;
        n -> files = NULL;
        n -> next = NULL;
        switch( wh ) {
                case TYPE_FILE:
                     ++node -> count;
                     break;
        }
        if( !node -> files ) {
            node -> files = n;
        } else {
            for( struct sFI *i = node -> files; i; i = i -> next ) {
                 if( !i -> next ) {
                     i -> next = n;
                     return( n );
                 }
            }
        }
        return( n );
    }
    printf( "Memory fault!  Cannot load the directory tree.\n" );
    return( (sFI *)quit() );
}
/***************************************************************/
/*                                                             */
/*                                                             */
/*                                                             */
/*                                                             */
/***************************************************************/
int builddirlist( struct sFI *node )
{
    char temp[ 128 ];
    struct sFI *x;
    struct find_t blk;
    int done;
    strcpy( temp, node -> blk.name );
    sprintf( Spec, "%s\\%s\\%s", node -> dirof, node -> blk.name, "*.*" );
    removedoubles( Spec );
    done = _dos_findfirst( Spec , 0xFF, &blk );
    while( !done ) {
           switch( blk.attrib ) {
                   case FA_LABEL:
                   case FA_DIREC:
                        if( blk.name[ 0 ] != '.' ) {
                            x = insertlist( node, &blk, TYPE_DIR );
                            builddirlist( x );
                        }
                        break;
                   case 0x28:
                   case FA_ARCH:
                   case FA_RDONLY:
                   case FA_HIDDEN:
                   case FA_SYSTEM:
                   default:
                        x = insertlist( node, &blk, TYPE_FILE );
                        break;
           }
           done = _dos_findnext( &blk );
    }
    return( 0 );
}
/***************************************************************/
/*                                                             */
/*                                                             */
/*                                                             */
/*                                                             */
/***************************************************************/
int main( int argc, char *argv[] )
{
    getcwd( Basecwd, 128 );
    system( "CHKDSK /F" );
    struct find_t blk;
    int done = _dos_findfirst( Basecwd, 0xFF, &blk );
    if( !done ) {
        memset( &blk, 0, sizeof( struct find_t ) );
    }
    Rootdirs = (struct sFI *)malloc( sizeof( struct sFI ) );
    if( Rootdirs ) {
        memmove( &Rootdirs -> blk, &blk, sizeof( struct find_t ) );
        sprintf( Temp, "%c:\\", 'A' + getdisk() );
        removedoubles( Temp );
        strcpy( Rootdirs -> dirof, Temp );
        Rootdirs -> count = 0;
        Rootdirs -> files = NULL;
        Rootdirs -> next = NULL;
        Rootdirs -> what = TYPE_DIR;
        builddirlist( Rootdirs );
        walkdirlist( Rootdirs );
        walkcmdlist();
    }
    return( quit() );
}
/***************************************************************/
/*                                                             */
/*                                                             */
/*                                                             */
/*                                                             */
/***************************************************************/
