Program AF; {Archive Finder}
{$Define Err}
{$R+}

{.$DEFINE ENGLISH}

Uses Crt,Dos{$IfDef Err},Err{$Endif};

Const motRep         = {$IfDef English} 'Directory';
                       {$Else}          'Rpertoire'; {$Endif}
      motKo          = {$IfDef English} 'Kb';
                       {$Else}          'Ko'; {$Endif}
Const PatcherIci     : String[7] = 'Config:';
Const SousRepAussi   : Boolean = True;
      EcrireToutesA  : Boolean = False;
      ArchivesSeules : Boolean = False;
      NomComplet     : Boolean = False;
      Globale        : Boolean = True;
      PasLesArchives : Boolean = False;
      VueRapide      : Boolean = False;
      UniquementTot  : Boolean = False;
      AffTotaux      : Boolean = False;
      TousReps       : Boolean = True;
      BelleVue       : Boolean = True;
      UnCluster      : Word    = 0;
      DefaultRep     = '\';
      DefRep         : String[64] = DefaultRep;
      Lecteurs       : String[26] = 'CDE';
      DateMini       : LongInt = 0;
      DateMaxi       : LongInt = $7FFFFFFF;
      TailleMini     : LongInt = 0;
      TailleMaxi     : LongInt = $7FFFFFFF;
Type  Fichier        = Record
                             Nam : String[12];
                             Att : Byte;
                             Dat : LongInt;
                             Siz : LongInt;
                       End;
Const MaxFichiers    = 65000 div SizeOf(Fichier);
Type  FichiersT      = Array[1..MaxFichiers] of Fichier;
Var   Fichiers       : ^FichiersT;
      NbFics         : Word;

Const MaxMask        = 20;
Var   Mask           : Array[1..MaxMask] of String[128];
      NbMasques      : Byte;

      NbArch         : Word;
      Ext            : String[10];

      RepOriginal    : String;
      KeepExit       : Pointer;
      Redirige       : Boolean;
      CrtS           : Text;
      TotalFound     : LongInt;
      SearchMask     : String;
      TotDsk,TotDskR : LongInt;
      TotArc,TotArcR : LongInt;
      NumA,NumD      : Word;
      NbArcFound     : Word; {nbre d'archives trouves par -a}
      ChercheTailleClust : Boolean; {spcial quand on ne sait pas sur quel
                                     disk sera faite la recherche}
Const Pile           : Byte = 0;


Function OteBs(x:String):String;
{Supprime le \ final si ce n'est pas le rep principal qui est spcifi}
Begin
     if (x<>'\') and (Length(x)>1) and (x[Length(x)]='\') then
     if x[Pred(Length(x))]<>':' then dec(x[0]);
     OteBs:=x;
End;


Function AjouteBs(x:String):String;
{Ajoute un \ final}
Begin
     if x='' then x:='.\' else
     if x[Length(x)]=':' then x:=x+'.\' else
     if x[Length(x)]<>'\' then x:=x+'\';
     AjouteBs:=x;
End;


Function Redir:Boolean;
{pas encore implment la manire parfaite de dtecter la redirection,
 mais je dois avoir le source quelque part...}
Var b : Array[1..256] of Byte;
Begin
     Move(Mem[PrefixSeg:0],B,SizeOf(b)); Redir:=B[26]<>1;
End;


Function ClusterSize(c:Char):Word;
Type DPB = Record
                 Numero     : Byte;
                 SousUnite  : Byte;
                 OctPSect   : Word;
                 Interleave : Byte;
                 SectPClust : Byte;
                 Reserves   : Word;
                 NbreDeFats : Byte;
                 RootDir    : Word;
                 PremSect   : Word;
                 DernClust  : Word;
                 SectPFat   : Byte;
                 DataSect1  : Word;
                 Driver     : Pointer;
                 Media      : Byte;
                 Flag       : Byte;
                 NextDPB    : Pointer;
           End;
Var  p:^DPB;
     b:Byte;
     r:Registers;
Begin
     b:=Byte(UpCase(c)); ClusterSize:=0;
     if b in [$41..$5A] then
     Begin
          b:=b-$40;
          With r do
          Begin
               Ah:=$32; Dl:=b; MsDos(r);
               p:=Ptr(ds,bx);
               if Al=0 then
               With p^ do ClusterSize:=(1 shl SectPClust)*OctPSect;
          End;
     End;
End;


Function FullSize(s:LongInt):LongInt;
Var z:LongInt;
Begin
     z:=0;
     if UnCluster>0 then
     Begin
          z:=(s div UnCluster)*UnCluster;
          if s mod UnCluster<>0 then z:=z+UnCluster;
     End;
     FullSize:=z;
End;


Procedure ProcessKey;
Var c:Char;
Begin
     if Keypressed then
     Begin
          c:=ReadKey;
          if c in [#0,'',' '] then {^S,' '=pause, #0=tche de fonction}
             Begin
                  {$IfDef English}
                  Write(CrtS,' P a u s e    Press a key to continue');
                  {$Else}
                  Write(CrtS,' P a u s e    Une touche pour continuer');
                  {$Endif}
                  c:=ReadKey;
                  Write(CrtS,^M); ClrEol;
             End;
          if c in [^C,#27] then Halt;
     End;
End;


Function Justify(x:String; b:Byte):String;
Var Len:Byte absolute x;
Begin
     if Len>=b then Len:=b else While Len<b do x:=x+' '; Justify:=x;
End;


Function AffDate(d:DateTime):String;
Const Months : Array[0..12] of String[3]
             {$IfDef English}
             = ('???','Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');
             {$Else}
             = ('???','Jan','Fv','Mar','Avr','Mai','Jun','Jul','Ao','Sep','Oct','Nov','Dc');
             {$Endif}
Var x,y,z:String[3];
Begin
     With d do
     Begin
          Str(Day:2,x); Str(Year mod 100:2,z); y:=Months[Month];
     End;
     {$IfDef ENGLISH}
     AffDate:=y+' '+x+' '+z;
     {$Else}
     AffDate:=x+'-'+y+'-'+z;
     {$Endif}
End;


Function AffHeure(d:DateTime):String;
Var x,y:String[3];
Begin
     With d do
     Begin
          Str(Hour,x); if Hour<10 then x:='0'+x;
          Str(Min,y);  if Min<10  then y:='0'+y;
     End;
     AffHeure:=x+':'+y;
End;


{$i C:\bp\cat\AF.INC}


Function Check(s:String):Boolean;
Var k:Byte;
    Foo:Boolean;
Begin
     k:=0;
     Repeat
           Inc(k); if Pos('.',s)=0 then s:=s+'.'; Foo:=sCheck(Mask[k],s);
     Until foo or (k=NbMasques);
     Check:=foo;
End;


Procedure Reverse(Var l:LongInt);
{pour les .SIT (Mac) les nombres hexa sont dans l'ordre inverse...}
{Merci  Motorola et Intel de se mettre d'accord...}
Var l1:LongInt;
Begin
     l1:=((l and $FF000000) shr 24) or ((l and $00FF0000) shr 8) or
         ((l and $0000FF00) shl 8)  or ((l and $000000FF) shl 24);
     l:=l1;
End;


Function OteRep(s:String):String;
Var i:Byte;
Begin
     i:=Length(s); While (i>0) and (s[i]<>'\') and (s[i]<>':') do Dec(i);
     if i>0 then Delete(s,1,i);
     OteRep:=s;
End;


Procedure Examine(Nom:String; Taille:LongInt);
{Examen d'une archive, quel que soit son type}
Const MaxTampon = 200;
      ZooId     = $FDC4A7DC;
Type  ZooHdrTyp = Record
                        Zoo_Text  : Array[1..20] of Char; { Nom du compacteur }
                        Zoo_Tag   : LongInt;              { Identifie une archive Zoo }
                        Zoo_Start : LongInt;              { Dbut des donnes }
                        Zoo_Minus : LongInt;              { Vrification de concordance }
                        Zoo_Major : Char;                 { Version n }
                        Zoo_Minor : Char;                 { Sous-version n }
                  End;
Label Fin;      {- Oui, je sais}
Var   f         : File;
      Tampon    : Array[1..MaxTampon] of Byte;
      Lu        : Word;
      j1,j2     : Word; { pour compter la taille du nomfic et du commentaire }

      NomFic    : String;     { Nom du fichier       }
      Algo      : String[5];  { Algo de compression  }
      PSize     : LongInt;    { Packed Size          }
      USize     : LongInt;    { Unpacked (real) size }
      Date      : DateTime;   { Date du fichier      }

      Flusher   : LongInt;    { Nombre d'octets  sauter jusqu'au prochain fichier }
      i         : Byte;
      w         : Word;
      Li        : LongInt;
      Found     : Word;        { Nbr de fichiers trouvs }
      Count     : LongInt;     { Position dans le fichier }
      ZooHdr    : ZooHdrTyp;
      PassEntry : Boolean;
      NumOnLine : Byte;
      SizeP,SizeU : LongInt;   { Tailles totales (Packed et Unpacked) }
      Cmt       : Boolean;     { Est-ce un commentaire ? }
      d1,d2     : LongInt;     {taille des Datas pour les .SIT}
      TailleDisk: LongInt;     {Taille sur le disque}
      St        : String;
      KeepAttr  : Word;
Begin
     HighVideo;
     Write(CrtS,^M);
     if Redirige then ClrEol;
     if ArchivesSeules and AffTotaux and not Redirige then Write(CrtS,Taille:9,'  ');
     if NomComplet then Write(CrtS,Nom) else Write(CrtS,'Archive '+Nom);
     ClrEol; Write(CrtS,^M);

     Inc(NbArch);
     Found:=0; Assign(f,Nom); GetFAttr(f,KeepAttr); SetFAttr(f,0);
     Reset(f,1); Lu:=0; Count:=0;
     if Ext='ZOO' then
     Begin
          BlockRead(f,ZooHdr,SizeOf(ZooHdr),Lu);
          if Lu<SizeOf(ZooHdr) then Goto Fin;
          Count:=ZooHdr.Zoo_Start;
     End else
     if Ext='SIT' then
     Begin
          Count:=150; {moi non plus, je ne sais plus pourquoi}
     End;
     NumOnLine:=0; SizeP:=0; SizeU:=0; TailleDisk:=0;
     Repeat
           Seek(f,Count); PassEntry:=False; Cmt:=False;
           ProcessKey;
           BlockRead(f,Tampon[1],MaxTampon,Lu);
           if Lu<26 then Goto Fin;

           if Ext='SIT' then
           Begin
                Move(Tampon[3],NomFic,64);
                Move(Tampon[85],USize,4); Reverse(USize);
                Move(Tampon[93],PSize,4); Reverse(PSize);
                Move(Tampon[89],d1,4); Reverse(d1);
                Move(Tampon[97],d2,4); Reverse(d2);
                PSize:=PSize+d2; USize:=USize+d1;
                if Tampon[1]=0 then i:=Tampon[2] else i:=Tampon[1];
                Case i of
                     0: Algo:='Stord';
                     2: Algo:=' LZW ';
                   else Algo:='?????';
                End;
                Li:=0;
                Flusher:=100+PSize+12; {Pourquoi 12 ? Bonne question}
           End else
           if Ext='ZOO' then
           Begin
                Move(Tampon[1],Li,4);
                if Li<>ZooId then Goto Fin;
                Case Tampon[6] of
                     0: Algo:='Store';
                     1: Algo:=' Lzw ';
                   else Begin Str(Tampon[6]:3,Algo); Algo:='? '+Algo; End;
                End;
                Move(Tampon[25],PSize,4);
                Move(Tampon[21],USize,4);
                i:=39; NomFic:='';
                While Tampon[i]<>0 do Begin NomFic:=NomFic+UpCase(Chr(Tampon[i])); Inc(i); End;
                Flusher:=0; Move(Tampon[7],Count,4);
                Move(Tampon[15],w,2); Li:=LongInt(w) shl 16;
                Move(Tampon[17],w,2); Li:=Li+w;
           End else
           if Ext='TPZ' then
           Begin
                Case Tampon[25] of
                     0: Algo:='inclu';
                     1: Algo:='implo';
                End;
                Move(Tampon[26],USize,4);
                Move(Tampon[30],PSize,4);
                NomFic:='';
                i:=56;
                While (Tampon[i]<>32) And (i<56+67) do
                Begin
                     NomFic:=NomFic+UpCase(Chr(Tampon[i])); Inc(i);
                End;
                i:=43;
                While (Tampon[i]<>32) And (i<43+12) do
                Begin
                     NomFic:=NomFic+UpCase(Chr(Tampon[i])); Inc(i);
                End;
                Flusher:=PSize+122;
                Move(Tampon[36],Li,4);
           End else
           if Ext='LZH' then
           Begin
                Move(Tampon[3],St[1],3); St[0]:=#3;
                if St<>'-lh' then Goto Fin;
                Move(Tampon[22],NomFic,Tampon[22]+1);
                Algo[0]:=#5; Move(Tampon[3],Algo[1],5);
                Move(Tampon[8],PSize,4);
                Move(Tampon[12],USize,4);
                Move(Tampon[18],w,2); Li:=LongInt(w) shl 16;
                Move(Tampon[16],w,2); Li:=Li+w;
                Flusher:=PSize+2+Tampon[1];
           End else
           if (Ext='ARJ') or ((Ext[1]='A') and (Ext[2] in ['0'..'9'])) then
           Begin
                Move(Tampon[17],PSize,4);
                Move(Tampon[21],USize,4);
                i:=35; NomFic:=''; j1:=1;
                While Tampon[i]<>0 do Begin
                  NomFic:=NomFic+Chr(Tampon[i]); Inc(i); Inc(j1);
                End;
                Case Tampon[10] of
                     0: Algo:='Store';
                   else Algo:='Met.'+Chr($30+Tampon[10]);
                End;
                Cmt:=Tampon[11]=2;
                Move(Tampon[3],w,2);
                Move(Tampon[13],Li,4);
                if Cmt then Begin
                  Flusher:=4+w+4+2;
                End else Flusher:=14+w+PSize-4;
           End else
           if Ext='ZIP' then
           Begin
                Move(Tampon[1],Li,4); if Li=$02014B50 then Goto Fin;
                Move(Tampon[9],w,2);
                Case w of
                     0: Algo:='Stord';
                     1: Algo:='Shrun';
                     2: Algo:='Redu1';
                     3: Algo:='Redu2';
                     4: Algo:='Redu3';
                     5: Algo:='Redu4';
                     6: Algo:='Implo';
                     7: Algo:='Token';
                     8: Algo:='Defla'; {or EXTRA compression}
                   else Str(w:5,Algo);
                End;
                Move(Tampon[13],w,2); Li:=LongInt(w) shl 16;
                Move(Tampon[11],w,2); Li:=Li+w;
                Move(Tampon[19],PSize,4);
                Move(Tampon[23],USize,4);
                Move(Tampon[27],w,2); if w>255 then w:=255;
                NomFic[0]:=Chr(w); Move(Tampon[31],NomFic[1],w);
                Flusher:=30+w+PSize;
                Move(Tampon[29],w,2);
                Flusher:=Flusher+w;
           End else
           if (Ext='ARC') or (Ext='PAK') then
           Begin
                Case Tampon[2] of
                     0: Goto Fin;
                     1: Algo:='Stor1';
                     2: Algo:='Stor2';
                     3: Algo:='Packd';
                     4: Algo:='Squzd';
                     5: Algo:='Crun1';
                     6: Algo:='Crun2';
                     7: Algo:='Crun3';
                     8: Algo:='Crun4';
                     9: Algo:='Sqash';
                   else Algo:='  ?  ';
                End;

                i:=3; NomFic:='';
                While Tampon[i]<>0 do Begin NomFic:=NomFic+Chr(Tampon[i]); Inc(i); End;
                Move(Tampon[16],PSize,4);
                if Tampon[2]=1 then USize:=PSize
                               else Move(Tampon[26],USize,4);
                if Tampon[2]=1 then Flusher:=25+PSize
                               else Flusher:=29+Psize;
                Move(Tampon[18],Li,4);
           End;
           UnPackTime(Li,Date);

           While Pos('/',NomFic)<>0 do NomFic[Pos('/',NomFic)]:='\';
           if (Li>=DateMini) and (Li and $FFFF0000<=DateMaxi) and
              (USize>=TailleMini) and (USize<=TailleMaxi) then
           if (NomFic<>'') and not Cmt then if Check(OteRep(NomFic)) then
           Begin
                if Found=0 then
                Begin
                     if Redirige and (ArchivesSeules or not EcrireToutesA) then
                       if NomComplet then WriteLn(Nom)
                                     else WriteLn('Archive '+Nom);
                     if not Redirige then Begin LowVideo; WriteLn(CrtS); End;
                     if not (VueRapide or UniquementTot or NomComplet or ArchivesSeules) then
                     Begin
                          {$IfDef English}
                          WriteLn('File name                      Methd UnpSize  PakSize Prct    Date    Time ');
                          {$Else}
                          WriteLn('Nom du fichier                 Mthd TRelle  TComprs Prct    Date    Heure');
                          {$Endif}
                          WriteLn('------------------------------ ----- -------  ------- ----  --------- -----');
                     End;
                End;
                Inc(Found); Inc(TotalFound); Inc(SizeU,USize); Inc(SizeP,PSize);
                Inc(NumA);
                Inc(TotArc,USize);
                Inc(TotArcR,FullSize(USize));
                TailleDisk:=TailleDisk+FullSize(USize);
                if not (UniquementTot or ArchivesSeules) then
                if VueRapide then
                Begin
                     Inc(NumOnLine);
                     While Pos('\',NomFic)<>0 do Delete(NomFic,1,Pos('\',NomFic));
                     Write('  '+Justify(NomFic,12));
                     if NumOnLine=5 then
                     Begin
                          WriteLn(' '); NumOnLine:=0;
                     End else Write('  ');
                End else
                if NomComplet
                   then WriteLn(NomFic)
                   else Begin
                             Write(Justify(NomFic,30),' '+Algo,USize:8,' ',PSize:8,' ');
                             if USize>0 then Write(LongInt(PSize)*100 div USize:3,'%')
                                        else Write('100%');
                             if Li<>0 then Write('  ',AffDate(Date),' ',AffHeure(Date));
                             WriteLn;
                        End;
           End;
           if ArchivesSeules and (found>0) then Begin
             Inc(NbArcFound); Goto Fin;
           End;
           Inc(Count,Flusher);
     Until false;
Fin: Close(f);
     SetFAttr(f,KeepAttr);
     if VueRapide and (NumOnLine>0) then WriteLn;
     if Found>0 then if NomComplet and not ArchivesSeules then WriteLn else
     if not ArchivesSeules then
     if AffTotaux then
     Begin
          if not (VueRapide or UniquementTot) then
             WriteLn('------------------------------       -------  -------');
          if TailleDisk=0 then St:='' else
          Begin
               Str(TailleDisk,St);
               St:='('+St+')';
          End;
          if VueRapide then i:=24 else i:=36;
          if Found=1 then
            {$IfDef ENGLISH}
            Write(Justify('1 file '+St,i)) else
            {$Else}
            Write(Justify('1 fichier '+St,i)) else
            {$Endif}
          Begin
               Str(Found,Algo);
               {$IfDef ENGLISH}
               Write(Justify(Algo+' files '+St,i));
               {$Else}
               Write(Justify(Algo+' fichiers '+St,i));
               {$Endif}
          End;
          WriteLn(SizeU:8,' ',SizeP:8,' ',SizeP*100 div SizeU:3,'%');
          WriteLn;
     End else if Found>0 then WriteLn;
End;


Function WriteAttr(b:Byte):String;
Var x:String;
Begin
     x:='';
     if b and $1 =$1  then x:=x+'r' else x:=x+' ';
     if b and $2 =$2  then x:=x+'h' else x:=x+' ';
     if b and $4 =$4  then x:=x+'s' else x:=x+' ';
     if b and $20=$20 then x:=x+'a' else x:=x+' ';
     WriteAttr:=x;
End;


Var TmpStr    : String; {Cherche est rcursive !}
    Dt        : DateTime;
    i         : Word;
    NumOnLine : Byte;
    TotalSize : LongInt;
    TotalDisk : LongInt;
    St2       : String;

Procedure Cherche(Rep:ComStr);
{Recherche rcursive sur les fichiers du disque.}
Type RepTypPtr = ^RepTyp;
     RepTyp    = Record
                       n:RepTypPtr; {pointe sur le prochain}
                       s:String[12];
                 End;
Var Sr:SearchRec;
    FirstRep,ChnRep:RepTypPtr;
Begin
     Inc(Pile);
     {$i-} ChDir(Rep); {$i+}
     if IoResult<>0 then
     Begin
          if EcrireToutesA and not NomComplet then
          Begin
               {$IfDef English}
               TmpStr:='Invalid directory '+Rep;
               {$Else}
               TmpStr:='Rpertoire '+Rep+' invalide';
               {$Endif}
               HighVideo;
               if Redirige then Begin Write(TmpStr); ClrEol; WriteLn; End
                           else Begin
                                     Write(CrtS,^M+TmpStr); ClrEol;
                                     LowVideo; WriteLn(CrtS);
                                End;
          End;
          Exit;
     End;
     GetDir(0,TmpStr); if TmpStr[Length(TmpStr)]<>'\' then TmpStr:=TmpStr+'\';
     if ChercheTailleClust then
     Begin
          ChercheTailleClust:=false; UnCluster:=ClusterSize(TmpStr[1]);
     End;
     HighVideo;
     Write(CrtS,^M+motRep+' '+OteBS(TmpStr)); ClrEol; Write(CrtS,^M);
     LowVideo;
     NbFics:=0;

     FindFirst(SearchMask,AnyFile-VolumeId,Sr); ProcessKey;

     if TousReps then
     Begin
          New(ChnRep); FillChar(ChnRep^,Sizeof(ChnRep^),0); FirstRep:=ChnRep;
     End;

     if DosError=0 then
     With Sr do While DosError=0 do
     Begin
          if Attr and Directory<>0 then
          Begin
               if TousReps and (Name<>'.') and (Name<>'..') then
               Begin
                    ChnRep^.s:=Name; New(ChnRep^.n);
                    ChnRep:=ChnRep^.n;  FillChar(ChnRep^,SizeOf(ChnRep^),0);
               End;
          End else
          Begin
               if Time<0 then Time:=0;
               if Globale and (Time>=DateMini)
                          and (Time and $FFFF0000<=DateMaxi)
                          and (Size>=TailleMini)
                          and (Size<=TailleMaxi)
                          and Check(Name)
                          then
               Begin
                    Inc(NbFics); Inc(TotalFound); Inc(NumD);
                    With Fichiers^[NbFics] do
                    Begin
                         Nam:=Name; Siz:=Size; Dat:=Time; Att:=Attr;
                         Inc(TotDsk,Size); Inc(TotDskR,FullSize(Size));
                    End;
               End;
               if not PasLesArchives then
               Begin
                    if Pos('.',Name)<>0 then Ext:=Copy(Name,Pos('.',Name)+1,3)
                                        else Ext:='';
                    if (Ext='LZH') or (Ext='ARJ') or (Ext='ZIP') or (Ext='ARC') or
                       (Ext='PAK') or (Ext='ZOO') or (Ext='SIT') or (Ext='TPZ')
                       or ((Ext[1]='A') and (Ext[2] in ['0'..'9']) and (Ext[3] in ['0'..'9']))
                       then Examine(TmpStr+Name,Size)
               End;
          End;
          ProcessKey; FindNext(Sr);
     End;
     if NbFics>0 then
     Begin
          NumOnLine:=0; HighVideo; TotalSize:=0; TotalDisk:=0;
          if BelleVue or NomComplet then Begin LowVideo; ClrEol; End else
          if Redirige then Begin Write(motRep+' '+OteBs(TmpStr)); ClrEol; WriteLn; End
                      else Begin
                                Write(CrtS,^M+MotRep+' '+OteBs(TmpStr)); ClrEol;
                                LowVideo; WriteLn(CrtS);
                           End;
          LowVideo;
          if not (BelleVue or NomComplet or VueRapide or UniquementTot) then
          Begin
               {$IfDef English}
               WriteLn('File name       Size     Date     Time ');
               {$Else}
               WriteLn('Nom fichier    Taille    Date     Heure');
               {$Endif}
               WriteLn('------------  -------  ---------  -----');
          End;
          For i:=1 to NbFics do With Fichiers^[i] do
          Begin
               TotalSize:=TotalSize+Siz; TotalDisk:=TotalDisk+FullSize(Siz);
               ProcessKey;
               UnpackTime(Dat,DT);
               if NomComplet then WriteLn(AjouteBs(OteBs(TmpStr))+Nam) else
               if not UniquementTot then
               if BelleVue then
                  WriteLn(Justify(Nam,12)+' ',Siz:8,'  '+AffDate(Dt)+'  '+
                          AffHeure(Dt)+'  '+AjouteBs(OteBs(TmpStr))) else
               if VueRapide then
               Begin
                    Inc(NumOnLine);
                    Write('  '+Justify(Nam,12));
                    if NumOnLine=5 then
                    Begin
                         WriteLn; NumOnLine:=0;
                    End else Write('  ');
               End else
                  WriteLn(Justify(Nam,12)+' ',Siz:8,'  '+AffDate(Dt)+'  '+AffHeure(Dt));
          End;
          if VueRapide and (NumOnLine<>0) then WriteLn;
          if AffTotaux then
          Begin
               if not (VueRapide or UniquementTot) then
                  WriteLn('              -------');
               if NbFics=1 then {$IfDef English}Write(Justify('1 file',13))
                                {$Else}Write(Justify('1 fichier',13)){$Endif}
                           else
               Begin
                    Str(NbFics,St2);
                    {$IfDef English}
                    Write(Justify(St2+' files',13));
                    {$Else}
                    Write(Justify(St2+' fichiers',13));
                    {$Endif}
               End;
               WriteLn(' ',TotalSize:7,'  (',TotalDisk,')');
          End;
          if not NomComplet then WriteLn;
     End else if (not ArchivesSeules and EcrireToutesA) then
         if Redirige then Writeln(motRep+' '+OteBs(TmpStr))
                     else Begin LowVideo; WriteLn(CrtS); End;
     if SousRepAussi then
     Begin
          if not TousReps then
          Begin
               FindFirst('*.',Directory,Sr);
               With Sr do While DosError=0 do
               Begin
                    if (Attr and Directory=Directory) and (Name<>'.') and (Name<>'..') then
                       Cherche(Name);
                    FindNext(Sr);
               End;
          End else
          if (FirstRep^.n<>Nil) or (FirstRep^.s<>'') then
          Begin
               ChnRep:=FirstRep;
               While ChnRep<>Nil do
               Begin
                    if ChnRep^.s<>'' then Cherche(ChnRep^.s);
                    FirstRep:=ChnRep; ChnRep:=ChnRep^.n; Dispose(FirstRep);
               End;
          End else Dispose(FirstRep);
     End;
     Dec(Pile); if Pile>0 then ChDir('..');
     Write(CrtS,^M); ClrEol; LowVideo;
End;


Function PlusMoins(Var x:String):Byte;
{Gestion des paramtres de la ligne de commande}
Begin
     Delete(x,1,1);
     if x[1]='-' then Begin PlusMoins:=0; Delete(x,1,1); End else
     if x[1]='+' then Begin PlusMoins:=1; Delete(x,1,1); End else
                            PlusMoins:=2;
End;


Function LisDate(Var s:String):LongInt;
Var Dt:DateTime;
    L:LongInt;
    dow:Word;
    ErrVal:Integer;
Begin
     Delete(s,1,1); L:=-1;
     With Dt do
     if Length(s)>=6 then
     Begin
          {$IfDef English}
          Val(Copy(s,3,2),Day,ErrVal); if ErrVal<>0 then Day:=1;
          Val(Copy(s,1,2),Month,ErrVal); if ErrVal<>0 then Month:=1;
          {$Else}
          Val(Copy(s,1,2),Day,ErrVal); if ErrVal<>0 then Day:=1;
          Val(Copy(s,3,2),Month,ErrVal); if ErrVal<>0 then Month:=1;
          {$Endif}
          Val(Copy(s,5,2),Year,ErrVal); if ErrVal<>0 then Year:=1;
          Year:=Year+1900; While Year<1980 do Inc(Year,100);
          Hour:=0; Min:=0; Sec:=0;
          PackTime(Dt,L); Delete(s,1,6);
     End else
     if (s='') or (s[1]<'0') or (s[1]>'9') then
     Begin
          GetDate(Year,Month,Day,Dow); Hour:=0; Min:=0; Sec:=0;
          While Year<1980 do Inc(Year,100);
          PackTime(Dt,l);
     End else {$IfDef English}
              WriteLn('/D invalid date (mmddyy)');
              {$Else}
              WriteLn('/D date invalide (JJMMYY)');
              {$Endif}
     LisDate:=L;
End;


Function ShowDate(l:LongInt):String;
Var s,x:String[6];
    Dt:DateTime;
Begin
     UnpackTime(l,Dt);
     With Dt do Begin
       s:='';
       {$IfDef English}
       if Month<10 then s:=s+'0'; Str(Month,x); s:=s+x;
       if Day<10   then s:=s+'0'; Str(Day,x); s:=s+x;
       {$Else}
       if Day<10   then s:=s+'0'; Str(Day,x); s:=s+x;
       if Month<10 then s:=s+'0'; Str(Month,x); s:=s+x;
       {$Endif}
       Year:=Year mod 100; if Year<10 then s:=s+'0'; Str(Year,x); s:=s+x;
     End;
     ShowDate:=s;
End;


Function LisTaille(Var x:String):LongInt;
{Extraction de la taille aprs /i999}
Var s:String;
    L:LongInt;
    ErrVal:Integer;
Begin
     Delete(x,1,1); LisTaille:=-1;
     if x<>'' then
     Begin
          s:='';
          While (x<>'') and (x[1]>='0') and (x[1]<='9') do
          Begin
               s:=s+x[1]; Delete(x,1,1);
          End;
          Val(s,L,ErrVal); if ErrVal<>0 then L:=-1;
          LisTaille:=L;
     End;
End;


Procedure LisParametres;
Const Pm : Array[Boolean] of Char = ('-','+');
Var Msk,Ext,x,y,z,t,Rep:String;
    i,j:Byte;
    Stupid,DefRepSet,AffHelp,Debug:Boolean; {Si /R a dj t spcifi}
Begin
     SearchMask:='*.*'; NbMasques:=0; DefRepSet:=False; Rep:=''; Stupid:=False;
     ChercheTailleClust:=False; AffHelp:=False; Debug:=False;
     if ParamCount>0 then
     Begin
          For i:=1 to ParamCount do
          Begin
               x:=ParamStr(i); For j:=1 to Length(x) do x[j]:=UpCase(x[j]);
               if x[1]='?' then AffHelp:=True else
               if (x[1]='/') or (x[1]='-') then
               Begin
                    Delete(x,1,1);
                    While x<>'' do
                    Case x[1] of
                         'A' : Begin
                                    Case PlusMoins(x) of
                                         0: ArchivesSeules:=False;
                                         1: ArchivesSeules:=True;
                                         2: ArchivesSeules:=not ArchivesSeules;
                                    End;
                                    if ArchivesSeules then
                                    Begin
                                         EcrireToutesA:=True; Globale:=False;
                                    End;
                               End;
                         'B' : Case PlusMoins(x) of
                                    0: BelleVue:=False;
                                    1: BelleVue:=True;
                                    2: BelleVue:=not BelleVue;
                               End;
                         'C' : Begin
                                    Case PlusMoins(x) of
                                         0: SousRepAussi:=False;
                                         1: SousRepAussi:=True;
                                         2: SousRepAussi:=not SousRepAussi;
                                    End;
                                    if not DefRepSet then
                                    Begin
                                         DefRep:='';
                                         DefRepSet:=True;
                                         GetDir(0,y); Lecteurs:=y[1];
                                    End;
                               End;
                         'D' : Begin
                                    Delete(x,1,1);
                                    Case x[1] of
                                         '+': DateMini:=LisDate(x);
                                         '-': DateMaxi:=LisDate(x);
                                         '=': Begin
                                                   DateMini:=LisDate(x);
                                                   DateMaxi:=DateMini;
                                              End;
                                         else {$IfDef English} WriteLn('/D incorrect syntax');
                                              {$Else} WriteLn('/D syntaxe incorrecte'); {$Endif}
                                    End;
                               End;
                         'E' : Case PlusMoins(x) of
                                    0: EcrireToutesA:=False;
                                    1: EcrireToutesA:=True;
                                    2: EcrireToutesA:=not EcrireToutesA;
                               End;
                         'F' : Case PlusMoins(x) of
                                    0: AffTotaux:=False;
                                    1: AffTotaux:=True;
                                    2: AffTotaux:=not AffTotaux;
                               End;
                         'G' : Case PlusMoins(x) of
                                    0: Globale:=False;
                                    1: Globale:=True;
                                    2: Globale:=not Globale;
                               End;
                         'I' : Begin
                                    Delete(x,1,1);
                                    Case x[1] of
                                         '+': TailleMini:=LisTaille(x);
                                         '-': TailleMaxi:=LisTaille(x);
                                         '=': Begin
                                                   TailleMini:=LisTaille(x);
                                                   TailleMaxi:=TailleMini;
                                              End;
                                         else {$IfDef English} WriteLn('/I incorrect syntax');
                                              {$Else} WriteLn('/I syntaxe incorrecte'); {$Endif}
                                    End;
                               End;
                         'L' : Begin
                                    Delete(x,1,1);
                                    if x<>'' then
                                    if x='0' then Begin
                                      GetDir(0,y); Lecteurs:=y[1];
                                    End else Lecteurs:=x;
                                    x:='';
                               End;
                         'M' : Begin
                                    Delete(x,1,1);
                                    if x<>'' then
                                    Begin
                                         FSplit(x,y,z,t);
                                         if y<>'' then DefRep:=OteBS(y);
                                         if Pos(':',y)<>0 then Begin
                                           Lecteurs:=y[1];
                                         End;
                                         SearchMask:=z+t; x:='';
                                    End;
                               End;
                         'N' : Case PlusMoins(x) of
                                    0: NomComplet:=False;
                                    1: NomComplet:=True;
                                    2: NomComplet:=not NomComplet;
                               End;
                         'P' : Case PlusMoins(x) of
                                    0: PasLesArchives:=False;
                                    1: PasLesArchives:=True;
                                    2: PasLesArchives:=not PasLesArchives;
                               End;
                         'R' : Begin
                                    Delete(x,1,1);
                                    if x<>'' then
                                    Begin
                                         DefRep:=x; DefRepSet:=True;
                                         if x[2]=':' then Lecteurs:=x[1];
                                         x:='';
                                    End;
                               End;
                         'S' : Case PlusMoins(x) of
                                    0: SousRepAussi:=False;
                                    1: SousRepAussi:=True;
                                    2: SousRepAussi:=not SousRepAussi;
                               End;
                         'T' : Begin
                                    Delete(x,1,1);
                                    if x<>'' then
                                    Begin
                                         AffTotaux:=True;
                                         if x[1]='0' then
                                         Begin
                                              ChercheTailleClust:=True;
                                              Delete(x,1,1);
                                         End else
                                         if x[1] in ['A'..'Z'] then
                                         Begin
                                              UnCluster:=ClusterSize(x[1]);
                                              Delete(x,1,1);
                                              ChercheTailleClust:=False;
                                         End else
                                         if x[1]='-' then
                                         Begin
                                              Delete(x,1,1); ChercheTailleClust:=False;
                                         End;
                                    End;
                               End;
                         'U' : Case PlusMoins(x) of
                                    0: UniquementTot:=False;
                                    1: UniquementTot:=True;
                                    2: UniquementTot:=not UniquementTot;
                               End;
                         'W' : Case PlusMoins(x) of
                                    0: VueRapide:=False;
                                    1: VueRapide:=True;
                                    2: VueRapide:=not VueRapide;
                               End;
                         '*' : Case PlusMoins(x) of
                                    0: TousReps:=False;
                                    1: TousReps:=True;
                                    2: TousReps:=not TousReps;
                               End;
                         '#' : Case PlusMoins(x) of
                                    0: Redirige:=False;
                                    1: Redirige:=True;
                                    2: Redirige:=not Redirige;
                               End;
                         '?' : Begin Delete(x,1,1); AffHelp:=True; End;
                         ')' : Begin Delete(x,1,1); Debug:=True;   End;
                          else Delete(x,1,1);
                    End;
               End else
               Begin
                    { On fait le FSplit  la main pour avoir des MASK et EXT
                      ayant des tailles suprieures aux normes DOS. Par
                      exemple: AF *LIS*MOI*.V*D* }
                    if x[Length(x)]=':' then x:=x+'.\'; j:=Length(x);
                    While (j>0) and (x[j]<>'\') and (x[j]<>':') do Dec(j);
                    if j>0 then
                    Begin
                         if (j>1) then Rep:=Copy(x,1,j-1) else
                         if j=1 then Rep:='\';
                         if j<>Length(x) then x:=Copy(x,j+1,Length(x)-j)
                                         else x:='';
                    End;
                    j:=Pos('.',x);
                    if j>0 then
                    Begin
                         Msk:=Copy(x,1,j-1); Ext:=Copy(x,j,Length(x)-j+1);
                    End else
                    Begin
                         Msk:=x; Ext:='';
                    End;
                    While Pos('**',Msk)<>0 do Delete(Msk,Pos('**',Msk),1);
                    { on agrandis la recherche dans la limite du raisonnable }
                    if (Msk[Length(Msk)]<>'*') and (Ext='') then Msk:=Msk+'*';
                    Msk:=Msk+Ext;
                    if NbMasques=MaxMask then
                       {$IfDef English}
                       WriteLn('WARNING: only ',MaxMask,' will be used !') else
                       {$Else}
                       WriteLn('ATTENTION: seulement ',MaxMask,' pris en compte !') else
                       {$Endif}
                       Begin
                            Inc(NbMasques); Mask[NbMasques]:=Msk;
                       End;
               End;
          End;
     End;
     if Globale and PasLesArchives and not DefRepSet and (Rep<>'')
        then DefRep:=Rep;
     if UniquementTot then
     Begin
          if not AffTotaux then
          Begin
               AffTotaux:=True; ChercheTailleClust:=True;
          End;
          BelleVue:=False;
     End;
     if (ArchivesSeules and PasLesArchives) or
        (not Globale and PasLesArchives) then
     Begin
          Stupid:=True;
          {$IfDef English}
          WriteLn('What a stupid request ! Try option /)');
          {$Else}
          WriteLn('Quelle requte idiote ! Essayez l''option /)');
          {$Endif}
     End;
     if ArchivesSeules then Globale:=False;
     if NbMasques=0 then
     Begin
          Inc(NbMasques); Mask[1]:='*';
     End;
     if PasLesArchives and Globale and not TousReps and (NbMasques=1) then
     Begin
          i:=Pos('*',Mask[1]);
          if (i=0) or (i<>Length(Mask[1])) or (Mask[1][Succ(i)]<>'.')
             then SearchMask:=Mask[1] else TousReps:=True;
     End;
     if Pos('.',SearchMask)=0 then
     Begin
          if SearchMask[Length(SearchMask)]<>'*' then SearchMask:=SearchMask+'*';
          SearchMask:=SearchMask+'.*';
     End;
     if DefRep[Length(DefRep)]=':' then DefRep:=DefRep+'.\';
     if AffHelp or Debug then
     Begin
          if not Debug then
          Begin
               {$IfDef English}
               WriteLn('Usage: AF [Mask*.*] [*Mask*] [/Parameter(s)] [-Parameter(s)]');
               {$Else}
               WriteLn('Usage: AF [Masque*.*] [*Masque*] [/Paramtre(s)] [-Paramtre(s)]');
               {$Endif}
               WriteLn;
          End;
          {$IfDef English}
          Write('  /a '+PM[ArchivesSeules]+'  Archive names only        ');
          Write('  /b '+PM[BelleVue]+'  Beautiful vue');
          WriteLn;
          Write('  /c    Current directory only    ');
          Write('  /d... Date (/d+311291 /d=010191)');
          WriteLn;
          Write('  /e '+PM[EcrireToutesA]+'  Every name written        ');
          Write('  /f '+PM[AffTotaux]+'  Full statistics         ');
          WriteLn;
          Write('  /g '+PM[Globale]+'  Global search             ');
          Write('  /i... sIze (/i+1024 /i-2048)  ');
          WriteLn;
          Write('  /l... Look drives: '+Justify(Lecteurs,12)+' ');
          Write('  /m... Mask for archives: '+Justify(SearchMask,16)+' ');
          WriteLn;
          Write('  /n '+PM[NomComplet]+'  Names only');
          WriteLn;
          Write('  /p '+PM[PasLesArchives]+'  skiP archives             ');
          Write('  /r... staRting at directory');
          WriteLn;
          Write('  /s '+PM[SousRepAussi]+'  Subdirs also              ');
          Write('  /t... True size on disk');
          WriteLn;
          Write('  /u '+PM[UniquementTot]+'  show only totals          ');
          Write('  /w '+PM[VueRapide]+'  Wide display       ');
          WriteLn;
          Write('  /* '+PM[TousReps]+'  all directories');
         {$Else}
          Write('  /a '+PM[ArchivesSeules]+'  noms Archives seulement   ');
          Write('  /b '+PM[BelleVue]+'  Belle vue');
          WriteLn;
          Write('  /c    dans Ce rpertoire        ');
          Write('  /d... date (/d+'+ShowDate(DateMini)+' /d-'+ShowDate(DateMaxi)+')');
          WriteLn;
          Write('  /e '+PM[EcrireToutesA]+'  tous les noms             ');
          Write('  /f '+PM[AffTotaux]+'  aFficher les totaux     ');
          WriteLn;
          Write('  /g '+PM[Globale]+'  recherche Globale         ');
          Write('  /i... taille (/i+1024 /i-2048)');
          WriteLn;
          Write('  /l... Lecteurs: '+Justify(Lecteurs,12)+'    ');
          Write('  /m... Masque: '+Justify(SearchMask,16)+' ');
          WriteLn;
          Write('  /n '+PM[NomComplet]+'  Nom complets');
          WriteLn;
          Write('  /p '+PM[PasLesArchives]+'  Pas les archives          ');
          Write('  /r... Rpertoire de dpart');
          WriteLn;
          Write('  /s '+PM[SousRepAussi]+'  Sous-rpertoires          ');
          Write('  /t... Taille relle');
          WriteLn;
          Write('  /u '+PM[UniquementTot]+'  totaux Uniquement         ');
          Write('  /w '+PM[VueRapide]+'  affichage ''Wide''');
          WriteLn;
          Write('  /* '+PM[TousReps]+'  tous les rpertoires');
          {$Endif}
          WriteLn;
          if not Debug then
          Begin
               WriteLn;
               {$Ifdef ENGLISH}
               WriteLn('AF looks all over the disks through archives created by Arj, PkZip, Lha,');
               WriteLn('LhArc, PkArc/PkPak, Arc, Zoo, StuffIt and Tpz for the specified masks.');
               WriteLn('Exemples: AF *.DOC >MyFile.lst     Result is in "MYFILE.LST"');
               WriteLn('          AF *.DOC /gmFREE*.ZIP    Only looks in FREE*.ZIP archives');
               WriteLn('          AF *.DOC /rC:\UTIL       Start searching in C:\Util');
               WriteLn('          AF -cgmDOC.ZIP -tC       Shows true size after unpacking on C:');
               {$ELSE}
               WriteLn('AF cherche sur tout le disque dans les archives cres par Arj, PkZip, Lha,');
               WriteLn('LhArc, PkArc/PkPak, Arc, Zoo, StuffIt et Tpz le masque spcifi.');
               WriteLn('Exemples: AF *.DOC >Fichier.lst    le rsultat est dans "FICHIER.LST"');
               WriteLn('          AF *.DOC /gmFREE*.ZIP    recherche dans les FREE*.ZIP seulement');
               WriteLn('          AF *.DOC /rC:\UTIL       commencer la recherche  C:\Util');
               WriteLn('          AF -cgmDOC.ZIP -tC       affiche la taille dcompacte sur C:');
               {$Endif}
          End else
          Begin
               {$IfDef English}
               Write('Mask(s):            ');
               {$else}
               Write('Masque(s):          ');
               {$Endif}
               For i:=1 to NbMasques do Write(''+Justify(Mask[i],16)+'  ');
          End;
          Halt;
     End;
     if Stupid then Halt(1);
End;


{$F+} Procedure MyExitProc; {$F-}
Var c:String[1];
    s:String;
Begin
     LowVideo;
     if Redirige or not EcrireToutesA then
     Begin
          Write(CrtS,^M); ClrEol;
     End;
     if Redirige then WriteLn(CrtS);
     if AffTotaux then
       if ArchivesSeules then Begin
         if NbArcFound>0 then c:='s' else c:='';
         {$IfDef English}
         WriteLn(NbArcFound:4,' archive'+c+' found.');
         {$Else}
         WriteLn(NbArcFound:4,' archive'+c+' trouve'+c+'.');
         {$Endif}
       End else Begin
         if NumD>0 then
         Begin
              if NumD>1 then c:='s' else c:='';
              if TotDskR>0 then Begin Str(TotDskR div 1024,s); s:='('+s+' '+MotKo+')'; End
                           else s:='';
              {$IfDef English}
              WriteLn(NumD:4,' ',Justify('file'+c+' on disk',23),TotDsk:8,' bytes ',s);
              {$Else}
              WriteLn(NumD:4,' ',Justify('fichier'+c+' sur le disque',23),TotDsk:8,' oct ',s);
              {$Endif}
         End;
         if NumA>0 then
         Begin
              if NumA>1 then c:='s' else c:='';
              if TotArcR>0 then Begin Str(TotArcR div 1024,s); s:=Justify('('+s+' '+motKo+')',10); End
                           else s:='          ';
              {$IfDef English}
              Write(NumA:4,' ',Justify('archived file'+c,23),TotArc:8,' bytes ',s,'    ');
              {$Else}
              Write(NumA:4,' ',Justify('fichier'+c+' archiv'+c,23),TotArc:8,' oct ',s,'    ');
              {$endif}
              if NbArch=1 then c:='' else c:='s';
              Write(NbArch,' archive'+c);
              WriteLn;
         End;
       End;
     if not ArchivesSeules then if not ((NumD<>0) xor (NumA<>0)) then
     Begin
          if TotalFound=0 then {$IfDef English} WriteLn('No file found.') else
                               {$Else} WriteLn('Aucun fichier trouv.') else {$Endif}
          Begin
               if TotalFound=1 then c:='' else c:='s';
               {$IfDef English}
               Write(TotalFound:4,' ',Justify('file'+c+' found'+c,23));
               {$Else}
               Write(TotalFound:4,' ',Justify('fichier'+c+' trouv'+c,23));
               {$Endif}
               if AffTotaux then
               Begin
                    if TotDskR+TotArcR>0
                       then Begin Str((TotDskR+TotArcR) div 1024,s); s:='('+s+' '+motKo+')'; End
                       else s:='';
                    {$IfDef English}
                    WriteLn(TotDsk+TotArc:8,' bytes ',s);
                    {$Else}
                    WriteLn(TotDsk+TotArc:8,' oct ',s);
                    {$Endif}
               End;
               WriteLn;
          End;
     End;
     ChDir(RepOriginal); Close(CrtS); Dispose(Fichiers);
     ExitProc:=KeepExit;
     if PatcherIci='' then; {juste pour tre dans le code de l'executable}
End;


Var Lec:Byte;
Begin
     {$IfDef English}
     WriteLn('Archive Finder   1.25   Jc Boggio/France   Mar, 2 93   Public domain');
     {$Else}
     WriteLn('Archive Finder   1.25   Jc Boggio   2-Mar-93   Domaine public');
     {$Endif}
     Redirige:=Redir;
     LisParametres; WriteLn; Assign(OutPut,''); ReWrite(OutPut);
     AssignCrt(CrtS); ReWrite(CrtS); TotalFound:=0; New(Fichiers);
     TotDsk:=0; TotDskR:=0; TotArc:=0; TotArcR:=0; NumA:=0; NumD:=0; NbArcFound:=0;
     NbArch:=0; GetDir(0,RepOriginal); KeepExit:=ExitProc; ExitProc:=@MyExitProc;
     if Pos(':',DefRep)<>0 then Cherche(DefRep)
                           else For Lec:=1 to Length(Lecteurs) do
                                Begin
                                     Pile:=0; {Normalement inutile}
                                     Cherche(Lecteurs[Lec]+':'+DefRep);
                                End;
End.


- 1.00  Premire version.
        Scrute les .LZH, les .ARJ, les .ZIP et les .ARC
- 1.01  Ajout des paramtres /S et /C
- 1.02  Ajout des fichiers .PAK
        Acclration de la recherche (50% plus rapide en moyenne, trs efficace
        sur les grosses archives (utilisation du Seek, merci Etche)).
        Gre la redirection.
        Ajout du /E /M /A et /N
        Amlioration de la recherche par dfaut
- 1.03  Suppression du bug lorsqu'aucun paramtre n'est spcifi
        Possibilit de remplacer le '/' par un '-'
        Ajout du /G /P et /R
        Modification du /S
- 1.04  Ajout des .ZOO (Merci Mr Burns (l'auteur de PibCat))
        Ajout du /W (merci Mr Buerg (l'auteur de FV entre autres))
- 1.05  Correction de l'affichage lors d'un /G seul (sans /P)
- 1.06  Ajout de totaux sur les archives
        Ajout de quelques ProcessKey pour mieux grer <Espace>, <Ctrl-C> et <Esc>
        Amlioration du /C : si un rpertoire par dfaut est prcis on
                             remplace le /C par un /S
        Amlioration du /M : si le masque d'archives est prcd d'un chemin,
                             celui-ci est plac dans le /R
        Suppression des '\' final dans les noms de rpertoire (c'est plus beau)
        possibilit de regrouper les paramtres (af -gp par exemple)
        possibilit de spcifier la valeur + ou - d'un paramtre (af -G+S-)
        Ajout de certains .SIT (trs incertain !)
- 1.07  Modification mineure du /M pour raison de commodit
        Ajout du /T et /F
- 1.08  Ajout du /U et du /#
        Modification du /E pour inclure l'criture des rpertoires
        Rparation du /R si rien n'est prcis.
        Multiples modifications dans l'affichage en particulier pour la
        gestion de la redirection.
- 1.09  Acclration des recherches de 28%. Quand on voit la vitesse de
        "Supersonic Search Tools" on prend peur...
- 1.10  Acclration des recherches avec la recherche supersonique. 43% par
        rapport  la version 1.08
        Ajout du /B
- 1.11  La recherche supersonique ne pouvant chercher qu' partir du
        rpertoire \ et posant un problme avec le dos 4.01, elle est
        laisse de ct pour le moment.
        Remis en place l'usage de ProcessKey
- 1.12  Suppression dfinitive de la recherche supersonique.
        Suppression du /B
        Amlioration de la vitesse de 20%
- 1.13  Ajout de la recherche ultra rapide utilise par SST (l'ex rfrence)
        qui peut ne chercher que les rpertoires *.
        Ici, cette fonction n'est utile qu'en conjonction avec -g et -p
        (recherche globale, pas dans les archives). Mais elle est TRES utile.
        SST est dpass. Essayez AF -GP* *.ZZZ
        Ajout du /*
- 1.14  Ajout des masques tendus de 4DOS ! (AF *A*F*.*)
- 1.15  Ajout de la recherche sur la date et la taille
        Ajout du /D et /I
- 1.16  Correction du bug en cas de tentative d'accs  une archive ReadOnly
        {Fin de la doc}
- 1.17  Correction mineure pour l'affichage des archives seules >= 10Mo.
        Multi masques !!! (AF *.Zip *.doc *.pas ...)
        Possibilit de lancer : AF \dos\*.com -gp
        A ce stade, on ne peut plus comparer les performances avec les
        autres produits (Multi masques + masques tendus)
- 1.18  Compatibilit avec MsDos 5.0 : modification de "ClusterSize".
        Gre la nouvelle mthode de compression de PkZip "Extra". Bof...
- 1.19  Correction mineure pour l'affichage /Wide
        Ajout du /L
        Pile conomise pendant la recherche des fichiers du disque
        Ajout du /B (pas la recherche supersonique mais le "Bel affichage")
        Modifications diverses d'affichage des totaux.
        /F dtermine  prsent si il faut afficher les totaux.
        /G est dsormais par dfaut sur + !!!
        Une seule diffusion
- 1.20  Encore quelques corrections et large diffusion
- 1.21  Ajout des fichiers TPZ de Patrick TEIL (merci  lui)
        Amlioration de ProcessKey
        Lger changement de look pour le contenu des archives
        Amliorations de Check. Gains de vitesse.
        Ajout de l'option /) pour VOIR ce que l'on cherche  faire et
        trouver une erreur
- 1.22  Les fichiers .A00  .A99 sont considrs comme des archives ARJ
        La recherche de fichier dans une archive ne prend plus en compte
        le sous-rpertoire dans lequel se trouve le fichier (jusque l,
        pour trouver le fichier UTIL\FICHIER.EXT, AF FICHIER* ne
        fonctionnait pas. Il fallait faire AF *FICHIER*
        La recherche accepte dsormais les masques termins par un . utile si
        l'on cherche les fichiers ne portant pas d'extension.
- 1.23  Debug du -m qui acceptait mal les -mb:xxx
        Les options /L /M et /R sont correctement affiches par l'option -)
        Modifications du /a en combinaison avec un masque de fichiers et
        combinaison avec /f et /n.
        TRES UTILE notamment pour :
          AF -AN TEASER.COM >FIC
          For %a in (@FIC) do Arj d %a teaser.com

          Ce petit Alias/Batch pour 4Dos fait chercher  AF toutes les
          archives contenant le fichier TEASER.COM et range cette liste
          dans FIC. Il ne reste plus qu' dire  4Dos de lire ce fichier
          FIC et pour chaque nom d'archive de supprimer le fichier en question.

        Correction sur le -C qui dsormais fait un -L0 automatiquement

- 1.24  Cration de la version en langue anglaise (non diffuse)
- 1.25  Corrections diverses langue anglaise
        Meilleure gestion des "garbages"  la fin des .LZH
        Changement de nom de la mthode de compactage "Deflat" pour PkZip
        (anciennement "Extra compression")

Pseudo CAT sur 3614 Teaser et 3615 Legend
                              3614 192310084

        Je cherche les formats de tous les Headers des .SIT (les vieux et les
        nouveaux !) ainsi que des .CPT
        Si vous avez des ides d'options  rajouter, je suis ouvert,
        n'hsitez surtout pas !
