/* stat.c */

#include "dos.h"
#include "conio.h"
#include "string.h"
#include "stdio.h"

#define COM1 0x3F8        /* COM1 Base    */
#define COM2 0x2F8        /* COM2 Base    */
#define COM3 0x3E8        /* COM3 Base    */
#define COM4 0x2E8        /* COM4 Base    */
#define TOUCH 0x2D8       /* Pro-ED       */
#define LASER 0x2E0       /* Pro-ED       */

main (int argc, char **argv)
{
  void aerror(void);
  unsigned com,status;
  int onoff;
  static char com1[] = "03F8";
  static char com2[] = "02F8";
  static char com3[] = "03E8";
  static char com4[] = "02E8";
  static char coms1[] = "COM1";
  static char coms2[] = "COM2";
  static char coms3[] = "COM3";
  static char coms4[] = "COM4";
  char coms[5];
  char comss[6];

  if (argc < 2) {
    aerror();
    }

  if ( (strcmpi( *(argv+1),"com1") ) == 0 ) {
    com = COM1;
    strcpy(coms,com1);
    strcpy(comss,coms1);
    }
  else {
    if ( (strcmpi( *(argv+1),"com2") ) == 0 ) {
      com = COM2;
      strcpy(coms,com2);
      strcpy(comss,coms2);
    }
    else {
      if ( (strcmpi( *(argv+1),"com3") ) == 0 ) {
        com = COM3;
        strcpy(coms,com3);
        strcpy(comss,coms3);
        }
      else {
        if ( (strcmpi( *(argv+1),"com4") ) == 0 ) {
          com = COM4;
          strcpy(coms,com4);
          strcpy(comss,coms4);
          }
        else {
          if ( (strcspn(argv[1],"Pp")) == 0 ) {
            if ( (strlen(argv[1]) > 2) & (strlen(argv[1]) < 6) ) {
              strcpy(comss,"PORT");
              strcpy(coms,argv[1]+1);
              sscanf (coms," %x",&com);
            }
            else {
              aerror();
            }
          }
          else {
            aerror();
          }
        }
      }
    }
  }

  if (argc > 3) {
    if ( (strcmpi( *(argv+3),"on") ) == 0 ) {
      onoff = 1;
    }
    else {
      if ( (strcmpi( *(argv+3),"off") ) == 0 ) {
        onoff = 0;
      }
      else {
        aerror();
      }
    }
    if ( (strcmpi( *(argv+2),"int") ) == 0 ) {
      inter(com,onoff);
    }
    else {
      if ( (strcmpi( *(argv+2),"dtr") ) == 0 ) {
        dtronoff(com,onoff);
      }
      else {
        if ( (strcmpi( *(argv+2),"rts") ) == 0 ) {
          rtsonoff(com,onoff);
        }
        else {
          aerror();
        }
      }
    }
  }
  else {
    if (argc == 3) aerror();
  }

  stat(com,coms,comss);
  exit(0);
}

/* Turn RTS ON or OFF at selected port */
rtsonoff(unsigned port, int onoff)
{
  unsigned status;

  if ( onoff == 1 ) {
    status = inp(port+4);
    status = status | 0x02;
    outp(port+4,status);
  }
  else {
    status = inp(port+4);
    status = status & 0xFD;
    outp(port+4,status);
  }
  return;
}

/* Turn DTR ON or OFF at selected port */
dtronoff(unsigned port, int onoff)
{
  unsigned status;

  if ( onoff == 1 ) {
    status = inp(port+4);
    status = status | 0x01;
    outp(port+4,status);
  }
  else {
    status = inp(port+4);
    status = status & 0xFE;
    outp(port+4,status);
  }
  return;
}

/* Turn interrupts ON or OFF at selected port */
inter(unsigned port, int onoff)
{
  unsigned status;

  if ( onoff == 1 ) {
    status = inp(port+4);
    status = status | 0x08;
    outp(port+4,status);
  }
  else {
    status = inp(port+4);
    status = status & 0xF7;
    outp(port+4,status);
  }
  return;
}

/* stat() */
/* print status of the 8250 MODEM Control register */
stat(unsigned port, char *coms, char *comss)
{
  int status,mstatus,mcontrol,testit;
  printf("  \n");
  status = inp(port + 2);
  status = status & 0xF8;
  if ( status ) {
    printf("Serial port on %s %s is not installed.\n",comss,coms);
    return;
  }
  mstatus = inp(port + 6);
  mcontrol = inp(port + 4);
  printf("MODEM status and MODEM control on %s %s is %X, %X.\n",
  comss,coms,mstatus,mcontrol);
  testit = mstatus & 0x80;
  if (testit)
    printf("  DCD is on,");
  else
    printf("  DCD is off,");

  testit = mstatus & 0x20;
  if (testit)
    printf("  DSR is on,");
  else
    printf("  DSR is off,");

  testit = mstatus & 0x10;
  if (testit)
    printf("  CTS is on,");
  else
    printf("  CTS is off,");

  testit = mcontrol & 1;
  if (testit)
    printf("  DTR is on,");
  else
    printf("  DTR is off,");

  testit = mcontrol & 2;
  if (testit)
    printf("  RTS is on.\n");
  else
    printf("  RTS is off.\n");

  testit = mcontrol & 8;
  if (testit)
    printf("  INTERRUPTS are enabled.\n");
  else
    printf("  INTERRUPTS are disabled.\n");
  return;
}

void aerror(void)
{
  printf(" \n");
  printf("You need at least 1 argument for the the STAT program.   \n");
  printf("  The first argument is the name of the COM port or the  \n");
  printf("  the base address of the COM port whose status you wish \n");
  printf("  to modify or display.  The second and third parameters \n");
  printf("  are optional and must appear together.  They specify   \n");
  printf("  the items which can be turned ON or OFF.               \n");
  printf("                                                         \n");
  printf("  SYNTAX:                                                \n");
  printf("                                                   \n");
  printf("         STAT  COM1    INT   ON                    \n");
  printf("               COM2    RTS   OFF                   \n");
  printf("               COM3    DTR                         \n");
  printf("               COM4                                  \n");
  printf("               PNNNN                                   \n");
  printf("                                                       \n");
  printf("  Where NNNN is a PORT address.                          \n");
  printf("                                                         \n");
  printf("  EXAMPLE --> C>stat com1 int on                         \n");
  printf("              C>stat p3f8 rts off <--- port address 3F8  \n");
  exit(0);
}
