;**************************************************************************
;*                                                                        *
;*    SUBS.INC  (C) 1992 DATASTORM TECHNOLOGIES, INC.                     *
;*                                                                        *
;* An ASPECT header file containing procedures facilitating user          *
;* login for the 2.0x scripted host mode.                                 *
;*                                                                        *
;**************************************************************************

;**************************************************************************
;* ͻ                                                                  *
;*  A.                           SETUP                                  *
;* ͼ                                                                  *
;**************************************************************************
proc setup

   $ifdef DEBUG                                 ; set some vars if debugging:
      set aspdebug on                           ;   Put offsets in error msgs
      set rangechk on                           ;         Do range checking
   $endif

   set keys on                                  ; we do all keys
   set rxdata on                                ; we do all incoming data
   set duplex full                              ; expect remote to echo
   set emulation ANSI                           ; set emulation to ansi

   set zmodem autodload off                     ; Don't autodownload on host
   set zmodem errdetect  crc32                  ; Use 32-bit CRC
   set zmodem recvcrash  protect                ; Don't let users overwrite
   set zmodem sendcrash  negotiate              ; Let user recover downloads
   set zmodem timestamp  off                    ; Stamp files w/system date/time
   set zmodem txmethod   streaming              ; Use fastest transmit method

   fetch host dldir hostdldir                   ; Get Download Directory
   fetch host uldir hostuldir                   ; Get Upload Directory
   fetch ASCII DN_TO ATimeout                   ; Get ASCII Timeout
   fetch cdinxfer hostcdxfer                    ; Monitor CD?
   fetch host autobaud hautobaud                ; Get autobaud detect
   fetch host systype systemtype                ; Get SystemType (OPEN|CLOSED)
   FilterCtrl = 1                               ; Filter incoming control chars

   odir = hostdldir                             ; Get original DL directory
   onam = "Default D/L Area"                    ; Set original DL Name
   hostdlnam = onam                             ; Set Default DL Name

endproc

proc mod_init
string temp

   statmsg "Configuring Host"
   fetch host connection contype                ; Fetch Connection Type
   if !connected && (contype == modem_con)
      set baud su_baudrate                      ; Set/Restore Baudrate
      endif                                     ; Check CD in case it's a
                                                ;   privileged user.
   set remotecmd off

   strfmt s0 "CD %s" st_dir                     ; Format string
   DOS s0 noclear                               ; Change to startup dir

   LCFlag = 0                                   ; Reset Lost Carrier Flag
   if contype == direct_con                     ; Check for direct connection
      return
      endif

   statmsg "Initializing Modem - Please Wait ..."

;********************************************************************
;* The following If CONNECTED test can be used to force the modem   *
;* to hang up, every time host is started.  It's commented out to   *
;* allow privileged users to abort host, then restart with a remote *
;* command.                                                         *
;********************************************************************
;  if connected                                 ; Online?
;     call hosthangup                           ; If so, hangup
;     endif

   if connected                                 ; Connected?
      return                                    ;   return, could be user
      endif                                     ;   starting w/ remote command

   transmit "AT^M"                              ;    to set modem speed
   waitfor "OK" 3                               ;    waitfor the "OK"

   fetch modem autoanson temp                   ; Get  Autoanswer String
   transmit temp                                ; Send Autoanswer String
   waitfor "OK" 3                               ;    waitfor the "OK"

endproc

;**************************************************************************
;* ͻ                                                                  *
;*  B.                      WAITFORCALL                                 *
;* ͼ                                                                  *
;**************************************************************************
proc waitforcall

string  c_message                               ; connect message
integer c_speed                                 ; connection speed
integer anykey                                  ; Keystrokes
integer normal,inverse,hilite                   ; Color variables
string  start                                   ; Start Blanker Time
long    ltemp                                   ; Long Temporary Variable

    fetch host message hostwelcom               ; Fetch Host Welcome Message
    fetch termnorm cnorm                        ; Fetch Normal Color Attribute
    time start 0                                ; Get Current Time
    llogin=0                                    ; Set local login off
                                                ;   in case previous login
                                                ;   was local

    setvattr &normal  black  green noblink      ;*
    setvattr &inverse yellow green noblink      ;** Define colors
    setvattr &hilite  white  green noblink      ;*

next:

    clear cnorm                                 ; Clear with normal attributes
    box 4 17 19 67 0                            ; Shadow Box
    box 3 15 18 65 normal                       ; Info Box

    fatsay 3  29 normal "] Scripted Host - %s [" version ;* Information
    atsay 18 29 normal "] Connect Type -        ["       ;*   bars

    atsay 17 17 normal " Log:"
    if log_it                                   ;*
      atsay 17 23 inverse "ON  "                ;** If Log active,
      else                                      ;**    display active
      atsay 17 23 inverse "OFF "                ;*
      endif

    atsay 17 33 hilite "F2"
    atsay 17 36 normal    "- Local Login"

    if contype == Modem_Con                     ;*
      atsay 18 46 normal "Modem"                ;** Display connection
     else                                       ;**   type, from setup
      atsay 18 46 normal "Direct"               ;*
      endif

    box 4 28 6 54 normal
    atsay 5  30 hilite "LAST CALLER INFORMATION";*
    atsay 7  20 normal "Name:"                  ;**
    atsay 8  20 normal "Baud:"                  ;***
    atsay 9  19 normal "Level:"                 ;****
    atsay 10 17 normal "Elapsed:"               ;*****
    atsay 11 18 normal "Online:"                ;****
    atsay 12 17 normal "Offline:"               ;***     Display Title, Options
    atsay 14 17 normal "Current:"               ;**        and Constants
    atsay 16 17 normal "Page:"                  ;*
    atsay 17 17 normal " Log:"

    atsay 16 17 hilite "P"                      ;*** Highlight Option Keys

    if log_it                                   ;*
      atsay 17 23 inverse "ON  "                ;** If Log active,
      else                                      ;**    display active
      atsay 17 23 inverse "OFF "                ;*
      endif

    if pager                                    ;*
      atsay 16 23 inverse "ON "                 ;** If Pager active,
      else                                      ;**    display active
      atsay 16 23 inverse "OFF"                 ;*
      endif

    if H_Level > -1                             ; H_Level < 0 No Last Caller
      atsay 7  26 inverse H_Name                       ;*
      fatsay 8  26 inverse "%ld" H_Baud                ;**
      fatsay 9  26 inverse "%d " H_Level               ;***
      call elaps with &H_Elapsed H_Online H_Offline    ;**** Last call info
      atsay 10 25 inverse H_Elapsed                    ;***
      atsay 11 26 inverse H_Online                     ;**
      atsay 12 26 inverse H_Offline                    ;*
    else
      atsay 7  26 inverse "Not Available             " ;*
      atsay 8  26 inverse "      "                     ;**
      atsay 9  26 inverse " "                          ;*** No last caller,
      atsay 10 26 inverse "             "              ;*** display blank fields
      atsay 11 26 inverse "             "              ;**
      atsay 12 26 inverse "             "              ;*
      endif

    set keys on                                 ;  Let script handle keystrokes
    set rxdata on                               ;     and incoming data

    if contype == Modem_Con                     ; If connection is modem

        if connected                            ; If CD already high, presume
                                                ;    connection has already
                                                ;    been established &
                                                ;    proceed to login.
           fetch baudrate ltemp                 ; Get autobaud setting
           goto logon                           ; Jump to login
           endif
        rflush                                  ; Flush receive buffer
        while 1                                 ; Loop forever
          strfmt s0 "%s  %s     " $time0 $date  ; format time/date string
          atsay 14 26 inverse s0                ; display time/date string
                                                ; Calculate elapsed time

          call elapsed with &blanktime start $time0
          if ((blanktime > blanktimeout) && !connected) && blanker
            call blankit with &start            ; blank screen if needed
            endif

          if hitkey                             ; Look for keyhit
            keyget anykey                       ; Get key
            call proc_key with &anykey inverse  ; Process key, return value in
                                                ;    anykey, if needed
            if failure                          ; Problem?
               llogin = 0                       ; Reset Local Login
               call flush_it                    ; Flush buffers
               goto next                        ;   reset for next caller
               endif

            if anykey == 0
               loopwhile
               endif

            if anykey == -999                   ; Look for logon,set by proc_key
               atsay 0 1 inverse "Local Login"  ; Display local login
               goto logon                       ; Goto Logon
               else
               anykey = 0                       ; Reset anykey
               endif

            if anykey == -111                   ; Look for start reset
               start = $time0                   ; Reset Start timer
               anykey = 0                       ; Reset anykey
               endif
            endif

          ;********************************************************************
          ;* This is the AUTOBAUD function.  Get the MODEM CONNECT message,   *
          ;* ATOI will strip out Alpha characters and leave a number. Use     *
          ;* this integer for the SWITCH to set the actural baudrate.         *
          ;*                                                                  *
          ;* Note: You may have to change the "CONNECT" message to reflect    *
          ;* the messages returned by your particular modem.  You may also    *
          ;* have to change the timeout on the WAITFOR command line.          *
          ;********************************************************************
          if comdata                            ; If data at port
             waitfor "ONNECT" 10                ;    waitfor MODEM connect msg
                                                ;    wait up to 10 seconds.
                                                ; We drop the first char
                                                ;    in the waitfor string
                                                ;    because we lose 1 char
                                                ;    with to the comdata.
             if !waitfor                        ; If waitfor timedout
                rflush                          ;    flush receive buffer
                goto next                       ;    reloop.
                endif

             if !HAutobaud
                exitwhile
                endif

             rget c_message 40                  ; get speed from connect msg
             atoi c_message c_speed             ; convert message into integer
             if HAUTOBAUD                       ; if MODEM AUTOBAUD is ON then
                                                ;    set new baudrate.
               switch c_speed                   ; Use C_Speed to set baudrate

                  case 0
                    set baud 300
                    endcase
                  case 1200
                    set baud 1200
                    endcase
                  case 2400
                    set baud 2400
                    endcase
                  case 4800
                    set baud 4800
                    endcase
                  case 9600
                    set baud 9600
                    endcase
                  case 19200
                    set baud 19200
                    endcase
               endswitch
               endif                            ; End of AUTOBAUD section
             exitwhile
          endif
        endwhile
      else                                      ; Direct Connect
        while 1
          set cdinxfer no                       ; Don't worry about CD during
                                                ;   a file transfer, because
                                                ;   a lot of direct connections
                                                ;   don't support CD
          strfmt s0 "%s  %s     " $time0 $date  ; Format date time string
          atsay 14 26 inverse s0                ; Display

          call elapsed with &blanktime start $time0 ; Calculate elapsed time
          if (blanktime > blanktimeout) && blanker  ; If blanker true
            call blankit with &start                ; Blank screen
            endif

          comgetc n0                            ; Look at port, ComGetC will
                                                ;    return the value of
                                                ;    character at port, if no
                                                ;    character exists, it
                                                ;    returns a -1.
          if n0 >= 0                            ; if return is => 0
            exitwhile                           ;    exit loop
            endif

          if hitkey
            keyget anykey                       ; Get key
            call proc_key with &anykey inverse  ; Process key

            if failure                          ; Problem?
               llogin = 0                       ; Reset Local Login
               goto next                        ; Reset for next caller
               endif

            if anykey == 0
               loopwhile
               endif

            if anykey == -999                   ; Look for logon,set by proc_key
               return                           ; Return
               else
               anykey = 0                       ; Reset anykey
               endif

            if anykey == -111                   ; Look for start timer reset
               start = $time0                   ; Reset Start timer
               anykey = 0                       ; Reset anykey
               endif
            endif
        endwhile
    endif

logon:

    pause 1                                     ; Give everything time to
                                                ;    "sync" up

    if ansi_on && (llogin == 0)                 ; If ANSI sequences on &
                                                ;    not a local login
      transmit clrstr                           ;    transmit clear screen
      endif

    clear
    RFlush
    call DisplayFile with HostOpenFile 23       ; If Opening exists,display

    fetch baudrate H_Baud                       ; Get current baudrate
    if contype == Modem_Con                     ; If modem connection
      strfmt msg "Remote User Online - %-5li`n" H_Baud
      message msg
      if ! hautobaud                            ; If autobaud is off
        fetch baudrate ltemp                    ;   get current baud & display
        message "Autobaud detect disabled"
        message "Port Settings Not Changed"
        endif
    else                                        ; If direct connection
      strfmt msg "Remote User Online - Direct Connect"
      message msg
      endif

    if ansi_on && (llogin == 0)                 ; If ANSI sequences on &
                                                ;    not a local login
      transmit clrstr                           ;    transmit clear screen
      endif

    call DisplayFile with HostNWSFile 23; If News file exists, display

    if ansi_on && (llogin == 0)                 ; If ANSI sequences on &
                                                ;    not a local login
      transmit clrstr                           ;    transmit clear screen
      endif

    message $null
    call HostPutS with "`r`n"
    call HostPutS with HOSTWELCOM
    call setsuccess
endproc

;**************************************************************************
;*                                                                        *
;*  Function:  Proc_Key                                                   *
;*   Purpose:  Interpret keystroke at main screen                         *
;*     Input:  Interger - Key scan code                                   *
;*    return:  Set key to -999 for local login, else no return            *
;*     Notes:                                                             *
;*                                                                        *
;**************************************************************************

proc proc_key
   intparm keystroke,inverse                    ; scancode,inverse video attr

    call setsuccess                             ; Want success true
    switch keystroke                            ; Use keystroke for switch
                                                ; NOTE: The following case
                                                ;       statements all use
                                                ;       Keystroke as the test
                                                ;       variable.

        case 0x1B                               ; "ESC"
          call exithost with 2                  ; Call Exithost
          endcase

        case 0x3C00                             ; "F2"
          llogin = 1                            ; Set local login to true
          time ontime 0                         ; Set ontime
          clear cnorm
          curon
          atsay 1 1 cnorm "Login as Sysop (Y/n)? "
          locate 1 23
          keyget n0                             ; Get key
          clear
          if (n0==110) || (n0==78)              ; Is it "N" or "n"
             call HostPutS with HOSTWELCOM
             call getuser                       ; login normally
             if failure                         ; if failed login
                H_Level   = -1                  ;    set no user
                call setfailure                 ; set failure flag
                llogin = 0                      ; Reset Local Login on Failure
                return                          ; return
                endif
             else
             access = "2"                       ; Give priveleged user level
             first = "Sysop"                    ; First Name "Sysop"
             last  = ""                         ; last null
             endif

          name  = first                         ; *
          strcat name " "                       ; ** Build full name
          strcat name last                      ; *

          H_Name = Name                         ; *
          strcat H_Name " - Local Login"        ; ** Set Waiting screen info
          atoi access H_Level                   ; **
          time h_online 0                       ; *

          strfmt s0 "%s - Logged On Locally with Level %s" Name Access
          call HostLog with "" s0

          keystroke = -999                      ; Jump to logon
          message "`n"
          endcase

        case 0x0070                             ; "P"
        case 0x0050
          if !pager
              pager = 1                         ; Set active
              atsay 16 23 inverse "ON "
           else
              pager = 0                         ; Set inactive
              atsay 16 23 inverse "OFF"
              endif
           keystroke = 0                        ; reset key
           endcase

        default                                 ;*
           sound 300 5                          ;**
           sound 750 15                         ;*** If unrecognized keyhit
           sound 400 10                         ;***     sound beeps &
           keystroke = 0                        ;**      reset keystroke
           endcase                              ;*
        endswitch
endproc

;**************************************************************************
;*                                                                        *
;*  Function:  Non_Char                                                   *
;*   Purpose:  Strip all non alpha/numeric charaters (A-Z,a-z,0-9)        *
;*     Input:  String Variable                                            *
;*    return:  Stripped String Variable                                   *
;*     Notes:                                                             *
;*                                                                        *
;**************************************************************************
proc Non_Char
   strparm original                             ; Original string parm
   string  temp                                 ; Temp string variable
   integer len,npos                             ; Length, & Position integers

                                                ; Set accepted ranges
   integer range1low = 65, range1high = 90      ; 65 = 'A', 90  = 'Z'
   integer range2low = 97, range2high = 122     ; 97 = 'a', 122 = 'z'
   integer range3low = 48, range3high = 57      ; 48 = '0', 57  = '9'

   strlen original len                          ; Get length of original
   npos = 0                                     ; Set string pointer 0
   while (npos < len) && (len>0)                ; while (pointer < length) &
                                                ;        (length > 0)
      strpeek original npos n9                  ; Look at first character

                                                ; If value is within the
                                                ;   acceptable ranges move on
                                                ;   to next character.
                                                ; Note: the backslash '\'
                                                ;       allows the command
                                                ;       to continue on to
                                                ;       the next line.
      if (((n9>=range1low)&&(n9<=range1high)) || \
          ((n9>=range2low)&&(n9<=range2high)) || \
          ((n9>=range3low)&&(n9<=range3high)) || \
            n9==32)
         inc npos                               ; Inc pointer
         loopwhile                              ; Loop to While
         endif
      substr temp original 0 npos               ; Set temp = to characters
                                                ;   upto invalid character
      inc npos                                  ; Inc pointer past invalid char
      substr original original npos len         ; Set Orig to all characters
                                                ;   past invalid character
      dec npos                                  ; Dec pointer, account for lost
                                                ;   character, the invalid one
      dec len                                   ; Dec length
      strcat temp original                      ; Concatenate temp & original
      original = temp                           ; Set original to temp
   endwhile
endproc

;**************************************************************************
;*                                                                        *
;*  Function:  GetUser                                                    *
;*   Purpose:  Wait for user to connect and login.                        *
;*     Input:  None                                                       *
;*    return:  Script aborts if ESC pressed.  Otherwise, the function     *
;*             won't return without a user.                            `  *
;*     Notes:                                                             *
;*                                                                        *
;**************************************************************************
proc GetUser
   while forever                                ; Loop forever
      if hitkey                                 ; Allow ESC key to exit loop
         call XKeyGet with &tempkey             ;   Get key if one is hit
      endif

      if (! connected) && (contype==MODEM_CON) && (llogin == 0)
                                                ; If connect type is modem
                                                ;  && not connect
                                                ;  && not a local login
         Call HostLog with padit "Lost Carrier`n"
         call SetFailure
         return
      endif

      call GetUserName                          ; Get the users name
      if success
         call GetUserPswd                       ; Get the users password
         if success
            call ParseUsrRec                    ; Find and parse user record
            if success                          ; If found and parsed
                 time ontime 0                  ; Set ontime
                 H_Online = Ontime              ; Set H_Online to ontime
                 call SetSuccess
                 return
            else
                 call SetFailure                ;Error getting user record
                 call HostPutS with "`n`r`n`rInvalid Login Attempt!`r`n"
                 return
            endif
         else
            call SetFailure                     ;Error getting password
            call HostPutS with "`n`r`n`rInvalid Login Attempt!`r`n"
            return
         endif
      else                                      ;Error getting user name
        call HostPutS with "`n`r`n`rInvalid Login Attempt!`r`n"
        call SetFailure
          return
      endif
   endwhile
endproc

;**************************************************************************
;*                                                                        *
;*  Function:  GetUserName                                                *
;*   Purpose:  Input a user name                                          *
;*     Input:  None                                                       *
;*    return:  success if user name obtained                              *
;*             FAILURE if user not obtained                               *
;*     Notes:                                                             *
;*                                                                        *
;**************************************************************************
proc GetUserName
integer i, len, tries

   tries = 0                                    ; Init tries to 0
   first = $null
   last  = $null

   if (! connected) && (contype==MODEM_CON) && (llogin == 0)
                                                ; If connect type is modem
                                                ;  && not connect
                                                ;  && not a local login
      Call HostLog with padit "Lost Carrier`n"
      call SetFailure                           ;    set failure
      return                                    ;    return
   endif

   rflush                                       ; Flush input buffer
   while tries < 3                              ; while tries < 3
      tries++                                   ; inc tries
      call HostPutS with "`r`n`r`nFirst name: " ; prompt for first name
      call HostGetS with &first NAMEMAX DISP    ; Get first (and optionally
                                                ;                 last name)
      if failure                                ; return FAILURE if CD drops
         exitwhile
         endif

      strlen first len                          ; len = length of first name
      if len < 1                                ; If length is < 1
         loopwhile                              ;    go to top of loop
         endif

      find first " " i                          ; Is there a last name? (SPACE)
      if not found
         find first ";" i                       ; (Look for SEMICOLON
                                                ;            if no SPACE)
         endif

      if found                                  ; YES, there is a last name:
         strpoke first i 0                      ;   terminate the first name
         i++                                    ;   i -> 1st character in last name
         substr last first i 80                 ;    ulast is last name
      else
         call HostPutS with "`r`n Last name: "
         call HostGetS with &last NAMEMAX DISP  ; Get last name
         if failure                         ; return FAILURE if CD drops
            exitwhile
            endif

         strlen last len                        ; Get length of last name
         if len < 1                             ; if length < 1
            loopwhile                           ;    loop to while
            endif
         endif

      call non_char with &first                 ; Strip non_alpha/numeric chars
      call non_char with &last                  ;    from first & last names
      strupr first                              ; Convert to uppercase
      strupr last                               ; Convert to uppercase
      name = first                              ; Name = first
      strcat name " "                           ; Add space
      strcat name last                          ; Append last

      call HostPutS with "`r`n  "
      call HostPutS with name
      call HostPutS with "`r`nIs this correct (Y/N)? "
      call HostGetYN                            ; Confirm name
      if success
         return
      else                                      ; if user says NO
         tries--                                ;   don't count it as a try
      endif
   endwhile                                     ; Loop to while, if tries < 3
   call HostHangup                              ; Hangup
   call SetFailure                              ; Set Failure
endproc

;**************************************************************************
;*                                                                        *
;*  Function:  GetUserPswd                                                *
;*                                                                        *
;*   Purpose:  Input a user password                                      *
;*     Input:  None                                                       *
;*    return:  success if user password obtained                          *
;*             FAILURE if password not obtained                           *
;*     Notes:                                                             *
;*                                                                        *
;**************************************************************************
proc GetUserPswd
integer i, tries

   tries = 0                                    ; Init tries to 0
   call HostPutS with "`r`n"
   while tries < 3                              ; Loop while tries < 3

      if (! connected) && (contype==MODEM_CON) && (llogin == 0)
                                                ; If connect type is modem
                                                ;  && not connect
                                                ;  && not a local login
        Call HostLog with padit "Lost Carrier`n"
        call SetFailure                         ;
        return                                  ;
      endif

      call HostPutS with "`r`nPassword: "       ; Prompt for password
      strset password 0 79                      ; Set Password to null
      call HostGetS with &password PSWDMAX HIDE ; Get password
      call Non_Char with &password              ; Strip non alpha characters

      if expose                                 ; if expose is true
        message $null                           ; drop a line
        strfmt s0 "          %s" password       ; format output
        message s0                              ; display password locally
        endif

      if failure                            ; Problem getting password
         exitwhile                              ;    return
      endif

      strlen password i                         ; Get length of password
      if i > 0                                  ; If length > 0
         strupr password                        ;   convert to uppercase
         call SetSuccess                        ;   set success
         return                                 ;   return
      endif
      tries++                                   ; Inc tries
   endwhile                                     ; Loop while, until tries > 3
   call HostHangup                              ; hangup
   call SetFailure                              ; set failure
endproc

;**************************************************************************
;*                                                                        *
;*  Function:  HostGetS                                                   *
;*   Purpose:  Input a character string from the port or local keyboard   *
;*     Input:  string parameter for return value                          *
;*    return:  If success, string variable contains the string            *
;*             FAILURE if connection lost                                 *
;*                                                                        *
;**************************************************************************
proc HostGetS
strparm s
intparm max, dodisp
integer i
string response

   s = $null                                    ; Clear s
   i = 0                                        ; i = 0
   rflush
   while forever                                ; loop forever
      call HostGetC with &response              ; get char, store in response
      if failure                                ; problem?
         call setfailure                        ;   set failure
         exitwhile                              ;   exit the loop
      endif
      switch response                           ; switch on response
         case "`r"                              ; Carriage Return?
            call SetSuccess                     ;   set success
            exitwhile                           ;   exit the loop
            endcase
         case "`b"                              ; Backspace ?
            if i != 0                           ; if i not equal to 0
               call HostPutS with "`b `b"       ;   clear char
               i--                              ;   dec i
               strpoke s i 0                    ;   poke a null into s
            endif
            endcase
         case " "                               ; This SPACE case must immed-
            if i == 0                           ; iately precede the default so
               loopwhile                        ; it will fall through
            endif
         default                                ; If not matched above
            if i < max                          ; if i < max
               if dodisp                        ;   if dodisp
                  call HostPutS with response   ;     send it to hostputs
               else                             ;   if not dodisp
                  call HostPutS with "*"        ;     send "*" to mask it
               endif
               strcat s response                ; add response to s
               i++                              ; inc i
            endif
            endcase
      endswitch
   endwhile
endproc

;**************************************************************************
;*                                                                        *
;*  Function:  HostGetYN                                                  *
;*   Purpose:  Input a "Y" or a "N" response                              *
;*     Input:  None                                                       *
;*    return:  success if Yes                                             *
;*             FAILURE if No or connection lost                           *
;*                                                                        *
;**************************************************************************
proc HostGetYN
string response

   while forever                                ; Loop forever
      call HostGetC with &response              ; Get Character
      if failure                                ; Problem?
         return                                 ;  return
      endif
      strupr response                           ; Convert to uppercase
      switch response                           ; Switch
         case "`r"                              ; Carriage Return
         case "Y"                               ; is it a "Y"
            call HostPutS with response         ; Display Char
            call SetSuccess                     ;    setsuccess
            exitwhile                           ;    exit loop
            endcase
         case "N"                               ; is it a "N"
            call HostPutS with response         ; Display Char
            call SetFailure                     ;    setfailure
            exitwhile                           ;    exit
            endcase
      endswitch
   endwhile
endproc

;**************************************************************************
;*                                                                        *
;*  Function:  HostGetC                                                   *
;*   Purpose:  Input a character from the port or local keyboard          *
;*     Input:  string parameter for return value                          *
;*    return:  If success, string variable contains the character.        *
;*             FAILURE is returned if the connection is lost.             *
;*                                                                        *
;*     Notes:                                                             *
;*                                                                        *
;**************************************************************************
proc HostGetC
strparm c
integer i = -1 , tout
string stime

   stime = $time0
   while i < 0
      call elapsed with &tout stime $time0

      if tout == WTimeOut                       ; If elapsed = Warning Timeout
         call hostputs with "`r`n`a`aInactivity Warning, you must respond!"
         pause 1                                ; Pause for 1 sec, allow clock
                                                ;    to reach next second
         endif

      if tout == Htimeout                       ; If elapsed = Hangup Timeout
         call hostputs with "`r`n`a`a`aInactivity Timeout, disconnecting...        "
         call setfailure                        ;    Timeout
         return                                 ;    return
         endif

      if hitkey                                 ; If a key is pressed
         call XKeyGet with &i                   ;    get the key
      endif
      if comdata && (llogin == 0)               ; If data available at port
         comgetc i                              ;    get the next character
      endif
      if (! connected) && (contype==MODEM_CON) && (llogin == 0)
                                                ; If connect type is modem
                                                ;  && not connect
                                                ;  && not a local login
         call HostLog with padit "Lost Carrier`n"
         call SetFailure                        ;    set error return code
         return                                 ;    and return to caller
      endif

      if filterctrl && ((i>-1) && (i<32))       ; Do we filter control chars?
                                                ;  and is it a control char
         if (i!=8) && (i!=13)                   ;   Yes? Let Backspace (8),
                                                ;    and Enter (13) thru
            loopwhile                           ;        Yes? Get next char
            endif
         endif
   endwhile

   key2ascii i c                                ; Convert scancode to ascii
   call SetSuccess
endproc

;**************************************************************************
;*                                                                        *
;*  Function:  HostPutS                                                   *
;*   Purpose:  Output a string to the port and the local screen           *
;*     Input:  string to output                                           *
;*    return:  None                                                       *
;*                                                                        *
;**************************************************************************
proc HostPutS
strparm s
integer c,idx

   if llogin == 0
     transmit s                                 ; Transmit to user
     endif
   idx = 0                                      ; Set idx to 0
   strpeek s idx c                              ; Look at first character
   while c > 0                                  ; if it's not a null
      writec c                                  ;   write character to screen
      idx++                                     ;   inc idx
      strpeek s idx c                           ;   look at next character
      endwhile                                  ; loop while
endproc

;**************************************************************************
;*  Function:  ParseUsrRec                                                *
;*   Purpose:  Lookup user in .USR file and parse record into globals     *
;*     Input:  name is the name of the user to lookup                     *
;*    return:  success if user found and parsed.                          *
;*             FAILURE if user not found or error parsing record.         *
;*     Notes:  These variables are initialized:                           *
;*                access    - User's access level ("0", "1", or "2")      *
;*                comment   - User's comment field                        *
;*                first     - User's first name                           *
;*                last      - User's last name                            *
;*                name      - User's full name (first and last)           *
;*                password  - User's password                             *
;*                record   - Raw record (terminated with a line feed)     *
;*             PCPLUS.USR record:                                         *      *
;*                      lastname;firstname;password;n;comment.......      *
;*                      (n is the access level {'0','1',or '2'})          *
;**************************************************************************

proc ParseUsrRec
integer i,atts
string tmp, tmp2, vpass

   atts = 0

Next_Try:

   find name " " i                              ; i = index of blank name separator
   strcpy first name i                          ; copy first name
   i++                                          ; i = index of last name
   substr last name i 79                        ; extract last name

   strset H_Name 0 79                           ; Clear H_name
   H_Name = first                               ; H_Name = First
   strcat H_Name " "                            ; Add space
   strcat H_Name Last                           ; Append Last name

   strfmt tmp "%s;%s" last first                ;'tmp' is what we're looking for
   strfmt tmp2 "%s;%s;%s" last first password   ;'tmp2' is new record
   strlen tmp i                                 ; i = length of name part
   fopen 1 HOSTUSRFILE "at+"                    ; Try to open user file
   if success                                   ; If opened
      while not EOF 1                           ;    loop until end of file
         fgets 1 record                         ;       Get record
         strupr record                          ;       Convert record uppercase
         strcmp record tmp i                    ;       Scan record for user
         if success                             ;       If this is our guy,

            n2=i+1                              ; Set n2 to 1st letter of password
            inc i                               ; Set I (index) 1st of pword
            n3= 0                               ; Set n3 (end of password) to 0
            n1= 0                               ; Null Char Check
            while (n1 != 59) && (n1 != 32)      ; Check for `!` or space
              i++                               ; Inc Index
              n3++                              ; Inc End of Pword
              strpeek record i n1               ; Look for at char
              endwhile
            substr vpass record n2 n3           ; Extract Password

            strlen tmp2 i

            strcmp vpass password
            if success
                call CopySFld with &password record &i FLD_SEP  ; Copy password
                call CopySFld with &access record &i FLD_SEP    ; Copy access level
                atoi Access H_Level
                if H_Level == 2
                  set remotecmd on              ; Set Remote Commands on
                  endif
                call CopySFld with &remarks record &i FLD_SEP    ; Copy comment
                call SetSuccess                 ; set return code to TRUE
                return                          ; exit
            else
                call HostPutS with "`n`rPassword incorrect."
                atts++
                if atts > 2                     ; Give 3 tries at Password
                  H_Level= -1
                  call hostputs with "`n`n`rExcessive Attempts`n`r"
                  call hostputs with "Logging Off!`r`n`a`a`a`a`r`n"
                  call HostHangup               ; Screwed up, hangup on them
                  call SetFailure               ; Set failure
                  return                        ; Return
                  endif
                call GetUserPswd                ; Get his password
                goto Next_Try                   ; Try again
            endif
         endif
      endwhile
      fclose 1                                  ; Close user file
      if SYSTEMTYPE==0                          ; if it's a closed system
          call HostPutS with "`n`rSorry, this is a closed system.`n`r"
          call HostHangup                       ; Hangup
          call SetFailure                       ; Set failure
          return
      endif
      call AddUser                              ; Add new user
      return
   else
      message "Error opening user file."
   endif
   call SetFailure
endproc

;**************************************************************************
;*                                                                        *
;*  Function:  CopySFld                                                   *
;*   Purpose:  Copy a string field (SFLD) from any position within        *
;*             the source string, to the destination string.  Also,       *
;*             increment the index by the length of the field copied.     *
;*     Input:  (&destination,source,&index,field_separator)               *
;*    return:  destination and int are updated.                           *
;*     Notes:  Terminates when a field_separator or line feed is          *
;*             encountered. If neither is encountered, the rest of the    *
;*             field is copied.                                           *
;*                                                                        *
;**************************************************************************
proc CopySFld
strparm dst
strparm src
intparm index
intparm fldsep
integer newidx
string  endstr,tmp

   substr endstr src index 79                   ; copy end of string / local var
   key2ascii fldsep tmp                         ; tmp = field separator string
   find endstr tmp newidx                       ; see if separator is in string
   if not found                                 ; If separator not found:
      find endstr "\n" newidx                   ;    is a line feed in string?
      if not found                              ;    If not:
          strlen endstr newidx                  ;       use the whole string
      endif
   endif
   strcpy dst endstr newidx                     ; copy field
   index = index + newidx + 1                   ; set caller's index
endproc

;**************************************************************************
;*                                                                        *
;*  Function:  HostHangup                                                 *
;*   Purpose:  hangup the MODEM (try several times)                       *
;*    return:  Nothing                                                    *
;*     Notes:                                                             *
;*                                                                        *
;**************************************************************************
proc HostHangup
integer hanguptries=3

      if (! connected) && (contype==MODEM_CON)
                                                ; If connect type is modem
                                                ;  && not connected
      call hostputs with "`r`n`r`n`r`n"         ; Clear host lines
      return                                    ; Return
   endif
   while hanguptries--                          ; While Hangup tries > 0,
                                                ;   & decrement on every loop
      pause 1                                   ; pause 1
      hangup                                    ; Hangup
      if ! connected                            ; If not connected
         exitwhile                              ;    exit while loop
      endif
   endwhile
   if connected                                 ; If still connected after
                                                ;    all of the above, warn
                                                ;    sysop.
      call HostPutS with "`r`n`r`nERROR: Unable to hangup.`r`n"
   endif
endproc

;**************************************************************************
;*                                                                        *
;*        Function:  BuildDFile                                           *
;*         Purpose:  Add data directory to start of data files            *
;*           Input:  DataFileString                                       *
;*          return:  DDir + DataFileString                                *
;*                                                                        *
;**************************************************************************

proc BuildDFile
   strparm dfile
   string  temp

   temp = ddir                                  ; Temp = path to data files

   strlen temp n9                               ; Get length of temp
   dec n9                                       ; Dec by 1 (string index
                                                ;           starts at 0)
   strpeek temp n9 n8                           ; Check last character
   if !(n8 == 92)                               ; If no `\`
     strcat temp "\"                            ; Add it
     endif

   strcat temp dfile                            ; Add backslash to temp
   dfile = temp                                 ; Dfile = temp
endproc

;**************************************************************************
;*                                                                        *
;*        Function:  SetFailure                                           *
;*         Purpose:  set FAILURE to TRUE (same as success not TRUE)       *
;*           Input:  None                                                 *
;*          return:  None                                                 *
;*                                                                        *
;**************************************************************************
proc SetFailure
   strcmp "X" ""                                ; Sets failure flag true
endproc

;**************************************************************************
;*                                                                        *
;*        Function:  SetSuccess                                           *
;*         Purpose:  set success to TRUE (same as FAILURE not TRUE)       *
;*           Input:  None                                                 *
;*          return:  None                                                 *
;*                                                                        *
;**************************************************************************

proc SetSuccess
   strcmp "" ""                                 ; Sets success flag true
endproc

;**************************************************************************
;*                                                                        *
;*        Function:  XKeyGet                                              *
;*         Purpose:  Pause until a key is pressed and exit script if ESC  *
;*           Input:  None                                                 *
;*          return:  None                                                 *
;*                                                                        *
;**************************************************************************
proc XKeyGet
intparm key
   keyget key
   if (key==27)                                 ; Escape key hit
      call exithost with 0                      ; Exit Host
      key = 0                                   ; Reset Key
   endif
   if (key==0x0E08)                             ; Convert backspace key
      key = 8                                   ;   to backspace character
   endif
   if key==0xE00D                               ; Gray CR
      key = 13                                  ; CR character
      endif
   if key> 0x3729                               ; Grey key
      key=key - 0x3700                          ; Normal key
      endif
   if key > 255                                 ; Filter out any high
      key = 0                                   ;  bit key codes has to be last
      endif                                     ;  if/then, so earlier ifs take
                                                ;  effect.
endproc

;**************************************************************************
;*                                                                        *
;*  Function:  GetNewPswd                                                 *
;*   Purpose:  Input a user password                                      *
;*     Input:  None                                                       *
;*    return:  success if user password obtained                          *
;*             FAILURE if password not obtained                           *
;*                                                                        *
;**************************************************************************
proc GetNewPswd

integer i, tries
string newpswd

   tries = 0                                    ; Set tries to 0
   while tries < 3                              ; Give them 3 shots at it
      call HostPutS with "`n`rPlease verify: "  ; Verify password prompt
      call HostGetS with &newpswd PSWDMAX HIDE  ; Get password
      if failure                                ; Problem?
         exitwhile
      endif
      strlen password i                         ; Get length of password
      if i > 0                                  ; Verify length > 0
         strupr password                        ; Convert to uppercase
         strupr newpswd                         ; Convert to uppercase
         strcmp password newpswd                ; Make sure they match
         if success                             ; OK?
            call SetSuccess
            return                              ; Boogey
         endif
      endif
      tries++                                   ; Inc tries
   endwhile                                     ; Loop
   call HostHangup                              ; Hangup on them
   call SetFailure                              ; Set Failure
endproc

;**************************************************************************
;*                                                                        *
;*  Function:  AddUser                                                    *
;*   Purpose:  Adds a new user into the PCPLUS.USR file                   *
;*    return:  Nothing                                                    *
;*     Notes:                                                             *
;*                                                                        *
;**************************************************************************
proc AddUser

    call GetNewPswd                             ; Verify password
    if success                                  ; ok
        fopen 1 HOSTUSRFILE "at"                ; open host user file for append
        if success                              ; ok
            strfmt record "%s;%s;%s;%i;* NEW USER *`n" last first password HOSTNEWUSR
            itoa HOSTNEWUSR access              ; get new user level
            H_Level = HOSTNEWUSR                ; Set H_Level
            fputs 1 record                      ; Write record
            fclose 1                            ; Close user file
            isfile hostnufile                   ; Does NewUserFile exist?
            if success                          ;  It does
              call hostputs with "`r`n"         ;    Space down for NewUserFile
              call displayfile with HostNUFile 23 ;  Display New User File
              call HostPutS with "`r`nHit any key"
              call HostGetC with &s0            ;    Waitfor response
              call HostPutS with "`b`b`b`b`b`b`b`b`b`b`b`b`b`b`b"
              endif
            call HostLog with padit "New user added to USR file"
            call SetSuccess                     ; Set success
            return
        else
           message "Error opening user file."
        endif
    endif
    call SetFailure
endproc

;**************************************************************************
;*                                                                        *
;*  Function:  Elaps                                                      *
;*   Purpose:  Calculate Elapsed Time Online                              *
;*    return:  Elapsed Time String                                        *
;*     Notes:                                                             *
;*                                                                        *
;**************************************************************************

proc elaps
  strparm tot,onl,ofl
  integer onh,onm,ons,ofh,ofm,ofs
  long toton,totoff,totonl
  string temp


  substr temp onl 0 2                           ;*
  atoi temp onh                                 ;**   Extract Hrs, Mins, & Secs
  substr temp onl 3 2                           ;***    convert to integer
  atoi temp onm                                 ;***    store in OnH,OnM,OnS
  substr temp onl 6 2                           ;**
  atoi temp ons                                 ;*
  substr temp onl 8 1                           ; Extract "AM" or "PM"
  strcmp temp "P"                               ; Check for PM
  if success
    onh=onh + 12                                ; Add 12 to hours
    endif
  toton = ons + (onm * 60) + (onh * 3600)       ; Total Secs from midnight

  substr temp ofl 0 2                           ;*
  atoi temp ofh                                 ;**
  substr temp ofl 3 2                           ;***
  atoi temp ofm                                 ;****
  substr temp ofl 6 2                           ;*****
  atoi temp ofs                                 ;****** Same as above, except
  substr temp ofl 8 1                           ;******   results save in
  strcmp temp "P"                               ;*****    OfH,OfM,OfS
  if success                                    ;****
    ofh=ofh + 12                                ;***
    endif                                       ;**
  totoff = ofs + (ofm * 60) + (ofh * 3600)      ;*

  totonl = totoff - toton                       ; Elapsed time

  onh = totonl / 3600                           ;*
  totonl = totonl%3600                          ;**
  onm = totonl / 60                             ;***Split elapsed components
  totonl = totonl%60                            ;**
  ons = totonl                                  ;*

  tot = " "                                     ; Set tot = to a space

  if onh > 9                                    ; if onh > 9
    itoa onh temp                               ;    convert to ascii
    strcat tot temp                             ;    append to tot
    endif
  if (onh > 0) && (onh < 10)                    ; if onh between 0 & 10
    strcat tot "0"                              ;    add "0" to tot, pads hours
    itoa onh temp                               ;    convert onh to string
    strcat tot temp                             ;    append string to tot
    endif
  if onh > 0                                    ; if onh > 0
    strcat tot " Hr "                           ;    append HR
    endif                                       ;

  if onm > 9                                    ;*
    itoa onm temp                               ;**
    strcat tot temp                             ;***
    endif                                       ;****
  if (onm > 0) && (onm < 10)                    ;*****
    itoa onm temp                               ;****** Same procedure as above
    strcat tot "0"                              ;******   results in Mins
    strcat tot temp                             ;*****
    endif                                       ;****
  if onm > 0                                    ;***
    strcat tot " Min "                          ;**
    endif                                       ;*

  if ons > 9                                    ;*
    itoa ons temp                               ;**
    strcat tot temp                             ;***
    endif                                       ;****
  if ons > 0 && ons < 10                        ;***** Same as above
    itoa ons temp                               ;*****   results in secs
    strcat tot "0"                              ;****
    strcat tot temp                             ;***
    endif                                       ;**
  strcat tot " Sec"                             ;*
endproc

;**************************************************************************
;*                                                                        *
;*  Function:  Flush_It                                                   *
;*   Purpose:  Flush Keyboard Buffer, Flush Receive Buffer                *
;*    return:  None                                                       *
;*     Notes:  None                                                       *
;*                                                                        *
;**************************************************************************

proc flush_it
  kflush
  rflush
endproc

;**************************************************************************
;*                                                                        *
;*  Function:  ReScreen                                                   *
;*   Purpose:  Restores screen & videomodes                               *
;*    return:                                                             *
;*     Notes:                                                             *
;*                                                                        *
;**************************************************************************

proc rescreen
  switch vidmode                                ;*
    case 1                                      ;**
      set screen 25x80                          ;***
      endcase                                   ;****
    case 2                                      ;*****
      set screen EXTRAX80                       ;******
      endcase                                   ;******* Reset video mode
    case 3                                      ;******
      set screen USERMODE                       ;*****
      endcase                                   ;****
    case 4                                      ;***
      set screen extraxuser                     ;**
      endcase                                   ;*
   endswitch
   if hostcdxfer
     set cdinxfer yes
    else
     set cdinxfer no
     endif
   clear cnorm                                  ; Clear & set video attribute
   exit
endproc

;**************************************************************************
;*                                                                        *
;*  Function:  Blankit                                                    *
;*   Purpose:  Screen Blank Routine                                       *
;*    return:  Timer Var (Resets)                                         *
;*     Notes:                                                             *
;*                                                                        *
;**************************************************************************

proc blankit
strparm start
integer move_time
integer row_count,port_dat
integer disp_color

  setvattr &disp_color magenta black blink

  vidsave 0                                     ; Save screen index 0
  port_dat = -1                                 ; Set port data -1
  row_count = 0                                 ; Set row_count 1 (first row)
  set statline off                              ; Turn off status line
  clear 0                                       ; Set screen black
  atsay row_count 21 disp_color "Host Screen Blanking ... Press any key"
  time start 0                                  ; Init counter
  while ! hitkey                                ; while not keyhit
    if (contype==modem_con) && (connected)      ; If modem connection is online
      exitwhile                                 ; exit while loop
      endif

    if (contype==direct_con) && (port_dat > -1) ; If direct connect
                                                ;    & data comes in port
      exitwhile                                 ; exit while loop
      endif
    call elapsed with &move_time start $time0   ; calculate elapsed time &
                                                ;   store in move_time
    if move_time == 3                           ; if 3 seconds elapsed
      atsay row_count 21 0   "                                      "
      inc row_count                             ; Increment row
      if row_count > 23                         ; If row > 23
        row_count=0                             ;    reset to 1st row
        endif
      atsay row_count 21 disp_color "Host Screen Blanking ... Press any key"
      time start 0                              ; reset timer
      endif
    comgetc port_dat                            ; check port for data
    endwhile                                    ; loop while
  set statline on                               ; Restore status line
  vidrest 0                                     ; Restore video index 0
  time start 0                                  ; Reset timer
endproc

;**************************************************************************
;*                                                                        *
;*  Function:  Dexist                                                     *
;*   Purpose:  Directory Exist Check                                      *
;*    return:  Directory (Resets if invalid)                              *
;*     Notes:                                                             *
;*                                                                        *
;**************************************************************************

PROC DEXIST                                     ; Check for directory existence
  STRPARM NEWDIR                                ; Dir to check
  STRING ORIDIR,CURDIR                          ; Temp Strings

  strlen newdir n0                              ; Check length
  if n0 < 2                                     ; Allow for root (\)
    call setsuccess
    return
    endif

  strupr newdir                                 ; Convert to uppercase
  STRLEN NEWDIR N0                              ; Get Length of newdir
  Dec N0                                        ; Dec by 1 (StrIndx begin w/ 0)
  STRPEEK NEWDIR N0 N1                          ; Check Last Character
  IF (N1 == 92)                                 ; If `\`
    substr newdir newdir 0 n0                   ; Strip backslash
    dec n0                                      ; Reset Length
    ENDIF

  GetDir 0 OriDir                               ; Get Original Directory

                                                ; The next group uses curdir
                                                ;     as a temporary variable
  strpeek newdir 1 n1                           ; Look at second char in newdir
  if !(n1==58)                                  ; If it's not a colon
     substr curdir oridir 0 2                   ;   Get current drive
     strcat curdir newdir                       ;   Append newdir to curdir
     newdir = curdir                            ;   newdir = curdir
     endif

                                                ; The next group uses curdir
                                                ;     as a temporary variable
  strpeek newdir 2 n1                           ; Look at third char in newdir
  if !(n1==92)                                  ; If it's not a backslash
     substr curdir newdir 0 2                   ;   Get drive & put in curdir
     substr newdir newdir 2 79                  ;   Put remainder back in newdir
     strcat curdir "\"                          ;   Add backslash
     strcat curdir newdir                       ;   Append newdir to curdir
     newdir = curdir                            ;   newdir = curdir
     endif

  strcmp newdir oridir                          ; Is test dir same as current
  if success                                    ;
     call setsuccess                            ;    then it's ok
     return                                     ;    return
     endif

  ChDir    NewDir                               ; Change to new directory
  GetDir 0 CurDir                               ; Get Current directory

  Strcmp Oridir Curdir                          ; compare current to original
  if success                                    ; They're the same
     call setfailure                            ;   Set Failure
   else                                         ; They're different
     call setsuccess                            ;   Set Success
     endif
  ChDir    OriDir                               ; Go back to original directory
ENDPROC

;**************************************************************************
;*                                                                        *
;*  Function:  FPUTI                                                      *
;*   Purpose:  Write Integer to file                                      *
;*     Input:  File Index By Value, Integer Value By Referece             *
;*    return:                                                             *
;*     Notes:                                                             *
;*                                                                        *
;**************************************************************************

proc FPutI
   intparm f_index,number
   integer lobyte,hibyte
   long fptr

   ftell f_index fptr                           ; Get Current Position
   hibyte = number & 0xFF00                     ; Get High Byte (Strip Low Byte)
   hibyte = hibyte >> 8                         ; Shift Right 8 Bits
   hibyte = hibyte & 0x00FF                     ; Strip High Byte

   lobyte = number & 0x00FF                     ; Get Low Byte
   fputc f_index hibyte                         ; Write High Byte to File
   fptr++                                       ; Inc FilePointer
   fseek f_index fptr 0                         ; Seek Next Position
   fputc f_index lobyte                         ; Write Low Byte
endproc

;**************************************************************************
;*                                                                        *
;*  Function:  FGETI                                                      *
;*   Purpose:  Read Integer from file                                     *
;*     Input:  File Index By Value, Integer Value By Referece             *
;*    return:                                                             *
;*     Notes:                                                             *
;*                                                                        *
;**************************************************************************

proc fgeti
   intparm f_index,number
   integer temp
   long fptr

   ftell f_index fptr                          ; Get Current Position
   fgetc f_index temp                          ; Read Byte
   number = temp << 8                          ; Shift Left 8 Bits
                                               ; to Convert to High Byte
                                               ; Store In Number

   fptr++                                      ; Inc FilePointer
   fseek f_index fptr  0                       ; Seek FilePointer Position
   fgetc f_index temp                          ; Read Byte
   number = number + temp                      ; Add to High Byte
endproc

;**************************************************************************
;*                                                                        *
;*  Function:  FPUTL                                                      *
;*   Purpose:  Write Long Value To File                                   *
;*     Input:  File Index by value, Long Value by reference               *
;*    return:                                                             *
;*     Notes:                                                             *
;*                                                                        *
;**************************************************************************

proc fputl
   intparm f_index
   longparm number
   long    hibyte,mid1byte
   integer mid2byte,lobyte,temp
   long fptr

   ftell f_index fptr                           ; Get Current Position

   hibyte = number & 0xFF000000                 ; Strip All But High Byte
   hibyte = hibyte >> 24                        ; Shift Right 24 Bits
   hibyte = hibyte & 0xFF                       ; Strip All But Low Byte
   temp = hibyte                                ; Store in Temp
   fputc f_index temp                           ; Write High Byte
   fptr++                                       ; Update FilePointer

   mid1byte = number & 0x00FF0000               ; Strip All But 3rd Byte
   mid1byte = mid1byte >> 16                    ; Shift Right 16 Bits
   mid1byte = mid1byte & 0xFF                   ; Strip All But Low Byte
   temp = mid1byte                              ; Store in Temp
   fputc f_index temp                           ; Write 3rd Byte
   fptr++                                       ; Update FilePointer

   mid2byte = number & 0x0000FF00               ; Strip All But 2nd Byte
   mid2byte = mid2byte >> 8                     ; Shift Right 8 Bits
   mid2byte = mid2byte & 0xFF                   ; Strip All But Low Byte
   fputc f_index mid2byte                       ; Write 2nd Byte
   fptr++                                       ; Update FilePointer

   lobyte = number & 0xFF                       ; Strip All But Low Byte
   fseek f_index fptr 0                         ; Seek FilePointer Pos
   fputc f_index lobyte                         ; Write Low Byte
endproc

;**************************************************************************
;*                                                                        *
;*  Function:  FGETL                                                      *
;*   Purpose:  Read Long Value From File                                  *
;*     Input:  File Index by value, Long Value by reference               *
;*    return:                                                             *
;*     Notes:                                                             *
;*                                                                        *
;**************************************************************************

proc fgetl
   intparm f_index
   longparm number
   long    hibyte,mid1byte,mid2byte
   integer lobyte,temp
   long fptr

   ftell f_index fptr                           ; Get Current Position
   fgetc f_index temp                           ; Read Byte
   hibyte = temp                                ; Store in Hybyte
   hibyte = hibyte << 24                        ; Shift Left 24 Bits
   number = hibyte                              ; Store in Number

   fptr++                                       ; Update File Pointer
   fgetc f_index temp                           ; Read Byte into Temp
   mid1byte = temp                              ; Store in Mid1Byte
   mid1byte = mid1byte << 16                    ; Shift Left 16 Bits
   number = number + mid1byte                   ; Add to Number

   fptr++                                       ; Update File Pointer
   fgetc f_index temp                           ; Read Byte into Number
   mid2byte = temp                              ; Store in Mid2Byte
   mid2byte = mid2byte << 8                     ; Shift Left 8
   number = number + mid2byte                   ; Add to Number

   fptr++                                       ; Update File Pointer
   fseek f_index fptr  0                        ; Seek FilePointer
   fgetc f_index lobyte                         ; Read Byte into LoByte
   number = number + lobyte                     ; Add to Number
endproc

;**************************************************************************
;*                                                                        *
;*  Function:  EXITHOST                                                   *
;*   Purpose:  Give SYSOP the option to abort host script                 *
;*     Input:                                                             *
;*    return:                                                             *
;*     Notes:  Call Rescreen to reset video mode                          *
;*                                                                        *
;**************************************************************************
proc exithost
intparm aborted
string  temp
      set msg_crlf off                          ; Set message linefeed off
      curon                                     ; Set cursor visible
      vidsave 1                                 ; Save screen index 1
      clear cnorm                               ; Clear screen w/ attrib cnorm

      if aborted == 0                           ; 0 - Aborted by Sysop
         message "`r`nExit Host Script (Y/n)? " ; Display prompt
         endif
      if aborted == 1                           ; 1 - Aborted by Privileged usr
         call hostputs with "`r`n`n  Exit Host (Y/n)? "   ; Display prompt
         endif
      if aborted == 2                           ; 2 - Exited normally
         goto ab1
         endif

      while 1                                   ;*
         if hitkey                              ;**
            keyget n0                           ;***
            exitwhile                           ;****  If abort type is 0 or 1
            endif                               ;*****    get response to exit
         if comdata                             ;*****    query, whether it's a
            comgetc n0                          ;****     keyhit, or incoming
            exitwhile                           ;***      data.
            endif                               ;**
         endwhile                               ;*

      key2ascii n0 s0                           ; Convert to string
      strupr s0                                 ; uppercase it
      call hostputs with s0                     ;* Display
      call hostputs with "`r`n"                 ;*     it
      strcmp s0 "Y" 1                           ; Compare it to Y
      if failure                                ; if not "Y"
         curoff                                 ;   set cursor off
         vidrest 1                              ;   restore video index 1
         return                                 ;   return
         endif

ab1:

      if (contype == modem_con) && connected    ; if modem still online
        call hostputs with "Hangup Line (Y/n)? ";    display prompt
        call hostgetyn                          ; Get response
        call hostputs with "`n`r"               ; Do CR/LF
        set msg_crlf on                         ;
        if success                              ; if "Y" or "y"
          statmsg "Hanging up Modem"            ;   Display message
          call hosthangup                       ;   hangup (what else?)
          endif
        endif

      if contype == modem_con

        if aborted == 1                         ; If aborted by user
            goto ab2                            ;   don't reset modem
            endif

         statmsg "Resetting Modem"
         fetch modem autoansoff temp            ; Get Autoansweroff String
         transmit temp                          ; Shoot it to modem
         endif

ab2:

      message "`r`n`r`nScript Aborted.`r`n"     ; Display abort message

      if aborted == 0
         call hostlog with "******** Host Aborted by Sysop *********" "`n"
         endif
      if aborted == 1
         call hostlog with "********* Host Aborted by User *********" "`n"
         endif
      if aborted == 2
         call hostlog with "*********** Host Deactivated ***********" "`n"
         endif

      call rescreen                             ; Call rescreen (restores
                                                ;  original screen & attributes)
      exit
endproc

;**************************************************************************
;*                                                                        *
;*  Function: DisplayFile                                                 *
;*   Purpose: Sends an acsii file to remote user and pauses every         *
;*            23 lines and displays a -MORE- prompt.                      *
;*     Input: Filename to send                                            *
;*            Page length                                                 *
;*    Return: Nothing                                                     *
;*     Notes: Failure if doesn't exist.                                   *
;*            Success if file exist and is displayed                      *
;*                                                                        *
;**************************************************************************
proc DisplayFile
strparm _file
intparm page_length
string line
integer count=0

    isfile _file                               ; Does file exist
    if failure                                 ; No?
        call SetFailure                        ; Set failure
        return                                 ; return
    endif

    fopen 5 _file "R"                          ; Open file for read
    call HostPutS with "`r"
    while 1                                    ; Loop forever
        fgets 5 line                           ; read line
        if EOF 5                               ; check for end of file
            exitwhile                          ; if eof exit while loop
        endif

        Call HostPutS with line                ; display line
        Call HostPutS with "`r"                ; add Carriage return
        inc count                              ; increment counter

        if count==page_length                  ; if counter = page length
            call HostPutS with "-MORE? (Y/n)-" ; display prompt
            call HostGetYN                     ; waitfor response
            call HostPuts with "`b `b"
            call HostPutS with "`r             `r" ; erase message
            if failure
               exitwhile
               endif
            count=1                            ; increment counter
        endif
    endwhile                                   ; loop
    fclose 5                                   ; close file
    call SetSuccess                            ; set success
endproc

;**************************************************************************
;*                                                                        *
;*  Function: GetHostParms                                                *
;*   Purpose: Open & read host parameter file or build with default       *
;*            parameters if one doesn't exist.                            *
;*     Input: None                                                        *
;*    Return: Parmeters, globally sets variables defined in host.asp      *
;*     Notes: Failure if can not create/read parm file                    *
;*                                                                        *
;**************************************************************************

proc GetHostParms
   string parmrec,temp
   integer stlen,prmlen

   ansi_on = 1                                ;*
   log_it  = 1                                ;*
   blanktimeout = 300                         ;**
   blanker = 1                                ;***
   expose  = 0                                ;****
   pager   = 1                                ;*****
   wtimeout = 180                             ;******
   htimeout = 300                             ;*******
   adir1=$null                                ;********
   adir2=$null                                ;********* Define Default Parms
   adir3=$null                                ;********
   adir4=$null                                ;*******
   adir5=$null                                ;******
   anam1="N/A"                                ;*****
   anam2="N/A"                                ;****
   anam3="N/A"                                ;***
   anam4="N/A"                                ;**
   anam5="N/A"                                ;*

   isfile hostparmfile                        ; Check if parm file exists
   if failure                                 ; Nope
      fopen 0 hostparmfile "W"                ; Create
      if failure                              ; Can't create
         strfmt s0 "`a`aUnable to create (%s) - No Host Parameter File Available"
         message s0
         exit
         endif

      fputs 0 "DIR1=`n"                       ;*
      fputs 0 "DIR2=`n"                       ;**
      fputs 0 "DIR3=`n"                       ;***
      fputs 0 "DIR4=`n"                       ;****
      fputs 0 "DIR5=`n"                       ;*****
      fputs 0 "NAM1=N/A`n"                    ;******
      fputs 0 "NAM2=N/A`n"                    ;*******
      fputs 0 "NAM3=N/A`n"                    ;********
      fputs 0 "NAM4=N/A`n"                    ;********* Write Defaults to File
      fputs 0 "NAM5=N/A`n"                    ;********  Include Line Feed (`n)
      fputs 0 "ANSI=ON`n"                     ;*******
      fputs 0 "BLANKTIMEOUT=300`n"            ;******
      fputs 0 "BLANKER=ON`n"                  ;*****
      fputs 0 "EXPOSE=OFF`n"                  ;****
      fputs 0 "PAGER=ON`n"                    ;***
      fputs 0 "LOG_IT=ON`n"                   ;***
      fputs 0 "WTIMEOUT=180`n"                ;**
      fputs 0 "HTIMEOUT=300`n"                ;*
      fclose 0
      return
      endif

   fopen 0 hostparmfile "R"                     ; Open Parm File
   while 1                                      ; Loop Forever
      if eof 0                                  ; Check for end of file
         fclose 0                               ; Close
         exitwhile
         endif

      fgets 0 parmrec                           ; Read record
      strlen parmrec stlen                      ; Calculate Length
      strupr parmrec                            ; Convert to uppercase

      strcmp parmrec "DIR1=" 5                  ; See if record is DIR entry
      if success                                ; yes?
         prmlen = stlen - 6                     ; start after "="
         substr adir1 parmrec 5 prmlen          ; Extract dir entry data
         endif

      strcmp parmrec "DIR2=" 5                  ;*
      if success                                ;**
         prmlen = stlen - 6                     ;***
         substr adir2 parmrec 5 prmlen          ;****
         endif                                  ;*****
                                                ;******
      strcmp parmrec "DIR3=" 5                  ;*******
      if success                                ;********
         prmlen = stlen - 6                     ;*********
         substr adir3 parmrec 5 prmlen          ;**********
         endif                                  ;***********
                                                ;************ Same as above
      strcmp parmrec "DIR4=" 5                  ;***********
      if success                                ;**********
         prmlen = stlen - 6                     ;*********
         substr adir4 parmrec 5 prmlen          ;********
         endif                                  ;*******
                                                ;******
      strcmp parmrec "DIR5=" 5                  ;*****
      if success                                ;****
         prmlen = stlen - 6                     ;***
         substr adir5 parmrec 5 prmlen          ;**
         endif                                  ;*

      strcmp parmrec "NAM1=" 5                  ;*
      if success                                ;**
         prmlen = stlen - 6                     ;***
         substr anam1 parmrec 5 prmlen          ;****
         endif                                  ;*****
                                                ;******
      strcmp parmrec "NAM2=" 5                  ;*******
      if success                                ;********
         prmlen = stlen - 6                     ;*********
         substr anam2 parmrec 5 prmlen          ;**********
         endif                                  ;***********
                                                ;************
      strcmp parmrec "NAM3=" 5                  ;*************
      if success                                ;**************  Same as above,
         prmlen = stlen - 6                     ;*************** but this time
         substr anam3 parmrec 5 prmlen          ;**************  extracting the
         endif                                  ;*************   directory names
                                                ;************
      strcmp parmrec "NAM4=" 5                  ;***********
      if success                                ;**********
         prmlen = stlen - 6                     ;*********
         substr anam4 parmrec 5 prmlen          ;********
         endif                                  ;*******
                                                ;******
      strcmp parmrec "NAM5=" 5                  ;*****
      if success                                ;****
         prmlen = stlen - 6                     ;***
         substr anam5 parmrec 5 prmlen          ;**
         endif                                  ;*

      strcmp parmrec "ANSI=" 5                  ;*
      if success                                ;**
         prmlen = stlen - 6                     ;***
         substr temp parmrec 5 prmlen           ;****
         strcmp temp "ON" 2                     ;***** Set ANSI preference,
         if success                             ;***** 0 = off, 1 = on
            ansi_on = 1                         ;****
            else                                ;***
            ansi_on = 0                         ;**
            endif                               ;*
         endif

      strcmp parmrec "PAGER=" 6                 ;*
      if success                                ;**
         prmlen = stlen - 7                     ;***
         substr temp parmrec 6 prmlen           ;****
         strcmp temp "ON" 2                     ;***** Set host Pager
         if success                             ;***** 0 = off, 1 = on
            PAGER = 1                           ;****
            else                                ;***
            PAGER = 0                           ;**
            endif                               ;*
         endif

      strcmp parmrec "EXPOSE=" 7                ;*
      if success                                ;**
         prmlen = stlen - 8                     ;***
         substr temp parmrec 7 prmlen           ;****
         strcmp temp "ON" 2                     ;***** Set password Expose
         if success                             ;***** 0 = off, 1 = on
            expose = 1                          ;****
            else                                ;***
            expose = 0                          ;**
            endif                               ;*
         endif

      strcmp parmrec "LOG_IT=" 7                ;*
      if success                                ;**
         prmlen = stlen - 8                     ;***
         substr temp parmrec 7 prmlen           ;****
         strcmp temp "ON" 2                     ;***** Set Activity log
         if success                             ;***** 0 = off, 1 = on
            log_it = 1                          ;****
            else                                ;***
            log_it = 0                          ;**
            endif                               ;*
         endif

      strcmp parmrec "BLANKER=" 8               ;*
      if success                                ;**
         prmlen = stlen - 9                     ;***
         substr temp parmrec 8 prmlen           ;****
         strcmp temp "ON" 2                     ;***** Set screen Blanker
         if success                             ;***** 0 = off, 1 = on
            BLANKER = 1                         ;****
            else                                ;***
            BLANKER = 0                         ;**
            endif                               ;*
         endif

      strcmp parmrec "BLANKTIMEOUT=" 13                   ;*
      if success                                          ;**
         prmlen = stlen - 14                              ;***  Set BlankTimeOut
         substr temp parmrec 13 prmlen                    ;**** & verify that
         atoi temp blanktimeout                           ;**** input value
         if (blanktimeout < 1) || (blanktimeout > 30000)  ;***  is within range
            blanktimeout = 300                            ;**   (1 - 30000)
            endif                                         ;*
         endif

      strcmp parmrec "WTIMEOUT=" 9                        ;*
      if success                                          ;**
         prmlen = stlen - 10                              ;***  Set WTimeOut
         substr temp parmrec 9 prmlen                     ;**** and verify that
         atoi temp Wtimeout                               ;**** input value
         if (Wtimeout < 10) || (Wtimeout > 30000)         ;***  is within range
            Wtimeout = 180                                ;**   (10 - 30000)
            endif                                         ;*
         endif

      strcmp parmrec "HTIMEOUT=" 9                        ;*
      if success                                          ;**
         prmlen = stlen - 10                              ;***
         substr temp parmrec 9 prmlen                     ;****  Set HTimeOut
         atoi temp HTimeout                               ;***** and verify that
         if (Htimeout < 10) || (Htimeout > 30000)         ;****  input value
            Htimeout = 300                                ;***   is within range
            endif                                         ;**    (10 - 30000)
         endif                                            ;*

      endwhile
   set msg_crlf on
endproc

;**************************************************************************
;*                                                                        *
;*  Function:  Elapsed                                                    *
;*   Purpose:  Calculate Elapsed Time                                     *
;*     Input:  Time String 1, Time String 2                               *
;*    return:  Elapsed Time Integer                                       *
;*     Notes:                                                             *
;*                                                                        *
;**************************************************************************
proc elapsed
  intparm el
  strparm onl,ofl
  integer onh,onm,ons,ofh,ofm,ofs
  long toton,totoff
  string temp
                                                ;*
  substr temp onl 0 2                           ;**
  atoi temp onh                                 ;***
  substr temp onl 3 2                           ;****
  atoi temp onm                                 ;*****
  substr temp onl 6 2                           ;****** Break Time String Into
  atoi temp ons                                 ;****** Hr,Min,Sec Components
  substr temp onl 8 1                           ;*****
  strcmp temp "P"                               ;****
  if success                                    ;***
    onh=onh + 12                                ;**
    endif                                       ;*

  toton = ons + (onm * 60) + (onh * 3600)       ; Calculate Time in Seconds

  substr temp ofl 0 2                           ;*
  atoi temp ofh                                 ;**
  substr temp ofl 3 2                           ;***
  atoi temp ofm                                 ;****
  substr temp ofl 6 2                           ;*****
  atoi temp ofs                                 ;****** Break Time String Into
  substr temp ofl 8 1                           ;****** Hr,Min,Sec Components
  strcmp temp "P"                               ;*****
  if success                                    ;****
    ofh=ofh + 12                                ;***
    endif                                       ;**
                                                ;*
  totoff = ofs + (ofm * 60) + (ofh * 3600)      ; Calculate Time in Seconds
  el = totoff - toton                           ; Calculate Elapsed Time in Secs
endproc

;**************************************************************************
;*                                                                        *
;*  Function:  HostLog                                                    *
;*   Purpose:  Logs Host Activity into Host.Log                           *
;*     Input:  String 1, String 2                                         *
;*    return:                                                             *
;*     Notes:                                                             *
;*                                                                        *
;**************************************************************************

proc HostLog
strparm activity1
strparm activity2

   if !log_it
      return
      endif

   strcmp activity2 "Lost Carrier" 12
   if success
      if LCFlag
         return
         endif
      LCFlag = 1
      endif

   isfile HostLogFile
   if failure                                   ;if new file put header at top
      fopen 4 HostLogFile "WT"
      if success
         fputs 4 "  DATE      TIME                           ACTIVITY`n"
         fputs 4 "--------  ----------   ---------------------------------------`n`n"
         fclose 4
      else
         clear
         locate 10 30
         Message "Can't create HOST.LOG file!"
         exit
      endif
   endif

   fopen 4 HostLogFile "A+"
   if failure
      clear
      locate 10 30
      Message "Can't open HOST.LOG file!"
      exit
   endif
   fseek 4 0 2
   strfmt msg "%s  %s   %s %s`n" $DATE $TIME0 activity1 activity2
   fputs 4 msg
   fclose 4
endproc

;**************************************************************************
;*                                                                        *
;*  Function:  Strippath                                                  *
;*   Purpose:  Removes the path from a path/filename                      *
;*     Input:  String 1                                                   *
;*    return:                                                             *
;*     Notes:                                                             *
;*                                                                        *
;**************************************************************************

Proc StripPath
   strparm FileIn
   Integer Len,BSIdx = -1,Loop,Char

   StrLen FileIn Len
   Dec Len

   For Loop = 0 Upto Len
      StrPeek FileIn Loop Char
      If Char == 0x5C                           ; "\"
         BSIdx = Loop
         EndIf
      EndFor

   Inc BSIdx
   SubStr FileIn FileIn BSIdx 79
Endproc
