


;                ACECOMM  Ascii Control File
;                          Use APRM.EXE to compile
;
; - PLEASE NOTE:   ACE.CTL is
;                              A  Plain  Ascii  Text  File...
;                              Use  a  Plain  Ascii  Text  Editor...
;
;
; ACECOMM's MACRO driven functionality provides for easy key re-definition
; Note: I have assigned both ALT-X and ALT-Q to the <EndAceComm> command
;       You may define the keys any way you like, should you forget to
;       assign an exit key, CTRL-BREAK from terminal mode will force the
;       <EndACEComm> MACRO to be executed, CTRL-BREAK is an acceptable
;       key-combo permanantly assigned to the <EndACEComm> MACRO
;
; Functions which end in '_LUI' are not suited for scripts as they require
; Local User Input
ALT-A <AutoScrGen_LUI>;                 Toggle AutoScrGen(tm) On/Off
ALT-B <BackBuffer_LUI>
ALT-C <CaptureFile_LUI>;                Toggle capture file Open/Close
ALT-D <FonListDialer_LUI>
;ALT-E <SendStr> ATS0=1^M <HostEcho>
ALT-E <HostMode>; Detects "RING" and sends Mdm_Answer string to modem
		; <HostMode> SETs HostEcho automaticaly
ALT-F <FileLister_LUI>;             ACECOMM internal filelist utility
ALT-G
ALT-H <MdmHangUp>
ALT-I
ALT-J <CommandShell_LUI>
ALT-K
ALT-L <RunProgram> list
ALT-M
ALT-N
ALT-O
ALT-P <PrmDataMenus_LUI>
ALT-Q <EndAceComm>
ALT-R <RunScriptFile_LUI>
ALT-S <ScrnSnapshot_LUI>
ALT-T <ScrnTag_LUI>
ALT-U
ALT-V <ViewKeyCombos>
ALT-W
ALT-X <EndAceComm>
ALT-Y
ALT-Z <ClearWindow>
;
ALT-1<SendZmo> %P; Internal zmodem   %P = "prompt for filename"
ALT-2<SendZmo> ace0320.arj
ALT-3<SendFile> ACECOMM.DSC
ALT-4
ALT-5
ALT-6
ALT-7
ALT-8
ALT-9
ALT-0
ALT--
ALT-= <DoorWayMode>
;
;
;
CTRL-A
CTRL-B
CTRL-C
CTRL-D
CTRL-E
CTRL-F
CTRL-G
CTRL-H
CTRL-I
CTRL-J
CTRL-K
CTRL-L
CTRL-M
CTRL-N
CTRL-O
CTRL-P
CTRL-Q
CTRL-R
CTRL-S
CTRL-T
CTRL-U
CTRL-V
CTRL-W
CTRL-X
CTRL-Y
CTRL-Z
;
CTRL-HOME
CTRL-PGUP
CTRL-LEFT
CTRL-RIGHT
CTRL-END
CTRL-PGDN

;
;
; Over on and near the KEYPAD with NUMLOCK "OFF"
Home
Up
PageUp <SProtocols_LUI>
GreyMinus
Left
Right
GreyPlus
End
Down
PageDn <RProtocols_LUI>
INS
DEL
;
;
;
F1 <SendStr>First Last^M
F2 <SendStr>[FON_REC_PWD] <SendStr>^M
F3 <SendStr>Phoenix, AZ
F4 <SendStr> CLASSIFIED!^M
F5 <SendStr>^H^H^H^H^H^H^H^H
F6 <SendStr> Is this a BBS or the census bureau???^M
F7 <SendFile>ACECOMM.DSC
F8
F9 <RunScriptFile> ace.scr
F10 <SendStr>xxxx^M
F11
F12 <SendStr>75120,3306^M


;
ALT-F1  <ChgDir>FILES <RunProgram> list <ChgDir>..
ALT-F2  <RunProgram> list
ALT-F3  <RunProgram> dsz rz -rm
ALT-F4  <RunProgram> COMMAND /C dir /w %WK; %WK (wait for keypress)
ALT-F5
ALT-F6
ALT-F7
ALT-F8
ALT-F9
ALT-F10
ALT-F11
ALT-F12
;
CTRL-F1  <LocalEcho> ON <DIALNUM> 846-2940 <LocalEcho> OFF
CTRL-F2  <SetDTR> Off <Delay> 5 <SetDTR> ON
CTRL-F3
CTRL-F4
CTRL-F5
CTRL-F6
CTRL-F7
CTRL-F8
CTRL-F9
CTRL-F10
CTRL-F11
CTRL-F12
; Note: The SHIFT Fn keyset is assigned to the screen-tag function.
;       Future will allow the screen-tag keyset be selectable,
;       untill then, screen-tag will assign the first available
;       SHIFT-Fn key the string that was tagged.
SHIFT-F1
SHIFT-F2
SHIFT-F3
SHIFT-F4
SHIFT-F5
SHIFT-F6
SHIFT-F7
SHIFT-F8
SHIFT-F9
SHIFT-F10
SHIFT-F11
SHIFT-F12
;
;
; - ACE-COMM will come up on the first usable port it can communicate
;   with. This feature may be overridden with 'PORT' (1 based)
Port 1
;
; Notes on selecting your highest port speed when LOCKing the port
;
; - Modem Speed can be set to highest baud your modem/computer will handle
;   including locked ports. Locking the port at 57600 with a high speed
;   modem causes the UART to assemble a character off the bit stream VERY
;   quickly. If you experience CRC errors with HIGH locked rates, drop
;   down to 38400 or even 19200. The lower rate will cause the UART to
;   make characters available at a reduced speed. For instance a 12 MHZ AT
;   will probably experience data overruns using a locked port above 38400
;   when downloading TEXT files with ZMODEM. A common miss-conception is
;   when CRC errors occur with HIGH LOCKED PORT rates, that it is the UART
;   unable to keep up. This is simply not true. The UART/modem combo is
;   capable of out running the computer/software combo. When using a TASK
;   switcher such as WINDOWS or DESQVIEW, a lower PORT RATE such as 19200
;   may very well be needed for efficient data transfers.
Baud 19200
; - Comment LOCKBAUD out if your modem doesn't handle a locked port
;   Locking the port data rate allows the modem and UART (serial port)
;   to communicate with each other most efficiently. Most modems above
;   2400 baud and or v32 capable will allow locking the port's data rate.
;   When you use LOCKBAUD ACECOMM and your modem will handle translation
;   for differant connect rates. See your modem manual for more information
;   using a locked port.
Lockbaud
;
;
; - Modem command strings
;   Note: Mdm commands are automaticaly appended with
;         Mdm_Cmd_Line_Terminator *when sent*
;         ^A translates to 1, ^M translates to 13 (CR_CHAR)
;         ~ translates to a 250 milisecond delay
Mdm_Init          ATZ^M~~~~ATES7=50; Command stacking with 1 second delay
Mdm_Dial_Prefix   ATEQ0X4DT
Mdm_Dial_Sufix
Mdm_Answer        ATA
Mdm_Hangup        +++~~~~~ATH0
Mdm_Offhook       ATH1
; The '^' character is recognized as a Control character. The byte
; following a '^' will become (byte - 64d) Example ^M translates to CR
Mdm_Abort         ^M
Mdm_Reset         ATZ
Mdm_Echo          ATE1
Mdm_Host_Init     ATE
; Mdm_Cmd_Line_Terminator is automaticaly appended to all modem commands
Mdm_Cmd_Line_Terminator ^M
;
; - Modem Responce Strings
;   Note: The following strings are probably case sensitive
;                                            (see your modem's manual)
Mdm_Res_Ok           OK
Mdm_Res_Ring         RING
Mdm_Res_NoCarrier    NO CARRIER
Mdm_Res_Error        ERROR
Mdm_Res_NoDialTone   NO DIAL TONE
Mdm_Res_Busy         BUSY
Mdm_Res_NoAnswer     NO ANSWER
Mdm_Res_Ringing      RINGING
Mdm_Res_Voice        VOICE
; - The following connect strings may be tailored any way you wish.
;   No particular order, refer to your modem's manual for case and format.
; Note: ACECOMM will detect a carrier anyway, the connect strings
;       may speed things up, and will also allow automatic baud adjustments
;       when connecting at a speed not dialed out on, and port not locked.
;       With Lockbaud SET, the UART's baud rate remains fixxed, translation
;       is made by your modem.
Mdm_Res_Connect_a CONNECT
Mdm_Res_Connect_b CONNECT 1200
Mdm_Res_Connect_c CONNECT 2400
Mdm_Res_Connect_d CONNECT 2400/ARQ
Mdm_Res_Connect_e CONNECT 4800
Mdm_Res_Connect_f CONNECT 9600
Mdm_Res_Connect_g CONNECT 9600/ARQ
Mdm_Res_Connect_h CONNECT 14400/ARQ
Mdm_Res_Connect_i CONNECT 16800/ARQ
Mdm_Res_Connect_j CONNECT 19200
Mdm_Res_Connect_k CONNECT 38400
Mdm_Res_Connect_l CONNECT 57600
Mdm_Res_Connect_m CARRIER
Mdm_Res_Connect_n CARRIER 9600
Mdm_Res_Connect_o CARRIER 12000
Mdm_Res_Connect_p CARRIER 14400
Mdm_Res_Connect_q CARRIER 16800
Mdm_Res_Connect_r CARRIER 19200
Mdm_Res_Connect_s CARRIER 28800
;
;
;
; Auto Download sequence triggers
; Note: The last byte in a sequence is the sequence's scan trigger byte
; Note: The last byte in a sequence is the sequence's scan trigger byte
; Note: The last byte in a sequence is the sequence's scan trigger byte
; Note: The last byte in a sequence is the sequence's scan trigger byte
; Note: The last byte in a sequence is the sequence's scan trigger byte
;       This means that ACECOMM will scan for the string with each occurance
;       of the last byte in a sequence. For this reason a trigger sequence
;       will end in a non-common byte. While 'rz^M' would be a valid trigger
;       sequence, we don't want ACECOMM to search on every carriage return
;       character that comes in. Look at Bimodem, we don't want to end the
;       sequence with the ^`(space character).
;
;       Characters 32(Space) and below need be escape encoded with the '^'
;       ^A becomes 1, ^B  2, ^C  3, etc.   ^` 32(SPACE)
; The following defaults have been working very well for me
AutoDnLd0 rz^M**^X
AutoDnLd1 HS*^B
AutoDnLd2 ^`^H^`^H^`^H^`^H
AutoDnLd3 MPt^`^V^H
; Auto logon sequence works for most BBS prompts
;AutoDnLd4 at^`is^`your^`name:; Note  SPACE CHAR 32d is encoded as ^`
AutoDnLd5
AutoDnLd6
AutoDnLd7
AutoDnLd8
AutoDnLd9
; AutoDownload MACROS
; <SendStr>^M  after externals activates BBS upon return
;PreAutoM   <ChgDir>files
;PostAutoM  <ChgDir>..
AutoMacro0 <RecvZmo>;         - Use ACECOMM's internal zmodem
;AutoMacro0 <RunProgram>dsz rz -mr <SendStr>^M
AutoMacro1 <RunProgram>hslink -P1 <SendStr>^M
AutoMacro2 <RunProgram>bimodem /C \ace <SendStr>^M
AutoMacro3 <RunProgram>MPT R <SendStr> ^M
; Auto logon macro
;AutoMacro4 <SendStr>First Last^M~^M~xxxx^M
AutoMacro5
AutoMacro6
AutoMacro7
AutoMacro8
AutoMacro9
;
;   Any directory commented out will be defined as the current directory
;   that the ACE.CTL file is compiled in.
;FonDir    fon;                - .FON files
;DnLdDir   files;              - Internal protocols receive to here
;Captures  cap;                - Create session capture (.CAP) files here
;Scripts   scr;                - Create/Run script files here
;TermKey   kts;                - Terminal key-press emulation (.KTS) files
;Nodelist  files               - NODELIST/NLIST.IDX  or  FBL's .NOD files here
;
FonFile  1_114.fon
;
; - The following SET flags  ON,  or  OFF (commented)
StatusLine
;SlowModem
AutoDnLd;                     - Enable autodownload triggers
AutoSave;                     - Auto save all chages in PRM-data editor
LogFile;
; - The following SET flags with paramaters
ScrnBlank   5; Minutes till blank
;ScrlBakBuf  200;           lines   - Uses 32k in color mode
ScrlBakBuf  300;           lines   - Uses 48k in color mode
;ScrlBakBuf  400;           lines   - Uses 62k in color mode
;
; - Defines for default BOX-MENU colors
;   BOX-MENU colors are initialized eact time the ACE.CTL file is compiled
BorderAttr         9
BorderType         1
TitleAttr         14
ITitleAttr        12
SelectorAttr       6
LeftFieldAttr      3
RightFieldAttr    10
BurstMenu
;ChatterMenu
;WhistleMenu
