'*****************************************************************************
' XMSDEMO.BAS - Simple program to demonstrate XMS interface for QuickBASIC
'               4.0+. May be run on any machine or DOS version.
'
'  (C) Copyright 1993 by One World Software. Placed into the public domain.
'  Author: Robin Duffy
'*****************************************************************************

DEFINT A-Z

DECLARE FUNCTION XMSError% ()
DECLARE FUNCTION WhichXError% ()
DECLARE FUNCTION GetXMS% (handle%)


TYPE mydata
   text AS STRING * 40
END TYPE

CLS
PRINT "This program demostrates the use of XMS memory with QuickBASIC. All the"
PRINT "major routines are demonstrated here. This simple test program was written"
PRINT "with QuickBASIC version 4.5 and tested in the editing environment."
PRINT
GOSUB keypress
PRINT

CALL InitXMS(there, memsize)

IF there THEN
   PRINT "This machine has"; memsize * 1024&; "bytes of available XMS!"
ELSE
   PRINT "Sorry, XMS memory is not available."
   END
END IF                                                      'Allocate all of
                                                            'it just to show
handle = GetXMS(memsize)                                    'we can!
IF XMSError THEN
   GOTO errorend
ELSE
   PRINT : PRINT "Successfully allocated"; memsize; "K bytes!"
END IF

PRINT : PRINT "Now to create some test data. This test data is a user type array"
PRINT "consisting of one element type - a 40 character string."
GOSUB keypress

bytes& = memsize * 1024&                     'Adjust the array size as needed
IF bytes& \ 40 > 400& THEN                   'No telling how much memory!
   numels = 400
ELSE
   numels = bytes& \ 40
END IF

REDIM t(1 TO numels) AS mydata

FOR x = 1 TO numels
   t(x).text = "This is element number" + STR$(x)
   PRINT t(x).text
NEXT

PRINT : PRINT "Saving"; numels; "elements to XMS memory!"

CALL Array2XMS(SEG t(1), handle, 40 * numels)
IF XMSError THEN GOTO errorend

ERASE t

PRINT : PRINT "The data in conventional memory has been erased. Now press a key to"
PRINT "restore the data to a new array and view it."
GOSUB keypress

REDIM r(1 TO numels) AS mydata

CALL XMS2Array(handle, SEG r(1), 40 * numels)
IF XMSError THEN GOTO errorend

FOR x = 1 TO numels
   PRINT r(x).text
NEXT
GOSUB keypress

ERASE r
PRINT : PRINT "OK, now you may edit or view any element directly from XMS memory."
PRINT "At the following prompt, press E to edit an element, V to view an element, or"
PRINT "ESC to exit the program. The program will ask you for an element number to"
PRINT "edit. Element numbers run between 1 and"; numels; "inclusive for this demo. "
PRINT "Each element used here is 40 characters long."
GOSUB keypress

DIM temp AS mydata

DO
   PRINT : PRINT "<E>dit, <V>iew or ESC?"
   DO
      pr$ = UCASE$(INKEY$)
   LOOP UNTIL pr$ = "E" OR pr$ = "V" OR pr$ = CHR$(27)

   IF pr$ <> CHR$(27) THEN
      INPUT "Element number? ", element
      IF element < 1 OR element > numels THEN
         PRINT "Invalid element number"
         pr$ = ""
      END IF
   END IF

   SELECT CASE pr$
   CASE "E"
      PRINT
      INPUT "New string-> ", temp.text
      CALL XSetElement(handle, temp, 40, element)
      IF XMSError THEN GOTO errorend
  
   CASE "V"
      PRINT : PRINT "Element"; element; "is: ";
      CALL XGetElement(handle, temp, 40, element)
      IF XMSError THEN GOTO errorend
      PRINT temp.text
  
   END SELECT

LOOP UNTIL pr$ = CHR$(27)


CALL FreeXMS(handle)

PRINT : PRINT "XMS memory has been released!"
PRINT : PRINT "This concludes the XMS demo program."
END

errorend:
   PRINT : PRINT "Error"; WhichXError; "occured - aborting program."
   PRINT "See program documentation for error information."
  
   IF handle THEN                             'Release it if it was allocated
      CALL FreeXMS(handle)                    'as DOS will not.
   END IF
  
   END

keypress:
   PRINT "Press any key to continue..."
   WHILE INKEY$ = "": WEND
   RETURN
