/*
 * clib.h - declarations for code in clib_?.lib
 *
 * (C) Copyright 1992, David Goodenough. All rights reserved
 */

#ifndef H_CLIB_INC
#define H_CLIB_INC 1

extern char *byp(char *);
extern char *strip(char *);
extern int dos21(int, int);
extern int dos21x(int, char *);
extern void xchdir(char *);
extern void gohome(void);
extern int scnwld(char *, void (*)(char *), int);
extern char *namefix(char *);
extern char *unbyp(char *);
extern int clocktick(void);
extern long lclocktick(void);
extern void border(int);
extern int where(void);
extern void moveto(int, int);
extern int bioskb(void);
extern int bkbnow(void);
extern int xkb(void);
extern void prinit(int);
extern int prstat(void);
extern void prchar(int);
extern char *upper(char *);
extern char *lower(char *);
extern long napms(unsigned int);
extern void sleep(unsigned int);
extern void readcmos(char *);
extern int dot(int);
extern int lcl(int);
extern int ucl(int);
extern void tone(long);
extern void music(char *);
extern void init_music(void);
extern int music_key(int);
extern int fcanon(char *, char *);
extern int dow(int, int, int);
extern void srnd(long);
extern int rnd(void);
extern void hang(void);
extern void reboot(void);
extern int getopt(int, char **, char *);
extern void cursor(int);
extern int run(char *, char *, int);
extern int editip(char *, int, int);
extern void edit_setprocs(void (*)(), void (*)(), int (*)());

/*
 * #defines for bits passed to scnwld()
 */

#define         ATTR_R          1
#define         ATTR_H          2
#define         ATTR_S          4
#define         ATTR_V          8
#define         ATTR_D          16
#define         ATTR_A          32

/*
 * variables in getopt
 */

extern int opterr;
extern int optind;
extern int optopt;
extern char *optarg;
extern char opterrstr[];

/*
 * pragmas etc. to link in the correct library
 */

#ifdef  M_I86TM
#pragma comment(lib,"clib_s.lib")
#endif
#ifdef  M_I86SM
#pragma comment(lib,"clib_s.lib")
#endif
#ifdef  M_I86MM
#pragma comment(lib,"clib_m.lib")
#endif
#ifdef  M_I86CM
#pragma comment(lib,"clib_c.lib")
#endif
#ifdef  M_I86LM
#pragma comment(lib,"clib_l.lib")
#endif
#ifdef  M_I86HM
#pragma comment(lib,"clib_l.lib")
#endif

#endif
