/*
 * geni.c - parse a GEnie input data stream into messages
 */

#include    <stdio.h>
#include    <clib.h>
#include    "callback.h"

char *mnam[] =
 {
    "jan",
    "feb",
    "mar",
    "apr",
    "may",
    "jun",
    "jul",
    "aug",
    "sep",
    "oct",
    "nov",
    "dec"
 };

static char hold[100];

static mcvt(mons)
char *mons;
 {
    int i;

/* XXX */

    lower(mons);
    mons[3] = 0;
    for (i = 0; i < 12; i++)
      if (strcmp(mons, mnam[i]) == 0)
        break;
    if (i < 12)
      i++;
    return(i);
 }

static gettok(dest, src, len)
char *dest, *src;
 {
    src = byp(src);
    while (*src != ' ' && *src && len)
     {
        *dest++ = *src++;
        len--;
     }
    *dest = 0;
 }

static init_split()
 {
    FILE *fp;
    char buff[30];

    strcpy(bbsname, "GENIE");
    strcpy(bbstitle, "GEnie Information Services");
    if ((fp = fopen("genie.cnf", "r")) != (FILE *) NULL &&
                                    fgets(buff, 28, fp) != (char *) NULL)
     {
        strip(buff);
        buff[25] = 0;
        strcpy(bbsuser, buff);
        fclose(fp);
     }
    else
      strcpy(bbsuser, "WHO-AM-I");
 }

int geni_split(line, whoami)
char *line;
 {
    static int state = 0;
    static int count;
    int i, j;
    int dt, mon, yr;
    char *oline;
    char junk[10];
    char mons[10];
    char work[80];

    static char area[6];
    static char sub_hold[28];
    static int confs = -1;
    static int topics = -1;
    static int nbl;

    strncpy(work, byp(oline = line), 78);
    work[78] = 0;
    strip(work);
    if (state == 0 && strncmp(work, "--==>>", 6) == 0 &&
                                strncmp(&work[9], "<<==--", 6) == 0)
     {
        strncpy(area, &work[6], 3);
        area[3] = 0;
        mine(whoami);
        init_split();
        addconf("MAIL");
        addconf(area);
     }
    if (area[0] == 0)
      strcpy(area, "XXX");
    if (state == 0)
     {
        if (strncmp(line, "From:   ", 8) == 0)
         {
            strcpy(confname, "MAIL");
            gettok(from, &line[8], 25);
            mine(whoami);
            init_split();
            addconf("MAIL");
            strcpy(to, bbsuser);
            state = 1;
            count = 4;
         }
        if (strncmp(line, "Item    ", 8) == 0)
         {
            sscanf(byp(&line[20]), "%d/%d/%d", &yr, &mon, &dt);
            sprintf(m_date, "%02d-%02d-%02d", mon, dt, yr);
            gettok(m_time, byp(&line[43]), 5);
         }
        if (strncmp(line, "Category ", 9) == 0)
         {
            if (sscanf(line, "Category %d, Topic %d", &confs, &topics) == 2)
             {
                strcpy(confname, area);
                state = 4;
                newmsg();
             }
         }
        if (strncmp(line, "Sub:", 4) == 0)
         {
            memset(sub_hold, 0, 26);
            strncpy(sub_hold, byp(&line[4]), 25);
         }
     }
    else if (state == 1)
     {
        if (strncmp(line, "To:     ", 8) == 0)
         {
            gettok(to, &line[8], 25);
            count = 4;
         }
        if (strncmp(line, "Sub:", 4) == 0)
         {
            memset(subject, 0, 26);
            strncpy(subject, byp(&line[4]), 25);
            state = 2;
            newmsg();
            nbl = 0;
         }
        else if (strncmp(line, "cc:", 3) == 0 || strncmp(line, "Cc:", 3) == 0)
          count = 4;
        else if (--count == 0)
          state = 0;
        return(0);
     }
    else if (state == 2)
     {
        if (strlen(byp(strip(line))) == 0)
          state = 3;
        return(0);
     }
    else if (state == 3)
     {
        if (strcmp(line, "=END=") == 0)
         {
            state = 0;
            finish_msg();
         }
        else if (strlen(line) == 0)
          nbl++;
        else
         {
            while (nbl)
             {
                nbl--;
                writemsg("");
            }
           writemsg(line);
         }
     }
    else if (state == 4)
     {
        sscanf(line, "Message %d %s %s %d, %d", &msgnum, junk, mons, &dt, &yr);
        msgnum--;
        mon = mcvt(mons);
        sprintf(m_date, "%02d-%02d-%02d", mon, dt, yr % 100);
        state = 5;
        if (topics != -1)
         {
            sprintf(hold, "%03d%03d / CONFERENCE %d, TOPIC: %d", confs, topics,
                                                                confs, topics);
            writemsg(hold);
            sprintf(to, "ALL %03d/%03d", confs, topics);
            topics = -1;
         }
     }
    else if (state == 5)
     {
        strncpy(from, line, 25);
        strcpy(subject, sub_hold);
        sscanf(byp(&line[25]), "at %s", m_time);
        state = 6;
     }
    else if (state == 6)
     {
        if (strlen(byp(strip(line))) == 0)
          state = 7;
     }
    else if (state == 7)
     {
        if (strcmp(line, " ************") == 0 ||
                            strcmp(line, " ------------") == 0)
         {
            state = 0;
            finish_msg();
         }
        else
          writemsg(line);
     }
 }
