/*
 * Basic XBBS-specific QWK functions in C
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include "qwk.h"
#include "xmsg.h"
#include "addr.h"
#ifdef BMG
 #include "bmg.h"
#endif

#ifdef HEADEDIT
    extern char to_domain[39],from_domain[39];
#endif

#ifdef GUESSREST
    extern ADDR *myaddr;
#endif

extern char *  rstrip (char *);
extern char *  skip_white (char *p);
extern char *  write_line (char **text,unsigned int linelen,char ctla);



#ifdef XQWKIMPORT


QWKAREAS * xreadqwkmsg (FILE *fp,XMSG *msg,char **hold,QWKAREAS *head,
                        int *error,int rep) {

    /* import a QWK message into an XBBS msg.  note that default
     * addresses should be assigned before calling this, as there's
     * no guarantee a valid address will be obtainable from the
     * damned QWK message.  Also note that message text will be
     * allocated here, and must be freed by caller
     */

    QWKHDR    hdr;
    time_t    t;
    struct tm *tm;
    long      size,pos;
    QWKAREAS *info;
    char     *p,*origin,*msgid,*msgto;


    *hold = NULL;
    *error = MSG_NOERR;
#ifdef HEADEDIT
    *from_domain = *to_domain = 0;
#endif

    /* get header */

    if(!qwkreadhdr(fp,&hdr,rep)) {
        *error = MSG_NOMOREMSGS;    /* end of the line */
        return NULL;
    }
    pos = ftell(fp);

    msg->attr = msg->m_attr = 0;
    if(!hdr.live) msg->m_attr |= MSGDELETED;
    if(hdr.status == QWKPRIVATE) msg->attr |= MSGPRIVATE;
    strcpy(msg->from,hdr.from);
    strcpy(msg->to,hdr.to);
    strcpy(msg->subj,hdr.subj);
    strftime(msg->date,20,"%a %d %b %y %H:%M",localtime(&hdr.date));
    t = time(NULL);
    tm = localtime(&t);
    msg->indate[0] = (char)(tm->tm_year - 89);
    msg->indate[1] = (char)(tm->tm_mon + 1);
    msg->indate[2] = (char)tm->tm_mday;
    msg->indate[3] = 0;
    msg->times = 0;
    msg->up    = 0;
    msg->dn    = 0;
    msg->cost  = 0;

    /* now get text */

    size = hdr.numchunks * (long)QWKBLKSIZE;
    if(!size) {
        *error = MSG_NOTEXT;    /* possible? */
        return NULL;
    }
    if(size > 65024L) size = 65024L;
    *hold = malloc((size_t)(size + 1L));
    if(!*hold) {
        *error = MSG_NOMEM;     /* fatal */
        return NULL;
    }

    if(!qwkreadblks(fp,*hold,(size_t)(size / (long)QWKBLKSIZE))) {
        free(*hold);
        *hold = NULL;
        fseek(fp,pos + (hdr.numchunks * (long)QWKBLKSIZE),SEEK_SET);
        *error = MSG_NOTEXT;    /* maybe not fatal */
        return NULL;
    }
    fseek(fp,pos + (hdr.numchunks * (long)QWKBLKSIZE),SEEK_SET);

    rstrip(*hold);
    msg->length = strlen(*hold);

    /* "treat" the message */

    p = *hold;
    while (*p) {
      if(*p == '\x8d' || *p == '\n') {
          memmove(p,&p[1],msg->length - ((unsigned int)p - (unsigned int)*hold));
          msg->length--;
          if(!msg->length) break;
          continue;
      }
      else p++;
    }
    if(*(p - 1) != '\r' && p > *hold) {
      *p = '\r';
      p[1] = 0;
    }

    if(!msg->length) {
        free(*hold);
        *hold = NULL;
        *error = MSG_NOTEXT;    /* maybe not fatal */
        return NULL;
    }

    /* find the damned area it belongs to */

    info = head;
    while(info) {
        if(hdr.confnum == info->confnum) break;
        info = info->next;
    }
    if(!info) {
        free(*hold);
        *hold = NULL;
        *error = MSG_BADAREA;   /* not fatal */
        return NULL;
    }

    /* now the hard part; trying to dig an address out of this
       addressless bastard... */

#ifdef BMG
    origin = bmgStrstr("\r * Origin: ",*hold,0);
    while((p = bmgStrstr("\r * Origin: ",&origin[1],0)) != NULL)
      origin = p;
    msgid = bmgStrstr("\01MSGID: ",*hold,0);
    msgto = bmgStrstr("\01MSGTO: ",*hold,0);
#else
    origin = strstr(*hold,"\r * Origin: ");
    while((p = strstr(&origin[1],"\r * Origin: ")) != NULL) origin = p;
    msgid = strstr(*hold,"\01MSGID: ");
    msgto = strstr(*hold,"\01MSGTO: ");
#endif

    if(msgid) {
        p = msgid;
        if((p - 1) < *hold || *(p - 1) == '\r') {

            ADDR addr;

            addr.domain = NULL;
            addr.net = msg->orig_net;
            addr.node = msg->orig;
            addr.point = msg->o_point;
            addr.zone = msg->o_zone;
            p += 8;
            p = skip_white(p);

            if(!parse_addr(&p,&addr,NULL)) {
#ifdef GUESSREST
                if(!addr.zone || !addr.net || !addr.domain || !*addr.domain) {
                    guess_rest(&addr,myaddr);
                }
#endif
            }
            msg->o_zone   = addr.zone;
            msg->orig_net = addr.net;
            msg->orig     = addr.node;
            msg->o_point  = addr.point;
#ifdef HEADEDIT
            if(addr.domain) strncpy(from_domain,addr.domain,38);
            from_domain[38] = 0;
            p = strchr(from_domain,'.');
            if(p) *p = 0;
            if(addr.domain) free(addr.domain);
#endif
        }
        else msgid = NULL;
    }

    if(msgto) {
        p = msgto;
        if((p - 1) < *hold || *(p - 1) == '\r') {

            ADDR addr;

            addr.domain = NULL;
            addr.net = msg->dest_net;
            addr.node = msg->dest;
            addr.point = msg->d_point;
            addr.zone = msg->d_zone;
            p += 8;
            p = skip_white(p);

            if(!parse_addr(&p,&addr,NULL)) {
#ifdef GUESSREST
                if(!addr.zone || !addr.net || !addr.domain || !*addr.domain) {
                    guess_rest(&addr,myaddr);
                }
#endif
            }
            msg->d_zone   = addr.zone;
            msg->dest_net = addr.net;
            msg->dest     = addr.node;
            msg->d_point  = addr.point;
#ifdef HEADEDIT
            if(addr.domain) strncpy(to_domain,addr.domain,38);
            to_domain[38] = 0;
            p = strchr(to_domain,'.');
            if(p) *p = 0;
            if(addr.domain) free(addr.domain);
#endif
        }
        else msgto = NULL;
    }

    if(origin && !msgid) {

        ADDR addr;
        char temp,*tempo;

        tempo = strchr(&origin[1],'\r');
        if(!tempo) {
            tempo = strrchr(origin,')');
            if(tempo) tempo++;
        }
        if(tempo) {
            while(*tempo != '(' && tempo > origin + 10) {
                tempo--;
            }
            if(*tempo == '(') {
                addr.net = msg->orig_net;
                addr.node = msg->orig;
                addr.point = msg->o_point;
                addr.zone = msg->o_zone;
                addr.domain = NULL;
                p = tempo + 1;
                while(*tempo && *tempo != '\r' && *tempo != ')') tempo++;
                temp = *tempo;
                *tempo = 0;
                if(!parse_addr(&p,&addr,NULL)) {
#ifdef GUESSREST
                    if(!addr.zone || !addr.net || !addr.domain || !*addr.domain) {
                        guess_rest(&addr,myaddr);
                    }
#endif
                }
                msg->o_zone   = addr.zone;
                msg->orig_net = addr.net;
                msg->orig     = addr.node;
                msg->o_point  = addr.point;
#ifdef HEADEDIT
                if(addr.domain && addr.domain)
                  strncpy(from_domain,addr.domain,38);
                from_domain[38] = 0;
                p = strchr(from_domain,'.');
                if(p) *p = 0;
                if(addr.domain) free(addr.domain);
#endif
                *tempo = temp;
            }
        }
    }

    return info;
}


#endif



#ifdef XQWKEXPORT

int xwriteqwkmsg (FILE *fp,FILE *idx,XMSG *msg,char *hold,long msgnum,
                  int area,int rep) {

    /* export an XBBS msg as a QWK msg */

    QWKHDR hdr;
    long   pos;
    char   *p;
#ifndef NEVER
    char         *ln;
    unsigned int len,w;
    long         bpos;
#endif
#ifdef USEFLOATS
    QWKIDX i;
#endif


    pos = ftell(fp);
    strncpy(hdr.from,msg->from,25);
    strncpy(hdr.to,msg->to,25);
    strncpy(hdr.subj,msg->subj,25);
    hdr.subj[25] = hdr.to[25] = hdr.from[25] = 0;
    if(msg->attr & MSGPRIVATE) hdr.status = QWKPRIVATE;
    else hdr.status = QWKPUBUNREAD;
    hdr.msgnum = msgnum;
    hdr.confnum = area;
    hdr.date = time(NULL);
    *hdr.pword = 0;
    hdr.repnum = 0;
    hdr.numchunks = (long)(msg->length / QWKBLKSIZE) + ((msg->length % QWKBLKSIZE) != 0);
    hdr.live = 1;

    if(!qwkwritehdr(fp,&hdr,rep)) {
        return MSG_BADWRITE;
    }

    if(!(msg->m_attr & MSGTREATED)) {    /* "treat" the message */
        p = hold;
        while (*p) {
          if(*p == '\x8d' || *p == '\n') {
              memmove(p,&p[1],msg->length - ((unsigned int)p - (unsigned int)hold));
              msg->length--;
              if(!msg->length) break;
              continue;
          }
          else p++;
        }
        if(*(p - 1) != '\r' && p > hold) {
          *p = '\r';
          p[1] = 0;
        }
    }

#ifdef NEVER

    /* this simple method won't work; damn QWK readers don't understand
       Fidonet-style paragraphing.  slows things down considerably. */

    if(!qwkwriteblks(fp,hold)) {
        fseek(fp,pos,SEEK_SET);
        fwrite("",0,0,fp); /* truncate file? */
        return MSG_BADWRITE;
    }

#endif

#ifndef NEVER

    p = hold;
    len = 0;
    while(p && *p) {
        ln = write_line(&p,76,1);
        len += fprintf(fp,"%s\xe3",ln);
    }

    /* fill out last block w/ spaces */

    hdr.numchunks = (long)((len / QWKBLKSIZE) + ((len % QWKBLKSIZE) != 0));
    w = ((unsigned int)hdr.numchunks * QWKBLKSIZE) - len;
    while(w--) {
        fputc(' ',fp);
    }

    /* backtrack and rewrite header */

    bpos = ftell(fp);
    fseek(fp,pos,SEEK_SET);
    qwkwritehdr(fp,&hdr,rep);
    fseek(fp,bpos,SEEK_SET);

#endif

#ifdef USEFLOATS
    if(!rep) {
        i->recnum = (float)(pos / (long)QWKBLKSIZE);
        i->junk = (char)area;
        qwkwriteidx(idx,&i);
    }
#endif

    msg->m_attr |= MSGQSCAN;
    return MSG_NOERR;
}

#endif
