#ifndef MSGERRS

    /* return values for functions in this module.  Also check errno */

    #define MSG_NOERR       0
    #define MSG_NOACCESS    1
    #define MSG_NOOPEN      2
    #define MSG_NOMEM       3
    #define MSG_NOSEEK      4
    #define MSG_NOLOCK      5
    #define MSG_NOUNLZSS    6
    #define MSG_REDUCED     7
    #define MSG_NOTEXT      8
    #define MSG_BADAREA     9
    #define MSG_BADNUM      10
    #define MSG_NOREAD      11
    #define MSG_PARTREAD    12
    #define MSG_ISPRIVATE   13
    #define MSG_ISDELETED   14
    #define MSG_BADWRITE    15
    #define MSG_NOMOREMSGS  16

    #define MSGERRS
#endif

#ifndef MSGDELETED

/*-------------------------------------------------------------------------*/
/* XBBS Message header                                                     */
/*-------------------------------------------------------------------------*/
struct __xmsg__ {
      char from[36];
      char to[36];
      char subj[60];
      unsigned int up;
      unsigned int dn;
	  unsigned int o_point;
	  unsigned int length;         /* Length of message */
	 unsigned long start;          /* Starting postition in text file              */
      char date[20];
      unsigned int times;          /* unused                                       */
	  unsigned int dest;           /* Destination node                             */
	  unsigned int orig;           /* Origination node number                      */
	  unsigned int cost;           /* Unit cost charged to send the message        */
	  unsigned int orig_net;       /* Origination network number                   */
	  unsigned int dest_net;       /* Destination network number                   */
	  char indate[4];              /* import date  (YMD(null))                     */
	  unsigned int m_attr;         /* Extra attributes                             */
	  unsigned int d_zone;         /* Destination zone                             */
	  unsigned int o_zone;         /* Origination zone                             */
	  unsigned int attr;           /* Attribute (behavior) of the message          */
	  unsigned int d_point;
};

typedef struct __xmsg__ XMSG;

/* These apply to m_attr */

#define MSGDELETED 0x0001  /* deleted message,          0000 0000 0000 0001*/
#define MSGANON    0x0002  /* anonymous message         0000 0000 0000 0010*/
#define MSGECHO    0x0004  /* unmoved echo message      0000 0000 0000 0100*/
#define MSGNET     0x0008  /* unmoved net message       0000 0000 0000 1000*/
#define MSGHOLD    0x0010  /* file attached to msg      0000 0000 0001 0000*/
#define MSGHOST    0x0020  /* being forwarded           0000 0000 0010 0000*/
#define MSGSCANNED 0x0040  /* fidonet scanned           0000 0000 0100 0000*/
#define MSGKEEP    0x0080  /* don't delete              0000 0000 1000 0000*/
#define MSGTREATED 0x0100  /* soft cr's & lf's removed  0000 0001 0000 0000*/
#define MSGPACKED  0x0200  /* message LZSS compressed   0000 0010 0000 0000*/
#define MSGGSCAN   0x0400  /* groupmail scanned         0000 0100 0000 0000*/
#define MSGRSCAN   0x0800  /* rfc0822 scanned           0000 1000 0000 0000*/
#define MSGQSCAN   0x1000  /* qwk scanned               0001 0000 0000 0000*/
/*#define    0x2000  /*  0010 0000 0000 0000*/
/*#define    0x4000  /*  0100 0000 0000 0000*/
#define MSGTAGGED  0x8000  /* used by offline readers   1000 0000 0000 0000*/


/* FIDO Message attributes (attr)                                           */

#define MSGPRIVATE 0x0001  /* private message,          0000 0000 0000 0001 */
#define MSGCRASH   0x0002  /* accept for forwarding     0000 0000 0000 0010 */
#define MSGREAD    0x0004  /* read by addressee         0000 0000 0000 0100 */
#define MSGSENT    0x0008  /* sent OK (remote)          0000 0000 0000 1000 */
#define MSGFILE    0x0010  /* file attached to msg      0000 0000 0001 0000 */
#define MSGFWD     0x0020  /* being forwarded           0000 0000 0010 0000 */
#define MSGORPHAN  0x0040  /* unknown dest node         0000 0000 0100 0000 */
#define MSGKILL    0x0080  /* kill after mailing        0000 0000 1000 0000 */
#define MSGLOCAL   0x0100  /* FidoNet vs. local         0000 0001 0000 0000 */
#define MSGXX1     0x0200  /*                           0000 0010 0000 0000 */
#define MSGXX2     0x0400  /* STRIPPED by FidoNet<tm>   0000 0100 0000 0000 */
#define MSGFRQ     0x0800  /* file request              0000 1000 0000 0000 */
#define MSGRRQ     0x1000  /* receipt requested         0001 0000 0000 0000 */
#define MSGCPT     0x2000  /* is a return receipt       0010 0000 0000 0000 */
#define MSGARQ     0x4000  /* audit trail requested     0100 0000 0000 0000 */
#define MSGURQ     0x8000  /* update request            1000 0000 0000 0000 */

#endif

/* LZSS routines in xbbslzs2.c */

char * unpack_msg2 (XMSG *msg,char **hold);
char * pack_msg2 (XMSG *msg,char *hold);

/* primitive message access functions in getput2.c */

int get_text2 (char **hold,XMSG *msg,unsigned int areano,
                        unsigned int messno);
int append_text2 (XMSG *msg,char *hold,unsigned int areano,
                           unsigned int messno);
int replace_text2 (XMSG *msg,char *hold,unsigned int areano,
                            unsigned int messno);
int get_mess2 (XMSG *msg,unsigned int areano,unsigned int messno);
int put_mess2 (XMSG *msg,unsigned int areano,unsigned int messno);
int post_message2 (XMSG *msg,char **hold,unsigned int areano,int isfile);

char * write_line2 (char *line, char **text,
                              unsigned int linelen, int ctla);
