#ifdef OS2
 #define INCL_DOS
 #include <os2.h>
#endif
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include "qwk.h"
#include "xqwk.h"
#include "xmsg.h"
#include "bmg.h"
#include "pkt.h"

extern char * lstrip (char *);
extern char * rstrip (char *);
extern char * stripcr (char *);
extern char * stristr (char *t, char *s);
extern char * assign (char *s,char *p);

int get_msg (FILE *fp,unsigned int buflen,char *buff,char **text,XMSG *xmsg);

char *area = NULL;



int main (int argc,char *argv[]) {

    XMSG msg;
    char *p,s[QWKBLKSIZE + 1],*hold,bbsid[9] = "",pktname[13],*lastarea = NULL;
    FILE *pkt,*qwk;
    int  c,uselist = 0,isrep = 0,numareas = 1;
    long nummsgs = 0L,secs;
    QWKAREAS *head = NULL,*info,*last = NULL;
    QWKAREAS *ahead = NULL,*ainfo,*alast = NULL;
    struct stat st;
    PKTHDR pkthdr;
    time_t start;


    printf("\n                      P-VERT"
           "\nPKT2QWK; converts Fidonet type 2 packets to QWK packets.\n");

    start = time(NULL);

    if(argc < 2) {
        printf("\nUsage: PKT2QWK <rootpktname> [-R(replypkt)] [-T(able)]\n");
        return 1;
    }

    strncpy(pktname,argv[1],8);
    pktname[8] = 0;
    rstrip(lstrip(pktname));
    p = strchr(pktname,'.');
    if(p) *p = 0;
    if(!*pktname) {
        printf("\nError in <rootpacketname>\n");
        return 2;
    }

    for(c = 2;c < argc;c++) {
        p = argv[c];
        while(*p == '/' || *p == '-') p++;
        switch(toupper(*p)) {
            case 'R':   isrep = 1;
                        break;

            case 'T':   uselist = 1;
                        break;

            default:    printf("\nUnknown option \"%c\"\n",*p);
                        break;
        }
    }

    /* read in table */

    if(uselist) {
        sprintf(s,"%s.TBL",pktname);
        qwk = fopen(s,"rt");
        if(!qwk) {
            printf("\nCan't find table %s\n",s);
            return 3;
        }
        printf("\nReading table %s\n",s);
        while(!feof(qwk)) {
            if(!fgets(s,80,qwk)) break;
            stripcr(s);
            if(!*s) continue;

            info = malloc(sizeof(QWKAREAS));
            if(!info) break;

            info->confnum = atoi(s);
            p = strchr(s,',');
            if(!p) {
                free(info);
                continue;
            }
            p++;
            info->name = strdup(p);
            if(!info->name) {
                free(info);
                continue;
            }

            if(!head) head = info;
            if(last) last->next = info;
            info->prev = last;
            info->next = NULL;
            last = info;
        }

        if(!head) {
            printf("\nDidn't get anything out of the table\n");
            return 4;
        }
    }

    hold = malloc(65202U);
    if(!hold) {
        printf("\nNot enough memory\n");
        return 5;
    }

    sprintf(s,"%s.PKT",pktname);
    pkt = fopen(s,"rb");
    if(!pkt) {
        printf("\nCan't open packet %s\n",s);
        return 6;
    }
    fread(&pkthdr,sizeof(PKTHDR),1,pkt);

    if(!isrep) strcpy(s,"MESSAGES.DAT");
    else sprintf(s,"%s.MSG",pktname);

    qwk = fopen(s,"wb");
    if(!qwk) {
        fclose(pkt);
        printf("\nCan't open QWK packet %s\n",s);
        return 7;
    }

    if(!qwkwriteblk(qwk,"Not produced by Qmail, no Copyright (c) 1987 and No Rights Reserved.")) {
        fclose(pkt);
        fclose(qwk);
        printf("\nCan't write to QWK packet %s\n",s);
        unlink(s);
        return 8;
    }

    while(!feof(pkt)) {
#ifdef OS2
        DosSleep(0L);
#endif
        c = get_msg(pkt,65200U,hold,&p,&msg);
        switch(c) {
            case -1:    printf("\nPacket read error\n");
                        goto BreakOut;

            case -2:    goto BreakOut;  /* end of packet */

            case -4:    printf("\nFatally grunged packet\n");
                        goto BreakOut;

            case 0:     break;

            default:    continue;
        }

        if(!msg.length || !*p) continue;
        if(!area) {
            if(head) area = head->name;
            else area = "NETMAIL";
        }

        /* find or make conference number */

        if(head) {
            info = head;
            while(info) {
                if(!stricmp(area,info->name)) break;
                info = info->next;
            }
            if(!info) {
                printf("\n? Unknown area %s skipped\n",area);
                if(lastarea) free(lastarea);
                lastarea = NULL;
                continue;
            }
            c = xwriteqwkmsg(qwk,NULL,&msg,p,nummsgs + 1,info->confnum,isrep);
        }
        else {
            ainfo = ahead;
            while(ainfo) {
                if(!stricmp(area,ainfo->name)) break;
                ainfo = ainfo->next;
            }
            if(!ainfo) {
                if(lastarea) free(lastarea);
                lastarea = NULL;
                ainfo = malloc(sizeof(QWKAREAS));
                if(!ainfo) continue;
                ainfo->name = strdup(area);
                if(!ainfo) {
                    free(ainfo);
                    continue;
                }
                ainfo->confnum = numareas++;

                if(!ahead) ahead = ainfo;
                if(alast) alast->next = ainfo;
                ainfo->next = NULL;
                ainfo->prev = alast;
                alast = ainfo;
            }

            c = xwriteqwkmsg(qwk,NULL,&msg,p,nummsgs + 1,ainfo->confnum,isrep);
        }

        if(c != MSG_NOERR) {
            printf("\nQWK packet write error #%d errno = %d; aborting...\n",c,errno);
            fclose(pkt);
            fclose(qwk);
            free(hold);
            return 9;
        }

        if(!lastarea || stricmp(lastarea,area)) {
            printf("\n%s ",area);
            lastarea = assign(lastarea,area);
        }
        printf("%-09ld\b\b\b\b\b\b\b\b\b",++nummsgs);
    }

BreakOut:

    fclose(pkt);
    fclose(qwk);
    free(hold);
    if(lastarea) free(lastarea);
    qwkfreeareas(head);
    qwkfreeareas(ahead);

    printf("\nCleaning up\n");
    if(nummsgs) {
        sprintf(s,"%s.PKT",pktname);
        unlink(s);
    }
    else {
        if(!isrep) strcpy(s,"MESSAGES.DAT");
        else sprintf(s,"%s.MSG",pktname);
        unlink(s);
    }

    printf("Complete: processed %ld message%s\n",nummsgs,&"s"[nummsgs == 1L]);
}



int get_msg (FILE *fp,unsigned int buflen,char *buff,char **text,XMSG *xmsg) {

    char *p,*endptr,*tempo,wasmsgid = 0,*origin,*pathline,*seenby;
	long pos;
    unsigned int x,len,*temp,chk,first_grunged = 0;


Again:

    area = NULL;
    memset(xmsg,0,sizeof(XMSG));
    if(feof(fp)) return -2;
    pos = ftell(fp);
    chk = fread(buff,1,buflen,fp);
    if(!chk || chk == 65535U) return -1;
    buff[buflen] = 0;
    p = buff;
    if(*p != (char)'\02' || p[1] != (char)'\0') {
        if(feof(fp) || (*p == (char)'\0' && p[1] == (char)'\0')) return -2;
        if(p < buff + buflen) p++;
        pos++;
        while(*p != (char)'\02' && p < (buff + buflen)) {
			p++;
			pos++;
		}
        fseek(fp,pos,SEEK_SET);
        if(!first_grunged) {
            printf("\nHmph.  Grunged packet...trying again...\n");
            first_grunged++;
            if(first_grunged > 1024) {
                return -4;
            }
        }
		goto Again;
	}
    p += 2;
    temp = (unsigned int *)p;
    xmsg->orig = *temp;
    p += 2;
    temp = (unsigned int *)p;
    xmsg->dest = *temp;
    p += 2;
    temp = (unsigned int *)p;
    xmsg->orig_net = *temp;
    p += 2;
    temp = (unsigned int *)p;
    xmsg->dest_net = *temp;
    p += 2;
    temp = (unsigned int *)p;
    xmsg->attr = *temp;
    p += 2;
    xmsg->cost = 0;
    p += 2;
    strncpy(xmsg->date,p,20);
    xmsg->date[19] = 0;
    while(*p) p++;   /* <--This kludge thanks to QMail, the broken wonder */
	p++;
    strncpy(xmsg->to,p,36);
    xmsg->to[35] = 0;
    while(*p) p++;
	p++;
    strncpy(xmsg->from,p,36);
    xmsg->from[35] = 0;
    while(*p) p++;
	p++;
    strncpy(xmsg->subj,p,60);
    xmsg->subj[59] = 0;
    while(*p) p++;
	p++;
    *text = p;
    while(*p) p++;
	p++;							/* Should be start of next msg */
    endptr = p;
    pos += (long)(endptr - buff);
    fseek(fp,pos,SEEK_SET);         /* Now positioned to start of next msg */

    if(!*xmsg->to && !*xmsg->from && !*xmsg->subj) {
        return -3;
    }
    len = strlen(*text);
    if(!len) {
        return -3;
    }

    if(strlen(xmsg->date) < 19) {
        for(x = 0; x < 19;x++) if(!xmsg->date[x]) xmsg->date[x] = 'Q';
    }

    /* end grunged msg testing */

    p = *text;
	while (*p) {	/* Strip linefeeds and soft cr's FAST */
        if(*p == '\x8d' || *p == '\n') {
            memmove(p,&p[1],len - (unsigned int)((long)p - (long)*text));
            len--;
            if(!len) break;
            continue;
        }
		p++;
	}

    if(!strnicmp(*text,"AREA:",5)) { /* Echo area tag */
        area = *text;
        while(**text && **text != '\r') {
            (*text)++;
		}
        if(**text) {
            **text = 0;                  /* area now = area tag line */
            (*text)++;                     /* text = true start of msg body if any */
		}
        while(**text == '\r' && **text) (*text)++; /* Skip leading cr's in body */
        area += 5;
		lstrip(area);
		rstrip(area);					/* Points directly to tag */
	}
    else area = NULL;

    if (area) {             /* Do ECHO specific BS */

        origin = pathline = seenby = NULL;

        tempo = *text;     /* They oughta outlaw EID's */
        while ((tempo = bmgStrstr("\01EID:",tempo,0)) != NULL)
          memmove(tempo,strchr(&tempo[1],'\r'),strlen(strchr(&tempo[1],'\r'))+1);

        tempo = *text;     /* and VIA's */
        while ((tempo = bmgStrstr("\01VIA",tempo,1)) != NULL)
          memmove(tempo,strchr(&tempo[1],'\r'),strlen(strchr(&tempo[1],'\r'))+1);

        while(**text == '\r' && **text) (*text)++; /* Skip leading cr's in body */
        if(!strncmp(*text," * Origin: ",11)) **text = 0;
        origin = bmgStrstr("\r * Origin:",*text,0);  /* find origin line */
        if (origin) {       /* Ain't one; oh, well, screw it */
            while((tempo = bmgStrstr("\r * Origin:",&origin[1],0)) != NULL)
              origin = tempo; /* Find last */
            pathline = bmgStrstr("\r\01PATH:",origin,0);   /* Find the PATH line */
            seenby = bmgStrstr("\rSEEN-BY:",origin,0); /* Find start of SEEN-BYs */
            if(pathline && seenby && pathline > seenby) {
                memmove(seenby,pathline,strlen(pathline) + 1);
            }
            else if(seenby) *seenby = 0;
		}
	}

    xmsg->length = strlen(*text);
    xmsg->m_attr = 0;
    if(area) xmsg->m_attr |= MSGECHO;        /* Is echo */
    else xmsg->m_attr |= MSGNET;             /* Is net  */

    return 0;
}
