#ifdef OS2
 #define INCL_DOS
 #include <os2.h>
#endif
#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include "qwk.h"
#include "xqwk.h"
#include "xmsg.h"
#include "pkt.h"
#include "addr.h"

PKTHDR * fill_in_pkt_hdr (PKTHDR *pkt,ADDR *myaddr,ADDR *addr,char *password);
int      write_pkt_msg (FILE *fp,XMSG *amsg,char *text,char *area);

extern char * rstrip (char *);
extern char * stripcr (char *);
extern char * stristr (char *t, char *s);



int main (int argc,char *argv[]) {

    ADDR from,to;
    XMSG msg;
    char *p,s[QWKBLKSIZE + 1],*hold,bbsid[9] = "",pktname[13];
    char qwkpkt[13] = "MESSAGES.DAT";
    FILE *pkt,*qwk;
    int  c,error,isrep = 0,makelist = 0;
    long numareas,nummsgs = 0L,secs;
    QWKAREAS *head,*info,*lastarea = NULL;
    struct stat st;
    PKTHDR pkthdr;
    time_t start;


    printf("\n                      P-VERT"
           "\nQWK2PKT; converts QWK packets to Fidonet type 2 packets.\n");

    start = time(NULL);

    if(argc < 3) {
        printf("\nUsage: QWK2PKT <from_address> <to_address> [-R(eplypkt)] [-T(able)]\n");
        return 1;
    }

    memset(&from,0,sizeof(ADDR));
    memset(&to,0,sizeof(ADDR));

    p = argv[1];
    if(parse_addr(&p,&from,NULL)) {
        printf("\nInvalid <from_address> -- must be 5-D Fidonet format"
               "\nexample:  1:380/16.0@Fidonet\n");
        return 2;
    }

    p = argv[2];
    if(parse_addr(&p,&to,NULL)) {
        printf("\nInvalid <to_address> -- must be 5-D Fidonet format"
               "\nexample:  1:380/16.0@Fidonet\n");
        return 3;
    }

    for(c = 3;c < argc;c++) {
        p = argv[c];
        while(*p == '/' || *p == '-') p++;
        switch(toupper(*p)) {
            case 'R':   isrep = 1;
                        break;

            case 'T':   makelist = 1;
                        break;

            default:    printf("\nUnknown option \"%c\"\n",*p);
                        break;
        }
    }

    qwk = fopen("CONTROL.DAT","rt");
    if(!qwk) {
        printf("\nCan't open CONTROL.DAT\n");
        return 4;
    }

    for(c = 0;c < 5;c++) {
        if(!fgets(s,80,qwk)) {
            fclose(qwk);
            printf("\nCONTROL.DAT is screwed\n");
            return 5;
        }
    }

    stripcr(s);
    rstrip(s);
    p = strchr(s,',');
    if(p && *(++p)) strncpy(bbsid,p,8);
    bbsid[8] = 0;

    for(c = 5;c < 10;c++) {
        if(!fgets(s,80,qwk)) {
            fclose(qwk);
            printf("\nCONTROL.DAT is screwed\n");
            return 5;
        }
    }

    head = qwkarearead(qwk,&numareas);
    fclose(qwk);
    if(!head) {
        printf("\nCONTROL.DAT is screwed or out of memory, take your pick.\n");
        return 6;
    }

    printf("\nProcessing %ld area%s\n",numareas,&"s"[numareas == 1L]);

    if(isrep) {
        if(*bbsid) sprintf(qwkpkt,"%s.MSG",bbsid);
        else strcpy(qwkpkt,"MESSAGES.MSG");
    }

    qwk = fopen(qwkpkt,"rb");
    if(!qwk) {
        printf("\nCan't open %s\n",qwkpkt);
        qwkfreeareas(head);
        return 7;
    }

    if(!qwkreadblk(qwk,s) || !stristr(s,"copyright")) {
        fclose(qwk);
        qwkfreeareas(head);
        printf("\n%s is screwed\n",qwkpkt);
        return 8;
    }

    if(*bbsid) {
        sprintf(s,"%s.PKT",bbsid);
    }
    else {
        sprintf(s,"%lx.PKT",time(NULL));
        while(!stat(s,&st)) {
            sprintf(s,"%lx.PKT",time(NULL));
        }
    }
    strcpy(pktname,s);

    pkt = fopen(pktname,"wb");
    if(!pkt) {
        fclose(qwk);
        printf("\nCan't open packet %s\n",pktname);
        qwkfreeareas(head);
        return 9;
    }

    printf("Building %s\n",pktname);

    if(fwrite(fill_in_pkt_hdr(&pkthdr,&from,&to,""),1,sizeof(PKTHDR),pkt) == 65535U) {
        printf("\nError writing to packet %s\n",pktname);
        fclose(qwk);
        fclose(pkt);
        qwkfreeareas(head);
        return 10;
    }
    fwrite("\0",2,1,pkt);
    fseek(pkt,ftell(pkt) - 2L,SEEK_SET);

    while(!feof(qwk)) {
#ifdef OS2
        DosSleep(0L);
#endif
        msg.orig = from.node;
        msg.dest = to.node;
        msg.orig_net = from.net;
        msg.dest_net = to.net;
        msg.o_zone = msg.d_zone = 0;
        msg.o_point = msg.d_point = 0;
        info = xreadqwkmsg(qwk,&msg,&hold,head,&error,isrep);
        if(!info || !hold || error != MSG_NOERR) {
            if(!info && error == MSG_BADAREA) {
                if(hold) free(hold);
                printf("\n? Unknown area skipped...\n");
                lastarea = NULL;
                continue;
            }
            if(error != MSG_NOERR && error != MSG_NOTEXT &&
              error != MSG_NOMOREMSGS) {
                printf("\nError %d, errno = %d; aborting...\n",error,errno);
                fclose(qwk);
                fclose(pkt);
                qwkfreeareas(head);
                return 11;
            }
            if(error == MSG_NOMOREMSGS) {
                if(hold) free(hold);
                break;
            }
            if(error == MSG_NOTEXT) {
                if(hold) free(hold);
                continue;
            }
        }
        if(lastarea != info) {
            printf("\n%s ",info->name);
            lastarea = info;
        }
        printf("%-09ld\b\b\b\b\b\b\b\b\b",++nummsgs);
        write_pkt_msg(pkt,&msg,hold,info->name);
        free(hold);
    }

    fclose(qwk);
    fclose(pkt);

    printf("\n\nRuntime: %ld mins %ld secs for %ld message%s",
           (time(NULL) - start) / 60L,(time(NULL) - start) % 60L,
           nummsgs,&"s"[nummsgs == 1]);
    if(nummsgs && !stat(qwkpkt,&st)) {
        numareas = st.st_size;
        if(!stat(pktname,&st)) {
            printf("\n\nSpace difference, QWK - PKT: %ld byte%s (not counting indexes, etc.)\n",
                   numareas - st.st_size,&"s"[(numareas - st.st_size) == 1L]);
            if(numareas > st.st_size) {  /* negatives screw up simple-minded calculation */
                secs = (long)max(1L,(((((numareas - st.st_size) * 10L) / 2400L) * 100L) / 80L));
                if(secs) printf("Approximately %ld percent, or %ld second%s @ 2400 baud.\n",
                                100L - ((st.st_size * 100L) / numareas),secs,&"s"[secs == 1L]);
            }
        }
    }

    if(!nummsgs || stat(pktname,&st) || st.st_size < 61L) {
        unlink(pktname);
        printf("\nProblem conversion:  no cleanup.\n");
    }
    else {
        printf("\nCleaning up");
        unlink("CONTROL.DAT");
        unlink("DOOR.ID");
        unlink(qwkpkt);
        info = head;
        if(makelist) {
            p = strchr(pktname,'.');
            if(p) {
                *p = 0;
                strcat(pktname,".TBL");
                qwk = fopen(pktname,"wt");
                if(!qwk) makelist = 0;
                else printf(" and building area table");
            }
            else makelist = 0;
        }
        printf(".\n");
        while(info) {
            if(makelist) {
                fprintf(qwk,"%d,%s\n",info->confnum,info->name);
            }
            sprintf(s,"%03d.NDX",info->confnum - 1);
            unlink(s);
            info = info->next;
        }
        if(makelist) fclose(qwk);
    }

    qwkfreeareas(head);
    return 0;
}



PKTHDR * fill_in_pkt_hdr (PKTHDR *pkt,ADDR *myaddr,ADDR *addr,char *password) {

    memset(pkt,0,sizeof(PKTHDR));

    pkt->onode = myaddr->node;
    pkt->onet = myaddr->net;
    pkt->ozone = myaddr->zone;
    pkt->opoint = myaddr->point;
    pkt->dnode = addr->node;
    pkt->dnet = addr->net;
    pkt->dpoint = addr->point;
    pkt->dzone = addr->zone;
    strncpy(pkt->odomain,myaddr->domain,8);
    strncpy(pkt->ddomain,addr->domain,8);

    strncpy(pkt->password,password,8);

    pkt->version = 2;
    pkt->subver = 2;
    pkt->product = 0;
    pkt->rev_lev = 0;

	return pkt;
}



int write_pkt_msg (FILE *fp,XMSG *amsg,char *text,char *area) {

    char pmsg[192],*p;
    unsigned int x;


    /* Write the message given to the end of the file given as a
	   packed msg */

	memset(pmsg,192,0);
    *pmsg = 0x02;
    pmsg[1] = 0x00;
    memcpy(&pmsg[2],&amsg->orig,2);
    memcpy(&pmsg[4],&amsg->dest,2);
    memcpy(&pmsg[6],&amsg->orig_net,2);
    memcpy(&pmsg[8],&amsg->dest_net,2);
    memcpy(&pmsg[10],&amsg->attr,2);
    x = 0;
    memcpy(&pmsg[12],&x,2);
    for(x = 0;x < 20;x++) if(!amsg->date[x]) amsg->date[x] = 'Q';
    amsg->date[19] = 0;
    memcpy(&pmsg[14],amsg->date,20);    
    p = &pmsg[34];
	strcpy(p,amsg->to);
    x = 34;
	while(*p){
		x++;
		p++;
	}
	p++;
	x++;
	strcpy(p,amsg->from);
	while(*p){
		x++;
		p++;
	}
	x++;
	p++;
	strcpy(p,amsg->subj);
	while(*p){
		x++;
		p++;
	}
	x++;
    p++;
    fwrite(pmsg,x,1,fp);
    if(area && *area) {             /* Prepend area tag */
        fprintf(fp,"AREA: %s\r",area);
    }
    fwrite(text,strlen(text),1,fp);
    fwrite("\0\0",3,1,fp);
    fseek(fp,(ftell(fp) - 2L),SEEK_SET);  /* Ready for another msg */
	return 1;
}
