#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "addr.h"


extern char *  rstrip (char *);
extern char *  lstrip (char *);
extern char *  skip_white (char *p);
extern char *  skip_nonwhite (char *p);
extern char *  to_delim (char *p, char *delim);
extern char *  assign (char *s,char *p);



int  parse_addr (char **p, ADDR *r,ADDR *rr) {

    /* Tries to parse a string for a valid FTN addresss.
       I say "tries" because it attempts to allow incomplete addresses
       without getting itself confused.
       p=pointer-to-pointer to string to parse
       r=pointer to address structure to place parsed address in */

    char *domain,*zone,*net,*node,*point,*temp,*tcr,*tnum,*tcp,*start;
    char lastdelim = 0;


    r->domain = domain = zone = net = node = point = temp = NULL;
	if(!*p || !**p) return -1;
    *p = skip_white(*p);
    start = *p;

    do {
        temp = *p;
        *p = to_delim(*p,"#:/.@\r\t ");
		switch((int) **p) {
            case '\r':
            case '\0':
            case ' ':
            case '\t':  if(lastdelim == '.') point = temp;
                        else if(lastdelim == '@') domain = temp;
                        else node = temp;
                        goto BreakOut;
            case '#':   domain = temp;
                        if(lastdelim == '.') {  /* handle fidonet.org */
                            domain = start;
                            point = NULL;
                        }
                        break;
            case ':':   zone = temp;
                        break;
            case '/':   net = temp;
                        break;
            case '@':   if(lastdelim == '.') point = temp;
                        else node = temp;
                        break;
            case '.':   if(lastdelim != '@') node = temp;
                        else {
                            *p = skip_nonwhite(*p); /* end this farce */
                            goto BreakOut;
                        }
						break;
        }
        lastdelim = **p;
        (*p)++;     /* Skip delimiter */
	} while(*p && **p);

BreakOut:

    if(!zone && !net && !point && !domain) {
        if(!node || (!atoi(node) && *node != '0')) return -1;
    }

    if(domain) {
        lstrip(domain);
        temp = strchr(domain,' ');
        if(temp) *temp = 0;
        tnum = strchr(domain,'#');
        if(tnum) *tnum = 0;
        tcr = strchr(domain,'\r');
        if(tcr) *tcr = 0;
        tcp = strchr(domain,'.');
        if(tcp) *tcp = 0;
        rstrip(domain);
        if(*domain) {
            r->domain = strdup(domain);
        }
        if(temp) *temp = ' ';
        if(tcr) *tcr = '\r';
        if(tnum) *tnum = '#';
        if(tcp) *tcp = '.';
    }
    if(zone) r->zone = atoi(zone);
    else r->zone = 0;
    if(net) r->net = atoi(net);
    else r->net = 0;
    if(node) r->node = atoi(node);
    else r->node = 0;
    if(point) r->point = atoi(point);
    else r->point = 0;

Again:

    if(!r->zone || !r->net || !node || !r->domain) {
		if(rr) {
			guess_rest(r,rr);
            rr = NULL;
			goto Again;
		}
		else return -1;
	}

	return 0;
}




int  guess_rest (ADDR *r, ADDR *m) {

    /* Makes primitive attempt to fill in missing fields of address
       r=pointer to address structure to complete
       m=pointer to first address in list to find missing info in */

    ADDR *temp;


    if(!r->net) r->net = m->net;  /* always assume primary address' net */

    if(!r->zone) {
        temp = m;
        r->zone = m->zone;        /* start assuming primary address' zone */
        while(temp) {
            if(temp->net == r->net) { /* unless we get a net match */
                r->zone = temp->zone;
                break;
            }
            temp = temp->next;
        }
    }

    if(!r->domain) {
        r->domain = strdup(m->domain);  /* start assuming primary domain */
        temp = m;
        while(temp) {
            if(temp->zone == r->zone) {   /* unless we get zone match */
                r->domain = assign(r->domain,temp->domain);
            }
            if(temp->net == r->net) break;    /* if we get a net match, break */
            temp = temp->next;
        }
    }

	return 0;
}




ADDR *  best_guess (ADDR *r,ADDR *m) {

    /* take our best guess as to who we should be when talking to node r
       m is list of addresses from which to choose */

    ADDR *temp,*ret = NULL;


    if(!r) return m;

    temp = m;
    while(temp) {
        if(r->domain && temp->domain && !stricmp(temp->domain,r->domain)) {
            if(!ret) ret = temp;         /* at least domains will match */
            if(temp->zone == r->zone) {
                if(ret->zone != r->zone) ret = temp;  /* zones too */
                if(temp->net == r->net) {             /* nets match! */
                    ret = temp;
                    break;             /* close as we're likely to get */
                }
            }
        }
        temp = temp->next;
    }

    if(ret) return ret;
    else return m;
}
