;********* FindLCh.Asm

;Find the last occurance of character in string
;

;Syntax: DECLARE FUNCTION FindLastCh(St$, BYVAL Ch)
;
;        St$     is the String to check
;        Ch      is the character to find

.Model Medium
.Code
Include Mixed.Inc

hProc FindLastCh String:Ptr, Chr:Ptr
    Std                         ;clear direction for string compares
    Push   ES
    Push   DS                   ;align segments for string compares
    Pop    ES

    Mov    AX, Chr              ;Get Ch to scan for
    Mov    BX,String            ;use BX for the address of St$ descriptor
    Mov    CX,[BX]              ;AX holds LEN(St$)
    Mov    DI,[BX+2]            ;DI holds first character of St$
    Jcxz   Exit                 ;get out if zero
    Mov    DX,CX                ;now DX holds LEN(St$)
    Add    DI,CX                ;Point to End of String+1
    Dec    DI                   ;and now to the end.
    Repne  Scasb                ;Scan for the character
    Jne    Exit                 ;Nope not there
    Inc    CX                   ;OK, it's there but we need to show where.
Exit:
    Mov    AX,CX                ;CX Contains position or 0
    Pop    ES
    Cld                         ;Reset flag
    HRet                  ; Return to BASIC

hEndP
End
