/* |--------------------------------------------------------------------|*/
/* |	      																				                    |*/
/* |	test -- test async library program									              |*/
/* |																					                          |*/
/* |--------------------------------------------------------------------|*/

#define EXTERN

#include <async.h>
#include <stdio.h>
#include <stdlib.h>

#define		COM1		 0
#define		COM2		 1
#define		COM3		 2
#define		COM4		 3
#define		SCAN		 0		/* keyboard function key scan code lead in */
#define		QUIT		'D'	/* F10 quit  */
#define     TRUE      1

char KbData, ModData;
int port;

void CloseUp(char * s);
void initialize(void);

void main()
{
   unsigned int mystat;
   
	initialize();
	VID_puts("\n\rPress F10 to quit...\n\r");
	do {
		if (kbhit()) {				/* get any char at kbd */
			KbData = getch();
			if (KbData == SCAN) {	/* FUNCTION KEY */
				KbData = getch();
				if (KbData == QUIT) {
					CloseUp("User abort.");
				}
			}
			else
				Async_Send(port, KbData);
		}
		if ((mystat = Async_Receive(port, &ModData)) == TRUE) {
			VID_putc(ModData);
		}
		else if (mystat != 0) {
		  VID_putc(ModData);
		  VID_puts("\n\r\Receive Error\n\r");
		}
	} while (TRUE); /* main while loop */
}		/* main */

void CloseUp(char *s)
{
   Async_Close(port);
	VID_puts(s);
	VID_puts("\n\r");
	VID_close();
   exit(0);
}

void initialize(void)
{
	VID_open();
	port = COM1;
	Async_Init();
	if (!Async_Open(port, 2400, 'E', 7, 1, 1000, 1000)) {
		VID_printf("Error opening COM%1s\n\r", port+1);
		VID_flush();
	}
}

void ProcessInputs(void)	/* dummy routine for Delay module */
{
}
