#ifndef ASYNC_H
#define ASYNC_H

#include <timing.h>
#include <vid.h>

#ifndef EXTERN
#define EXTERN extern
#endif

#ifdef _TURBOC
#define INP inportb
#define OUTP outportb
#endif

#ifdef _ZOR
#define INP inp
#define OUTP outp
#endif

#ifdef _MSC
#define INP inp
#define OUTP outp
#endif

#define MAXPORTS 4

#define port1 0              /* COM1                        */
#define port2 1              /* COM2                        */
#define port3 2              /* COM3                        */
#define port4 3              /* COM4                        */

/*Ŀ*/
/*                                                                    */
/*                 COMMUNICATIONS HARDWARE ADDRESSES                  */
/*                                                                    */
/*       These are specific to IBM PCs and close compatibles.         */
/**/

#define UART_THR     0x00  /* offset from base of UART Registers for IBM PC */
#define UART_RBR     0x00  /* receive buffer            */
#define UART_IER     0x01  /* interupt enable register  */
#define UART_IIR     0x02  /* interupt identification register */
#define UART_FCR     0x02  /* fifo buffer               */
#define UART_LCR     0x03  /* line control register     */
#define UART_MCR     0x04  /* modem control register    */
#define UART_LSR     0x05  /* line status register      */
#define UART_MSR     0x06  /* modem status register     */
#define UART_SCR     0x07  /* UART scratch buffer on NS16550 type */

#define I8088_IMR    0x21  /* port address of the Interrupt Mask Register */
   /*  for the 8059             */

#define COM1_Base    0x03F8 /* port addresses for the UART */
#define COM2_Base    0x02F8
#define COM3_Base    0x03E8 /* port addresses for the UART */
#define COM4_Base    0x02E8

#define UART_LSR1    0x03FD /* address of line status register for COM1 */
#define UART_LSR2    0x02FD /* address of line status register for COM2 */
#define UART_LSR3    0x03ED /* address of line status register for COM3 */
#define UART_LSR4    0x02ED /* address of line status register for COM4 */

#define UART_IIR1    0x03FA /* address of line status register for COM1 */
#define UART_IIR2    0x02FA /* address of line status register for COM2 */
#define UART_IIR3    0x03EA /* address of line status register for COM3 */
#define UART_IIR4    0x02EA /* address of line status register for COM4 */

#define COM1_Irq  12          /* Interrupt line for the UART */
#define COM2_Irq  11
#define COM3_Irq  12          /* Interrupt line for the UART */
#define COM4_Irq  11

#define MaxInt 65535
#define MAXRECV 32766
#define MAXSEND 65534

#define ERR -1
#define FALSE 0
#define TRUE  1
#define TIMEOUT  -1              /* TimeOut value                   */

#define RCVERR      6
#define XMITINT     2
#define RCVINT      4
#define FIFOTIMEOUT 0x0c
#define THRE        0x20

typedef enum tagBAUD{B110,B150,B300,B600,B1200,B2400,B4800,B9600,B19200,
						  B38400,B57600,B115K,Async_Num_Bauds}BAUD;
						  

/*Ŀ*/
/*                                                                    */
/*                  COMMUNICATIONS BUFFER VARIABLES                   */
/*                                                                    */
/*    The Communications Buffers are implemented as a circular (ring) */
/*    buffer, or double-ended queue.  The asynchronous I/O routines   */
/*    enter characters in the buffer as they are received.  Higher-   */
/*    level routines may extract characters from the buffer.          */
/*                                                                    */
/*    Note that this buffer is used for input only;  output is done   */
/*    on a character-by-character basis.                              */
/*                                                                    */
/**/

EXTERN struct BufferDef {
   unsigned *BufferStart;  /* start of communications buffer (receive) */
   unsigned *Buffer_Max;   /* last loc in buffer */
   volatile unsigned *Buffer_Head;  /* Loc in Async_Buffer to put next char */
   volatile unsigned *Buffer_Tail;  /* Loc in Async_Buffer to get next char */
   volatile unsigned Buffer_Used;
   unsigned Buffer_Size;
   unsigned MaxBufferUsed;

   unsigned char *SBufferStart; /* start of send buffer */
   unsigned char *SBuffer_Max;  /* last loc in send buffer */
   unsigned char *SBuffer_Head;
   volatile unsigned char *SBuffer_Tail;
   volatile unsigned SBuffer_Used;
   unsigned SBuffer_Size;
   unsigned MaxSBufferUsed;
   int sendints;						/* flay if send interupts are used */
   unsigned char ier;
   unsigned Base;
   unsigned Irq;
   unsigned Lsr;
   unsigned Iir;
   unsigned Save_Offset, Save_Segment;
   char Open_Flag;         /* true if Open but no Close */
   char Buffer_Overflow;   /* True if buffer overflow   */
} Async[MAXPORTS];

int Async_Init(void);
int Async_Open(int port, unsigned BaudRate, char Parity, int WordSize,
               int StopBits, int BufferSize, unsigned SBufferSize);
void Async_Close(int port);
int Async_Receive(int port, unsigned char *C);
int Async_Send(int port, unsigned char c);
int Async_putc(int port, unsigned char c);
void Async_Send_String(int port, unsigned char *s);
int Async_Buffer_Check(int port);
void Async_Calc_Buffer(int port);
void Async_Putback(int port, unsigned char c);
int Async_DCD(int port);
int Async_CTS(int port);
int Async_DSR(int port);
int Async_RI(int port);
int Async_Carrier_Drop(int port);
void Async_DTR(int port, char Ready_Status);
void Async_RTS(int port, char Ready_Status);
void Async_Isr(int port);
void Async_Send_String_With_Delays(int port, unsigned char *s, 
         int char_Delay, int EOS_Delay);
int Async_Percentage_Used(int port);
void Async_Purge_Buffer(int port);
void Async_Send_Brk(int port);
int Async_Receive_With_Timeout(int port, int Hunds, unsigned char *C);
void Async_Signon(int port, char *phone);
void Async_Signoff(int port);
void Async_Ints(int port);


void inton    ( void );
void intoff   ( void );
void getvec   ( int, unsigned *, unsigned * );
void setvec   ( int, unsigned  , unsigned );
/* void intsetup ( int, void (*func)() ); */

void intserv0 ( void );
void intserv1 ( void );
void intserv2 ( void );
void intserv3 ( void );

void peekw    ( unsigned , unsigned , void *, int);

void ProcessInputs( void );

#endif /* ASYNC_H */
