'=============================================================================
'  AnsiTerm.Bas
'
'  Terminal program with ANSI emulation and XModem file transfer.
'
'  Copyright (c) 1991 Clearware Computing, By David Cleary
'
'  Compile: BC /O AnsiTerm;
'  Link:    LINK /NOD/NOE/EX/PACKC/F AnsiTerm + AnsiDisp + FileSpec + Xmodem +
'           XStat + _NOVAL+_NOREAD+_NOERROR, , NUL, PDQCOMM PDQ;
'=============================================================================

DEFINT A-Z

'$INCLUDE: 'PDQDecl.Bas'               'PDQ Declarations
'$INCLUDE: 'CommDecl.Bas'              'PDQComm Declarations
'$INCLUDE: 'Term.Bi'                   'Both of these needed for
'$INCLUDE: 'Ansi.Bi'                   'ANSI emulation

' BASIC Declares
DECLARE FUNCTION GetFileSpec$ ()
DECLARE FUNCTION XModemSend% (FileName$)
DECLARE FUNCTION MessageSend% (FileName$, AutoWrap%)
DECLARE FUNCTION XModemReceive% (FileName$)
DECLARE SUB ReadDialDir (FileName$, Numbers$())

'-------- Initialize some variables

	DIM DialDir$(1 TO 10)

	One = 1                             'Saves a few bytes to declare
	Bottom = 25                         'these as variable instead of
	Norm = 7                            'constants
	Reverse = 112
	Space = 32
	Reset$ = "ATZ" + CHR$(13)
	Stat$ = SPACE$(80)
	Menu$ = "ALT +: Quit  Dial  HangUp  Configure  Log:    Upload  dOwnload"

	CLS
	AnsiInit                            'This sets the defaults for emulation
	Ansi.BRow = 24                      'We want to use the bottom row for status

'-----  Look for configuration file
	Path$ = GetFileSpec$						'Let's search for a configuration file
	Config$ = LEFT$(Path$, INSTR(Path$, ".")) + "CFG"

	IF PDQExist(Config$) THEN           'If we have a configuration file,
		OPEN Config$ FOR BINARY AS #1
		GET #1, , ComNum                 'This is our Comm Port
		GET #1, , Baud&                  'This is our baud rate
		GET #1, , Tone                   'This tells us if we have touch-tone
		CLOSE #1                         'or pulse dialing
	ELSE
		GOSUB GetConfig                  'If no configuration file exists,
	END IF

'-----  Read dialing directory if one exists
	DialFile$ = LEFT$(Path$, INSTR(Path$, ".")) + "DIR"
	IF PDQExist(DialFile$) THEN         'See if one exists
		CALL ReadDialDir(DialFile$, DialDir$())  'Read it up
	END IF

	GOSUB OpenPort                      'Go and open the port

	GOSUB Menu                          'Display Menu

	DO
		KeyPress = BIOSInkey             'This gets keyboard input
		SELECT CASE KeyPress             'While this prcesses it

'-----  Exit Program   ALT-Q
			CASE -16
				LSET Stat$ = "Exit to DOS? (Y/N)"
				Noise = -1
				GOSUB DoStat               'Prompt with sound
				LOCATE Bottom, 20
				GOSUB YesNo                'Yes/No answer
				IF KeyPress = 78 THEN
					GOSUB Menu              'If no, display menu
					AnsiPrint ""            'and reposition cursor
				ELSE
					EXIT DO
				END IF

'-----  Dial Out       ALT-D
			CASE -32
				Phone$ = SPACE$(30)

				LSET Stat$ = "Enter Number to Dial: - "
				GOSUB DoStat
				LOCATE Bottom, Bottom
				BIOSInput Phone$, Reverse

				Phone$ = LTRIM$(RTRIM$(Phone$))
				GOSUB Menu
				AnsiPrint ""
				IF LEN(Phone$) THEN GOSUB DialOut

'-----  Hang Up        ALT-H
			CASE -35
				LSET Stat$ = "Hanging Up Modem - StandBy"
				GOSUB DoStat

				Pause Bottom
				ComPrint "+++"
				Pause Bottom
				ComPrint "ATH" + CHR$(13)
				GOSUB Menu

'-----  Change Configuration   ALT-C
			CASE -46
				CloseCom
				GOSUB GetConfig
				GOSUB OpenPort
				GOSUB Menu

'-----  Log To Disk    ALT-L
			CASE -38

				IF LogOn THEN              'If we are logging, then we stop
					LogOn = 0
					CLOSE #1                'Close our log file
					DosErr = ERR            'Check for errors
					IF DosErr THEN
						LSET Stat$ = "Disk Error - " + PDQMessage$(DosErr)
						Noise = -1
						GOSUB DoStat
					ELSE
						LSET Stat$ = "Closing " + FileName$
						GOSUB DoStat
					END IF
					Pause Bottom

				ELSE
													'Else start logging
					FileName$ = SPACE$(30)
					LSET Stat$ = "Enter File Name:"
					GOSUB DoStat
					LOCATE Bottom, 18
					BIOSInput FileName$, Reverse

					FileName$ = UCASE$(RTRIM$(LTRIM$(FileName$)))
					LenName = LEN(FileName$)

					IF LenName THEN
						OverWrite = -1
						IF PDQExist(FileName$) THEN
							LSET Stat$ = FileName$ + " Exists, Overwrite it? (Y/N)"
							Noise = -1
							GOSUB DoStat
							LOCATE Bottom, LenName + 30
							GOSUB YesNo
							IF KeyPress = 78 THEN OverWrite = 0

							IF NOT OverWrite THEN
								LSET Stat$ = "Append to " + FileName$ + "? (Y/N)"
								GOSUB DoStat
								LOCATE Bottom, LenName + 19
								GOSUB YesNo
								AppendTo = -1
								IF KeyPress = 78 THEN AppendTo = 0
							END IF
						END IF

						IF OverWrite THEN
							OPEN FileName$ FOR OUTPUT AS #1
							DosErr = ERR
						ELSEIF AppendTo THEN
							OPEN FileName$ FOR APPEND AS #1
							DosErr = ERR
						END IF

						IF DosErr THEN

							LSET Stat$ = "Disk Error - " + PDQMessage$(DosErr)
							GOSUB DoStat
							LogOn = 0
							Pause Bottom

						ELSEIF OverWrite OR AppendTo THEN

							LogOn = -1
							LSET Stat$ = "Opening: " + FileName$
							GOSUB DoStat
							Pause Bottom

						END IF
					END IF
				END IF

				GOSUB Menu
				AnsiPrint ""

'-----  Function Keys for Dialing Directory  F1 - F10
			CASE -66 TO -59
				Phone$ = DialDir$(-KeyPress - 58)
				IF LEN(Phone$) THEN GOSUB DialOut

'-----  Upload a File
			CASE -22

				FileName$ = SPACE$(30)
				LSET Stat$ = "Enter File Name to Upload:"
				GOSUB DoStat
				LOCATE Bottom, 28
				BIOSInput FileName$, Reverse
				FileName$ = UCASE$(LTRIM$(RTRIM$(FileName$)))
				IF NOT PDQExist(FileName$) THEN

					AnsiPrint ""
					LSET Stat$ = FileName$ + "Not Found . . ."
					Noise = -1
					GOSUB DoStat
					Pause Bottom

				ELSE

					AnsiPrint ""
					GOSUB Menu
					SetHandshaking "NON"
					RetCode = XModemSend(FileName$)
					SetHandshaking "XON"
					IF RetCode THEN
						LSET Stat$ = "Upload failed - Return Code " + STR$(RetCode)
					ELSE
						LSET Stat$ = "Upload successful"
					END IF
					Noise = -1
					GOSUB DoStat
					Pause Bottom

				END IF
				GOSUB Menu

'-----  Download a File
			CASE -24

				FileName$ = SPACE$(30)
				LSET Stat$ = "Enter File Name to Download:"
				GOSUB DoStat
				LOCATE Bottom, 31
				BIOSInput FileName$, Reverse
				FileName$ = UCASE$(LTRIM$(RTRIM$(FileName$)))
				AnsiPrint ""
				GOSUB Menu
				SetHandshaking "NON"
				RetCode = XModemReceive(FileName$)
				SetHandshaking "XON"
				IF RetCode THEN
					LSET Stat$ = "Download failed - Return Code " + STR$(RetCode)
				ELSE
					LSET Stat$ = "Download successful"
				END IF
				Noise = -1
				GOSUB DoStat
				Pause Bottom

				GOSUB Menu

'-----  Normal keys out the port
			CASE IS > 0
				ComPrint CHR$(KeyPress)

'-----  Extended key code
			CASE IS < 0
				ComPrint CHR$(0) + CHR$(KeyPress)

		END SELECT

'-----  Servive Port
		IF ComLoc THEN
			Text$ = ComInput$(ComLoc)
			AnsiPrint Text$
			IF LogOn THEN PUT #1, , Text$
		END IF

'-----  IMPORTANT !!! Check for buffer overrun condition
		IF OverRun THEN
			LSET Stat$ = "Buffer Overrun !!!"
			Noise = -1
			GOSUB DoStat
			FlushBuffer
			Pause Bottom
			GOSUB Menu
		END IF

	LOOP

	CloseCom
	IF LogOn THEN CLOSE #1
	CLS
	END

'*****************************************************************************
'-----  Subroutines

Menu:                                  'display line 25 menu
	LSET Stat$ = ""
	PDQPrint Stat$, Bottom, One, Reverse   'clear line 25
	PDQPrint Menu$, Bottom, One, Reverse   'print the menu string

	PDQPrint "Q", Bottom, 8, Norm       'highlight menu keys
	PDQPrint "D", Bottom, 14, Norm
	PDQPrint "H", Bottom, 20, Norm
	PDQPrint "C", Bottom, 28, Norm
	PDQPrint "L", Bottom, 39, Norm
	PDQPrint "U", Bottom, 47, Norm
	PDQPrint "O", Bottom, 56, Norm

	IF LogOn THEN                          'if disk log is on then
		PDQPrint "On", Bottom, 43, Reverse  'highlight on
	ELSE                                   'if disk log is off then
		PDQPrint "Off", Bottom, 43, Reverse 'highlight off
	END IF
RETURN

YesNo:
	YesNoCol = POS(0)                   'save cursor column
	DO                                  'key press loop
		LOCATE Bottom, YesNoCol          'locate curosr position
		KeyPress = BIOSInkey             'get user input
		IF KeyPress THEN                 'if a key was pressed
			IF KeyPress > 90 THEN KeyPress = KeyPress - 32  'upper case swap
			PRINT CHR$(KeyPress);         'print the key
		END IF
	LOOP UNTIL KeyPress = 89 OR KeyPress = 78   'loop until a valid choice
RETURN

'----- Reconfigure
GetConfig:
	LSET Stat$ = "Enter Com Port Number - "
	GOSUB DoStat
	LOCATE Bottom, Bottom
	DO
		KeyPress = BIOSInkey
		IF KeyPress THEN
			IF KeyPress = 27 THEN
				LOCATE Row, Col
				GOSUB Menu
				RETURN
			END IF
			PDQPrint CHR$(KeyPress), Bottom, Bottom, Norm
			ComNum = PDQValI(CHR$(KeyPress))
			IF ComNum < 1 AND ComNum > 4 THEN
				PDQSound 2500, 2
			ELSE
				EXIT DO
			END IF
		END IF
	LOOP

	LSET Stat$ = "What baud rate do you want? "
	GOSUB DoStat
	Baud$ = SPACE$(5)
	LOCATE Bottom, 29
	BIOSInput Baud$, Reverse
	Baud& = PDQValL(Baud$)

	LSET Stat$ = "Do you have a touch-tone phone? (Y/N) - "
	GOSUB DoStat
	LOCATE Bottom, 40
	GOSUB YesNo
	IF KeyPress = 89 THEN Tone = -1 ELSE Tone = 0

	OPEN Config$ FOR BINARY AS #2
	PUT #2, , ComNum
	PUT #2, , Baud&
	PUT #2, , Tone
	CLOSE #2

	GOSUB Menu
	AnsiPrint ""
RETURN

'-----  Open Com Port
OpenPort:
	LSET Stat$ = "Initializing Port - Standby"
	GOSUB DoStat
	OpenCom "COM" + STR$(ComNum) + ":" + STR$(Baud&) + ",N,8,1,RB1024,XON"
	ComErr = ERR
	IF ComErr THEN
		LSET Stat$ = "Sorry - Communications error " + STR$(ComErr)
		Noise = -1
		GOSUB DoStat
		Pause Bottom
		CLS
		END
	END IF

	ComPrint Reset$

RETURN

'----- Dial Out
DialOut:
	IF Tone THEN Dial$ = "ATDT" ELSE Dial$ = "ATDP"
	Dial$ = Dial$ + Phone$ + CHR$(13)
	LSET Stat$ = "Dialing " + Phone$
	GOSUB DoStat
	ComPrint Dial$
	Pause Bottom
	GOSUB Menu
RETURN

'-----  Print staus line
DoStat:
	PDQPrint Stat$, Bottom, One, Norm
	IF Noise THEN
		PDQSound 2500, 2
		Noise = 0
	END IF
RETURN

SUB ReadDialDir (FileName$, Numbers$()) STATIC

	MaxNum = UBOUND(Numbers$)           'Determine max amount of numbers
	CurNum = 1                          'Array pointer
	FileNum = FREEFILE                  'Get a file handle
	OPEN FileName$ FOR INPUT AS #FileNum 'Open the file

	DO
		LINE INPUT #FileNum, Line$       'Read a line
		Comment = INSTR(Line$, "'")      'Parse out comments
		IF Comment THEN
			Line$ = LEFT$(Line$, Comment - 1)
		END IF
		Line$ = LTRIM$(RTRIM$(Line$))    'Remove all spaces

		IF LEN(Line$) THEN               'After all this, if we have anything
			Numbers$(CurNum) = Line$      'Lets call it a phone number
			CurNum = CurNum + 1
		END IF
	
	LOOP UNTIL EOF(FileNum) OR CurNum > MaxNum 'Continue until we reach the
															 'the enod of file or out of
	CLOSE #FileNum                             'numbers

END SUB
