/*

PREFIX -- Stores Squish lastread pointers before SQFIX

Version 1.0  (10/12/92)

Written by Bob Quinlan of Austin, Texas, USA
Sysop of Red October at 512-834-2593 (1:382/111)

Copyright 1992 by Bob Quinlan

Compatible with Maximus 2.00 and 2.01


This program is intended to be used before SQFIX and various other
utilities that reset the lastread pointers.  It generates a pair of
files (areaname.PFH and areaname.PFL) which contain the data necessary
to reconstruct the lastread information.

PREFIX must be followed by the name of a message area.

Once PREFIX has been run you can run SQFIX or perform whatever other
maintenance is needed.  Then run the companion program POSTFIX to
reconstruct the lastread pointers.


PREFIX returns ERRORLEVEL 0 after a successful run.  ERRORLEVEL 1 is
returned to indicate an error.

NOTICE:  You may use, copy, and distribute this program freely as long
as you insure that both the executable and the documentation (.DOC)
files are included in the distribution package.  The source code does
not need to be included.  You may modify this program and document, so
long as reasonable credit is given to the original author if a
substantial portion of the original remains intact.  The author is not
responsible for any losses which may occur either directly or indirectly
as a result of using this program.

This program uses the Squish MsgAPI and the Maximus structures written
by Scott J. Dudley.  "Squish" is a trademark of Scott J. Dudley.

HISTORY:
Version 1.0  (10/12/92) -- Original release.  Written in Borland C.

Large memory model

OS/2 version (8/22/93) -- Ported using IBM's C SET/2 by Richard Butler
                        - no code changes made to PREFIX.C
*/

/* Needed for use with MSGAPI modified for C SET/2 */

#define __386__
#define __MSC__
#define _MSC_VER 600
#define OS_2
#define msgapierr _msgapierr

/* end */

#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <io.h>
/* #include <dos.h> */
#include <share.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys\stat.h>
#include <sys\types.h>
#include "prog.h"     /* From MsgAPI by Scott J. Dudley modified for C SET/2 */
#include "alc.h"      /* From MsgAPI by Scott J. Dudley modified for C SET/2 */
#include "msgapi.h"   /* From MsgAPI by Scott J. Dudley modified for C SET/2 */
#include "mstruct.h"  /* Maximus structures by Scott J. Dudley: modified
                         to avoid duplicate definitions of datestamps  */

#define MAXLINE     (128)
#define MAXNAME     (36)


int main(int argc, char *argv[])
{
struct _area arearef;
XMSG   xmsg;
MSG    *area;
MSGH   *msg;
UMSGID uid;
struct _minf mi;
UMSGID umsgid;
dword  msgn;

char   msgpath[MAXLINE];
char   stamppath[MAXLINE];
FILE   *stamp_fp;
char   lastumsgidpath[MAXLINE];
FILE   *lastumsgid_fp;
char   lastmsgnpath[MAXLINE];
FILE   *lastmsgn_fp;

char   line[MAXLINE];
char   *ch;
int    i;


/************/
/*  PREFIX  */
/************/

printf("PREFIX/2 1.0 -- Copyright 1992 by Bob Quinlan (10/12/92)\n");

if (argc == 2)
    {
    strncpy(msgpath, argv[1], MAXLINE);
    }
else
    {
    fprintf(stderr, "No message area specified!\n");
    exit(1);
    }

/*  Open the message API  */
mi.req_version = 0;
mi.def_zone = 1;
if (MsgOpenApi(&mi) != 0)
    {
    fprintf(stderr, "Unable to initialize MsgAPI!\n");
    exit(1);
    }

/*  Open the message area  */
if ((area=MsgOpenArea(msgpath, MSGAREA_NORMAL, MSGTYPE_SQUISH)) == NULL)
    {
    fprintf(stderr, "Unable to open area %s (%d)!\n", msgpath, msgapierr);
    exit(1);
    }

/*  Lock the message area for better efficiency  */
MsgLock(area);

/*  Open the datestamp file  */
strcpy(stamppath, msgpath);
strcat(stamppath, ".pfh");
if ((stamp_fp = fopen(stamppath, "wb")) == NULL)
    {
    fprintf(stderr, "Unable to open %s\n", stamppath);
    exit(1);
    }

/*  Write datestamps to the datestamp file  */
printf("Extracting datestamps");
for (msgn = 1; msgn <= MsgGetHighMsg(area); msgn++)
    {
    /*  Read the message  */
    if ((msg=MsgOpenMsg(area, MOPEN_READ, msgn)) == NULL)
        {
        fprintf(stderr, "Unable to open message %ld for reading (%d)!\n",
              msgn, msgapierr);
        exit(1);
        }
    if (MsgReadMsg(msg, &xmsg, 0L, 0L, NULL, 0L, NULL) == -1)
        {
        fprintf(stderr, "Unable to read message %ld (%d)!\n", msgn, msgapierr);
        exit(1);
        }
    if (MsgCloseMsg(msg) != 0)
        {
        fprintf(stderr, "Unable to close message %ld (%d)!\n", msgn, msgapierr);
        exit(1);
        }
    if (fwrite(&xmsg.date_arrived, sizeof(struct _stamp), 1, stamp_fp) < 1)
        {
        fprintf(stderr, "Unable to write datestamp %ld!\n", msgn);
        exit(1);
        }
    printf(".");
    }
printf("\n");

/*  Close the datestamp file  */
fclose(stamp_fp);

/*  Open the lastread UMSGID file  */
strcpy(lastumsgidpath, msgpath);
strcat(lastumsgidpath, ".SQL");
if ((lastumsgid_fp = fopen(lastumsgidpath, "rb")) == NULL)
    {
    fprintf(stderr, "Unable to open %s\n", lastumsgidpath);
    exit(1);
    }

/*  Open the lastread msg number file  */
strcpy(lastmsgnpath, msgpath);
strcat(lastmsgnpath, ".pfl");
if ((lastmsgn_fp = fopen(lastmsgnpath, "wb")) == NULL)
    {
    fprintf(stderr, "Unable to open %s\n", lastmsgnpath);
    exit(1);
    }

printf("Converting message numbers");
/*  Convert and write lastread message numbers  */
while (fread(&umsgid, sizeof(UMSGID), 1, lastumsgid_fp) > 0)
    {
    if ((msgn = MsgUidToMsgn(area, umsgid, UID_NEXT)) == 0)
        {
        msgn = 1;
        }
    if (fwrite(&msgn, sizeof(dword), 1, lastmsgn_fp) < 1)
        {
        fprintf(stderr, "Unable to write lastread pointer.\n");
        exit(1);
        }
    printf(".");
    }
printf("\n");

/*  Close the lastread msg number file  */
fclose(lastmsgn_fp);

/*  Close the lastread UMSGID file  */
fclose(lastumsgid_fp);

/*  Unlock the message area  */
MsgUnlock(area);

/*  Close the message area  */
if (MsgCloseArea(area) != 0)
    {
    fprintf(stderr, "Unable to close area %s (%d)!\n", msgpath, msgapierr);
    exit(1);
    }

/*  Close the message API  */
if (MsgCloseApi() != 0)
    {
    fprintf(stderr, "Unable to deinitialize MsgAPI!\n");
    exit(1);
    }

return 0;
}


