/*

POSTFIX -- Restores lastread pointers after SQFIX

Version 1.0  (10/12/92)

Written by Bob Quinlan of Austin, Texas, USA
Sysop of Red October at 512-834-2593 (1:382/111)

Copyright 1992 by Bob Quinlan

Compatible with Maximus 2.00 and 2.01


This program is intended to be run after SQFIX and various other
utilities that reset the lastread pointers.  It reads a pair of files
(areaname.PFH and areaname.PFL) generated by PREFIX to determine what
lastread pointers assignments to restore.

It uses arrival datestamps to determine where to restore the lastread
pointers.  This will usually put the lastread pointers back on the exact
messages where they were originally, but it may occasionally be off by a
few messages.

See the instruction to PREFIX before using POSTFIX.

POSTFIX must be followed by the name of a message area.  It will attempt
to restore the lastread pointers for that area.  When it is finished it
will delete the .PF? files created by PREFIX.


POSTFIX returns ERRORLEVEL 0 after a successful run.  ERRORLEVEL 1 is
returned to indicate an error.

NOTICE:  You may use, copy, and distribute this program freely as long
as you insure that both the executable and the documentation (.DOC)
files are included in the distribution package.  The source code does
not need to be included.  You may modify this program and document, so
long as reasonable credit is given to the original author if a
substantial portion of the original remains intact.  The author is not
responsible for any losses which may occur either directly or indirectly
as a result of using this program.

This program uses the Squish MsgAPI and the Maximus structures written
by Scott J. Dudley.  "Squish" is a trademark of Scott J. Dudley.

HISTORY:
Version 1.0  (10/12/92) -- Original release.  Written in Borland C.

Large memory model

OS/2 version (8/22/93) -- Ported using IBM's C SET/2 by Richard Butler
                        - no code changes made to POSTFIX.C
*/

/* Needed for use with MSGAPI modified for C SET/2 */

#define __386__
#define __MSC__
#define _MSC_VER 600
#define OS_2
#define msgapierr _msgapierr

/* end */

#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <io.h>
/* #include <mem.h>
   #include <dos.h */
#include <share.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys\stat.h>
#include <sys\types.h>
#include "prog.h"     /* From MsgAPI by Scott J. Dudley modified for C SET/2 */
#include "alc.h"      /* From MsgAPI by Scott J. Dudley modified for C SET/2 */
#include "msgapi.h"   /* From MsgAPI by Scott J. Dudley modified for C SET/2 */
#include "mstruct.h"  /* Maximus structures by Scott J. Dudley: modified
                         to avoid duplicate definitions of datestamps  */

#define MAXLINE     (128)
#define MAXNAME     (36)


int stampcmp(struct _stamp *ds1, struct _stamp *ds2);


typedef struct
    {
    struct _stamp stamp;
    UMSGID umsgid;
    } MSG_DATA;


int main(int argc, char *argv[])
{
struct _area arearef;
XMSG   xmsg;
MSG    *area;
MSGH   *msg;
UMSGID uid;
struct _minf mi;
UMSGID umsgid;
dword  msgn;
dword  match;
int    exact;

char   msgpath[MAXLINE];
char   stamppath[MAXLINE];
FILE   *stamp_fp;
char   lastmsgnpath[MAXLINE];
FILE   *lastmsgn_fp;
char   lastumsgidpath[MAXLINE];
FILE   *lastumsgid_fp;

long   messages;
MSG_DATA *new;
long   stamps;
struct _stamp *old;
UMSGID *msgindex;

char   line[MAXLINE];
char   *ch;
int    i, j;


/*************/
/*  POSTFIX  */
/*************/

printf("POSTFIX/2 1.0 -- Copyright 1992 by Bob Quinlan (10/12/92)\n");

if (argc == 2)
    {
    strncpy(msgpath, argv[1], MAXLINE);
    }
else
    {
    fprintf(stderr, "No message area specified!\n");
    exit(1);
    }

/*  Open the message API  */
mi.req_version = 0;
mi.def_zone = 1;
if (MsgOpenApi(&mi) != 0)
    {
    fprintf(stderr, "Unable to initialize MsgAPI!\n");
    exit(1);
    }

/*  Open the message area  */
if ((area=MsgOpenArea(msgpath, MSGAREA_NORMAL, MSGTYPE_SQUISH)) == NULL)
    {
    fprintf(stderr, "Unable to open area %s (%d)!\n", msgpath, msgapierr);
    exit(1);
    }

/*  Allocate space for the message data array  */
messages = MsgGetHighMsg(area);
new = calloc(messages, sizeof(MSG_DATA));

/*  Lock the message area for better efficiency  */
MsgLock(area);

/*  Read in message datestamps and umsgids  */
for (msgn = 1; msgn <= messages; msgn++)
    {
    /*  Read the message  */
    if ((msg=MsgOpenMsg(area, MOPEN_READ, msgn)) == NULL)
        {
        fprintf(stderr, "Unable to open message %ld for reading (%d)!\n",
              msgn, msgapierr);
        exit(1);
        }
    if (MsgReadMsg(msg, &xmsg, 0L, 0L, NULL, 0L, NULL) == -1)
        {
        fprintf(stderr, "Unable to read message %ld (%d)!\n", msgn, msgapierr);
        exit(1);
        }
    new[msgn-1].stamp = xmsg.date_arrived;
    new[msgn-1].umsgid = MsgMsgnToUid(area, msgn);
    if (MsgCloseMsg(msg) != 0)
        {
        fprintf(stderr, "Unable to close message %ld (%d)!\n", msgn, msgapierr);
        exit(1);
        }
    }

/*  Unlock the message area  */
MsgUnlock(area);

/*  Close the message area  */
if (MsgCloseArea(area) != 0)
    {
    fprintf(stderr, "Unable to close area %s (%d)!\n", msgpath, msgapierr);
    exit(1);
    }

/*  Close the message API  */
if (MsgCloseApi() != 0)
    {
    fprintf(stderr, "Unable to deinitialize MsgAPI!\n");
    exit(1);
    }

/*  Open the datestamp file  */
strcpy(stamppath, msgpath);
strcat(stamppath, ".pfh");
if ((stamp_fp = fopen(stamppath, "rb")) == NULL)
    {
    fprintf(stderr, "Unable to open %s\n", stamppath);
    exit(1);
    }

/*  Allocate space for the message index array  */
stamps = filelength(fileno(stamp_fp))/sizeof(struct _stamp);
old = calloc(stamps, sizeof(struct _stamp));

/*  Read in the datestamps  */
if (fread(old, sizeof(struct _stamp), stamps, stamp_fp) < stamps)
    {
    fprintf(stderr, "Unable to read %s\n", stamppath);
    exit(1);
    }

/*  Close the datestamp file  */
fclose(stamp_fp);

/*  Delete the datestamp file  */
remove(stamppath);

/*  Allocate space for the message index array  */
msgindex = calloc(stamps, sizeof(UMSGID));

/*  Correlate datestamps with new messages and store their umsgid values  */
printf("Finding equivalent messages");
for (i = 0; i < stamps; i++)
    {
    match = 0;
    exact = 0;
    for (j = 0; j < messages; j++)
        {
        if (stampcmp(&new[j].stamp, &old[i]) == 0)
            {
            match = j;
            exact = 1;
            break;
            }
        if ((!match) && (j) && (stampcmp(&new[j].stamp, &old[i]) > 0))
            {
            match = j-1;
            }
        }
    msgindex[i] = new[match].umsgid;
    if (exact)
        printf(".");
    else
        printf(":");
    }
printf("\n");

/*  Free unneeded arrays  */
free(old);
free(new);

/*  Open the lastread msg number file  */
strcpy(lastmsgnpath, msgpath);
strcat(lastmsgnpath, ".pfl");
if ((lastmsgn_fp = fopen(lastmsgnpath, "rb")) == NULL)
    {
    fprintf(stderr, "Unable to open %s\n", lastmsgnpath);
    exit(1);
    }

/*  Open the lastread UMSGID file  */
strcpy(lastumsgidpath, msgpath);
strcat(lastumsgidpath, ".SQL");
if ((lastumsgid_fp = fopen(lastumsgidpath, "wb")) == NULL)
    {
    fprintf(stderr, "Unable to open %s\n", lastumsgidpath);
    exit(1);
    }

printf("Converting message numbers");
/*  Convert and write lastread message numbers  */
while (fread(&msgn, sizeof(dword), 1, lastmsgn_fp) > 0)
    {
    umsgid = msgindex[msgn-1];
    if (fwrite(&umsgid, sizeof(UMSGID), 1, lastumsgid_fp) < 1)
        {
        fprintf(stderr, "Unable to write lastread pointer.\n");
        exit(1);
        }
    printf(".");
    }
printf("\n");

/*  Close the lastread UMSGID file  */
fclose(lastumsgid_fp);

/*  Close the lastread msg number file  */
fclose(lastmsgn_fp);

/*  Delete the lastread msg number file  */
remove(lastmsgnpath);

/*  Free array  */
free(msgindex);

return 0;
}


int stampcmp(struct _stamp *ds1, struct _stamp *ds2)
{
if (ds1->date.yr > ds2->date.yr)
    return 1;
if (ds1->date.yr < ds2->date.yr)
    return -1;

if (ds1->date.mo > ds2->date.mo)
    return 1;
if (ds1->date.mo < ds2->date.mo)
    return -1;

if (ds1->date.da > ds2->date.da)
    return 1;
if (ds1->date.da < ds2->date.da)
    return -1;

if (ds1->time.hh > ds2->time.hh)
    return 1;
if (ds1->time.hh < ds2->time.hh)
    return -1;

if (ds1->time.mm > ds2->time.mm)
    return 1;
if (ds1->time.mm < ds2->time.mm)
    return -1;

if (ds1->time.ss > ds2->time.ss)
    return 1;
if (ds1->time.ss < ds2->time.ss)
    return -1;

return 0;
}


