/*******************************************************************************
module name:  EXISTS
author:       Karl Boyken
date:         3/13/92
OS:           MS-DOS
compiler:     MicroSoft C 6.0
purpose:      EXISTS is a script utility that performs the same function as
              the DOS batch file exists conditional.  EXISTS takes exactly
              one parameter, the string to be tested.  If more or less
              than one parameter exists, or if the string does not specify an
              existing file or directory, EXISTS returns 1.  It returns 0 if
              the string matches a file or directory.
*******************************************************************************/


#include <dos.h>

int main(int argc, char *argv[]) {
unsigned attributes;  /* for _dos_getfileattr */

  /* Check number of arguments */
  if ((argc < 2) || (argc > 2)) {
    return 1;
  }

  /* Get file attributes to see if file or directory exists */
  if (_dos_getfileattr(argv[1], &attributes)) {
    return 1;
  }
  return 0;
}
