/*******************************************************************************
module name:  STALEFIL
author:       Karl Boyken
date:         3/13/92
OS:           MS-DOS
compiler:     MicroSoft C 6.0
purpose:      STALEFIL determines whether a certain number of days have 
              elapsed since a file has been updated.  STALEFIL takes exactly
              two parameters, in this order:  the string specifying the file,
              and the number of days to use to determine whether or not the
              file is stale.

              If more or less than two parameters exist, or if the string 
              does not specify an existing file, or if the file is older than
              the number of days specified, STALEFIL returns 1.  It returns 0
              if successful. 

              Note that the computation of the number of days that have
              passed since the file's last update is fairly crude.  The
              method used does not take into account leap years.
*******************************************************************************/

#include <stdio.h>
#include <fcntl.h>
#include <dos.h>

int main(int argc, char *argv[]) {
  int fh;                              /* file handle          */
  int i;                               /* iterator             */
  int retval;                          /* function result      */
  unsigned int cutoff = 0;             /* target age, in days  */
  struct dosdate_t cur_date;           /* current date         */
  unsigned int age = 0;                /* age of file, in days */
  unsigned char file_day;              /* file day             */
  unsigned char file_month;            /* file month           */
  unsigned int file_year;              /* file year            */
  unsigned file_date;                  /* file date            */
  unsigned file_time;                  /* file time            */
  unsigned int days_per_month[12] = {  /* days/month table     */
    31,   /* January   */
    28,   /* February  */
    31,   /* March     */
    30,   /* April     */
    31,   /* May       */
    30,   /* June      */
    31,   /* July      */
    31,   /* August    */
    30,   /* September */
    31,   /* October   */
    30,   /* November  */
    31};  /* December  */

  /* Check arguments */
  if ((argc < 3) || (argc > 3)) {
    return 1;
  }
  retval = sscanf(argv[2], "%d", &cutoff);
  if ((retval == EOF) || (retval == 0)) {
    return 1;
  }

  /* Get current date */
  _dos_getdate(&cur_date);

  /* Get file date */
  if (_dos_open(argv[1], O_RDONLY, &fh)) {
    return 1;
  }
  if (_dos_getftime(fh, &file_date, &file_time)) {
    _dos_close(fh);
    return 1;
  }
  _dos_close(fh);

  /* Convert file date to comparable format */
  file_day = file_date & 0x001f;
  file_month = (file_date >> 5) & 0x000f;
  file_year = (file_date >> 9) + 1980;

  /* Determine file age */
  if (cur_date.year > file_year)  {
    age = days_per_month[file_month - 1] - file_day;
    for (i = file_month; i < 12; i++)
      age += days_per_month[i];
    age += (cur_date.year - file_year) * 365;
    for (i = 0; i < cur_date.month - 1; i++)
      age += days_per_month[i];
    age += cur_date.day;
  }
  else if (cur_date.year == file_year) {
    if (cur_date.month > file_month) {
      age = days_per_month[file_month - 1] - file_day;
      for (i = file_month; i < 12; i++)
        age += days_per_month[i];
      for (i = 0; i < cur_date.month - 1; i++)
        age += days_per_month[i];
      age += cur_date.day;
    }
    else if (cur_date.month == file_month) {
      if (cur_date.day > file_day)
        age = cur_date.day - file_day;
    }
  }

  /* Test file age */
  if (age > cutoff) {
    return 1;
  }

  return 0;
}
