/*******************************************************************

  IPXLIB.C V1.00
  Copyright (c) 1992 by Kurt Duncan - All Rights Reserved

  Library of functions based on the Novell IPX transport mechanism

*******************************************************************/


#include <dos.h>
#include "ipxlib.h"


/***********************************************************************
  IPX_Is_Loaded
***********************************************************************/

unsigned int IPX_Is_Loaded (void) {
    union  REGS regs;

    regs.x.ax = 0x7A00;
    int86 (0x2F, &regs, &regs);
    if (regs.h.al != 0xFF) return (0);
    return (1);
    }


/***********************************************************************
  IPX_Open_Socket
***********************************************************************/

unsigned int IPX_Open_Socket (unsigned int Socket_Number) {
    union REGS regs;

    regs.x.bx = 0x00;    /* IPX function 00h */
    regs.h.al = 0x00;    /* Longevity code 00h (close at end of pgm) */
    regs.x.dx = IPX_Flipword (Socket_Number);
    int86 (0x7A, &regs, &regs);
    return (regs.h.al);
    }


/***********************************************************************
  IPX_Close_Socket
***********************************************************************/

void IPX_Close_Socket (unsigned int Socket_Number) {
    union REGS regs;

    regs.x.bx = 0x01;    /* IPX function 01h */
    regs.x.dx = IPX_Flipword (Socket_Number);
    int86 (0x7A, &regs, &regs);
    return;
    }


/***********************************************************************
  IPX_Get_Local_Target
***********************************************************************/

unsigned int IPX_Get_Local_Target (struct IPX_address far *Destination,
                                   struct IPX_node    far *Target) {
    union  REGS regs;
    struct SREGS sregs;

    segread (&sregs);
    regs.x.bx = 0x02;
    sregs.es  = FP_SEG (Destination);
    regs.x.si = FP_OFF (Destination);
    regs.x.di = FP_OFF (Target);
    int86x (0x7A, &regs, &regs, &sregs);
    return (regs.x.cx);
    }


/***********************************************************************
  IPX_Send_Packet
***********************************************************************/

void IPX_Send_Packet (struct IPX_ECB far *ECB) {
    union  REGS regs;
    struct SREGS sregs;

    segread (&sregs);
    regs.x.bx = 0x03;
    sregs.es  = FP_SEG (ECB);
    regs.x.si = FP_OFF (ECB);
    int86x (0x7A, &regs, &regs, &sregs);
    return;
    }


/***********************************************************************
  IPX_Listen_For_Packet
***********************************************************************/

void IPX_Listen_For_Packet (struct IPX_ECB far *ECB) {
    union  REGS regs;
    struct SREGS sregs;

    segread (&sregs);
    regs.x.bx = 0x04;
    sregs.es  = FP_SEG (ECB);
    regs.x.si = FP_OFF (ECB);
    int86x (0x7A, &regs, &regs, &sregs);
    return;
    }


/***********************************************************************
  IPX_Cancel_Event
***********************************************************************/

void IPX_Cancel_Event (struct IPX_ECB far *ECB) {
    union  REGS regs;
    struct SREGS sregs;

    segread (&sregs);
    regs.x.bx = 0x06;
    sregs.es  = FP_SEG (ECB);
    regs.x.si = FP_OFF (ECB);
    int86x (0x7A, &regs, &regs, &sregs);
    return;
    }


/***********************************************************************
  IPX_Get_Internetwork_Address
***********************************************************************/

void IPX_Get_Internetwork_Address (struct IPX_address far *Address) {
    union  REGS regs;
    struct SREGS sregs;

    segread (&sregs);
    regs.x.bx = 0x09;
    sregs.es  = FP_SEG (Address);
    regs.x.si = FP_OFF (Address);
    int86x (0x7A, &regs, &regs, &sregs);
    return;
    }


/***********************************************************************
  IPX_Relinquish_Control
***********************************************************************/

void IPX_Relinquish_Control (void) {
    union REGS regs;

    regs.x.bx = 0x0A;
    int86 (0x7A, &regs, &regs);
    return;
    }


/***********************************************************************
  IPX_Flipword
***********************************************************************/

unsigned int IPX_Flipword (unsigned int Inword) {
    unsigned char c1, c2;

    c1 = Inword >> 8;
    c2 = Inword & 0xFF;
    return ( (unsigned int) (c2 << 8) | c1);
    }


/***********************************************************************
  IPX_Fliplong
***********************************************************************/

void IPX_Fliplong (unsigned long *Inlong) {
    unsigned char c1, c2, c3, c4;

    c1 = *Inlong >> 24;
    c2 = (*Inlong >> 16) & 0xFF;
    c3 = (*Inlong >> 8) & 0xFF;
    c4 = *Inlong & 0xFF;

    *Inlong = (unsigned long) (
              ( (unsigned long) c4 << 24) | 
              ( (unsigned long) c3 << 16) | 
              ( (unsigned long) c2 << 8)  | 
              ( (unsigned long) c1 ));
    return;
    }
