/* ======================================================================
** Program CALL.C.
**
** Copyright, (c) 1989, 1990, 1991, 1992, Sean R. Kirkpatrick
**
** Released into the public domain, September 1, 1992.
**
** This program implements a simple telephone book.  A list of data,
** separated by by '^' (caret) symbols is read from disk.  The parameter(s)
** on the command line represent text to search for in the file.  The
** entries of this file look something like this:
**
**   ^
**   first line of text
**   second line of text
**   ...
**   last line of text
**   ^
**
** Each ^ must be the first character on the line.  This starts a new
** record.  Any amount of text may appear in between carets, subject to
** an 80 character limit on each line.
**
** Modification History
** ======================================================================= 
** Date              Rev     Who     What
** -----------------------------------------------------------------------
** 6/7/89    1.0     SRK     Created
** 6/8/89    1.1     SRK     Added to SCCS
** 6/8/89    1.2     SRK     Minor bug fixes
** 6/9/89    1.3     SRK     Implemented addName
** 6/12/89   1.4     SRK     Implemented delName
** 6/15/89   1.5     SRK     Migrated to RCS from SCCS
** 4/19/91   1.6     SRK     Port to Power C
** =======================================================================
*/

static char _ver[] = "1.6 91/04/19";

#define ANSI
#define PWR_C
#undef RCS      /* not under RCS control, don't have a version for DOS */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <malloc.h>
#include <time.h>

#ifndef ANSI
#include <file.h>
#endif

#ifdef PWR_C
#include <conio.h>
#endif

#define LINESIZE 81
#define FALSE 0
#define TRUE !FALSE
#define BUFFSIZE 512

struct LineRec {
     struct LineRec * next;
     char info[LINESIZE];
};

typedef struct LineRec LineRecType;

LineRecType  * lineRec;
LineRecType  * pHead;
LineRecType  * pTail;

FILE * fh;
char * callFile;
char   defaultFile[100];

char tm[40];
long t;
time_t timer;

int Found;
int RemoveName;

/* =============================================================== */

void pause()
{
    int c;

    printf( "--- press any key to continue ---" );

#ifdef PWR_C
    c = getch();
#else
    c = getchar();
#endif

} /* pause */

/* =============================================================== */

void display_help()
{
printf( "HELP\n\n" );

printf( "Usage: Call [who | +who{,text} | -who] | HELP]\n" );
printf( "\n");
printf( "This program searches a text file for an entry that matches the\n" );
printf( "name supplied on the command line.\n" );
printf( "The file that is searched is called Phones.Txt and it can be\n" );
printf( "located in the current directory, or in a directory specified\n");
printf( "in the DOS environment variable PHONES.  Using a DOS environment\n" );
printf( "has the advantage that the file will always be available to this\n" );
printf( "program regardless of the currently logged directory.\n" );
printf( "\n" );
printf( "You can add this string to your environment by adding a new line\n" );
printf( "to your AUTOEXEC.BAT file: SET PHONES=A:\PHONES.TXT.\n" );
printf( "\n" );
printf( " The format of the phone file is:\n" );
printf( "\n" );
printf( "    ^\n" );
printf( "    name\n" );
printf( "    any text\n" );
printf( "    any number of lines\n" );
printf( "    ^\n" );
pause();
printf( "\n" );
printf( "The carrets serve as text delimiters and must be in column 1.\n" );
printf( "Otherwise the format of the file is free form.  All text between\n" );
printf( "carrets will be displayed if a match is found, otherwise an error\n" );
printf( "message will be displayed.\n" );
printf( "\n" );
printf( "Any number of entries may be included within the file, and\n" );
printf( "there is no limit on the number of lines in each entry.  Upper \n" );
printf( "and lower case letters are not significant, as the program will \n" );
printf( "convert all characters to uppercase before checking for a match.\n" );

} /* display_help */

/* =============================================================== */

void upline( char * l )
{
    while ( (*l != '\n') && (*l != '\0') ) {
        if ( isalpha( *l ) && islower( *l ) )
            *l = toupper( *l );
        *++l;
    }
} /* upline */

/* =============================================================== */

int strindex( s, t )
char *s, *t;
{
/*
** out of K&R, check it out
**
** sure wish my compiler had one of these
*/
     int i, j, k;

     upline( s ); 
     upline( t );

     for ( i = 0; s[i] != '\0'; i++ ) {
             for ( j=i,k=0; t[k] != '\0' && s[j] == t[k];  j++, k++ )
                     ;
             if ( k > 0 && t[k] == '\0' )
                     /* found */
                     return i;
     } /* for */

     /* not found */
     return -1;

} /* strindex */

/* =============================================================== */

void init()

{
    /* 
    ** if successful, this routine returns to main with a properly
    ** opened phone file, otherwise, it returns to the system.
    */
     strcpy( defaultFile, "phones.txt" );

     if ( ( callFile = getenv( "PHONES" ) ) == NULL ) 
             callFile = defaultFile;
     
     if ( ( fh = fopen( callFile, "r" ) ) == NULL ) {
             printf( "Trouble opening: %s!\n\n", callFile );
             exit( 1 );
     }
     
} /* init */

/* =============================================================== */

void displayName( p )
LineRecType * p;
{
     
    int x = 0;
    pTail = p;

	printf( "\n //======================================================\\\\\n" );
	while ( ( pTail != NULL ) && (pTail->info[0] != '^' ) ) {
		printf( "|| " );
		for ( x = 0; pTail->info[x] != '\n' && pTail->info[x] != '\0'; x++ )
			putchar( pTail->info[x] );
		for ( x = 3 + strlen( pTail->info ); x < 59; x++ )
			putchar( ' ' );
		printf( "||\n" );
        pTail = pTail->next;
	}

	printf( " \\\\======================================================//\n" );
} /* displayName */

/* =============================================================== */

void delName( p )
LineRecType * p;
{
     /*
     ** when we enter, we've found an entry that matches the 
     ** command line spec.  Ask if it's ok to delete the record.
     */

     int ch;

     RemoveName = FALSE;

     printf( "Delete this entry? y/n " );

#ifdef PWR_C
    ch = getch();
#else
    ch = getchar();
#endif

     if ( ch != 'Y' && ch != 'y' ) 
             return;

     /*
     ** when we get here, pTail points to the beginning  of the entry
     ** to be deleted.  We need to rewrite the file to eliminate it.
     */

     if ( ( fh = fopen( callFile, "w" ) ) == NULL ) {
             printf( "Trouble opening: %s!\n\n", callFile );
             exit( 1 );
     }

     pTail = pHead; /* start of the top of the list */
     while ( pTail != NULL ) {
             if ( pTail == p ) {
                     /* skip the entry */
                     pTail = pTail->next;

                     while ( ( pTail != NULL ) && ( pTail->info[0] != '^' ) )
                             pTail = pTail->next;

                     /* skip past the ending ^ in the deleted entry */

                     if ( pTail->info[0] == '^' )
                             pTail = pTail->next;
             } /* while */
             else {
                     fprintf( fh, "%s", pTail->info );
                     pTail = pTail->next;
             } /* else */
     } /* while */
} /* delName */

/* =============================================================== */

void scanList( who )
char * who;
{
     LineRecType * p;
     pTail = pHead;

     while( pTail != NULL ) {
             if ( pTail->info[0] == '^' ) {
                     /* get out if done */
                     if ( pTail->next == NULL )
                             return;

                     pTail = pTail->next;
                     p = pTail;

                     while ( ( pTail != NULL ) && (pTail->info[0] != '^' ) ) {
                             if ( strindex( pTail->info, who ) != -1 ) {
                                     /*
                                     ** found a match, display the entry
                                     */
                                     Found = TRUE;
                                     displayName( p );

                                     if ( RemoveName ) {
                                             delName( p );
                                     } /* if */
                             } /* if */
                             else
                                     pTail = pTail->next;
                     } /* while */
             } /* if */
             else
                     pTail = pTail->next;
     } /* while */
} /* scanList */

/* =============================================================== */

void buildList()
{
     char line[LINESIZE];

     pHead = NULL;
     pTail = pHead;

     while ( ( fgets( line, LINESIZE,  fh ) ) != NULL ) {
             if ( ( lineRec = (LineRecType *) malloc( sizeof( LineRecType ) ) ) == NULL ) {
                     printf( "\nMemory allocation error\n\n" );
                     exit( 1 );
             }
             else {
                     strcpy( lineRec->info, line );

                     if ( pHead == NULL ) {
                             pHead = lineRec;
                             pTail = lineRec;
                             pHead->next = pTail;
                     } else {
                             pTail->next = lineRec;
                             pTail = lineRec;
                             pTail->next = NULL;
                     } /* else */                    
             } /* else */
     } /* while */

} /* buildList */

/* =============================================================== */

void addName( argc, argv )
int argc;
char *argv[];
{
     int x;
     char *s;
     char *b;
     char line[LINESIZE];
     char buff[BUFFSIZE];

     /*
     ** open the file for update at EOF 
     */
     if ( ( fh = fopen( callFile, "a+" ) ) == NULL ) {
             printf( "Trouble opening: %s!\n\n", callFile );
             exit( 1 );
     }
     
     if ( argc > 1 ) {
             /* 
             ** the data to be written to the file comes from the 
             ** command line.
             */
             for ( x = 0; x < argc; x++ ) {
                     /* 
                     ** get all of the data from the command line                                    ** put it in 'buff'
                     */
                     strcat( buff, argv[x] );
                     strcat( buff, " " );
             } /* for */

             /*
             ** pick apart the buffer
             ** get all up to the ','
             ** put it in 'line'
             ** write 'line' to file
             ** loop
             */

             b = buff;
             while ( ( s = strtok( b, "," )  ) != NULL ) {
                     strcpy( line, s );
                     fprintf( fh, "%s\n", line );    
                     b = NULL;
             } /* while */   

             /* 
             ** print out the time of this addition
             */
             t = time( timer );
             fprintf( fh, "\n%s", asctime( localtime(&t) ) );

             fprintf( fh, "%c\n", '^' );             
             fclose( fh );
             return;
     } /* if */

     /*
     ** if we get this far, only a + appears on the command line.
     ** get input interactively.
     */
     printf( "Enter the data you wish to store.  Place a period as the only entry on the line to end input\n\n" );

     for ( ; ; ) {   
             x = 0;
             
             if ( ( fgets( line, sizeof( line ), stdin ) == NULL )
                || ( line[0] == '.' )  ) {
                     /* 
                     ** save the time of this addition
                     */
                     t = time( timer );
                     fprintf( fh, "\n%s", asctime( localtime(&t) ) );

                     fprintf( fh, "%c\n", '^' );
                     fclose( fh );
                     return;
             }
             else {
                     fprintf( fh, "%s", line );              
             }
     } /* for */
} /* addName */

/* =============================================================== */

main( argc, argv )
int argc;
char * argv[];
{

     int x;
     char *ver;

     ver = _ver;

#ifdef RCS
     while( ! isdigit( *++ver ) && *ver ) ;
#endif

     printf( "Call v%s, Copyright 1989, 1990, 1991, Sean R. Kirkpatrick, all rights reserved\n\n", ver );

     if ( argc < 2 ) {
            display_help();
            exit(0);
     }

     init();
  
     buildList();

     printf( "\n==============================================================\n" );


     for ( x = 1; x < argc; x++ ) {
             Found = FALSE;


             if ( *argv[x] == '+' ) {
                     *++argv[x];
                     addName( argc - x, &argv[x] );
                     return;
             }
             else if ( *argv[x] == '-' ) {
                     /*
                     ** going to remove the name specified
                     ** advance past the '-'
                     */
                     *++argv[x];
                     RemoveName = TRUE;
             } /* else */

             upline( argv[x] );

             printf( "\n\nSearching for %s...", argv[x] );

             scanList( argv[x] );

             if ( Found ) 
                     Found = FALSE;
             else 
                     printf( "not found!\n" );
     } /* for */

} /* call */

