;
;                             C O M M U N I Q U 
;
;                       
;                      Quick Modem Setup Utility Datafile
;                       
;
;  Date: 3rd July 1993
;
;  "MODEM      <str>"   Defines the modem name
;  "SPEED      <num>"   Sets the maximum speed of the modem
;  "INIT       <str>"   Sets the initialisation string in Communiqu
;  "PREFIX     <str>"   Sets the DIAL PREFIX 1 in Communiqu
;  "SUFFIX     <str>"   Sets the DIAL SUFFIX 1 in Communiqu
;  "CANCEL     <str>"   Sets the DIAL CANCEL string in Communiqu
;  "RINGSTR[1] <str>"   Sets the strings returned by the modem after dialling
;  "RINGSTR[2] <str>"     "                   "                         "
;  "RINGSTR[3] <str>"     "                   "                         "
;  "RINGSTR[4] <str>"     "                   "                         "
;  "HANGUP     <str>"   Sets the DISCONNECT string in Communiqu
;  "ANSWER     <str>"   Sets the AUTO ANSWER string in Communiqu
;  "TOGGLE DTR      "   Turns TOGGLE DTR on in Communiqu
;  "DTR        <num>"   Sets the DROP DTR TIME in Communiqu
;  "BREAK      <num>"   Sets the BREAK TIME in Communiqu
;  "HFLOW           "   Turns HARDWARE FLOW CONTROL on in Communiqu
;  "SFLOW           "   Turns SOFTWARE FLOW CONTROL on in Communiqu
;
;  "SWTICH     <str>"   Display text concerning external switch settings (1..6)
;  "NOTE       <str>"   Display other notes concerning the modem setup (1..6)
;  "SETUP      <str>"   Modem initialisation to be sent immediately (1..4)
;
;
;  NOTES: o Any settings not entered in the modem definition will be given
;           Communiqu's default generic modem settings.
;         o These commands may be in any order.
;
;
--------------------------------------------------------------------------------

MODEM  Anchor 2400i internal half-card
SPEED  2400
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
BREAK  200
DTR    500
TOGGLE DTR
NOTE   Your 2400 baud modem is ready to go!

--------------------------------------------------------------------------------

MODEM  AST 2X9600
SPEED  19200
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
ANSWER ATA|
TOGGLE DTR
SWITCH Switch Settings:    FRONT 1 2 3 4 5 6 7 8 9 10
SWITCH                           U D D U D U U D X X
SWITCH                     REAR  1 2 3 4 5 6 7 8
SWITCH                           D D D U D U U X
SWITCH X = Not Used

--------------------------------------------------------------------------------

MODEM  ATI 2400etc
SPEED  9600
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
ANSWER ATA|

--------------------------------------------------------------------------------

MODEM  ATI 2400etc/e & 2400etc/i V.42
SPEED  9600
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
ANSWER ATA|

--------------------------------------------------------------------------------

MODEM  ATI 9600etc/e V.32/V.42
SPEED  38400
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
ANSWER ATA|
DTR    500

--------------------------------------------------------------------------------

MODEM  Cardinal 2400 MNP
SPEED  9600
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500

--------------------------------------------------------------------------------

MODEM  CompuCom Speedmodem
SPEED  19200
INIT   AT&F2%H2&D2S10=30%C0H0
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500

--------------------------------------------------------------------------------

MODEM  Digicom 9624LE / 9624PC V.32bis
SPEED  38400
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500

--------------------------------------------------------------------------------

MODEM  Digitan HiNOTE   IQ ZX1896 2400 Fax Modem
SPEED  2400
INIT   ATE1Q0V1X4&C1&D2S7=60S25=4|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
SFLOW
BREAK  500

--------------------------------------------------------------------------------

MODEM  E* Tech Bullet E9696M V.32 MNP
SPEED  19200
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500

--------------------------------------------------------------------------------

MODEM  E* Tech Bullet PC2400MH MNP
SPEED  9600
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500

--------------------------------------------------------------------------------

MODEM  Everex 12e External (EV-936)
SPEED  1200
INIT   ATE1F1H0M1Q0V1X4&C1&D2|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
SFLOW
BREAK  1000
SWITCH Switch Settings:  1   2   3   4   5   6   7   8   9
SWITCH                   On  Off Off Off Off On  Off Off Off

--------------------------------------------------------------------------------

MODEM  Everex 24e External (EV-945)
SPEED  2400
INIT   ATE1F1H0M1Q0V1X4&C1&D2|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
SFLOW
BREAK  1000
SWITCH Switch Settings:  1   2   3   4   5   6   7   8   9
SWITCH                   On  Off Off Off Off On  Off Off Off

--------------------------------------------------------------------------------

MODEM  Everex Evercom 24+ MNP
SPEED  9600
INIT   AT\C0\J0\K5\N3\Q0\V1V1E1Q0X4|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
HFLOW
BREAK  1000

--------------------------------------------------------------------------------

MODEM  Everex EverFax 24/96
SPEED  9600
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  1000
NOTE   Your Everex EverFax 24/96 is ready to go!  Be sure to read your
NOTE   modem manual and double-check the setup.

--------------------------------------------------------------------------------

MODEM  Fastcomm FDX 2424 (MNP Class-5)
SPEED  9600
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500
SWITCH All switches on the bottom of the modem should be in the
SWITCH OPEN (off) position.

--------------------------------------------------------------------------------

MODEM  Fastcomm FDX 2496
SPEED  9600
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500
SWITCH All switches on the bottom of the modem should be in the
SWTICH OPEN (off) position.

--------------------------------------------------------------------------------

MODEM  Fastcomm FDX 9696 (V.32 & MNP-5)
SPEED  19200
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500
SWTICH All switches on the bottom of the modem should be in the
SWITCH OPEN (off) position.

--------------------------------------------------------------------------------

MODEM  Forval IM14400/SA14400 V.32bis (38400 baud)
SPEED  38400
INIT   ATZ0|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500

--------------------------------------------------------------------------------

MODEM  Forval IM14400/SA14400 V.32bis (57600 baud)
SPEED  57600
INIT   ATZ0|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500

--------------------------------------------------------------------------------

MODEM  Gateway 2000 TelePath FAX/Modem (v.32bis)
SPEED  38400
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500

--------------------------------------------------------------------------------

MODEM  Generic 1200 Baud Hayes clone
SPEED  1200
INIT   ATE1Q0M1X1V1|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ^~^~^~+++^~^~^~ATH0|
HANGUP ATS0=0H0|
ANSWER ATA|
SFLOW
BREAK  1000
SWITCH If your modem has hardware switches or jumpers, be sure to set
SWITCH the modem so that it does NOT force Carrier Detect (this is
SWITCH usually switch #6).  Also, set the DTR so that is NOT forced on
SWITCH all the time (this is usually switch #1).  If your modem uses
SWITCH NRAM to store the configuration, you should use the Generic
SWITCH 1200 Baud (switchless) after this.
NOTE   Your 1200 baud modem is ready to go!  Be sure to read your modem
NOTE   manual and double-check the setup.

--------------------------------------------------------------------------------

MODEM  Generic 1200 Baud Hayes clone (switchless)
SPEED  1200
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
SFLOW
BREAK  1000
NOTE   Your 1200 baud modem is ready to go!  Be sure to read your modem
NOTE   manual and double-check the setup.

--------------------------------------------------------------------------------

MODEM  Generic 2400 baud Hayes clone
SPEED  2400
INIT   ATE1Q0M1X1V1|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ^~^~^~+++^~^~^~ATH0|
HANGUP ATS0=0H0|
ANSWER ATA|
SFLOW
BREAK  1000
SWITCH If your modem has hardware switches or jumpers, be sure to set
SWITCH the modem so that it does NOT force Carrier Detect (this is
SWITCH usually switch #6).  Also, set the DTR so that is NOT forced on
SWITCH all the time (this is usually switch #1).  If your modem uses
SWITCH NRAM to store the configuration, you should use the Generic
SWITCH 2400 (switchless) after this.
NOTE   Your 2400 baud modem is ready to go!  Be sure to read your
NOTE   modem manual and double-check the setup.

--------------------------------------------------------------------------------

MODEM  Generic 2400 Baud Hayes clone (switchless)
SPEED  2400
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
SFLOW
BREAK  1000
NOTE   Your 2400 baud modem is ready to go!  Be sure to read your
NOTE   modem manual and double-check the setup.

--------------------------------------------------------------------------------

MODEM  GVC 9600 V.42
SPEED  19200
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500

--------------------------------------------------------------------------------

MODEM  GVC SM96 V.42bis
SPEED  38400
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500

--------------------------------------------------------------------------------

MODEM  Hayes Personal Modem 2400
SPEED  2400
INIT   AT&C1&D2E1Q0|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ^~^~^~+++^~^~^~ATH0|
HANGUP ATS0=0H0|
ANSWER ATA|
SFLOW
BREAK  1000

--------------------------------------------------------------------------------

MODEM  Hayes SmartModem 1200 External
SPEED  1200
INIT   ATE1Q0M1X1V1S7=60|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ^~^~^~+++^~^~^~ATH0|
HANGUP ATS0=0H0|
ANSWER ATA|
SFLOW
BREAK  1000
SWITCH Switch Settings:    1  2  3  4  5  6  7  8  9  10
SWITCH                     U  U  D  U  D  U  U  D  U  U
SWITCH
SWITCH Note:  Early versions did not have switches 9 & 10.

--------------------------------------------------------------------------------

MODEM  Hayes SmartModem 1200B Full Card Internal
SPEED  1200
INIT   ATE1Q0M1X1V1S7=60|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ^~^~^~+++^~^~^~ATH0|
HANGUP ATS0=0H0|
ANSWER ATA|
SFLOW
BREAK  1000
SWITCH Hayes changed this version of the modem several times.
SWITCH Be aware that your modem may or may not have all of these
SWITCH switches or that these are the correct settings.  Only
SWITCH your modem manual knows for sure...
SWITCH
SWITCH Switch Settings: #2  DOWN - RJ12/RJ13 phone jack
SWITCH                      UP   - RJ11 or equivelent
SWITCH                  #3  UP   - Allow true CD
SWITCH                  #4  UP   - Allow DTR
SWITCH                      (early versions required strapping
SWITCH                       pins A-B for this function)

--------------------------------------------------------------------------------

MODEM  Hayes SmartModem 1200B Half Card Internal
SPEED  1200
INIT   ATE1Q0M1X1V1S7=60|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ^~^~^~+++^~^~^~ATH0|
HANGUP ATS0=0H0|
ANSWER ATA|
SFLOW
BREAK  1000
SWITCH Switch Settings: #2  RIGHT - RJ12/RJ13 phone jack
SWITCH                      LEFT  - RJ11 or equivelent
SWITCH                  #3  RIGHT - Allow true CD
SWITCH                  #4  LEFT  - Allow DTR

--------------------------------------------------------------------------------

MODEM  Hayes SmartModem 2400
SPEED  2400
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
SFLOW
BREAK  1000

--------------------------------------------------------------------------------

MODEM  Hayes V-Series 2400
SPEED  2400
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  1000

--------------------------------------------------------------------------------

MODEM  Hayes V-Series 9600
SPEED  19200
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  1000

--------------------------------------------------------------------------------

MODEM  Hayes V-Series 9600 V.42
SPEED  19200
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  1000

--------------------------------------------------------------------------------

MODEM  Hayes V-Series ULTRA Smartmodem 9600
SPEED  38400
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  1000

--------------------------------------------------------------------------------

MODEM  Intel  2400EX MNP
SPEED  9600
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500

--------------------------------------------------------------------------------

MODEM  Intel  9600EX V.32/V.42bis
SPEED  38400
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500

--------------------------------------------------------------------------------

MODEM  Intel 14400EX V.32bis/V.42bis
SPEED  57600
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500

--------------------------------------------------------------------------------

MODEM  Microcom AX/1200  AX/2400
SPEED  9600
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |^~|
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  1000
SWITCH Switch Settings:    FRONT 1 2 3 4 5 6 7 8
SWITCH                           U D D U D U U D
SWITCH
SWITCH                     REAR  1 2 3 4 5 6 7 8
SWITCH                           D U D U D U D U

--------------------------------------------------------------------------------

MODEM  Microcom AX/1200c AX/2400c MNP
SPEED  9600
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |^~|
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  1000
SWITCH Switch Settings:    FRONT 1 2 3 4 5 6 7 8
SWITCH                           U D D U D U U D
SWITCH
SWITCH                     REAR  1 2 3 4 5 6 7 8
SWITCH                           D U D U D U D U

--------------------------------------------------------------------------------

MODEM  Microcom AX/9624c AX/9612c
SPEED  19200
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  1000
SWITCH Switch Settings:    FRONT 1 2 3 4 5 6 7 8 9 10
SWITCH                           U D D D D U U D U U
SWITCH
SWITCH                     REAR  1 2 3 4 5 6 7 8
SWITCH                           D D D U D U D D

--------------------------------------------------------------------------------

MODEM  Microcom QX/V.32c
SPEED  38400
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  1000
SWITCH Switch Settings:    FRONT 1 2 3 4 5 6 7 8 9 10
SWITCH                           U D D U D U U D   U
SWITCH
SWITCH                     REAR  1 2 3 4 5 6 7 8
SWITCH                           D U D U D D D D

--------------------------------------------------------------------------------

MODEM  Microcom QX/4232hs
SPEED  38400
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  1000
SWITCH Switch Settings:    FRONT 1 2 3 4 5 6 7 8 9 10
SWITCH                           U D U U U D D D   U
SWITCH
SWITCH                     REAR  1 2 3 4 5 6 7 8
SWITCH                           D U D U D U U D

--------------------------------------------------------------------------------

MODEM  Multi-Tech MultiModem 224EC / 224PC  MNP
SPEED  9600
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  600
SWITCH       224EC:   Switches on Back of Edgecard
SWITCH                   1 OPEN (Up)
SWITCH                   2 OPEN (Up)
SWITCH                   3 CLOSED (Down)
SWITCH                   4 CLOSED (Down)

--------------------------------------------------------------------------------

MODEM  Multi-Tech MultiModem 224EH5 (MNP 5)
SPEED  9600
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  600
SWITCH Switch Settings on the Bottom of the modem:
SWITCH        4 Switch Bank 1 2 3 4
SWITCH                      D U D D
SWITCH        8 Switch Bank 1 2 3 4 5 6 7 8
SWITCH                      U U D U D U U D
SWITCH

--------------------------------------------------------------------------------

MODEM  Multi-Tech MultiModem 224EH7 (MNP 7)
SPEED  19200
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  600
SWITCH Switch Settings on the Bottom of the modem:
SWITCH        4 Switch Bank 1 2 3 4
SWITCH                      D U D D
SWITCH        8 Switch Bank 1 2 3 4 5 6 7 8
SWITCH                      U U D U D U U D
SWITCH
SWITCH Jumpers that need to be changed -inside- the modem:
SWITCH  CTS/RTS: toward the back of the modem.

--------------------------------------------------------------------------------

MODEM  Multi-Tech MultiModem 224PC5
SPEED  2400
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  600

--------------------------------------------------------------------------------

MODEM  Multi-Tech MultiModem 696E
SPEED  19200
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  600
SWITCH Switch Settings on the Bottom of the modem:
SWITCH        4 Switch Bank 1 2 3 4
SWITCH                      D U D D
SWITCH        8 Switch Bank 1 2 3 4 5 6 7 8
SWITCH                      U U D U D U U D
SWITCH
SWITCH Jumpers that need to be changed -inside- the modem:
SWITCH  CTS/RTS: toward the back of the modem.

--------------------------------------------------------------------------------

MODEM  Multi-Tech MultiModem 932EC
SPEED  19200
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  600
SETUP  AT&F|
SETUP  AT&E1&E4&E8&E10&E13&E15|
SETUP  AT$MB9600$SB19200$BA0&W0|

--------------------------------------------------------------------------------

MODEM  Multi-Tech MultiModem V.32
SPEED  19200
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  600
SWITCH Switch Settings on the Bottom of the modem:
SWITCH        4 Switch Bank 1 2 3 4
SWITCH                      D U D D
SWITCH        8 Switch Bank 1 2 3 4 5 6 7 8
SWITCH                      U U D U D U U D
SWITCH
SETUP  AT&F|
SETUP  AT&C1&D2B1E1M1Q0V1X4|
SETUP  AT&E1&E4&E8&E10&E13&E15|
SETUP  AT$MB9600$SB19200$BA0&W0|

--------------------------------------------------------------------------------

MODEM  Multi-Tech MultiModem V.32/V.42bis
SPEED  38400
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  600
SWITCH Switch Settings on the Bottom of the modem:
SWITCH        4 Switch Bank 1 2 3 4
SWITCH                      D U D D
SWITCH        8 Switch Bank 1 2 3 4 5 6 7 8
SWITCH                      U U D U D U U D
SWITCH
SWITCH Jumpers that need to be changed -inside- the modem:
SWITCH   Open the case and move the jumper labeled
SWITCH   RTS/CTS so that the jumper it on the CTS side.
SETUP  AT&F|
SETUP  AT&C1&D2B1E1M1Q0V1X4|
SETUP  AT&E1&E4&E8&E10&E13&E15|
SETUP  AT$MB9600$SB38400$BA0&W0|

--------------------------------------------------------------------------------

MODEM  NEC N9631 V.32 MNP
SPEED  19200
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500
SETUP  AT&F2|
SETUP  ATE1Q0&T5\Q3\V1\X1NOTE   FT1&W|

--------------------------------------------------------------------------------

MODEM  OKITEL 2400 Plus
SPEED  9600
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500
SWITCH Switch Settings:
SWITCH
SWITCH   1   2   3   4   5   6
SWITCH   OFF OFF OFF OFF OFF ON
SWITCH
SETUP  AT&F|
SETUP  AT&C1&D2%C0\J0\N3\Q3\V1S25=4&W|

--------------------------------------------------------------------------------

MODEM  Penril Alliance V.32
SPEED  19200
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500
SETUP  AT&F|
SETUP  AT&C1&D2\Q1,1&W|

--------------------------------------------------------------------------------

MODEM  Practical Peripherals PM2400
SPEED  2400
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
SFLOW
BREAK  1000
SETUP  ATB1E1L2M1Q0V1X4Y1&C1&D2&G0&J0&L0&P0|
SETUP  AT&X0&Y0S0=0S2=43&W|

--------------------------------------------------------------------------------

MODEM  Practical Peripherals PM2400SA MNP
SPEED  9600
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500
SETUP  ATB1E1L2M1Q0V1X4Y0&C1&D2&J0&P0|
SETUP  AT\A3\C1\E0\G0\J0\K5\N3\Q3\V1\X0|
SETUP  AT%C0%A0S0=0S2=43&W0|

--------------------------------------------------------------------------------

MODEM  Practical Peripherals PM9600SA V.32
SPEED  38400
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500
SETUP  AT&F|
SETUP  ATW2&C1&D2|

--------------------------------------------------------------------------------

MODEM  Quicktel Series 9600 V.32/V.42
SPEED  19200
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500
SETUP  AT&F|
SETUP  AT&C1&D2\Q3|
SWITCH On the bottom of the modem, locate the 8-Position
SWITCH DIP Switch.  Verify that switch #7 and #8 are set OFF.
SWITCH
SWITCH Open the modem and locate the 4-Position DIP Switch.
SWITCH Switch #1, #2 and #3 should be set OFF. Switch #4 should
SWITCH be set ON.

--------------------------------------------------------------------------------

MODEM  Sysdyne MDM 24H
SPEED  2400
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0M1H0|
ANSWER ATA|
TOGGLE DTR
SFLOW
BREAK  750
SWITCH Switch settings should remain at factory defaults.  If you need
SWITCH to select a different COM port other than 2, refer to your
SWITCH owners manual for detailed instructions.
SETUP  ATB1E1F1L2M1Q0V1X4Y0|
SETUP  AT&C1&D2S7=60S11=60&Y0&W0|

--------------------------------------------------------------------------------

MODEM  Telebit T2000 & Trailblazer Plus
SPEED  19200
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATH0|^~ATS0=0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  1000
SETUP  AT E1 Q0 M1 V1 W1 X14 Y0 S0=0|
SETUP  AT S50=0 S51=254 S52=4 S54=3 S58=2|
SETUP  AT S63=1 S64=0 S66=1 S67=0 S68=2 S90=0|
SETUP  AT S92=1 S94=1 S95=2 S96=1 S110=1|
SETUP  AT S111=0 S131=1 S255=0 &W1 &W2|
SWITCH This assumes the Telebit is in ECM (Enhanced Command Mode).
SWITCH To place your modem into ECM, follow these steps:
SWITCH
SWITCH  1. Start with the modem turned off and the A/B switch in the
SWITCH     A position.
SWITCH  2. Press and hold the T/D switch while turning on the modem.
SWITCH     Release the T/D switch -AFTER- the MR indicator comes on.
SWITCH
SWITCH This will store the ECM default settings in Profile A of non-
SWITHC volatile memory.

--------------------------------------------------------------------------------

MODEM  Telebit T2500
SPEED  19200
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  1500
SETUP  ATE1Q0M1X4V1S11=60|
SETUP  AT&C1&D2&G0&J0&K3&L0&P0|
SETUP  AT&Q5&W|
SWITCH This assumes the Telebit is in CCM (Conventional Command Mode).
SWITCH To place your modem into CCM, follow these steps:
SWITCH
SWITCH  1. Turn the modem off.
SWITCH  2. Hold in the T/D switch and turn the power on.  Release the
SWITCH     switch when the PEP,CD and MR lights are flashing.  Ignore
SWITCH     any other lights that may be lit from here on.
SWITCH  3. Tap the T/D switch until just the CD light is lit (not
SWITCH     flashing).  The PEP and MR lights are OFF.
SWITCH  4. Press and hold the T/D switch (2 seconds or more) until the
SWITCH     CD light is flashing again.

--------------------------------------------------------------------------------

MODEM  TwinCom 96/42i
SPEED  38400
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500
SETUP  AT&F|
SETUP  AT&C1&D2\A3&W|

--------------------------------------------------------------------------------

MODEM  UDS 2440
SPEED  9600
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  1000
SETUP  AT&F|
SETUP  ATS7=60|
SETUP  AT&C1&D2&R&T5%N8%U3%V0%K1&W|

--------------------------------------------------------------------------------

MODEM  UDS V.3224/V.3225 (V.32)
SPEED  19200
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500
SETUP  AT&F|
SETUP  ATS7=60|
SETUP  AT&C1&D2&R&T5%C1\Q3\V1&W|

--------------------------------------------------------------------------------

MODEM  USRobotics Courier 2400e and 2400PC MNP
SPEED  2400
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  1000
SWITCH External Switchblock:   1  2  3  4  5  6  7  8  9  10
SWITCH                         U  U  D  U  D  U  U  D  D  U
SWITCH
SWITCH                        Where U is UP  and  D is DOWN
SWITCH
SWITCH Note: for the 2400PC, turn the modem on it's side so
SWITCH      you can read the numbers, then the above settings
SWITCH      will make sense.
SETUP  ATE1Q0M1X6V1S7=60S11=60|
SETUP  AT&B0&H1&R2&I0&M4&N0&W|
SETUP  AT&FE0|

--------------------------------------------------------------------------------

MODEM  USRobotics Direct 1200PC internal
SPEED  1200
INIT   ATE1Q0M1X1V1S7=60|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ^~^~^~+++^~^~^~ATS0=0M0|
ANSWER ATA|
SFLOW
BREAK  500
SWITCH External Switchblock:
SWITCH      1   2   3   4
SWITCH      OFF OFF OFF OFF
SWITCH
SWITCH Jumpers:
SWITCH      J1  UP
SWITCH      J2  UP
SWITCH      J3  DOWN
SWITCH      J14 UP

--------------------------------------------------------------------------------

MODEM  USRobotics Direct 2400PC / Sportster 2400
SPEED  2400
INIT   ATE1Q0M1X6V1S7=60S11=60|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
SFLOW
BREAK  500
SWITCH External Switchblock:
SWITCH
SWITCH      1   2   3   4   5   6   7   8   9   10
SWITCH      OFF OFF ON  OFF ON  OFF OFF ON  ON  ON
SWITCH

--------------------------------------------------------------------------------

MODEM  USRobotics HST ( 96x ROM)
SPEED  19200
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500
SWITCH External switchblock: 1-UP  2-UP  3-DOWN  4-UP     5-DOWN
SWITCH                       6-UP  7-UP  8-DOWN  9-DOWN  10-UP
SWITCH                       WIDE SWITCH-UP
SETUP  ATE1Q0M1V1X7S7=60|
SETUP  AT&B1&H1&M4&N0&R2&W|

--------------------------------------------------------------------------------

MODEM  USRobotics HST (144x ROM)
SPEED  19200
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500
SWITCH External switchblock: 1-UP  2-UP  3-DOWN  4-UP     5-DOWN
SWITCH                       6-UP  7-UP  8-DOWN  9-DOWN  10-UP
SWITCH                       WIDE SWITCH-UP
SETUP  ATE1Q0M1X7V1S7=60|
SETUP  AT&B1&C1&D2&H1&M4&N0&R2&W|

--------------------------------------------------------------------------------

MODEM  USRobotics HST (144x ROM) V.42
SPEED  38400
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500
SWTICH External switchblock: 1-UP  2-UP  3-DOWN  4-UP     5-DOWN
SWITCH                       6-UP  7-UP  8-DOWN  9-DOWN  10-UP
SWITCH                       WIDE SWITCH-UP
SETUP  ATE1Q0M1X7V1S7=60|
SETUP  AT&A3&K3&B1&C1&D2&H1&M4&N0&R2&W|

--------------------------------------------------------------------------------

MODEM  USRobotics HST Dual Standard
SPEED  38400
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500
SWITCH External switchblock: 1-UP  2-UP  3-DOWN  4-UP     5-DOWN
SWITCH                       6-UP  7-UP  8-DOWN  9-DOWN  10-UP
SWITCH                       WIDE SWITCH-UP
SETUP  AT&F|
SETUP  ATB1E1Q0M1X7V1S7=60|
SETUP  AT&A2&B1&C1&D2&H1&R2&M4&N0&K0&W|

--------------------------------------------------------------------------------

MODEM  USRobotics HST Dual Standard V.42bis
SPEED  38400
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500
SWTICH External switchblock: 1-UP  2-UP  3-DOWN  4-UP     5-DOWN
SWITCH                       6-UP  7-UP  8-DOWN  9-DOWN  10-UP
SWITCH                       WIDE SWITCH-UP
SETUP  AT&F|
SETUP  ATB1E1Q0M1X7V1S7=60|
SETUP  AT&A3&B1&C1&D2&H1&R2&M4&N0&K3&W|

--------------------------------------------------------------------------------

MODEM  USRobotics HST V.32bis (Duals too)
SPEED  38400
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500
SWITCH External switchblock: 1-UP  2-UP  3-DOWN  4-UP     5-DOWN
SWITCH                       6-UP  7-UP  8-DOWN  9-DOWN  10-UP
SWITCH                       WIDE SWITCH-UP
SETUP  AT&F|
SETUP  ATE1Q0M1X7V1S7=60|
SETUP  AT&A3&K3&B1&C1&D2&H1&M4&N0&R2&W|

--------------------------------------------------------------------------------

MODEM  USRobotics MicroLink 2400
SPEED  2400
INIT   ATE1Q0M1X6V1S7=60S11=60|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
SFLOW
BREAK  500
SWITCH External Switchblock:
SWITCH
SWITCH      1   2   3   4   5   6   7   8   9   10
SWITCH      OFF OFF ON  OFF ON  OFF OFF ON  ON  ON
SWITCH

--------------------------------------------------------------------------------

MODEM  USRobotics Password 1200 internal
SPEED  1200
INIT   ATE1Q0M1X1V1S7=60|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ^~^~^~+++^~^~^~ATS0=0M0|
ANSWER ATA|
SFLOW
BREAK  500
SWTICH External Switchblock:
SWITCH      1   2   3   4
SWITCH      UP  UP  UP  UP
SWITCH
SWITCH Jumpers:
SWITCH      J1  UP
SWITCH      J2  UP
SWITCH      J3  RIGHT
SWITCH      J5  DOWN

--------------------------------------------------------------------------------

MODEM  USRobotics VARmodem 2400
SPEED  2400
INIT   ATE1Q0M1X6V1S7=60S11=60|
PREFIX ATDT
SUFFIX |
CANCEL |
TOGGLE DTR
HANGUP ATS0=0H0|
ANSWER ATA|
SFLOW
BREAK  500
SWTICH External Switchblock:
SWITCH
SWITCH      1   2   3   4   5   6   7   8   9   10
SWITCH      OFF OFF ON  OFF ON  OFF OFF ON  ON  ON
SWITCH

--------------------------------------------------------------------------------

MODEM  Ven-Tel 2400 Half Card (4 Option Switches)
SPEED  2400
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
SFLOW
BREAK  500
SWITCH Internal switchblock:
SWITCH
SWITCH   Refer to your manual for setting the COM port via
SWITCH   these switches.  This is set with switches 3 and 4.
SETUP  ATE1M1Q0X4V1&C1&D2&Y0S0=0&W|

--------------------------------------------------------------------------------

MODEM  Ven-Tel 2400 Half Card (6 Option Switches)
SPEED  2400
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ^~^~^~+++^~^~^~ATH0|
ANSWER ATA|
SFLOW
BREAK  500
SWITCH Internal switchblock:
SWITCH      1  2  3  4  5  6
SWITCH      O  C  *  *  O  *
SWITCH
SWITCH   Where  O = OPEN,  C = CLOSED
SWITCH          * = Dependent on hardware.  See manual.
SWITCH
SETUP  ATE1M1Q0X4V1S0=0|

--------------------------------------------------------------------------------

MODEM  Ven-Tel 2400-33
SPEED  9600
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500
SWITCH External switchblock:
SWITCH         1-OFF  2-OFF  3-OFF  4-OFF   5-OFF
SWITCH         6-OFF  7-ON   8-ON   9-ON   10-OFF
SETUP  AT%A13B1\C1&C1\D3&D2E1F1\G0&G0|
SETUP  AT&L0M1&M0\N3Q0\Q3&R1\T0&T4V1|
SETUP  AT\V1X4\X1Y0&W|

--------------------------------------------------------------------------------

MODEM  Ven-Tel Pathfinder 18K
SPEED  19200
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  1000
SETUP  AT&F|
SETUP  AT X3 S0=0|
SETUP  AT S51=5 S54=3 S58=2|
SETUP  AT S66=1 S68=2 S92=1 S95=2|
SETUP  AT S111=0 &W|

--------------------------------------------------------------------------------

MODEM  ViVa 24m 2400 MNP
SPEED  9600
INIT   ATZ|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500
SETUP  AT&F|
SETUP  AT&C1&D2%C0\J0\N3\Q3\V1S25=4&W|

--------------------------------------------------------------------------------

MODEM  ZOOM/Modem 2400 V.42bis
SPEED  9600
INIT   AT&F&C1&D2S36=7S95=44|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ^~^~^~+++^~^~^~ATH0|
ANSWER ATA|
HFLOW
BREAK  1000
SETUP  AT&F|
SETUP  AT&W|

--------------------------------------------------------------------------------

MODEM  ZOOM/Modem HC2400R
SPEED  2400
INIT   AT&F&C1&D2|
PREFIX ATDT
SUFFIX |
CANCEL |
TOGGLE DTR
RING
HANGUP ATS0=0H0|
ANSWER ATA|
SLOW
BREAK  1000
SETUP  AT&F|
SETUP  AT&W|

--------------------------------------------------------------------------------

MODEM  ZOOM/Modem HC2400S SendFax
SPEED  2400
INIT   AT&F&C1&D2|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
SFLOW
BREAK  1000
SETUP  AT&F|
SETUP  AT&W|

--------------------------------------------------------------------------------

MODEM  ZOOM/Modem MX2400R
SPEED  2400
INIT   AT&F&C1&D2|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
SFLOW
BREAK  1000
SETUP  AT&F|
SETUP  AT&W|

--------------------------------------------------------------------------------

MODEM  ZOOM/Modem MX2400S SendFax
SPEED  2400
INIT   AT&F&C1&D2|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ATS0=0H0|
ANSWER ATA|
TOGGLE DTR
SFLOW
BREAK  1000
SETUP  AT&F|
SETUP  AT&W|

--------------------------------------------------------------------------------

MODEM  ZOOM/Modem V.32 with V.42bis
SPEED  38400
INIT   AT&F&C1&D2S36=7S95=44|
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ^~^~^~+++^~^~^~ATH0|
ANSWER ATA|
HFLOW
BREAK  1000
SETUP  AT&F|
SETUP  AT&W|

--------------------------------------------------------------------------------

MODEM  ZyXEL U-1496, U-1496B, U-1496E/+
SPEED  57600                                                                       2
INIT   ATZ^M
PREFIX ATDT
SUFFIX |
CANCEL |
HANGUP ~~~+++~~~ATH0|
ANSWER ATA|
TOGGLE DTR
HFLOW
BREAK  500
SETUP  AT&F^M
SETUP  ATQ0M1X6V1S7=60^M
SETUP  AT&K4&B1&C1&D2&H3*E0&N0&W^M
NOTE   For the best results set your baudrate to 57600 baud, though
NOTE   if you do not have a 16550 UART installed on your serial card
NOTE   you should use 38400 baud for more reliable results.

;
;
;    
;    (c) Copyright 1993 Wandoo Valley Software Corporation and Adam Blake
;                       All Rights Reserved WorldWide
;    
;
