/*
 * rep.c - main module for rep: convert .REP packet back to text
 */

#include    <stdio.h>
#include    <time.h>
#include    <malloc.h>
#include    <clib.h>

FILE *ifp;

char subject[26];
char from[26];
char to[26];

#pragma pack(1)

/*
 * this matches the header format in a .REP packet
 */
struct _header_
 {
    char _status;
    char _msgnum[7];
    char _date[8];
    char _time[5];
    char _to[25];
    char _from[25];
    char _subject[25];
    char _passwd[12];
    char _refer[8];
    char _size[6];
    char _alive;
    int _conf;
    char _filler[3];
 } header;

char line[] = "%s\n";

/*
 * copy src to dest, up to len characters, and then remove trailing white
 * space
 */
stripcpy(dest, src, len)
char *dest, *src;
 {
    strncpy(dest, src, len);
    dest[len] = 0;
    strip(dest);
 }

/*
 * copy src to dest, up to len characters, and pad with spaces if needed
 */
padcpy(dest, src, len)
char *dest, *src;
 {
    while (*src && len)
     {
        *dest++ = *src++;
        len--;
     }
    while (len--)
      *dest++ = ' ';
 }

/*
 * process a rep file
 */
handlerep(s)
char *s;
 {
    int ch;
    int i;
    int j;
    int l;
    int type;
    long pos;
    long cpos;
    FILE *cxfp;
    FILE *dfp;
    char t[256];
    char drive[8];
    char path[256];
    char name[10];
    char ext[8];
    char cxdat[20];
    char data[20];

    /*
     * get a local copy
     */
    strcpy(t, s);
    /*
     * and chop it up
     */
    _splitpath(t, drive, path, name, ext);
    /*
     * figure what PKUNZIP will do, and then do it
     */
    sprintf(path, "pkunzip %s", s);
    system(path);
    /*
     * generate local filename
     */
    sprintf(path, "%s.MSG", name);
    sprintf(cxdat, "%s.INF", name);
    sprintf(data, "%s.TXT", name);
    /*
     * open inf file: this maps conf numbers to conf names
     */
    if ((cxfp = fopen(cxdat, "r")) == (FILE *) NULL)
     {
        printf("Can't find %s\n", cxdat);
        return;
     }
    /*
     * open .MSG file
     */
    if ((ifp = fopen(path, "rb")) == NULL)
     {
        printf("Can't find %s, check ZIP file integrity\n", path);
        fclose(cxfp);
        return;
     }
    /*
     * and output file
     */
    if ((dfp = fopen(data, "w")) == (FILE *) NULL)
     {
        printf("Can't create %s\n", data);
        fclose(cxfp);
        fclose(ifp);
        return;
     }
    /*
     * toss the first header
     */
    fread(&header, 1, 128, ifp);
    /*
     * while there's another message to process
     */
    while (fread(&header, 1, 128, ifp) == 128)
     {
        /*
         * get the conference number
         */
        stripcpy(data, header._msgnum, 7);
        i = atoi(data);
        /*
         * rewind inf file
         */
        fseek(cxfp, 0L, 0);
        /*
         * read to the appropriate line
         */
        while (fgets(data, 18, cxfp) != (char *) NULL && i--)
          ;
        strip(data);
        /*
         * output confname first
         */
        fprintf(dfp, line, data);
        /*
         * then from
         */
        stripcpy(from, header._from, 25);
        fprintf(dfp, line, from);
        /*
         * to
         */
        stripcpy(to, header._to, 25);
        fprintf(dfp, line, to);
        /*
         * subject
         */
        stripcpy(subject, header._subject, 25);
        fprintf(dfp, line, subject);
        /*
         * get the message size
         */
        stripcpy(data, header._size, 6);
        i = atoi(data);
        /*
         * save our place
         */
        pos = ftell(ifp);
        l = 0;
        /*
         * now count the lines
         */
        while (--i > 0 && fread(t, 1, 128, ifp) == 128)
          for (j = 0; j < 128; j++)
            if ((t[j] & 0xff) == 0xe3)
              l++;
        /*
         * output the numbner of lines
         */
        fprintf(dfp, "%d\n", l);
        /*
         * back to where the data starts
         */
        fseek(ifp, pos, 0);
        i = atoi(data);
        /*
         * now read and transfer the message
         */
        while (--i > 0 && fread(t, 1, 128, ifp) == 128)
         {
            for (j = 0; j < 128; j++)
             {
                if (l)
                 {
                    if ((ch = t[j] & 0xff) == 0xe3)
                     {
                        /*
                         * 0xe3's become newlines
                         */
                        fputc('\n', dfp);
                        l--;
                     }
                    /*
                     * plus some other character conversion
                     */
                    /*
                     * XXX this is where we ought to implement 7 or 8 bit
                     * conversions
                     */
                    else if ((ch >= ' ' && ch <= '~') /* XXX || type == 8 */)
                      fputc(ch, dfp);
                    else if (ch == 254)
                      fputc('+', dfp);
                    else
                      fputc('.', dfp);
                 }
             }
         }
     }
    /*
     * all done, close the files, and clean up
     */
    fclose(ifp);
    fclose(cxfp);
    fclose(dfp);
    unlink(s);
    unlink(path);
 }

main()
 {
    /*
     * use scnwld to crunch all the rep files
     * XXX do we want to only process those given to us, i.e.
     *   REP
     * with no args crunches everything, while
     *   REP ABC.REP
     * crunches abc.rep only
     */
    if (scnwld("*.rep", handlerep, 17) == 0)
      printf("Warning: no .REP files found\n");
    return(0);
 }
