;
; This script file courtesy of Paul Rino, SysOp
; The Software Cafe  *  Shreveport, LA. * (318)798-1008
;
; PROCOMM PLUS ASPECT script file - Edit Before Using!
;
; This is a generic script file for logging onto GAP BBS systems
; and transferring mail using GAPNET. Be sure you edit the file
; using the appropriate dialing entry numbers, your name and password.
; NOTE: Use this script to access your dialing directory entries.
;

proc main

;
;  Sets a few Procomm Plus system parameters.
;  Turns Alarm OFF and sets maximum dialing attemps to 150.
;  Sets PAUSE between calls to 10 seconds.
;  Disables AUTO ZMODEM to use external dsz.
;  Valid values range from 0 to 999 for both.
;

set ALARM OFF
set MODEM MAXDIAL 150
set MODEM CALLPAUSE 10
set ZMODEM AUTODLOAD OFF

;
;  Dials Dialing Directory Entries 1, 2, and 3.
;  Edit to match the Dialing directory entries for the Hub you call.
;

string ddentry
assign ddentry "1 2 3"
dial ddentry

;
;  After x number of dialing attempts, Procomm Plus will exit.
;

if not connected
quit
endif
pause 1

;
;  Wait for GAP's ANSI detect message and does a quick log on.
;  Change "Yes :" to "No : " if for some strange reason you don't use ANSI.
;

Waitfor "Yes : "
Transmit "N Q NS O^M"

;
;  Logs on using FIRSTNAME LASTNAME PASSWORD. Edit before using!
;

Waitfor "Name : "
Transmit "FIRSTNAME LASTNAME PASSWORD^M"
Pause 1

;
;  Invokes the QWK command at the prompt.
;

Waitfor "ommand : "
Transmit "QWK^M"
Pause 1

;
;  Waits for the QWK command line and issues the [D] command.
;  Edit the dsz command line if your directory structure is different.

pause 1
Waitfor "elp : "
Transmit "D^M"
Pause 1
Waitfor "*" forever
dos "dsz port 2 pB4096 ha on rz -m c:\gap\gapnet\qwk\hubname.qwk"
Waitfor "ontinue"
Transmit "^M"

;
;  Waits for the QWK command line and issues the [U] command.
;  Edit the dsz command line if your directory structure is different.
;

Pause 1
Waitfor "elp : "
Transmit "U^M"
Pause 1
dos "dsz port 2 pB4096 ha on sz -m c:\gap\gapnet\rep\hubname.rep"
Pause 1
Waitfor "elp : "

;
;  Issues the [Q] command to return to the Main Board
;  and then performs a quick logoff.
;

Transmit "q^M"
Pause 1
Waitfor "ommand : "
Transmit "g q^M"

;
;  Shuts down Procomm Plus and returns to DOS.
;

Waitfor "NO CARRIER"
quit
endproc
