/*

 * swiftbbs.h
 * structures and other typedefs for SwiftBBS programs.
 * adapted from QuickBBS' "STRUCT.264"

 * (SwiftBBS) copyright 1989, 1990, 1991 by Dana Bell

 * revised 9/3/91
 * (revisions include declaration changes to unsigned and use
 * of Reserved variables for SwiftBBS features)

*/

/*
 * Most string variables declared in this file are actually
 * null-terminated counted strings. The first [0] element is
 * the length of the string. SwiftBBS attempts to preserve that
 * count but uses strings as null terminated character arrays.
*/

#define FALSE 0
#define TRUE !FALSE


/* specify user variables as global */
/************************************/
typedef unsigned char flagtype[4];
typedef unsigned char flagdesc[31];    /* for flags.bbs file (qflag) */
typedef unsigned char gosubtype[20][9];


/*  User Configuration Information  */
/************************************/
typedef struct userrecord {
	unsigned char name[36];
	unsigned char city[26];
	unsigned char pwd[16];
	unsigned char dataphone[13];
	unsigned char homephone[13];
	unsigned char lasttime[6];
	unsigned char lastdate[9];
	unsigned char attrib;
	flagtype flags;
	unsigned int credit;
	unsigned int pending;
	unsigned int timesposted;
	unsigned int highmsgread;
	unsigned int seclvl;
	unsigned int times;
	unsigned int ups;
	unsigned int downs;
	unsigned int upK;
	unsigned int downK;
	unsigned int todayK;
	signed int elapsed;
	unsigned int len;
	unsigned int combinedptr;                    /* long in QuickBBS  */
	unsigned char lastarea;             /* used by QuickBBS for age   */
	unsigned char extraspace[5];
} USER;
/* unsigned char attributes[][12] = {
		" *Deleted* ",
		" Cls codes ",
		" More. . . ",
		" ANSI okay ",
		" *No-Kill* ",
		" Ignore DL ",
		" Full-scrn ",
		" Avatar    "                    /* Reserved in QuickBBS
	};
*/


/* System Configuration Information */
/************************************/
typedef struct boardrecord {
	unsigned char name[17];
	unsigned char type;     /* 0=Std   1=Net  2=Monitor  3=Echo       */
														/* 2=Reserved in QuickBBS  */
	unsigned char kind;     /* 0=Both  1=Pvt  2=Pub      3=Read-Only  */
	unsigned char combined;
	unsigned char aliases;
	/* flags and levels  */
	unsigned int readlevel;
	flagtype readflags;
	unsigned int writelevel;
	flagtype writeflags;
	unsigned int sysoplevel;
	flagtype sysopflags;
} BOARD;
/*    unsigned char boardtype[][12] = {
			"  Standard ",
			"  Net only ",
			"  Monitor  ",       /* Reserved in QuickBBS
			"  * Echo * ",
		};
		unsigned char boardkind[][12] = {
			"  Pub&Priv ",
			"  Private! ",
			"   Public  ",
			"  ReadOnly ",
		};
*/

typedef struct eventinfo {
	unsigned char status;         /* 0=Deleted 1=Enabled 2=Disabled   */
	unsigned char runtime[6];
	unsigned char errorlevel;
	unsigned char days;
	unsigned char forced;
	unsigned char lasttimerun[9];
} EVENT;

typedef struct configrecord {
	unsigned int commport;
	unsigned int initbaud, inittimes, answerwait;
	unsigned char modeminitstr[71];
	unsigned char modembusystr[71];
	unsigned char modeminitresp[41];
	unsigned char modembusyresp[41];
	unsigned char resp300[41];
	unsigned char resp1200[41];
	unsigned char resp2400[41];
	/* system paths   */
	unsigned char menupath[67];
	unsigned char textpath[67];
	unsigned char netpath[67];
		  /* restriction parameters  */
	unsigned int minbaud;
	unsigned int graphicsbaud;
	unsigned int xferbaud;
	unsigned char lowbaudstart[6];
	unsigned char lowbaudend[6];
	unsigned char downloadstart[6];
	unsigned char downloadend[6];
	unsigned char pagingstart[6];
	unsigned char pagingend[6];
	/* matrix information   */
	unsigned int matrixzone;
	unsigned int matrixnet;
	unsigned int matrixnode;
	unsigned int akanet[5];
	unsigned int akanode[5];
	unsigned int netmailboard;
	/* default information for new users   */
	unsigned int defaultsec;
	unsigned int defaultcredit;
	flagtype defaultflags;
	/* sysop security levels   */
	unsigned char editorcmdstr[71];
	unsigned char originline[61];
	unsigned char sysopname[36];
	unsigned char
		autologonchar,
		fastlogon,
		screenblanking,
		uselastread,
		monomode,
		directwrite,
		snowcheck,
		netechoexit,
		onewordnames,
		checkmail,
		askhomephone,
		askdataphone,
		graphicsavail;
	unsigned int
		inactivetimeout,
		logontime,
		deffgcolor,
		defbgcolor,
		passwordtries,
		maxpagetimes,
		pagebelllen;
	unsigned char
		use_xmodem,
		use_xmodem1k,
		use_ymodem,
		use_ymodemg,
		use_sealink,
		use_zmodem,
		inp_fields;
	unsigned char quotestr[4];
	unsigned int uploadcredit;
	unsigned char loadingmessage[71];
	unsigned char selectionprompt[71];
	unsigned char versionid[2];
		  /* added for 2.04 */
	unsigned char resp4800[41];
	unsigned char resp9600[41];
	unsigned int akazone[5];
	/* added for 2.60 */
	unsigned int matrixpoint;
	unsigned int akapoint[5];
	unsigned char useaka[200];
	unsigned char askage;
	unsigned char systemname[41];
	long regkey;
	char extraspace[5];
	EVENT eventrec[30];
	BOARD boardrec[200];
} CONFIG;

typedef struct sysinfo {
	long callcount;
	unsigned char lastcaller[36];
	unsigned char extrasys[128];
} SYS;

typedef struct timeinfo {
	unsigned char startdate[9];
	unsigned int busyperhour[24];
	unsigned int busyperday[7];
} TIMELOG;

typedef struct exitinfo {
	unsigned int baudrate;
	SYS sysinfo;
	TIMELOG timeloginfo;
	USER userinfo;
	EVENT eventinfo;
	unsigned char netmail;
	unsigned char echomail;
	unsigned char logintime[6];
	unsigned char logindate[9];
	unsigned int tmlimit;
	unsigned int loginsec;                        /* long in QuickBBS */
	unsigned int credit;                          /* long in QuickBBS */
	unsigned int userrecnum;
	unsigned int readthru;
	unsigned int pagetimes;
	unsigned int downlimit;
	unsigned char wantchat;
	unsigned char gosublevel;
	gosubtype gosub;
	unsigned char menu[9];
} EXIT;


/*  Nodelist Configuration Information  */
/****************************************/
typedef struct noderecord {
	unsigned char nodetype;
	unsigned int zone,net,node;
	unsigned char name[21];
	unsigned char city[41];
	unsigned char phone[41];
	unsigned char password[9];
	unsigned int flags;
	unsigned int baudrate;
	unsigned int cost;
} NODE;

typedef struct nodeindex {
	unsigned int zone,net,node;
	unsigned char nodetype;
} NIDX;
/* unsigned char nodeattrib[][12] = {
		"  Net Hub  ",
		"  Net Host ",
		" Reg Coord ",
		" Zone gate ",
		"  Runs CM  ",
		"           ",
		"           ",
		"           "
	};
*/


/*  Menu Configuration Information  */
/************************************/
typedef struct menuinfo {
	unsigned char type;
	unsigned int security;
	flagtype flags;
	unsigned char display[76];
	unsigned char key;
	unsigned char data[81];
	unsigned char fg, bg;
} MENU;


/*   Message Files Structures   */
/********************************/
typedef struct msginfo {
	unsigned int lowmsg;
	unsigned int highmsg;
	unsigned int totalactive;
	unsigned int activemsgs[200];
} MSGINFO;

typedef struct msgidx {
	unsigned int msgnum;
	unsigned char board;
} MSGIDX;

typedef struct msghdr {
	unsigned int
		msgnum,
		replyto,
		seealsonum,
		tread;
	unsigned int startrec;
	unsigned int
		numrecs,
		destnet,
		destnode,
		orignet,
		orignode;
	unsigned char
		destzone,
		origzone;
	unsigned int cost;
	unsigned char
		msgattr,
		netattr;
	unsigned char board;
	unsigned char posttime[6];
	unsigned char postdate[9];
	unsigned char whoto[36];
	unsigned char whofrom[36];
	unsigned char subj[73];
} MSGHDR;

/*       unsigned int destpoint;*/

/* unsigned char msgattrib[][12] = {
		" *Deleted* ",
		" unmovdNet ",
		" *Net Msg* ",
		" *Private* ",
		" *Received ",
		" unmovdEch ",
		" * Local * ",
		" *Monitor* "                    /* Reserved in QuickBBS
	};
	unsigned char netattrib[][12] = {
		" * KILL  * ",
		"  Sent Ok  ",
		"  Attaches ",
		" * CRASH * ",
		" Recpt Req ",
		" Audit Req ",
		" IsRetRcpt ",
		"  File Req "                    /* Reserved in QuickBBS
	};
*/


/* Standard Errorlevels */
/************************/
/*
	255 compiler
	6+ external program
	5 Net & echo processing done/needed
	2 Fatal error - problem
	1 Problem accessing a file
	0 did nothing, do nothing, default
*/
