;**************************************************************************
;*                                                                        *
;* ASCIIXF.ASP  (C) 1992 DATASTORM TECHNOLOGIES, INC.                     *
;*                                                                        *
;* An ASPECT header file containing procedures facilitating ASCII file    *
;* transfers in the 2.0x scripted host mode.                              *
;*                                                                        *
;**************************************************************************

proc getascii
  strparm fname
  integer elt,linesout,char_in = 0
  integer rcount = 0,AEcho,lastline
  string timein


  lastline = $scrnrows - 1                      ; Calculate last line -
                                                ; (depends upon video mode)
  fetch ascii echo aecho                        ; get ascii echo
  time timein 0                                 ; set timein
  clear cnorm                                   ; clear screen
  fopen 0 fname "wt"                            ; create file
  if failure                                    ; problem?
    return                                      ; return
    endif

  if ansi_on
     transmit clrstr
     endif

  Call HostPuts with "`r`nBegin Your ASCII Transfer Procedure (CTRL-X aborts)`r`n"
  Call HostPuts with "`r`n`r`n(Press <CR> twice to end)`r`n"

  set keys   on                                ; Set keys   on
  set rxdata on                                ; Set rxdata on
  linesout = 1                                 ; set linesout to 1

  statmsg "DOWNLOAD IN PROGRESS - PRESS ESC TO END"

  while 1                                      ; loop forever
    comgetc char_in                            ; Check Port
    if char_in < 0                             ; No Char?
      call elapsed with &elt timein $time0     ; Check for Elapsed Time Since
                                               ;     Last Char Received
      inc elt                                  ; Add 1 to Elapsed Time
                                               ;     Prevents having 0 Elapsed
      if elt > atimeout                        ;
        exitwhile                              ; If Elapsed > ASCII Timout
        endif                                  ; Head on out
      endif

    if hitkey                                  ; HitKey?
      keyget n9                                ; What Key?
      if n9 == 27                              ; ESC - Headout
        exitwhile
        endif
      endif

    if char_in > -1                            ; Char at Port?
      time timein 0                            ; Reset Time

      if char_in != 26                         ; Disregard LineFeed & EOF
        fputc 0 char_in                        ; Write Char to File
        if char_in==13                         ; Is Char a <CR>?
          fputc 0 10                           ; Write LF to File
          if aecho                             ; Display?
            message $null
            endif
          linesout++                           ; Inc Lines Written
          rcount++                             ; Inc <CR> check
          fatsay lastline 2 14 "Line: %d" linesout   ; Display Line Count
        else
          rcount=0                             ; Not <CR> ?
          if aecho
            termwrt char_in                    ; Reset <CR> Count
            endif
          endif                                ; Write Char
        endif

        if rcount==2                           ; If 2 CR's
          exitwhile                            ; Move 'em out
          endif

      endif
      fatsay lastline 67 14 "Timeout: %d" elt  ; Display Timeout Count
    endwhile                                   ; loop
  fclose 0                                     ; close file
  call hostputs with "**** TRANSFER COMPLETE ****"
  call setsuccess                              ; set success
  call flush_It                                ; call flush_it
  clear
  set statline on                              ; turn status line back on
endproc
