/*******************************************************
 *
 * menu.js
 *
 * JavaScript functions for the menu frame at the top.
 *
 *******************************************************/
 
var	CurrentFile;    // currently loaded file name.

var	OutputFrame;    // Output frame reference
var Hierarchy;      // Array containing hierarchy
var Level;
var DetailName;



//======================================================
// Initialise variables
//======================================================
OutputFrame = top.frames["output"];
ContentFrame = top.frames["content"];
DetailFrame = top.frames["details"];
Hierarchy = new Array;
Level = 0;


function isNumeric(X)
{
    return !isNaN(parseInt(X));
}


function GetFullName()
{
    var X,Z;
    
    Z = "";
    for (X = 0;X < Level;X++)
        Z = Z + Hierarchy[X];

    return Z;
}


function Expand()
{
    if(typeof(eval(GetFullName())) == "undefined")
    {
        alert("This object does not exist");
        Level--;
    }
    OutputFrame.location = "output.htm";
}


function SetTopLevel(X)
{
    Level=1;
    Hierarchy[0] = "ContentFrame";
    if( X != "" )
    {
        Hierarchy[1] = "."+X;
        Level=2;
    }
    Expand();
}


function AddLevel(X)
{
    if(isNumeric(X))
        Hierarchy[Level] = "["+X+"]";
    else
		Hierarchy[Level] = "." + X;

    Level++;
    Expand();
}


function SetDetail(X)
{
    if(isNumeric(X))
        DetailName = "["+X+"]";
    else
	DetailName = "." + X;
    DetailFrame.location = "detail.htm";
}


function BackStep()
{
    if(Level > 1)
    {
        Level--;
        Expand();
    }
}


//==============================================================
// Construct a fully-qualified name from the hierarchy array
//==============================================================
function GetFullName()
{
    var X,Z;
    
    Z = "";
    for (X = 0;X < Level;X++)
        Z = Z + Hierarchy[X];

    return Z;
}



//======================================================
// Load a new document into the content frame. The
// document name to load is taken from the 'filename'
// form-field.
//======================================================
function loadDoc()
{
  currentFile = document.forms["frm_filename"]["filename"].value;
  top.frames["content"].location = currentFile;
}




//======================================================
// Set the top level to the document object.
//======================================================
function doDoc()
{
  SetTopLevel("document");
}


//======================================================
// Set the top level to the window object.
//======================================================
function doWin()
{
  SetTopLevel("window");
}


//======================================================
// Set the top level to the navigator object.
//======================================================
function doNav()
{
  SetTopLevel("navigator");
}


//======================================================
// Set the top level to the navigator object.
//======================================================
function doTop()
{
  SetTopLevel("");
}


//======================================================
// Set the top level to a user-specified object.
//======================================================
function doObj()
{
  SetTopLevel(document.forms["frm_object"]["object"].value);
}



function Help()
{
    open('help.htm',"helpwindow", "toolbar=0,scrollbars=1,location=0,status=0,resizeable=0,width=300,height=400");
}

