#ifdef SECTION
//#define SECTION_HDR SECTION
#endif
//----------------------------------------------------------------------------
// LEdit wrapper for ObjectWindows 2.5 ... V2.05
// (C) Copyright 1996-1997 Andrey B. Yastrebov, All Rights Reserved
//
//   Implementation of class TLEdit.
//----------------------------------------------------------------------------
//  NOBODY CAN MODIFY THIS FILE WITHOUT WRITTEN PERMISSION OF AUTHOR
//----------------------------------------------------------------------------
#include <owl/owlpch.h>
#include <owl/docview.h>
#include <owl/edit.rh>
#include <owl/editsear.rh>
#include <owl/editfile.rh>
#include <owl/editview.rh>
#include <owl/docview.rh>
#include "leowl.h"

//----------------------------------------------------------------------------
//#define SHAREWARE_VERSION 1

#ifdef SHAREWARE_VERSION
#include "ledit.sha"
#else
BOOL
IsGoodVersion()
{
  return LVer() >= 205;
}
#endif

#if !defined(SECTION_HDR) || SECTION_HDR == 1

//---------------------------------------------------------------------------
DEFINE_RESPONSE_TABLE1(TLEditGroup, TWindow)
END_RESPONSE_TABLE;

TLEditGroup::TLEditGroup (TWindow* parent,
								  TModule* module)
: TWindow(parent,0,module)
{
  Attr.Style = WS_CHILD;
}

//
// return "LEditGroup" class name
//
char far*
TLEditGroup::GetClassName()
{
  return LEDITGROUP_CLASS;
}

//---------------------------------------------------------------------------
DEFINE_RESPONSE_TABLE1(TLEdit,TWindow)
  EV_WM_PAINT,
  EV_WM_DESTROY,
  EV_WM_SETFONT,
  EV_MESSAGE(EM_CTLCOLOR, EvControlSColor),
  EV_MESSAGE(WM_CTLCOLOR, EvControlTColor),
  EV_MESSAGE(EM_CTLCOLOREX, EvControlHighlight),
  EV_MESSAGE(EM_DRAW, EvDraw),
  EV_MESSAGE(EM_FINDBRACE, EvFindBrace),
  EV_MESSAGE(EM_WORDCLICK, EvWordClick),
  EV_MESSAGE(EM_PRINT, EvPrint),
  EV_MESSAGE(EM_WORDWRAP, EvWordWrap),
  EV_MESSAGE(EM_NOTIFYFOUND, EvNotifyFound),
#define EV_DEFEC(EC_cmd) EV_COMMAND_AND_ID(EC_cmd, CmEC_Command)
  EV_DEFEC(EC_EDITUNDO),
  EV_DEFEC(EC_EDITREDO),
  EV_DEFEC(EC_EDITCUT),
  EV_DEFEC(EC_EDITCOPY),
  EV_DEFEC(EC_EDITPASTE),
  EV_DEFEC(EC_EDITDUPLICATE),
  EV_DEFEC(EC_EDITCLEAR),
  EV_DEFEC(EC_EDITSELECTALL),
  EV_DEFEC(EC_SEARCHFIND),
  EV_DEFEC(EC_SEARCHNEXT),
  EV_DEFEC(EC_SEARCHREPLACE),
  EV_DEFEC(EC_SEARCHBRACE),
  EV_DEFEC(EC_SEARCHBOOKMARK),
  EV_DEFEC(EC_SEARCHSETBOOKMARK),
  EV_DEFEC(EC_TOOLSCHANGEFONT),
  EV_DEFEC(EC_TOOLSCLEARUNDOBUFFER),
  EV_DEFEC(EC_TOOLSCLEARALL),
  EV_DEFEC(EC_FILEPRINT),
  EV_DEFEC(EC_FILEPRINTERSETUP),
  EV_COMMAND(CM_EDITUNDO, CmEditUndo),
  EV_COMMAND(CM_EDITCUT, CmEditCut),
  EV_COMMAND(CM_EDITCOPY, CmEditCopy),
  EV_COMMAND(CM_EDITPASTE, CmEditPaste),
  EV_COMMAND(CM_EDITDELETE, CmEditDelete),
  EV_COMMAND(CM_EDITFIND, CmEditFind),
  EV_COMMAND(CM_EDITFINDNEXT, CmEditFindNext),
  EV_COMMAND(CM_EDITREPLACE, CmEditReplace),
  EV_COMMAND(CM_EDITCLEAR, CmEditClear),
  EV_COMMAND(CM_FILEPRINT, CmFilePrint),
  EV_COMMAND(CM_FILEPRINTERSETUP, CmFilePrinterSetup),
  EV_COMMAND_ENABLE(CM_EDITUNDO, CmTranslateEnable),
  EV_COMMAND_ENABLE(EC_EDITUNDO, CmDirectEnable),
  EV_COMMAND_ENABLE(EC_EDITREDO, CmDirectEnable),
  EV_COMMAND_ENABLE(CM_EDITCUT, CmTranslateEnable),
  EV_COMMAND_ENABLE(EC_EDITCUT, CmDirectEnable),
  EV_COMMAND_ENABLE(CM_EDITCOPY, CmTranslateEnable),
  EV_COMMAND_ENABLE(EC_EDITCOPY, CmDirectEnable),
  EV_COMMAND_ENABLE(CM_EDITPASTE, CmTranslateEnable),
  EV_COMMAND_ENABLE(EC_EDITPASTE, CmDirectEnable),
  EV_COMMAND_ENABLE(EC_EDITDUPLICATE, CmDirectEnable),
  EV_COMMAND_ENABLE(CM_EDITDELETE, CmTranslateEnable),
  EV_COMMAND_ENABLE(EC_EDITCLEAR, CmDirectEnable),
  EV_COMMAND_ENABLE(EC_EDITSELECTALL, CmDirectEnable),
  EV_COMMAND_ENABLE(CM_EDITFIND, CmTranslateEnable),
  EV_COMMAND_ENABLE(EC_SEARCHFIND, CmDirectEnable),
  EV_COMMAND_ENABLE(CM_EDITFINDNEXT, CmTranslateEnable),
  EV_COMMAND_ENABLE(EC_SEARCHNEXT, CmDirectEnable),
  EV_COMMAND_ENABLE(CM_EDITREPLACE, CmTranslateEnable),
  EV_COMMAND_ENABLE(EC_SEARCHREPLACE, CmDirectEnable),
  EV_COMMAND_ENABLE(EC_SEARCHBRACE, CmDirectEnable),
  EV_COMMAND_ENABLE(EC_SEARCHBOOKMARK, CmDirectEnable),
  EV_COMMAND_ENABLE(EC_SEARCHSETBOOKMARK, CmDirectEnable),
  EV_COMMAND_ENABLE(EC_TOOLSCHANGEFONT, CmDirectEnable),
  EV_COMMAND_ENABLE(EC_TOOLSCLEARUNDOBUFFER, CmDirectEnable),
  EV_COMMAND_ENABLE(CM_EDITCLEAR, CmTranslateEnable),
  EV_COMMAND_ENABLE(EC_TOOLSCLEARALL, CmDirectEnable),
  EV_COMMAND_ENABLE(CM_FILEPRINT, CmTranslateEnable),
  EV_COMMAND_ENABLE(EC_FILEPRINT, CmDirectEnable),
  EV_COMMAND_ENABLE(CM_FILEPRINTERSETUP, CmTranslateEnable),
  EV_COMMAND_ENABLE(EC_FILEPRINTERSETUP, CmDirectEnable),

END_RESPONSE_TABLE;

//
// constructor for a TLEdit object
//
// by default, LEdit controls have no styles
//
TLEdit::TLEdit  (TWindow*        parent,
					  const char far* title,
					  long            extraStyle,
					  TModule*        module)
:
  TWindow(parent, title, module)
{
Init();
Attr.Style |= extraStyle;
}


TLEdit::TLEdit (TWindow*        parent,
					 int             id,
					 const char far* title,
					 int x, int y, int w, int h,
					 long            extraStyle,
					 TModule*        module)
:
  TWindow(parent, title, module)
{
  Init();
  Attr.Id = id;
  Attr.X = x;
  Attr.Y = y;
  Attr.W = w;
  Attr.H = h;
  Attr.Style |= WS_CHILD | WS_VISIBLE | WS_GROUP | WS_TABSTOP | extraStyle;
}

// constructor for a TLEdit to be associated with a MS-Windows
// interface element created by MS-Windows from a resource definition
//
// initializes its data fields using passed parameters
//
TLEdit::TLEdit (TWindow*   parent,
					 int        resourceId,
					 TModule*   module)
:
  TWindow(parent, 0, module)
{
  Init();
  if (Title)
	 delete Title;     // Free memory allocated by TWindow's constructor
  Title = 0;
  SetFlag(wfFromResource);
  memset(&Attr, 0, sizeof(Attr));
  Attr.Id = resourceId;
}

TLEdit::~TLEdit ()
{
   if (lpFont) delete lpFont;
}

void
TLEdit::Init()
{
  // To ensure static loading
  if (! IsGoodVersion() )
	 {
		::MessageBeep(MB_ICONHAND);
		::MessageBox(0,"To register these products, please contact TechnoSoft, Inc.:\n\
3795 SW 194th Place, Beaverton, OR 97007 USA\n\
E-mail: ledit@technosoft-inc.com",
		  "Sorry, this is illegal copy of either LEdit DLL or LEdit LIB",
		  MB_OK | MB_SYSTEMMODAL);
		::exit(EXIT_FAILURE);
	 };
  StreamInit = FALSE;
  Group = NULL;
  UseMemoryDC = FALSE;
  ControlColors = FALSE;
  BackColor = GetSysColor(COLOR_WINDOW);
  ForeColor = GetSysColor(COLOR_WINDOWTEXT);
  BackColorSelected = GetSysColor(COLOR_HIGHLIGHT);
  ForeColorSelected = GetSysColor(COLOR_HIGHLIGHTTEXT);
  Run = FALSE;
  TabStops = 8;
  AutoIndent = FALSE;
  DefaultSelection = FALSE;
  WrapKeys = FALSE;
  MultilineItems = FALSE;
  MultilineStrings = FALSE;
  SinglelineStrings = FALSE;
  CurrentWordAsText = FALSE;
  UnixStyleSave = FALSE;
  MacStyleSave = FALSE;
  StartInComments = FALSE;
  NoPrintProgress = FALSE;
  NoPrintDialog = FALSE;
  WordWrap = FALSE;
  BookmarksMax = 16;
  CaretWidth = 0;
  InsertMode = IM_INSERT;
  SyntaxLength = -1;
  UndoDepth = -1;
  lpFont = NULL;
  Attr.Param = 0;
  memset(&SelPos, 0, sizeof(LEDITPOSITION));
  DisableTransfer();
}

//
// Attach window to the group
//

int
TLEdit::Attach(TLEditGroup* group)
{
  Group = group;
  if (Run)
	 return (Group) ?
      LOWORD(Group->HandleMessage(EM_ATTACH,(WPARAM) HWindow,0L)) : -1;
  else
	 return 0;
}

//
// switches messages to Ledit itself
//
void
TLEdit::SetupWindow()
{
  TWindow::SetupWindow();
  HandleMessage(EM_SETRUNTIMEFLAGS,EMP_16_AS32);
  HandleMessage(EM_EX_SETHANDLE,EC_DEFAULT_LEDIT_ID,(LPARAM)HWindow);
  Run = TRUE;
  Attach(Group);
  SetTabStops(TabStops);
  SetMultilineItems(MultilineItems);
  SetMultilineStrings(MultilineStrings);
  SetSinglelineStrings(SinglelineStrings);
  SetCurrentWordAsText(CurrentWordAsText);
  SetUnixStyleSave(UnixStyleSave);
  SetMacStyleSave(MacStyleSave);
  SetStartInComments(StartInComments);
  SetPrintDialog(! NoPrintDialog);
  SetPrintProgress(! NoPrintProgress);
  SetDefaultSelection(DefaultSelection);
  SetWrapKeys(WrapKeys);
  SetAutoIndent(AutoIndent);
  SetInsertMode(InsertMode);
  SetUndoDepth(UndoDepth);
  SetBookmarksMax(BookmarksMax);
  SetWordWrap(WordWrap,WordWrapAuto,WordWrapWidth);
  SetCaretWidth(CaretWidth);
  if (lpFont)
	 SetFont();
  if ((SyntaxLength > -1) && (SyntaxLength < 255))
	 SetSyntax(Syntax,SyntaxLength);
  SetSelection();
  OnCreated();
}

BOOL
TLEdit::CanClose()
{
  return TWindow::CanClose() && ((! Run) || LOWORD(HandleMessage(EM_CLOSE)));
}

void
TLEdit::EvDestroy()
{
//  if (lpFont) delete lpFont;
  if (Attr.Param) delete Attr.Param;
  Run = FALSE;
  TWindow::EvDestroy();
}

#ifdef BC40
void
TLEdit::EvSetFont(HANDLE hfont, BOOL /*redraw*/)
#else
void
TLEdit::EvSetFont(HFONT hfont, BOOL /*redraw*/)
#endif
{
  if (lpFont)
	 if (HFONT(*lpFont) != hfont)
		{
		  delete lpFont;
		  lpFont = new TFont((HFONT)hfont);
		}
	 else {}
  else lpFont = new TFont((HFONT)hfont);
  DefaultProcessing();
}

void
TLEdit::SetFont(TFont &font)
{
  LOGFONT LFont;
  font.GetObject(LFont);
  HandleMessage(EM_SETLOGFONT,0,(LPARAM) &LFont);
}

void
TLEdit::CmDirectEnable(TCommandEnabler& commandHandler)
{
  commandHandler.Enable(LOWORD(HandleMessage(EM_CANEXECUTECOMMAND,
	 commandHandler.Id)));
}

void
TLEdit::CmTranslateEnable(TCommandEnabler& commandHandler)
{
  WORD EC_Id = 0;
#define TRANS_CMEC(CM_def,EC_def) \
  case CM_def: {EC_Id = EC_def; break;}
  switch (commandHandler.Id)
	 {
		TRANS_CMEC(CM_FILENEW,EC_FILENEW)
		TRANS_CMEC(CM_FILEOPEN,EC_FILEOPEN)
#ifndef BC40
		TRANS_CMEC(CM_FILEREVERT,EC_FILEREOPEN)
#endif
		TRANS_CMEC(CM_FILESAVE,EC_FILESAVE)
		TRANS_CMEC(CM_FILESAVEAS,EC_FILESAVEAS)
      TRANS_CMEC(CM_FILEPRINT,EC_FILEPRINT)
      TRANS_CMEC(CM_FILEPRINTERSETUP,EC_FILEPRINTERSETUP)
		TRANS_CMEC(CM_EDITUNDO,EC_EDITUNDO)
		TRANS_CMEC(CM_EDITCUT,EC_EDITCUT)
		TRANS_CMEC(CM_EDITCOPY,EC_EDITCOPY)
		TRANS_CMEC(CM_EDITPASTE,EC_EDITPASTE)
		TRANS_CMEC(CM_EDITDELETE,EC_EDITCLEAR)
		TRANS_CMEC(CM_EDITFIND,EC_SEARCHFIND)
		TRANS_CMEC(CM_EDITFINDNEXT,EC_SEARCHNEXT)
		TRANS_CMEC(CM_EDITREPLACE,EC_SEARCHREPLACE)
		TRANS_CMEC(CM_EDITCLEAR,EC_TOOLSCLEARALL)
	 }
  commandHandler.Enable(LOWORD(HandleMessage(EM_CANEXECUTECOMMAND,EC_Id)));
}

BOOL
TLEdit::IsSelection()
{
  LEDITPOSITION Pos;
  GetSelection(Pos);
  return (Pos.StartPosition != Pos.EndPosition) ||
			(Pos.StartLine != Pos.EndLine);

}

long
TLEdit::GetLine(char far* str, long lineNumber)
{
  *(long*)str = lineNumber;
  return HandleMessage(EM_EX_GETLINE,0,(long) str);
}

char far*
TLEdit::GetLine(long lineNumber)
{
  char Buf [8192];
  Buf[0] = 0;
  GetLine(Buf,lineNumber);
  return strnewdup(Buf);
}

long
TLEdit::GetWrapLine(char far* str, long lineNumber, short lineSkip)
{
  *(long*)str = lineNumber;
  return HandleMessage(EM_GETWRAPLINE,lineSkip,(long) str);
}

char far*
TLEdit::GetWrapLine(long lineNumber, short lineSkip)
{
  char Buf [8192];
  Buf[0] = 0;
  GetWrapLine(Buf,lineNumber, lineSkip);
  return strnewdup(Buf);
}

char far*
TLEdit::GetRestOfLine()
{
  char Buf [8192];
  Buf[0] = 0;
  GetRestOfLine(Buf);
  return strnewdup(Buf);
}

void
TLEdit::MoveCaret(long Line,short int Position)
{
  LEDITPOSITION Pos;
  Pos.StartLine = Line;
  Pos.StartPosition = Position;
  Pos.EndLine = Line;
  Pos.EndPosition = Position;
  SetSelection(Pos);
}

void
TLEdit::SetSelection(long StartLine,short int StartPosition, long EndLine,
  short int EndPosition)
{
  LEDITPOSITION Pos;
  Pos.StartLine = StartLine;
  Pos.StartPosition = StartPosition;
  Pos.EndLine = EndLine;
  Pos.EndPosition = EndPosition;
  SetSelection(Pos);
}

HANDLE
TLEdit::GetText()
{
  HANDLE Result = GlobalAlloc(GMEM_MOVEABLE,GetTextLength()+1);
  if (Result)
	 {
		char far* Buf = (char far*) GlobalLock(Result);
		if (Buf)
		  {
			 if (! GetText(Buf))
				{
				  GlobalUnlock(Result);
				  GlobalFree(Result);
				  Result = 0;
				}
			 else GlobalUnlock(Result);
		  }
		else
		  {
			 GlobalFree(Result);
			 Result = 0;
		  }
	 };
  return Result;
}

void
TLEdit::SetText(HANDLE hGlobal)
{
  char far* Buf = (char far*) GlobalLock(hGlobal);
  if (Buf) SetText(Buf);
  GlobalUnlock(hGlobal);
}

HANDLE
TLEdit::GetSelText()
{
  HANDLE Result = GlobalAlloc(GMEM_MOVEABLE,GetTextLength()+1);
  if (Result)
	 {
		char far* Buf = (char far*) GlobalLock(Result);
		if (Buf)
		  {
			 if (! GetSelText(Buf))
				{
				  GlobalUnlock(Result);
				  GlobalFree(Result);
				  Result = 0;
				}
			 else GlobalUnlock(Result);
		  }
		else
		  {
			 GlobalFree(Result);
			 Result = 0;
		  }
	 };
  return Result;
}

void
TLEdit::SetSelText(HANDLE hGlobal)
{
  char far* Buf = (char far*) GlobalLock(hGlobal);
  if (Buf) SetSelText(Buf);
  GlobalUnlock(hGlobal);
}

void
TLEdit::DeleteSubText(const LEDITPOSITION& Pos)
{
  SetSelection(Pos);
  DeleteSelection();
}

void
TLEdit::DeleteSubText(long StartLine,short int StartPosition, long EndLine,
  short int EndPosition)
{
  SetSelection(StartLine,StartPosition,EndLine,EndPosition);
  DeleteSelection();
}

void
TLEdit::DeleteLine(int lineNumber)
{
  LEDITPOSITION Pos;
  Pos.StartLine = lineNumber;
  Pos.StartPosition = 0;
  if (GetNumLines() == lineNumber)
	 {
		Pos.EndLine = lineNumber;
		Pos.EndPosition = 0x7fff;
	 }
  else
	 {
		Pos.EndLine = lineNumber+1;
		Pos.EndPosition = 0;
	 }
  DeleteSubText(Pos);
}

void
TLEdit::SetTabStops(int numTabs)
{
  TabStops = (numTabs < 1) ? 1 : (numTabs > 40) ? 40 : numTabs;
  if (Run) HandleMessage(EM_EX_SETTABSTOPS, TabStops);
}

void
TLEdit::SetReadOnly(BOOL readOnly)
{
  if (readOnly)
	 {
		Attr.Style = Attr.Style | ES_READONLY;
		if (Run)
		  HandleMessage(EM_EX_SETREADONLY,EMP_SET);
	 }
  else
	 {
		Attr.Style = Attr.Style & ! ES_READONLY;
		if (Run)
		  HandleMessage(EM_EX_SETREADONLY,EMP_CLEAR);
	 }
}

void
TLEdit::SetHighlight(BOOL highlight)
{
  if (highlight)
	 {
		Attr.Style = Attr.Style | ES_HIGHLIGHT;
		if (Run)
		  HandleMessage(EM_SETHIGHLIGHT,EMP_SET);
	 }
  else
	 {
		Attr.Style = Attr.Style & ! ES_HIGHLIGHT;
		if (Run)
		  HandleMessage(EM_SETHIGHLIGHT,EMP_CLEAR);
	 }
}

void
TLEdit::SetTransparent(BOOL transparent)
{
  if (transparent)
	 {
		Attr.Style = Attr.Style | ES_TRANSPARENT;
		if (Run)
		  HandleMessage(EM_SETTRANSPARENT,EMP_SET);
	 }
  else
	 {
		Attr.Style = Attr.Style & ! ES_TRANSPARENT;
		if (Run)
		  HandleMessage(EM_SETTRANSPARENT,EMP_CLEAR);
	 }
}

void
TLEdit::SetScrollBars(BOOL horzScrollBar, BOOL vertScrollBar)
{
  SetHorzScrollBar(horzScrollBar);
  SetVertScrollBar(vertScrollBar);
}

void
TLEdit::SetHorzScrollBar(BOOL horzScrollBar)
{
  if (horzScrollBar)
	 {
		Attr.Style = Attr.Style | WS_HSCROLL;
		if (Run)
		  HandleMessage(EM_SETMETRICS,0,HandleMessage(EM_GETMETRICS)
          | 0x10000L);
	 }
  else
	 {
		Attr.Style = Attr.Style & ! WS_HSCROLL;
		if (Run)
		  HandleMessage(EM_SETMETRICS,0,HandleMessage(EM_GETMETRICS)
          & 0xFFFEFFFFL);
	 }
}

void
TLEdit::SetVertScrollBar(BOOL vertScrollBar)
{
  if (vertScrollBar)
	 {
		Attr.Style = Attr.Style | WS_VSCROLL;
		if (Run)
		  HandleMessage(EM_SETMETRICS,0,HandleMessage(EM_GETMETRICS)
			 | 0x20000L);
	 }
  else
	 {
		Attr.Style = Attr.Style & ! WS_VSCROLL;
		if (Run)
		  HandleMessage(EM_SETMETRICS,0,HandleMessage(EM_GETMETRICS)
          & 0xFFFDFFFFL);
	 }
}

void
TLEdit::SetExtraSpacing(short horzSpacing, short vertSpacing)
{
  SetHorzScrollBar(horzSpacing);
  SetVertScrollBar(vertSpacing);
}

void
TLEdit::SetExtraHorzSpacing(short horzSpacing)
{
  if (Run)
	 HandleMessage(EM_SETMETRICS,0,(HandleMessage(EM_GETMETRICS)
          & 0xFFFFFFF0L) | (horzSpacing & 0xF));
}

void
TLEdit::SetExtraVertSpacing(short vertSpacing)
{
  if (Run)
	 HandleMessage(EM_SETMETRICS,0,(HandleMessage(EM_GETMETRICS)
          & 0xFFFFFF0FL) | ((vertSpacing >> 4) & 0xF));
}

void
TLEdit::SetInsertMode(BOOL insertMode)
{
  InsertMode = insertMode;
  if (Run)
	 {
		if (InsertMode)
		  HandleMessage(EM_SETINSERTMODE,EMP_CLEAR);
		else
		  HandleMessage(EM_SETINSERTMODE,EMP_SET);
	 }
}

void
TLEdit::SetUndoDepth(int undoDepth )
{
  if (Run)
	 HandleMessage(EM_SETUNDOPARAM,
		(undoDepth == -1) ? GetUndoMaxBuffer() : undoDepth);
  else
	 UndoDepth = undoDepth;
}

void
TLEdit::SetAutoIndent(BOOL autoIndent)
{
  AutoIndent = autoIndent;
  if (Run)
	 {
		if (autoIndent)
		  HandleMessage(EM_SETRUNTIMEFLAGS,EMP_AUTOINDENT);
		else
		  HandleMessage(EM_SETRUNTIMEFLAGS,0,EMP_AUTOINDENT);
	 }
}

void
TLEdit::SetDefaultSelection(BOOL defaultSelection)
{
  DefaultSelection = defaultSelection;
  if (Run)
	 {
		if (defaultSelection)
		  HandleMessage(EM_SETRUNTIMEFLAGS,EMP_DEFAULTSELECTION);
		else
		  HandleMessage(EM_SETRUNTIMEFLAGS,0,EMP_DEFAULTSELECTION);
	 }
}

void
TLEdit::SetWrapKeys(BOOL wrapKeys)
{
  WrapKeys = wrapKeys;
  if (Run)
	 {
		if (wrapKeys)
		  HandleMessage(EM_SETRUNTIMEFLAGS,EMP_WRAPKEYS);
		else
		  HandleMessage(EM_SETRUNTIMEFLAGS,0,EMP_WRAPKEYS);
	 }
}

void
TLEdit::SetMultilineItems(BOOL multilineItems)
{
  MultilineItems = multilineItems;
  if (Run)
	 {
		if (multilineItems)
		  HandleMessage(EM_SETRUNTIMEFLAGS,EMP_MULTILINEITEMS);
		else
		  HandleMessage(EM_SETRUNTIMEFLAGS,0,EMP_MULTILINEITEMS);
	 }
}

void
TLEdit::SetMultilineStrings(BOOL multilineStrings)
{
  MultilineStrings = multilineStrings;
  if (Run)
	 {
		if (multilineStrings)
		  HandleMessage(EM_SETRUNTIMEFLAGS,EMP_MULTILINESTRINGS);
		else
		  HandleMessage(EM_SETRUNTIMEFLAGS,0,EMP_MULTILINESTRINGS);
	 }
}

void
TLEdit::SetSinglelineStrings(BOOL singlelineStrings)
{
  SinglelineStrings = singlelineStrings;
  if (Run)
	 {
		if (singlelineStrings)
		  HandleMessage(EM_SETRUNTIMEFLAGS,EMP_SINGLELINESTRINGS);
		else
		  HandleMessage(EM_SETRUNTIMEFLAGS,0,EMP_SINGLELINESTRINGS);
	 }
}


void
TLEdit::SetCurrentWordAsText(BOOL currentWordAsText)
{
  CurrentWordAsText = currentWordAsText;
  if (Run)
	 {
		if (currentWordAsText)
		  HandleMessage(EM_SETRUNTIMEFLAGS,EMP_CURRENTWORDASTEXT);
		else
		  HandleMessage(EM_SETRUNTIMEFLAGS,0,EMP_CURRENTWORDASTEXT);
	 }
}

void
TLEdit::SetUnixStyleSave(BOOL unixStyleSave)
{
  UnixStyleSave = unixStyleSave;
  if (Run)
	 {
		if (unixStyleSave)
		  HandleMessage(EM_SETRUNTIMEFLAGS,EMP_UNIXSTYLESAVE);
		else
		  HandleMessage(EM_SETRUNTIMEFLAGS,0,EMP_UNIXSTYLESAVE);
	 }
}

void
TLEdit::SetMacStyleSave(BOOL macStyleSave)
{
  MacStyleSave = macStyleSave;
  if (Run)
	 {
		if (macStyleSave)
		  HandleMessage(EM_SETRUNTIMEFLAGS,EMP_MACSTYLESAVE);
		else
		  HandleMessage(EM_SETRUNTIMEFLAGS,0,EMP_MACSTYLESAVE);
	 }
}

void
TLEdit::SetStartInComments(BOOL startInComments)
{
  StartInComments = startInComments;
  if (Run)
	 {
		if (startInComments)
		  HandleMessage(EM_SETRUNTIMEFLAGS,EMP_STARTINCOMMENTS);
		else
		  HandleMessage(EM_SETRUNTIMEFLAGS,0,EMP_STARTINCOMMENTS);
	 }
}

void
TLEdit::SetPrintDialog(BOOL printDialog)
{
  NoPrintDialog = ! printDialog;
  if (Run)
	 {
		if (NoPrintDialog)
		  HandleMessage(EM_SETRUNTIMEFLAGS,EMP_NOPRINTDIALOG);
		else
		  HandleMessage(EM_SETRUNTIMEFLAGS,0,EMP_NOPRINTDIALOG);
	 }
}

void
TLEdit::SetPrintProgress(BOOL printProgress)
{
  NoPrintProgress = ! printProgress;
  if (Run)
	 {
		if (NoPrintProgress)
		  HandleMessage(EM_SETRUNTIMEFLAGS,EMP_NOPRINTPROGRESS);
		else
		  HandleMessage(EM_SETRUNTIMEFLAGS,0,EMP_NOPRINTPROGRESS);
	 }
}

void
TLEdit::SetCaretWidth(short caretWidth)
{
  CaretWidth = caretWidth;
  if (Run)
    HandleMessage(EM_SETCARETWIDTH,CaretWidth);
}

void
TLEdit::SetBookmarksMax(short bookmarksMax)
{
  BookmarksMax = bookmarksMax;
  if (Run)
	 HandleMessage(EM_SETBMLIMIT,BookmarksMax);
}

void
TLEdit::SetWordWrap(BOOL active, BOOL automatic, short width)
{
  WordWrap = active;
  WordWrapAuto = automatic;
  WordWrapWidth = width;
  if (Run)
  {
    WPARAM wp = 0;
    if (active)
    {
      wp = EMP_ACTIVE;
      if (automatic)
        wp |= EMP_AUTOMATIC;
      if (width)
        wp |= EMP_CUSTOM;
    }
    HandleMessage(EM_SETWORDWRAP,wp,width);
  }
}

void
TLEdit::SetSyntax(SYNTAX far* syntax, int syntaxLength, int flags)
{
  if (syntaxLength < 0) syntaxLength = 0;
  if (syntaxLength > 254) syntaxLength = 254;
  int W = syntaxLength + (flags << 8);
  if (Run)
	 HandleMessage(EM_SETSYNTAX,W,(LPARAM) syntax);
  memcpy(&Syntax,syntax,syntaxLength*2);
  SyntaxLength = W;
}

void
TLEdit::SetSyntax(char far* syntax, int flags)
{
  char far* Sx;
  int W = 0;
  if (*syntax != 0)
	 {
		for (Sx = syntax;(*Sx != 0) && (W < 254);Sx++)
		switch (*Sx)
		  {
			 case '0':
				{
				  Syntax[W].cFirst = 1;
				  Syntax[W].cSecond = 1;
				  W++;
				  break;
				}
			 case '1':
				{
				  if (*(Sx+1) == 0)
					 break;
				  Sx++;
				  Syntax[W].cFirst = *Sx;
				  Syntax[W].cSecond = 0;
				  W++;
				  break;
				}
			 case '2':
				{
				  if (*(Sx+1) == 0)
					 break;
				  if (*(Sx+2) == 0)
					 {
						Sx++;
						break;
					 }
				  Sx++;
				  Syntax[W].cFirst = *Sx;
				  Sx++;
				  Syntax[W].cSecond = *Sx;
				  W++;
				  break;
				}
          case '3':
				{
				  if (*(Sx+1) == 0)
					 break;
				  Sx++;
				  Syntax[W].cFirst = *Sx;
				  Syntax[W].cSecond = 3;
				  W++;
				  break;
				}
          case '4':
				{
				  if (*(Sx+1) == 0)
					 break;
				  Sx++;
				  Syntax[W].cFirst = *Sx;
				  Syntax[W].cSecond = 4;
				  W++;
				  break;
				}
		  }
	 }
  W = W + (flags << 8);

  if (Run)
	 SetSyntax(Syntax,W);
  SyntaxLength = W;
}

void
TLEdit::GetDialogLocation(int dlgType, int &x, int &y)
{
  long L = HandleMessage(EM_GETDIALOGLOCATION,dlgType);
  x = LOWORD(L);
  y = LOWORD(L);
}

void
TLEdit::TranslateLocation(int x, int y, long &line, int &pos, int operation)
{
  long L = HandleMessage(EM_TRANSLATELOCATION,operation,MAKELONG(x,y));
  line = LOWORD(L) + GetFirstVisibleLine();
  pos = HIWORD(L);
}

BOOL
TLEdit::GetLocation(long line, int pos, int &x, int &y)
{
  long L = HandleMessage(EM_GETLOCATION,pos,line);
  if (L == -1)
	 {
		return FALSE;
	 }
  else
	 {
		x = LOWORD(L);
		y = HIWORD(L);
		return TRUE;
	 }
}


LRESULT
TLEdit::EvCommand(UINT Id, HWND hWndCtl, UINT notifyCode)
{
  if ( Id == EC_DEFAULT_LEDIT_ID )
	 {
		switch (notifyCode)
		  {
			 case EN_CHANGE:
				{
				  OnChange();
				  return 0;
				}
			 case EN_HSCROLL:
				{
				  OnHorzScroll();
				  return 0;
				}
			 case EN_VSCROLL:
				{
				  OnVertScroll();
				  return 0;
				}
			 case EN_SETFOCUS:
				{
				  OnGotFocus();
				  return 0;
				}
			 case EN_KILLFOCUS:
				{
				  OnLostFocus();
				  return 0;
				}
			 case EN_INSERTMODE:
			 case EN_OVERWRITEMODE:
				{
				  InsertMode = notifyCode - EN_INSERTMODE;
				  OnChangeMode();
				  return 0;
				}
			 case EN_CLIPBOARD:
				{
				  return OnClipboardError();
				}
			 case EN_FILEERROR:
				{
				  return OnFileError();
				}
			 case EN_GOINGTOCLOSE:
				{
				  return OnGoingToClose();
				}
			 case EN_MAXTEXT:
				{
				  return OnMaxLine();
				}
			 case EN_STOREFILE:
				{
				  return OnAskIfStoreFile();
				}
			 case EN_NEWFILE:
				{
				  OnNewFile();
				  return 0;
				}
			 case EN_NEWFONT:
				{
				  OnNewFont();
				  return 0;
				}
			 case EN_ERRSPACE:
				{
				  return OnSpaceError();
				}
		  }
	 }
  else return TWindow::EvCommand(Id, hWndCtl, notifyCode);

  // To suppress warnings
  return 0;
}

void
TLEdit::EvPaint()
{
  DefaultProcessing();  // don't call TWindow::EvPaint()
}

LRESULT
TLEdit::EvControlSColor(WPARAM wp, LPARAM /*lp*/)
{
  OnCtlSelColor();
  SetTextColor((HDC) wp, ForeColorSelected);
  SetBkColor((HDC) wp, BackColorSelected);
  return 0;
}

LRESULT
TLEdit::EvControlTColor(WPARAM wp, LPARAM lp)
{
  if (ControlColors)
    {
      OnCtlTxtColor();
      SetTextColor((HDC) wp, ForeColor);
      SetBkColor((HDC) wp, BackColor);
    }
  else
    if (Parent)
      Parent->HandleMessage(WM_CTLCOLOR,wp,lp);
  return 0;
}

LRESULT
TLEdit::EvNotifyFound(WPARAM /*wp*/, LPARAM lp)
{
  return OnNotifyFound(lp);
}

LRESULT
TLEdit::EvControlHighlight(WPARAM wp, LPARAM lp)
{
  COLORREF TColor = 0;
  COLORREF BColor = 0;

  WORD Result = ControlHighlight(*(LPWORDDESC)lp, BColor, TColor);

  if (Result & EOCH_BKGND)
	 SetBkColor((HDC) wp, BColor);

  if (Result & EOCH_TEXT)
	 SetTextColor((HDC) wp, TColor);

  return 0;
}

LRESULT
TLEdit::EvFindBrace(WPARAM /*wp*/, LPARAM lp)
{
  return MAKELRESULT(OnFindBrace(*(LPWORDDESC) lp),0);
}

LRESULT
TLEdit::EvWordClick(WPARAM /*wp*/, LPARAM lp)
{
  OnWordClick();
  return MAKELRESULT(WordClick(*(LPWORDDESC) lp),0);
}

LRESULT
TLEdit::EvDraw(WPARAM wp, LPARAM /*lp*/)
{
  // Retrieve DC
  HDC DC = (HDC) wp;
  LRESULT LResult = 0;
  HDC MemDC;
  HBITMAP BitMap;

  // Involve bitmap if needed
  if ( UseMemoryDC )
	 {
		MemDC = CreateCompatibleDC(DC);
		if ( MemDC )
		  {
			 BitMap = CreateCompatibleBitmap(DC,Attr.W,Attr.H);
			 if ( BitMap )
				{
				  // Set result to return
				  LResult = (LRESULT) BitMap;

				  // Select the bitmap in MemDC and retrieve
				  // the handle of previous bitmap
				  BitMap = (HBITMAP) SelectObject(MemDC,BitMap);

				  // Bind all drawing to MemDC
				  DC = MemDC;
				}
			 else
				{
				  // We need not MemDC if we haven't got any bitmap
				  DeleteDC(MemDC);
				  MemDC = 0;
				}
		  }
	 }
  else MemDC = 0;

  // Call User Function Draw(DC)
  TDC* hDC = new TDC(DC);
  TRect* rect = new TRect(0,0,Attr.W,Attr.H);
  Paint(*hDC,TRUE,*rect);
  delete hDC;
  delete rect;

  // Delete memory DC if it exists
  if ( MemDC )
	 {
		SelectObject(MemDC,BitMap);
		DeleteDC(MemDC);
	 }

  // Return value that was prepared
  return LResult;
}

LRESULT
TLEdit::EvPrint(WPARAM wp, LPARAM lp)
{
   TDC* hDC = new TDC((HDC) wp);
   long L = OnPrint(*hDC,HIWORD(lp),LOWORD(lp));
   delete hDC;
   return L;
}

LRESULT
TLEdit::EvWordWrap(WPARAM wp, LPARAM lp)
{
   return WordBreakProc((const char far*) lp, LOWORD(wp));
}

//
// return "LEdit" class name
//
char far*
TLEdit::GetClassName()
{
  return LEDIT_CLASS;
}

//
// Should transfer state information for TLEdit controls
//
UINT
TLEdit::Transfer(void* /* buffer */, TTransferDirection /* direction */)
{
  return 0;
}
//---------------------------------------------------------------------------
DEFINE_RESPONSE_TABLE1(TLEditFile,TLEdit)
  EV_MESSAGE(EM_SETFILEFILTER, EvSetFileMask),
  EV_DEFEC(EC_FILENEW),
  EV_DEFEC(EC_FILEOPEN),
  EV_DEFEC(EC_FILEREOPEN),
  EV_DEFEC(EC_FILESAVE),
  EV_DEFEC(EC_FILESAVEAS),
//  EV_COMMAND(CM_FILENEW, CmFileNew),
//  EV_COMMAND(CM_FILEOPEN, CmFileOpen),
#ifndef BC40
  EV_COMMAND(CM_FILEREVERT, CmFileReOpen),
#endif
  EV_COMMAND(CM_FILESAVE, CmFileSave),
  EV_COMMAND(CM_FILESAVEAS, CmFileSaveAs),
  EV_COMMAND_ENABLE(EC_FILENEW, CmDirectEnable),
  EV_COMMAND_ENABLE(EC_FILEOPEN, CmDirectEnable),
#ifndef BC40
  EV_COMMAND_ENABLE(CM_FILEREVERT, CmTranslateEnable),
#endif
  EV_COMMAND_ENABLE(EC_FILEREOPEN, CmDirectEnable),
  EV_COMMAND_ENABLE(CM_FILESAVE, CmTranslateEnable),
  EV_COMMAND_ENABLE(EC_FILESAVE, CmDirectEnable),
  EV_COMMAND_ENABLE(CM_FILESAVEAS, CmTranslateEnable),
  EV_COMMAND_ENABLE(EC_FILESAVEAS, CmDirectEnable),
END_RESPONSE_TABLE;

//
// constructors for a TLEditFile
//
TLEditFile::TLEditFile (TWindow*        parent,
								const char far* title,
								long extraStyle,
								TModule*        module)
:
  TLEdit(parent, title, extraStyle | ES_HASFILE, module)
{
  Init();
}

TLEditFile::TLEditFile (TWindow*        parent,
								int             id,
								const char far* title,
								int x, int y, int w, int h,
								long extraStyle,
								TModule*        module)
:
  TLEdit(parent, id, title, x, y, w, h, extraStyle | ES_HASFILE, module)
{
  Init();
}

TLEditFile::TLEditFile (TWindow*   parent,
								int        resourceId,
								TModule*   module)
:
  TLEdit(parent, resourceId, module)
{
  Init();
}

void
TLEditFile::Init()
{
  FileMask[0] = 0;
}

void
TLEditFile::SetupWindow()
{
  TLEdit::SetupWindow();
  if (FileMask[0] != 0)
	 SetFileMask(FileMask);
  else
	 HandleMessage(EM_GETFILEFILTER,0,(LPARAM) &FileMask);
}

char far*
TLEditFile::GetFileName()
{
  char Buf [512];
  Buf[0] = 0;
  GetFileName(Buf);
  return strnewdup(Buf);
}

void
TLEditFile::SetFileMask(char far* fileMask)
{
  if (Run)
	 HandleMessage(EM_SETFILEFILTER,0,(LPARAM) fileMask);
  else
	 lstrcpy(FileMask,fileMask);
}

LRESULT
TLEditFile::EvSetFileMask(WPARAM /*wp*/, LPARAM lp)
{
  lstrcpy(FileMask, (char far*) lp);
  return DefaultProcessing();
}

//--------------------------------------------------------------------------
#ifndef LEDIT_NO_VIEW
DEFINE_RESPONSE_TABLE1(TLEditView,TLEdit)
  EV_VN_ISWINDOW,
  EV_VN_ISDIRTY,
  EV_VN_COMMIT,
  EV_VN_REVERT,
  EV_VN_DOCCLOSED,
END_RESPONSE_TABLE;

TLEditView::TLEditView(TDocument& doc,
							  TWindow* parent,
							  TModule* module)
:
  TLEdit(parent,GetNextViewId(),"",0,0,0,0,0,module),
  TView(doc)
{
  Attr.AccelTable = IDA_EDITVIEW;
  weWrite = FALSE;
  if (!module)
	 module = GetModule();
  if (::FindResource(*module, TResId(IDM_EDITVIEW), RT_MENU))
	 SetViewMenu(new TMenuDescr(IDM_EDITVIEW, 0,2,0,0,0,1,module));
}

BOOL
TLEditView::LoadData()
{
  istream* is = Doc->InStream(ios::in | ios::binary);
  if (is == 0)
	 {
		 Doc->PostError(IDS_UNABLEOPEN, MB_OK);
		 return FALSE;
	 }
  is->seekg(0L, ios::end);
  long flen = is->tellg();
  is->seekg(0L, ios::beg);
  long pos = 0;
  HANDLE H = GlobalAlloc(GMEM_MOVEABLE, flen+1);
  if (H == 0)
	 {
		 delete is;
		 Doc->PostError(IDS_NOMEMORYFORVIEW, MB_OK);
		 return FALSE;
	 }
  char huge* Pt = (char huge*) GlobalLock(H);
  if (Pt == NULL)
	 {
		 GlobalFree(H);
		 delete is;
		 Doc->PostError(IDS_NOMEMORYFORVIEW, MB_OK);
		 return FALSE;
	 }
#define PART 0x4000
  while (pos != flen)
	 {
		long rest = 0x10000L - FP_OFF(Pt);
		rest = ((flen-pos) > rest) ? rest : (flen-pos);
		int toWrite = (rest > PART) ? PART : LOWORD(rest);
		is->read((char far*) Pt, toWrite);
		if (is->gcount() != toWrite)
		  {
			 GlobalUnlock(H);
			 GlobalFree(H);
			 delete is;
			 Doc->PostError(IDS_READERROR, MB_OK);
			 return FALSE;
		  }
		Pt += toWrite;
		pos += toWrite;
	 }
  *Pt = 0;
  SetText(H);
  EmptyUndoBuffer();
  ClearModify(15);
  GlobalUnlock(H);
  GlobalFree(H);
  delete is;
  return TRUE;
}

BOOL
TLEditView::Create()
{
  if (Run)
	 return FALSE;
  TLEdit::Create();
  if (Doc->GetDocPath() == 0)
    {
         ClearModify(15);
	 return TRUE;           // new file, no data to display
    }
  if (!LoadData())
	 NotOK();
  return TRUE;
}

BOOL
TLEditView::VnDocClosed(int omode)
{
  if (!(omode & ofWrite) || weWrite)  // make sure someone else's write
	 {
		weWrite = FALSE;
		return FALSE;
	 }
  else
	 {
		GetSelection();
		LoadData();
		SetSelection();
		return TRUE;
	 }
}

BOOL
TLEditView::VnCommit(BOOL force)
{
  if (!force && !(VnIsDirty()))
	 return TRUE;

  ostream* os = Doc->OutStream(ios::out | ios::binary);
  if (os == 0)
	 {
		Doc->PostError(IDS_UNABLEOPEN, MB_OK);
		return FALSE;
	 }
  weWrite = TRUE;
  os->seekp(0L);

  HANDLE H = GetText();
  if (H == 0)
	 {
		delete os;
		Doc->PostError(IDS_NOMEMORYFORVIEW, MB_OK);
		return FALSE;
	 }
  char huge* Pt = (char huge*) GlobalLock(H);
  if (Pt == NULL)
	 {
		GlobalFree(H);
		delete os;
		Doc->PostError(IDS_NOMEMORYFORVIEW, MB_OK);
		return FALSE;
	 }
  while (*Pt != 0)
	 {
		char huge* PtX = Pt;
		int toWrite = 0;
		while ((*PtX != 0) && (toWrite <= PART) && ((FP_SEG(PtX) == FP_SEG(Pt))))
		  {
			 PtX++;
			 toWrite++;
		  }
		os->write((char far*)Pt, toWrite);
		if (!os->good())
		  {
			 GlobalUnlock(H);
			 GlobalFree(H);
			 delete os;
			 Doc->PostError(IDS_WRITEERROR, MB_OK);
			 return FALSE;
		  }
		Pt = PtX;
	 }
  GlobalUnlock(H);
  GlobalFree(H);
  ClearModify(15);
  delete os;
  return TRUE;
}

BOOL
TLEditView::VnRevert(BOOL clear)
{
  Clear();
  ClearModify(15);
  return clear ? TRUE : LoadData();
}
#endif // TLEditView
#endif
#if !defined(SECTION_HDR) || SECTION_HDR == 2
//---------------------------------------------------------------------------
IMPLEMENT_STREAMABLE1(TLEditGroup, TWindow);

void*
TLEditGroup::Streamer::Read(ipstream& is, uint32 /*version*/) const
{
  TLEditGroup* Obj = GetObject();
  ReadBaseObject((TWindow*)Obj, is);
  return Obj;
}

void
TLEditGroup::Streamer::Write(opstream& os) const
{
  TLEditGroup* Obj = GetObject();
  WriteBaseObject((TWindow*)Obj, os);
}
//--------------------------------------------------------------------------
IMPLEMENT_STREAMABLE_CLASS(TLEdit);
IMPLEMENT_STREAMER(TLEdit);
IMPLEMENT_STREAMABLE_POINTER(TLEdit);

//
// To show that we're created from stream
//
TLEdit::TLEdit(StreamableInit)
  : TWindow(streamableInit)
{
  StreamInit = TRUE;
}

//
// reads an instance of TLEdit from the passed ipstream
//
void*
TLEdit::Streamer::Read(ipstream& is, uint32 /*version*/) const
{
  TLEdit* Obj = GetObject();
  ReadBaseObject((TWindow*)Obj, is);
  if (Obj->StreamInit)
    {
      Obj->Run = FALSE;
      Obj->Attr.Param = 0;
	 }
  BOOL IsFont;
  is >> Obj->InsertMode;
  is >> Obj->AutoIndent;
  is >> Obj->DefaultSelection;
  is >> Obj->WrapKeys;
  is >> Obj->MultilineItems;
  is >> Obj->MultilineStrings;
  is >> Obj->SinglelineStrings;
  is >> Obj->CurrentWordAsText;
  is >> Obj->UnixStyleSave;
  is >> Obj->MacStyleSave;
  is >> Obj->StartInComments;
  is >> Obj->NoPrintDialog;
  is >> Obj->NoPrintProgress;
  is >> Obj->CaretWidth;
  is >> Obj->BookmarksMax;
  is >> Obj->WordWrap;
  if (Obj->WordWrap)
  {
	  is >> Obj->WordWrapAuto;
     is >> Obj->WordWrapWidth;
  }
  is >> Obj->UseMemoryDC;
  is >> Obj->UndoDepth;
  is >> Obj->TabStops;
  is >> Obj->ForeColorSelected;
  is >> Obj->BackColorSelected;
  is >> Obj->ControlColors;
  if (Obj->ControlColors)
	 {
		is >> Obj->ForeColor;
      is >> Obj->BackColor;
	 }
  else if (Obj->StreamInit)
	 {
      // safe thing
      Obj->BackColor = GetSysColor(COLOR_WINDOW);
      Obj->ForeColor = GetSysColor(COLOR_WINDOWTEXT);
    }
  is.freadBytes(&(Obj->SelPos), sizeof(LEDITPOSITION));
  is >> Obj->SyntaxLength;
  if (Obj->SyntaxLength > 0)
	 is.freadBytes(&(Obj->Syntax),Obj->SyntaxLength*2);
  is >> IsFont;
  if (IsFont)
	 {
		LOGFONT lf;
		is.freadBytes(&lf,sizeof(LOGFONT));
		Obj->lpFont = new TFont(&lf);
		if (Obj->Run)
		  Obj->SetFont();
	 }
  else
	 Obj->lpFont = 0;
  is >> Obj->Group;
  if (Obj->Run)
	 {
		Obj->SetInsertMode(Obj->InsertMode);
		Obj->SetAutoIndent(Obj->AutoIndent);
		Obj->SetDefaultSelection(Obj->DefaultSelection);
      Obj->SetWrapKeys(Obj->WrapKeys);
		Obj->SetMultilineItems(Obj->MultilineItems);
      Obj->SetMultilineStrings(Obj->MultilineStrings);
      Obj->SetSinglelineStrings(Obj->SinglelineStrings);
		Obj->SetCurrentWordAsText(Obj->CurrentWordAsText);
      Obj->SetUnixStyleSave(Obj->UnixStyleSave);
      Obj->SetMacStyleSave(Obj->MacStyleSave);
		Obj->SetStartInComments(Obj->StartInComments);
		Obj->SetPrintDialog(! Obj->NoPrintDialog);
		Obj->SetPrintProgress(! Obj->NoPrintProgress);
		Obj->SetCaretWidth(Obj->CaretWidth);
		Obj->SetBookmarksMax(Obj->BookmarksMax);
		Obj->SetWordWrap(Obj->WordWrap,Obj->WordWrapAuto,Obj->WordWrapWidth);
		Obj->SetTabStops(Obj->TabStops);
		Obj->SetUndoDepth(Obj->UndoDepth);
		if ((Obj->SyntaxLength > -1) && (Obj->SyntaxLength < 255))
		  Obj->SetSyntax(Obj->Syntax,Obj->SyntaxLength);
		LEDITPOSITION CurSelPos = Obj->SelPos;
		Obj->SetSelection(CurSelPos);
	 }
  return Obj;
}

//
// writes the TLEdit to the passed opstream
//
void
TLEdit::Streamer::Write(opstream& os) const
{
  TLEdit* Obj = GetObject();
  WriteBaseObject((TWindow*)Obj, os);
  BOOL IsFont = (Obj->lpFont != NULL);
  os << Obj->InsertMode;
  os << Obj->AutoIndent;
  os << Obj->DefaultSelection;
  os << Obj->WrapKeys;
  os << Obj->MultilineItems;
  os << Obj->MultilineStrings;
  os << Obj->SinglelineStrings;
  os << Obj->CurrentWordAsText;
  os << Obj->UnixStyleSave;
  os << Obj->MacStyleSave;
  os << Obj->StartInComments;
  os << Obj->NoPrintDialog;
  os << Obj->NoPrintProgress;
  os << Obj->CaretWidth;
  os << Obj->BookmarksMax;
  os << Obj->WordWrap;
  if (Obj->WordWrap)
  {
     os << Obj->WordWrapAuto;
     os << Obj->WordWrapWidth;
  }
  os << Obj->UseMemoryDC;
  os << Obj->UndoDepth;
  os << Obj->TabStops;
  os << Obj->ForeColorSelected;
  os << Obj->BackColorSelected;
  os << Obj->ControlColors;
  if (Obj->ControlColors)
    {
       os << Obj->ForeColor;
       os << Obj->BackColor;
    }
  if (Obj->Run) Obj->GetSelection();
  os.fwriteBytes(&(Obj->SelPos),sizeof(LEDITPOSITION));
  os << Obj->SyntaxLength;
  if (Obj->SyntaxLength > 0)
	 os.fwriteBytes(&(Obj->Syntax),Obj->SyntaxLength*2);
  os << IsFont;
  if (IsFont)
	 {
		LOGFONT lf;
		Obj->lpFont->GetObject(lf);
		os.fwriteBytes(&lf,sizeof(LOGFONT));
	 }
  os << Obj->Group;
}

//---------------------------------------------------------------------------
IMPLEMENT_STREAMABLE1(TLEditFile, TLEdit);

//
// reads an instance of TLEditFile from the passed ipstream
//
void*
TLEditFile::Streamer::Read(ipstream& is, uint32 /*version*/) const
{
  TLEditFile* Obj = GetObject();
  ReadBaseObject((TLEdit*)Obj, is);
  is.freadString(Obj->FileMask, SIZE_FILEMASK+1);
  Obj->Attr.Param = is.freadString();
  Obj->Attr.Style |= ES_LOADFROMPARAM;
  if (Obj->Run)
	 {
		if (Obj->FileMask[0])
		  Obj->SetFileMask(Obj->FileMask);
		Obj->LoadFromFile(Obj->Attr.Param);
		Obj->SetSelection();
	 }
  return Obj;
}

//
// writes the TLEditFile to the passed opstream
//
void
TLEditFile::Streamer::Write(opstream& os) const
{
  TLEditFile* Obj = GetObject();
  WriteBaseObject((TLEdit*)GetObject(), os);
  os.fwriteString(Obj->FileMask);
  char FileName[255];
  Obj->GetFileName(FileName);
  os.fwriteString(FileName);
}

//---------------------------------------------------------------------------
#ifndef LEDIT_NO_VIEW
IMPLEMENT_STREAMABLE2(TLEditView, TLEdit, TView);

void*
TLEditView::Streamer::Read(ipstream& is, uint32 /*version*/) const
{
  TLEditView* Obj = GetObject();
  ReadBaseObject((TLEdit*)Obj, is);
  ReadBaseObject((TView*)Obj, is);
  return Obj;
}

void
TLEditView::Streamer::Write(opstream& os) const
{
  TLEditView* Obj = GetObject();
  WriteBaseObject((TLEdit*)Obj, os);
  WriteBaseObject((TView*)Obj, os);
}
#endif // TLEditView
#endif

