/* ---------------------------------------------------------------

    This code is not complete source code!
    It is only EXAMPLE for Reading XSP!

------------------------------------------------------------------ */

#include <stdio.h>
#include <mem.h>
#include "xsp.h"

XSP::XSP()
{
    ani_info = 0;
    file = 0;
    ani_info = 0;
    frame_offset = 0;
    memset( &frame_header, 0, sizeof(XSP_FRAME_HEADER) );
}

XSP::~XSP()
{
    if( file ) fclose(file);
    if( ani_info ) delete ani_info;
}

BOOL XSP::Load( char *fname )
{
    file = fopen( fname, "rb" );
    if( file==NULL ) return FALSE;

    fread( &header, sizeof( XSP_HEADER ), 1, file );
    if( memcmp( header.header, "XSP", 3 ) ) {
        fclose( file );
        file = 0;
        return FALSE;
    }

    if( frame_offset ) delete frame_offset;
    frame_offset = new int[ header.total_frame ];
    fread( frame_offset, header.total_frame, 4, file );

    if( header.total_animation ) {
        fseek( file, header.ani_info_offset, SEEK_SET );
        if( ani_info ) delete ani_info;
        ani_info = new XSP_ANI_INFO[ header.total_animation ];
        fread( ani_info, sizeof( XSP_ANI_INFO ), header.total_animation, file );
    }

    GotoFrame( 0 );

    return TRUE;
}

void XSP::GotoFrame( int num )
{
    if( num>=header.total_frame ) return;
    current_frame = num;

    fseek( file, frame_offset[ num ], SEEK_SET );
    fread( &frame_header, sizeof( XSP_FRAME_HEADER ), 1, file );
    BYTE *temp;
    temp = new BYTE[ frame_header.xlen * frame_header.ylen ];
    fread( temp, frame_header.xlen * frame_header.ylen, 1, file );

    if( frame_header.pal_offset==0 ) {
        frame_header.palette = header.palette;
    } else {
        if( frame_header.palette && frame_header.palette!=header.palette ) {
            delete frame_header.palette;
        }
        frame_header.palette = new BYTE[768];
        fseek( file, frame_header.pal_offset, 0 );
        fread( frame_header.palette, 768, 1, file );
    }

    xpos = frame_header.xpos;
    ypos = frame_header.ypos;

//  -- reg version only ---
//    SetImage( temp, frame_header.xlen, frame_header.ylen, frame_header.palette );
//

// *** Image is stored in (temp) ****

    delete temp;
}

