////////////////////////////////////////////////////////////
//
//	ImgDemo  ImgDLL sample app
//
//	Copyright 1997, smaller animals software
//
//	Author									 
//	chris losinger,	chrisdl@pagesz.net
//

// imgDlg.cpp : implementation file
//

#include "stdafx.h"
#include "imgdemo.h"
#include "imgDlg.h"
#include "imgdll.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif															   

// this is the function the DLL will call on every scan line read or written to/from a file
// if it returns a FALSE, the operation aborts
BOOL CALLBACK callBackFn(UINT row, UINT total);

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CImgDlg dialog

CImgDlg::CImgDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CImgDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CImgDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_doGray = FALSE;
	m_doRGBBGR= FALSE;
	m_doFlip = FALSE;
	m_doHFlip = FALSE;
	m_doLUT = FALSE;
	m_doMatrix = FALSE;
	m_doSharpen = FALSE;
	m_doBlur = FALSE;
	m_doQuantize = FALSE;
	m_doEQ=FALSE;

	//EQ
	m_iEQLowLevel=00;
	m_iEQHighLevel=200;
	m_EQChannelMask=CHRED | CHBLUE | CHGREEN;

	// sharpen
	m_iSharpenLevel=25;

	// blur
	m_iBlurLevel=50;

	// LUT
	for (int lb=0;lb<256;lb++)
		m_LUT[lb]=lb;

	m_LUTChannelMask=CHRED | CHBLUE | CHGREEN;
	m_linLut=TRUE;

	// matrix - default to a slight embossing effect
	for (int mm=0;mm<9;mm++)
		m_fMatrix[mm]=0.0;
	m_fMatrix[0]=1.0;
	m_fMatrix[4]=1.0;
	m_fMatrix[8]=-1.0;

	m_bZero = FALSE;
	m_bFeedback = FALSE;
	m_MatrixChannelMask = CHRED | CHBLUE | CHGREEN;
	m_fMatrixLevel=1.0;

	// quantization
	m_iQuantColors = 16;

	// global image
	m_rgbBuf=NULL;
	m_width=0;
	m_height=0;

	// rotate
	m_quickRotationType = -1;

	m_EQGraphMask = 0;	// lum
	for (int i=0; i<256; i++) m_EQHisto[i]=0;

	MakePalette();
}

CImgDlg::~CImgDlg()
{
	CleanUp();
	m_pal.DeleteObject();
}

//
//	make sure all the controls have the values we want them to have
//

void CImgDlg::SetAllControls()
{
	CString txt;
	// sharpen
	txt.Format("%d", m_iSharpenLevel);
	m_sharpenLevelWnd.SetWindowText(txt);
	m_sharpenCheck.SetCheck(m_doSharpen);

	// blur
	txt.Format("%d", m_iBlurLevel);
	m_BlurLevelWnd.SetWindowText(txt);
	m_BlurCheck.SetCheck(m_doBlur);

	// matrix
	txt.Format("%6.4f", m_fMatrix[8]);
	m_matrix8Wnd.SetWindowText(txt);
	txt.Format("%6.4f", m_fMatrix[7]);
	m_matrix7Wnd.SetWindowText(txt);
	txt.Format("%6.4f", m_fMatrix[6]);
	m_matrix6Wnd.SetWindowText(txt);
	txt.Format("%6.4f", m_fMatrix[5]);
	m_matrix5Wnd.SetWindowText(txt);
	txt.Format("%6.4f", m_fMatrix[4]);
	m_matrix4Wnd.SetWindowText(txt);
	txt.Format("%6.4f", m_fMatrix[3]);
	m_matrix3Wnd.SetWindowText(txt);
	txt.Format("%6.4f", m_fMatrix[2]);
	m_matrix2Wnd.SetWindowText(txt);
	txt.Format("%6.4f", m_fMatrix[1]);
	m_matrix1Wnd.SetWindowText(txt);
	txt.Format("%6.4f", m_fMatrix[0]);
	m_matrix0Wnd.SetWindowText(txt);

	m_matrixZeroCheck.SetCheck(m_bZero);
	m_matrixRedCheck.SetCheck(((m_MatrixChannelMask & CHRED) == CHRED));
	m_matrixGreenCheck.SetCheck(((m_MatrixChannelMask & CHGREEN) == CHGREEN));
	m_matrixBlueCheck.SetCheck(((m_MatrixChannelMask & CHBLUE) == CHBLUE));
	m_matrixOnCheck.SetCheck(m_doMatrix);
	m_matrixFeedbackCheck.SetCheck(m_bFeedback);

	txt.Format("%6.4f", m_fMatrixLevel);
	m_matrixLevelWnd.SetWindowText(txt);

	// lut
	m_LUTRedCheck.SetCheck(((m_LUTChannelMask & CHRED) == CHRED));
	m_LUTGreenCheck.SetCheck(((m_LUTChannelMask & CHGREEN) == CHGREEN));
	m_LUTBlueCheck.SetCheck(((m_LUTChannelMask & CHBLUE) == CHBLUE));
	CheckRadioButton(IDC_LINLUT, IDC_INVLUT, (m_linLut ? IDC_LINLUT : IDC_INVLUT));

	// stuff
	m_grayCheck.SetCheck(m_doGray);
	m_rgbbgrCheck.SetCheck(m_doRGBBGR);
	m_flipCheck.SetCheck(m_doFlip);
	m_hFlipCheck.SetCheck(m_doHFlip);

	// quant
	m_quantCheck.SetCheck(m_doQuantize);
	txt.Format("%d",m_iQuantColors);
	m_quantColorsWnd.SetWindowText(txt);

	// eq
	m_histRedCheck.SetCheck(((m_EQChannelMask & CHRED) == CHRED));
	m_histGreenCheck.SetCheck(((m_EQChannelMask & CHGREEN) == CHGREEN));
	m_histBlueCheck.SetCheck(((m_EQChannelMask & CHBLUE) == CHBLUE));
	m_histCheck.SetCheck(m_doEQ);
	txt.Format("%d",m_iEQLowLevel);
	m_histLowWnd.SetWindowText(txt);
	txt.Format("%d",m_iEQHighLevel);
	m_histHighWnd.SetWindowText(txt);

	// quick rotate
	CheckRadioButton(IDC_ROTATE_NONE, IDC_ROTATE_270, IDC_ROTATE_NONE);


	CheckRadioButton(IDC_EQ_LUM, IDC_EQ_BLUE, IDC_EQ_LUM);
}

void CImgDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CImgDlg)
	DDX_Control(pDX, IDC_HISTO_FRAME, m_histoFrame);
	DDX_Control(pDX, IDC_COLOR_TEXT, m_colorTextWnd);
	DDX_Control(pDX, IDC_HORIZFLIP, m_hFlipCheck);
	DDX_Control(pDX, IDC_HIST_GREEN, m_histGreenCheck);
	DDX_Control(pDX, IDC_HISTCHECK, m_histCheck);
	DDX_Control(pDX, IDC_HIST_RED, m_histRedCheck);
	DDX_Control(pDX, IDC_HIST_LOW, m_histLowWnd);
	DDX_Control(pDX, IDC_HIST_HIGH, m_histHighWnd);
	DDX_Control(pDX, IDC_HIST_BLUE, m_histBlueCheck);
	DDX_Control(pDX, IDC_IMGRECT_BEFORE, m_beforeRectWnd);
	DDX_Control(pDX, IDC_QUANT_COLORS, m_quantColorsWnd);
	DDX_Control(pDX, IDC_QUANTIZE_CHECK, m_quantCheck);
	DDX_Control(pDX, IDC_LUTCHECK, m_LUTCheck);
	DDX_Control(pDX, IDC_RGBBGR, m_rgbbgrCheck);
	DDX_Control(pDX, IDC_GRAYSCALE, m_grayCheck);
	DDX_Control(pDX, IDC_FLIP, m_flipCheck);
	DDX_Control(pDX, IDC_IMGRECT, m_imgRectWnd);
	DDX_Control(pDX, IDC_SHARPEN_LEVEL, m_sharpenLevelWnd);
	DDX_Control(pDX, IDC_SHARPEN_CHECK, m_sharpenCheck);
	DDX_Control(pDX, IDC_MATRIX8, m_matrix8Wnd);
	DDX_Control(pDX, IDC_MATRIX7, m_matrix7Wnd);
	DDX_Control(pDX, IDC_MATRIX6, m_matrix6Wnd);
	DDX_Control(pDX, IDC_MATRIX5, m_matrix5Wnd);
	DDX_Control(pDX, IDC_MATRIX4, m_matrix4Wnd);
	DDX_Control(pDX, IDC_MATRIX3, m_matrix3Wnd);
	DDX_Control(pDX, IDC_MATRIX2, m_matrix2Wnd);
	DDX_Control(pDX, IDC_MATRIX0, m_matrix0Wnd);
	DDX_Control(pDX, IDC_MATRIX1, m_matrix1Wnd);
	DDX_Control(pDX, IDC_MATRIX_ZERO, m_matrixZeroCheck);
	DDX_Control(pDX, IDC_MATRIX_RED, m_matrixRedCheck);
	DDX_Control(pDX, IDC_MATRIX_ON, m_matrixOnCheck);
	DDX_Control(pDX, IDC_MATRIX_LEVEL, m_matrixLevelWnd);
	DDX_Control(pDX, IDC_MATRIX_GREEN, m_matrixGreenCheck);
	DDX_Control(pDX, IDC_MATRIX_FEEDBACK, m_matrixFeedbackCheck);
	DDX_Control(pDX, IDC_MATRIX_BLUE, m_matrixBlueCheck);
	DDX_Control(pDX, IDC_LUT_RED, m_LUTRedCheck);
	DDX_Control(pDX, IDC_LUT_GREEN, m_LUTGreenCheck);
	DDX_Control(pDX, IDC_LUT_BLUE, m_LUTBlueCheck);
	DDX_Control(pDX, IDC_BLUR_LEVEL, m_BlurLevelWnd);
	DDX_Control(pDX, IDC_BLUR_CHECK, m_BlurCheck);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CImgDlg, CDialog)
	//{{AFX_MSG_MAP(CImgDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BLUR_CHECK, OnBlurCheck)
	ON_EN_CHANGE(IDC_BLUR_LEVEL, OnChangeBlurLevel)
	ON_BN_CLICKED(IDC_FLIP, OnFlip)
	ON_BN_CLICKED(IDC_GRAYSCALE, OnGrayscale)
	ON_BN_CLICKED(IDC_LUT_BLUE, OnLutBlue)
	ON_BN_CLICKED(IDC_LUT_GREEN, OnLutGreen)
	ON_BN_CLICKED(IDC_LUT_RED, OnLutRed)
	ON_BN_CLICKED(IDC_MATRIX_BLUE, OnMatrixBlue)
	ON_BN_CLICKED(IDC_MATRIX_FEEDBACK, OnMatrixFeedback)
	ON_BN_CLICKED(IDC_MATRIX_GREEN, OnMatrixGreen)
	ON_EN_CHANGE(IDC_MATRIX_LEVEL, OnChangeMatrixLevel)
	ON_BN_CLICKED(IDC_MATRIX_ON, OnMatrixOn)
	ON_BN_CLICKED(IDC_MATRIX_RED, OnMatrixRed)
	ON_BN_CLICKED(IDC_MATRIX_ZERO, OnMatrixZero)
	ON_EN_CHANGE(IDC_MATRIX0, OnChangeMatrix0)
	ON_EN_CHANGE(IDC_MATRIX1, OnChangeMatrix1)
	ON_EN_CHANGE(IDC_MATRIX2, OnChangeMatrix2)
	ON_EN_CHANGE(IDC_MATRIX3, OnChangeMatrix3)
	ON_EN_CHANGE(IDC_MATRIX4, OnChangeMatrix4)
	ON_EN_CHANGE(IDC_MATRIX5, OnChangeMatrix5)
	ON_EN_CHANGE(IDC_MATRIX6, OnChangeMatrix6)
	ON_EN_CHANGE(IDC_MATRIX7, OnChangeMatrix7)
	ON_EN_CHANGE(IDC_MATRIX8, OnChangeMatrix8)
	ON_BN_CLICKED(IDC_OPEN, OnOpen)
	ON_BN_CLICKED(IDC_RGBBGR, OnRgbbgr)
	ON_BN_CLICKED(IDC_SAVE, OnSave)
	ON_BN_CLICKED(IDC_SHARPEN_CHECK, OnSharpenCheck)
	ON_EN_CHANGE(IDC_SHARPEN_LEVEL, OnChangeSharpenLevel)
	ON_BN_CLICKED(IDC_INVLUT, OnInvlut)
	ON_BN_CLICKED(IDC_LINLUT, OnLinlut)
	ON_BN_CLICKED(IDC_LUTCHECK, OnLutcheck)
	ON_BN_CLICKED(IDC_QUANTIZE_CHECK, OnQuantizeCheck)
	ON_BN_CLICKED(IDC_ABOUT, OnAbout)
	ON_EN_CHANGE(IDC_QUANT_COLORS, OnChangeQuantColors)
	ON_BN_CLICKED(IDC_HIST_BLUE, OnHistBlue)
	ON_BN_CLICKED(IDC_HIST_GREEN, OnHistGreen)
	ON_EN_CHANGE(IDC_HIST_HIGH, OnChangeHistHigh)
	ON_EN_CHANGE(IDC_HIST_LOW, OnChangeHistLow)
	ON_BN_CLICKED(IDC_HIST_RED, OnHistRed)
	ON_BN_CLICKED(IDC_HISTCHECK, OnHistcheck)
	ON_BN_CLICKED(IDC_HORIZFLIP, OnHorizflip)
	ON_BN_CLICKED(IDC_ROTATE_180, OnRotate180)
	ON_BN_CLICKED(IDC_ROTATE_270, OnRotate270)
	ON_BN_CLICKED(IDC_ROTATE_90, OnRotate90)
	ON_BN_CLICKED(IDC_ROTATE_NONE, OnRotateNone)
	ON_BN_CLICKED(IDC_EQ_BLUE, OnEqBlue)
	ON_BN_CLICKED(IDC_EQ_GREEN, OnEqGreen)
	ON_BN_CLICKED(IDC_EQ_LUM, OnEqLum)
	ON_BN_CLICKED(IDC_EQ_RED, OnEqRed)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CImgDlg message handlers

BOOL CImgDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	SetAllControls();

	// tell the DLL that we're going to use it
	ImgDLLInitDLL(IMGDLL_LOCK_KEY);

	// tell the DLL to call the function "callBackFn" on every scan line
	// read or written
	ImgDLLSetCallback(callBackFn);

	// load the sample image
	LoadDefaultImage();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CImgDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CImgDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CPaintDC dc(this); // device context for painting

		CPalette * op = dc.SelectPalette(&m_pal,FALSE);
		dc.RealizePalette();

		// where to draw to
		CRect afterRect;
		m_imgRectWnd.GetWindowRect(afterRect);
		ScreenToClient(afterRect);
		afterRect.InflateRect(-2,-2);
		dc.FillRect(afterRect, &CBrush(::GetSysColor(COLOR_3DFACE)));

		// where to draw to
		CRect beforeRect;
		m_beforeRectWnd.GetWindowRect(beforeRect);
		ScreenToClient(beforeRect);
		beforeRect.InflateRect(-2,-2);
		dc.FillRect(beforeRect, &CBrush(::GetSysColor(COLOR_3DFACE)));

		// draw the before image

		// this call wraps a call to ImgDLLRGBToHBITMAP as well as all the
		// usual CreateCompatibleDC, SelectObject, BitBlt stuff
		if (m_rgbBuf!=NULL) 
			ImgDLLDrawRGB(dc.m_hDC,
						m_rgbBuf, 
						m_width, m_height, 
						beforeRect.left,
						beforeRect.top,
						min(100,m_width),		// clip
						min(100,m_height),
						(HPALETTE)m_pal.GetSafeHandle());	//optional



		// apply the changes to generate the "after" image
		BYTE *outputImage = RenderImage();

		// draw the After image
		if (outputImage!=NULL) {

			ImgDLLDrawRGB(dc.m_hDC,
						outputImage, 
						m_width, m_height, 
						afterRect.left,
						afterRect.top,
						min(100,m_width),		// clip
						min(100,m_height),
						(HPALETTE)m_pal.GetSafeHandle()); //optional

			delete [] outputImage;
		}

		// draw histo graph

		// where to draw to
		CRect graphRect;
		m_histoFrame.GetWindowRect(graphRect);
		ScreenToClient(graphRect);
		graphRect.InflateRect(-2,-2);
		dc.FillRect(graphRect, CBrush::FromHandle((HBRUSH)::GetStockObject(WHITE_BRUSH)));

		int maxval = 0;
		for (int z = 0; z<256; z++)
			maxval = max(maxval, m_EQHisto[z]);
		if (maxval > 0) {
			double xscale = (double)(graphRect.Width() - 5) / 256;
			double yscale = (double)(graphRect.Height() - 5) / maxval;
			for (int i=0; i<255; i++) {
				double xpos = xscale * i + 2 + graphRect.left;
				double ypos = graphRect.bottom - (yscale * m_EQHisto[i] + 2);

				dc.MoveTo((int)xpos, (int)ypos);
				dc.LineTo((int)xpos, (graphRect.bottom - 2));

			}
		}

		dc.SelectPalette(op, FALSE);

		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CImgDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

// call this when we want to redraw the After image
void CImgDlg::InvalidateAfterImage()
{
	// where to draw to
	CRect outRect;
	m_imgRectWnd.GetWindowRect(outRect);
	ScreenToClient(outRect);

	InvalidateRect(outRect, FALSE);

	CRect graphRect;
	m_histoFrame.GetWindowRect(graphRect);
	ScreenToClient(graphRect);

	InvalidateRect(graphRect, FALSE);

}

// call this when we want to redraw the Before image
void CImgDlg::InvalidateBeforeImage()
{
	// where to draw to
	CRect outRect;
	m_beforeRectWnd.GetWindowRect(outRect);
	ScreenToClient(outRect);

	InvalidateRect(outRect, FALSE);
}

////////////////////////////////////////////////////////////////////////
// a thousand control handlers....

void CImgDlg::OnBlurCheck() 
{
	m_doBlur = m_BlurCheck.GetCheck();
	InvalidateAfterImage();
}

void CImgDlg::OnChangeBlurLevel() 
{
	CString txt;
	m_BlurLevelWnd.GetWindowText(txt);
	m_iBlurLevel=atoi(txt);

	InvalidateAfterImage();
}

////////////////////////////////////////////////////////////////////////

void CImgDlg::OnSharpenCheck() 
{
	m_doSharpen = m_sharpenCheck.GetCheck();
	InvalidateAfterImage();
}

void CImgDlg::OnChangeSharpenLevel() 
{
	CString txt;
	m_sharpenLevelWnd.GetWindowText(txt);
	m_iSharpenLevel=atoi(txt);

	InvalidateAfterImage();
}

////////////////////////////////////////////////////////////////////////

void CImgDlg::OnFlip() 
{
	m_doFlip = m_flipCheck.GetCheck();
	InvalidateAfterImage();
}

////////////////////////////////////////////////////////////////////////

void CImgDlg::OnHorizflip() 
{
	m_doHFlip = m_hFlipCheck.GetCheck();
	InvalidateAfterImage();
}

////////////////////////////////////////////////////////////////////////

void CImgDlg::OnRgbbgr() 
{
	m_doRGBBGR = m_rgbbgrCheck.GetCheck();
	InvalidateAfterImage();
}

////////////////////////////////////////////////////////////////////////

void CImgDlg::OnGrayscale() 
{
	m_doGray = m_grayCheck.GetCheck();
	InvalidateAfterImage();
}


////////////////////////////////////////////////////////////////////////

void CImgDlg::OnLutcheck() 
{
	m_doLUT = m_LUTCheck.GetCheck();
	InvalidateAfterImage();
}

void CImgDlg::OnLutBlue() 
{
	BOOL check = m_LUTBlueCheck.GetCheck();
	if (check)
		m_LUTChannelMask = m_LUTChannelMask | CHBLUE;
	else 
		m_LUTChannelMask = m_LUTChannelMask ^ CHBLUE;

	InvalidateAfterImage();
}

void CImgDlg::OnLutGreen() 
{
	BOOL check = m_LUTGreenCheck.GetCheck();
	if (check)
		m_LUTChannelMask = m_LUTChannelMask | CHGREEN;
	else 
		m_LUTChannelMask = m_LUTChannelMask ^ CHGREEN;

	InvalidateAfterImage();
}

void CImgDlg::OnLutRed() 
{
	BOOL check = m_LUTRedCheck.GetCheck();
	if (check)
		m_LUTChannelMask = m_LUTChannelMask | CHRED;
	else 
		m_LUTChannelMask = m_LUTChannelMask ^ CHRED;

	InvalidateAfterImage();
}


void CImgDlg::OnInvlut() 
{
	CButton * pBut = (CButton *)GetDlgItem(IDC_INVLUT);
	m_linLut=!(pBut->GetCheck());
	SetLUT();
	InvalidateAfterImage();
}

void CImgDlg::OnLinlut() 
{
	CButton * pBut = (CButton *)GetDlgItem(IDC_LINLUT);
	m_linLut=(pBut->GetCheck());
	SetLUT();
	InvalidateAfterImage();
}

void CImgDlg::SetLUT()
{
	for (int i=0;i<256;i++) {
		m_LUT[i] = (m_linLut ? i : 256 - i);
	}
}

////////////////////////////////////////////////////////////////////////

void CImgDlg::OnHistRed() 
{
	BOOL check = m_histRedCheck.GetCheck();
	if (check)
		m_EQChannelMask = m_EQChannelMask  | CHRED;
	else 
		m_EQChannelMask  = m_EQChannelMask  ^ CHRED;

	InvalidateAfterImage();
}

void CImgDlg::OnHistBlue() 
{
	BOOL check = m_histBlueCheck.GetCheck();
	if (check)
		m_EQChannelMask = m_EQChannelMask  | CHBLUE;
	else 
		m_EQChannelMask  = m_EQChannelMask  ^ CHBLUE;

	InvalidateAfterImage();
}

void CImgDlg::OnHistGreen() 
{
	BOOL check = m_histGreenCheck.GetCheck();
	if (check)
		m_EQChannelMask = m_EQChannelMask  | CHGREEN;
	else 
		m_EQChannelMask  = m_EQChannelMask  ^ CHGREEN;

	InvalidateAfterImage();	
}

void CImgDlg::OnChangeHistHigh() 
{
	CString txt;
	m_histHighWnd.GetWindowText(txt);
	m_iEQHighLevel=atoi(txt);

	InvalidateAfterImage();
}

void CImgDlg::OnChangeHistLow() 
{
	CString txt;
	m_histLowWnd.GetWindowText(txt);
	m_iEQLowLevel=atoi(txt);

	InvalidateAfterImage();
}

void CImgDlg::OnHistcheck() 
{
	m_doEQ = m_histCheck.GetCheck();
	InvalidateAfterImage();
}


////////////////////////////////////////////////////////////////////////

void CImgDlg::OnRotate180() 
{
	m_quickRotationType = 1;
	InvalidateAfterImage();
}

void CImgDlg::OnRotate270() 
{
	m_quickRotationType = 2;
	InvalidateAfterImage();
}

void CImgDlg::OnRotate90() 
{
	m_quickRotationType = 0;
	InvalidateAfterImage();
}

void CImgDlg::OnRotateNone() 
{
	m_quickRotationType = -1;
	InvalidateAfterImage();
}

////////////////////////////////////////////////////////////////////////

void CImgDlg::OnMatrixOn() 
{
	m_doMatrix = m_matrixOnCheck.GetCheck();
	InvalidateAfterImage();
}

void CImgDlg::OnMatrixZero() 
{
	m_bZero = m_matrixZeroCheck.GetCheck();
	InvalidateAfterImage();
}


void CImgDlg::OnMatrixBlue() 
{
	BOOL check = m_matrixBlueCheck.GetCheck();
	if (check)
		m_MatrixChannelMask = m_MatrixChannelMask  | CHBLUE;
	else 
		m_MatrixChannelMask  = m_MatrixChannelMask  ^ CHBLUE;

	InvalidateAfterImage();
}

void CImgDlg::OnMatrixRed() 
{
	BOOL check = m_matrixRedCheck.GetCheck();
	if (check)
		m_MatrixChannelMask = m_MatrixChannelMask  | CHRED;
	else 
		m_MatrixChannelMask  = m_MatrixChannelMask  ^ CHRED;

	InvalidateAfterImage();
}

void CImgDlg::OnMatrixGreen() 
{
	BOOL check = m_matrixGreenCheck.GetCheck();
	if (check)
		m_MatrixChannelMask = m_MatrixChannelMask  | CHGREEN;
	else 
		m_MatrixChannelMask  = m_MatrixChannelMask  ^ CHGREEN;

	InvalidateAfterImage();
}

void CImgDlg::OnMatrixFeedback() 
{
	m_bFeedback =  m_matrixFeedbackCheck.GetCheck();
	InvalidateAfterImage();
}

void CImgDlg::OnChangeMatrixLevel() 
{
	CString txt;
	m_matrixLevelWnd.GetWindowText(txt);
	m_fMatrixLevel=atof(txt);
	
	InvalidateAfterImage();
}

void CImgDlg::OnChangeMatrix0() 
{
	CString txt;
	m_matrix0Wnd.GetWindowText(txt);
	m_fMatrix[0]=atof(txt);

	InvalidateAfterImage();
}

void CImgDlg::OnChangeMatrix1() 
{
	CString txt;
	m_matrix1Wnd.GetWindowText(txt);
	m_fMatrix[1]=atof(txt);

	InvalidateAfterImage();
}

void CImgDlg::OnChangeMatrix2() 
{
	CString txt;
	m_matrix2Wnd.GetWindowText(txt);
	m_fMatrix[2]=atof(txt);

	InvalidateAfterImage();
}

void CImgDlg::OnChangeMatrix3() 
{
	CString txt;
	m_matrix3Wnd.GetWindowText(txt);
	m_fMatrix[3]=atof(txt);

	InvalidateAfterImage();
}

void CImgDlg::OnChangeMatrix4() 
{
	CString txt;
	m_matrix4Wnd.GetWindowText(txt);
	m_fMatrix[4]=atof(txt);

	InvalidateAfterImage();
}

void CImgDlg::OnChangeMatrix5() 
{
	CString txt;
	m_matrix5Wnd.GetWindowText(txt);
	m_fMatrix[5]=atof(txt);

	InvalidateAfterImage();
}

void CImgDlg::OnChangeMatrix6() 
{
	CString txt;
	m_matrix6Wnd.GetWindowText(txt);
	m_fMatrix[6]=atof(txt);

	InvalidateAfterImage();
}

void CImgDlg::OnChangeMatrix7() 
{
	CString txt;
	m_matrix7Wnd.GetWindowText(txt);
	m_fMatrix[7]=atof(txt);

	InvalidateAfterImage();
}

void CImgDlg::OnChangeMatrix8() 
{
	CString txt;
	m_matrix8Wnd.GetWindowText(txt);
	m_fMatrix[8]=atof(txt);

	InvalidateAfterImage();
}

////////////////////////////////////////////////////////////////////////



void CImgDlg::OnEqBlue() 
{
	m_EQGraphMask = CHBLUE;
	InvalidateAfterImage();
}

void CImgDlg::OnEqGreen() 
{
	m_EQGraphMask = CHGREEN;
	InvalidateAfterImage();
}

void CImgDlg::OnEqLum() 
{
	m_EQGraphMask = 0;
	InvalidateAfterImage();
}

void CImgDlg::OnEqRed() 
{
	m_EQGraphMask = CHRED;
	InvalidateAfterImage();
}

////////////////////////////////////////////////////////////////////////

void CImgDlg::OnQuantizeCheck() 
{
	m_doQuantize=m_quantCheck.GetCheck();	
	InvalidateAfterImage();
}



void CImgDlg::OnChangeQuantColors() 
{
	CString txt;
	m_quantColorsWnd.GetWindowText(txt);
	m_iQuantColors=atoi(txt);

	InvalidateAfterImage();
}


// the ImgDLL DLL will call this function once for every scan line
// read or written to a JPG, PNG or BMP file. if this function returns FALSE
// the operation aborts and ImgDLLGetLastError will return CALLBACKCANCEL
//
//	you can use this to monitor the progress of read / write operations
BOOL CALLBACK callBackFn(UINT row, UINT total) 
{
	double perc;
	perc = 100 * (double)row / (double)total;
	TRACE3("Callback at row : %u  total : %u  %f percent done\n",row, total, perc);

	return TRUE;   // don't abort
}

////////////////////////////////////////////////////////////////////////

void CImgDlg::OnOpen() 
{
	CString fileName;
	CString filt="Image Files (jpg,bmp,gif,pcx,png,tiff)|Image Files *.BMP;*.JPG;*.PCX;*.PNG;*.TIF;*.GIF| \
JPG Files (*.JPG)|*.JPG| \
PNG Files (*.PNG)|*.PNG| \
TIFF Files (*.TIF)|*.TIF| \
BMP Files (*.BMP)|*.BMP| \
PCX Files (*.PCX)|*.PCX| \
GIF Files (*.GIF)|*.GIF| \
All files (*.*)|*.*||";

    // OPENFILENAME - so i can get to its Help page easily

	CString defFilt = "*.BMP;*.JPG;*.PCX;*.PNG;*.TIF;*.GIF";
	CFileDialog fileDlg(TRUE,defFilt, defFilt, NULL,filt,this);

	fileDlg.m_ofn.Flags|=OFN_FILEMUSTEXIST;
	fileDlg.m_ofn.lpstrTitle="File to load";

	if (fileDlg.DoModal()==IDOK) {

		AfxGetApp()->DoWaitCursor(1);

		fileName=fileDlg.GetPathName();
		CString ext=fileName.Right(4);

		HGLOBAL hImg=NULL;

		UINT w,h;

		// read new image
		if (!ext.CompareNoCase(".JPG"))
			hImg = ImgDLLReadRGBFromJPG(fileName, &w, &h);

		if (!ext.CompareNoCase(".PNG"))
			hImg = ImgDLLReadRGBFromPNG(fileName, &w, &h);

		if (!ext.CompareNoCase(".TIF"))
			hImg = ImgDLLTIFFToRGB(fileName, &w, &h);

		if (!ext.CompareNoCase(".BMP"))
			hImg = ImgDLLReadRGBFromBMP(fileName, &w, &h);

		if (!ext.CompareNoCase(".PCX"))
			hImg = ImgDLLReadRGBFromPCX(fileName, &w, &h);
		
		if (hImg!=NULL) {
			BYTE *tmp = (BYTE *)GlobalLock(hImg);
			if (tmp!=NULL) {
									   
				// copy to our global RGB buffer, if we can

				DWORD imgSize = w * h * 3;

				CleanUp();

				try {
					m_rgbBuf = (BYTE *) new BYTE[imgSize];
				} catch (CMemoryException *e) {
					e->ReportError();
					e->Delete();
					CleanUp();
					AfxGetApp()->DoWaitCursor(-1);
					return;
				}

				// copy
				memcpy(m_rgbBuf, tmp, imgSize);
				m_width=w;
				m_height=h;

				// clean up
				GlobalUnlock(hImg);
				GlobalFree(hImg);

				// redraw
				InvalidateBeforeImage();
				InvalidateAfterImage();
			}
		} else {
			AfxMessageBox(StringFromErrorNum(ImgDLLGetLastError()));
		}

		AfxGetApp()->DoWaitCursor(-1);
	}            
}


void CImgDlg::OnSave() 
{
	CString fileName;
	CString filt="JPG File (*.JPG)|*.JPG|24-Bit PNG File (*.PNG)|*.PNG|8-bit PNG File (*.PNG)|*.PNG|24-bit BMP (*.BMP)|*.BMP|8-bit BMP (*.BMP)|*.BMP|4-bit BMP (*.BMP)|*.BMP||";
    
    // OPENFILENAME - so i can get to its Help page easily
	CFileDialog fileDlg(FALSE,"*.JPG","*.JPG",NULL,filt,this);

	fileDlg.m_ofn.Flags|=OFN_FILEMUSTEXIST;
	fileDlg.m_ofn.lpstrTitle="File to save as";

	if (fileDlg.DoModal()==IDOK) {
		
		AfxGetApp()->DoWaitCursor(1);

		fileName=fileDlg.GetPathName();
		CString ext=fileName.Right(4);

		// draw the output image
		BYTE *tmp = RenderImage();

		DWORD imgByteSize = (m_width * m_height * 3);

		switch (fileDlg.m_ofn.nFilterIndex) {
		default:
		case 1: //JPG
			{
				if (!ImgDLLSaveRGBToJPG(fileName, tmp, m_width, m_height, 75, TRUE)) {
					AfxMessageBox(StringFromErrorNum(ImgDLLGetLastError()));
				}
			}
			break;
		case 2:	// PNG-24
			{
				if (!ImgDLLSaveRGB24ToPNGRGB(fileName, tmp, m_width, m_height, 0.0)) {
					AfxMessageBox(StringFromErrorNum(ImgDLLGetLastError()));
				}
			}
			break;
		case 3:	//	PNG-8
			{
				int colors = (fileDlg.m_ofn.nFilterIndex == 5 ? 16 : 256);

				// make a buffer for the quantized version
				BYTE *qImg;
				try {
					qImg = (BYTE *) new BYTE[imgByteSize];
				} catch (CMemoryException *e) {
					e->ReportError();
					e->Delete();
					AfxGetApp()->DoWaitCursor(-1);
					AfxMessageBox(StringFromErrorNum(MEMERR));
					return ;
				}

				// quantize it
				RGBQUAD pal[256];
				if (!ImgDLLQuantizeRGBTo8Bit(tmp,
											qImg,
											m_width,
											m_height,
											colors,
											pal)) {
					AfxGetApp()->DoWaitCursor(-1);
					AfxMessageBox(StringFromErrorNum(ImgDLLGetLastError()));
					return;
				}

				// save it
				if (!ImgDLLSave8BitToPNG8Bit(fileName,
												qImg,
												m_width,
												m_height,
												colors,
												pal,
												0.0)) {
					AfxMessageBox(StringFromErrorNum(ImgDLLGetLastError()));
				}
				delete [] qImg;
			}
			break;

		case 4: //24 bit BMP
			if (!ImgDLLSaveRGBToBMP24(fileName, tmp, m_width, m_height)) 
				AfxMessageBox(StringFromErrorNum(ImgDLLGetLastError()));

			break;

		case 5: // 8-bit BMP, 4-bit BMP
		case 6:
			{
				int colors = (fileDlg.m_ofn.nFilterIndex == 5 ? 16 : 256);
				int bits = (fileDlg.m_ofn.nFilterIndex == 5 ? 4 : 8);

				// make a buffer for the quantized version
				BYTE *qImg;
				try {
					qImg = (BYTE *) new BYTE[imgByteSize];
				} catch (CMemoryException *e) {
					e->ReportError();
					e->Delete();
					AfxGetApp()->DoWaitCursor(-1);
					AfxMessageBox(StringFromErrorNum(MEMERR));
					return ;
				}

				// quantize it
				RGBQUAD pal[256];
				if (!ImgDLLQuantizeRGBTo8Bit(tmp,
											qImg,
											m_width,
											m_height,
											colors,
											pal)) {
					AfxGetApp()->DoWaitCursor(-1);
					AfxMessageBox(StringFromErrorNum(ImgDLLGetLastError()));
					return;
				}

				// save it
				if (!ImgDLLSaveColormappedToBMP(fileName,
												qImg,
												m_width,
												m_height,
												bits,
												colors,
												pal)) {
					AfxMessageBox(StringFromErrorNum(ImgDLLGetLastError()));
				}
				delete [] qImg;
			}
			break;
		}
		
		delete [] tmp;

		AfxGetApp()->DoWaitCursor(-1);
	}
}

////////////////////////////////////////////////////////////////////////
//	this is where we apply the mod's

BYTE * CImgDlg::RenderImage()
{
	AfxGetApp()->DoWaitCursor(1);

	// copy it to our buffer
	DWORD imgByteSize = (m_width * m_height * 3);

	BYTE * outBuf;
	// alloc our buffer
	try {
		outBuf = (BYTE *) new BYTE[imgByteSize];
	} catch (CMemoryException *e) {
		e->ReportError();
		e->Delete();
		AfxGetApp()->DoWaitCursor(-1);
		CleanUp();
		return NULL;
	}
  
	// copy
	memcpy(outBuf, m_rgbBuf, imgByteSize);

	// grayscale
	if (m_doGray) {
		if (!ImgDLLMakeGrayScale(outBuf, m_width, m_height)) {
			AfxGetApp()->DoWaitCursor(-1);
			return outBuf;
		}
	}

	// flip
	if (m_doFlip) {
		if (!ImgDLLVerticalFlipBuf(outBuf, m_width * 3, m_height)) {
			AfxGetApp()->DoWaitCursor(-1);
			return outBuf;
		}
	}

	// RGB / BGR
	if (m_doRGBBGR) {
		if (!ImgDLLBGRFromRGB(outBuf, m_width, m_height)) {
			AfxGetApp()->DoWaitCursor(-1);
			return outBuf;
		}
	}

	// horiz flip
	if (m_doHFlip) {
		if (!ImgDLLHorizontalFlipRGB(outBuf, m_width, m_height)) {
			AfxGetApp()->DoWaitCursor(-1);
			return outBuf;
		}
	}

	// LUT
	if (m_doLUT) {
		if (!ImgDLLApplyLUTToRGB(outBuf, m_width, m_height, m_LUTChannelMask, m_LUT)) {
			AfxGetApp()->DoWaitCursor(-1);
			return outBuf;
		}
	}

	// histogram EQ
	if (m_doEQ) {
		if (!ImgDLLHistogramEqualizeRGB(outBuf, m_width, m_height, m_iEQLowLevel, m_iEQHighLevel, m_EQChannelMask)) {
			AfxGetApp()->DoWaitCursor(-1);
			return outBuf;
		}
	}

	// quantize
	if (m_doQuantize) {
		BYTE *tmp;
		try {
			tmp = (BYTE *) new BYTE[imgByteSize];
		} catch (CMemoryException *e) {
			e->ReportError();
			e->Delete();
			AfxGetApp()->DoWaitCursor(-1);
			return outBuf;
		}

		// quantize it
		RGBQUAD pal[256];
		if (!ImgDLLQuantizeRGBTo8Bit(outBuf,
									tmp,
									m_width,
									m_height,
									m_iQuantColors,
									pal)) {
			AfxGetApp()->DoWaitCursor(-1);
			return outBuf;
		} 
 
		// we really want a 24-bit image for display, so create a 24-bit image,
		// using the palette and the 8-bit image
		if (!ImgDLLRGBFrom8Bit(tmp,
								outBuf,
								m_width,
								m_height,
								m_iQuantColors,
								pal)) {
			AfxGetApp()->DoWaitCursor(-1);
			return outBuf;
		}

		delete [] tmp;
	}

	// matrix
	if (m_doMatrix) {
		BYTE *tmp;
		try {
			tmp = (BYTE *) new BYTE[imgByteSize];
		} catch (CMemoryException *e) {
			e->ReportError();
			e->Delete();
			AfxGetApp()->DoWaitCursor(-1);
			return outBuf;
		}
		if (!ImgDLLApplyMatrixToRGB(outBuf,	tmp, m_width, m_height,
									m_MatrixChannelMask, m_bZero, m_bFeedback, m_fMatrixLevel, m_fMatrix)) {
			AfxGetApp()->DoWaitCursor(-1);
			return outBuf;
		}
		memcpy(outBuf, tmp, imgByteSize);
		delete [] tmp;
	}


	// quick rotate
	if (m_quickRotationType!=-1) {
		ImgDLLQuickRotateRGB(outBuf, m_width, m_height, m_quickRotationType);
		// rotate 90 or 270, swap width and height
		if ((m_quickRotationType==0) || (m_quickRotationType==2)) {
			UINT t = m_width;
			m_width = m_height;
			m_height = t;
		}
	}

	// sharpen
	if (m_doSharpen) {
		BYTE *tmp;
		try {
			tmp = (BYTE *) new BYTE[imgByteSize];
		} catch (CMemoryException *e) {
			e->ReportError();
			e->Delete();
			AfxGetApp()->DoWaitCursor(-1);
			return outBuf;
		}
		if (!ImgDLLSharpenRGB(outBuf, tmp, m_width, m_height, m_iSharpenLevel)) {
			AfxGetApp()->DoWaitCursor(-1);
			return outBuf;
		}
		memcpy(outBuf, tmp, imgByteSize);
		delete [] tmp;
	}


	// blur
	if (m_doBlur) {
		BYTE *tmp;
		try {
			tmp = (BYTE *) new BYTE[imgByteSize];
		} catch (CMemoryException *e) {
			e->ReportError();
			e->Delete();
			AfxGetApp()->DoWaitCursor(-1);
			return outBuf;
		}
		if (!ImgDLLBlurRGB(outBuf, tmp, m_width, m_height, m_iBlurLevel)) {
			AfxGetApp()->DoWaitCursor(-1);
			return outBuf;
		}
		memcpy(outBuf, tmp, imgByteSize);
		delete [] tmp;
	}

	// count the colors
	UINT cols = ImgDLLCountRGBColors(outBuf, m_width, m_height, FALSE);
	CString t;
	t.Format("%u colors", cols);
	m_colorTextWnd.SetWindowText(t);

	if (m_EQGraphMask==0) {
		if (!ImgDLLGetBrightnessHistogram(outBuf,
								m_width,
								m_height,
								m_EQHisto)) {
		}
	} else {
		if (!ImgDLLGetChannelHistogram(outBuf,
								m_width,
								m_height,
								m_EQGraphMask,
								m_EQHisto)) {
		}
	}

	AfxGetApp()->DoWaitCursor(-1);

	return outBuf;
}


////////////////////////////////////////////////////////////////////////

void CImgDlg::CleanUp()
{
	if (m_rgbBuf!=NULL) {
		delete [] m_rgbBuf;
		m_rgbBuf=NULL;
		m_width=m_height=0;
	}
}

////////////////////////////////////////////////////////////////////////

void CImgDlg::LoadDefaultImage()
{
	CleanUp();

	// we'll need our palette to render the bitmap on < 16 bit displays
	HPALETTE hPal = (HPALETTE)m_pal.GetSafeHandle();


	//	use ImgDLLLoadResourceBMP, instead of CBitmap::LoadBitmap!
	//
	//	on 8-bit displays, LoadBitmap maps the bitmap to the 16-colors
	//	of the standard Windows palette - this is no good. you don't even
	//	get a chance to use a palette on the image because LoadBitmap mangles
	//	the color info!! yuck!!
	//
	//	if you use this function, with a palette that represents a
	//  spread of colors from the image, or even just a nice spread of
	//	colors all across the spectrum, you'll get much better results.
	//	trust me. 
	//	
	//	if you use a NULL palette, this function will use a 
	//	set of colors from the system palette, which will give slightly
	//	better results than LoadBitmap.
	//
	//	if you don't believe me, get into 256-color mode, replace the 
	//	ImgDLLLoadResourceBMP call with these two lines and see what happens.
	//
	//	CBitmap tmpBmp; tmpBmp.LoadBitmap(IDB_SAMPLE_IMAGE);
	//	HBITMAP hTmpBmp = tmpBmp.GetSafeHandle();
	//

	HBITMAP hTmpBmp = ImgDLLLoadResourceBMP(AfxGetInstanceHandle(),
											(LPSTR)IDB_SAMPLE_IMAGE,
											hPal);

	if (hTmpBmp==NULL) {
		AfxMessageBox(StringFromErrorNum(ImgDLLGetLastError()));
		return;
	}

	// get an RGB buffer from our HBITMAP, use the palette to render the bitmap
	HGLOBAL hImg = ImgDLLHBITMAPToRGB(hTmpBmp, 
							  &m_width, 
							  &m_height,
							  (HPALETTE)m_pal.GetSafeHandle());

	// clean up - me have the RGB buffer, we don't need the HBITMAP anymore
	::DeleteObject(hTmpBmp);

	if (hImg!=NULL) {

		BYTE *pImg = (BYTE *)GlobalLock(hImg);

		if (pImg!=NULL) {

			// copy it to our buffer
			DWORD imgByteSize = (m_width * m_height * 3);
			
			// alloc our buffer
			try {
				m_rgbBuf = (BYTE *) new BYTE[imgByteSize];
			} catch (CMemoryException *e) {
				e->ReportError();
				e->Delete();
				CleanUp();
			}

			// copy
			memcpy(m_rgbBuf, pImg, imgByteSize);

			InvalidateBeforeImage();
			InvalidateAfterImage();

			GlobalUnlock(hImg);
		} else {
			AfxMessageBox("Failed to lock ptr");
			CleanUp();
		}
		GlobalFree(hImg);
	} else {
		AfxMessageBox(StringFromErrorNum(ImgDLLGetLastError()));
		return;
	}
}

////////////////////////////////////////////////////////////////////////

CString CImgDlg::StringFromErrorNum(int err)
{
	CString out;
	out.Format("Error #%d", err);

	switch (err) {
	default 			:		
		break;
	case IMGOK			:		out="No error"; 
		break;
	case NOGIFERR		:		out="No GIF support.."; 
		break;
	case CALLBACKCANCEL :		out="Operation cancelled by callback";
		break;
	case PNGCREATEERR	:		out="Internal PNG creation error - possibly bad params";
		break;	
	case IMGDLLINTERNAL :		out="Internal ImgDLL error";
		break;
	case IMGFONTERR		:		out="Font creation error";
		break;
	case MEMERR			:		out="Error : out of memory";
		break;
	case FILEOPENERR	:		out="Error on file open";
		break;
	case FILEREADERR	:		out="Error on file read";
		break;
	case FILEWRITEERR	:		out="Error on file write";
		break;
	case BADPARAMERR	:		out="Bad user param";
		break;
	case INVALIDBMPERR	:		out="Bad BMP file";
		break;
	case BMPRLEERR		:		out="We don't do RLE BMP files";
		break;
	case INVALIDGIFERR	:		out="Bad GIF file";
		break;
	case INVALIDTIFFERR	:		out="Bad TIF file";
		break;
	case INVALIDJPGERR	:		out="Bad jpg file";
		break;
	case TRIALVERSION	:		out = "DLL unlocked to Trial level functionality only";
		break;
	case IMGDCERR		:		out = "Device error";
		break;
	case IMGDIBERR		:		out = "GetDIBits error";
		break;
	case IMGNORESOURCE	:		out = "Resource Not Found";
		break;
	}

	return out;
}


void CImgDlg::OnAbout() 
{
	CAboutDlg dlgAbout;
	dlgAbout.DoModal();
}


// creates a spread of colors - no real method, just a semi-even spread
// this is all you really need to get better than Windows standard...
void CImgDlg::MakePalette()
{ 
	LPLOGPALETTE     lpPal;
	BYTE *           pLogPal;
	HPALETTE         hPal = NULL;
	int              i;

	try {
		pLogPal = new BYTE [sizeof (LOGPALETTE) + (sizeof (PALETTEENTRY) * (256))];
	} catch (CMemoryException *e) {
		e->ReportError();
		e->Delete();
		pLogPal==NULL;
		return;
	}

	lpPal = (LPLOGPALETTE) pLogPal;
	lpPal->palVersion = 0x300;
	lpPal->palNumEntries = 256;

	int r,g,b;
	r=b=g=0;
	for (i=0;i<256;i++) {
		lpPal->palPalEntry[i].peRed   = r % 256;
		lpPal->palPalEntry[i].peGreen = g % 256;
		lpPal->palPalEntry[i].peBlue  = b % 256;
		lpPal->palPalEntry[i].peFlags = 0;

	   r+=16;
	   g+=4;
	   b++;
	}

	BOOL ok = m_pal.CreatePalette (lpPal);

	delete [] pLogPal;
}
