// imgDlg.h : header file
//

#if !defined(AFX_IMGDLG_H__F5E79507_40DD_11D1_8159_444553540000__INCLUDED_)
#define AFX_IMGDLG_H__F5E79507_40DD_11D1_8159_444553540000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

/////////////////////////////////////////////////////////////////////////////
// CImgDlg dialog

class CImgDlg : public CDialog
{
// Construction
public:
	CImgDlg(CWnd* pParent = NULL);	// standard constructor

	~CImgDlg();

// Dialog Data
	//{{AFX_DATA(CImgDlg)
	enum { IDD = IDD_IMGDEMO_DIALOG };
	CStatic	m_histoFrame;
	CStatic	m_colorTextWnd;
	CButton	m_hFlipCheck;
	CButton	m_histGreenCheck;
	CButton	m_histCheck;
	CButton	m_histRedCheck;
	CEdit	m_histLowWnd;
	CEdit	m_histHighWnd;
	CButton	m_histBlueCheck;
	CStatic	m_beforeRectWnd;
	CEdit	m_quantColorsWnd;
	CButton	m_quantCheck;
	CButton	m_LUTCheck;
	CButton	m_rgbbgrCheck;
	CButton	m_grayCheck;
	CButton	m_flipCheck;
	CStatic	m_imgRectWnd;
	CEdit	m_sharpenLevelWnd;
	CButton	m_sharpenCheck;
	CEdit	m_matrix8Wnd;
	CEdit	m_matrix7Wnd;
	CEdit	m_matrix6Wnd;
	CEdit	m_matrix5Wnd;
	CEdit	m_matrix4Wnd;
	CEdit	m_matrix3Wnd;
	CEdit	m_matrix2Wnd;
	CEdit	m_matrix0Wnd;
	CEdit	m_matrix1Wnd;
	CButton	m_matrixZeroCheck;
	CButton	m_matrixRedCheck;
	CButton	m_matrixOnCheck;
	CEdit	m_matrixLevelWnd;
	CButton	m_matrixGreenCheck;
	CButton	m_matrixFeedbackCheck;
	CButton	m_matrixBlueCheck;
	CButton	m_LUTRedCheck;
	CButton	m_LUTGreenCheck;
	CButton	m_LUTBlueCheck;
	CEdit	m_BlurLevelWnd;
	CButton	m_BlurCheck;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CImgDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CImgDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnBlurCheck();
	afx_msg void OnChangeBlurLevel();
	afx_msg void OnFlip();
	afx_msg void OnGrayscale();
	afx_msg void OnLutBlue();
	afx_msg void OnLutGreen();
	afx_msg void OnLutRed();
	afx_msg void OnMatrixBlue();
	afx_msg void OnMatrixFeedback();
	afx_msg void OnMatrixGreen();
	afx_msg void OnChangeMatrixLevel();
	afx_msg void OnMatrixOn();
	afx_msg void OnMatrixRed();
	afx_msg void OnMatrixZero();
	afx_msg void OnChangeMatrix0();
	afx_msg void OnChangeMatrix1();
	afx_msg void OnChangeMatrix2();
	afx_msg void OnChangeMatrix3();
	afx_msg void OnChangeMatrix4();
	afx_msg void OnChangeMatrix5();
	afx_msg void OnChangeMatrix6();
	afx_msg void OnChangeMatrix7();
	afx_msg void OnChangeMatrix8();
	afx_msg void OnOpen();
	afx_msg void OnRgbbgr();
	afx_msg void OnSave();
	afx_msg void OnSharpenCheck();
	afx_msg void OnChangeSharpenLevel();
	afx_msg void OnInvlut();
	afx_msg void OnLinlut();
	afx_msg void OnLutcheck();
	afx_msg void OnQuantizeCheck();
	afx_msg void OnAbout();
	afx_msg void OnChangeQuantColors();
	afx_msg void OnHistBlue();
	afx_msg void OnHistGreen();
	afx_msg void OnChangeHistHigh();
	afx_msg void OnChangeHistLow();
	afx_msg void OnHistRed();
	afx_msg void OnHistcheck();
	afx_msg void OnHorizflip();
	afx_msg void OnRotate180();
	afx_msg void OnRotate270();
	afx_msg void OnRotate90();
	afx_msg void OnRotateNone();
	afx_msg void OnEqBlue();
	afx_msg void OnEqGreen();
	afx_msg void OnEqLum();
	afx_msg void OnEqRed();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

protected:
	BOOL	m_doGray;
	BOOL	m_doRGBBGR;
	BOOL	m_doFlip;
	BOOL	m_doLUT;
	BOOL	m_doMatrix;
	BOOL	m_doSharpen;
	BOOL	m_doBlur;
	BOOL	m_doQuantize;
	BOOL	m_doEQ;

	// sharpen
	int		m_iSharpenLevel;

	// blur
	int		m_iBlurLevel;

	BOOL	m_doHFlip ;
	// LUT
	BYTE	m_LUT[256];
	BYTE	m_LUTChannelMask;
	BOOL	m_linLut;

	// EQ
	BYTE	m_EQChannelMask;
	int		m_iEQLowLevel;
	int		m_iEQHighLevel;

	// eq graph
	BYTE	m_EQGraphMask;
	int		m_EQHisto[256];

	// matrix 
	double	m_fMatrix[9];
	double	m_fMatrixLevel;
	BOOL	m_bZero;
	BOOL	m_bFeedback;
	BYTE	m_MatrixChannelMask;

	// quantize
	int		m_iQuantColors;

	// global image buffer
	BYTE	*m_rgbBuf;
	UINT	m_width;
	UINT	m_height;

	// global palette
	CPalette m_pal;

	int		m_quickRotationType;

protected:
	void	CleanUp();
	void	SetAllControls();
	void	LoadDefaultImage();
	CString StringFromErrorNum(int err);
	BYTE *	RenderImage();
	void	InvalidateAfterImage();
	void	InvalidateBeforeImage();
	void	SetLUT();
	void	MakePalette();

};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_IMGDLG_H__F5E79507_40DD_11D1_8159_444553540000__INCLUDED_)
