VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "DeskPad"
   ClientHeight    =   4365
   ClientLeft      =   7965
   ClientTop       =   1125
   ClientWidth     =   3165
   FillColor       =   &H00C0C0C0&
   Icon            =   "deskpad.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   4365
   ScaleWidth      =   3165
   WhatsThisHelp   =   -1  'True
   Begin VB.TextBox Text1 
      BackColor       =   &H00C0C0C0&
      ForeColor       =   &H00000000&
      Height          =   4335
      Left            =   0
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   0
      Top             =   0
      Width           =   3135
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Index           =   0
      Begin VB.Menu mnuSave 
         Caption         =   "&Save text and options"
         Index           =   4
         Shortcut        =   {F2}
      End
      Begin VB.Menu mnuRevert 
         Caption         =   "&Revert to saved text"
         Index           =   11
         Shortcut        =   {F4}
      End
      Begin VB.Menu mnuQuit 
         Caption         =   "&Quit - don't save anything"
         Index           =   1
         Shortcut        =   {F9}
      End
      Begin VB.Menu fence1 
         Caption         =   "-"
         Index           =   99
      End
      Begin VB.Menu mnuPrint 
         Caption         =   "&Print"
         Index           =   2
         Shortcut        =   {F7}
      End
      Begin VB.Menu fence2 
         Caption         =   "-"
         Index           =   98
      End
      Begin VB.Menu mnuExitAndSave 
         Caption         =   "Save text and options then &Exit"
         Index           =   3
         Shortcut        =   {F8}
      End
   End
   Begin VB.Menu mnuedit 
      Caption         =   "&Edit"
      Index           =   31
      Begin VB.Menu mnucopy 
         Caption         =   "Copy"
         Index           =   32
         Shortcut        =   ^C
      End
      Begin VB.Menu mnucut 
         Caption         =   "Cut"
         Index           =   33
         Shortcut        =   ^X
      End
      Begin VB.Menu mnupaste 
         Caption         =   "Paste"
         Index           =   34
         Shortcut        =   ^V
      End
      Begin VB.Menu mnuDelete 
         Caption         =   "Delete"
         Index           =   35
         Shortcut        =   +{DEL}
      End
   End
   Begin VB.Menu mnuoptions 
      Caption         =   "&Options"
      Begin VB.Menu mnufont 
         Caption         =   "Screen Font"
         Begin VB.Menu mnuSans 
            Caption         =   "MS Sans Serif"
         End
         Begin VB.Menu mnucourier 
            Caption         =   "Courier"
         End
      End
      Begin VB.Menu mnufontsize 
         Caption         =   "Screen &Font size"
         Begin VB.Menu font8 
            Caption         =   "8 pt"
         End
         Begin VB.Menu font10 
            Caption         =   "10 pt"
         End
         Begin VB.Menu font12 
            Caption         =   "12 pt"
         End
      End
      Begin VB.Menu fence4 
         Caption         =   "-"
      End
      Begin VB.Menu mnulinesperpage 
         Caption         =   "Lines per printed page"
         Begin VB.Menu mnu60lpp 
            Caption         =   "60"
         End
         Begin VB.Menu mnu65lpp 
            Caption         =   "65"
         End
         Begin VB.Menu mnu70lpp 
            Caption         =   "70"
         End
      End
      Begin VB.Menu mnuwordwrappos 
         Caption         =   "Wordwrap printed pages at character"
         Begin VB.Menu mnuwrap60 
            Caption         =   "60"
         End
         Begin VB.Menu mnuwrap65 
            Caption         =   "65"
         End
         Begin VB.Menu mnuwrap70 
            Caption         =   "70"
         End
         Begin VB.Menu mnuwrap75 
            Caption         =   "75"
         End
      End
      Begin VB.Menu fence5 
         Caption         =   "-"
      End
      Begin VB.Menu mnuStayOnTop 
         Caption         =   "Stay on top"
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Index           =   5
      Begin VB.Menu mnuHow2Use 
         Caption         =   "&How to use DeskPad"
         Index           =   7
         Shortcut        =   {F1}
      End
      Begin VB.Menu fence3 
         Caption         =   "-"
      End
      Begin VB.Menu mnuAbout 
         Caption         =   "&About DeskPad"
         Index           =   6
         Shortcut        =   {F11}
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False


Dim linesperpage As Integer
Dim wordwrappos As Integer
Dim nl As String
Dim tempfilename As String
Dim stayontop As String
Private Declare Function SetWindowPos Lib "User32" ( _
    ByVal hwnd As Long, _
    ByVal hWndInsertionAfter As Long, _
    ByVal x As Long, _
    ByVal y As Long, _
    ByVal cx As Long, _
    ByVal cy As Long, _
    ByVal wFlags As Long _
  ) As Long ' used by Stay On Top feature
  
Private Sub DisableStayOnTop()
SetWindowPos hwnd, -2, 0, 0, 0, 0, &H2 Or &H1
stayontop = "No"
mnuStayOnTop.Checked = False
End Sub

Private Sub EnableStayOnTop()

SetWindowPos hwnd, -1, 0, 0, 0, 0, &H2 Or &H1
stayontop = "Yes"
mnuStayOnTop.Checked = True
End Sub
Private Sub font10_Click()
Text1.FontSize = 10
checkfontsize
End Sub

Private Sub font12_Click()
Text1.FontSize = 12
checkfontsize
End Sub

Private Sub font8_Click()
Text1.FontSize = 8
checkfontsize
End Sub
Private Sub Form_Load()

tempfilename = App.Path & "\$deskpad.tmp"

nl = Chr$(13) + Chr$(10)

If App.PrevInstance Then
MsgBox "Error:  DeskPad is already running", , "Silly"
End
End If

Text1.Text = ""
If Dir$(App.Path & "\deskpad.txt") <> "" Then
 Open App.Path & "\deskpad.txt" For Input As #1
 Do While Not EOF(1)
 Line Input #1, a$
 If Len(Text1.Text) > 0 Then Text1.Text = Text1.Text & nl & a$
 If Len(Text1.Text) = 0 Then Text1.Text = Text1.Text & a$
 Loop
 Close 1
getallsettings   ' read font, layout etc settings from registry

End If
End Sub

Private Sub getallsettings()
Form1.Top = GetSetting("DeskPad", "Screen Layout", "WindowTop", 300)
Form1.Left = GetSetting("DeskPad", "Screen Layout", "WindowLeft", 1000)
Form1.Height = GetSetting("DeskPad", "Screen Layout", "WindowHeight", 4000)
Form1.Width = GetSetting("DeskPad", "Screen Layout", "WindowWidth", 3500)
Text1.FontSize = GetSetting("DeskPad", "Screen Layout", "FontSize", 8)
checkfontsize
Text1.Font = GetSetting("DeskPad", "Screen Layout", "Font", "MS Sans Serif")
checkfontname
x = GetSetting("DeskPad", "Screen Layout", "StayOnTop", "No")
If x = "No" Then DisableStayOnTop
If x = "Yes" Then EnableStayOnTop
linesperpage = GetSetting("DeskPad", "Screen Layout", "LinesPerPage", 60)
wordwrappos = GetSetting("DeskPad", "Screen Layout", "WordWrapPos", 60)
checklinesperpage
checkwordwrappos
End Sub
Private Sub checkfontsize()
' These Int() and other weird comparisons are because setting the font
' to 8, 10 and 12 seems to return fontsizes of 8.25, 9.75 and 12!!
If Int(Text1.FontSize) = 8 Then font8.Checked = True Else font8.Checked = False
If Int(Text1.FontSize) >= 9 And Int(Text1.FontSize) <= 11 Then font10.Checked = True Else font10.Checked = False
If Int(Text1.FontSize) = 12 Then font12.Checked = True Else font12.Checked = False
End Sub
Private Sub checkfontname()
If Text1.Font = "MS Sans Serif" Then mnuSans.Checked = True Else mnuSans.Checked = False
If Text1.Font = "Courier New" Then mnucourier.Checked = True Else mnucourier.Checked = False
End Sub
Private Sub checkwordwrappos()
' tick the relevant menu option
If wordwrappos = 60 Then mnuwrap60.Checked = True Else mnuwrap60.Checked = False
If wordwrappos = 65 Then mnuwrap65.Checked = True Else mnuwrap65.Checked = False
If wordwrappos = 70 Then mnuwrap70.Checked = True Else mnuwrap70.Checked = False
If wordwrappos = 75 Then mnuwrap75.Checked = True Else mnuwrap75.Checked = False
End Sub
Private Sub checklinesperpage()
' tick the relevant menu option
If linesperpage = 60 Then mnu60lpp.Checked = True Else mnu60lpp.Checked = False
If linesperpage = 65 Then mnu65lpp.Checked = True Else mnu65lpp.Checked = False
If linesperpage = 70 Then mnu70lpp.Checked = True Else mnu70lpp.Checked = False
End Sub
Private Sub Form_Resize()
If Form1.Height > 720 Then Text1.Height = Form1.Height - 720
If Form1.Width > 150 Then Text1.Width = Form1.Width - 150
End Sub

Private Sub saveallsettings()
SaveSetting "DeskPad", "Screen Layout", "WindowLeft", Form1.Left
SaveSetting "DeskPad", "Screen Layout", "WindowTop", Form1.Top
SaveSetting "DeskPad", "Screen Layout", "WindowHeight", Form1.Height
SaveSetting "DeskPad", "Screen Layout", "WindowWidth", Form1.Width
SaveSetting "DeskPad", "Screen Layout", "FontSize", Text1.FontSize
SaveSetting "DeskPad", "Screen Layout", "Font", Text1.Font
SaveSetting "DeskPad", "Screen Layout", "StayOnTop", stayontop
SaveSetting "DeskPad", "Screen Layout", "LinesPerPage", linesperpage
SaveSetting "DeskPad", "Screen Layout", "WordWrapPos", wordwrappos
End Sub

Private Sub mnu60lpp_Click()
linesperpage = 60
checklinesperpage
End Sub

Private Sub mnu65lpp_Click()
linesperpage = 65
checklinesperpage
End Sub

Private Sub mnu70lpp_Click()
linesperpage = 70
checklinesperpage
End Sub

Private Sub mnuAbout_Click(index As Integer)
a$ = "DeskPad v"
a$ = a$ + Trim(Str$(App.Major)) + "."
a$ = a$ + Trim(Str$(App.Minor)) + "."
a$ = a$ + Trim(Str$(App.Revision))
a$ = a$ + nl
a$ = a$ + "Written by Robert Schifreen." + nl
a$ = a$ + "Copyright Oakworth Software 1998." + nl
a$ = a$ + "DeskPad is freeware.  Distribute freely." + nl + nl
MsgBox a$, , "DeskPad"
End Sub

Private Sub mnucopy_Click(index As Integer)
Clipboard.Clear
Clipboard.SetText Screen.ActiveControl.SelText
End Sub

Private Sub mnucourier_Click()
Text1.Font = "Courier New"
checkfontname
End Sub

Private Sub mnucut_Click(index As Integer)
Screen.ActiveControl.SelText = ""
End Sub

Private Sub mnuDelete_Click(index As Integer)
Screen.ActiveControl.SelText = ""
End Sub

Private Sub mnuExitAndSave_Click(index As Integer)
saveallsettings
Open App.Path & "\deskpad.txt" For Output As #1
Print #1, Text1.Text
Close 1
End
End Sub

Private Sub mnuHow2Use_Click(index As Integer)
a$ = ""

a$ = a$ + "DeskPad is a simple notepad app for" + nl
a$ = a$ + "Windows 95 and NT.  It is freeware." + nl + nl

a$ = a$ + "It displays the contents of deskpad.txt" + nl
a$ = a$ + "in an editable window on the desktop," + nl
a$ = a$ + "as a handy place for a to-do list or" + nl
a$ = a$ + "other notes, phone numbers etc." + nl + nl

a$ = a$ + "You'll always find the latest version at:" + nl
a$ = a$ + "www.oakworth.demon.co.uk/deskpad.htm." + nl + nl

a$ = a$ + "Deskpad.txt, which is a plain ASCII text file," + nl
a$ = a$ + "must be in the same directory from which" + nl
a$ = a$ + "the DESKPAD.EXE program is run." + nl + nl

a$ = a$ + "Note that you need the Microsoft Visual" + nl
a$ = a$ + "Basic 5.0 runtime file (MSVBVM50.DLL) in " + nl
a$ = a$ + "your \windows\system directory to use" + nl
a$ = a$ + "DeskPad.  If you don't have it, you can" + nl
a$ = a$ + "get it from Microsoft's web site." + nl + nl

a$ = a$ + "You can contact the author as:" + nl
a$ = a$ + "deskpad@oakworth.demon.co.uk" + nl + nl

a$ = a$ + "And that's it!" + nl + nl

Title = "DeskPad v"
Title = Title + Trim(Str$(App.Major)) + "."
Title = Title + Trim(Str$(App.Minor)) + "."
Title = Title + Trim(Str$(App.Revision))
MsgBox a$, , Title

End Sub

Private Sub mnupaste_Click(index As Integer)
Screen.ActiveControl.SelText = Clipboard.GetText()
End Sub

Private Sub mnuPrint_Click(index As Integer)

' Print is hard-coded to 10 pt courier new.  5 char left margin.

Printer.FontName = "Courier New"
Printer.FontSize = 10

' It's easier to read lines from a text file than a text box
' so write text box to a temp file.

If Dir$(tempfilename) <> "" Then  ' tmp file already exists
Kill tempfilename
End If

Open tempfilename For Output As #1
Print #1, Text1.Text
Close 1

' linesperpage and wordWrapPos are user settings from registry
Open tempfilename For Input As 1

linesprinted = 0
printheader
Do While Not EOF(1)
Line Input #1, a$
If Len(a$) <= wordwrappos Then      ' line is OK, so print and inc counter
Printer.Print "     " & a$
linesprinted = linesprinted + 1
Else

' line is too long, so split it.
a$ = a$ & " " ' makes things easier!
myline = ""
print1:
i = InStr(a$, " ")
If i = 0 Then GoTo print2  ' we're finished
myword = Left$(a$, i)
a$ = Right$(a$, Len(a$) - i)
myline = myline & myword
If Len(myline) >= wordwrappos Then
  Printer.Print "     " & Trim(myline)
  myline = ""
  linesprinted = linesprinted + 1
End If
GoTo print1
print2:
If Len(myline) > 0 Then
  Printer.Print "     " & Trim(myline)
  linesprinted = linesprinted + 1
End If
' end of long-line-split code

End If

If linesprinted >= linesperpage Then  ' >= in case long split line overruns
Printer.NewPage
printheader
linesprinted = 0
End If
Loop
Close 1
Printer.EndDoc  ' Do the printing
Kill tempfilename
End Sub

Private Sub printheader()
Printer.FontBold = True
x = Printer.FontSize
Printer.FontSize = 9
Printer.Print "     " & LCase$(App.Path & "\deskpad.txt on " & Date & " at " & Time) & " - Page " & Printer.Page
Printer.FontBold = False
Printer.FontSize = x
Printer.Print ""  ' leave blank line under header
End Sub

Private Sub mnuQuit_Click(index As Integer)
End
End Sub

Private Sub mnuRevert_Click(index As Integer)
If Dir$(App.Path & "\deskpad.txt") <> "" Then
 Text1.Text = ""
 Open App.Path & "\deskpad.txt" For Input As #1
 Do While Not EOF(1)
 Line Input #1, a$
 If Len(Text1.Text) > 0 Then Text1.Text = Text1.Text & nl & a$
 If Len(Text1.Text) = 0 Then Text1.Text = Text1.Text & a$
 Loop
 Close 1
Else
MsgBox "Error: deskpad.txt not found"
End If
End Sub

Private Sub mnuSans_Click()
Text1.Font = "MS Sans Serif"
checkfontname
End Sub

Private Sub mnuSave_Click(index As Integer)
saveallsettings
Open App.Path & "\deskpad.txt" For Output As #1
Print #1, Text1.Text
Close 1
End Sub

Private Sub mnuStayOnTop_Click()
x = stayontop
If x = "No" Then
EnableStayOnTop
Else
DisableStayOnTop
End If
End Sub

Private Sub mnuwrap60_Click()
wordwrappos = 60
checkwordwrappos
End Sub

Private Sub mnuwrap65_Click()
wordwrappos = 65
checkwordwrappos
End Sub

Private Sub mnuwrap70_Click()
wordwrappos = 70
checkwordwrappos
End Sub

Private Sub mnuwrap75_Click()
wordwrappos = 75
checkwordwrappos
End Sub
