/*
 * Decompiled with CFR 0.152.
 */
package barcode.bean;

import barcode.bean.AboutFrame;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.Serializable;

public class BarCode3of9
extends Canvas
implements Serializable {
    private static String alphabet3of9 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%*";
    private static String[] coded3of9Char = new String[]{"000110100", "100100001", "001100001", "101100000", "000110001", "100110000", "001110000", "000100101", "100100100", "001100100", "100001001", "001001001", "101001000", "000011001", "100011000", "001011000", "000001101", "100001100", "001001100", "000011100", "100000011", "001000011", "101000010", "000010011", "100010010", "001010010", "000000111", "100000110", "001000110", "000010110", "110000001", "011000001", "111000000", "010010001", "110010000", "011010000", "010000101", "110000100", "011000100", "010101000", "010100010", "010001010", "000101010", "010010100"};
    public static final int CODE3OF9 = 0;
    public static final int CODE3OF9CHK = 1;
    public static final int SMALL = 1;
    public static final int MEDIUM = 2;
    public static final int LARGE = 3;
    public static final int BASELINE = 0;
    public static final int MIDDLELINE = 1;
    public static final int TOPLINE = 2;
    private static final int DEFWIDTH = 50;
    private static final int DEFHEIGHT = 25;
    private static final boolean DEFTEXTINS = true;
    private static final int DEFSIZE = 1;
    private static final Color DEFBACKCOLOR = Color.white;
    private static final Color DEFFORECOLOR = Color.black;
    private static final Font DEFFONT = new Font("Courier", 0, 12);
    private double wideToNarrowRatio = 3.0;
    private String intercharacterGap = "0";
    private double marginWidth;
    private double marginHeight;
    private double labelLength;
    private double labelHeight;
    private String stringToEncode = "";
    private String filledStringToEncode = "";
    private String encodedString = "";
    private int narrowestDim = 1;
    private boolean textInside = true;
    private int style = 0;
    private int initialWidth = 50;
    private int initialHeight = 25;
    private Color backColor = DEFBACKCOLOR;
    private Color foreColor = DEFFORECOLOR;
    private Font font = DEFFONT;
    private int textAlign = 2;

    public BarCode3of9() {
        this("3OF9", 50, 25, 1, 0, true, DEFBACKCOLOR, DEFFORECOLOR, DEFFONT, 2);
    }

    private BarCode3of9(String string, int n, int n2, int n3, int n4, boolean bl, Color color, Color color2, Font font, int n5) {
        this.stringToEncode = string;
        this.narrowestDim = n3;
        this.initialWidth = n;
        this.initialHeight = n2;
        this.textInside = bl;
        this.style = n4;
        this.backColor = color;
        this.foreColor = color2;
        this.font = font;
        this.textAlign = n5;
        this.Encode();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(this.initialWidth, this.initialHeight);
        return dimension;
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension(this.initialWidth, this.initialHeight);
        return dimension;
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public void resize(int n, int n2) {
        this.initialWidth = n;
        this.initialHeight = n2;
        super.resize(n, n2);
        this.repaint();
    }

    public void resize(Dimension dimension) {
        this.initialWidth = dimension.width;
        this.initialHeight = dimension.height;
        super.resize(dimension.width, dimension.height);
        this.repaint();
    }

    protected String paramString() {
        String string = String.valueOf(this.filledStringToEncode) + "," + this.initialWidth + "x" + this.initialHeight;
        return string;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.paramString() + "]";
    }

    public Dimension requestedMinimunSize(String string) {
        int n = string.length() * 16 * this.narrowestDim + 31 * this.narrowestDim;
        if (this.style == 1) {
            n += 16 * this.narrowestDim;
        }
        int n2 = Math.max((int)(0.15 * (double)n), 35);
        return new Dimension(n, n2);
    }

    public void setString(String string) throws IllegalArgumentException {
        this.stringToEncode = string;
        this.stringValidate();
        this.Encode();
    }

    public String getString() {
        return this.stringToEncode;
    }

    public void setDimension(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                this.narrowestDim = n;
                this.repaint();
                return;
            }
        }
        this.narrowestDim = 1;
        this.repaint();
    }

    public int getDimension() {
        return this.narrowestDim;
    }

    public void setTextInside(boolean bl) {
        this.textInside = bl;
        this.repaint();
    }

    public boolean isTextInside() {
        return this.textInside;
    }

    public void setStyle(int n) {
        switch (n) {
            case 0: 
            case 1: {
                this.style = n;
                this.Encode();
                return;
            }
        }
        this.style = 0;
        this.Encode();
    }

    public int getStyle() {
        return this.style;
    }

    public void setBackground(Color color) {
        this.backColor = color;
        this.repaint();
    }

    public Color getBackground() {
        return this.backColor;
    }

    public void setForeground(Color color) {
        this.foreColor = color;
        this.repaint();
    }

    public Color getForeground() {
        return this.foreColor;
    }

    public void setFont(Font font) {
        this.font = font;
        this.repaint();
    }

    public Font getFont() {
        return this.font;
    }

    public void setTextAlign(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.textAlign = n;
                this.repaint();
                return;
            }
        }
        this.textAlign = 2;
        this.repaint();
    }

    public int getTextAlign() {
        return this.textAlign;
    }

    public synchronized void paint(Graphics graphics) {
        int n = this.size().width;
        int n2 = this.size().height;
        graphics.setFont(this.font);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        int n3 = fontMetrics.getAscent();
        this.labelLength = this.filledStringToEncode.length() * 16 * this.narrowestDim;
        this.marginWidth = ((double)n - this.labelLength) / 2.0;
        this.marginHeight = ((double)n2 - this.labelLength) / 2.0;
        if (this.textInside) {
            if (this.textAlign == 0) {
                this.labelHeight = n2;
            }
            if (this.textAlign == 1) {
                this.labelHeight = n2 - n3 / 2;
            }
            if (this.textAlign == 2) {
                this.labelHeight = n2 - n3;
            }
        } else {
            this.labelHeight = n2;
        }
        graphics.setColor(this.backColor);
        graphics.fillRect(0, 0, n, n2);
        int n4 = this.encodedString.length();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        n5 = (int)this.marginWidth;
        n6 = 0;
        n7 = 0;
        n8 = 0;
        int n10 = 0;
        while (n10 < n4) {
            if (n10 % 2 == 0) {
                graphics.setColor(this.foreColor);
            } else {
                graphics.setColor(this.backColor);
            }
            n9 = Character.digit(this.encodedString.charAt(n10), 10) == 1 ? (int)(this.wideToNarrowRatio * (double)this.narrowestDim) : this.narrowestDim;
            graphics.fillRect(n7 + n5, n8 + n6, n9, (int)this.labelHeight);
            n7 += n9;
            ++n10;
        }
        if (this.textInside) {
            int n11 = fontMetrics.stringWidth(this.filledStringToEncode);
            int n12 = this.size().height;
            int n13 = (int)(this.marginWidth + this.labelLength / 2.0 - (double)(n11 / 2));
            graphics.setColor(this.backColor);
            graphics.fillRect(n13, n12 - n3, n11, n3);
            graphics.setColor(this.foreColor);
            graphics.drawString(this.filledStringToEncode, n13, n12);
        }
    }

    private void stringValidate() throws IllegalArgumentException {
        int n = this.stringToEncode.length();
        int n2 = 0;
        while (n2 < n) {
            if (alphabet3of9.indexOf(this.stringToEncode.charAt(n2)) == -1 || this.stringToEncode.indexOf("*") != -1) {
                throw new IllegalArgumentException("only digits and upper case letter for 3of9");
            }
            ++n2;
        }
    }

    private void Encode() {
        int n;
        int n2;
        this.filledStringToEncode = new String(this.stringToEncode);
        if (this.style == 1) {
            n2 = this.stringToEncode.length();
            n = 0;
            int n3 = 0;
            while (n3 < n2) {
                n += alphabet3of9.indexOf(this.stringToEncode.charAt(n3));
                ++n3;
            }
            this.filledStringToEncode = String.valueOf(this.filledStringToEncode) + alphabet3of9.charAt(n %= 43);
        }
        this.filledStringToEncode = "*" + this.filledStringToEncode + "*";
        this.encodedString = "";
        n2 = this.filledStringToEncode.length();
        n = 0;
        while (n < n2 - 1) {
            this.encodedString = String.valueOf(this.encodedString) + coded3of9Char[alphabet3of9.indexOf(this.filledStringToEncode.charAt(n))];
            this.encodedString = String.valueOf(this.encodedString) + this.intercharacterGap;
            ++n;
        }
        this.encodedString = String.valueOf(this.encodedString) + coded3of9Char[alphabet3of9.indexOf(this.filledStringToEncode.charAt(n2 - 1))];
        this.repaint();
    }

    final void showAboutFrame() {
        AboutFrame aboutFrame = new AboutFrame();
        aboutFrame.tell("\t\tBarCode3of9\n");
        aboutFrame.tell("\nfrom a full set of classes that implements the most common\n");
        aboutFrame.tell("bar code on the market\n\n");
        aboutFrame.tell("\tdeveloped by Umberto Marzo\n\n");
        aboutFrame.tell("Comments at:\numarzo@eniware.it\n\n");
        aboutFrame.tell("The full set of classes, updates, documentation at:\n");
        aboutFrame.tell("www.geocities.com/SiliconValley/Pines/4619\n\n");
        aboutFrame.show();
    }
}

