unit DemoForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, msgdisp, ComCtrls,
  ShowForm,HelpForm;

type
  TForm1 = class(TForm)
	edt_AbortCaption: TEdit;
	Label1: TLabel;
	Label2: TLabel;
	Label3: TLabel;
	GroupBox1: TGroupBox;
	chk_doLockParent: TCheckBox;
	chk_doWaitForClick: TCheckBox;
	chk_doForbidTimer: TCheckBox;
	chk_doShowButton: TCheckBox;
	chk_doLockApplication: TCheckBox;
	Label4: TLabel;
    edt_AsyncDelay: TEdit;
    com_Types: TComboBox;
    mem_Status: TMemo;
    UpDown1: TUpDown;
    SBar: TStatusBar;
    GroupBox2: TGroupBox;
    Button4: TButton;
    Button3: TButton;
    Button2: TButton;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure chk_doLockParentClick(Sender: TObject);
    procedure edt_AbortCaptionChange(Sender: TObject);
    procedure com_TypesClick(Sender: TObject);
    procedure com_TypesDblClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private-Deklarationen }
  public
	{ Public-Deklarationen }
	procedure SetControls;
	procedure GetControls;
	procedure DispHint(Sender : TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
	GetControls;
	if (Form2.MsgDisplay1.AsyncDisplay) then SBar.SimpleText:='AsyncDisplay returns: True'
	else SBar.SimpleText:='AsyncDisplay returns: False';
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
	GetControls;
	if (Form2.MsgDisplay1.OpenDisplay) then SBar.SimpleText:='OpenDisplay returns: True'
	else SBar.SimpleText:='OpenDisplay returns: False';
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
	if (Form2.MsgDisplay1.CloseDisplay) then SBar.SimpleText:='CloseDisplay returns: True'
	else SBar.SimpleText:='CloseDisplay returns: False';
end;

procedure TForm1.SetControls;
begin
	edt_AbortCaption.Text:=Form2.MsgDisplay1.AbortCaption;
	edt_AsyncDelay.Text:=IntToStr(Form2.MsgDisplay1.AsyncDelay);
	com_Types.ItemIndex:=Ord(Form2.MsgDisplay1.Types);
	mem_Status.Lines.Assign(Form2.MsgDisplay1.Status);
	chk_doLockParent.Checked:=doLockParent in Form2.MsgDisplay1.Options;
	chk_doWaitForClick.Checked:=doWaitForClick in Form2.MsgDisplay1.Options;
	chk_doForbidTimer.Checked:=doForbidTimer in Form2.MsgDisplay1.Options;
	chk_doShowButton.Checked:=doShowButton in Form2.MsgDisplay1.Options;
	chk_doLockApplication.Checked:=doLockApplication in Form2.MsgDisplay1.Options;
end;

procedure TForm1.GetControls;
begin
	Form2.MsgDisplay1.AbortCaption:=edt_AbortCaption.Text;
	Form2.MsgDisplay1.AsyncDelay:=StrToInt(edt_AsyncDelay.Text);
	Form2.MsgDisplay1.Types:=TMsgDisplayTypes(com_Types.ItemIndex);
	Form2.MsgDisplay1.Status.Assign(mem_Status.Lines);
	if (chk_doLockParent.Checked) then Form2.MsgDisplay1.Options:=Form2.MsgDisplay1.Options+[doLockParent]
	else Form2.MsgDisplay1.Options:=Form2.MsgDisplay1.Options-[doLockParent];
	if (chk_doWaitForClick.Checked) then Form2.MsgDisplay1.Options:=Form2.MsgDisplay1.Options+[doWaitForClick]
	else Form2.MsgDisplay1.Options:=Form2.MsgDisplay1.Options-[doWaitForClick];
	if (chk_doForbidTimer.Checked) then Form2.MsgDisplay1.Options:=Form2.MsgDisplay1.Options+[doForbidTimer]
	else Form2.MsgDisplay1.Options:=Form2.MsgDisplay1.Options-[doForbidTimer];
	if (chk_doShowButton.Checked) then Form2.MsgDisplay1.Options:=Form2.MsgDisplay1.Options+[doShowButton]
	else Form2.MsgDisplay1.Options:=Form2.MsgDisplay1.Options-[doShowButton];
	if (chk_doLockApplication.Checked) then Form2.MsgDisplay1.Options:=Form2.MsgDisplay1.Options+[doLockApplication]
	else Form2.MsgDisplay1.Options:=Form2.MsgDisplay1.Options-[doLockApplication];
end;

procedure TForm1.FormShow(Sender: TObject);
begin
	ShowMessage(
	'Welcome to the demo application of TMsgDisplay'+#13+#10+
	'TMsgDisplay is just a Panel which will be opened while a long'+#13+#10+
	'operation is in progress to inform the user about the current status'+#13+#10+
	'You can use TMsgDisplay also as a Warning Display with a given timeout delay'+#13+#10+
	'So you can e.g. Inform the user about a failed text search etc. without the'+#13+#10+
	'disadvantage the MessageBox function have (Locking the application until the user'+#13+#10+
	'clicks on the okay button). Just set the timeout to 10 seconds, done.'+#13+#10+
	'Note: There is also an enhanced version of TMsgDisplay availble which displays an'+#13+#10+
	'additional progressbar and a percentage label');
	ShowMessage(
	'Set the properties of the TMsgDisplay included in the SampleForm'+#13+#10+
	'Hold the mouse cursor over a control to display its hint in the help'+#13+#10+
	'window. Use the function call buttons to open/close the Msgdisplay');
	Form2.Show;
	Form3.Show;
	SetControls;
	Application.OnHint:=DispHint;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
	GetControls;
	Form2.MsgDisplay1.Apply;
end;

procedure TForm1.chk_doLockParentClick(Sender: TObject);
begin
	if (Sender = chk_doLockParent) then
	begin
		if (Sender as TCheckBox).Checked then Form2.MsgDisplay1.Options:=Form2.MsgDisplay1.Options+[doLockParent]
		else Form2.MsgDisplay1.Options:=Form2.MsgDisplay1.Options-[doLockParent];
	end else if (Sender=chk_doLockApplication) then
	begin
		if (Sender as TCheckBox).Checked then Form2.MsgDisplay1.Options:=Form2.MsgDisplay1.Options+[doLockApplication]
		else Form2.MsgDisplay1.Options:=Form2.MsgDisplay1.Options-[doLockApplication];
	end else if (Sender=chk_doWaitForClick) then
	begin
		if (Sender as TCheckBox).Checked then Form2.MsgDisplay1.Options:=Form2.MsgDisplay1.Options+[doWaitForClick]
		else Form2.MsgDisplay1.Options:=Form2.MsgDisplay1.Options-[doWaitForClick];
	end else if (Sender=chk_doForbidTimer) then
	begin
		if (Sender as TCheckBox).Checked then Form2.MsgDisplay1.Options:=Form2.MsgDisplay1.Options+[doForbidTimer]
		else Form2.MsgDisplay1.Options:=Form2.MsgDisplay1.Options-[doForbidTimer];
	end else if (Sender=chk_doShowButton) then
	begin
		if (Sender as TCheckBox).Checked then Form2.MsgDisplay1.Options:=Form2.MsgDisplay1.Options+[doShowButton]
		else Form2.MsgDisplay1.Options:=Form2.MsgDisplay1.Options-[doShowButton];
	end;
end;

procedure TForm1.edt_AbortCaptionChange(Sender: TObject);
begin
	Form2.MsgDisplay1.AbortCaption:=edt_AbortCaption.Text;
end;

procedure TForm1.com_TypesClick(Sender: TObject);
begin
	Form2.MsgDisplay1.Types:=TMsgDisplayTypes(com_Types.ItemIndex);
end;

procedure TForm1.com_TypesDblClick(Sender: TObject);
begin
	ShowMessage('DblClick');
end;

procedure TForm1.DispHint(Sender : TObject);
begin
	if (length(Application.Hint)>0) then Form3.Label1.Caption:=Application.Hint;
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	ShowMessage(
	'TMsgDisplay is Freeware and Noteware :-)'+#13+#10+
	'this means: Feel free to use this component in Freeware and Shareware stuff'+#13+#10+
	'But you have to send me a notice, that you use my component and you have to'+#13+#10+
	'include a short message (i.e. in the Creadits section of the Readme.txt of'+#13+#10+
	'your application)'+#13+#10+
	'that you use the TMsgDisplay component (c) 1997 by H.P.G and a link to'+#13+#10+
	'my homepage and my email address'+#13+#10+#13+#10+
	'Addresses:'+#13+#10+
	'Homepage: http://members.aol.com/hpgue/hpgintl.htm'+#13+#10+
	'E-Mail: hpgue@aol.com'+#13+#10+#13+#10+
	'Feel free to send me any comment, suggestion, idea, money, etc.');
	CanClose:=true;
end;

end.
