unit DemoForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  hyperlnk, StdCtrls, ComCtrls, ColorGrd, ExtCtrls;

type
  Tfrm_Demo = class(TForm)
    Button1: TButton;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    Label1: TLabel;
    HyperLink1: THyperLink;
    TabSheet2: TTabSheet;
    HyperLink4: THyperLink;
    HyperLink5: THyperLink;
    Label2: TLabel;
    TabSheet3: TTabSheet;
    HyperLink2: THyperLink;
    HyperLink3: THyperLink;
    HyperLink6: THyperLink;
    HyperLink7: THyperLink;
    Label3: TLabel;
    tab_Custom: TTabSheet;
    HyperLink8: THyperLink;
    Label4: TLabel;
    Label5: TLabel;
    edt_CustomPrefix: TEdit;
    Label6: TLabel;
    edt_Caption: TEdit;
    tab_Properties: TTabSheet;
    Label7: TLabel;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    hl_Prop: THyperLink;
    Label8: TLabel;
    edt_PCustomPrefix: TEdit;
    Label9: TLabel;
    edt_PCaption: TEdit;
    clg_LVColor: TColorGrid;
    Label10: TLabel;
    Label11: TLabel;
    com_PLinkType: TComboBox;
    chk_PVisited: TCheckBox;
    SBar: TStatusBar;
    TabSheet4: TTabSheet;
    Label12: TLabel;
    HyperLink9: THyperLink;
    HyperLink10: THyperLink;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    HyperLink11: THyperLink;
    Label16: TLabel;
    HyperLink12: THyperLink;
    HyperLink13: THyperLink;
    Label17: TLabel;
    Image1: TImage;
    HyperLink14: THyperLink;
    edt_PAlias: TEdit;
    edt_PHint: TEdit;
    chk_PParentShowHint: TCheckBox;
    chk_PShowHint: TCheckBox;
    TabSheet6: TTabSheet;
    Label22: TLabel;
    Image2: TImage;
    HyperLink18: THyperLink;
    HyperLink19: THyperLink;
    Bevel1: TBevel;
    HyperLink20: THyperLink;
    HyperLink21: THyperLink;
    Menus: TTabSheet;
    Label23: TLabel;
    HyperLink22: THyperLink;
    Label24: TLabel;
    HyperLink23: THyperLink;
    Label25: TLabel;
    Label26: TLabel;
    Label27: TLabel;
    tab_Urls: TTabSheet;
    Label28: TLabel;
    Label29: TLabel;
    Label30: TLabel;
    Button2: TButton;
    ListBox1: TListBox;
    ListBox2: TListBox;
    Button3: TButton;
    procedure Button1Click(Sender: TObject);
    procedure edt_CustomPrefixChange(Sender: TObject);
    procedure edt_CaptionChange(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure clg_LVColorChange(Sender: TObject);
    procedure edt_PCaptionChange(Sender: TObject);
    procedure com_PLinkTypeClick(Sender: TObject);
    procedure chk_PVisitedClick(Sender: TObject);
    procedure edt_PCustomPrefixChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure HyperLink15Execute(Sender: TObject; var ExecuteIt: Boolean);
    procedure HyperLink16Execute(Sender: TObject; var ExecuteIt: Boolean);
    procedure HyperLink17Execute(Sender: TObject; var ExecuteIt: Boolean);
    procedure chk_PParentShowHintClick(Sender: TObject);
    procedure chk_PShowHintClick(Sender: TObject);
    procedure edt_PAliasChange(Sender: TObject);
    procedure edt_PHintChange(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);

  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    procedure DisplayHint(Sender : Tobject);
  end;

var
  frm_Demo: Tfrm_Demo;
  hl : THyperLink;

implementation

type
  IndexColorItem=record
      Color : TColor;
      Name  : String;
  end;

const
	NumOfColors=16;
	IndexColors : array[0..NumOfColors-1] of IndexColorItem=
  (
  	(Color:clBlack;Name:'clBlack'),
  	(Color:clMaroon;Name:'clMaroin'),
  	(Color:clGreen;Name:'clGreen'),
  	(Color:clOlive;Name:'clOlive'),
  	(Color:clNavy;Name:'clNavy'),
  	(Color:clPurple;Name:'clPurple'),
  	(Color:clTeal;Name:'clTeal'),
  	(Color:clSilver;Name:'clSilver'),
  	(Color:clGray;Name:'clGray'),
  	(Color:clRed;Name:'clRed'),
  	(Color:clLime;Name:'clLime'),
  	(Color:clYellow;Name:'clYellow'),
  	(Color:clBlue;Name:'clBlue'),
  	(Color:clFuchsia;Name:'clFuchsia'),
  	(Color:clAqua;Name:'clAqua'),
  	(Color:clWhite;Name:'clWhite')
  );

function GetColorString(index : integer) : String;
begin
	Result:=IndexColors[index].Name;
end;
function GetColor(index : integer) : TColor;
begin
	Result:=IndexColors[index].Color;
end;
function ColorToIndex(tc : TColor) : Integer;
var i : Integer;
begin
	Result:=-1;
	for i:=0 to NumOfColors do
  begin
  	if (GetColor(i)=tc) then
      begin
			Result:=i;
          Break;
      end;
  end;
end;
function StringToIndex(nm : String) : Integer;
var i : Integer;
begin
	Result:=-1;
	for i:=0 to NumOfColors do
  begin
  	if (GetColorString(i)=nm) then
      begin
			Result:=i;
          Break;
      end;
  end;
end;

{$R *.DFM}

procedure Tfrm_Demo.DisplayHint(Sender : Tobject);
begin
	if (length(Application.Hint)>0) then
  	SBar.SimpleText:=Application.Hint
  else
  	SBar.SimpleText:='Ready...';
end;

procedure Tfrm_Demo.Button1Click(Sender: TObject);
begin
	Close;
end;

procedure Tfrm_Demo.edt_CustomPrefixChange(Sender: TObject);
begin
	HyperLink8.CustomPrefix:=edt_CustomPrefix.Text;
end;

procedure Tfrm_Demo.edt_CaptionChange(Sender: TObject);
begin
	HyperLink8.Caption:=edt_Caption.Text;
end;

procedure Tfrm_Demo.PageControl1Change(Sender: TObject);
begin
	if (tab_Properties.Showing) then
  begin
		clg_LVColor.ForegroundIndex:=ColorToIndex(hl_Prop.LinkColor);
		clg_LVColor.BackgroundIndex:=ColorToIndex(hl_Prop.VisitedColor);
      edt_PCaption.Text:=hl_Prop.Caption;
      com_PLinkType.ItemIndex:=Integer(hl_Prop.LinkType);
      chk_PVisited.Checked:=hl_Prop.Visited;
      edt_PCustomPrefix.Text:=hl_Prop.CustomPrefix;
      hl_Prop.Invalidate;
  end
  else if (tab_Custom.Showing) then
  begin
		edt_CustomPrefix.Text:=HyperLink8.CustomPrefix;
      edt_Caption.Text:=HyperLink8.Caption;
      HyperLink8.Invalidate;
  end
  else if (tab_Urls.Showing) then
  begin
  	ListBox1.Items.Assign(UrlBase.VisitedUrlList);
  	ListBox2.Items.Assign(UrlBase.OtherUrls);
  end;
end;

procedure Tfrm_Demo.FormShow(Sender: TObject);
var
	IntroMsg : string;
begin
		clg_LVColor.ForegroundIndex:=ColorToIndex(hl_Prop.LinkColor);
		clg_LVColor.BackgroundIndex:=ColorToIndex(hl_Prop.VisitedColor);
      edt_PCaption.Text:=hl_Prop.Caption;
      com_PLinkType.ItemIndex:=Integer(hl_Prop.LinkType);
      chk_PVisited.Checked:=hl_Prop.Visited;
      edt_PCustomPrefix.Text:=hl_Prop.CustomPrefix;
      edt_PAlias.Text:=hl_Prop.Alias;
      edt_PHint.Text:=hl_Prop.Hint;
      chk_PParentShowHint.Checked:=hl_Prop.ParentShowHint;
      chk_PShowHint.Checked:=hl_Prop.ShowHint;
      if (Tag=0) then
      begin
          IntroMsg:='Welcome to the THyperLink 1.3 demo application'+#13+#13+
              'This component is (c) 1998 by H.P.G'+#13+#13+
              'You can obtain the newest versions always from my homepage'+#13+
              'the address is available on the tabsheet "About"'+#13+#13+
              'Click on "Ok" to continue...';

          ShowMessage(IntroMsg);
          Tag:=1;
      end;
end;

procedure Tfrm_Demo.clg_LVColorChange(Sender: TObject);
begin
		hl_Prop.LinkColor:=clg_LVColor.ForegroundColor;
		hl_Prop.VisitedColor:=clg_LVColor.BackgroundColor;
end;

procedure Tfrm_Demo.edt_PCaptionChange(Sender: TObject);
begin
		hl_Prop.Caption:=edt_PCaption.Text;
    FormShow(self);
end;

procedure Tfrm_Demo.com_PLinkTypeClick(Sender: TObject);
begin
		hl_Prop.LinkType:=TLinkType(com_PLinkType.ItemIndex);
    FormShow(self);
end;

procedure Tfrm_Demo.chk_PVisitedClick(Sender: TObject);
begin
		hl_Prop.Visited:=chk_PVisited.Checked;
    FormShow(self);
end;

procedure Tfrm_Demo.edt_PCustomPrefixChange(Sender: TObject);
begin
		hl_Prop.CustomPrefix:=edt_PCustomPrefix.Text;
    FormShow(self);
end;

procedure Tfrm_Demo.FormCreate(Sender: TObject);
begin
	Application.OnHint:=DisplayHint;
  Application.HintHidePause:=5000;
end;

procedure Tfrm_Demo.HyperLink15Execute(Sender: TObject;
  var ExecuteIt: Boolean);
begin
	  ExecuteIt:=false;
    ShowMessage(
    	'OnBeforeExecute is defined as follows:'+#13+#13+
        '    TExecuteEvent=procedure (Sender: TObject;var ExecuteIt:'+#13+
        '         boolean ) of object;'+#13+#13+
        'this event is fired when the user clicks on the THyperLink and'+#13+
        'before the OnExecute event occurs. Setting the ExecuteIt parameter'+#13+
        'to false will prevent THyperLink to execute the address.'+#13+
        'You can i.e. start another application than the associated one.');
end;

procedure Tfrm_Demo.HyperLink16Execute(Sender: TObject;
  var ExecuteIt: Boolean);
begin
	  ExecuteIt:=false;
    ShowMessage(
    	'OnExecute is defined as follows:'+#13+#13+
        '    TExecuteEvent=procedure (Sender: TObject;var ExecuteIt:'+#13+
        '        boolean ) of object;'+#13+#13+
        'this event is fired when the user clicks on the THyperLink and'+#13+
        'the OnBeforeExecute event allows the execution.'+#13+
        'Setting the ExecuteIt parameter to false will prevent THyperLink'+#13+
        'to execute the address. The difference to the OnBeforeExecute event'+#13+
        'is that the OnAfterExecute event will be always fired also when you set'+#13+
        'ExecuteIt to false which changes the VisitedColor and flag'+#13+
        'You can i.e. also start another application than the associated one.');
end;

procedure Tfrm_Demo.HyperLink17Execute(Sender: TObject;
  var ExecuteIt: Boolean);
begin
	  ExecuteIt:=false;
    ShowMessage(
    	'OnExecute is defined as follows:'+#13+#13+
        '    TAfterExecuteEvent=procedure (Sender: TObject;Reslt:'+#13+
        '        longint ) of object;'+#13+#13+
        'this event is fired when the user clicks on the THyperLink and'+#13+
        'the OnBeforeExecute and OnExecute event allows the execution.'+#13+
        'The Result parameter is the return value of the ShellExecute function'+#13+
        'call. If its value is smaller then 32 you got an error and the application'+#13+
        'could not be started. To determine the reason use the GetLastError()'+#13+
        'WINAPI function');
end;

procedure Tfrm_Demo.chk_PParentShowHintClick(Sender: TObject);
begin
    hl_Prop.ParentShowHint:=chk_PParentShowHint.Checked;
	  FormShow(self);
end;

procedure Tfrm_Demo.chk_PShowHintClick(Sender: TObject);
begin
    hl_Prop.ShowHint:=chk_PShowHint.Checked;
    FormShow(self);
end;

procedure Tfrm_Demo.edt_PAliasChange(Sender: TObject);
begin
	  hl_Prop.Alias:=edt_PAlias.Text;
	  FormShow(self);
end;

procedure Tfrm_Demo.edt_PHintChange(Sender: TObject);
begin
  hl_Prop.Hint:=edt_PHint.Text;
  FormShow(self);
end;

procedure Tfrm_Demo.Button2Click(Sender: TObject);
begin
 	ListBox1.Items.Assign(UrlBase.VisitedUrlList);
 	ListBox2.Items.Assign(UrlBase.OtherUrls);
end;

procedure Tfrm_Demo.Button3Click(Sender: TObject);
begin
	UrlBase.Reset();
 	ListBox1.Items.Assign(UrlBase.VisitedUrlList);
 	ListBox2.Items.Assign(UrlBase.OtherUrls);
end;

end.
