//---------------------------------------------------------------------------
#ifndef chessH
#define chessH
//---------------------------------------------------------------------------
#include <vcl\SysUtils.hpp>
#include <vcl\Controls.hpp>
#include <vcl\Classes.hpp>
#include <vcl\Forms.hpp>
#include "CHTYPES.H"
#include "CHTHREAD.H"
//---------------------------------------------------------------------------

class MoveInfo
{
    public:
    __fastcall MoveInfo(void);

    char position[66];
    CastleSet Castling;
    Square OldSquare, NewSquare;
    Square EnPassant;
};

class PACKAGE TChessBoard : public TGraphicControl
{
private:
    TThreadPriority _ThinkingPriority;
    bool _Thinking;
    char position[66];
    CastleSet _CastlingAllowed;
    int _SearchDepth;

    ChessThread *Now;
    Square _EnPassant;
    MoveInfo MoveList[256][2];

    int _ResizeMinSize,_ResizeMaxSize;

    bool ResizeState, _Resizable;
    char PromoteTo;
    int PieceIndex[2][6];

    int Boardx,Boardy,BoardSize;
    int PieceSize;
    int _SizeOfSquare;
    int _CurrentMove;

    StandardSet _StandardSize;

    TMoveEvent legalmove,check,mate,stalemate,castling;
    TNotifyEvent onlytwokingsleft,threefoldposition;
    TCaptureEvent capture;
    TOneSquareEvent illegalmove;
    TPromotionEvent promotion;

    String posstr;

    TImageList *list;
    Graphics::TBitmap *_SquareLight,*_SquareDark, *_BorderBitmap;
    TPen *_LineStyle;
    TFont *_CoordFont;

    CoordSet _DisplayCoords;

    int _SizeOfBorder;
    Square SquareClick1,SquareClick2;
    bool _ComputerPlaysWhite, _ComputerPlaysBlack;

    bool _WhiteOnTop,_WhiteToMove,_BoardLines;
    TColor _SquareColorLight, _SquareColorDark, _BorderColor;

    Graphics::TBitmap *_CustomPieceSet,  *Default;

    bool __fastcall BitmapExists(Graphics::TBitmap *bmp);
    bool __fastcall BitmapIsValidPieceSet (Graphics::TBitmap *bmp);
    bool __fastcall CheckForThreefoldPosition(void);
    bool __fastcall CheckLegalBishopMove(Square oldSq,Square newSq);
    bool __fastcall CheckLegalKingMove(Square oldSq, Square newSq);
    bool __fastcall CheckLegalKnightMove(Square oldSq,Square newSq);
    bool __fastcall CheckLegalPawnMove(Square oldSq,Square newSq);
    bool __fastcall CheckLegalQueenMove(Square oldSq,Square newSq);
    bool __fastcall CheckLegalRookMove(Square oldSq,Square newSq);
    bool __fastcall MoveIsLegal (Square oldSq, Square newSq);

    int  __fastcall PieceToInt (char piece);

    void __fastcall DoPromotion (Square sq);
    void __fastcall DrawBoard (void);
    void __fastcall DrawBorder (void);
    void __fastcall DrawPiece (Square sq, char piece);
    void __fastcall DrawPieces (void);
    void __fastcall Fillint (Square sq);
    void __fastcall FinishedThread (TObject *Sender);
    void __fastcall InitializeBitmaps (void);
    void __fastcall OrganizeBitmaps(void);

    //boring write methods
    void __fastcall set_BoardLines(bool show);
    void __fastcall set_BorderBitmap(Graphics::TBitmap *bmp);
    void __fastcall set_BorderColor(TColor c);
    void __fastcall set_SizeOfBorder (int border);
    void __fastcall set_ComputerPlaysBlack (bool computerplays);
    void __fastcall set_ComputerPlaysWhite (bool computerplays);
    void __fastcall set_CoordFont(TFont *font);
    void __fastcall set_CurrentMove (int moveno);
    void __fastcall set_CustomPieceSet(Graphics::TBitmap *bmp);
    void __fastcall set_DisplayCoords(CoordSet set);
    void __fastcall set_EnPassant (Square sq);
    void __fastcall set_Height(int hgt);
    void __fastcall set_LineStyle(TPen *pen);
    void __fastcall set_ResizeMaxSize (int size);
    void __fastcall set_ResizeMinSize (int size);
    void __fastcall set_PosStr(String pos);
    void __fastcall set_SearchDepth (int depth);
    void __fastcall set_SizeOfSquare(int size);
    void __fastcall set_SquareColorDark(TColor c);
    void __fastcall set_SquareColorLight(TColor c);
    void __fastcall set_SquareDark(Graphics::TBitmap *bmp);
    void __fastcall set_SquareLight(Graphics::TBitmap *bmp);
    void __fastcall set_StandardSize(StandardSet set);
    void __fastcall set_Thinking (bool thinking);
    void __fastcall set_ThinkingPriority (TThreadPriority priority);
    void __fastcall set_WhiteOnTop(bool wabove);
    void __fastcall set_WhiteSquareBitmap(Graphics::TBitmap *bmp);
    void __fastcall set_WhiteToMove(bool wmove);
    void __fastcall set_Width(int wdt);

protected:
    //Event handlers
    virtual void __fastcall Capture (System::TObject *Sender,  Square oldSq, Square newSq, char CapturedPiece);
    virtual void __fastcall Castle (System::TObject *Sender, Square oldSq, Square newSq);
    virtual void __fastcall Check (System::TObject *Sender,  Square oldSq, Square newSq);
    DYNAMIC void __fastcall Click(void);
    DYNAMIC void __fastcall DragCanceled(void);
    DYNAMIC void __fastcall DragDrop(System::TObject *Source,int X, int Y);
    DYNAMIC void __fastcall DragOver(System::TObject* Source, int X, int Y,TDragState State, bool &Accept );
    virtual void __fastcall EndDrag(bool drop);
    virtual void __fastcall IllegalMove (System::TObject *Sender,  Square sq);
    virtual void __fastcall LegalMove (System::TObject *Sender,  Square oldSq, Square newSq);
    virtual void __fastcall Mate (System::TObject *Sender,  Square oldSq, Square newSq);
    DYNAMIC void __fastcall MouseDown(TMouseButton Button, Classes::TShiftState Shift, int X, int Y);
    DYNAMIC void __fastcall MouseMove(Classes::TShiftState Shift, int X, int Y);
    DYNAMIC void __fastcall MouseUp(TMouseButton Button, Classes::TShiftState Shift, int X, int Y);
    virtual void __fastcall OnlyTwoKingsLeft (System::TObject *Sender);
    virtual void __fastcall Paint(void);
    virtual void __fastcall Promotion (System::TObject *Sender,  Square oldSq, Square newSq, char &NewPiece);
    virtual void __fastcall StaleMate (System::TObject *Sender,  Square oldSq, Square newSq);
    virtual void __fastcall ThreefoldPosition (System::TObject *Sender);
    virtual void __fastcall WndProc (TMessage &Message);

public:

    int FirstMove, LastMove;
    bool FirstTurn, LastTurn;

    //Constructor, destructor
    __fastcall TChessBoard(TComponent* Owner);
    virtual __fastcall ~TChessBoard(void);


    //Public interface
    void __fastcall MoveNow (void);
    void __fastcall CancelThinking(void);
    void __fastcall DrawChessPiece(TCanvas *canvas, int x, int y,char piece);
    bool __fastcall BlackInCheckAfter(Square oldSq, Square newSq);
    void __fastcall ClearSquare(Square sq);
    static int inline __fastcall ColorOfPiece (char piece);
    int  __fastcall ColorOfPiece (Square sq);
    int  __fastcall ColorOfSquare (Square sq);
    MoveInfo __fastcall GetMove (int moveno, bool WhiteMoves);
    TStringList* __fastcall GetMoveList (void);
    bool __fastcall GotoMove (int moveno, bool WhiteMoves);
    bool __fastcall LegalMoveAvailable (void);
    static Square inline __fastcall MouseToSquare (int x, int y);
    bool __fastcall Move (Square , Square );
    bool __fastcall MoveBackward (void);
    bool __fastcall MoveForward (void);
    void __fastcall NewGame(void);
    bool __fastcall SetUpPosition (MoveInfo &pos, int moveno, bool whitemoves);
    void __fastcall UpdateChessBoard (char *oldpos);
    bool __fastcall WhiteInCheckAfter(Square oldSq, Square newSq);
    Square __fastcall WindowToSquare (int x, int y);
    static int inline __fastcall XPos (Square sq);
    static int inline __fastcall YPos (Square sq);

__published:

    __property bool BoardLines={read=_BoardLines,write=set_BoardLines};
    __property bool ComputerPlaysBlack={read=_ComputerPlaysBlack, write=set_ComputerPlaysBlack};
    __property bool ComputerPlaysWhite={read=_ComputerPlaysWhite, write=set_ComputerPlaysWhite};
    __property bool Resizable={read=_Resizable, write=_Resizable};
    __property bool Thinking={read=_Thinking,write=set_Thinking};
    __property bool WhiteOnTop={read=_WhiteOnTop,write=set_WhiteOnTop};
    __property bool WhiteToMove={read=_WhiteToMove,write=set_WhiteToMove};
    __property CastleSet CastlingAllowed={read=_CastlingAllowed,write=_CastlingAllowed};
    __property CoordSet DisplayCoords={read=_DisplayCoords,write=set_DisplayCoords};
    __property Graphics::TBitmap *BorderBitmap={read=_BorderBitmap, write=set_BorderBitmap};
    __property Graphics::TBitmap *CustomPieceSet={read=_CustomPieceSet, write=set_CustomPieceSet};
    __property Graphics::TBitmap *SquareDark={read=_SquareDark, write=set_SquareDark};
    __property Graphics::TBitmap *SquareLight={read=_SquareLight, write=set_SquareLight};
    __property int  SearchDepth={read=_SearchDepth,write=set_SearchDepth};
    __property int CurrentMove={read=_CurrentMove, write=set_CurrentMove};
    __property int ResizeMaxSize={read=_ResizeMaxSize, write=set_ResizeMaxSize};
    __property int ResizeMinSize={read=_ResizeMinSize, write=set_ResizeMinSize};
    __property int SizeOfBorder={read=_SizeOfBorder, write=set_SizeOfBorder};
    __property int SizeOfSquare={read=_SizeOfSquare, write=set_SizeOfSquare};
    __property Square EnPassant={read=_EnPassant, write=set_EnPassant};
    __property StandardSet StandardSize={read=_StandardSize, write=set_StandardSize};
    __property String Position={read=posstr, write=set_PosStr};
    __property TColor BorderColor={read=_BorderColor, write=set_BorderColor};
    __property TColor SquareColorDark={read=_SquareColorDark, write=set_SquareColorDark};
    __property TColor SquareColorLight={read=_SquareColorLight, write=set_SquareColorLight};
    __property TFont *CoordFont={read=_CoordFont, write=set_CoordFont};
    __property TPen *LineStyle={read=_LineStyle, write=set_LineStyle};
    __property TThreadPriority ThinkingPriority={read=_ThinkingPriority, write=set_ThinkingPriority};

    __property TMoveEvent OnCastle={read=castling, write=castling};
    __property TMoveEvent OnCheck={read=check, write=check};
    __property TMoveEvent OnLegalMove={read=legalmove, write=legalmove};
    __property TMoveEvent OnMate={read=mate, write=mate};
    __property TMoveEvent OnStaleMate={read=stalemate, write=stalemate};
    __property TNotifyEvent OnOnlyTwoKingsLeft={read=onlytwokingsleft, write=onlytwokingsleft};
    __property TNotifyEvent OnThreefoldPosition={read=threefoldposition, write=threefoldposition};
    __property TOneSquareEvent OnIllegalMove={read=illegalmove, write=illegalmove};
    __property TPromotionEvent OnPromotion={read=promotion, write=promotion};
    __property TCaptureEvent OnCapture={read=capture, write=capture};

    __property Visible;
    __property Enabled;

    __property DragCursor;
    __property DragMode;
    __property OnClick;
    __property OnDblClick ;
    __property OnDragDrop ;
    __property OnDragOver ;
    __property OnEndDrag ;
    __property OnMouseDown ;
    __property OnMouseMove ;
    __property OnMouseUp;
    __property OnStartDrag;
};
//---------------------------------------------------------------------------
#endif

