#ifndef chessTypesH
#define chessTypesH

#define NoPiece   -1
#define Black      0
#define White      1

enum Square
{  None=0,
   A8,B8,C8,D8,E8,F8,G8,H8,
   A7,B7,C7,D7,E7,F7,G7,H7,
   A6,B6,C6,D6,E6,F6,G6,H6,
   A5,B5,C5,D5,E5,F5,G5,H5,
   A4,B4,C4,D4,E4,F4,G4,H4,
   A3,B3,C3,D3,E3,F3,G3,H3,
   A2,B2,C2,D2,E2,F2,G2,H2,
   A1,B1,C1,D1,E1,F1,G1,H1};

enum pieces
{BP=0,BN,BB,BR,BK,BQ,WP=8,WN,WB,WR,WQ,WK};

enum StandardSet
{ Size32, Size40, Size64, Size80};

enum DisplayCoords { West, North, East, South };
enum CanStillCastle { WhiteKingSide,WhiteQueenSide, BlackKingSide, BlackQueenSide };

typedef Set<CanStillCastle, WhiteKingSide, BlackQueenSide>  CastleSet;
typedef Set<DisplayCoords,  West, South>  CoordSet;

typedef void __fastcall (__closure *TMoveEvent) (System::TObject *Sender,  Square oldSq, Square newSq);
typedef void __fastcall (__closure *TCaptureEvent) (System::TObject *Sender,  Square oldSq, Square newSq, char CapturedPiece);
typedef void __fastcall (__closure *TOneSquareEvent) (System::TObject *Sender,  Square sq);
typedef void __fastcall (__closure *TPromotionEvent) (System::TObject *Sender,  Square oldSq, Square newSq, char &NewPiece);

typedef bool __fastcall (__closure *MoveFunc)(Square,Square);

//--------------------------------------------------------------------
//From Tom:
//

#define MOVE_STACK       4096
#define HIST_STACK       64

#define LIGHT            0
#define DARK             1

#define PAWN             0
#define KNIGHT           1
#define BISHOP           2
#define ROOK             3
#define QUEEN            4
#define KING             5

#define EMPTY            6

#define FILE(x)          (x&7)
#define RANK(x)          (x>>3)


/* This is the basic description of a move. promote is what
   piece to promote the pawn to, if the move is a pawn
   promotion. bits is a bitfield that describes the move,
   with the following bits:

   1    capture
   2    castle
   4    en passant capture
   8    pushing a pawn 2 squares
   16    pawn move
   32    promote

   It's union'ed with an integer so two moves can easily
   be compared with each other. */

typedef struct {
    char from;
    char to;
    char promote;
    char bits;
} move_bytes;

typedef union {
    move_bytes b;
    int i;
} move;

/* an element of the move stack. it's just a move with a
   score, so it can be sorted by the search functions. */
typedef struct {
    move m;
    int score;
} gen_rec;

/* an element of the history stack, with the information
   necessary to take a move back. */
typedef struct {
    move m;
    int capture;
    int castle;
    int ep;
    int fifty;
} hist_rec;

#endif

