//---------------------------------------------------------------------------
// ChessBoard Component for Borland C++ Builder 1.0
// Version 2.11 - October 23rd 1997
// Author: Daniel Terhell
//---------------------------------------------------------------------------

#include <vcl\vcl.h>
#pragma hdrstop

#include "CHESSBRD.H"
#include "CHTHREAD.CPP"

//---------------------------------------------------------------------------
static inline TChessBoard *ValidCtrCheck()
{
    return new TChessBoard(NULL);
}
//----------Constructor and Destructor--------------------

__fastcall MoveInfo::MoveInfo (void)
{
    strcpy(&position[0],"_rnbqkbnrpppppppp                                PPPPPPPPRNBQKBNR");
    EnPassant=OldSquare=NewSquare=None;
    Castling<<WhiteKingSide<<WhiteQueenSide<<BlackKingSide<<BlackQueenSide;
}

__fastcall TChessBoard::TChessBoard(TComponent* Owner)
    : TGraphicControl(Owner)
{
    _LineStyle= new TPen();
    _CoordFont= new TFont();
    _SquareLight    = new Graphics::TBitmap();
    _SquareDark     = new Graphics::TBitmap();
    _BorderBitmap   = new Graphics::TBitmap();
    _CustomPieceSet = new Graphics::TBitmap();

    list            = new TImageList(this);
    Default         = new Graphics::TBitmap();

    _StandardSize=Size40;

    FirstMove=1;
    LastMove=1;
    LastTurn=TRUE;

    _ResizeMinSize=0;
    _ResizeMaxSize=1000;

    PromoteTo='q';

    _DisplayCoords<<West<<East<<North<<South;

    InitializeBitmaps();
    OrganizeBitmaps();

    _CoordFont->Color=clWhite;
    _CoordFont->Name="Arial";
    _CoordFont->Size=7;
    _CoordFont->Pitch=fpDefault;

    _SizeOfSquare=40;
    _SizeOfBorder=24;
    _BorderColor=clOlive;
    _SquareColorDark=clGray;
    _SquareColorLight=clSilver;

    Width=8*_SizeOfSquare+2*_SizeOfBorder;
    Height=Width;

    Boardx=_SizeOfBorder;
    Boardy=_SizeOfBorder;

    _ComputerPlaysWhite=FALSE;
    _ComputerPlaysBlack=FALSE;

    _SearchDepth=3;
    _ThinkingPriority=tpLower;
    _Thinking=FALSE;

    strcpy (&position[0],"_rnbqkbnrpppppppp                                PPPPPPPPRNBQKBNR");
    posstr=String(&position[1]);

    _WhiteToMove=TRUE;
    _CurrentMove=1;
    FirstMove=1;
    FirstTurn=White;
    LastMove=1;
    LastTurn=White;

    _EnPassant=None;

    _CastlingAllowed<<WhiteKingSide<<WhiteQueenSide<<BlackKingSide<<BlackQueenSide;

    if (!ComponentState.Contains(csDesigning))
    {
        Now=new ChessThread (&position[0], &_WhiteToMove, &_EnPassant,
             &_CastlingAllowed, &_Thinking, &_SearchDepth, &Move);
        Now->Priority=_ThinkingPriority;
        Now->OnTerminate=FinishedThread;
        Now->FreeOnTerminate=TRUE;
    }
}


__fastcall TChessBoard::~TChessBoard()
{
    if (Now)
    {
        Now->Terminate();
    }

    delete list,_LineStyle,_CoordFont,_SquareLight,_SquareDark,_BorderBitmap,Default,_CustomPieceSet;
}

//----------- Event handlers here --------------------------------------------------

void __fastcall TChessBoard::FinishedThread (TObject *Sender)
{
    //
}

void __fastcall TChessBoard::WndProc (TMessage &Message)
{
    if (_Thinking==FALSE)
    {
        if (WhiteToMove)
        {
            if (_ComputerPlaysWhite)
                MoveNow();
        }
        else
        {
            if (_ComputerPlaysBlack)
                MoveNow();
        }
    }
    TGraphicControl::WndProc(Message);
}



void __fastcall TChessBoard::Paint (void)
{
    int size=(Width+Height)/2;
    _SizeOfSquare=(size-2*_SizeOfBorder)>>3;
    Width=8*_SizeOfSquare+2*_SizeOfBorder;
    Height=Width;

    DrawBorder();
    DrawBoard();
    DrawPieces();
}

void __fastcall TChessBoard::MouseDown(TMouseButton Button,
                            Classes::TShiftState Shift, int X, int Y)
{
    TGraphicControl::MouseDown(Button,Shift,X,Y);
    Square sq=WindowToSquare(X,Y);
    if (sq>=A8 && sq<=H1 && position[sq]!=' ')
    {
         SquareClick1=sq;
         BeginDrag(FALSE);
    }
}


void __fastcall TChessBoard::DragOver(System::TObject* Source,
     int X, int Y, TDragState State, bool &Accept )
{
    TGraphicControl::DragOver(Source, X, Y, State, Accept);

    Square sq=WindowToSquare(X,Y);
    int mid=_SizeOfSquare/2;

    if (list->Dragging==FALSE)
    {
        ClearSquare(SquareClick1);
        list->SetDragImage(PieceToInt(position[SquareClick1]), 0,0);
        list->DragLock  (Parent->Handle,X+this->Left-mid,Y+this->Top-mid);
        list->BeginDrag (Parent->Handle,0,0);
    }

    list->DragMove(X+this->Left-mid,Y+this->Top-mid);

    list->ShowDragImage();

    if (Source==this)
    {
        if (MoveIsLegal(SquareClick1,sq)||SquareClick1==sq)
        {
            Accept=TRUE;
        }
    }
}

void __fastcall TChessBoard::DragDrop(System::TObject *Source, int X, int Y)
{
    TGraphicControl::DragDrop(Source,X,Y);
    if (list->Dragging==TRUE)
    {
        list->HideDragImage();
        list->EndDrag();
        list->DragUnlock();
    }

    SquareClick2=WindowToSquare(X,Y);
    if (SquareClick1!=SquareClick2)
    {
        Move (SquareClick1,SquareClick2);
    }
    else DrawPiece (SquareClick1,position[SquareClick1]);

}

void __fastcall TChessBoard::DragCanceled(void)
{
    list->HideDragImage();
    list->EndDrag();
    list->DragUnlock();
    DrawPiece (SquareClick1,position[SquareClick1]);
    if (illegalmove!=NULL) illegalmove(this, SquareClick1);
}

void __fastcall TChessBoard::MouseMove(Classes::TShiftState Shift, int X, int Y)
{
    static TCursor OldCursor;

    if (Cursor!=crSizeNWSE && Cursor!=crSizeWE && Cursor!=crSizeNS)
        OldCursor=Cursor;

    if (_Resizable && X>=(Width-10) && X<=Width && Y>=(Height-10) && Y<=Height)
    {
        Cursor=crSizeNWSE;
        if (Shift.Contains(ssLeft))
            ResizeState=TRUE;
    }

    else if (_Resizable && ResizeState==FALSE)
        Cursor=OldCursor;

    if (_Resizable && ResizeState==TRUE)
    {
        int w=X>Y ? X:Y;
        w=w<_ResizeMinSize ? _ResizeMinSize : w;
        w=w>_ResizeMaxSize ? _ResizeMaxSize : w;
        if (w!=Width)
            Width=w;
    }

    TGraphicControl::MouseMove (Shift,X,Y);
}


void __fastcall TChessBoard::MouseUp(TMouseButton Button,  Classes::TShiftState Shift, int X, int Y)
{
    if (ResizeState==TRUE)
    {
        ResizeState=FALSE;
    }
    TGraphicControl::MouseUp(Button,Shift,X,Y);
}

void __fastcall TChessBoard::Click (void)
{
    TGraphicControl::Click();
}

void __fastcall TChessBoard::EndDrag(bool drop)
{
    TGraphicControl::EndDrag(drop);
}

void __fastcall TChessBoard::LegalMove (TObject *Sender, Square oldSq, Square newSq)
{}

void __fastcall TChessBoard::IllegalMove (TObject *Sender, Square sq)
{}

void __fastcall TChessBoard::Check (TObject *Sender, Square oldSq, Square newSq)
{}

void __fastcall TChessBoard::Mate (TObject *Sender, Square oldSq, Square newSq)
{}

void __fastcall TChessBoard::Castle (TObject *Sender, Square oldSq, Square newSq)
{}

void __fastcall TChessBoard::StaleMate (TObject *Sender, Square oldSq, Square newSq)
{}

void __fastcall TChessBoard::Capture (TObject *Sender, Square oldSq, Square newSq, char CapturedPiece)
{}

void __fastcall TChessBoard::OnlyTwoKingsLeft (TObject *Sender)
{
}

void __fastcall TChessBoard::ThreefoldPosition (TObject *Sender)
{
}

void __fastcall TChessBoard::Promotion (TObject *Sender, Square oldSq, Square newSq, char &NewPiece)
{
      String i="NBRQnbrq";

      for (int r=1; r<=8; r++)
      {
          if (NewPiece==i[r])
              break;
          if (r==8) NewPiece='q';
      }

    PromoteTo=NewPiece;
}

void __fastcall TChessBoard::DoPromotion (Square sq)
{
    if (YPos(sq)==8)
    {
        position[sq]=char(toupper(PromoteTo));
    }
    else  if (YPos(sq)==1)
    {
        position[sq]=char(tolower(PromoteTo));
    }

    ClearSquare(sq);
    DrawPiece(sq,position[sq]);
    posstr=String(&position[1]);
}

//--------------Boring write methods for published properties---------------

void __fastcall TChessBoard::set_PosStr(String pos)
{
    char *p=pos.c_str();
    char *q;

    String PieceStr=" PNBRQKpnbrqk";

    CancelThinking();

    for (int r=1; r<=64; r++)
         position[r]=' ';

    for ( q=&position[1]; q<=&position[64]; q++,p++)
    {
        if (*p)
        {
            for (int n=1; n<=13; n++)
                if (PieceStr[n]==*p)
                    {*q=*p; break;}

        }
        else break;
    }

    if (LowerCase(pos)=="init" || LowerCase(pos)=="newgame")
    {
        strcpy(&position[0],"_rnbqkbnrpppppppp                                PPPPPPPPRNBQKBNR");
    }

    posstr=String(&position[1]);

    Paint();
}

void __fastcall TChessBoard::set_ResizeMinSize (int size)
{
    _ResizeMinSize=size < _ResizeMaxSize ? size : _ResizeMaxSize;
    if (Width<_ResizeMinSize) Width=_ResizeMinSize;
}

void __fastcall TChessBoard::set_ResizeMaxSize (int size)
{
    _ResizeMaxSize=size > _ResizeMinSize ? size : _ResizeMaxSize;
    if (Width>_ResizeMaxSize) Width=_ResizeMaxSize;
}

void __fastcall TChessBoard::set_SizeOfSquare (int size)
{
    _SizeOfSquare=size;
    Width=8*_SizeOfSquare+2*_SizeOfBorder;
    Height=Width;
    Paint();
}

void __fastcall TChessBoard::set_CurrentMove (int moveno)
{
// Read-Only
}

void __fastcall TChessBoard::set_EnPassant (Square sq)
{
    CancelThinking();

    if ((sq>=A6 && sq<=H6)||(sq>=A3 && sq<=H3))
        _EnPassant=sq;
}

void __fastcall TChessBoard::set_BoardLines (bool show)
{
    _BoardLines=show;
    Paint();
}

void __fastcall TChessBoard::set_DisplayCoords (CoordSet set)
{
    _DisplayCoords=set;
    Paint();
}

void __fastcall TChessBoard::set_CoordFont(TFont *font)
{
    _CoordFont->Assign(font);
    Paint();
}

void __fastcall TChessBoard::set_StandardSize(StandardSet set)
{
    _StandardSize=set;
    InitializeBitmaps();
    OrganizeBitmaps();
    Paint();
}

void __fastcall TChessBoard::set_CustomPieceSet(Graphics::TBitmap *bmp)
{
    if (bmp==NULL||BitmapIsValidPieceSet(bmp))
    {
       _CustomPieceSet->Assign(bmp);
       OrganizeBitmaps();
       Paint();
    }
}

void __fastcall TChessBoard::set_LineStyle (TPen *pen)
{
    _LineStyle->Assign(pen);
    Paint();
}

void __fastcall TChessBoard::set_SizeOfBorder (int border)
{
    _SizeOfBorder=border;
    Width=8*_SizeOfSquare+2*_SizeOfBorder;
    Height=Width;
    Boardx=_SizeOfBorder;
    Boardy=_SizeOfBorder;
}

void __fastcall TChessBoard::set_WhiteOnTop (bool wabove)
{
    _WhiteOnTop=wabove;
    Paint();
}

void __fastcall TChessBoard::set_WhiteToMove (bool whitetomove)
{
    CancelThinking();
    _WhiteToMove=whitetomove;
}

void __fastcall TChessBoard::set_SquareDark(Graphics::TBitmap *bmp)
{
    _SquareDark->Assign(bmp);
    Paint();
}

void __fastcall TChessBoard::set_SquareLight(Graphics::TBitmap *bmp)
{
    _SquareLight->Assign(bmp);
    Paint();
}

void __fastcall TChessBoard::set_BorderBitmap(Graphics::TBitmap *bmp)
{
    _BorderBitmap->Assign(bmp);
    Paint();
}

void __fastcall TChessBoard::set_SquareColorDark(TColor c)
{
    _SquareColorDark=c;
    Paint();
}

void __fastcall TChessBoard::set_SquareColorLight(TColor c)
{
    _SquareColorLight=c;
    Paint();
}

void __fastcall TChessBoard::set_BorderColor(TColor c)
{
    _BorderColor=c;
    Paint();
}

void __fastcall TChessBoard::set_ComputerPlaysBlack(bool computerplays)
{
    CancelThinking();
    _ComputerPlaysBlack=computerplays;
}

void __fastcall TChessBoard::set_ComputerPlaysWhite(bool computerplays)
{
    CancelThinking();
    _ComputerPlaysWhite=computerplays;
}

void __fastcall TChessBoard::set_SearchDepth (int depth)
{
   int sd=depth;
   if (sd<1)
       sd=1;
   if (sd>=10)
       sd=10;
   _SearchDepth=sd;
}

void __fastcall TChessBoard::set_ThinkingPriority (TThreadPriority priority)
{
    _ThinkingPriority=priority;
    if (_ThinkingPriority>tpNormal)
        _ThinkingPriority=tpNormal;
    if (Now) Now->Priority=_ThinkingPriority;
}

void __fastcall TChessBoard::set_Thinking (bool thinking)
{
    // Read-Only !
}


//-------PUBLIC Graphic Routines-----------------------------------------------

void __fastcall TChessBoard::DrawChessPiece(TCanvas *canvas, int x, int y,char piece)
{
    int i=-1,j,v;

    char c=piece;
    if (c>='A' && c<='Z') c+=char(32);

    switch(c)
    {
         case 'p': i=0; break;
         case 'n': i=1; break;
         case 'b': i=2; break;
         case 'r': i=3; break;
         case 'q': i=4; break;
         case 'k': i=5; break;
    }

    j=(piece>='A' && piece<='Z') ? 0:1;

    v=(i>=0) ? PieceIndex[j][i]: -1;

    list->Draw (canvas,x,y,v);
}



void __fastcall TChessBoard::UpdateChessBoard (char *oldpos)
{
    for (int sq=1; sq<=64; sq++)
        if (*(oldpos+sq)!=*(position+sq))
        {
            ClearSquare(Square(sq));
            if (position[sq]!=' ')
                DrawPiece(Square(sq),position[sq]);
        }
}


void __fastcall TChessBoard::DrawPiece (Square sq, char piece)
{
    TRect dest;

    int x=(sq-1)%8;
    int y=(sq-1)/8;

    if (_WhiteOnTop)
    {
        x=7-x;
        y=7-y;
    }

    int adj=(_SizeOfSquare-PieceSize)/2;
    list->Draw(Canvas, Boardx+_SizeOfSquare*x+adj, Boardy+_SizeOfSquare*y+adj, PieceToInt(piece));
}

//Clears the int according to the Screen coords
//Returns TRUE if a int could be found at (x,y)
void __fastcall TChessBoard::ClearSquare(Square sq)
{
    int x,y,posx,posy, SavedDC;
    Graphics::TBitmap *Pic;

    SavedDC=SaveDC(Canvas->Handle);

    Canvas->CopyMode=cmSrcCopy;
    Canvas->Brush->Style=bsSolid;

    x=XPos(sq)-1;
    y=8-YPos(sq);
    if (_WhiteOnTop)
    {
        x=7-x;
        y=7-y;
    }

    posx=Boardx+x*_SizeOfSquare;
    posy=Boardy+y*_SizeOfSquare;

    IntersectClipRect(Canvas->Handle,posx,posy,posx+_SizeOfSquare,
          posy+_SizeOfSquare);

    if (ColorOfSquare(sq)==Black)
        if (BitmapExists(_SquareDark)) Pic=_SquareDark;
        else
        {
            Pic=NULL;
            Canvas->Brush->Color=_SquareColorDark;
            Canvas->Pen->Color=_SquareColorDark;
        }
    else
        if (BitmapExists(_SquareLight)) Pic=_SquareLight;
        else
        {
            Pic=NULL;
            Canvas->Brush->Color=_SquareColorLight;
            Canvas->Pen->Color=_SquareColorLight;
        }

    if (Pic)
    {
        for (y=0;y<=Height/Pic->Height; y++)
            for(x=0; x<=Width/Pic->Width; x++)
                Canvas->Draw(x*Pic->Width,y*Pic->Height,Pic);
    }
    else
        Canvas->FillRect(Canvas->ClipRect);

    if (_BoardLines)
    {
        Canvas->Pen->Color=clBlack;
        for (x=1; x<=7; x++)
        {
            Canvas->MoveTo(Boardx+x*_SizeOfSquare,Boardy);
            Canvas->LineTo(Boardx+x*_SizeOfSquare,Height-Boardy);
            Canvas->MoveTo(Boardx,Boardy+x*_SizeOfSquare);
            Canvas->LineTo(Width-Boardx,Boardy+x*_SizeOfSquare);
        }
    }

    RestoreDC (Canvas->Handle,SavedDC);
}

//Converts from Window Coordinates to square
//returns 0 if invalid else
// 1-64 as a int number
Square __fastcall TChessBoard::WindowToSquare (int x, int y)
{
    int xn,yn,xv,yv;

    xv=x-(Boardx);
    yv=y-(Boardy);

    if ((xv<0)||(xv>=8*_SizeOfSquare)||(yv<0)||(yv>=8*_SizeOfSquare))
       return None;

    xn=xv/_SizeOfSquare;
    yn=yv/_SizeOfSquare;

    if (xn>7) xn=7;
    if (yn>7) yn=7;

    if (_WhiteOnTop)
    {
        xn=7-xn;
        yn=7-yn;
    }

    return (Square(8*yn+xn+1));
}

//-------PRIVATE Graphic Routines

bool __fastcall TChessBoard::BitmapExists (Graphics::TBitmap *bmp)
{
    return (bmp && bmp->Width && bmp->Height);
}

bool __fastcall TChessBoard::BitmapIsValidPieceSet (Graphics::TBitmap *bmp)
{
    bool v=(bmp && bmp->Width && bmp->Height &&
           (bmp->Width*2==bmp->Height*3));
    return v;
}

void __fastcall TChessBoard::OrganizeBitmaps(void)
{
    Graphics::TBitmap *Bmp=BitmapIsValidPieceSet(_CustomPieceSet) ? _CustomPieceSet : Default;
    PieceSize=Bmp->Height>>2;

    list->Clear();
    list->Masked=TRUE;
    list->DrawingStyle=dsTransparent;
    list->Width=PieceSize;
    list->Height=PieceSize;

    Graphics::TBitmap *tmp=new Graphics::TBitmap();
    Graphics::TBitmap *tmpmask=new Graphics::TBitmap();

    tmp->Width=PieceSize;
    tmp->Height=PieceSize;
    tmpmask->Width=PieceSize;
    tmpmask->Height=PieceSize;

    for (int n=0; n<=1; n++)
    for (int r=0; r<=5; r++)
    {
        TRect src,dest;
        src.Left=r*PieceSize; src.Top=n*(PieceSize*2); src.Right=src.Left+PieceSize; src.Bottom=n*(PieceSize*2)+PieceSize;
        dest.Left=0; dest.Top=0; dest.Right=PieceSize; dest.Bottom=PieceSize;
        tmp->Canvas->CopyRect(dest,Bmp->Canvas,src);

        src.Left=r*PieceSize; src.Top=n*(PieceSize*2)+PieceSize; src.Right=src.Left+PieceSize; src.Bottom=n*(PieceSize*2)+(PieceSize*2);
        tmpmask->Canvas->CopyRect(dest,Bmp->Canvas,src);

        PieceIndex[n][r]=list->Add (tmp,tmpmask);
    }

    delete tmpmask;
    delete tmp;
}

void __fastcall TChessBoard::DrawBorder (void)
{
    String abc;
    int r,v,boffset,soffset,x,y,SavedDC;

    SavedDC=SaveDC(Canvas->Handle);

    Canvas->CopyMode=cmSrcCopy;
    Canvas->Brush->Style=bsSolid;
    Canvas->Brush->Color=_BorderColor;

    ExcludeClipRect(Canvas->Handle,_SizeOfBorder,_SizeOfBorder,Width-_SizeOfBorder,Height-_SizeOfBorder);

    if (BitmapExists(_BorderBitmap))
    {
        for (y=0; y<=Height/_BorderBitmap->Height; y++)
            for (x=0; x<=Width/_BorderBitmap->Width; x++)
                Canvas->Draw(x*_BorderBitmap->Width,y*_BorderBitmap->Height,_BorderBitmap);
    }
    else Canvas->FillRect(Canvas->ClipRect);

    Canvas->Font=_CoordFont;

    abc=_WhiteOnTop ? "HGFEDCBA" : "ABCDEFGH";

    boffset=((_SizeOfBorder-_CoordFont->Size) >> 1)+1;
    soffset=(_SizeOfSquare-_CoordFont->Size)>>1;

    y=Canvas->TextHeight('0')/4;
    SetBkMode(Canvas->Handle,TRANSPARENT);

    for (r=0; r<=7; r++)
    {
        if (_WhiteOnTop) v=r+1; else v=8-r;
        if (_DisplayCoords.Contains(West))
            Canvas->TextOut(boffset,_SizeOfBorder+r*_SizeOfSquare+soffset,IntToStr(v));
        if (_DisplayCoords.Contains(East))
            Canvas->TextOut(Width-_SizeOfBorder+boffset,_SizeOfBorder+r*_SizeOfSquare+soffset,IntToStr(v));
        if (_DisplayCoords.Contains(North))
            Canvas->TextOut(_SizeOfBorder+r*_SizeOfSquare+soffset,boffset-y,abc[r+1]);
        if (_DisplayCoords.Contains(South))
            Canvas->TextOut(_SizeOfBorder+r*_SizeOfSquare+soffset,Height-_SizeOfBorder+boffset-y,abc[r+1]);
    };

    Canvas->Pen=_LineStyle;
    Canvas->MoveTo(0,0);
    Canvas->LineTo(Width-1,0);
    Canvas->LineTo(Width-1,Width-1);
    Canvas->LineTo(0,Width-1);
    Canvas->LineTo(0,0);

    Canvas->MoveTo (_SizeOfBorder-1,_SizeOfBorder-1);
    Canvas->LineTo (Width-_SizeOfBorder,_SizeOfBorder-1);
    Canvas->LineTo (Width-_SizeOfBorder,Width-_SizeOfBorder);
    Canvas->LineTo (_SizeOfBorder-1,Width-_SizeOfBorder);
    Canvas->LineTo (_SizeOfBorder-1,_SizeOfBorder-1);

    RestoreDC (Canvas->Handle, SavedDC);
}


void __fastcall TChessBoard::DrawPieces (void)
{
    for (int sq=1; sq<=64; sq++)
    {
        if (position[sq]!=' ')
            DrawPiece(Square(sq),position[sq]);
    }
}


void __fastcall TChessBoard::DrawBoard (void)
{
    int n,x,y,posx,posy,SavedDC,TempDC;
    Graphics::TBitmap *Pic;

    SavedDC=SaveDC(Canvas->Handle);

    Canvas->CopyMode=cmSrcCopy;
    Canvas->Brush->Style=bsSolid;

    IntersectClipRect (Canvas->Handle,_SizeOfBorder,_SizeOfBorder,
                       Width-_SizeOfBorder,Height-_SizeOfBorder);

    for (n=0;n<=1;n++)
    {
        TempDC=SaveDC(Canvas->Handle);
        for (x=0; x<=3; x++)
            for (y=0; y<=7; y++)
            {
                posx=Boardx+(x*2+(n^(y&1)))*_SizeOfSquare;
                posy=Boardy+y*_SizeOfSquare;
                ExcludeClipRect(Canvas->Handle,posx,posy,posx+_SizeOfSquare,
                                posy+_SizeOfSquare);
            }
        if (!n)
            if (BitmapExists(_SquareDark))
                Pic=_SquareDark;
            else
            {
                Pic=NULL;
                Canvas->Brush->Color=_SquareColorDark;
                Canvas->Pen->Color=_SquareColorDark;
            }
        else
            if (BitmapExists(_SquareLight))
                Pic=_SquareLight;
            else
            {
                Pic=NULL;
                Canvas->Brush->Color=SquareColorLight;
                Canvas->Pen->Color  =SquareColorLight;
            }
        if(Pic!=NULL)
        {
            for (y=0; y<=(Height/Pic->Height); y++)
                for (x=0;x<=(Width/Pic->Width); x++)
                    Canvas->Draw(x*Pic->Width,y*Pic->Height,Pic);
        }
        else
            Canvas->FillRect(Canvas->ClipRect);

        RestoreDC(Canvas->Handle,TempDC);
    }

    if (_BoardLines)
    {
        Canvas->Pen->Color=clBlack;
        for (x=1; x<=7; x++)
        {
            Canvas->MoveTo(Boardx+x*_SizeOfSquare,Boardy);
            Canvas->LineTo(Boardx+x*_SizeOfSquare,Height-Boardy);
            Canvas->MoveTo(Boardx,Boardy+x*_SizeOfSquare);
            Canvas->LineTo(Width-Boardx,Boardy+x*_SizeOfSquare);
        }
    }


    RestoreDC(Canvas->Handle,SavedDC);
}



//-----------------------------------------------------------------------
//-     Real Chess here  -PUBLIC-
//-----------------------------------------------------------------------

void __fastcall TChessBoard::CancelThinking(void)
{
    if (Now) Now->CancelThinking();
}

void __fastcall TChessBoard::MoveNow (void)
{
    CancelThinking();
    if (LegalMoveAvailable())
        _Thinking=TRUE;
}


TStringList*  __fastcall TChessBoard::GetMoveList (void)
{
    TStringList *m=new TStringList;
    String s;

    for (int r=FirstMove; r<=LastMove; r++)
    for (int side=0; side<=1; side++)
    {
        if (r>LastMove||(r==LastMove && side && LastTurn))
             goto BreakOut;

        if (!side) s=IntToStr(r)+". ";
        else s="              ";

        if (r==FirstMove && !side && !FirstTurn)
            s+=" ...   ";
        else
        {
            s+=char('A'+XPos(MoveList[r][side].OldSquare)-1);
            s+=char('0'+YPos(MoveList[r][side].OldSquare));
        }

        s+='-';

        s+=char('A'+XPos(MoveList[r][side].NewSquare)-1);
        s+=char('0'+YPos(MoveList[r][side].NewSquare));

        m->Add(s);

    }

    BreakOut:

    return m;
}

MoveInfo __fastcall TChessBoard::GetMove (int moveno, bool whitetomove)
{
    static MoveInfo temp;
    temp.OldSquare=None;
    temp.NewSquare=None;
    strcpy (&temp.position[0],"init");
    temp.EnPassant=None;

    if (moveno>LastMove||(moveno==LastMove && LastTurn && !whitetomove))
        {return temp;}

    if (moveno<FirstMove||(moveno==FirstMove && !FirstTurn && whitetomove))
        {return temp;}

    return MoveList[moveno][!whitetomove];
}


//Squares are numbered from 1 - 64 (a8,b8...h1)
int __fastcall inline TChessBoard::ColorOfSquare (Square sq)
{
    return (((sq-1)&1)==(((sq-1)>>3)&1));
}

int __fastcall TChessBoard::PieceToInt (char piece)
{
    String i="PNBRQKpnbrqk";

    for (int r=1; r<=12; r++)
        if (piece==i[r])
            return (PieceIndex[(r-1)/6][(r-1)%6]);

    return -1;
}


//returns color of the PIECE on a square
int __fastcall TChessBoard::ColorOfPiece (Square sq)
{
    if ((position[sq]>='b')&&(position[sq]<='r')) return Black;
    else if ((position[sq]>='B')&&(position[sq]<='R')) return White;
    else return NoPiece;
}

int inline __fastcall TChessBoard::ColorOfPiece (char piece)
{
     String i="NBRQnbrq";

     for (int r=1; r<=8; r++)
     {
          if (piece==i[r])
              break;
          if (r==8) return NoPiece;
     }

    return (piece>='B' && piece<='R');
}


// Returns XPos of a int according to ChessBoard coordinates (A-H)
int __fastcall inline TChessBoard::XPos (Square sq)
{
    return (1+(sq-1)%8);
}

// Returns YPos of a int according to ChessBoard coordinates (1-8)
int __fastcall inline TChessBoard::YPos (Square sq)
{
    return 8-((sq-1)/8);
}

Square __fastcall inline TChessBoard::MouseToSquare (int x, int y)
{
    return (x>=1 && x<=8 && y>=1 && y<=8) ? Square(8*(8-y)+x) : None;
}

bool __fastcall TChessBoard::SetUpPosition (MoveInfo &pos, int moveno, bool whitetomove)
{
    CancelThinking();

    String i=" pnbrqkPNBRQK";

    if ( moveno>200 ||
        (pos.EnPassant && YPos (pos.EnPassant)!=3 && YPos(pos.EnPassant)!=6))
           return FALSE;

    for (int r=1; r<=64; r++)
    {
        for (int n=1; n<=13; n++)
        {
            if (pos.position[r]==i[n]) goto BreakOut;
        }
        return FALSE;

        BreakOut:
    }

    strcpy (&position[1],&pos.position[1]);
    _WhiteToMove=whitetomove;
    FirstTurn=whitetomove;
    _CurrentMove=moveno;
    FirstMove=moveno;

    _CastlingAllowed=pos.Castling;
    _EnPassant=pos.EnPassant;

    Paint();
    return TRUE;
}

void __fastcall TChessBoard::NewGame (void)
{
    CancelThinking();

    strcpy (&position[0],"_rnbqkbnrpppppppp                                PPPPPPPPRNBQKBNR");

    _WhiteToMove=TRUE;
    _CurrentMove=1;
    FirstMove=1;
    FirstTurn=White;
    LastMove=1;
    LastTurn=White;

    _EnPassant=None;

    _CastlingAllowed<<WhiteKingSide<<WhiteQueenSide<<BlackKingSide<<BlackQueenSide;

    posstr=String(&position[1]);

    Paint();
}

bool __fastcall TChessBoard::Move (Square oldSq, Square newSq)
{
    bool ch,stillmove;
    char oldpiece;
    int sq;

    if (!MoveIsLegal(oldSq,newSq))
        return FALSE;

    ch=(WhiteInCheckAfter(oldSq,newSq)||BlackInCheckAfter(oldSq,newSq));

    strcpy(&MoveList[_CurrentMove][!_WhiteToMove].position[0],&position[0]);
    MoveList[_CurrentMove][!_WhiteToMove].Castling=_CastlingAllowed;
    MoveList[_CurrentMove][!_WhiteToMove].EnPassant=_EnPassant;
    MoveList[_CurrentMove][!_WhiteToMove].OldSquare=Square(oldSq);
    MoveList[_CurrentMove][!_WhiteToMove].NewSquare=Square(newSq);
    LastMove=_CurrentMove;
    LastTurn=_WhiteToMove;

    if (!_WhiteToMove) _CurrentMove++;
    _WhiteToMove=!_WhiteToMove;

    oldpiece=position[newSq];
    position[newSq]=position[oldSq];
    position[oldSq]=' ';
    ClearSquare(oldSq);
    ClearSquare(newSq);
    DrawPiece(newSq,position[newSq]);

    posstr=String(&position[1]);

    //Call OnLegalMove event handler
    if (legalmove!=NULL)
        legalmove(this,oldSq,newSq);

    //Eventually call OnCapture event handler (also in En Passant)
    if (oldpiece!=' ' && capture!=NULL)
        capture(this,oldSq,newSq,oldpiece);

    //More to do if last move was a promotion
    if (((position[newSq])=='p'||position[newSq]=='P')&&
        (YPos(newSq)==8 || YPos(newSq)==1))
    {
        if (promotion!=NULL)
             promotion(this,oldSq,newSq,PromoteTo);

        DoPromotion(newSq);
    }

    //More to do if last move was En Passant capture
    if (_EnPassant==newSq)
    {
        if (YPos(newSq)==6&&position[newSq]=='P')
        {
            sq=MouseToSquare(XPos(newSq),5);
            if (capture!=NULL)
                capture(this,oldSq,newSq,position[sq]);
            position[sq]=' ';
            ClearSquare(Square(sq));
        }
        else if (YPos(newSq)==3&&position[newSq]=='p')
        {
            sq=MouseToSquare(XPos(newSq),4);
            if (capture!=NULL)
                capture(this,oldSq,newSq,position[sq]);
            position[sq]=' ';
            ClearSquare(Square(sq));
        }
    }

    //More to do if last move allows En Passant continuation
    if ((position[newSq]=='P' && YPos(oldSq)==2 && YPos(newSq)==4)||
        (position[newSq]=='p' && YPos(oldSq)==7 && YPos(newSq)==5))
    {
        _EnPassant=Square ((oldSq+newSq)>>1);
    }

    else _EnPassant=None;

    //More to do if last move was castling
    if (position[newSq]=='K' && oldSq==E1)
    {
        if (newSq==G1)
        {
            position[F1]='R';
            position[H1]=' ';
            ClearSquare(H1);
            DrawPiece(F1,'R');
            if (castling!=NULL)
                castling(this,oldSq,newSq);
        }
        else if (newSq==C1)
        {
            position[D1]='R';
            position[A1]=' ';
            ClearSquare(A1);
            DrawPiece(D1,'R');
            if (castling!=NULL)
                castling(this,oldSq,newSq);
        }
    }

    else if (position[newSq]=='k' && oldSq==E8)
    {
        if (newSq==G8)
        {
            position[F8]='r';
            position[H8]=' ';
            ClearSquare(H8);
            DrawPiece(F8,'r');
            if (castling!=NULL)
                castling(this,oldSq,newSq);
        }
        else if (newSq==C8)
        {
            position[D8]='r';
            position[A8]=' ';
            ClearSquare(A8);
            DrawPiece(D8,'r');
            if (castling!=NULL)
                castling(this,oldSq,newSq);
        }
    }

    //Eventually Remove Castling Allowance
    switch (oldSq)
    {
        //if a rook moved
        case A1:{_CastlingAllowed>>WhiteQueenSide; break;}
        case H1:{_CastlingAllowed>>WhiteKingSide;  break;}
        case A8:{_CastlingAllowed>>BlackQueenSide; break;}
        case H8:{_CastlingAllowed>>BlackKingSide;  break;}

        //or if a king moved
        case E1:{_CastlingAllowed>>WhiteQueenSide;
                 _CastlingAllowed>>WhiteKingSide;  break;}
        case E8:{_CastlingAllowed>>BlackQueenSide;
                 _CastlingAllowed>>BlackKingSide;  break;}
    }

    //More to do if there's mate or stalemate
        stillmove=LegalMoveAvailable();
    if (ch==TRUE)
    {
        if (check!=NULL)
            check(this,oldSq,newSq);
        if (stillmove==FALSE && mate!=NULL)
                mate(this,oldSq,newSq);
    }
    else
    {
        if (stillmove==FALSE && stalemate!=NULL)
            stalemate(this,oldSq,newSq);
    }

    //More to do if there's only two kings left
    int count=0;
    for (int r=1; r<=64; r++)
         if(position[r]!=' ' && position[r]!='k' && position[r]!='K')
            count++;
    if (!count && onlytwokingsleft!=NULL)
        onlytwokingsleft(this);

    strcpy(&MoveList[_CurrentMove][!_WhiteToMove].position[0],&position[0]);
    MoveList[_CurrentMove][!_WhiteToMove].Castling=_CastlingAllowed;
    MoveList[_CurrentMove][!_WhiteToMove].EnPassant=_EnPassant;
    LastMove=_CurrentMove;
    LastTurn=_WhiteToMove;
    posstr=String(&position[1]);

    // Or a Threefold Position in the game
    if (CheckForThreefoldPosition()==TRUE)
    {
        if (threefoldposition!=NULL)
            threefoldposition(this);
    }

    if (_Thinking==FALSE)
    {
        if (WhiteToMove)
        {
            if (_ComputerPlaysWhite)
                MoveNow();
        }
        else
        {
            if (_ComputerPlaysBlack)
                MoveNow();
        }
    }
    return TRUE;
}


bool __fastcall TChessBoard::MoveBackward (void)
{
     if (_WhiteToMove)
        return (GotoMove  (_CurrentMove-1, FALSE));
     else return (GotoMove (_CurrentMove, TRUE));
}

bool __fastcall TChessBoard::MoveForward (void)
{
    if (_WhiteToMove)
        return (GotoMove  (_CurrentMove, FALSE));
    else return GotoMove (_CurrentMove+1, TRUE);
}


bool __fastcall TChessBoard::GotoMove (int moveno, bool whitetomove)
{
    char oldpos[65];

    CancelThinking();

    if (moveno>LastMove||(moveno==LastMove && LastTurn && !whitetomove))
        {return FALSE;}

    if (moveno<FirstMove||(moveno==FirstMove && !FirstTurn && whitetomove))
        {return FALSE;}

    _CurrentMove=moveno;
    _WhiteToMove=whitetomove;

    strcpy(&oldpos[0], &position[0]);
    strcpy(&position[0],&MoveList[_CurrentMove][!_WhiteToMove].position[0]);
    _EnPassant=MoveList[_CurrentMove][!_WhiteToMove].EnPassant;
    _CastlingAllowed= MoveList[_CurrentMove][!_WhiteToMove].Castling;
    posstr=String(&position[1]);

    UpdateChessBoard(&oldpos[0]);

    return TRUE;
}

bool __fastcall TChessBoard::LegalMoveAvailable (void)
{
    int r,n;

    if (_WhiteToMove)
    {
        for (r=1; r<=64; r++)
        if (ColorOfPiece(Square(r))==White)
        {
            for (n=1; n<=64; n++)
                 if (MoveIsLegal(Square(r),Square(n))&&(WhiteInCheckAfter(Square(r),Square(n))==FALSE))
                     return TRUE;
        }
    }
    else
    {
        for (r=1; r<=64; r++)
        if (ColorOfPiece(Square(r))==Black)
        {
            for (n=1; n<=64; n++)
                 if (MoveIsLegal(Square(r),Square(n))&&(BlackInCheckAfter(Square(r),Square(n))==FALSE))
                     return TRUE;
        }
    }
    return FALSE;
}


//---PRIVATE CHESS Stuff here-----------------

bool __fastcall TChessBoard::CheckForThreefoldPosition(void)
{
    int turn,t,move,m;
    int count=0;

    m=move=_CurrentMove;
    if (_WhiteToMove)
    {
        turn=0;
    }
    else turn=1;

    t=turn;

    for (;;)
    {
        t--;
        if (t<0) { t=1; m--;}
        if (m<1) break;
        if(!strcmp(MoveList[move][turn].position,MoveList[m][t].position))
            count++;
    }

    return (count>=2);
}

bool __fastcall TChessBoard::MoveIsLegal (Square oldSq, Square newSq)
{
    bool r;
    char piece=char (tolower(position[oldSq]));

    if (oldSq<1 || oldSq>64 || newSq<1 || newSq>64 || _Thinking==TRUE ||
        CheckForThreefoldPosition()==TRUE)
        return FALSE;

    //Turn to the right color ?
    if (_WhiteToMove)
        {
        if (ColorOfPiece(oldSq)!=White) return FALSE;
        }
    else
        {
        if (ColorOfPiece(oldSq)!=Black) return FALSE;
        }
    // Old int does't contain a piece ?
    if (ColorOfPiece(oldSq)==NoPiece)
         return FALSE;

    // Can't take piece of own color
    if (ColorOfPiece(oldSq)==ColorOfPiece(newSq))
            return FALSE;

    r=TRUE;

    switch (piece)
    {
        case 'p':   {
              r=CheckLegalPawnMove(oldSq,newSq);
              break;
              }
        case 'n':   {
              r=CheckLegalKnightMove(oldSq,newSq);
              break;
              }
        case 'b':   {
              r=CheckLegalBishopMove(oldSq,newSq);
              break;
              }
        case 'r':   {
              r=CheckLegalRookMove(oldSq,newSq);
              break;
              }
        case 'q':   {
              r=CheckLegalQueenMove(oldSq,newSq);
              break;
              }
        case 'k':   {
              r=CheckLegalKingMove(oldSq,newSq);
              break;
              }
    }

    if (r==TRUE)
    {
        if (ColorOfPiece(oldSq)==Black &&
            (BlackInCheckAfter(oldSq,newSq)==TRUE))
             r=FALSE;
        else if (ColorOfPiece(oldSq)==White &&
            (WhiteInCheckAfter(oldSq,newSq)==TRUE))
             r=FALSE;
    }

    return r;
}

//Checks whether black is in check after the specified move
bool __fastcall TChessBoard::BlackInCheckAfter(Square oldSq, Square newSq)
{
    bool Result=FALSE;
    int x,y,r;
    Square kingsq;
    char v;

    char pos[65];
    strcpy (&pos[0],&position[0]);

    v=pos[oldSq];
    pos[oldSq]=' ';
    pos[newSq]=v;

    for (r=1; r<=64; r++)
         if (pos[r]=='k') break;

    kingsq=Square(r);
    if (r>64 || r<1) return FALSE;

    //pawn check
    for (x=-1; x<=1; x+=2)
    if (pos[MouseToSquare(XPos(kingsq)+x,YPos(kingsq)-1)]=='P')
        {return TRUE;}

    //knight check
    for (y=-1; y<=1; y+=2)
    for (x=-2; x<=2; x+=4)
        if (pos[MouseToSquare(XPos(kingsq)+x,YPos(kingsq)+y)]=='N')
            {return TRUE;}
    for (y=-2; y<=2; y+=4)
    for (x=-1; x<=1; x+=2)
        if (pos[MouseToSquare(XPos(kingsq)+x,YPos(kingsq)+y)]=='N')
            {return TRUE;}

    //bishop (and queen) check
    for (y=-1; y<=1; y+=2)
        for (x=-1; x<=1; x+=2)
            for (r=1; r<=7; r++)
            {
                 v=pos[MouseToSquare(XPos(kingsq)+x*r,YPos(kingsq)+y*r)];
                 if (v=='Q' || v=='B' || (v=='K' && r==1))
                 {
                    return TRUE;
                 }
                 if (v!=' ')
                     break;
            }

    //rook (and queen) check
    for (x=-1; x<=1; x+=2)
        for (r=1; r<=7; r++)
        {
             v=pos[MouseToSquare(XPos(kingsq)+x*r,YPos(kingsq))];
             if (v=='Q' || v=='R' || (v=='K'&& r==1))
             {
                return TRUE;
             }
             if (v!=' ')
                 break;
        }

    for (y=-1; y<=1; y+=2)
        for (r=1; r<=7; r++)
        {
             v=pos[MouseToSquare(XPos(kingsq),YPos(kingsq)+r*y)];
             if (v=='Q' || v=='R' || (v=='K'&& r==1))
             {
                return TRUE;
             }
             if (v!=' ')
                 break;
        }

return Result;
}

//Checks whether white is in check after the specified move
bool __fastcall TChessBoard::WhiteInCheckAfter(Square oldSq, Square newSq)
{
    bool Result=FALSE;
    Square kingsq;
    int x,y,r;
    char v;

    char pos[65];
    strcpy (&pos[0],&position[0]);

    //Can move to same Square
    v=pos[oldSq];
    pos[oldSq]=' ';
    pos[newSq]=v;

    for (r=1; r<=64; r++)
         if (pos[r]=='K') break;

    kingsq=Square(r);
    if (r>64 || r<1) return FALSE;

    //pawn check
    for (x=-1; x<=1; x+=2)
        if (pos[MouseToSquare(XPos(kingsq)+x,YPos(kingsq)+1)]=='p')
            {return TRUE;}

    //knight check
    for (y=-1; y<=1; y+=2)
    for (x=-2; x<=2; x+=4)
        if (pos[MouseToSquare(XPos(kingsq)+x,YPos(kingsq)+y)]=='n')
            {return TRUE;}
    for (y=-2; y<=2; y+=4)
    for (x=-1; x<=1; x+=2)
        if (pos[MouseToSquare(XPos(kingsq)+x,YPos(kingsq)+y)]=='n')
            {return TRUE;}

    //bishop (and queen) check
    for (y=-1; y<=1; y+=2)
        for (x=-1; x<=1; x+=2)
            for (r=1; r<=7; r++)
            {
                 v=pos[MouseToSquare(XPos(kingsq)+x*r,YPos(kingsq)+y*r)];
                 if (v=='q' || v=='b' || (v=='k' && r==1))
                 {
                    return TRUE;
                 }
                 if (v!=' ')
                     break;
            }

    //rook (and queen) check
    for (x=-1; x<=1; x+=2)
        for (r=1; r<=7; r++)
        {
             v=pos[MouseToSquare(XPos(kingsq)+x*r,YPos(kingsq))];
             if (v=='q' || v=='r' || (v=='k'&& r==1))
             {
                return TRUE;
             }
             if (v!=' ')
                 break;
        }

    for (y=-1; y<=1; y+=2)
        for (r=1; r<=7; r++)
        {
             v=pos[MouseToSquare(XPos(kingsq),YPos(kingsq)+r*y)];
             if (v=='q' || v=='r' || (v=='k'&& r==1))
             {
                return TRUE;
             }
             if (v!=' ')
                 break;
        }

return Result;
}

//Checks whether a pawn move is legal, assuming the king isn't in check
bool __fastcall TChessBoard::CheckLegalPawnMove(Square oldSq,Square newSq)
{
    int deltax=abs(XPos(newSq)-XPos(oldSq));

    if (ColorOfPiece(oldSq)==White)
    {
        if (YPos(newSq)==YPos(oldSq)+1)
        {
            if (!deltax)
                {
                if (position[newSq]==' ')
                    return TRUE;
                }
            else if (deltax==1)
                {
                if ((ColorOfPiece(newSq)==Black)||
                    _EnPassant==newSq)
                    return TRUE;
                }
        }
        else if ((YPos(oldSq)==2)&&(YPos(newSq)==4))
        {
            if (!deltax && position[newSq]==' '
               && position[(oldSq+newSq)/2]==' ') return TRUE;
        }

    }
    else if (ColorOfPiece(oldSq)==Black)
    {
        if (YPos(newSq)==YPos(oldSq)-1)
        {
            if (!deltax)
                {
                if (position[newSq]==' ') return TRUE;
                }
            else if (deltax==1)
                {
                if ((ColorOfPiece(newSq)==White)||
                    _EnPassant==newSq)
                     return TRUE;
                }
        }
        else if (YPos(oldSq)==7 && YPos(newSq)==5)
        {
            if (!deltax && position[newSq]==' ' &&
                position[(oldSq+newSq)/2]==' ')
                {
                    return TRUE;
                }
        }
    }

return FALSE;
}

//Checks whether a knight move is legal, assuming the king isn't in check
bool __fastcall TChessBoard::CheckLegalKnightMove(Square oldSq,Square newSq)
{
    int deltax=abs(XPos(oldSq)-XPos(newSq));
    int deltay=abs(YPos(oldSq)-YPos(newSq));
    if (((deltax==2)&&(deltay==1))||((deltax==1)&&(deltay==2)))
        return TRUE;
    return FALSE;
}

//Checks whether a bishop move is legal, assuming the king isn't in check
bool __fastcall TChessBoard::CheckLegalBishopMove(Square oldSq, Square newSq)
{
    int x=XPos(oldSq);
    int y=YPos(oldSq);
    Square v;
    int r,n,m;
    int p=ColorOfPiece(oldSq);

    for (n=-1; n<=1; n+=2)
        for (m=-1; m<=1; m+=2)
            for (r=1; r<=7; r++)
            {
                v=MouseToSquare(x+n*r,y+m*r);
                if ((ColorOfPiece(v)==NoPiece)||(ColorOfPiece(v)!=p))
                {
                    if (v==newSq) return TRUE;
                }
                if (ColorOfPiece(v)!=NoPiece) break;
            }

    return FALSE;
}

//Checks whether a rook move is legal, assuming the king isn't in check
bool __fastcall TChessBoard::CheckLegalRookMove(Square oldSq, Square newSq)
{
    int x=XPos(oldSq);
    int y=YPos(oldSq);
    Square v;
    int r,n;
    int p=ColorOfPiece(oldSq);

    for (n=-1; n<=1; n+=2)
        for (r=1; r<=7; r++)
        {
            v=MouseToSquare(x+n*r,y);
            if ((ColorOfPiece(v)==NoPiece)||(ColorOfPiece(v)!=p))
            {
                if (v==newSq) return TRUE;
            }
            if (ColorOfPiece(v)!=NoPiece) break;
        }

    for (n=-1; n<=1; n+=2)
        for (r=1; r<=7; r++)
        {
            v=MouseToSquare(x,y+n*r);
            if ((ColorOfPiece(v)==NoPiece)||(ColorOfPiece(v)!=p))
            {
                if (v==newSq) return TRUE;
            }
            if (ColorOfPiece(v)!=NoPiece) break;
        }

    return FALSE;
}

//Checks whether a queen move is legal, assuming the king isn't in check
bool __fastcall TChessBoard::CheckLegalQueenMove(Square oldSq, Square newSq)
{
    bool r=CheckLegalBishopMove(oldSq,newSq);
    return r==TRUE ? r:CheckLegalRookMove(oldSq,newSq);
}

//Checks whether a king move is legal, assuming the king isn't in check
bool __fastcall TChessBoard::CheckLegalKingMove(Square oldSq,Square newSq)
{
    int deltax=abs(XPos(oldSq)-XPos(newSq));
    int deltay=abs(YPos(oldSq)-YPos(newSq));
    if ((deltax<=1)&&(deltay<=1))
        return TRUE;

    if (oldSq==E1 && newSq==G1)
    {
        if (_CastlingAllowed.Contains(WhiteKingSide) && position[H1]=='R' &&
            position[G1]==' ' && position[F1]==' ' &&
            !WhiteInCheckAfter(E1,E1) &&
            !WhiteInCheckAfter(E1,F1) &&
            !WhiteInCheckAfter(E1,G1))
            return TRUE;
    }
    if (oldSq==E1 && newSq==C1)
    {
        if (_CastlingAllowed.Contains(WhiteQueenSide) && position[A1]=='R' &&
            position[B1]==' ' && position[C1]==' ' && position[D1]== ' ' &&
            !WhiteInCheckAfter(E1,E1) &&
            !WhiteInCheckAfter(E1,D1) &&
            !WhiteInCheckAfter(E1,C1))
            return TRUE;
    }
    if (oldSq==E8 && newSq==G8)
    {
        if (_CastlingAllowed.Contains(BlackKingSide) && position[H8]=='r' &&
            position[G8]==' ' && position[F8]==' ' &&
            !BlackInCheckAfter(E8,E8) &&
            !BlackInCheckAfter(E8,F8) &&
            !BlackInCheckAfter(E8,G8))
            return TRUE;
    }
    if (oldSq==E8 && newSq==C8)
    {
        if (_CastlingAllowed.Contains(BlackQueenSide) && position[A8]=='r' &&
               position[B8]==' ' && position[C8]==' ' && position[D8]== ' ' &&
               !BlackInCheckAfter(E8,E8) &&
               !BlackInCheckAfter(E8,D8) &&
               !BlackInCheckAfter(E8,C8))
            return TRUE;
    }

    return FALSE;
}


//---------------------------------------------------------------------------
namespace Chessbrd
{
    void __fastcall Register()
    {
        TComponentClass classes[1] = {__classid(TChessBoard)};
        RegisterComponents("Chess", classes, 0);
    }
}
//---------------------------------------------------------------------------

void __fastcall TChessBoard::InitializeBitmaps (void)
{
unsigned long set32[3102]={
0x30764D42,0x00000000,0x00760000,0x00280000,0x00C00000,0x00800000,0x00010000,
0x00000004,0x30000000,0x00000000,0x00000000,0x00100000,0x00100000,0x00000000,
0x00000000,0x80000080,0x80000000,0x00800080,0x00800000,0x80800080,0xC0C00000,
0x808000C0,0x00000080,0xFF0000FF,0xFF000000,0x00FF00FF,0x00FF0000,0xFFFF00FF,
0xFFFF0000,0xFFFF00FF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x88FFFFFF,0x88888888,
0x88888888,0xFFFFFF88,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xF8FFFFFF,0x88888888,0xFFFFFF8F,0xFFFFFFFF,
0xFFFFFFFF,0x88888888,0xFFFFFF8F,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0x80FFFFFF,0x00000000,0x00000000,0xFFFFFF08,0x88888880,0x88FF8F88,
0x80888888,0xFFFFFFFF,0x888888FF,0x88888888,0x8F888888,0xFFFFFFFF,0x8088F8FF,
0x00000000,0xFFFF8808,0xFFFFFFFF,0x88F8FFFF,0x00000000,0xFFFF8808,0xFFFFFFFF,
0x8888FFFF,0x88888888,0xFF8F8888,0xFFFFFFFF,0x80FFFFFF,0x00000000,0x00000000,
0xFFFFFF08,0x00000080,0x00F80800,0x00000000,0xFFFFFF8F,0x000000F8,0x00000000,
0x08000000,0xFFFFFFFF,0x0000F8FF,0x00000000,0xFF8F0000,0xFFFFFFFF,0x0080FFFF,
0x00000000,0xFF8F0000,0xFFFFFFFF,0x0000F8FF,0x00000000,0xFF080000,0xFFFFFFFF,
0x80FFFFFF,0x00000000,0x00000000,0xF8FFFF08,0x00000000,0x00800000,0x00000000,
0xFFFFFF08,0x000000F8,0x00000000,0x08000000,0xFFFFFFFF,0x000080FF,0x00000000,
0xFF080000,0xFFFFFFFF,0x0000F8FF,0x00000000,0xFF080000,0xFFFFFFFF,0x0000F8FF,
0x00000000,0xFF080000,0xFFFFFFFF,0x80FFFFFF,0x00000000,0x00000000,0xF8FFFF08,
0x00000000,0x00000000,0x00000000,0xFFFFFF08,0x000000F8,0x00000000,0x08000000,
0xFFFFFFFF,0x000080FF,0x00000000,0xFF080000,0xFFFFFFFF,0x0000F8FF,0x00000000,
0xFF080000,0xFFFFFFFF,0x0000F8FF,0x00000000,0xFF080000,0xFFFFFFFF,0xF8FFFFFF,
0x00000000,0x00000000,0xFFFFFF08,0x88888888,0x00000080,0x88888888,0xFFFFFF8F,
0x000000F8,0x00000000,0x08000000,0xFFFFFFFF,0x0000F8FF,0x00000000,0xFF8F0000,
0xFFFFFFFF,0x0080FFFF,0x00000000,0xFF8F0000,0xFFFFFFFF,0x0000F8FF,0x00000000,
0xFF080000,0xFFFFFFFF,0xF88FF8FF,0x00000000,0x00000000,0xFFFFFF08,0xF8FFFFFF,
0x00000080,0xFFFFFFFF,0xFFFFFFFF,0x000088FF,0x00000000,0x8F080000,0xFFFFFFFF,
0x0000F8FF,0x00000000,0xFF8F0000,0xFFFFFFFF,0x0080FFFF,0x00000000,0xFF8F0000,
0xFFFFFFFF,0x0000F8FF,0x00000000,0xFF080000,0xFFFFFFFF,0xFF088088,0x00000080,
0x00000000,0xFFFFFF08,0x80FFFFFF,0x00000000,0xFFFF8F00,0xFFFFFFFF,0x0000F8FF,
0x00000000,0xFF080000,0xFFFFFFFF,0x0000F8FF,0x00000000,0xFF8F0000,0xFFFFFFFF,
0x0080FFFF,0x00000000,0xFF8F0000,0xFFFFFFFF,0x0000F8FF,0x00000000,0xFF080000,
0xF8FFFFFF,0x8F000000,0x000000F8,0x00000000,0xFFFFFF08,0x80FFFFFF,0x00000000,
0xFFFF8F00,0xFFFFFFFF,0x0000F8FF,0x00000000,0xFF080000,0xFFFFFFFF,0x000080FF,
0x00000000,0xFF080000,0xFFFFFFFF,0x0000F8FF,0x00000000,0xFF080000,0xFFFFFFFF,
0x0080FFFF,0x00000000,0xFF8F0000,0xF8FFFFFF,0x8F000000,0x000080FF,0x00000000,
0xFFFFFF08,0xF8FFFFFF,0x00000000,0xFFFFFF08,0xFFFFFFFF,0x0080FFFF,0x00000000,
0xFF8F0000,0xFFFFFFFF,0x000080FF,0x00000000,0xFF080000,0xFFFFFFFF,0x0000F8FF,
0x00000000,0xFF080000,0xFFFFFFFF,0x0080FFFF,0x00000000,0xFF8F0000,0x80FFFFFF,
0x08000000,0x0000808F,0x00000000,0xFFFFFF8F,0xF8FFFFFF,0x00000000,0xFFFFFF08,
0xFFFFFFFF,0x00F8FFFF,0x00000000,0xFFFF0800,0xFFFFFFFF,0x000000F8,0x00000000,
0x8F000000,0xFFFFFFFF,0x000080FF,0x00000000,0x8F000000,0xFFFFFFFF,0x00F8FFFF,
0x00000000,0xFFFF0800,0x80FFFFFF,0x00000000,0x00008808,0x00000000,0xFFFFFF8F,
0xF8FFFFFF,0x00000000,0xFFFFFF08,0xFFFFFFFF,0x80FFFFFF,0x00000000,0xFFFF8F00,
0xFFFFFFFF,0x000000F8,0x00000000,0x8F000000,0xFFFFFFFF,0x000000F8,0x00000000,
0x08000000,0xFFFFFFFF,0x80FFFFFF,0x00000000,0xFFFF8F00,0xF8FFFFFF,0x00000000,
0x00000800,0x00000000,0xFFFFFF8F,0x80FFFFFF,0x00000000,0xFFFF8F00,0xFFFFFFFF,
0x80FFFFFF,0x00000000,0xFFFF8F00,0xFFFFFFFF,0x000000F8,0x00000000,0x8F000000,
0xFFFFFFFF,0x00000080,0x00000000,0x00000000,0xFFFFFF8F,0xF8FFFFFF,0x00000080,
0xFFFFFF88,0xF8FFFFFF,0x00000000,0x00000000,0x00000000,0xFFFFFF8F,0x00F8FFFF,
0x00000000,0xFFFF0800,0xFFFFFFFF,0x80FFFFFF,0x00000000,0xFFFF8F00,0xFFFFFFFF,
0x00000080,0x00000000,0x08000000,0xFFFFFFFF,0x00000080,0x00000000,0x00000000,
0xFFFFFF8F,0xF8FFFFFF,0x00000000,0xFFFFFF08,0xFFFFFFFF,0x00000080,0x00000000,
0x08000000,0xFFFFFFFF,0x00F8FFFF,0x00000000,0xFFFF0800,0xFFFFFFFF,0x80FFFFFF,
0x00000000,0xFFFF8F00,0xFFFFFFFF,0x00000080,0x00000000,0x08000000,0xF8FFFFFF,
0x00000000,0x00000000,0x00000000,0xFFFFFF08,0x80FFFFFF,0x00000000,0xFFFF8F00,
0xFFFFFFFF,0x00000080,0x00000000,0x08000000,0xFFFFFFFF,0x0080FFFF,0x00000000,
0xFF8F0000,0xFFFFFFFF,0x80FFFFFF,0x00000000,0xFFFF8F00,0xFFFFFFFF,0x00800080,
0x00000000,0x08000800,0xF8FFFFFF,0x00000000,0x00000000,0x00000000,0xFFFFFF08,
0x80FFFFFF,0x00000000,0xFFFF8F00,0xFFFFFFFF,0x000000F8,0x00000000,0x8F000000,
0xFFFFFFFF,0x0080FFFF,0x00000000,0xFF8F0000,0xFFFFFFFF,0x80FFFFFF,0x00000000,
0xFFFF8F00,0xF8FFFFFF,0x00800000,0x80000008,0x00000800,0xF8FFFF8F,0x00000000,
0x00000000,0x00000000,0xFFFFFF08,0x80FFFFFF,0x00000000,0xFFFF8F00,0xFFFFFFFF,
0x000000F8,0x00000000,0x8F000000,0xFFFFFFFF,0x0080FFFF,0x00000000,0xFF8F0000,
0xFFFFFFFF,0x80FFFFFF,0x00000000,0xFFFF8F00,0xF8FFFFFF,0x00800800,0x80000008,
0x00800800,0xFFFFFF8F,0x00000080,0x00000000,0x00000000,0xFFFFFF8F,0x80FFFFFF,
0x00000000,0xFFFF8F00,0xFFFFFFFF,0x000080FF,0x00000000,0xFF080000,0xFFFFFFFF,
0x0080FFFF,0x00000000,0xFF8F0000,0xFFFFFFFF,0x80FFFFFF,0x00000000,0xFFFF8F00,
0xF8FFFFFF,0x00808F00,0x88000088,0x00F80800,0xFFFFFF8F,0x00000080,0x00000000,
0x00000000,0xFFFFFF8F,0xF8FFFFFF,0x00000000,0xFFFFFF08,0xFFFFFFFF,0x000080FF,
0x00000000,0xFF080000,0xFFFFFFFF,0x00F8FFFF,0x00000000,0xFFFF0800,0xFFFFFFFF,
0x00F8FFFF,0x00000000,0xFFFF0800,0x80FFFFFF,0x00808F00,0x88000088,0x00F80800,
0xFFFFFF08,0x000080F8,0x08000088,0x88000080,0xFFFFFFFF,0xFFFFFFFF,0x00000080,
0xFFFFFF8F,0xFFFFFFFF,0x000080FF,0x00000000,0xFF8F0000,0xFFFFFFFF,0x00F8FFFF,
0x00000000,0xFFFF0800,0xFFFFFFFF,0x0080FFFF,0x00000000,0xFF8F0000,0x80FFFFFF,
0x0080FF08,0x88000088,0x80FF0800,0xFFFFFF08,0x8888F8FF,0x08000088,0xFF8888F8,
0xFFFFFFFF,0xFFFFFFFF,0x080000F8,0xFFFFFFFF,0xFFFFFFFF,0x0000F8FF,0x00000000,
0xFFFF0800,0xFFFFFFFF,0x80FFFFFF,0x00000000,0xFFFF8F00,0xFFFFFFFF,0x0000F8FF,
0x00000000,0xFF080000,0x00F8FFFF,0x08808F00,0xFF0880FF,0x00F80880,0xFFFF8F00,
0xFFFFFFFF,0x8F0080FF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x00000080,0xFFFFFF8F,
0xFFFFFFFF,0x0000F8FF,0x00000000,0xFFFF8F00,0xFFFFFFFF,0xF8FFFFFF,0x00000080,
0xFFFFFF88,0xFFFFFFFF,0x0000F8FF,0x00000000,0xFF080000,0x00F8FFFF,0x08808F00,
0xFF0880FF,0x00F80880,0xFFFF8F00,0xFFFFFFFF,0xFF08F8FF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0x00000080,0xFFFFFF8F,0xFFFFFFFF,0x0080FFFF,0x00000000,0xFFFFFF08,
0xFFFFFFFF,0xFFFFFFFF,0x8F0080FF,0xFFFFFFFF,0xFFFFFFFF,0x0000F8FF,0x00000000,
0xFF080000,0x80FFFFFF,0x0880FF08,0xFF0880FF,0x80FF0880,0xFFFFFF08,0xFFFFFFFF,
0xFF08F8FF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x080000F8,0xFFFFFFFF,0xFFFFFFFF,
0x0080FFFF,0x08000000,0xFFFFFF8F,0xFFFFFFFF,0xFFFFFFFF,0x080000F8,0xFFFFFFFF,
0xFFFFFFFF,0x0000F8FF,0x00000000,0xFF080000,0xF8FFFFFF,0x0000F88F,0xF808808F,
0xF88F0000,0xFFFFFF8F,0xFFFFFFFF,0x8F0888FF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0x8F0080FF,0xFFFFFFFF,0xFFFFFFFF,0x0080FFFF,0x8F880080,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0x080000F8,0xFFFFFFFF,0xFFFFFFFF,0x0000F8FF,0x08000088,0xFF080080,
0xFFFFFFFF,0x0000F8FF,0x88000088,0xFF8F0000,0xFFFFFFFF,0xFFFFFFFF,0x080000F8,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFF88F8FF,0xFFFFFFFF,0xFFFFFFFF,0x8800F8FF,
0xFF8F0088,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x080000F8,0xFFFFFFFF,0xFFFFFFFF,
0x0000F8FF,0x08000088,0xFF080080,0xFFFFFFFF,0x0880FFFF,0x8F0000F8,0xFFFF0880,
0xFFFFFFFF,0xFFFFFFFF,0x8F0888FF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFF88FFFF,0xFFFF08F8,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0x8F0080FF,0xFFFFFFFF,0xFFFFFFFF,0x8F88FFFF,0x8F8888FF,0xFF8F88FF,0xFFFFFFFF,
0x8FF8FFFF,0xFF0880FF,0xFFFF8FF8,0xFFFFFFFF,0xFFFFFFFF,0xFF08F8FF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFF8FFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFF88F8FF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFF8FF8FF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFF8FFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xF0FFFFFF,
0x00000000,0x00000000,0xFFFFFF0F,0xFFFFFFF0,0xFFFFFFFF,0xF0FFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xF8FFFFFF,0x00000000,0xFFFFFF8F,
0xFFFFFFFF,0xFFFFFFFF,0x00000000,0xFFFFFF0F,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xF0FFFFFF,0x00000000,0x00000000,0xFFFFFF0F,0x000000F0,
0x00FF0F00,0x00000000,0xFFFFFFFF,0x000000FF,0x00000000,0x0F000000,0xFFFFFFFF,
0x0080FFFF,0x00000000,0xFFFF0800,0xFFFFFFFF,0x00F0FFFF,0x00000000,0xFFFF0000,
0xFFFFFFFF,0x0000FFFF,0x00000000,0xFF0F0000,0xFFFFFFFF,0xF0FFFFFF,0x00000000,
0xF00F0000,0xFFFFFF0F,0x00000000,0x00F00000,0x00000000,0xFFFFFF0F,0x000000FF,
0x00000000,0x0F000000,0xFFFFFFFF,0x0000F0FF,0x00000000,0xFF0F0000,0xFFFFFFFF,
0x0000FFFF,0x00000000,0xFF0F0000,0xFFFFFFFF,0x0000FFFF,0x00000000,0xFF0F0000,
0xFFFFFFFF,0xF8FFFFFF,0x00000000,0xF00F0000,0xFFFFFF0F,0x00000000,0x00000000,
0x00000000,0xFFFFFF0F,0x000000FF,0x00000000,0x0F000000,0xFFFFFFFF,0xFF0FF8FF,
0x00000000,0xFF0FFFFF,0xFFFFFFFF,0xFF0FFFFF,0x000000F0,0xFF0FFFFF,0xFFFFFFFF,
0x0000FFFF,0x00000000,0xFF0F0000,0xFFFFFFFF,0xFFFFFFFF,0x00000000,0xF00F0000,
0xFFFFFF0F,0xFFFFFFFF,0x000F0FF0,0xFFFFFFFF,0xFFFFFFFF,0xFFFF00FF,0xFFFFFFFF,
0x0FF0FFFF,0xFFFFFFFF,0x0F00FFFF,0xFFFFFFFF,0xFFFF00F0,0xFFFFFFFF,0x00F0FFFF,
0xFFFFFFFF,0xFFFF00F0,0xFFFFFFFF,0x0000FFFF,0x00000000,0xFF0F0000,0xFFFFFFFF,
0xFFFFFFFF,0x00000080,0xF00F0000,0xFFFFFF0F,0xFFFFFFFF,0x000000F0,0xFFFFFFFF,
0xFFFFFFFF,0x0000FFFF,0x00000000,0xFF0F0000,0xFFFFFFFF,0xF00FFFFF,0x00000000,
0xFFFFF00F,0xFFFFFFFF,0xFFF0FFFF,0x00000000,0xFFFFF00F,0xFFFFFFFF,0x0000FFFF,
0x00000000,0xFF0F0000,0xFFFFFFFF,0xFF0FF0FF,0x000000F8,0xF00F0000,0xFFFFFF0F,
0xF0FFFFFF,0x00000000,0xFFFFFF00,0xFFFFFFFF,0x0000FFFF,0x00000000,0xFF0F0000,
0xFFFFFFFF,0xFF00FFFF,0xFFFFFFFF,0xFFFF00FF,0xFFFFFFFF,0x0FF0FFFF,0xFFFFFFFF,
0xFFFF00FF,0xFFFFFFFF,0x0080FFFF,0x00000000,0xFF8F0000,0xFFFFFFFF,0xFF080000,
0x000000FF,0xF00F0000,0xFFFFFF0F,0xF0FFFFFF,0x000000F0,0xFFFFFFF0,0xFFFFFFFF,
0xFF00FFFF,0xFFFFFFFF,0xFF0FF0FF,0xFFFFFFFF,0x0000F0FF,0x00000000,0xFF0F0000,
0xFFFFFFFF,0x0000FFFF,0x00000000,0xFF0F0000,0xFFFFFFFF,0x00F0FFFF,0x00000000,
0xFFFF0000,0xFFFFFFFF,0xFF000F00,0x0000F0FF,0xF00F0000,0xFFFFFF8F,0xFFFFFFFF,
0xFFFFFF0F,0xFFFFFF0F,0xFFFFFFFF,0x00F0FFFF,0x00000000,0xFFFF0000,0xFFFFFFFF,
0xFF0FF0FF,0xFFFFFFFF,0xFF08F0FF,0xFFFFFFFF,0xFF0FFFFF,0x00000000,0xFF0FFF0F,
0xFFFFFFFF,0x00F8FFFF,0x00000000,0xFFFF0800,0xF0FFFFFF,0x0F000000,0x0000F8FF,
0x800F0000,0xFFFFFFFF,0xFFFFFFFF,0x00000000,0xFFFFFF0F,0xFFFFFFFF,0x00FFFFFF,
0xFFFFFFFF,0xFFFF0FF0,0xFFFFFFFF,0x000080FF,0x00000000,0xFF000000,0xFFFFFFFF,
0x0F0FF0FF,0xFF0FFFFF,0xFF000FFF,0xFFFFFFFF,0x00FFFFFF,0x00000000,0xFFFF0F00,
0xF8FFFFFF,0x0000000F,0x0000FF0F,0x00FF0000,0xFFFFFFFF,0xFFFFFFFF,0x00000000,
0xFFFFFF0F,0xFFFFFFFF,0xF0FFFFFF,0x00000000,0xFFFFFF00,0xFFFFFFFF,0x000000FF,
0x00000000,0xFF000000,0xFFFFFFFF,0x00F000FF,0x000F0F00,0x0FF00000,0xFFFFFFFF,
0xF8FFFFFF,0x00000000,0xFFFFFF08,0xFFFFFFFF,0x00000000,0x00000F00,0x00FF0000,
0xFFFFFFFF,0xF0FFFFFF,0xFFFFFF0F,0xFFFFFF00,0xFFFFFFFF,0xF0FFFFFF,0x00000000,
0xFFFFFF00,0xFFFFFFFF,0x000000FF,0x00000000,0xFF000000,0xFFFFFFFF,0x00000FF8,
0x000F0F00,0x080F0000,0xFFFFFFFF,0xFFFFFFFF,0x000000F0,0xFFFFFFFF,0xFFFFFFFF,
0x00000080,0x00000000,0x08FF0000,0xFFFFFFFF,0x80FFFFFF,0x00000000,0xFFFF8F00,
0xFFFFFFFF,0xF0FFFFFF,0x00000000,0xFFFFFF00,0xFFFFFFFF,0x000000F8,0x00000000,
0x8F000000,0xFFFFFFFF,0x0000F0F0,0x000F0F00,0xF0000000,0xFFFFFFFF,0xFFFFFFFF,
0x00000000,0xFFFFFF0F,0xFFFFFFFF,0x000000F0,0x00000000,0x0FFF0000,0xFFFFFFFF,
0x00FFFFFF,0x00000000,0xFFFF0F00,0xFFFFFFFF,0xF0FFFFFF,0x00000000,0xFFFFFF00,
0xFFFFFFFF,0x000000F0,0x00000000,0x0F000000,0xFFFFFFFF,0x0000000F,0xF0F0F000,
0x0F000000,0xFFFFFF0F,0xF8FFFFFF,0x00000000,0xFFFFFF08,0xFFFFFFFF,0x000000F8,
0x00F00000,0x8FF00000,0xFFFFFFFF,0x00F8FFFF,0x00F00000,0xFFFF0800,0xFFFFFFFF,
0xF0FFFFFF,0x00000000,0xFFFFFF00,0xFFFFFFFF,0x00F000F0,0x00000000,0x0F000F00,
0xFFFFFFFF,0x0000000F,0xF0F0F000,0x0F000000,0xFFFFFF0F,0xF0FFFFFF,0x00000000,
0xFFFFFF00,0xFFFFFFFF,0x000000FF,0x000F0000,0xFFF00F00,0xFFFFFFFF,0x00F0FFFF,
0x00F00000,0xFFFF0000,0xFFFFFFFF,0xF0FFFFFF,0x00000000,0xFFFFFF00,0xFFFFFFFF,
0x00F00880,0xF000000F,0x08800F00,0xFFFFFFFF,0x0000008F,0x0FF0000F,0x0F000000,
0xFFFFFF8F,0xF0FFFFFF,0x00000000,0xFFFFFF00,0xFFFFFFFF,0x000080FF,0x000F0000,
0xFF080F00,0xFFFFFFFF,0x00F0FFFF,0xF0FFFF00,0xFFFF0000,0xFFFFFFFF,0xF0FFFFFF,
0x00000000,0xFFFFFF00,0xFFFFFFFF,0x00F08F00,0xF800008F,0x00F80F00,0xFFFFFFFF,
0x0F00F0F0,0x000F0FF0,0xF00000FF,0xFFFFFFFF,0xF8FFFFFF,0x00000000,0xFFFFFF08,
0xFFFFFFFF,0x000FF0FF,0x00000000,0xFF0FFF00,0xFFFFFFFF,0x00F8FFFF,0x00F00000,
0xFFFF0800,0xFFFFFFFF,0xF0FFFFFF,0x00000000,0xFFFFFF00,0xFFFFFFFF,0x00F0FF00,
0xFF0000FF,0x00FF0F00,0xFFFFFFFF,0xF0FF0FF8,0x000F0F00,0x08FFFF00,0xFFFFFFFF,
0xFFFFFFFF,0x00000000,0xFFFFFF0F,0xFFFFFFFF,0xF00FF0FF,0x00000000,0xFF8FF00F,
0xFFFFFFFF,0x00FFFFFF,0x00F00000,0xFFFF0F00,0xFFFFFFFF,0x00FFFFFF,0xFFFFFFFF,
0xFFFF0FF0,0xF8FFFFFF,0x00F0FF08,0xFF0000FF,0x80FF0F00,0xFFFFFF8F,0x0800F8FF,
0x0F0F0FFF,0xFF0800F8,0xFFFFFFFF,0xFFFFFFFF,0x000000F0,0xFFFFFFFF,0xFFFFFFFF,
0xF000F8FF,0x00000000,0xFFFF00FF,0xFFFFFFFF,0x80FFFFFF,0x00000000,0xFFFF8F00,
0xFFFFFFFF,0x00F0FFFF,0x00000000,0xFFFF0000,0xF0FFFFFF,0x08F0FF0F,0xFF0880FF,
0xF0FF0F80,0xFFFFFF0F,0xFFFFFFFF,0x0FFF0FFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0x0F0000FF,0xFFFFFFFF,0xFFFFFFFF,0x0000FFFF,0x0F000000,0xFFFF0FF0,0xFFFFFFFF,
0xF8FFFFFF,0x00000000,0xFFFFFF08,0xFFFFFFFF,0xFF00FFFF,0xFFFFFFFF,0xFF0FF0FF,
0x00FFFFFF,0x0FF0FF00,0xFF0FF0FF,0x00FF0FF0,0xFFFFFF00,0xFFFFFFFF,0xFF00F0FF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x000000F0,0xFFFFFFFF,0xFFFFFFFF,0x0F00FFFF,
0xFF0F00F0,0xFFFFFF00,0xFFFFFFFF,0xFFFFFFFF,0x000000F0,0xFFFFFFFF,0xFFFFFFFF,
0x0000FFFF,0x00000000,0xFF0F0000,0x80FFFFFF,0x0FF0FF08,0xFF0FF0FF,0x80FF0FF0,
0xFFFFFF08,0xFFFFFFFF,0xFF0FFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x080000F8,
0xFFFFFFFF,0xFFFFFFFF,0x00F0FFFF,0x00000000,0xFFFFFF8F,0xFFFFFFFF,0xFFFFFFFF,
0xFF00F0FF,0xFFFFFFFF,0xFFFFFFFF,0x0000FFFF,0x00000000,0xFF0F0000,0xF0FFFFFF,
0x0FF0FF0F,0xFF0FF0FF,0xF0FF0FF0,0xFFFFFF0F,0xFFFFFFFF,0xFF0FFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0x0F0000FF,0xFFFFFFFF,0xFFFFFFFF,0x00F0FFFF,0x8F000000,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0F0000FF,0xFFFFFFFF,0xFFFFFFFF,0x0000FFFF,
0x00000000,0xFF0F0000,0xFFFFFFFF,0x0000FFFF,0xFF0FF0FF,0xFFFF0000,0xFFFFFFFF,
0xFFFFFFFF,0xFF0FFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFF08F8FF,0xFFFFFFFF,
0xFFFFFFFF,0x00F0FFFF,0xFFFF00F0,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0F0000FF,
0xFFFFFFFF,0xFFFFFFFF,0x0000FFFF,0x0F0000FF,0xFF0F00F0,0xFFFFFFFF,0x0880FFFF,
0xFF0000FF,0xFFFF0880,0xFFFFFFFF,0xFFFFFFFF,0x0F0000FF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFF00FFFF,0xFFFF00FF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0x0F0000FF,0xFFFFFFFF,0xFFFFFFFF,0x0000FFFF,0x0F0000FF,
0xFF0F00F0,0xFFFFFFFF,0x0FF0FFFF,0xFF0880FF,0xFFFF0FF0,0xFFFFFFFF,0xFFFFFFFF,
0xFF0FFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFF0FFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFF00F0FF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFF0FF0FF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFF0FFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0x88FFFFFF,0x88888888,0x88888888,0xFFFFFF88,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xF8FFFFFF,
0x88888888,0xFFFFFF8F,0xFFFFFFFF,0xFFFFFFFF,0x88888888,0xFFFFFF8F,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x80FFFFFF,0x00000000,0x00000000,
0xFFFFFF08,0x88888880,0x88FF8F88,0x80888888,0xFFFFFFFF,0x888888FF,0x88888888,
0x8F888888,0xFFFFFFFF,0x8088F8FF,0x00000000,0xFFFF8808,0xFFFFFFFF,0x88F8FFFF,
0x00000000,0xFFFF8808,0xFFFFFFFF,0x8888FFFF,0x88888888,0xFF8F8888,0xFFFFFFFF,
0x80FFFFFF,0x00000000,0x00000000,0xFFFFFF08,0x00000080,0x00F80800,0x00000000,
0xFFFFFF8F,0x000000F8,0x00000000,0x08000000,0xFFFFFFFF,0x0000F8FF,0x00000000,
0xFF8F0000,0xFFFFFFFF,0x0080FFFF,0x00000000,0xFF8F0000,0xFFFFFFFF,0x0000F8FF,
0x00000000,0xFF080000,0xFFFFFFFF,0x80FFFFFF,0x00000000,0x00000000,0xF8FFFF08,
0x00000000,0x00800000,0x00000000,0xFFFFFF08,0x000000F8,0x00000000,0x08000000,
0xFFFFFFFF,0x000080FF,0x00000000,0xFF080000,0xFFFFFFFF,0x0000F8FF,0x00000000,
0xFF080000,0xFFFFFFFF,0x0000F8FF,0x00000000,0xFF080000,0xFFFFFFFF,0x80FFFFFF,
0x00000000,0x00000000,0xF8FFFF08,0x00000000,0x00000000,0x00000000,0xFFFFFF08,
0x000000F8,0x00000000,0x08000000,0xFFFFFFFF,0x000080FF,0x00000000,0xFF080000,
0xFFFFFFFF,0x0000F8FF,0x00000000,0xFF080000,0xFFFFFFFF,0x0000F8FF,0x00000000,
0xFF080000,0xFFFFFFFF,0xF8FFFFFF,0x00000000,0x00000000,0xFFFFFF08,0x88888888,
0x00000080,0x88888888,0xFFFFFF8F,0x000000F8,0x00000000,0x08000000,0xFFFFFFFF,
0x0000F8FF,0x00000000,0xFF8F0000,0xFFFFFFFF,0x0080FFFF,0x00000000,0xFF8F0000,
0xFFFFFFFF,0x0000F8FF,0x00000000,0xFF080000,0xFFFFFFFF,0xF88FF8FF,0x00000000,
0x00000000,0xFFFFFF08,0xF8FFFFFF,0x00000080,0xFFFFFFFF,0xFFFFFFFF,0x000088FF,
0x00000000,0x8F080000,0xFFFFFFFF,0x0000F8FF,0x00000000,0xFF8F0000,0xFFFFFFFF,
0x0080FFFF,0x00000000,0xFF8F0000,0xFFFFFFFF,0x0000F8FF,0x00000000,0xFF080000,
0xFFFFFFFF,0xFF088088,0x00000080,0x00000000,0xFFFFFF08,0x80FFFFFF,0x00000000,
0xFFFF8F00,0xFFFFFFFF,0x0000F8FF,0x00000000,0xFF080000,0xFFFFFFFF,0x0000F8FF,
0x00000000,0xFF8F0000,0xFFFFFFFF,0x0080FFFF,0x00000000,0xFF8F0000,0xFFFFFFFF,
0x0000F8FF,0x00000000,0xFF080000,0xF8FFFFFF,0x8F000000,0x000000F8,0x00000000,
0xFFFFFF08,0x80FFFFFF,0x00000000,0xFFFF8F00,0xFFFFFFFF,0x0000F8FF,0x00000000,
0xFF080000,0xFFFFFFFF,0x000080FF,0x00000000,0xFF080000,0xFFFFFFFF,0x0000F8FF,
0x00000000,0xFF080000,0xFFFFFFFF,0x0080FFFF,0x00000000,0xFF8F0000,0xF8FFFFFF,
0x8F000000,0x000080FF,0x00000000,0xFFFFFF08,0xF8FFFFFF,0x00000000,0xFFFFFF08,
0xFFFFFFFF,0x0080FFFF,0x00000000,0xFF8F0000,0xFFFFFFFF,0x000080FF,0x00000000,
0xFF080000,0xFFFFFFFF,0x0000F8FF,0x00000000,0xFF080000,0xFFFFFFFF,0x0080FFFF,
0x00000000,0xFF8F0000,0x80FFFFFF,0x08000000,0x0000808F,0x00000000,0xFFFFFF8F,
0xF8FFFFFF,0x00000000,0xFFFFFF08,0xFFFFFFFF,0x00F8FFFF,0x00000000,0xFFFF0800,
0xFFFFFFFF,0x000000F8,0x00000000,0x8F000000,0xFFFFFFFF,0x000080FF,0x00000000,
0x8F000000,0xFFFFFFFF,0x00F8FFFF,0x00000000,0xFFFF0800,0x80FFFFFF,0x00000000,
0x00008808,0x00000000,0xFFFFFF8F,0xF8FFFFFF,0x00000000,0xFFFFFF08,0xFFFFFFFF,
0x80FFFFFF,0x00000000,0xFFFF8F00,0xFFFFFFFF,0x000000F8,0x00000000,0x8F000000,
0xFFFFFFFF,0x000000F8,0x00000000,0x08000000,0xFFFFFFFF,0x80FFFFFF,0x00000000,
0xFFFF8F00,0xF8FFFFFF,0x00000000,0x00000800,0x00000000,0xFFFFFF8F,0x80FFFFFF,
0x00000000,0xFFFF8F00,0xFFFFFFFF,0x80FFFFFF,0x00000000,0xFFFF8F00,0xFFFFFFFF,
0x000000F8,0x00000000,0x8F000000,0xFFFFFFFF,0x00000080,0x00000000,0x00000000,
0xFFFFFF8F,0xF8FFFFFF,0x00000080,0xFFFFFF88,0xF8FFFFFF,0x00000000,0x00000000,
0x00000000,0xFFFFFF8F,0x00F8FFFF,0x00000000,0xFFFF0800,0xFFFFFFFF,0x80FFFFFF,
0x00000000,0xFFFF8F00,0xFFFFFFFF,0x00000080,0x00000000,0x08000000,0xFFFFFFFF,
0x00000080,0x00000000,0x00000000,0xFFFFFF8F,0xF8FFFFFF,0x00000000,0xFFFFFF08,
0xFFFFFFFF,0x00000080,0x00000000,0x08000000,0xFFFFFFFF,0x00F8FFFF,0x00000000,
0xFFFF0800,0xFFFFFFFF,0x80FFFFFF,0x00000000,0xFFFF8F00,0xFFFFFFFF,0x00000080,
0x00000000,0x08000000,0xF8FFFFFF,0x00000000,0x00000000,0x00000000,0xFFFFFF08,
0x80FFFFFF,0x00000000,0xFFFF8F00,0xFFFFFFFF,0x00000080,0x00000000,0x08000000,
0xFFFFFFFF,0x0080FFFF,0x00000000,0xFF8F0000,0xFFFFFFFF,0x80FFFFFF,0x00000000,
0xFFFF8F00,0xFFFFFFFF,0x00800080,0x00000000,0x08000800,0xF8FFFFFF,0x00000000,
0x00000000,0x00000000,0xFFFFFF08,0x80FFFFFF,0x00000000,0xFFFF8F00,0xFFFFFFFF,
0x000000F8,0x00000000,0x8F000000,0xFFFFFFFF,0x0080FFFF,0x00000000,0xFF8F0000,
0xFFFFFFFF,0x80FFFFFF,0x00000000,0xFFFF8F00,0xF8FFFFFF,0x00800000,0x80000008,
0x00000800,0xF8FFFF8F,0x00000000,0x00000000,0x00000000,0xFFFFFF08,0x80FFFFFF,
0x00000000,0xFFFF8F00,0xFFFFFFFF,0x000000F8,0x00000000,0x8F000000,0xFFFFFFFF,
0x0080FFFF,0x00000000,0xFF8F0000,0xFFFFFFFF,0x80FFFFFF,0x00000000,0xFFFF8F00,
0xF8FFFFFF,0x00800800,0x80000008,0x00800800,0xFFFFFF8F,0x00000080,0x00000000,
0x00000000,0xFFFFFF8F,0x80FFFFFF,0x00000000,0xFFFF8F00,0xFFFFFFFF,0x000080FF,
0x00000000,0xFF080000,0xFFFFFFFF,0x0080FFFF,0x00000000,0xFF8F0000,0xFFFFFFFF,
0x80FFFFFF,0x00000000,0xFFFF8F00,0xF8FFFFFF,0x00808F00,0x88000088,0x00F80800,
0xFFFFFF8F,0x00000080,0x00000000,0x00000000,0xFFFFFF8F,0xF8FFFFFF,0x00000000,
0xFFFFFF08,0xFFFFFFFF,0x000080FF,0x00000000,0xFF080000,0xFFFFFFFF,0x00F8FFFF,
0x00000000,0xFFFF0800,0xFFFFFFFF,0x00F8FFFF,0x00000000,0xFFFF0800,0x80FFFFFF,
0x00808F00,0x88000088,0x00F80800,0xFFFFFF08,0x000080F8,0x08000088,0x88000080,
0xFFFFFFFF,0xFFFFFFFF,0x00000080,0xFFFFFF8F,0xFFFFFFFF,0x000080FF,0x00000000,
0xFF8F0000,0xFFFFFFFF,0x00F8FFFF,0x00000000,0xFFFF0800,0xFFFFFFFF,0x0080FFFF,
0x00000000,0xFF8F0000,0x80FFFFFF,0x0080FF08,0x88000088,0x80FF0800,0xFFFFFF08,
0x8888F8FF,0x08000088,0xFF8888F8,0xFFFFFFFF,0xFFFFFFFF,0x080000F8,0xFFFFFFFF,
0xFFFFFFFF,0x0000F8FF,0x00000000,0xFFFF0800,0xFFFFFFFF,0x80FFFFFF,0x00000000,
0xFFFF8F00,0xFFFFFFFF,0x0000F8FF,0x00000000,0xFF080000,0x00F8FFFF,0x08808F00,
0xFF0880FF,0x00F80880,0xFFFF8F00,0xFFFFFFFF,0x8F0080FF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0x00000080,0xFFFFFF8F,0xFFFFFFFF,0x0000F8FF,0x00000000,0xFFFF8F00,
0xFFFFFFFF,0xF8FFFFFF,0x00000080,0xFFFFFF88,0xFFFFFFFF,0x0000F8FF,0x00000000,
0xFF080000,0x00F8FFFF,0x08808F00,0xFF0880FF,0x00F80880,0xFFFF8F00,0xFFFFFFFF,
0xFF08F8FF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x00000080,0xFFFFFF8F,0xFFFFFFFF,
0x0080FFFF,0x00000000,0xFFFFFF08,0xFFFFFFFF,0xFFFFFFFF,0x8F0080FF,0xFFFFFFFF,
0xFFFFFFFF,0x0000F8FF,0x00000000,0xFF080000,0x80FFFFFF,0x0880FF08,0xFF0880FF,
0x80FF0880,0xFFFFFF08,0xFFFFFFFF,0xFF08F8FF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0x080000F8,0xFFFFFFFF,0xFFFFFFFF,0x0080FFFF,0x08000000,0xFFFFFF8F,0xFFFFFFFF,
0xFFFFFFFF,0x080000F8,0xFFFFFFFF,0xFFFFFFFF,0x0000F8FF,0x00000000,0xFF080000,
0xF8FFFFFF,0x0000F88F,0xF808808F,0xF88F0000,0xFFFFFF8F,0xFFFFFFFF,0x8F0888FF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x8F0080FF,0xFFFFFFFF,0xFFFFFFFF,0x0080FFFF,
0x8F880080,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x080000F8,0xFFFFFFFF,0xFFFFFFFF,
0x0000F8FF,0x08000088,0xFF080080,0xFFFFFFFF,0x0000F8FF,0x88000088,0xFF8F0000,
0xFFFFFFFF,0xFFFFFFFF,0x080000F8,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFF88F8FF,
0xFFFFFFFF,0xFFFFFFFF,0x8800F8FF,0xFF8F0088,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0x080000F8,0xFFFFFFFF,0xFFFFFFFF,0x0000F8FF,0x08000088,0xFF080080,0xFFFFFFFF,
0x0880FFFF,0x8F0000F8,0xFFFF0880,0xFFFFFFFF,0xFFFFFFFF,0x8F0888FF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFF88FFFF,0xFFFF08F8,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x8F0080FF,0xFFFFFFFF,0xFFFFFFFF,0x8F88FFFF,
0x8F8888FF,0xFF8F88FF,0xFFFFFFFF,0x8FF8FFFF,0xFF0880FF,0xFFFF8FF8,0xFFFFFFFF,
0xFFFFFFFF,0xFF08F8FF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFF8FFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFF88F8FF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFF8FF8FF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFF8FFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xF0FFFFFF,0x00000000,0x00000000,0xFFFFFF0F,0xFFFFFFF0,
0xFFFFFFFF,0xF0FFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xF8FFFFFF,0x00000000,0xFFFFFF8F,0xFFFFFFFF,0xFFFFFFFF,0x00000080,0xFFFFFF8F,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xF0FFFFFF,0xFFFFFFFF,
0xF0FFFFFF,0xFFFFFF0F,0x000000F0,0x00FF0F00,0x00000000,0xFFFFFFFF,0x000000FF,
0x00000000,0x0F000000,0xFFFFFFFF,0x0800FFFF,0xFFFFFFFF,0xFFFF0080,0xFFFFFFFF,
0x00F0FFFF,0xFFFFFF8F,0xFFFF0080,0xFFFFFFFF,0x0000FFFF,0x00000000,0xFF0F0000,
0xFFFFFFFF,0xF0FFFFFF,0xFFFFFFFF,0xF0FFFFFF,0xFFFFFF0F,0xFFFFFF0F,0x0FF000FF,
0xFFFFFFFF,0xFFFFFF0F,0xFFFF0FFF,0xFFFFFFFF,0x0FFFFFFF,0xFFFFFFFF,0xFF0FF0FF,
0xFFFFFFFF,0xFF0FF0FF,0xFFFFFFFF,0xFF00FFFF,0xFFFFFFFF,0xFF0FF0FF,0xFFFFFFFF,
0xFF0FFFFF,0xFFFFFFFF,0xFF0FFFFF,0xFFFFFFFF,0xF8FFFFFF,0xFFFFFF8F,0xF0FFFFFF,
0xFFFFFF0F,0x00000000,0xFF00F00F,0x00000000,0xFFFFFF0F,0xFFFF0FFF,0xFFFFFFFF,
0x0FFFFFFF,0xFFFFFFFF,0x0800F0FF,0xFFFFFFFF,0xFF0F0080,0xFFFFFFFF,0x0000FFFF,
0xFFFFFF8F,0xFF0F0080,0xFFFFFFFF,0xFF0FFFFF,0xFFFFFFFF,0xFF0FFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFF0F,0xF0FFFFFF,0xFFFFFF0F,0xFFFFFFFF,0x000F0FF0,0xFFFFFFFF,
0xFFFFFFFF,0x000000FF,0x00000000,0x0F000000,0xFFFFFFFF,0xF80FFFFF,0x00000000,
0xFFFFF08F,0xFFFFFFFF,0xFFF0FFFF,0x00000080,0xFFFFF08F,0xFFFFFFFF,0xFF0FFFFF,
0xFFFFFFFF,0xFF0FFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFF80,0xF0FFFFFF,0xFFFFFF0F,
0xFFFFFFFF,0x000000F0,0xFFFFFFFF,0xFFFFFFFF,0xFF0FFFFF,0xFFFFFFFF,0xFF0FFFFF,
0xFFFFFFFF,0x8F00FFFF,0xFFFFFFFF,0xFFFF00F8,0xFFFFFFFF,0x08F0FFFF,0xFFFFFFFF,
0xFFFF00F8,0xFFFFFFFF,0xFF0FFFFF,0xFFFFFFFF,0xFF0FFFFF,0xFFFFFFFF,0xFF0FF0FF,
0xFFFF0FF8,0xF0FFFFFF,0xFFFFFF0F,0xF0FFFFFF,0xF0FFFF00,0xFFFFFF00,0xFFFFFFFF,
0xFF0FFFFF,0xFFFFFFFF,0xFF0FFFFF,0xFFFFFFFF,0x800FFFFF,0x00000000,0xFFFFF008,
0xFFFFFFFF,0xF8F0FFFF,0x00000000,0xFFFFF008,0xFFFFFFFF,0xFF80FFFF,0xFFFFFFFF,
0xFF8FF0FF,0xFFFFFFFF,0xFF080000,0xFFFF88FF,0xF0FFFFFF,0xFFFFFF0F,0xF0FFFFFF,
0xF0FFFF00,0xFFFFFF00,0xFFFFFFFF,0x0000FFFF,0x00000000,0xFF0F0000,0xFFFFFFFF,
0xFF0FF8FF,0xFFFFFFFF,0xFF8FF0FF,0xFFFFFFFF,0xFF00FFFF,0xFFFFFFFF,0xFF0FF0FF,
0xFFFFFFFF,0xFFF0FFFF,0xFFFFFFFF,0xFFFFF0FF,0xFFFFFFFF,0xFFF0F000,0xFFFFF0FF,
0xF0FFFFFF,0xFFFFFF8F,0xFFFFFFFF,0x0F00000F,0xFFFFFF0F,0xFFFFFFFF,0x0FF0FFFF,
0xFFFFFFFF,0xFFFF00FF,0xFFFFFFFF,0x00F8F0FF,0x00000000,0xFF0F8F00,0xFFFFFFFF,
0x0800FFFF,0xFFFFFFFF,0xFF0F00F8,0xFFFFFFFF,0x0FF8FFFF,0xFFFFFFFF,0xFFFF08FF,
0xF0FFFFFF,0x0FF0FF0F,0xFF0FF8FF,0x80FFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFF0F,
0xFFFFFF0F,0xFFFFFFFF,0x00FFFFFF,0x00000000,0xFFFF0F00,0xFFFFFFFF,0xFFFF80FF,
0xFFFFFFFF,0xFF08FFFF,0xFFFFFFFF,0xF80FF0FF,0x00000000,0xFF00FF08,0xFFFFFFFF,
0x00FFFFFF,0xFFFFFFFF,0xFFFF0FF0,0xF8FFFFFF,0x80FF0F0F,0xFF0FFF8F,0x00FFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xF0FFFF00,0xFFFFFF0F,0xFFFFFFFF,0xF0FFFFFF,0xFFFFFFFF,
0xFFFFFFF0,0xFFFFFFFF,0xFF0800FF,0xFFFFFFFF,0xFF0080FF,0xFFFFFFFF,0xFFFF00FF,
0xFF0FFFFF,0x0FF0FFFF,0xFFFFFFFF,0xF8FFFFFF,0xF0FFFF00,0xFFFFFF08,0xFFFFFFFF,
0xFFFFFF0F,0xFF0F0F80,0x00FFFFFF,0xFFFFFFFF,0xF0FFFFFF,0x00000000,0xFFFFFF00,
0xFFFFFFFF,0xF0FFFFFF,0xFFFFFFFF,0xFFFFFFF0,0xFFFFFFFF,0x00F00FFF,0x00000000,
0xFFF00F00,0xFFFFFFFF,0xFFFF0FF8,0xFF0FFFFF,0x08FFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0x00FF0FF0,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFF00,0xFF0F80FF,0x08FFFFFF,0xFFFFFFFF,
0x80FFFFFF,0xFFFFFFFF,0xFFFF8FF0,0xFFFFFFFF,0xF0FFFFFF,0xFFFFFFFF,0xFFFFFFF0,
0xFFFFFFFF,0xFF000FF8,0x0F8FF8F0,0x8FF000FF,0xFFFFFFFF,0xFFFFFFF0,0xFF0FFFFF,
0xF0FFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xF0FFFF00,0xFFFFFF0F,0xFFFFFFFF,0xFFFFFFF0,
0xFF0FFFFF,0x0FF8FFFF,0xFFFFFFFF,0x0FFFFFFF,0xFFFFFFFF,0xFFFF0FFF,0xFFFFFFFF,
0xF0FFFFFF,0xFFFFFFFF,0xFFFFFFF0,0xFFFFFFFF,0xFF00F0F0,0x0FFFFFF0,0x0F0F00FF,
0xFFFFFFFF,0xFFFFFF0F,0xFFF8F8FF,0xFFFFFFFF,0xFFFFFF0F,0xF8FFFFFF,0xFFFFFF0F,
0xFFFFFF08,0xFFFFFFFF,0xFFFF0FF8,0xFF00FFFF,0x8FF0FFFF,0xFFFFFFFF,0x8FF0FFFF,
0xFF0FFFFF,0xFFFF80FF,0xFFFFFFFF,0xF0FFFFFF,0xFFFFFFFF,0xFFFFFFF0,0xFFFFFFFF,
0xFFF0F0F0,0x08FFFF80,0x0F0F0FFF,0xFFFFFFFF,0xFFFFFF0F,0xFFF0F0FF,0xFFFFFFFF,
0xFFFFFF0F,0xF0FFFFFF,0xFFFFFFFF,0xFFFFFFF0,0xFFFFFFFF,0xFFFF0FFF,0xFFF0FFFF,
0xFF80FFFF,0xFFFFFFFF,0xFFF0FFFF,0xFF0FFFFF,0xFFFFF0FF,0xFFFFFFFF,0xF0FFFFFF,
0xFFFFFFFF,0xFFFFFFF0,0xFFFFFFFF,0xFFF00880,0xF0F00F0F,0x08800FFF,0xFFFFFFFF,
0xFFFFFF8F,0x0FF808FF,0xFFFFFFFF,0xFFFFFF8F,0xF0FFFFFF,0xFFFFFFFF,0xFFFFFFF0,
0xFFFFFFFF,0xFFFF80FF,0xFFF8FFFF,0xFF08FFFF,0xFFFFFFFF,0xFFF0FFFF,0x0F0000FF,
0xFFFFF0FF,0xFFFFFFFF,0xF0FFFFFF,0xFFFFFFFF,0xFFFFFFF0,0xFFFFFFFF,0xF0F08F00,
0xF8F00F8F,0x00F80F0F,0xFFFFFFFF,0xFFFFFFF0,0x08FF0FF8,0xF0FFFFFF,0xFFFFFFFF,
0xF8FFFFFF,0xFFFFFF0F,0xFFFFFF08,0xFFFFFFFF,0xFFF0F0FF,0xFFFFFFFF,0xFF0FF8FF,
0xFFFFFFFF,0x8FF8FFFF,0xFF0FFFFF,0xFFFF88FF,0xFFFFFFFF,0xF0FFFFFF,0xFFFFFFFF,
0xFFFFFFF0,0xFFFFFFFF,0xF0F0FF00,0xFFF00FFF,0x00FF0F0F,0xFFFFFFFF,0xF0FF0FF8,
0x00FF0F00,0x08FFFF00,0xFFFFFFFF,0xFFFFFFFF,0xF0FFFF00,0xFFFFFF0F,0xFFFFFFFF,
0x0FF0F0FF,0xFFFFFFFF,0xFF8FF0FF,0xFFFFFFFF,0x0FFFFFFF,0xFF0FFFFF,0xFFFF0FFF,
0xFFFFFFFF,0x00FFFFFF,0x00000000,0xFFFF0F00,0xF8FFFFFF,0xF0F0FF08,0xFFF00FFF,
0x80FF0F0F,0xFFFFFF8F,0x0800F8FF,0x0FFF0FFF,0xFF0800F8,0xFFFFFFFF,0xFFFFFFFF,
0x00FF0FF0,0xFFFFFFFF,0xFFFFFFFF,0x0F0FF8FF,0xFFFFFFFF,0xFFFF00FF,0xFFFFFFFF,
0x80FFFFFF,0xFFFFFFFF,0xFFFF8FF0,0xFFFFFFFF,0x0FF0FFFF,0xFFFFFFFF,0xFFFF00FF,
0xF0FFFFFF,0x08F0FF0F,0xFF0880FF,0xF0FF0F80,0xFFFFFF0F,0xFFFFFFFF,0x0FFF0FFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0FFF0FFF,0xFFFFFFFF,0xFFFFFFFF,0xFF0FFFFF,
0xFFFFFFFF,0xFFFF0FF0,0xFFFFFFFF,0xF8FFFFFF,0xF0FFFF00,0xFFFFFF08,0xFFFFFFFF,
0x0000FFFF,0x00000000,0xFF0F0000,0x0FFFFFFF,0x0FF0FFF0,0xFF0FF0FF,0x0FFF0FF0,
0xFFFFFFF0,0xFFFFFFFF,0xFF00F0FF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x00FF0FF0,
0xFFFFFFFF,0xFFFFFFFF,0xF080FFFF,0xFF0FFFFF,0xFFFFFF00,0xFFFFFFFF,0xFFFFFFFF,
0x08F000F8,0xFFFFFFFF,0xFFFFFFFF,0xFF0FFFFF,0xFFFFFFFF,0xFF0FFFFF,0x8FFFFFFF,
0x0FF0FFF8,0xFF0FF0FF,0x8FFF0FF0,0xFFFFFFF8,0xFFFFFFFF,0xFF0FFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0x08FF0FF8,0xFFFFFFFF,0xFFFFFFFF,0xF0F0FFFF,0x0000FF00,
0xFFFFFF8F,0xFFFFFFFF,0xFFFFFFFF,0xFF00F0FF,0xFFFFFFFF,0xFFFFFFFF,0xFF0FFFFF,
0xFFFFFFFF,0xFF0FFFFF,0xF0FFFFFF,0x0FF0FF0F,0xFF0FF0FF,0xF0FF0FF0,0xFFFFFF0F,
0xFFFFFFFF,0xFF0FFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0FF000FF,0xFFFFFFFF,
0xFFFFFFFF,0xF0F0FFFF,0x8F00F000,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0FF000FF,
0xFFFFFFFF,0xFFFFFFFF,0xF00FFFFF,0x00FF0F00,0xFF0FFF00,0xFFFFFFFF,0xF00FFFFF,
0xFF0FF0FF,0xFFFFF00F,0xFFFFFFFF,0xFFFFFFFF,0xFF0FFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFF08F8FF,0xFFFFFFFF,0xFFFFFFFF,0x00F0FFFF,0xFFFFF0F0,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0x0FFF0FFF,0xFFFFFFFF,0xFFFFFFFF,0xF00FFFFF,0x0FFF0FFF,
0xFF0FFFF0,0xFFFFFFFF,0xF88FFFFF,0xFFF00FFF,0xFFFFF88F,0xFFFFFFFF,0xFFFFFFFF,
0x0F0000FF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFF00FFFF,0xFFFF00FF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0FF000FF,0xFFFFFFFF,
0xFFFFFFFF,0x0000FFFF,0x0F0000FF,0xFF0F00F0,0xFFFFFFFF,0x0FF0FFFF,0xFFF88FFF,
0xFFFF0FF0,0xFFFFFFFF,0xFFFFFFFF,0xFF0FFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFF0FFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFF00F0FF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFF0FF0FF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFF0FFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0x0000FFFF};

unsigned long set40[4830]={
0x4B764D42,0x00000000,0x00760000,0x00280000,0x00F00000,0x00A00000,0x00010000,
0x00000004,0x4B000000,0x00000000,0x00000000,0x00100000,0x00100000,0x00000000,
0x00000000,0x80000080,0x80000000,0x00800080,0x00800000,0x80800080,0xC0C00000,
0x808000C0,0x00000080,0xFF0000FF,0xFF000000,0x00FF00FF,0x00FF0000,0xFFFF00FF,
0xFFFF0000,0xFFFF00FF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x888888F8,0x88888888,
0x88888888,0xFFFFFF8F,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x888888FF,
0x8F888888,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x8888F8FF,0xFF8F8888,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0x00000080,0x00000000,0x00000000,0xFFFFFF08,0x888808F8,0xFF888888,0x888888FF,
0x8F808888,0xFFFFFFFF,0x8888F8FF,0x88888888,0x88888888,0xFF8F8888,0xFFFFFFFF,
0x88FFFFFF,0x00000088,0x08000000,0xFFFF8F88,0xFFFFFFFF,0xF8FFFFFF,0x00008088,
0x88080000,0xFFFFFF8F,0xFFFFFFFF,0x8888FFFF,0x88888888,0x88888888,0xFFFF8888,
0xFFFFFFFF,0xFFFFFFFF,0x00000080,0x00000000,0x00000000,0xFFFFFF08,0x00000080,
0x88000000,0x00000088,0x08000000,0xFFFFFFFF,0x000080FF,0x00000000,0x00000000,
0xFF080000,0xFFFFFFFF,0x00F8FFFF,0x00000000,0x00000000,0xFFFF0800,0xFFFFFFFF,
0x80F8FFFF,0x00000000,0x00000000,0xFFFF8F08,0xFFFFFFFF,0x0000F8FF,0x00000000,
0x00000000,0xFF8F0000,0xFFFFFFFF,0xFFFFFFFF,0x00000080,0x00000000,0x00000000,
0xFFFFFF08,0x00000080,0x00000000,0x00000000,0x08000000,0xFFFFFFFF,0x000080FF,
0x00000000,0x00000000,0xFF080000,0xFFFFFFFF,0x0080FFFF,0x00000000,0x00000000,
0xFF8F0000,0xFFFFFFFF,0x0080FFFF,0x00000000,0x00000000,0xFFFF0800,0xFFFFFFFF,
0x0000F8FF,0x00000000,0x00000000,0xFF8F0000,0xFFFFFFFF,0xFFFFFFFF,0x000000F8,
0x00000000,0x00000000,0xF8FFFF08,0x00000000,0x00000000,0x00000000,0x00000000,
0xFFFFFF8F,0x000080FF,0x00000000,0x00000000,0xFF080000,0xFFFFFFFF,0x0080FFFF,
0x00000000,0x00000000,0xFF8F0000,0xFFFFFFFF,0x0000F8FF,0x00000000,0x00000000,
0xFF8F0000,0xFFFFFFFF,0x0000F8FF,0x00000000,0x00000000,0xFF8F0000,0xFFFFFFFF,
0xFFFFFFFF,0x000000F8,0x00000000,0x00000000,0xFFFFFF08,0x00000080,0x00000000,
0x00000000,0x08000000,0xFFFFFFFF,0x000080FF,0x00000000,0x00000000,0xFF080000,
0xFFFFFFFF,0x00F8FFFF,0x00000000,0x00000000,0xFFFF0800,0xFFFFFFFF,0x0080FFFF,
0x00000000,0x00000000,0xFFFF0800,0xFFFFFFFF,0x0000F8FF,0x00000000,0x00000000,
0xFF8F0000,0xFFFFFFFF,0xFFFFFFFF,0x000080FF,0x00000000,0x00000000,0xFFFFFF08,
0x888888F8,0x00008888,0x88880000,0x8F888888,0xFFFFFFFF,0x000080FF,0x00000000,
0x00000000,0xFF080000,0xFFFFFFFF,0x00F8FFFF,0x00000000,0x00000000,0xFFFF0800,
0xFFFFFFFF,0x00F8FFFF,0x00000000,0x00000000,0xFFFF8F00,0xFFFFFFFF,0x0000F8FF,
0x00000000,0x00000000,0xFF8F0000,0xFFFFFFFF,0x8FF8FFFF,0x000080FF,0x00000000,
0x00000000,0xFFFFFF08,0xFFFFFFFF,0x008088FF,0xFF880800,0xFFFFFFFF,0xFFFFFFFF,
0x0088F8FF,0x00000000,0x00000000,0xFF8F8800,0xFFFFFFFF,0x00F8FFFF,0x00000000,
0x00000000,0xFFFF0800,0xFFFFFFFF,0x00F8FFFF,0x00000000,0x00000000,0xFFFF8F00,
0xFFFFFFFF,0x0000F8FF,0x00000000,0x00000000,0xFF8F0000,0xFFFFFFFF,0x088088FF,
0x0000F8FF,0x00000000,0x00000000,0xFFFFFF08,0xFFFFFFFF,0x000000F8,0x88000000,
0xFFFFFFFF,0xFFFFFFFF,0x00F8FFFF,0x00000000,0x00000000,0xFFFF8F00,0xFFFFFFFF,
0x00F8FFFF,0x00000000,0x00000000,0xFFFF0800,0xFFFFFFFF,0x00F8FFFF,0x00000000,
0x00000000,0xFFFF8F00,0xFFFFFFFF,0x0080F8FF,0x00000000,0x00000000,0xFF8F0800,
0xFFFFFFFF,0x000000F8,0x0080FF8F,0x00000000,0x00000000,0xFFFFFF08,0xF8FFFFFF,
0x00000080,0x00000000,0xFFFFFF8F,0xFFFFFFFF,0x00F8FFFF,0x00000000,0x00000000,
0xFFFF8F00,0xFFFFFFFF,0x00F8FFFF,0x00000000,0x00000000,0xFFFF0800,0xFFFFFFFF,
0x0080FFFF,0x00000000,0x00000000,0xFFFF0800,0xFFFFFFFF,0x0080FFFF,0x00000000,
0x00000000,0xFFFF0800,0xFFFFFFFF,0x00000080,0x00F8FF08,0x00000000,0x00000000,
0xFFFFFF08,0xFFFFFFFF,0x00000080,0x08000000,0xFFFFFFFF,0xFFFFFFFF,0x00F8FFFF,
0x00000000,0x00000000,0xFFFF8F00,0xFFFFFFFF,0x0080FFFF,0x00000000,0x00000000,
0xFF8F0000,0xFFFFFFFF,0x0080FFFF,0x00000000,0x00000000,0xFFFF0800,0xFFFFFFFF,
0x0088FFFF,0x00000000,0x00000000,0xFFFF8800,0xF8FFFFFF,0x00000000,0x80FFFF08,
0x00000000,0x00000000,0xFFFFFF8F,0xFFFFFFFF,0x00000080,0x08000000,0xFFFFFFFF,
0xFFFFFFFF,0x80FFFFFF,0x00000000,0x00000000,0xFFFFFF08,0xFFFFFFFF,0x0080FFFF,
0x00000000,0x00000000,0xFF8F0000,0xFFFFFFFF,0x0000F8FF,0x00000000,0x00000000,
0xFF8F0000,0xFFFFFFFF,0x00F8FFFF,0x00000000,0x00000000,0xFFFF8F00,0xF8FFFFFF,
0x00000000,0x80FF8800,0x00000000,0x00000000,0xFFFFFF8F,0xFFFFFFFF,0x000000F8,
0x8F000000,0xFFFFFFFF,0xFFFFFFFF,0xF8FFFFFF,0x00000000,0x00000000,0xFFFFFF8F,
0xFFFFFFFF,0x0000F8FF,0x00000000,0x00000000,0xFF080000,0xFFFFFFFF,0x000080FF,
0x00000000,0x00000000,0xFF080000,0xFFFFFFFF,0x80F8FFFF,0x00000000,0x00000000,
0xFFFF8F08,0xF8FFFFFF,0x00000000,0xF8880000,0x00000000,0x00000000,0xFFFFFF8F,
0xFFFFFFFF,0x000000F8,0x8F000000,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x00000080,
0x08000000,0xFFFFFFFF,0xFFFFFFFF,0x0000F8FF,0x00000000,0x00000000,0xFF080000,
0xFFFFFFFF,0x000000F8,0x00000000,0x00000000,0x8F000000,0xFFFFFFFF,0x88FFFFFF,
0x00000000,0x00000000,0xFFFFFF88,0xF8FFFFFF,0x00000000,0x88000000,0x00000000,
0x00000000,0xFFFFFF8F,0xFFFFFFFF,0x000000F8,0x8F000000,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0x00000080,0x08000000,0xFFFFFFFF,0xFFFFFFFF,0x000080FF,0x00000000,
0x00000000,0x8F000000,0xFFFFFFFF,0x00000080,0x00000000,0x00000000,0x08000000,
0xFFFFFFFF,0xF8FFFFFF,0x00000080,0x08000000,0xFFFFFF8F,0xFFFFFFFF,0x00000080,
0x00000000,0x00000080,0x00000000,0xFFFFFF8F,0xFFFFFFFF,0x00000080,0x08000000,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x00000080,0x08000000,0xFFFFFFFF,0xFFFFFFFF,
0x000080FF,0x00000000,0x00000000,0x8F000000,0xFFFFFFFF,0x00000080,0x00000000,
0x00000000,0x08000000,0xFFFFFFFF,0xFFFFFFFF,0x00008088,0x88080000,0xFFFFFFFF,
0xFFFFFFFF,0x00000080,0x00000000,0x00000000,0x08000000,0xFFFFFFFF,0xF8FFFFFF,
0x00000000,0x00000000,0xFFFFFF8F,0xFFFFFFFF,0xFFFFFFFF,0x00000080,0x08000000,
0xFFFFFFFF,0xFFFFFFFF,0x080080FF,0x00000000,0x00000000,0x8F000008,0xF8FFFFFF,
0x00000000,0x00000000,0x00000000,0x00000000,0xFFFFFF8F,0xFFFFFFFF,0x000000F8,
0x8F000000,0xFFFFFFFF,0xFFFFFFFF,0x000000F8,0x00000000,0x00000000,0x08000000,
0xFFFFFFFF,0xF8FFFFFF,0x00000000,0x00000000,0xFFFFFF8F,0xFFFFFFFF,0xFFFFFFFF,
0x00000080,0x08000000,0xFFFFFFFF,0xFFFFFFFF,0x080080FF,0x00000000,0x00000000,
0x8F000008,0xF8FFFFFF,0x00000000,0x00000000,0x00000000,0x00000000,0xFFFFFF8F,
0xFFFFFFFF,0x00000088,0x88000000,0xFFFFFFFF,0xFFFFFFFF,0x000000F8,0x00000000,
0x00000000,0x08000000,0xFFFFFFFF,0x80FFFFFF,0x00000000,0x00000000,0xFFFFFF08,
0xFFFFFFFF,0xFFFFFFFF,0x00000080,0x08000000,0xFFFFFFFF,0xFFFFFFFF,0x880080FF,
0x00080000,0x00000800,0x8F008008,0xF8FFFFFF,0x00000000,0x00000000,0x00000000,
0x00000000,0xFFFFFF8F,0xFFFFFFFF,0x00000080,0x08000000,0xFFFFFFFF,0xFFFFFFFF,
0x000080FF,0x00000000,0x00000000,0x8F000000,0xFFFFFFFF,0x80FFFFFF,0x00000000,
0x00000000,0xFFFFFF08,0xFFFFFFFF,0xFFFFFFFF,0x00000080,0x08000000,0xFFFFFFFF,
0xFFFFFFFF,0x880000F8,0x00080000,0x00000800,0x08008008,0xF8FFFFFF,0x00000000,
0x00000000,0x00000000,0x00000000,0xFFFFFF8F,0xFFFFFFFF,0x00000080,0x08000000,
0xFFFFFFFF,0xFFFFFFFF,0x000080FF,0x00000000,0x00000000,0x8F000000,0xFFFFFFFF,
0x80FFFFFF,0x00000000,0x00000000,0xFFFFFF08,0xFFFFFFFF,0xFFFFFFFF,0x00000080,
0x08000000,0xFFFFFFFF,0xFFFFFFFF,0xF80800F8,0x00880000,0x00800800,0x0800F808,
0xF8FFFFFF,0x00000000,0x00000000,0x00000000,0x00000000,0xFFFFFF8F,0xFFFFFFFF,
0x00000080,0x08000000,0xFFFFFFFF,0xFFFFFFFF,0x0000F8FF,0x00000000,0x00000000,
0xFF080000,0xFFFFFFFF,0x80FFFFFF,0x00000000,0x00000000,0xFFFFFF08,0xFFFFFFFF,
0xFFFFFFFF,0x00000080,0x08000000,0xFFFFFFFF,0xFFFFFFFF,0xF80800F8,0x00880000,
0x00800800,0x0800F808,0xFFFFFFFF,0x00000080,0x00000000,0x00000000,0x08000000,
0xFFFFFFFF,0xFFFFFFFF,0x00000080,0x08000000,0xFFFFFFFF,0xFFFFFFFF,0x0000F8FF,
0x00000000,0x00000000,0xFF080000,0xFFFFFFFF,0xF8FFFFFF,0x00000000,0x00000000,
0xFFFFFF8F,0xFFFFFFFF,0xFFFFFFFF,0x00000080,0x08000000,0xFFFFFFFF,0xFFFFFFFF,
0xF88F00F8,0x00880000,0x00800800,0x0880FF08,0xFFFFFFFF,0x00000080,0x00000000,
0x00000000,0x08000000,0xFFFFFFFF,0xFFFFFFFF,0x00000088,0x88000000,0xFFFFFFFF,
0xFFFFFFFF,0x0000F8FF,0x00000000,0x00000000,0xFF8F0000,0xFFFFFFFF,0xF8FFFFFF,
0x00000000,0x00000000,0xFFFFFF8F,0xFFFFFFFF,0xF8FFFFFF,0x00000000,0x00000000,
0xFFFFFF8F,0xFFFFFFFF,0xF88F00F8,0x00F80800,0x00F80800,0x0880FF08,0xFFFFFFFF,
0x000000F8,0x00000000,0x00000000,0x8F000000,0xFFFFFFFF,0xFFFFFFFF,0x000000F8,
0x8F000000,0xFFFFFFFF,0xFFFFFFFF,0x0080FFFF,0x00000000,0x00000000,0xFF8F0000,
0xFFFFFFFF,0xFFFFFFFF,0x00000080,0x08000000,0xFFFFFFFF,0xFFFFFFFF,0x80FFFFFF,
0x00000000,0x00000000,0xFFFFFF08,0xFFFFFFFF,0xF8FF0880,0x80FF0800,0x00F88F00,
0x00F8FF08,0xFFFFFF8F,0x000088FF,0x00008800,0x00880000,0xFF880000,0xFFFFFFFF,
0xFFFFFFFF,0x000080F8,0x8F080000,0xFFFFFFFF,0xFFFFFFFF,0x0080FFFF,0x00000000,
0x00000000,0xFFFF0800,0xFFFFFFFF,0xFFFFFFFF,0x000000F8,0x8F000000,0xFFFFFFFF,
0xFFFFFFFF,0x00F8FFFF,0x00000000,0x00000000,0xFFFF8F00,0xF8FFFFFF,0xF8FF0800,
0x80FF0800,0x00F88F00,0x00F8FF08,0xFFFFFF08,0x8888FFFF,0x0000F888,0x888F0000,
0xFFFF8888,0xFFFFFFFF,0xFFFFFFFF,0x008088FF,0xFF880800,0xFFFFFFFF,0xFFFFFFFF,
0x00F8FFFF,0x00000000,0x00000000,0xFFFF8F00,0xFFFFFFFF,0xFFFFFFFF,0x000080FF,
0xFF080000,0xFFFFFFFF,0xFFFFFFFF,0x0080FFFF,0x00000000,0x00000000,0xFFFF0800,
0x80FFFFFF,0xF88F0000,0x80FF8F00,0x80FF8F00,0x0080FF08,0xFFFF8F00,0xFFFFFFFF,
0x0080FFFF,0xFFFF0800,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0000F8FF,0xFF8F0000,
0xFFFFFFFF,0xFFFFFFFF,0x00F8FFFF,0x00000000,0x00000000,0xFFFFFF08,0xFFFFFFFF,
0xFFFFFFFF,0x0000F8FF,0xFF8F0000,0xFFFFFFFF,0xFFFFFFFF,0x0080FFFF,0x00000000,
0x00000000,0xFFFF0800,0x80FFFFFF,0xF88F0000,0x80FF8F00,0x80FF8F00,0x0080FF08,
0xFFFF8F00,0xFFFFFFFF,0x00F8FFFF,0xFFFF8F00,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0x0000F8FF,0xFF8F0000,0xFFFFFFFF,0xFFFFFFFF,0x80FFFFFF,0x00000000,0x08000000,
0xFFFFFF8F,0xFFFFFFFF,0xFFFFFFFF,0x0088FFFF,0xFFFF8800,0xFFFFFFFF,0xFFFFFFFF,
0x0080FFFF,0x00000000,0x00000000,0xFFFF0800,0x80FFFFFF,0x808F0000,0x80FF8F00,
0x80FF8F00,0x00808F00,0xFFFF8F00,0xFFFFFFFF,0x80FFFFFF,0xFFFFFF08,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0x0000F8FF,0xFF8F0000,0xFFFFFFFF,0xFFFFFFFF,0x80FFFFFF,
0x00000000,0x8F080000,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0080FFFF,0xFFFF0800,
0xFFFFFFFF,0xFFFFFFFF,0x0080FFFF,0x00000000,0x00000000,0xFFFF0800,0xF8FFFFFF,
0x00F80800,0x80FF0800,0x00F88F00,0x00F80800,0xFFFFFF08,0xFFFFFFFF,0x80FFFFFF,
0xFFFFFF08,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0000F8FF,0xFF8F0000,0xFFFFFFFF,
0xFFFFFFFF,0x80FFFFFF,0x00000000,0xFF8F8808,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0x0080FFFF,0xFFFF0800,0xFFFFFFFF,0xFFFFFFFF,0x0080FFFF,0x00000000,0x00000000,
0xFFFF0800,0xFFFFFFFF,0x00F88F88,0x00F80800,0x00F80800,0x88FF0800,0xFFFFFF8F,
0xFFFFFFFF,0x80F8FFFF,0xFFFF8808,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0080F8FF,
0xFF8F0800,0xFFFFFFFF,0xFFFFFFFF,0x80FFFFFF,0x00800800,0xFFFFFF08,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0x0080FFFF,0xFFFF0800,0xFFFFFFFF,0xFFFFFFFF,0x0080FFFF,
0x00808800,0x00880800,0xFFFF0800,0xFFFFFFFF,0x00F8FFFF,0x00F80800,0x00F80800,
0xFFFF0800,0xFFFFFFFF,0xFFFFFFFF,0x0080FFFF,0xFFFF0800,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0x0088FFFF,0xFFFF8800,0xFFFFFFFF,0xFFFFFFFF,0x00F8FFFF,0x00808F08,
0xFFFFFF8F,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0080FFFF,0xFFFF0800,0xFFFFFFFF,
0xFFFFFFFF,0x0080FFFF,0x00808F00,0x00F80800,0xFFFF0800,0xFFFFFFFF,0x80FFFFFF,
0x00F88F00,0x80FF0800,0xFFFF8F00,0xFFFFFFFF,0xFFFFFFFF,0x0080FFFF,0xFFFF0800,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x88F8FFFF,0xFFFF8F88,0xFFFFFFFF,0xFFFFFFFF,
0x00F8FFFF,0x08F8FF8F,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x00F8FFFF,
0xFFFF8F00,0xFFFFFFFF,0xFFFFFFFF,0x88F8FFFF,0x88F8FF88,0x88F88F88,0xFFFF8F88,
0xFFFFFFFF,0xF8FFFFFF,0x80FFFF88,0xF8FF8F00,0xFFFFFF88,0xFFFFFFFF,0xFFFFFFFF,
0x80F8FFFF,0xFFFF8808,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0x88F8FFFF,0x8FFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0x88FFFFFF,0xFFFFFF88,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xF8FFFFFF,0xFFFFFF88,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0x80FFFFFF,0xFFFFFF08,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x88FFFFFF,0xFFFFFF88,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x000000F0,0x00000000,0x00000000,0xFFFFFF0F,
0xFFFF0FFF,0xFFFFFFFF,0xFFFFFFFF,0xFFF0FFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x000000FF,0x0F000000,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0x00008077,0x77080000,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x000000F0,0x00000000,
0x00000000,0xFFFFFF0F,0x000000F0,0xFF070000,0x000070FF,0x0F000000,0xFFFFFFFF,
0x0000F0FF,0x00000000,0x00000000,0xFF0F0000,0xFFFFFFFF,0x00FFFFFF,0x00000000,
0x00000000,0xFFFF0F00,0xFFFFFFFF,0x80F7FFFF,0x00000000,0x00000000,0xFFFF7F08,
0xFFFFFFFF,0x0000FFFF,0x00000000,0x00000000,0xFFFF0000,0xFFFFFFFF,0xFFFFFFFF,
0x000000F0,0x00000000,0xF00F0000,0xFFFFFF0F,0x00000070,0x87000000,0x00000078,
0x07000000,0xFFFFFFFF,0x0000F0FF,0x00000000,0x00000000,0xFF0F0000,0xFFFFFFFF,
0x00F0FFFF,0x00000000,0x00000000,0xFFFF0000,0xFFFFFFFF,0x0070FFFF,0x00000000,
0x00000000,0xFFFF0700,0xFFFFFFFF,0x0000FFFF,0x00000000,0x00000000,0xFFFF0000,
0xFFFFFFFF,0xFFFFFFFF,0x000000FF,0x00000000,0xF00F0000,0xFFFFFF0F,0x00000080,
0x08000000,0x00000080,0x08000000,0xFFFFFFFF,0x0000F0FF,0x00000000,0x00000000,
0xFF0F0000,0xFFFFFFFF,0x0FF0FFFF,0x00000000,0x00000000,0xFFFF000F,0xFFFFFFFF,
0x0700F7FF,0x00000080,0x08000000,0xFF7F0070,0xFFFFFFFF,0x0000FFFF,0x00000000,
0x00000000,0xFFFF0000,0xFFFFFFFF,0xFFFFFFFF,0x000000FF,0x00000000,0xF00F0000,
0xFFFFFF0F,0x000000F0,0x00000000,0x00000000,0x0F000000,0xFFFFFFFF,0x0000F0FF,
0x00000000,0x00000000,0xFF0F0000,0xFFFFFFFF,0x00FFFFFF,0x000000FF,0x0F000000,
0xFFFF0FF0,0xFFFFFFFF,0x0070FFFF,0x008077FF,0xFF770800,0xFFFF0700,0xFFFFFFFF,
0x0000FFFF,0x00000000,0x00000000,0xFFFF0000,0xFFFFFFFF,0xFFFFFFFF,0x0000F0FF,
0x00000000,0xF00F0000,0xFFFFFF0F,0xFFFFFFFF,0x0070FFFF,0xFFFF0700,0xFFFFFFFF,
0xFFFFFFFF,0x0F00F0FF,0xFFFFFFFF,0xFFFFFFFF,0xFF0F00F0,0xFFFFFFFF,0x00FFFFFF,
0xFFFFFF00,0xF0FFFFFF,0xFFFF0F00,0xFFFFFFFF,0x00F7FFFF,0xFFFF8700,0x0078FFFF,
0xFFFF7F00,0xFFFFFFFF,0x0000FFFF,0x00000000,0x00000000,0xFFFF0000,0xFFFFFFFF,
0xFFFFFFFF,0x0000F0FF,0x00000000,0xF00F0000,0xFFFFFF0F,0xFFFFFFFF,0x80F7FFFF,
0xFFFF7F08,0xFFFFFFFF,0xFFFFFFFF,0x00FFFFFF,0x00000000,0x00000000,0xFFFFFF00,
0xFFFFFFFF,0x00FFFFFF,0x00000000,0x00000000,0xFFFF0F00,0xFFFFFFFF,0x00FFFFFF,
0x000080F7,0x7F080000,0xFFFFFF00,0xFFFFFFFF,0x0080FFFF,0x00000000,0x00000000,
0xFFFF0800,0xFFFFFFFF,0x0FF0FFFF,0x0000FFFF,0x00000000,0xF00F0000,0xFFFFFF0F,
0xFFFFFFFF,0x000000F7,0x7F000000,0xFFFFFFFF,0xFFFFFFFF,0x00FFFFFF,0x00000000,
0x00000000,0xFFFFFF00,0xFFFFFFFF,0x00FFFFFF,0x000000FF,0x0F000000,0xFFFF0FF0,
0xFFFFFFFF,0x00F8FFFF,0xFFFF7F08,0x80F7FFFF,0xFFFF8F00,0xFFFFFFFF,0x0070FFFF,
0x00000000,0x00000000,0xFFFF0700,0xFFFFFFFF,0x000000FF,0x00F0FFFF,0x00000000,
0xF00F0000,0xFFFFFF0F,0xFFFFFFFF,0x00000000,0x00000000,0xFFFFFFFF,0xFFFFFFFF,
0x00FFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFF00,0xFFFFFFFF,0x00FFFFFF,0xFFFFFF00,
0xF0FFFFFF,0xFFFF0F00,0xFFFFFFFF,0x00F0FFFF,0x00000000,0x00000000,0xFFFF0F00,
0xFFFFFFFF,0x00F8FFFF,0x00000000,0x00000000,0xFFFF8F00,0xFFFFFFFF,0x000F00F0,
0x00FFFF0F,0x00000000,0xF00F0000,0xFFFFFF0F,0xFFFFFFFF,0x0000FF70,0x07FF0000,
0xFFFFFFFF,0xFFFFFFFF,0x00FFFFFF,0x00000000,0x00000000,0xFFFFFF00,0xFFFFFFFF,
0x0FF0FFFF,0x00000000,0x00000000,0xFFFF000F,0xFFFFFFFF,0x0080FFFF,0x00000000,
0x00000000,0xFFFF0800,0xFFFFFFFF,0x00F7FFFF,0x00000000,0x00000000,0xFFFF7F00,
0xFFFFFFFF,0x000F0000,0xF0FFFF0F,0x00000000,0x00FF0000,0xFFFFFFFF,0xFFFFFFFF,
0xFFFF0FF0,0x0FF0FFFF,0xFFFFFFFF,0xFFFFFFFF,0x70FFFFFF,0x00000000,0x00000000,
0xFFFFFF07,0xFFFFFFFF,0x0FF0FFFF,0x000000FF,0x0F000000,0xFFFF00FF,0xFFFFFFFF,
0x0F00F7FF,0x000088F7,0x7F880000,0xFF7F00F0,0xFFFFFFFF,0x80FFFFFF,0x00000000,
0x00000000,0xFFFFFF08,0xFFFFFFFF,0x0000F000,0xF0FFFF00,0x00000000,0x00FF0000,
0xFFFFFFFF,0xFFFFFFFF,0x000000F7,0x7F000000,0xFFFFFFFF,0xFFFFFFFF,0xF7FFFFFF,
0xFFFF0F00,0x00F0FFFF,0xFFFFFF7F,0xFFFFFFFF,0x0000FFFF,0xFFFFFF0F,0xFFFFFFFF,
0xFF0F0000,0xFFFFFFFF,0xFF0070FF,0xF0FFFF87,0x78FFFF0F,0xFF0700FF,0xFFFFFFFF,
0x70FFFFFF,0x00000000,0x00000000,0xFFFFFF07,0xFFFFFFFF,0x0000FF00,0xFFFF0000,
0x00000000,0x00FF0000,0xFFFFFFFF,0xFFFFFFFF,0x00000FFF,0xFFF00000,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0x00000070,0x07000000,0xFFFFFFFF,0xFFFFFFFF,0x0000FFFF,
0x00000000,0x00000000,0xFF0F0000,0xFFFFFFFF,0xF00F00F7,0xF0000000,0x0000000F,
0x7F00F00F,0xFFFFFFFF,0xF7FFFFFF,0x00000000,0x00000000,0xFFFFFF7F,0xFFFFFFFF,
0x00000F00,0xFF000000,0x00000000,0x00FF0000,0xFFFFFFFF,0xFFFFFFFF,0xFFFF00F7,
0x7F00FFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x000000F0,0x0F000000,0xFFFFFFFF,
0xFFFFFFFF,0x0000F0FF,0x00000000,0x00000000,0xFF000000,0xFFFFFFFF,0x00FF00F8,
0xF0000000,0x0000000F,0x8F00FF00,0xFFFFFFFF,0xFFFFFFFF,0x00000078,0x87000000,
0xFFFFFFFF,0xFFFFFFFF,0x000000F0,0x00000000,0x000000F0,0x00FF0000,0xFFFFFFFF,
0xFFFFFFFF,0x000000F8,0x8F000000,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x000000F0,
0x0F000000,0xFFFFFFFF,0xFFFFFFFF,0x0000F0FF,0x00000000,0x00000000,0xFF000000,
0xFFFFFFFF,0x00F00F70,0xF0000000,0x0000000F,0x07F00F00,0xFFFFFFFF,0xFFFFFFFF,
0x000070FF,0xFF070000,0xFFFFFFFF,0xFFFFFFFF,0x000000F0,0x00000000,0x00000000,
0x0FF00F00,0xFFFFFFFF,0xFFFFFFFF,0x00000080,0x08000000,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0x000000F0,0x0F000000,0xFFFFFFFF,0xFFFFFFFF,0x0F00F0FF,0x00000000,
0x00000000,0xFF00000F,0xFFFFFFFF,0x00007F80,0xF0080000,0x0000800F,0x08F70000,
0xFFFFFFFF,0xFFFFFFFF,0x000000F7,0x7F000000,0xFFFFFFFF,0xFFFFFFFF,0x000000FF,
0x00000000,0x00000000,0x0FF00F00,0xFFFFFFFF,0xFFFFFFFF,0x00000000,0x00000000,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x000000F0,0x0F000000,0xFFFFFFFF,0xFFFFFFFF,
0x0F00F0FF,0x00000000,0x00000000,0xFF00000F,0xFFFFFFFF,0x0000F800,0x800F0000,
0x0000F008,0x008F0000,0xFFFFFFFF,0xFFFFFFFF,0x000000F8,0x8F000000,0xFFFFFFFF,
0xFFFFFFFF,0x000000FF,0x00000000,0x0000000F,0x0FF00F00,0xFFFFFFFF,0xF8FFFFFF,
0x0F000000,0x000000F0,0xFFFFFF8F,0xFFFFFFFF,0xFFFFFFFF,0x000000F0,0x0F000000,
0xFFFFFFFF,0xFFFFFFFF,0xFF00F0FF,0x000F0000,0x00000F00,0xFF00F00F,0xFFFFFFFF,
0x0000F000,0x008F0000,0x0000F800,0x000F0000,0xFFFFFFFF,0xFFFFFFFF,0x000000F0,
0x0F000000,0xFFFFFFFF,0xFFFFFFFF,0x0000F0FF,0x00000000,0x0000000F,0xFF00FF00,
0xFFFFFFFF,0xF0FFFFFF,0x0F000000,0x000000F0,0xFFFFFF0F,0xFFFFFFFF,0xFFFFFFFF,
0x000000F0,0x0F000000,0xFFFFFFFF,0xFFFFFFFF,0xFF0000FF,0x000F0000,0x00000F00,
0x0F00F00F,0xFFFFFFFF,0x0000F000,0x0FF80800,0x00808FF0,0x000F0000,0xFFFFFFFF,
0xFFFFFFFF,0x000000F0,0x0F000000,0xFFFFFFFF,0xFFFFFFFF,0x0000F0FF,0x00000000,
0x0000F000,0xFF00FF00,0xFFFFFFFF,0xF0FFFFFF,0xFF0F0000,0x0000F0FF,0xFFFFFF0F,
0xFFFFFFFF,0xFFFFFFFF,0x000000F0,0x0F000000,0xFFFFFFFF,0xFFFFFFFF,0xFF0F00FF,
0x00FF0000,0x00F00F00,0x0F00FF0F,0xFFFFFFFF,0x0000F700,0x07708F00,0x00F80770,
0x007F0000,0xFFFFFFFF,0xFFFFFFFF,0x000000F0,0x0F000000,0xFFFFFFFF,0xFFFFFFFF,
0x0F00FFFF,0x00000000,0x0000F000,0xFF0FF00F,0xFFFFFFFF,0xF8FFFFFF,0xFF0F0000,
0x0000F0FF,0xFFFFFF8F,0xFFFFFFFF,0xFFFFFFFF,0x000000F0,0x0F000000,0xFFFFFFFF,
0xFFFFFFFF,0xFF0F00FF,0x00FF0000,0x00F00F00,0x0F00FF0F,0xFFFFFFFF,0x00708F80,
0x7000F78F,0xF87F0007,0x08F80700,0xFFFFFFFF,0xFFFFFFFF,0x000000F0,0x0F000000,
0xFFFFFFFF,0xFFFFFFFF,0x0F00FFFF,0x000000F0,0x00000000,0xFF0FF00F,0xFFFFFFFF,
0xF7FFFFFF,0x0F000000,0x000000F0,0xFFFFFF7F,0xFFFFFFFF,0xFFFFFFFF,0x00000070,
0x07000000,0xFFFFFFFF,0xFFFFFFFF,0xFFFF00FF,0x00FF0000,0x00F00F00,0x0FF0FF0F,
0xFFFFFFFF,0xFFFF0870,0xF00080FF,0xFF08000F,0x0780FFFF,0xFFFFFFFF,0xFFFFFFFF,
0x000000F8,0x8F000000,0xFFFFFFFF,0xFFFFFFFF,0x0F00FFFF,0x000000FF,0x00000000,
0xFFFF00FF,0xFFFFFFFF,0xFFFFFFFF,0x0F000080,0x080000F0,0xFFFFFFFF,0xFFFFFFFF,
0xF7FFFFFF,0xFFFF0F00,0x00F0FFFF,0xFFFFFF7F,0xFFFFFFFF,0xFFFF00FF,0x00FF0F00,
0x00FF0F00,0x0FF0FF0F,0xFFFFFFFF,0x000000F7,0xF0000000,0x0000000F,0x7F000000,
0xFFFFFFFF,0xFFFFFFFF,0x000000F7,0x7F000000,0xFFFFFFFF,0xFFFFFFFF,0x00F0FFFF,
0x0000F0FF,0x0F000000,0xFFFF00F0,0xFFFFFFFF,0xFFFFFFFF,0x000000F8,0x8F000000,
0xFFFFFFFF,0xFFFFFFFF,0x70FFFFFF,0x00000000,0x00000000,0xFFFFFF07,0xFFFFFFFF,
0xFFFF0FF0,0xF0FF0F00,0x00FFFF00,0x00FFFF0F,0xFFFFFFFF,0x0000F7FF,0x70007F00,
0x00F70007,0xFF7F0000,0xFFFFFFFF,0xFFFFFFFF,0x000070FF,0xFF070000,0xFFFFFFFF,
0xFFFFFFFF,0x00F0FFFF,0x00000000,0x0F000000,0xFFFF0F00,0xFFFFFFFF,0xFFFFFFFF,
0x000080FF,0xFF080000,0xFFFFFFFF,0xFFFFFFFF,0x00F7FFFF,0x00000000,0x00000000,
0xFFFF7F00,0xFFFFFFFF,0xFFFF0F00,0xF0FF0F00,0x00FFFF00,0x00FFFF0F,0xFFFFFF0F,
0xFFFFFFFF,0x0700FFFF,0xFFFF0070,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0070FFFF,
0xFFFF0700,0xFFFFFFFF,0xFFFFFFFF,0x00FFFFFF,0x00000000,0xF00F0000,0xFFFFFF00,
0xFFFFFFFF,0xFFFFFFFF,0x0000F8FF,0xFF8F0000,0xFFFFFFFF,0xFFFFFFFF,0x0FF0FFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFF0FF0,0xF0FFFFFF,0xFFFF0000,0xF0FFFF00,0xF0FFFF00,
0x00F0FF0F,0xFFFFFF00,0xFFFFFFFF,0x0070FFFF,0xFFFF0700,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0x0080FFFF,0xFFFF0800,0xFFFFFFFF,0xFFFFFFFF,0x00FFFFFF,0x0000000F,
0x00FF0000,0xFFFFFF0F,0xFFFFFFFF,0xFFFFFFFF,0x0080FFFF,0xFFFF0800,0xFFFFFFFF,
0xFFFFFFFF,0x00F0FFFF,0x00000000,0x00000000,0xFFFF0F00,0xF0FFFFFF,0xFFFF0000,
0xF0FFFF00,0xF0FFFF00,0x00F0FF0F,0xFFFFFF00,0xFFFFFFFF,0x00F7FFFF,0xFFFF7F00,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0000FFFF,0xFFFF0000,0xFFFFFFFF,0xFFFFFFFF,
0xF0FFFFFF,0x0000FF00,0x0F00FF0F,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x80FFFFFF,
0xFFFFFF08,0xFFFFFFFF,0xFFFFFFFF,0x00F0FFFF,0x00000000,0x00000000,0xFFFF0F00,
0xF0FFFFFF,0xF0FF0000,0xF0FFFF00,0xF0FFFF00,0x00F0FF00,0xFFFFFF00,0xFFFFFFFF,
0xF0FFFFFF,0xFFFFFF0F,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0000FFFF,0xFFFF0000,
0xFFFFFFFF,0xFFFFFFFF,0xF0FFFFFF,0x00000000,0xFF0F0000,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0x00F8FFFF,0xFFFF8F00,0xFFFFFFFF,0xFFFFFFFF,0x00F0FFFF,0x00000000,
0x00000000,0xFFFF0F00,0xFFFFFFFF,0x00FF0F00,0xF0FF0F00,0x00FFFF00,0x00FF0F00,
0xFFFFFF0F,0xFFFFFFFF,0xF0FFFFFF,0xFFFFFF0F,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0x0080FFFF,0xFFFF0800,0xFFFFFFFF,0xFFFFFFFF,0xF0FFFFFF,0x00000000,0xFFFFFF0F,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x00F0FFFF,0xFFFF0F00,0xFFFFFFFF,0xFFFFFFFF,
0x00F0FFFF,0x00000000,0x00000000,0xFFFF0F00,0xFFFFFFFF,0x00FFFFFF,0x00FF0F00,
0x00FF0F00,0xFFFF0F00,0xFFFFFFFF,0xFFFFFFFF,0xF0FFFFFF,0xFFFFFF0F,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0x0070FFFF,0xFFFF0700,0xFFFFFFFF,0xFFFFFFFF,0xF0FFFFFF,
0x00F00F00,0xFFFFFF0F,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x00F0FFFF,0xFFFF0F00,
0xFFFFFFFF,0xFFFFFFFF,0x00F0FFFF,0x00F0FF00,0x00FF0F00,0xFFFF0F00,0xFFFFFFFF,
0x00FFFFFF,0x00FF0F00,0x00FF0F00,0xFFFF0F00,0xFFFFFFFF,0xFFFFFFFF,0x00F0FFFF,
0xFFFF0F00,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x80F7FFFF,0xFFFF7F08,0xFFFFFFFF,
0xFFFFFFFF,0x00FFFFFF,0x00F0FF0F,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0x00F8FFFF,0xFFFF8F00,0xFFFFFFFF,0xFFFFFFFF,0x00F0FFFF,0x00F0FF00,0x00FF0F00,
0xFFFF0F00,0xFFFFFFFF,0xF0FFFFFF,0x00FFFF00,0xF0FF0F00,0xFFFFFF00,0xFFFFFFFF,
0xFFFFFFFF,0x00F0FFFF,0xFFFF0F00,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x00FFFFFF,0x0FFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0x80FFFFFF,0xFFFFFF08,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xF0FFFFFF,0xFFFFFF00,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xF0FFFFFF,0xFFFFFF0F,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xF0FFFFFF,0xFFFFFF0F,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x888888F8,0x88888888,0x88888888,
0xFFFFFF8F,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x888888FF,0x8F888888,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x8888F8FF,0xFF8F8888,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x00000080,
0x00000000,0x00000000,0xFFFFFF08,0x888808F8,0xFF888888,0x888888FF,0x8F808888,
0xFFFFFFFF,0x8888F8FF,0x88888888,0x88888888,0xFF8F8888,0xFFFFFFFF,0x88FFFFFF,
0x00000088,0x08000000,0xFFFF8F88,0xFFFFFFFF,0xF8FFFFFF,0x00008088,0x88080000,
0xFFFFFF8F,0xFFFFFFFF,0x8888FFFF,0x88888888,0x88888888,0xFFFF8888,0xFFFFFFFF,
0xFFFFFFFF,0x00000080,0x00000000,0x00000000,0xFFFFFF08,0x00000080,0x88000000,
0x00000088,0x08000000,0xFFFFFFFF,0x000080FF,0x00000000,0x00000000,0xFF080000,
0xFFFFFFFF,0x00F8FFFF,0x00000000,0x00000000,0xFFFF0800,0xFFFFFFFF,0x80F8FFFF,
0x00000000,0x00000000,0xFFFF8F08,0xFFFFFFFF,0x0000F8FF,0x00000000,0x00000000,
0xFF8F0000,0xFFFFFFFF,0xFFFFFFFF,0x00000080,0x00000000,0x00000000,0xFFFFFF08,
0x00000080,0x00000000,0x00000000,0x08000000,0xFFFFFFFF,0x000080FF,0x00000000,
0x00000000,0xFF080000,0xFFFFFFFF,0x0080FFFF,0x00000000,0x00000000,0xFF8F0000,
0xFFFFFFFF,0x0080FFFF,0x00000000,0x00000000,0xFFFF0800,0xFFFFFFFF,0x0000F8FF,
0x00000000,0x00000000,0xFF8F0000,0xFFFFFFFF,0xFFFFFFFF,0x000000F8,0x00000000,
0x00000000,0xF8FFFF08,0x00000000,0x00000000,0x00000000,0x00000000,0xFFFFFF8F,
0x000080FF,0x00000000,0x00000000,0xFF080000,0xFFFFFFFF,0x0080FFFF,0x00000000,
0x00000000,0xFF8F0000,0xFFFFFFFF,0x0000F8FF,0x00000000,0x00000000,0xFF8F0000,
0xFFFFFFFF,0x0000F8FF,0x00000000,0x00000000,0xFF8F0000,0xFFFFFFFF,0xFFFFFFFF,
0x000000F8,0x00000000,0x00000000,0xFFFFFF08,0x00000080,0x00000000,0x00000000,
0x08000000,0xFFFFFFFF,0x000080FF,0x00000000,0x00000000,0xFF080000,0xFFFFFFFF,
0x00F8FFFF,0x00000000,0x00000000,0xFFFF0800,0xFFFFFFFF,0x0080FFFF,0x00000000,
0x00000000,0xFFFF0800,0xFFFFFFFF,0x0000F8FF,0x00000000,0x00000000,0xFF8F0000,
0xFFFFFFFF,0xFFFFFFFF,0x000080FF,0x00000000,0x00000000,0xFFFFFF08,0x888888F8,
0x00008888,0x88880000,0x8F888888,0xFFFFFFFF,0x000080FF,0x00000000,0x00000000,
0xFF080000,0xFFFFFFFF,0x00F8FFFF,0x00000000,0x00000000,0xFFFF0800,0xFFFFFFFF,
0x00F8FFFF,0x00000000,0x00000000,0xFFFF8F00,0xFFFFFFFF,0x0000F8FF,0x00000000,
0x00000000,0xFF8F0000,0xFFFFFFFF,0x8FF8FFFF,0x000080FF,0x00000000,0x00000000,
0xFFFFFF08,0xFFFFFFFF,0x008088FF,0xFF880800,0xFFFFFFFF,0xFFFFFFFF,0x0088F8FF,
0x00000000,0x00000000,0xFF8F8800,0xFFFFFFFF,0x00F8FFFF,0x00000000,0x00000000,
0xFFFF0800,0xFFFFFFFF,0x00F8FFFF,0x00000000,0x00000000,0xFFFF8F00,0xFFFFFFFF,
0x0000F8FF,0x00000000,0x00000000,0xFF8F0000,0xFFFFFFFF,0x088088FF,0x0000F8FF,
0x00000000,0x00000000,0xFFFFFF08,0xFFFFFFFF,0x000000F8,0x88000000,0xFFFFFFFF,
0xFFFFFFFF,0x00F8FFFF,0x00000000,0x00000000,0xFFFF8F00,0xFFFFFFFF,0x00F8FFFF,
0x00000000,0x00000000,0xFFFF0800,0xFFFFFFFF,0x00F8FFFF,0x00000000,0x00000000,
0xFFFF8F00,0xFFFFFFFF,0x0080F8FF,0x00000000,0x00000000,0xFF8F0800,0xFFFFFFFF,
0x000000F8,0x0080FF8F,0x00000000,0x00000000,0xFFFFFF08,0xF8FFFFFF,0x00000080,
0x00000000,0xFFFFFF8F,0xFFFFFFFF,0x00F8FFFF,0x00000000,0x00000000,0xFFFF8F00,
0xFFFFFFFF,0x00F8FFFF,0x00000000,0x00000000,0xFFFF0800,0xFFFFFFFF,0x0080FFFF,
0x00000000,0x00000000,0xFFFF0800,0xFFFFFFFF,0x0080FFFF,0x00000000,0x00000000,
0xFFFF0800,0xFFFFFFFF,0x00000080,0x00F8FF08,0x00000000,0x00000000,0xFFFFFF08,
0xFFFFFFFF,0x00000080,0x08000000,0xFFFFFFFF,0xFFFFFFFF,0x00F8FFFF,0x00000000,
0x00000000,0xFFFF8F00,0xFFFFFFFF,0x0080FFFF,0x00000000,0x00000000,0xFF8F0000,
0xFFFFFFFF,0x0080FFFF,0x00000000,0x00000000,0xFFFF0800,0xFFFFFFFF,0x0088FFFF,
0x00000000,0x00000000,0xFFFF8800,0xF8FFFFFF,0x00000000,0x80FFFF08,0x00000000,
0x00000000,0xFFFFFF8F,0xFFFFFFFF,0x00000080,0x08000000,0xFFFFFFFF,0xFFFFFFFF,
0x80FFFFFF,0x00000000,0x00000000,0xFFFFFF08,0xFFFFFFFF,0x0080FFFF,0x00000000,
0x00000000,0xFF8F0000,0xFFFFFFFF,0x0000F8FF,0x00000000,0x00000000,0xFF8F0000,
0xFFFFFFFF,0x00F8FFFF,0x00000000,0x00000000,0xFFFF8F00,0xF8FFFFFF,0x00000000,
0x80FF8800,0x00000000,0x00000000,0xFFFFFF8F,0xFFFFFFFF,0x000000F8,0x8F000000,
0xFFFFFFFF,0xFFFFFFFF,0xF8FFFFFF,0x00000000,0x00000000,0xFFFFFF8F,0xFFFFFFFF,
0x0000F8FF,0x00000000,0x00000000,0xFF080000,0xFFFFFFFF,0x000080FF,0x00000000,
0x00000000,0xFF080000,0xFFFFFFFF,0x80F8FFFF,0x00000000,0x00000000,0xFFFF8F08,
0xF8FFFFFF,0x00000000,0xF8880000,0x00000000,0x00000000,0xFFFFFF8F,0xFFFFFFFF,
0x000000F8,0x8F000000,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x00000080,0x08000000,
0xFFFFFFFF,0xFFFFFFFF,0x0000F8FF,0x00000000,0x00000000,0xFF080000,0xFFFFFFFF,
0x000000F8,0x00000000,0x00000000,0x8F000000,0xFFFFFFFF,0x88FFFFFF,0x00000000,
0x00000000,0xFFFFFF88,0xF8FFFFFF,0x00000000,0x88000000,0x00000000,0x00000000,
0xFFFFFF8F,0xFFFFFFFF,0x000000F8,0x8F000000,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0x00000080,0x08000000,0xFFFFFFFF,0xFFFFFFFF,0x000080FF,0x00000000,0x00000000,
0x8F000000,0xFFFFFFFF,0x00000080,0x00000000,0x00000000,0x08000000,0xFFFFFFFF,
0xF8FFFFFF,0x00000080,0x08000000,0xFFFFFF8F,0xFFFFFFFF,0x00000080,0x00000000,
0x00000080,0x00000000,0xFFFFFF8F,0xFFFFFFFF,0x00000080,0x08000000,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0x00000080,0x08000000,0xFFFFFFFF,0xFFFFFFFF,0x000080FF,
0x00000000,0x00000000,0x8F000000,0xFFFFFFFF,0x00000080,0x00000000,0x00000000,
0x08000000,0xFFFFFFFF,0xFFFFFFFF,0x00008088,0x88080000,0xFFFFFFFF,0xFFFFFFFF,
0x00000080,0x00000000,0x00000000,0x08000000,0xFFFFFFFF,0xF8FFFFFF,0x00000000,
0x00000000,0xFFFFFF8F,0xFFFFFFFF,0xFFFFFFFF,0x00000080,0x08000000,0xFFFFFFFF,
0xFFFFFFFF,0x080080FF,0x00000000,0x00000000,0x8F000008,0xF8FFFFFF,0x00000000,
0x00000000,0x00000000,0x00000000,0xFFFFFF8F,0xFFFFFFFF,0x000000F8,0x8F000000,
0xFFFFFFFF,0xFFFFFFFF,0x000000F8,0x00000000,0x00000000,0x08000000,0xFFFFFFFF,
0xF8FFFFFF,0x00000000,0x00000000,0xFFFFFF8F,0xFFFFFFFF,0xFFFFFFFF,0x00000080,
0x08000000,0xFFFFFFFF,0xFFFFFFFF,0x080080FF,0x00000000,0x00000000,0x8F000008,
0xF8FFFFFF,0x00000000,0x00000000,0x00000000,0x00000000,0xFFFFFF8F,0xFFFFFFFF,
0x00000088,0x88000000,0xFFFFFFFF,0xFFFFFFFF,0x000000F8,0x00000000,0x00000000,
0x08000000,0xFFFFFFFF,0x80FFFFFF,0x00000000,0x00000000,0xFFFFFF08,0xFFFFFFFF,
0xFFFFFFFF,0x00000080,0x08000000,0xFFFFFFFF,0xFFFFFFFF,0x880080FF,0x00080000,
0x00000800,0x8F008008,0xF8FFFFFF,0x00000000,0x00000000,0x00000000,0x00000000,
0xFFFFFF8F,0xFFFFFFFF,0x00000080,0x08000000,0xFFFFFFFF,0xFFFFFFFF,0x000080FF,
0x00000000,0x00000000,0x8F000000,0xFFFFFFFF,0x80FFFFFF,0x00000000,0x00000000,
0xFFFFFF08,0xFFFFFFFF,0xFFFFFFFF,0x00000080,0x08000000,0xFFFFFFFF,0xFFFFFFFF,
0x880000F8,0x00080000,0x00000800,0x08008008,0xF8FFFFFF,0x00000000,0x00000000,
0x00000000,0x00000000,0xFFFFFF8F,0xFFFFFFFF,0x00000080,0x08000000,0xFFFFFFFF,
0xFFFFFFFF,0x000080FF,0x00000000,0x00000000,0x8F000000,0xFFFFFFFF,0x80FFFFFF,
0x00000000,0x00000000,0xFFFFFF08,0xFFFFFFFF,0xFFFFFFFF,0x00000080,0x08000000,
0xFFFFFFFF,0xFFFFFFFF,0xF80800F8,0x00880000,0x00800800,0x0800F808,0xF8FFFFFF,
0x00000000,0x00000000,0x00000000,0x00000000,0xFFFFFF8F,0xFFFFFFFF,0x00000080,
0x08000000,0xFFFFFFFF,0xFFFFFFFF,0x0000F8FF,0x00000000,0x00000000,0xFF080000,
0xFFFFFFFF,0x80FFFFFF,0x00000000,0x00000000,0xFFFFFF08,0xFFFFFFFF,0xFFFFFFFF,
0x00000080,0x08000000,0xFFFFFFFF,0xFFFFFFFF,0xF80800F8,0x00880000,0x00800800,
0x0800F808,0xFFFFFFFF,0x00000080,0x00000000,0x00000000,0x08000000,0xFFFFFFFF,
0xFFFFFFFF,0x00000080,0x08000000,0xFFFFFFFF,0xFFFFFFFF,0x0000F8FF,0x00000000,
0x00000000,0xFF080000,0xFFFFFFFF,0xF8FFFFFF,0x00000000,0x00000000,0xFFFFFF8F,
0xFFFFFFFF,0xFFFFFFFF,0x00000080,0x08000000,0xFFFFFFFF,0xFFFFFFFF,0xF88F00F8,
0x00880000,0x00800800,0x0880FF08,0xFFFFFFFF,0x00000080,0x00000000,0x00000000,
0x08000000,0xFFFFFFFF,0xFFFFFFFF,0x00000088,0x88000000,0xFFFFFFFF,0xFFFFFFFF,
0x0000F8FF,0x00000000,0x00000000,0xFF8F0000,0xFFFFFFFF,0xF8FFFFFF,0x00000000,
0x00000000,0xFFFFFF8F,0xFFFFFFFF,0xF8FFFFFF,0x00000000,0x00000000,0xFFFFFF8F,
0xFFFFFFFF,0xF88F00F8,0x00F80800,0x00F80800,0x0880FF08,0xFFFFFFFF,0x000000F8,
0x00000000,0x00000000,0x8F000000,0xFFFFFFFF,0xFFFFFFFF,0x000000F8,0x8F000000,
0xFFFFFFFF,0xFFFFFFFF,0x0080FFFF,0x00000000,0x00000000,0xFF8F0000,0xFFFFFFFF,
0xFFFFFFFF,0x00000080,0x08000000,0xFFFFFFFF,0xFFFFFFFF,0x80FFFFFF,0x00000000,
0x00000000,0xFFFFFF08,0xFFFFFFFF,0xF8FF0880,0x80FF0800,0x00F88F00,0x00F8FF08,
0xFFFFFF8F,0x000088FF,0x00008800,0x00880000,0xFF880000,0xFFFFFFFF,0xFFFFFFFF,
0x000080F8,0x8F080000,0xFFFFFFFF,0xFFFFFFFF,0x0080FFFF,0x00000000,0x00000000,
0xFFFF0800,0xFFFFFFFF,0xFFFFFFFF,0x000000F8,0x8F000000,0xFFFFFFFF,0xFFFFFFFF,
0x00F8FFFF,0x00000000,0x00000000,0xFFFF8F00,0xF8FFFFFF,0xF8FF0800,0x80FF0800,
0x00F88F00,0x00F8FF08,0xFFFFFF08,0x8888FFFF,0x0000F888,0x888F0000,0xFFFF8888,
0xFFFFFFFF,0xFFFFFFFF,0x008088FF,0xFF880800,0xFFFFFFFF,0xFFFFFFFF,0x00F8FFFF,
0x00000000,0x00000000,0xFFFF8F00,0xFFFFFFFF,0xFFFFFFFF,0x000080FF,0xFF080000,
0xFFFFFFFF,0xFFFFFFFF,0x0080FFFF,0x00000000,0x00000000,0xFFFF0800,0x80FFFFFF,
0xF88F0000,0x80FF8F00,0x80FF8F00,0x0080FF08,0xFFFF8F00,0xFFFFFFFF,0x0080FFFF,
0xFFFF0800,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0000F8FF,0xFF8F0000,0xFFFFFFFF,
0xFFFFFFFF,0x00F8FFFF,0x00000000,0x00000000,0xFFFFFF08,0xFFFFFFFF,0xFFFFFFFF,
0x0000F8FF,0xFF8F0000,0xFFFFFFFF,0xFFFFFFFF,0x0080FFFF,0x00000000,0x00000000,
0xFFFF0800,0x80FFFFFF,0xF88F0000,0x80FF8F00,0x80FF8F00,0x0080FF08,0xFFFF8F00,
0xFFFFFFFF,0x00F8FFFF,0xFFFF8F00,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0000F8FF,
0xFF8F0000,0xFFFFFFFF,0xFFFFFFFF,0x80FFFFFF,0x00000000,0x08000000,0xFFFFFF8F,
0xFFFFFFFF,0xFFFFFFFF,0x0088FFFF,0xFFFF8800,0xFFFFFFFF,0xFFFFFFFF,0x0080FFFF,
0x00000000,0x00000000,0xFFFF0800,0x80FFFFFF,0x808F0000,0x80FF8F00,0x80FF8F00,
0x00808F00,0xFFFF8F00,0xFFFFFFFF,0x80FFFFFF,0xFFFFFF08,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0x0000F8FF,0xFF8F0000,0xFFFFFFFF,0xFFFFFFFF,0x80FFFFFF,0x00000000,
0x8F080000,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0080FFFF,0xFFFF0800,0xFFFFFFFF,
0xFFFFFFFF,0x0080FFFF,0x00000000,0x00000000,0xFFFF0800,0xF8FFFFFF,0x00F80800,
0x80FF0800,0x00F88F00,0x00F80800,0xFFFFFF08,0xFFFFFFFF,0x80FFFFFF,0xFFFFFF08,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0000F8FF,0xFF8F0000,0xFFFFFFFF,0xFFFFFFFF,
0x80FFFFFF,0x00000000,0xFF8F8808,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0080FFFF,
0xFFFF0800,0xFFFFFFFF,0xFFFFFFFF,0x0080FFFF,0x00000000,0x00000000,0xFFFF0800,
0xFFFFFFFF,0x00F88F88,0x00F80800,0x00F80800,0x88FF0800,0xFFFFFF8F,0xFFFFFFFF,
0x80F8FFFF,0xFFFF8808,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0080F8FF,0xFF8F0800,
0xFFFFFFFF,0xFFFFFFFF,0x80FFFFFF,0x00800800,0xFFFFFF08,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0x0080FFFF,0xFFFF0800,0xFFFFFFFF,0xFFFFFFFF,0x0080FFFF,0x00808800,
0x00880800,0xFFFF0800,0xFFFFFFFF,0x00F8FFFF,0x00F80800,0x00F80800,0xFFFF0800,
0xFFFFFFFF,0xFFFFFFFF,0x0080FFFF,0xFFFF0800,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0x0088FFFF,0xFFFF8800,0xFFFFFFFF,0xFFFFFFFF,0x00F8FFFF,0x00808F08,0xFFFFFF8F,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0080FFFF,0xFFFF0800,0xFFFFFFFF,0xFFFFFFFF,
0x0080FFFF,0x00808F00,0x00F80800,0xFFFF0800,0xFFFFFFFF,0x80FFFFFF,0x00F88F00,
0x80FF0800,0xFFFF8F00,0xFFFFFFFF,0xFFFFFFFF,0x0080FFFF,0xFFFF0800,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0x88F8FFFF,0xFFFF8F88,0xFFFFFFFF,0xFFFFFFFF,0x00F8FFFF,
0x08F8FF8F,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x00F8FFFF,0xFFFF8F00,
0xFFFFFFFF,0xFFFFFFFF,0x88F8FFFF,0x88F8FF88,0x88F88F88,0xFFFF8F88,0xFFFFFFFF,
0xF8FFFFFF,0x80FFFF88,0xF8FF8F00,0xFFFFFF88,0xFFFFFFFF,0xFFFFFFFF,0x80F8FFFF,
0xFFFF8808,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0x88F8FFFF,0x8FFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0x88FFFFFF,0xFFFFFF88,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xF8FFFFFF,0xFFFFFF88,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0x80FFFFFF,0xFFFFFF08,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x88FFFFFF,0xFFFFFF88,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0x000000F0,0x00000000,0x00000000,0xFFFFFF0F,0xFFFF0FFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFF0FFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x000000FF,0x0F000000,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0x00008077,0x77080000,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x000000F0,0x00000000,0x00000000,
0xFFFFFF0F,0x000000F0,0xFF070000,0x000070FF,0x0F000000,0xFFFFFFFF,0x0000F0FF,
0x00000000,0x00000000,0xFF0F0000,0xFFFFFFFF,0x00FFFFFF,0x00000000,0x00000000,
0xFFFF0F00,0xFFFFFFFF,0x80F7FFFF,0x00000000,0x00000000,0xFFFF7F08,0xFFFFFFFF,
0x0000FFFF,0x00000000,0x00000000,0xFFFF0000,0xFFFFFFFF,0xFFFFFFFF,0xFFFF0FF0,
0xFFFFFFFF,0xF0FFFFFF,0xFFFFFF0F,0x77778770,0x87707777,0x77770778,0x07787777,
0xFFFFFFFF,0x0000F0FF,0x00000000,0x00000000,0xFF0F0000,0xFFFFFFFF,0x00F0FFFF,
0xFFFFFF00,0xF0FFFFFF,0xFFFF0000,0xFFFFFFFF,0x0070FFFF,0xFFFF8F00,0x00F8FFFF,
0xFFFF0700,0xFFFFFFFF,0x0000FFFF,0x00000000,0x00000000,0xFFFF0000,0xFFFFFFFF,
0xFFFFFFFF,0xFFFF00FF,0xFFFFFFFF,0xF0FFFFFF,0xFFFFFF0F,0x77777780,0x08F77777,
0x77777F80,0x08777777,0xFFFFFFFF,0xFF0FF0FF,0xFFFFFFFF,0xFFFFFFFF,0xFF0FF0FF,
0xFFFFFFFF,0x00F0FFFF,0xFFFFFF00,0xF0FFFFFF,0xFFFF0000,0xFFFFFFFF,0x0000FFFF,
0xFFFF7F88,0x88F7FFFF,0xFF7F0000,0xFFFFFFFF,0xFF00FFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFF00FF,0xFFFFFFFF,0xFFFFFFFF,0xFFFF00FF,0xFFFFFFFF,0xF0FFFFFF,0xFFFFFF0F,
0x000000F0,0x700F0000,0x0000F007,0x0F000000,0xFFFFFFFF,0x0000F0FF,0x00000000,
0x00000000,0xFF0F0000,0xFFFFFFFF,0x00FFFFFF,0x00000000,0x00000000,0xFFFF0F00,
0xFFFFFFFF,0x0070FFFF,0x00000000,0x00000000,0xFFFF0700,0xFFFFFFFF,0x7F00FFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFF00F7,0xFFFFFFFF,0xFFFFFFFF,0xFF0FF0FF,0xFFFFFFFF,
0xF0FFFFFF,0xFFFFFF0F,0xFFFFFFFF,0xF000F7FF,0xFF7F000F,0xFFFFFFFF,0xFFFFFFFF,
0x0000F0FF,0x00000000,0x00000000,0xFF0F0000,0xFFFFFFFF,0x00FFFFFF,0x000000FF,
0x0F000000,0xFFFF0FF0,0xFFFFFFFF,0x00FFFFFF,0x000080FF,0xFF080000,0xFFFFFF00,
0xFFFFFFFF,0x8F00FFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFF00F8,0xFFFFFFFF,0xFFFFFFFF,
0xFF00F0FF,0xFFFFFFFF,0xF0FFFFFF,0xFFFFFF0F,0xFFFFFFFF,0x0078FFFF,0xFFFF8700,
0xFFFFFFFF,0xFFFFFFFF,0x00FFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFF00,0xFFFFFFFF,
0x00FFFFFF,0xFFFFFF00,0xF0FFFFFF,0xFFFF0F00,0xFFFFFFFF,0x00FFFFFF,0xFFFF7F08,
0x80F7FFFF,0xFFFFFF00,0xFFFFFFFF,0x0F80FFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFF08F0,
0xFFFFFFFF,0x0FF0FFFF,0x0F00FFFF,0xFFFFFFFF,0xF0FFFFFF,0xFFFFFF0F,0xFFFFFFFF,
0x000000F7,0x7F000000,0xFFFFFFFF,0xFFFFFFFF,0x00FFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFF00,0xFFFFFFFF,0x00FFFFFF,0x000000FF,0x0F000000,0xFFFF0FF0,0xFFFFFFFF,
0x00F8FFFF,0x00000078,0x87000000,0xFFFF8F00,0xFFFFFFFF,0x0770FFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFF0770,0xFFFFFFFF,0x000000FF,0x00F0FFFF,0xFFFFFFFF,0xF0FFFFFF,
0xFFFFFF0F,0xFFFFFFFF,0xFFFF0700,0x0070FFFF,0xFFFFFFFF,0xFFFFFFFF,0x00FFFFFF,
0x00000000,0x00000000,0xFFFFFF00,0xFFFFFFFF,0x00FFFFFF,0xFFFFFF00,0xF0FFFFFF,
0xFFFF0F00,0xFFFFFFFF,0x0FF0FFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFF0FF0,0xFFFFFFFF,
0x08F8FFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFF8F80,0xFFFFFFFF,0x000000F0,0x00FFFF0F,
0xFFFFFF0F,0xF0FFFFFF,0xFFFFFF0F,0xFFFFFFFF,0x00000070,0x07000000,0xFFFFFFFF,
0xFFFFFFFF,0x00FFFFFF,0x00000000,0x00000000,0xFFFFFF00,0xFFFFFFFF,0x00F0FFFF,
0x00000000,0x00000000,0xFFFF0000,0xFFFFFFFF,0x0080FFFF,0xFFFF7708,0x8077FFFF,
0xFFFF0800,0xFFFFFFFF,0x00F7FFFF,0xFFFFFF7F,0xF7FFFFFF,0xFFFF7F00,0xFFFFFFFF,
0xF0000F00,0xF0FFFF0F,0xFFFFFF0F,0x00FFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x000000F0,
0x0F000000,0xFFFFFFFF,0xFFFFFFFF,0x70FFFFFF,0xFFFFFF00,0x00FFFFFF,0xFFFFFF07,
0xFFFFFFFF,0x0FF0FFFF,0x000000F0,0x0F000000,0xFFFF00FF,0xFFFFFFFF,0x0000F7FF,
0x00000000,0x00000000,0xFF7F0000,0xFFFFFFFF,0x80FFFFFF,0xFFFFFF07,0x70FFFFFF,
0xFFFFFF08,0xFFFFFFFF,0xFFFFFF00,0xF0FFFF00,0xFFFFFF00,0x00FFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFF07F7,0x7F70FFFF,0xFFFFFFFF,0xFFFFFFFF,0xF7FFFFFF,0x00000000,
0x00000000,0xFFFFFF7F,0xFFFFFFFF,0x0F00FFFF,0xFFFFFFFF,0xFFFFFFFF,0xFF0F00FF,
0xFFFFFFFF,0x770070FF,0x00000078,0x87000000,0xFF070077,0xFFFFFFFF,0x70FFFFFF,
0xFFFF7F00,0x00F7FFFF,0xFFFFFF07,0xFFFFFFFF,0xFF0FF000,0xFFFF00F0,0xFFFFFF00,
0x00FFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFF00FF,0xFF00FFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0x00000070,0x07000000,0xFFFFFFFF,0xFFFFFFFF,0x0000FFFF,0xFFFFFF00,
0xF0FFFFFF,0xFF0F0000,0xFFFFFFFF,0xFF0700F7,0xF0FFFFFF,0xFFFFFF0F,0x7F0070FF,
0xFFFFFFFF,0xF7FFFFFF,0xFF7F0800,0x000078FF,0xFFFFFF7F,0xFFFFFFFF,0xFF0FF000,
0xFF0000FF,0xFFFFFF00,0x00FFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x000000F7,0x7F000000,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFF0FF0,0x0FF0FFFF,0xFFFFFFFF,0xFFFFFFFF,
0xF000F0FF,0x00000000,0x000000F0,0xFF00F000,0xFFFFFFFF,0xFF7F00F0,0xF0FFFFFF,
0xFFFFFF0F,0x0F00F7FF,0xFFFFFFFF,0xFFFFFFFF,0x7F000078,0x870000F7,0xFFFFFFFF,
0xFFFFFFFF,0xFFFF0FF0,0x0000FFFF,0xFFFF0FF0,0x00FFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0x000000F8,0x8F000000,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFF0FF0,0x0FF0FFFF,
0xFFFFFFFF,0xFFFFFFFF,0x000FF0FF,0x0000000F,0x0F000000,0xFF000F00,0xFFFFFFFF,
0xFFFF0780,0x70FFFFFF,0xFFFFFF07,0x0870FFFF,0xFFFFFFFF,0xFFFFFFFF,0x070070FF,
0xFF070070,0xFFFFFFFF,0xFFFFFFFF,0xFFFF0FF0,0x00FFFFFF,0xFFFF0F00,0x0FF0FFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFF8F80,0x08F8FFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFF0FF0,0x0FF0FFFF,0xFFFFFFFF,0xFFFFFFFF,0x000FF0FF,0x0F00FF00,0xF00F000F,
0xFF000F00,0xFFFFFFFF,0xFFFF8F00,0x80FFFFFF,0xFFFFFF08,0x00F8FFFF,0xFFFFFFFF,
0xFFFFFFFF,0x7F0000F7,0x7F0000F7,0xFFFFFFFF,0xFFFFFFFF,0xFFFF00FF,0xFFFFFFFF,
0xFFFF0F00,0x0FF0FFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFF08,0x80FFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFF0FF0,0x0FF0FFFF,0xFFFFFFFF,0xFFFFFFFF,0x0F00F0FF,
0x0F00FF00,0xF00F00FF,0xFF00000F,0xFFFFFFFF,0xFFFF7F00,0x00FFFFFF,0xFFFFFF00,
0x00F7FFFF,0xFFFFFFFF,0xFFFFFFFF,0xFF7F00F8,0x8F00F7FF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFF00FF,0xFFFFFFFF,0xFFFF0FF0,0x0F00FFFF,0xFFFFFFFF,0xF8FFFFFF,0xF0FFFF07,
0x70FFFF0F,0xFFFFFF8F,0xFFFFFFFF,0xFFFFFFFF,0xFFFF0FF0,0x0FF0FFFF,0xFFFFFFFF,
0xFFFFFFFF,0x0F00F0FF,0x000FF000,0xF0000FF0,0xFF00000F,0xFFFFFFFF,0xFFFFFF00,
0x00F8FFFF,0xFFFF8F00,0x00FFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFF08F0,0x0F80FFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFF0FF0FF,0xFFFFFFFF,0xFFFF0FF0,0xFF00FFFF,0xFFFFFFFF,
0xF0FFFFFF,0xF0FFFF0F,0xF0FFFF0F,0xFFFFFF0F,0xFFFFFFFF,0xFFFFFFFF,0xFFFF0FF0,
0x0FF0FFFF,0xFFFFFFFF,0xFFFFFFFF,0xFF0000FF,0x000FF000,0xF0000FF0,0x0F00F00F,
0xFFFFFFFF,0xFFFFFF00,0x07F0FFFF,0xFFFF0F70,0x00FFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFF0FF0,0x0FF0FFFF,0xFFFFFFFF,0xFFFFFFFF,0xFF0FF0FF,0xFFFFFFFF,0xFFFF00FF,
0xFF00F0FF,0xFFFFFFFF,0xF0FFFFFF,0x00F0FF0F,0xF0FF0F00,0xFFFFFF0F,0xFFFFFFFF,
0xFFFFFFFF,0xFFFF0FF0,0x0FF0FFFF,0xFFFFFFFF,0xFFFFFFFF,0xFF0000FF,0x000FF000,
0xF0000FF0,0x0F00F00F,0xFFFFFFFF,0xFFFF7F00,0x8F70FFFF,0xFFFF07F8,0x00F7FFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFF0FF0,0x0FF0FFFF,0xFFFFFFFF,0xFFFFFFFF,0xF000FFFF,
0xFFFFFFFF,0xFFFF00FF,0xFF0FF0FF,0xFFFFFFFF,0xF8FFFFFF,0x00F0FF08,0x80FF0F00,
0xFFFFFF8F,0xFFFFFFFF,0xFFFFFFFF,0xFFFF0FF0,0x0FF0FFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFF0F00FF,0x00FF0000,0x00F00FF0,0x0F00FF0F,0xFFFFFFFF,0xFFFF0F80,0x7F00F7FF,
0xFF7F00F7,0x08F0FFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFF08F0,0x0F80FFFF,0xFFFFFFFF,
0xFFFFFFFF,0xF000FFFF,0xFFFFFF0F,0xFFFFFFFF,0xFF0F00FF,0xFFFFFFFF,0xF7FFFFFF,
0xF0FFFF00,0x00FFFF0F,0xFFFFFF7F,0xFFFFFFFF,0xFFFFFFFF,0xFFFF0F70,0x07F0FFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFF0F00FF,0x00FF0000,0x00F00FF0,0x0F00FF0F,0xFFFFFFFF,
0xFF7F00F0,0xFF0080F7,0x870000FF,0x0F00F7FF,0xFFFFFFFF,0xFFFFFFFF,0xFF8F00F8,
0x8F00F8FF,0xFFFFFFFF,0xFFFFFFFF,0xF000FFFF,0xFFFFFF00,0xFFFFFFFF,0xFFFF00FF,
0xFFFFFFFF,0xFFFFFFFF,0xF0FF8F80,0x08F8FF0F,0xFFFFFFFF,0xFFFFFFFF,0xF7FFFFFF,
0x00000000,0x00000000,0xFFFFFF7F,0xFFFFFFFF,0xFFFF00FF,0x00FF0000,0x00F00FF0,
0x0FF0FF0F,0xFFFFFFFF,0x000000F7,0xFF000000,0x000000FF,0x7F000000,0xFFFFFFFF,
0xFFFFFFFF,0x7F0000F7,0xFF0000FF,0xFFFFFFFF,0xFFFFFFFF,0x0FF0FFFF,0xFFFF0F00,
0xFFFFFFFF,0xFFFF00F0,0xFFFFFFFF,0xFFFFFFFF,0xFFFF08F8,0x8F80FFFF,0xFFFFFFFF,
0xFFFFFFFF,0x70FFFFFF,0x00000000,0x00000000,0xFFFFFF07,0xFFFFFFFF,0xFFFF00F0,
0xF0FF0F00,0x00FFFF00,0x00F0FF0F,0xFFFFFFFF,0x0000F8FF,0x7F00F700,0x007F00F7,
0xFF8F0000,0xFFFFFFFF,0xFFFFFFFF,0x0F0070FF,0xFF0F00F0,0xFFFFFFFF,0xFFFFFFFF,
0x0FF0FFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFF0F00,0xFFFFFFFF,0xFFFFFFFF,0xFF8F80FF,
0xFF08F8FF,0xFFFFFFFF,0xFFFFFFFF,0x00F7FFFF,0xFFFFFF0F,0xF0FFFFFF,0xFFFF7F00,
0xFFFFFFFF,0xFFFF0F00,0xF0FF0F00,0x00FFFF00,0x00FFFF0F,0xFFFFFF0F,0xFFFFFFFF,
0x0700FFFF,0xFFFF0070,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0F70FFFF,0xFFFF07F0,
0xFFFFFFFF,0xFFFFFFFF,0x00FFFFFF,0xFFFF0FF0,0xF0FFFFFF,0xFFFFFF00,0xFFFFFFFF,
0xFFFFFFFF,0x7F00F8FF,0xFF8F00F7,0xFFFFFFFF,0xFFFFFFFF,0x00F0FFFF,0x00000000,
0x00000000,0xFFFF0F00,0xF0FFFFFF,0xFFFF0000,0xF0FF0F00,0x00FFFF00,0x00F0FF0F,
0xFFFFFF00,0xFFFFFFFF,0x0070FFFF,0xFFFF0700,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0x7F80FFFF,0xFFFF08F7,0xFFFFFFFF,0xFFFFFFFF,0x00FFFFFF,0xFFFF0F00,0x00F0FF00,
0xFFFFFF0F,0xFFFFFFFF,0xFFFFFFFF,0x0080FFFF,0xFFFF0800,0xFFFFFFFF,0xFFFFFFFF,
0x00F0FFFF,0x00000000,0x00000000,0xFFFF0F00,0xF0FFFFFF,0xFFFF000F,0xF0FFFF00,
0xF0FFFF00,0x0FF0FF0F,0xFFFFFF00,0xFFFFFFFF,0x00F7FFFF,0xFFFF7F00,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFF00FFFF,0xFFFF00FF,0xFFFFFFFF,0xFFFFFFFF,0xF0FFFFFF,
0xFF0F000F,0x0F000000,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x80FFFFFF,0xFFFFFF08,
0xFFFFFFFF,0xFFFFFFFF,0x0FF0FFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFF0FF0,0xF0FFFFFF,
0xF0FF0000,0xF0FFFF00,0xF0FFFF00,0x00F0FF00,0xFFFFFF00,0xFFFFFFFF,0x70FFFFFF,
0xFFFFFF07,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x7F00FFFF,0xFFFF00F7,0xFFFFFFFF,
0xFFFFFFFF,0xF0FFFFFF,0xFF00F00F,0xFF0F0000,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0x08F8FFFF,0xFFFF8F80,0xFFFFFFFF,0xFFFFFFFF,0x0FF0FFFF,0x0F000000,0x000000F0,
0xFFFF0FF0,0xFFFFFFFF,0x00FF0F00,0xF0FF0F00,0x00FFFF00,0x00FF0F00,0xFFFFFF0F,
0xFFFFFFFF,0xF0FFFFFF,0xFFFFFF0F,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0780FFFF,
0xFFFF0870,0xFFFFFFFF,0xFFFFFFFF,0xF0FFFFFF,0xF0000000,0xFFFFFF0F,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0x8FF0FFFF,0xFFFF0FF8,0xFFFFFFFF,0xFFFFFFFF,0x0FF0FFFF,
0x0F000000,0x000000F0,0xFFFF0FF0,0xFFFFFFFF,0x00FFFFFF,0x00FF0FF0,0x00FF0F00,
0xFFFF0FF0,0xFFFFFFFF,0xFFFFFFFF,0xF0FFFFFF,0xFFFFFF0F,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0x0070FFFF,0xFFFF0700,0xFFFFFFFF,0xFFFFFFFF,0xF0FFFFFF,0x00F00F00,
0xFFFFFF0F,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x8FF0FFFF,0xFFFF0FF8,0xFFFFFFFF,
0xFFFFFFFF,0x00F0FFFF,0x00F0FF00,0x00FF0F00,0xFFFF0F00,0xFFFFFFFF,0x00FFFFFF,
0x00FF0F00,0x00FF0FF0,0xFFFF0F00,0xFFFFFFFF,0xFFFFFFFF,0x00F0FFFF,0xFFFF0F00,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x80F7FFFF,0xFFFF7F08,0xFFFFFFFF,0xFFFFFFFF,
0x00FFFFFF,0x00F0FF0F,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x08F8FFFF,
0xFFFF8F80,0xFFFFFFFF,0xFFFFFFFF,0x00F0FFFF,0x00F0FF00,0x00FF0F00,0xFFFF0F00,
0xFFFFFFFF,0xF0FFFFFF,0x00FFFF00,0xF0FF0F00,0xFFFFFF00,0xFFFFFFFF,0xFFFFFFFF,
0x00F0FFFF,0xFFFF0F00,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0x00FFFFFF,0x0FFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0x80FFFFFF,0xFFFFFF08,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xF0FFFFFF,0xFFFFFF00,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xF0FFFFFF,0xFFFFFF0F,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xF0FFFFFF,0xFFFFFF0F,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0000FFFF};


unsigned long set64[3088]={
0x303E4D42,0x00000000,0x003E0000,0x00280000,0x01800000,0x01000000,0x00010000,
0x00000001,0x30000000,0x00000000,0x00000000,0x00020000,0x00020000,0x00000000,
0xFFFF0000,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0x3FFFFFFF,0xFFFFFFFF,0xFFFFFFFC,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFF03C0FF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x000000F0,
0x03FF3F00,0x07FC3FE0,0xFFFFFFC0,0xFFFFFFFF,0xFFFFFFFF,0xFF0080FF,0xFFFFFFFF,
0x1F0000F8,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x000000F0,0x00FE3F00,0x00E00700,
0xE0FF7F00,0x00000000,0xFFFFFF03,0x030000E0,0xFFFFFFFF,0x030000C0,0xFEFFFFFF,
0x00000000,0xFFFFFF3F,0x000000F0,0x00FE3F00,0x00C00300,0xE0FF7F00,0x00000000,
0xFEFFFF03,0x00000000,0xFEFFFF3F,0x00000000,0xFCFFFF7F,0x00000000,0xFFFFFF1F,
0x000000F0,0x00FC3F00,0x00800100,0xE0FF3F00,0x00000000,0xF8FFFF03,0x00000000,
0xF8FFFF0F,0x00000000,0xFCFFFF1F,0x00000000,0xFFFFFF1F,0x000000F0,0x00FC3F00,
0x00000000,0xE0FF3F00,0x00000000,0xFCFFFF03,0x00000000,0xFCFFFF1F,0x00000000,
0xFCFFFF3F,0x00000000,0xFFFFFF1F,0x000000F8,0x00FE3F00,0x00000000,0xE0FF7F00,
0x00000000,0xFEFFFF03,0x00000000,0xFCFFFF3F,0x00000000,0xFCFFFF3F,0x00000000,
0xFFFFFF1F,0x000000F8,0x80FF3F00,0x00000000,0xE0FFFF01,0x00000000,0xFEFFFF03,
0x00000000,0xFEFFFF3F,0x00000000,0xFCFFFF7F,0x00000000,0xFFFFFF1F,0x000000FC,
0xF8FF3F00,0xFC01803F,0xE0FFFF1F,0x00000000,0xFFFFFF03,0x00000000,0xFFFFFF7F,
0x00000000,0xFCFFFFFF,0x00000000,0xFFFFFF1F,0x000000FC,0xFFFF3F00,0xFF07E0FF,
0xFFFFFFFF,0x00000000,0xFFFFFF7F,0x00000000,0xFFFFFF7F,0x00000000,0xFCFFFFFF,
0x00000000,0xFFFFFF1F,0x000000FE,0xFFFF3F00,0xFF07E0FF,0xFFFFFFFF,0x00000000,
0xFFFFFF7F,0x00000080,0xFFFFFFFF,0x00000000,0xFCFFFFFF,0x00000000,0xFFFFFF1F,
0x000000FF,0xFFFF3F00,0xFF0000FF,0xFFFFFFFF,0x00000000,0xFFFFFF7F,0x00000000,
0xFFFFFF7F,0x00000000,0xFEFFFFFF,0x00000000,0xFCFFFF3F,0x0000807F,0xFFFF3F00,
0x1F0000F8,0xFFFFFFFF,0x00000000,0xFFFFFF7F,0x00000000,0xFEFFFF7F,0x00000000,
0xFEFFFF7F,0x00000000,0xC0FFFF3F,0x0000803F,0xFFFF3F00,0x0F0000F0,0xFFFFFFFF,
0x00000000,0xFFFFFF7F,0x00000000,0xFEFFFF7F,0x00000000,0xFEFFFF7F,0x00000000,
0x00FFFF3F,0x0000C01F,0xFFFF3F00,0x0F0000F0,0xFFFFFFFF,0x00000000,0xFFFFFF7F,
0x00000000,0xFEFFFF7F,0x00000000,0xFFFFFF7F,0x00000000,0x00FEFF7F,0x0000E01F,
0xFFFF3F00,0x1F0000F8,0xFFFFFFFF,0x00000080,0xFEFFFFFF,0x00000000,0xFCFFFF3F,
0x00000000,0xFFFFFF3F,0x00000000,0x00FEFF7F,0x0000F00F,0xFFFF7F00,0x1F0000F8,
0xFFFFFFFF,0x010000C0,0xFEFFFFFF,0x00000000,0xF8FFFF3F,0x00000000,0xFFFFFF1F,
0x00000080,0x00FCFFFF,0x0000F807,0xFFFF7F00,0x1F0000F8,0xFFFFFFFF,0x030000E0,
0xFCFFFFFF,0x00000000,0xF0FFFF1F,0x00000000,0xFFFFFF0F,0x00000080,0x00FCFFFF,
0x0000FC03,0xFFFF7F00,0x3F0000FC,0xFFFFFFFF,0x070000F0,0xF8FFFFFF,0x00000000,
0xE0FFFF0F,0x00000000,0xFFFFFF07,0x010000C0,0x00FCFFFF,0x0000FE01,0xFFFF7F00,
0x3F0000FC,0xFFFFFFFF,0x0F0000F8,0xF8FFFFFF,0x00000000,0xC0FFFF0F,0x00000000,
0xFFFFFF03,0x030000E0,0x00FCFFFF,0x00007E00,0xFFFF7F00,0x7F0000FE,0xFFFFFFFF,
0x0F0000F8,0xF0FFFFFF,0x00000000,0x80FFFF07,0x00000000,0xFFFFFF01,0x070000F0,
0x00FCFFFF,0x00001F00,0xFFFF7F00,0x3F0000FC,0xFFFFFFFF,0x0F0000F8,0xF0FFFFFF,
0x00000000,0x00FFFF07,0x00000000,0xFFFFFF00,0x0F0000F8,0x00FCFFFF,0x00000700,
0xFFFFFF00,0x1F0000F8,0xFFFFFFFF,0x0F0000F8,0xF0FFFFFF,0x00000000,0x00FFFF07,
0x00000000,0xFFFFFF00,0x3F0000FE,0x00FEFFFF,0x00800100,0xFFFFFF00,0x0F0000F0,
0xFFFFFFFF,0x0F0000F8,0xF0FFFFFF,0x00000000,0x00FEFF07,0x00000000,0xFFFF7F00,
0xFF0080FF,0x00FEFFFF,0x00800000,0xFFFFFF00,0x0F0000F0,0xFFFFFFFF,0x0F0000F8,
0xF0FFFFFF,0x00000000,0x00FEFF07,0x00000000,0xFFFF7F00,0x7F0000FF,0x00FFFFFF,
0x00000000,0xFFFFFF00,0x070000E0,0xFFFFFFFF,0x0F0000F8,0xE0FFFFFF,0x02000020,
0x00FEFF03,0x00000000,0xFFFF7F00,0x3F0000FE,0x00FFFFFF,0x00000000,0xFFFFFF01,
0x070000E0,0xFFFFFFFF,0x0F0000F8,0xE0FFFFFF,0x02000020,0x00FEFF03,0x00000000,
0xFFFF7F00,0x1F0000FC,0x80FFFFFF,0x00000000,0xFFFFFF01,0x030000C0,0xFFFFFFFF,
0x0F0000F8,0xE0FFFFFF,0x03041060,0x00FEFF03,0x00000000,0xFFFF7F00,0x1F0000FC,
0xC0FFFFFF,0x00000000,0xFFFFFF01,0x030000C0,0xFFFFFFFF,0x0F0000F8,0xE0FFFFFF,
0x03041060,0x00FEFF03,0x00000000,0xFFFF7F00,0x0F0000F8,0xC0FFFFFF,0x00000000,
0xFFFFFF03,0x030000C0,0xFFFFFFFF,0x0F0000F8,0xE0FFFFFF,0x030410E0,0x00FEFF83,
0x00000000,0xFFFF7F00,0x0F0000F8,0xE0FFFFFF,0x00000000,0xFFFFFF03,0x030000C0,
0xFFFFFFFF,0x0F0000F8,0xC0FFFFFF,0x030630E0,0x00FFFF81,0x00000000,0xFFFFFF00,
0x0F0000F8,0xE0FFFFFF,0x00000000,0xFFFFFF07,0x030000C0,0xFFFFFFFF,0x0F0000F8,
0xC1FFFFFF,0x030E38E0,0x00FFFFC1,0x00000000,0xFFFFFF00,0x0F0000F8,0xF0FFFFFF,
0x00000000,0xFFFFFF07,0x030000C0,0xFFFFFFFF,0x0F0000F8,0xC3FFFFFF,0x030E38E0,
0x80FFFFC1,0x00000000,0xFFFFFF01,0x0F0000F8,0xF0FFFFFF,0x00000000,0xFFFFFF0F,
0x030000C0,0xFFFFFFFF,0x0F0000F8,0xC3FFFFFF,0x030F78E0,0xC0FFFFE1,0x00000000,
0xFFFFFF03,0x1F0000FC,0xF8FFFFFF,0x00000000,0xFFFFFF0F,0x030000C0,0xFFFFFFFF,
0x0F0000F8,0x87FFFFFF,0x030F78E0,0xE0FFFFF0,0x00024000,0xFFFFFF07,0x1F0000FC,
0xF8FFFFFF,0x00000000,0xFFFFFF1F,0x070000E0,0xFFFFFFFF,0x070000F0,0x87FFFFFF,
0x030F78E0,0xF0FFFFF0,0x0003C000,0xFFFFFF0F,0x3F0000FE,0xF8FFFFFF,0x00000000,
0xFFFFFF1F,0x070000E0,0xFFFFFFFF,0x030000E0,0x8FFFFFFF,0x831FFCE0,0xFCFFFFF8,
0xC003C003,0xFFFFFF3F,0x7F0000FF,0xF8FFFFFF,0x00000000,0xFFFFFF3F,0x0F0000F0,
0xFFFFFFFF,0x00000080,0x8FFFFFFF,0x831FFCE0,0xFFFFFFF8,0xFF03C0FF,0xFFFFFFFF,
0xFF0080FF,0xF8FFFFFF,0x00000000,0xFFFFFF7F,0x1F0000F8,0xFFFFFFFF,0x00000000,
0x1FFFFF7F,0x831FFCE0,0xFFFF7FFC,0xFF07E0FF,0xFFFFFFFF,0xFF01C0FF,0xFCFFFFFF,
0x00000000,0xFFFFFFFF,0x3F0000FC,0xFEFFFFFF,0x00000000,0x3FFEFF3F,0xC31FFCE1,
0xFFFF3FFE,0xFF07E0FF,0xFFFFFFFF,0xFF07F0FF,0xFCFFFFFF,0x01000000,0xFFFFFFFF,
0x7F0000FE,0xFCFFFFFF,0x00000000,0x1FFCFF1F,0xC31FFCE1,0xFFFF1FFC,0xFF0FF0FF,
0xFFFFFFFF,0xFF03E0FF,0xFEFFFFFF,0x03000000,0xFFFFFFFF,0xFF0180FF,0xFCFFFFFF,
0x00000000,0x0FF8FF1F,0xC33FFEE1,0xFFFF0FF8,0xFF1FF8FF,0xFFFFFFFF,0xFF03E0FF,
0xFFFFFFFF,0x07000000,0xFFFFFFFF,0xFF03C0FF,0xFCFFFFFF,0x00000000,0x0FF8FF1F,
0xE33FFEE3,0xFFFF0FF8,0xFF7FFEFF,0xFFFFFFFF,0xFF01C0FF,0xFFFFFFFF,0x0F000080,
0xFFFFFFFF,0xFF07E0FF,0xFCFFFFFF,0x00000000,0x0FF8FF1F,0xE33FFEE3,0xFFFF0FF8,
0xFF7FFEFF,0xFFFFFFFF,0xFF01C0FF,0xFFFFFFFF,0x3F000080,0xFFFFFFFF,0xFF1FF8FF,
0xFCFFFFFF,0x00000000,0x1FFCFF1F,0xE33FFEE3,0xFFFF1FFC,0xFF7FFEFF,0xFFFFFFFF,
0xFF01C0FF,0xFFFFFFFF,0xFF000080,0xFFFFFFFF,0xFF1FF8FF,0xFCFFFFFF,0x00000000,
0x3FFEFF1F,0xC13FFEC1,0xFFFF3FFE,0xFF7FFEFF,0xFFFFFFFF,0xFF01C0FF,0xFFFFFFFF,
0xFF030080,0xFFFFFFFF,0xFF0FF0FF,0xFCFFFFFF,0x00000000,0xFFFFFF1F,0x803FFE80,
0xFFFFFFFF,0xFF7FFEFF,0xFFFFFFFF,0xFF03E0FF,0xFFFFFFFF,0xFF7F0000,0xFFFFFFFF,
0xFF0FF0FF,0xFCFFFFFF,0xC007F001,0xFFFFFF1F,0x801FFC80,0xFFFFFFFF,0xFF07E0FF,
0xFFFFFFFF,0xFF03E0FF,0xFFFFFFFF,0xFFFFC000,0xFFFFFFFF,0xFF0FF0FF,0xFCFFFFFF,
0xC007F001,0xFFFFFF1F,0x800FF880,0xFFFFFFFF,0xFF07E0FF,0xFFFFFFFF,0xFF07F0FF,
0xFFFFFFFF,0xFFFFC003,0xFFFFFFFF,0xFF0FF0FF,0xFCFFFFFF,0xC007F001,0xFFFFFF1F,
0xC10FF8C1,0xFFFFFFFF,0xFF7FFEFF,0xFFFFFFFF,0xFF1FFCFF,0xFFFFFFFF,0xFFFFE107,
0xFFFFFFFF,0xFF0FF0FF,0xFCFFFFFF,0xC007F001,0xFFFFFF1F,0xE30FF8E3,0xFFFFFFFF,
0xFF7FFEFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFE10F,0xFFFFFFFF,0xFF1FF8FF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFF1FFCFF,0xFFFFFFFF,0xFF7FFEFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFF3BF,0xFFFFFFFF,0xFF3FFCFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFF3FFEFF,0xFFFFFFFF,0xFF7FFEFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0x3FFFFFFF,0xFFFFFFFF,0xFFFFFFFC,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFF03C0FF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x000000F0,0x03FF3F00,0x07FC3FE0,
0xFFFFFFC0,0xFFFFFFFF,0xFFFFFFFF,0xFF0080FF,0xFFFFFFFF,0x1F0000F8,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0x000000F0,0x00FE3F00,0x00E00700,0xE0FF7F00,0x00000000,
0xFFFFFF03,0x030000E0,0xFFFFFFFF,0x030000C0,0xFEFFFFFF,0x00000000,0xFFFFFF3F,
0x000000F0,0x00FE3F1C,0x00C00300,0xE0FF7F00,0x00000000,0xFEFFFF03,0x00000000,
0xFEFFFF3F,0x00000000,0xFCFFFF7F,0x00000000,0xFFFFFF1F,0x000000F0,0x00FC3F1C,
0x00800100,0xE0FF3F00,0x00000000,0xF8FFFF03,0x00000000,0xF8FFFF0F,0x00000000,
0xFCFFFF1F,0x00000000,0xFFFFFF1F,0x000000F0,0x00FC3F1C,0x00000000,0xE0FF3F00,
0x00000000,0xFCFFFF03,0x07000070,0xFCFFFF1F,0x3E00007C,0xFCFFFF3F,0x00000000,
0xFFFFFF1F,0x000000F8,0x00FE3F1C,0x00000000,0xE0FF7F00,0x00000000,0xFEFFFF03,
0xFE01C03F,0xFCFFFF3F,0xFC07E03F,0xFCFFFF3F,0x00000000,0xFFFFFF1F,0x000000F8,
0x80FF3F1C,0x00000000,0xE0FFFF01,0xFEFFFF3F,0xFEFFFF03,0xFCFFFF1F,0xFEFFFF3F,
0xE0FFFF07,0xFCFFFF7F,0x00000000,0xFFFFFF1F,0x000000FC,0xF8FF3F1C,0xFC01803F,
0xE0FFFF1F,0xFEFFFF3F,0xFFFFFF03,0x00FF7F00,0xFFFFFF7F,0x00FC3F00,0xFCFFFFFF,
0x00000000,0xFFFFFF1F,0x000000FC,0xFFFF3F1C,0xFF07E0FF,0xFFFFFFFF,0x00000000,
0xFFFFFF7F,0x00000000,0xFFFFFF7F,0x1C000038,0xFCFFFFFF,0x00000000,0xFFFFFF1F,
0x000000FE,0xFFFF3F1C,0xFF07E0FF,0xFFFFFFFF,0x00000000,0xFFFFFF7F,0x0C000098,
0xFFFFFFFF,0xFC03803F,0xFCFFFFFF,0x00000000,0xFFFFFF1F,0x000000FF,0xFFFF3F1C,
0xFF0000FF,0xFFFFFFFF,0x00000000,0xFFFFFF7F,0xFC00801F,0xFFFFFF7F,0xF0FFFF0F,
0xFEFFFFFF,0x00000000,0xFCFFFF3F,0x0000807F,0xFFFF3F1C,0x1F0000F8,0xFFFFFFFF,
0x00000000,0xFFFFFF7F,0xF8FFFF0F,0xFEFFFF7F,0x00FE7F00,0xFEFFFF7F,0x00000000,
0xC0FFFF3F,0x0000803F,0xFFFF3F1C,0x0F0000F0,0xFFFFFFFF,0xFEFFFF3F,0xFFFFFF7F,
0x80FFFF00,0xFEFFFF7F,0x00000000,0xFEFFFF7F,0x00000000,0x00FFFF3F,0x0000C01F,
0xFFFF3F1C,0x8F0000F1,0xFFFFFFFF,0xFCFFFF1F,0xFFFFFF7F,0x00000000,0xFEFFFF7F,
0x00000000,0xFFFFFF7F,0x00000000,0x0EFEFF7F,0x0000E01F,0xFFFF3F18,0x9F0FF0F9,
0xFFFFFFFF,0x00000080,0xFEFFFFFF,0x06000030,0xFCFFFF3F,0x1E000078,0xFFFFFF3F,
0x00000000,0x07FEFF7F,0x0000F00F,0xFFFF7F38,0x1FFFFFF8,0xFFFFFFFF,0x010000C0,
0xFEFFFFFF,0x7E00003F,0xF8FFFF3F,0xFF03C0FF,0xFFFFFF1F,0x00000080,0x03FCFFFF,
0x0000F807,0xFFFF7F38,0x1FF81FF8,0xFFFFFFFF,0x030000E0,0xFCFFFFFF,0xFCFFFF1F,
0xF1FFFF1F,0xF37FFECF,0xFFFFFF8F,0x00000080,0x23FCFFFF,0x0000FC03,0xFFFF7F38,
0x3F0000FC,0xFFFFFFFF,0xC7FFFFF1,0xF8FFFFFF,0xC0FFFF01,0xE3FFFF0F,0x017E7E80,
0xFFFFFFC7,0x010000C0,0x70FCFFFF,0x0000FE01,0xFFFF7F38,0x3F0000FC,0xFFFFFFFF,
0xCFFFFFF9,0xF8FFFFFF,0x00000000,0xC7FFFF0F,0x00600600,0xFFFFFFE3,0x030000E0,
0x70FCFFFF,0x00007E00,0xFFFF7F38,0x7F0E70FE,0xFFFFFFFF,0x0F0000F8,0xF0FFFFFF,
0x00000000,0x8EFFFF07,0x00600600,0xFFFFFF71,0x070000F0,0x30FCFFFF,0x00001F00,
0xFFFF7F30,0x3FFE7FFC,0xFFFFFFFF,0x0F0000F8,0xF0FFFFFF,0x00000000,0x1CFFFF07,
0x00600600,0xFFFFFF38,0x0F0000F8,0x00FCFFFF,0x00000700,0xFFFFFF70,0x1FF81FF8,
0xFFFFFFFF,0x0F0000F8,0xF0FFFFFF,0x00000000,0x38FFFF07,0x00600600,0xFFFFFF1C,
0x3F0000FE,0x00FEFFFF,0x00800100,0xFFFFFF70,0x0F0000F0,0xFFFFFFFF,0x0F0000F8,
0xF0FFFFFF,0x00000000,0x30FEFF07,0x00300C00,0xFFFF7F0C,0xFF0080FF,0x00FEFFFF,
0x00800000,0xFFFFFF70,0x0F0000F0,0xFFFFFFFF,0x0F0000F8,0xF0FFFFFF,0x00000000,
0x70FEFF07,0x00300C00,0xFFFF7F0E,0x7F0000FF,0x00FFFFFF,0x00000000,0xFFFFFF60,
0x070000E0,0xFFFFFFFF,0x0F0000F8,0xE0FFFFFF,0x02000020,0x60FEFF03,0x00300C00,
0xFFFF7F06,0x3F0000FE,0x00FFFFFF,0x00000000,0xFFFFFFE1,0x078001E0,0xFFFFFFFF,
0x0F0000F8,0xE0FFFFFF,0x02000020,0x60FEFF03,0x00181800,0xFFFF7F06,0x1F0000FC,
0x80FFFFFF,0x00E00000,0xFFFFFFE1,0x038001C0,0xFFFFFFFF,0x0F0000F8,0xE0FFFFFF,
0x03041060,0x60FEFF03,0x00981900,0xFFFF7F06,0x1F0000FC,0xC0FFFFFF,0x00E00000,
0xFFFFFFE1,0x038001C0,0xFFFFFFFF,0x0F0000F8,0xE0FFFFFF,0x03041060,0x70FEFF03,
0x008C3100,0xFFFF7F0E,0x0F0000F8,0xC0FFFFFF,0x00600000,0xFFFFFFC3,0x038001C0,
0xFFFFFFFF,0x0F0000F8,0xE0FFFFFF,0x030410E0,0x30FEFF83,0x00CE7300,0xFFFF7F0C,
0x0F0000F8,0xE0FFFFFF,0x01600000,0xFFFFFFC3,0x038001C0,0xFFFFFFFF,0x0F0000F8,
0xC0FFFFFF,0x030630E0,0x38FFFF81,0x00C7E300,0xFFFFFF1C,0x0F0000F8,0xE0FFFFFF,
0x01700000,0xFFFFFF87,0x03FC3FC0,0xFFFFFFFF,0x0F0000F8,0xC1FFFFFF,0x030E38E0,
0x1CFFFFC1,0xC063C603,0xFFFFFF38,0x0F0000F8,0xF0FFFFFF,0x03300000,0xFFFFFF87,
0x03FC3FC0,0xFFFFFFFF,0x0F0000F8,0xC3FFFFFF,0x030E38E0,0x8FFFFFC1,0xF061860F,
0xFFFFFFF1,0x0F0000F8,0xF0FFFFFF,0x033000C0,0xFFFFFF0F,0x038001C0,0xFFFFFFFF,
0x0F0000F8,0xC3FFFFFF,0x030F78E0,0xC7FFFFE1,0x7F6006FE,0xFFFFFFE3,0x1F0000FC,
0xF8FFFFFF,0x032000F0,0xFFFFFF0F,0x038001C0,0xFFFFFFFF,0x0F0000F8,0x87FFFFFF,
0x030F78E0,0xE1FFFFF0,0x1F324CF8,0xFFFFFF87,0x1F0000FC,0xF8FFFFFF,0x060000F8,
0xFFFFFF1F,0x078001E0,0xFFFFFFFF,0xC7FFFFF1,0x87FFFFFF,0x030F78E0,0xF0FFFFF0,
0x0033CC00,0xFFFFFF0F,0x3F0000FE,0xF8FFFFFF,0x0C000078,0xFFFFFF1F,0x078001E0,
0xFFFFFFFF,0xC3FFFFE1,0x8FFFFFFF,0x831FFCE0,0xFCFFFFF8,0xC033CC03,0xFFFFFF3F,
0x7F0000FF,0xF8FFFFFF,0x1C00007C,0xFFFFFF3F,0x0F8001F0,0xFFFFFFFF,0x00000080,
0x8FFFFFFF,0x831FFCE0,0xFFFFFFF8,0xFF63C6FF,0xFFFFFFFF,0xFF0080FF,0xF8FFFFFF,
0x1800001C,0xFFFFFF7F,0x1F0000F8,0xFFFFFFFF,0x00000000,0x1FFFFF7F,0x831FFCE0,
0xFFFF7FFC,0xFFE7E7FF,0xFFFFFFFF,0xFF01C0FF,0xFCFFFFFF,0x30000000,0xFFFFFFFF,
0x3F0000FC,0xFEFFFFFF,0x00000000,0x3FFEFF3F,0xC31FFCE1,0xFFFF3FFE,0xFF87E1FF,
0xFFFFFFFF,0xFF07F0FF,0xFCFFFFFF,0x61000000,0xFFFFFFFF,0x7F0000FE,0xFCFFFFFF,
0xFEFFFF3F,0x1FFCFF1F,0xC31FFCE1,0xFFFF1FFC,0xFF0FF0FF,0xFFFFFFFF,0xFF03E0FF,
0xFEFFFFFF,0xC3010000,0xFFFFFFFF,0xFF0180FF,0xFCFFFFFF,0xFFFFFF7F,0x0FF8FF1F,
0xC33FFEE1,0xFFFF0FF8,0xFF1FF8FF,0xFFFFFFFF,0xFF03E0FF,0xFFFFFFFF,0x87030000,
0xFFFFFFFF,0xFF03C0FF,0xFCFFFFFF,0x00000000,0x0FF8FF1F,0xE33FFEE3,0xFFFF0FF8,
0xFF7FFEFF,0xFFFFFFFF,0xFF01C0FF,0xFFFFFFFF,0x0F1E8087,0xFFFFFFFF,0xFF07E0FF,
0xFCFFFFFF,0x00000000,0x0FF8FF1F,0xE33FFEE3,0xFFFF0FF8,0xFF7FFEFF,0xFFFFFFFF,
0xFF01C0FF,0xFFFFFFFF,0x3F700080,0xFFFFFFFF,0xFF1FF8FF,0xFCFFFFFF,0x00000000,
0x1FFCFF1F,0xE33FFEE3,0xFFFF1FFC,0xFF7FFEFF,0xFFFFFFFF,0xFF01C0FF,0xFFFFFFFF,
0xFF000080,0xFFFFFFFF,0xFF1FF8FF,0xFCFFFFFF,0x00000000,0x3FFEFF1F,0xC13FFEC1,
0xFFFF3FFE,0xFF7FFEFF,0xFFFFFFFF,0xFF01C0FF,0xFFFFFFFF,0xFF030080,0xFFFFFFFF,
0xFF0FF0FF,0xFCFFFFFF,0x00000000,0xFFFFFF1F,0x803FFE80,0xFFFFFFFF,0xFF7FFEFF,
0xFFFFFFFF,0xFF03E0FF,0xFFFFFFFF,0xFF7F0000,0xFFFFFFFF,0xFF0FF0FF,0xFCFFFFFF,
0xC007F001,0xFFFFFF1F,0x801FFC80,0xFFFFFFFF,0xFF07E0FF,0xFFFFFFFF,0xFF03E0FF,
0xFFFFFFFF,0xFFFFC000,0xFFFFFFFF,0xFF0FF0FF,0xFCFFFFFF,0xC007F001,0xFFFFFF1F,
0x800FF880,0xFFFFFFFF,0xFF07E0FF,0xFFFFFFFF,0xFF07F0FF,0xFFFFFFFF,0xFFFFC003,
0xFFFFFFFF,0xFF0FF0FF,0xFCFFFFFF,0xC007F001,0xFFFFFF1F,0xC10FF8C1,0xFFFFFFFF,
0xFF7FFEFF,0xFFFFFFFF,0xFF1FFCFF,0xFFFFFFFF,0xFFFFE107,0xFFFFFFFF,0xFF0FF0FF,
0xFCFFFFFF,0xC007F001,0xFFFFFF1F,0xE30FF8E3,0xFFFFFFFF,0xFF7FFEFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFE10F,0xFFFFFFFF,0xFF1FF8FF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFF1FFCFF,0xFFFFFFFF,0xFF7FFEFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFF3BF,0xFFFFFFFF,0xFF3FFCFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFF3FFEFF,
0xFFFFFFFF,0xFF7FFEFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x3FFFFFFF,0xFFFFFFFF,
0xFFFFFFFC,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFF03C0FF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0x000000F0,0x03FF3F00,0x07FC3FE0,0xFFFFFFC0,0xFFFFFFFF,
0xFFFFFFFF,0xFF0080FF,0xFFFFFFFF,0x1F0000F8,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0x000000F0,0x00FE3F00,0x00E00700,0xE0FF7F00,0x00000000,0xFFFFFF03,0x030000E0,
0xFFFFFFFF,0x030000C0,0xFEFFFFFF,0x00000000,0xFFFFFF3F,0x000000F0,0x00FE3F00,
0x00C00300,0xE0FF7F00,0x00000000,0xFEFFFF03,0x00000000,0xFEFFFF3F,0x00000000,
0xFCFFFF7F,0x00000000,0xFFFFFF1F,0x000000F0,0x00FC3F00,0x00800100,0xE0FF3F00,
0x00000000,0xF8FFFF03,0x00000000,0xF8FFFF0F,0x00000000,0xFCFFFF1F,0x00000000,
0xFFFFFF1F,0x000000F0,0x00FC3F00,0x00000000,0xE0FF3F00,0x00000000,0xFCFFFF03,
0x00000000,0xFCFFFF1F,0x00000000,0xFCFFFF3F,0x00000000,0xFFFFFF1F,0x000000F8,
0x00FE3F00,0x00000000,0xE0FF7F00,0x00000000,0xFEFFFF03,0x00000000,0xFCFFFF3F,
0x00000000,0xFCFFFF3F,0x00000000,0xFFFFFF1F,0x000000F8,0x80FF3F00,0x00000000,
0xE0FFFF01,0x00000000,0xFEFFFF03,0x00000000,0xFEFFFF3F,0x00000000,0xFCFFFF7F,
0x00000000,0xFFFFFF1F,0x000000FC,0xF8FF3F00,0xFC01803F,0xE0FFFF1F,0x00000000,
0xFFFFFF03,0x00000000,0xFFFFFF7F,0x00000000,0xFCFFFFFF,0x00000000,0xFFFFFF1F,
0x000000FC,0xFFFF3F00,0xFF07E0FF,0xFFFFFFFF,0x00000000,0xFFFFFF7F,0x00000000,
0xFFFFFF7F,0x00000000,0xFCFFFFFF,0x00000000,0xFFFFFF1F,0x000000FE,0xFFFF3F00,
0xFF07E0FF,0xFFFFFFFF,0x00000000,0xFFFFFF7F,0x00000080,0xFFFFFFFF,0x00000000,
0xFCFFFFFF,0x00000000,0xFFFFFF1F,0x000000FF,0xFFFF3F00,0xFF0000FF,0xFFFFFFFF,
0x00000000,0xFFFFFF7F,0x00000000,0xFFFFFF7F,0x00000000,0xFEFFFFFF,0x00000000,
0xFCFFFF3F,0x0000807F,0xFFFF3F00,0x1F0000F8,0xFFFFFFFF,0x00000000,0xFFFFFF7F,
0x00000000,0xFEFFFF7F,0x00000000,0xFEFFFF7F,0x00000000,0xC0FFFF3F,0x0000803F,
0xFFFF3F00,0x0F0000F0,0xFFFFFFFF,0x00000000,0xFFFFFF7F,0x00000000,0xFEFFFF7F,
0x00000000,0xFEFFFF7F,0x00000000,0x00FFFF3F,0x0000C01F,0xFFFF3F00,0x0F0000F0,
0xFFFFFFFF,0x00000000,0xFFFFFF7F,0x00000000,0xFEFFFF7F,0x00000000,0xFFFFFF7F,
0x00000000,0x00FEFF7F,0x0000E01F,0xFFFF3F00,0x1F0000F8,0xFFFFFFFF,0x00000080,
0xFEFFFFFF,0x00000000,0xFCFFFF3F,0x00000000,0xFFFFFF3F,0x00000000,0x00FEFF7F,
0x0000F00F,0xFFFF7F00,0x1F0000F8,0xFFFFFFFF,0x010000C0,0xFEFFFFFF,0x00000000,
0xF8FFFF3F,0x00000000,0xFFFFFF1F,0x00000080,0x00FCFFFF,0x0000F807,0xFFFF7F00,
0x1F0000F8,0xFFFFFFFF,0x030000E0,0xFCFFFFFF,0x00000000,0xF0FFFF1F,0x00000000,
0xFFFFFF0F,0x00000080,0x00FCFFFF,0x0000FC03,0xFFFF7F00,0x3F0000FC,0xFFFFFFFF,
0x070000F0,0xF8FFFFFF,0x00000000,0xE0FFFF0F,0x00000000,0xFFFFFF07,0x010000C0,
0x00FCFFFF,0x0000FE01,0xFFFF7F00,0x3F0000FC,0xFFFFFFFF,0x0F0000F8,0xF8FFFFFF,
0x00000000,0xC0FFFF0F,0x00000000,0xFFFFFF03,0x030000E0,0x00FCFFFF,0x00007E00,
0xFFFF7F00,0x7F0000FE,0xFFFFFFFF,0x0F0000F8,0xF0FFFFFF,0x00000000,0x80FFFF07,
0x00000000,0xFFFFFF01,0x070000F0,0x00FCFFFF,0x00001F00,0xFFFF7F00,0x3F0000FC,
0xFFFFFFFF,0x0F0000F8,0xF0FFFFFF,0x00000000,0x00FFFF07,0x00000000,0xFFFFFF00,
0x0F0000F8,0x00FCFFFF,0x00000700,0xFFFFFF00,0x1F0000F8,0xFFFFFFFF,0x0F0000F8,
0xF0FFFFFF,0x00000000,0x00FFFF07,0x00000000,0xFFFFFF00,0x3F0000FE,0x00FEFFFF,
0x00800100,0xFFFFFF00,0x0F0000F0,0xFFFFFFFF,0x0F0000F8,0xF0FFFFFF,0x00000000,
0x00FEFF07,0x00000000,0xFFFF7F00,0xFF0080FF,0x00FEFFFF,0x00800000,0xFFFFFF00,
0x0F0000F0,0xFFFFFFFF,0x0F0000F8,0xF0FFFFFF,0x00000000,0x00FEFF07,0x00000000,
0xFFFF7F00,0x7F0000FF,0x00FFFFFF,0x00000000,0xFFFFFF00,0x070000E0,0xFFFFFFFF,
0x0F0000F8,0xE0FFFFFF,0x02000020,0x00FEFF03,0x00000000,0xFFFF7F00,0x3F0000FE,
0x00FFFFFF,0x00000000,0xFFFFFF01,0x070000E0,0xFFFFFFFF,0x0F0000F8,0xE0FFFFFF,
0x02000020,0x00FEFF03,0x00000000,0xFFFF7F00,0x1F0000FC,0x80FFFFFF,0x00000000,
0xFFFFFF01,0x030000C0,0xFFFFFFFF,0x0F0000F8,0xE0FFFFFF,0x03041060,0x00FEFF03,
0x00000000,0xFFFF7F00,0x1F0000FC,0xC0FFFFFF,0x00000000,0xFFFFFF01,0x030000C0,
0xFFFFFFFF,0x0F0000F8,0xE0FFFFFF,0x03041060,0x00FEFF03,0x00000000,0xFFFF7F00,
0x0F0000F8,0xC0FFFFFF,0x00000000,0xFFFFFF03,0x030000C0,0xFFFFFFFF,0x0F0000F8,
0xE0FFFFFF,0x030410E0,0x00FEFF83,0x00000000,0xFFFF7F00,0x0F0000F8,0xE0FFFFFF,
0x00000000,0xFFFFFF03,0x030000C0,0xFFFFFFFF,0x0F0000F8,0xC0FFFFFF,0x030630E0,
0x00FFFF81,0x00000000,0xFFFFFF00,0x0F0000F8,0xE0FFFFFF,0x00000000,0xFFFFFF07,
0x030000C0,0xFFFFFFFF,0x0F0000F8,0xC1FFFFFF,0x030E38E0,0x00FFFFC1,0x00000000,
0xFFFFFF00,0x0F0000F8,0xF0FFFFFF,0x00000000,0xFFFFFF07,0x030000C0,0xFFFFFFFF,
0x0F0000F8,0xC3FFFFFF,0x030E38E0,0x80FFFFC1,0x00000000,0xFFFFFF01,0x0F0000F8,
0xF0FFFFFF,0x00000000,0xFFFFFF0F,0x030000C0,0xFFFFFFFF,0x0F0000F8,0xC3FFFFFF,
0x030F78E0,0xC0FFFFE1,0x00000000,0xFFFFFF03,0x1F0000FC,0xF8FFFFFF,0x00000000,
0xFFFFFF0F,0x030000C0,0xFFFFFFFF,0x0F0000F8,0x87FFFFFF,0x030F78E0,0xE0FFFFF0,
0x00024000,0xFFFFFF07,0x1F0000FC,0xF8FFFFFF,0x00000000,0xFFFFFF1F,0x070000E0,
0xFFFFFFFF,0x070000F0,0x87FFFFFF,0x030F78E0,0xF0FFFFF0,0x0003C000,0xFFFFFF0F,
0x3F0000FE,0xF8FFFFFF,0x00000000,0xFFFFFF1F,0x070000E0,0xFFFFFFFF,0x030000E0,
0x8FFFFFFF,0x831FFCE0,0xFCFFFFF8,0xC003C003,0xFFFFFF3F,0x7F0000FF,0xF8FFFFFF,
0x00000000,0xFFFFFF3F,0x0F0000F0,0xFFFFFFFF,0x00000080,0x8FFFFFFF,0x831FFCE0,
0xFFFFFFF8,0xFF03C0FF,0xFFFFFFFF,0xFF0080FF,0xF8FFFFFF,0x00000000,0xFFFFFF7F,
0x1F0000F8,0xFFFFFFFF,0x00000000,0x1FFFFF7F,0x831FFCE0,0xFFFF7FFC,0xFF07E0FF,
0xFFFFFFFF,0xFF01C0FF,0xFCFFFFFF,0x00000000,0xFFFFFFFF,0x3F0000FC,0xFEFFFFFF,
0x00000000,0x3FFEFF3F,0xC31FFCE1,0xFFFF3FFE,0xFF07E0FF,0xFFFFFFFF,0xFF07F0FF,
0xFCFFFFFF,0x01000000,0xFFFFFFFF,0x7F0000FE,0xFCFFFFFF,0x00000000,0x1FFCFF1F,
0xC31FFCE1,0xFFFF1FFC,0xFF0FF0FF,0xFFFFFFFF,0xFF03E0FF,0xFEFFFFFF,0x03000000,
0xFFFFFFFF,0xFF0180FF,0xFCFFFFFF,0x00000000,0x0FF8FF1F,0xC33FFEE1,0xFFFF0FF8,
0xFF1FF8FF,0xFFFFFFFF,0xFF03E0FF,0xFFFFFFFF,0x07000000,0xFFFFFFFF,0xFF03C0FF,
0xFCFFFFFF,0x00000000,0x0FF8FF1F,0xE33FFEE3,0xFFFF0FF8,0xFF7FFEFF,0xFFFFFFFF,
0xFF01C0FF,0xFFFFFFFF,0x0F000080,0xFFFFFFFF,0xFF07E0FF,0xFCFFFFFF,0x00000000,
0x0FF8FF1F,0xE33FFEE3,0xFFFF0FF8,0xFF7FFEFF,0xFFFFFFFF,0xFF01C0FF,0xFFFFFFFF,
0x3F000080,0xFFFFFFFF,0xFF1FF8FF,0xFCFFFFFF,0x00000000,0x1FFCFF1F,0xE33FFEE3,
0xFFFF1FFC,0xFF7FFEFF,0xFFFFFFFF,0xFF01C0FF,0xFFFFFFFF,0xFF000080,0xFFFFFFFF,
0xFF1FF8FF,0xFCFFFFFF,0x00000000,0x3FFEFF1F,0xC13FFEC1,0xFFFF3FFE,0xFF7FFEFF,
0xFFFFFFFF,0xFF01C0FF,0xFFFFFFFF,0xFF030080,0xFFFFFFFF,0xFF0FF0FF,0xFCFFFFFF,
0x00000000,0xFFFFFF1F,0x803FFE80,0xFFFFFFFF,0xFF7FFEFF,0xFFFFFFFF,0xFF03E0FF,
0xFFFFFFFF,0xFF7F0000,0xFFFFFFFF,0xFF0FF0FF,0xFCFFFFFF,0xC007F001,0xFFFFFF1F,
0x801FFC80,0xFFFFFFFF,0xFF07E0FF,0xFFFFFFFF,0xFF03E0FF,0xFFFFFFFF,0xFFFFC000,
0xFFFFFFFF,0xFF0FF0FF,0xFCFFFFFF,0xC007F001,0xFFFFFF1F,0x800FF880,0xFFFFFFFF,
0xFF07E0FF,0xFFFFFFFF,0xFF07F0FF,0xFFFFFFFF,0xFFFFC003,0xFFFFFFFF,0xFF0FF0FF,
0xFCFFFFFF,0xC007F001,0xFFFFFF1F,0xC10FF8C1,0xFFFFFFFF,0xFF7FFEFF,0xFFFFFFFF,
0xFF1FFCFF,0xFFFFFFFF,0xFFFFE107,0xFFFFFFFF,0xFF0FF0FF,0xFCFFFFFF,0xC007F001,
0xFFFFFF1F,0xE30FF8E3,0xFFFFFFFF,0xFF7FFEFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFE10F,0xFFFFFFFF,0xFF1FF8FF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFF1FFCFF,
0xFFFFFFFF,0xFF7FFEFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFF3BF,0xFFFFFFFF,
0xFF3FFCFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFF3FFEFF,0xFFFFFFFF,0xFF7FFEFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x3FFFFFFF,0xFFFFFFFF,0xFFFFFFFC,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFF03C0FF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0x000000F0,0x03FF3F00,0x07FC3FE0,0xFFFFFFC0,0xFFFFFFFF,0xFFFFFFFF,0xFF0080FF,
0xFFFFFFFF,0x1F0000F8,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x000000F0,0x40FE3F00,
0x00E00700,0xE0FF7F02,0x00000000,0xFFFFFF03,0x030000E0,0xFFFFFFFF,0x03F81FC0,
0xFEFFFFFF,0x00000000,0xFFFFFF3F,0xFFFFFFF3,0x78FE3FFC,0xF0C1830F,0xE0FF7F1E,
0x00000000,0xFEFFFF03,0x00FE3F00,0xFEFFFF3F,0xC0FFFF03,0xFCFFFF7F,0x00000000,
0xFFFFFF1F,0xFFFFFFF3,0xFFFC3FFC,0xFF8FF1FF,0xE7FF3FFF,0xFFFFFFFF,0xF8FFFFF3,
0xFCFFFF1F,0xF8FFFF0F,0xFCFFFF3F,0xFCFFFF1F,0xFFFFFF7F,0xFFFFFF1F,0xFFFFFFF1,
0x3FFC3FFC,0xFF1FF8FF,0xE7FF3FFC,0xFFFFFFFF,0xFCFFFFF3,0xFCFFFF1F,0xFCFFFF1F,
0xC0FFFF03,0xFCFFFF3F,0xFFFFFFFF,0xFFFFFF9F,0xFFFFFFF9,0x03FE3FFC,0x013C3C80,
0xE7FF7FC0,0xFFFFFFFF,0xFEFFFFF3,0x00FE3F00,0xFCFFFF3F,0x02F81F40,0xFCFFFF3F,
0xFFFFFFFF,0xFFFFFF9F,0xFFFFFFF8,0x80FF3FFC,0x00300C00,0xE0FFFF01,0x00000000,
0xFEFFFF03,0x02000020,0xFEFFFF3F,0x1C000038,0xFCFFFF7F,0xFFFFFFFF,0xFFFFFF9F,
0xFFFFFFFC,0xF8FF3FFC,0xFC61863F,0xE0FFFF1F,0x00000000,0xFFFFFF03,0xFE00803F,
0xFFFFFF7F,0xFC03C03F,0xFCFFFFFF,0xFFFFFFFF,0xFFFFFF9F,0xFFFF7FFC,0xFFFF3FFC,
0xFF67E6FF,0xFFFFFFFF,0xFEFFFF3F,0xFFFFFF7F,0xFCFFFF1F,0xFFFFFF7F,0xE0FFFF07,
0xFCFFFFFF,0xFFFFFFFF,0xFFFFFF9F,0xFFFF3FFE,0xFFFF3FFC,0xFF07E0FF,0xFFFFFFFF,
0xFEFFFF3F,0xFFFFFF7F,0xF0FFFF87,0xFFFFFFFF,0x00FC3F00,0xFCFFFFFF,0xFFFFFF7F,
0xFFFFFF1F,0xFFFF1FFF,0xFFFF3FFC,0xFF0000FF,0xFFFFFFFF,0xFEFFFF3F,0xFFFFFF7F,
0x00FF7F00,0xFFFFFF7F,0x0C000030,0xFEFFFFFF,0xFFFFFF7F,0xFCFFFF3F,0xFFFF9F7F,
0xFFFF3FFC,0x1FF00FF8,0xFFFFFFFF,0xFEFFFF3F,0xFFFFFF7F,0x06000030,0xFEFFFF7F,
0xFC01803F,0xFEFFFF7F,0xFFFFFF7F,0xC0FFFF3F,0xFFFF8F3F,0xFFFF3FFC,0x0FFFFFF0,
0xFFFFFFFF,0x00000000,0xFFFFFF7F,0x7E00003F,0xFEFFFF7F,0xFEFFFF7F,0xFEFFFF7F,
0xFEFFFF3F,0x01FFFF3F,0xFFFFC71F,0xFFFF3FFC,0x0FFFFFF0,0xFFFFFFFF,0x00000000,
0xFFFFFF7F,0xFEFFFF3F,0xFEFFFF7F,0xFEFFFF7F,0xFFFFFF7F,0xFEFFFF3F,0x11FEFF7F,
0xFFFFE39F,0xFFFF3FF8,0x1FF00FF8,0xFFFFFFFF,0xF8FFFF8F,0xFEFFFFFF,0xF8FFFF0F,
0xFCFFFF3F,0xE0FFFF07,0xFFFFFF3F,0xFCFFFF1F,0x38FEFF7F,0xFFFFF18F,0xFFFF7FF8,
0x9F0000F9,0xFFFFFFFF,0xF1FFFFC7,0xFEFFFFFF,0x80FFFF00,0xF8FFFF3F,0x00FC3F00,
0xFFFFFF1F,0xFCFFFF9F,0x7CFCFFFF,0xFFFFF8C7,0xFFFF7FF8,0x1F07E0F8,0xFFFFFFFF,
0xE3FFFFE3,0xFCFFFFFF,0x03000060,0xF1FFFF1F,0x0F0000F0,0xFFFFFF8F,0xF8FFFF8F,
0xDCFCFFFF,0xFF7FFCE3,0xFFFF7FF8,0x3FFEFFFC,0xFFFFFFFF,0x070000F0,0xF8FFFFFF,
0x3F0000FE,0xE3FFFF8F,0xFF0180FF,0xFFFFFFC7,0xF1FFFFC7,0x8FFCFFFF,0xFF7FFEF1,
0xFFFF7FF8,0x3FFE7FFC,0xFFFFFFFF,0x0F0000F8,0xF9FFFFFF,0xFCFFFF9F,0xC7FFFFCF,
0xFF7FFEFF,0xFFFFFFE3,0xE3FFFFE3,0x8FFCFFFF,0xFF3F7EF8,0xFFFF7FF8,0x7FF00FFE,
0xFFFFFFFF,0xCFFFFFF9,0xF0FFFFFF,0xE0FFFF03,0x8FFFFF07,0xFF7FFEFF,0xFFFFFFF1,
0x87FFFFF0,0xCFFCFFFF,0xFF3F1FFE,0xFFFF7FF0,0x3F0000FC,0xFFFFFFFF,0xCFFFFFF9,
0xF0FFFFFF,0xC0E1C301,0x1FFFFF07,0xFF7FFEFF,0xFFFFFFF8,0x0FFE3FF8,0x7FFCFFFF,
0xFF1F07FF,0xFFFFFFF0,0x1F07E0F8,0xFFFFFFFF,0xCFFFFFF9,0xF3FFFFFF,0x00800080,
0x3FFFFFE7,0xFF7FFEFF,0xFFFFFFFC,0x3FF80FFE,0x7FFEFFFF,0xFF9FC1FF,0xFFFFFFF0,
0x8FFFFFF1,0xFFFFFFFF,0xCFFFFFF9,0xF3FFFFFF,0x10100484,0x3FFEFFE7,0xFF3FFCFF,
0xFFFF7FFC,0xFFF88FFF,0x3FFEFFFF,0xFF9FF0FF,0xFFFFFFF0,0xCFFFFFF3,0xFFFFFFFF,
0xCFFFFFF9,0xF3FFFFFF,0x30314606,0x7FFEFF67,0xFF3FFCFF,0xFFFF7FFE,0x7FFC1FFF,
0x3FFFFFFF,0xFF1FF8FF,0xFFFFFFE0,0xC7FFFFE3,0xFFFFFFFF,0xCFFFFFF9,0xE3FFFFFF,
0xF261C327,0x7FFEFF63,0xFF3FFCFF,0xFFFF7FFE,0x3FFE3FFE,0x1FFFFFFF,0xFF3FFEFF,
0xFFFFFFE1,0xE77FFEE7,0xFFFFFFFF,0xCFFFFFF9,0xE6FFFFFF,0xF2E08327,0x7FFEFF33,
0xFF1FF8FF,0xFFFF7FFE,0x1FFF7FFC,0x8FFFFFFF,0xFF1FFFFF,0xFFFFFFE1,0xE37FFEC7,
0xFFFFFFFF,0xCFFFFFF9,0xE6FFFFFF,0xF3E49367,0x7FFEFF33,0xFF9FF9FF,0xFFFF7FFE,
0x9FFFFFFC,0xCFFFFFFF,0xFF1FFFFF,0xFFFFFFE1,0xF37FFECF,0xFFFFFFFF,0xCFFFFFF9,
0xE4FFFFFF,0xF3E49367,0x7FFEFF13,0xFF8FF1FF,0xFFFF7FFE,0x8FFFFFF8,0xC7FFFFFF,
0xFF9FFFFF,0xFFFFFFC3,0xF37FFECF,0xFFFFFFFF,0xCFFFFFF9,0xE4FFFFFF,0x73E413E7,
0x3FFEFF93,0xFFCFF3FF,0xFFFF7FFC,0xCFFFFFF9,0xE7FFFFFF,0xFF9FFFFF,0xFFFFFFC3,
0xF37FFECF,0xFFFFFFFF,0xCFFFFFF9,0xC0FFFFFF,0x73C631E7,0x3FFFFF81,0xFFC7E3FF,
0xFFFFFFFC,0xCFFFFFF9,0xE3FFFFFF,0xFF8FFFFF,0xFFFFFF87,0xF303C0CF,0xFFFFFFFF,
0xCFFFFFF9,0xC1FFFFFF,0x73CE39E7,0x1FFFFFC1,0xFFE3C7FF,0xFFFFFFF8,0xCFFFFFF9,
0xF3FFFFFF,0xFFCFFFFF,0xFFFFFF87,0xF303C0CF,0xFFFFFFFF,0xCFFFFFF9,0xC3FFFFFF,
0x33CE39E6,0x8FFFFFC1,0xFFE187FF,0xFFFFFFF1,0x8FFFFFF8,0xF1FFFFFF,0xFFCFFF3F,
0xFFFFFF0F,0xF37FFECF,0xFFFFFFFF,0xCFFFFFF9,0xC3FFFFFF,0x33CF79E6,0xC7FFFFE1,
0x7FE007FE,0xFFFFFFE3,0x9FFFFFFC,0xF9FFFFFF,0xFFDFFF0F,0xFFFFFF0F,0xE37FFEC7,
0xFFFFFFFF,0xCFFFFFF9,0x87FFFFFF,0x33CF79E6,0xE1FFFFF0,0x1FF24FF8,0xFFFFFF87,
0x1FFF7FFC,0xF9FFFFFF,0xFEFFFF07,0xFFFFFF1F,0xE77FFEE7,0xFFFFFFFF,0x070000F0,
0x87FFFFFF,0x138F78E4,0xF0FFFFF0,0x00F3CF00,0xFFFFFF0F,0x3FFE3FFE,0xF9FFFFFF,
0xFCFFFF87,0xFFFFFF1F,0xC77FFEE3,0xFFFFFFFF,0x030000E0,0x8FFFFFFF,0x939FFCE4,
0xFCFFFFF8,0xC0F3CF03,0xFFFFFF3F,0x7FFC1FFF,0xF9FFFFFF,0xFCFFFF83,0xFFFFFF3F,
0x8F7FFEF1,0xFFFFFFFF,0xE0FFFF83,0x8FFFFFFF,0x939FFCE4,0xFFFFFFF8,0xFFE3C7FF,
0xFFFFFFFF,0xFFF087FF,0xF8FFFFFF,0xF8FFFFE3,0xFFFFFF7F,0x1FFFFFF8,0xFFFFFFFF,
0xF8FFFF0F,0x1FFFFF7F,0x839FFCE0,0xFFFF7FFC,0xFFE7E7FF,0xFFFFFFFF,0xFFC1C1FF,
0xFCFFFFFF,0xF0FFFFFF,0xFFFFFFFF,0x3FFC3FFC,0xFEFFFFFF,0xFCFFFF1F,0x3FFEFF3F,
0xC39FFCE1,0xFFFF3FFE,0xFF87E1FF,0xFFFFFFFF,0xFFC7F1FF,0xFCFFFFFF,0xE1FFFF7F,
0xFFFFFFFF,0x7FF81FFE,0xFCFFFFFF,0x00000000,0x1FFCFF1F,0xC31FFCE1,0xFFFF1FFC,
0xFF0FF0FF,0xFFFFFFFF,0xFFE3E3FF,0xFEFFFFFF,0xC3FFFF33,0xFFFFFFFF,0xFFF18FFF,
0xFCFFFFFF,0x00000000,0x8FF8FF1F,0xC33FFEE1,0xFFFF8FF8,0xFF1FF8FF,0xFFFFFFFF,
0xFFF3E7FF,0xFFFFFFFF,0x877FFE11,0xFFFFFFFF,0xFFE3C7FF,0xFCFFFFFF,0xFFFFFFFF,
0xCFF9FF9F,0xE33FFEE3,0xFFFFCFF9,0xFF7FFEFF,0xFFFFFFFF,0xFFF1C7FF,0xFFFFFFFF,
0x0F7E9E90,0xFFFFFFFF,0xFF87E1FF,0xFCFFFFFF,0xFFFFFFFF,0x8FF8FF9F,0xE33FFEE3,
0xFFFF8FF8,0xFF7FFEFF,0xFFFFFFFF,0xFFF9CFFF,0xFFFFFFFF,0x3F701E98,0xFFFFFFFF,
0xFF1FF8FF,0xFCFFFFFF,0xFFFFFFFF,0x1FFCFF9F,0xE33FFEE3,0xFFFF1FFC,0xFF7FFEFF,
0xFFFFFFFF,0xFFF9CFFF,0xFFFFFFFF,0xFF001E9E,0xFFFFFFFF,0xFF1FF8FF,0xFCFFFFFF,
0x0FE003F8,0x3FFEFF9F,0xC13FFEC1,0xFFFF3FFE,0xFF7FFEFF,0xFFFFFFFF,0xFFF1C7FF,
0xFFFFFFFF,0xFF030E9C,0xFFFFFFFF,0xFF8FF1FF,0xFCFFFFFF,0x0FE003F8,0xFFFFFF9F,
0x883FFE88,0xFFFFFFFF,0xFF7FFEFF,0xFFFFFFFF,0xFFF3E7FF,0xFFFFFFFF,0xFF7F0C18,
0xFFFFFFFF,0xFFCFF3FF,0xFCFFFFFF,0xCFE7F3F9,0xFFFFFF9F,0x9C1FFC9C,0xFFFFFFFF,
0xFF07E0FF,0xFFFFFFFF,0xFFC3E1FF,0xFFFFFFFF,0xFFFFCC30,0xFFFFFFFF,0xFFCFF3FF,
0xFCFFFFFF,0xCFE7F3F9,0xFFFFFF9F,0x888FF888,0xFFFFFFFF,0xFF07E0FF,0xFFFFFFFF,
0xFF07F0FF,0xFFFFFFFF,0xFFFFC823,0xFFFFFFFF,0xFFCFF3FF,0xFCFFFFFF,0xC007F001,
0xFFFFFF1F,0xC1CFF9C1,0xFFFFFFFF,0xFF7FFEFF,0xFFFFFFFF,0xFF1FFCFF,0xFFFFFFFF,
0xFFFFE107,0xFFFFFFFF,0xFF8FF1FF,0xFCFFFFFF,0xC007F001,0xFFFFFF1F,0xE38FF8E3,
0xFFFFFFFF,0xFF7FFEFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFE10F,0xFFFFFFFF,
0xFF1FF8FF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFF1FFCFF,0xFFFFFFFF,0xFF7FFEFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFF3BF,0xFFFFFFFF,0xFF3FFCFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFF3FFEFF,0xFFFFFFFF,0xFF7FFEFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0x0000FFFF};

unsigned long set80[4816]={
0x4B3E4D42,0x00000000,0x003E0000,0x00280000,0x01E00000,0x01400000,0x00010000,
0x00000001,0x4B000000,0x00000000,0x00000000,0x00020000,0x00020000,0x00000000,
0xFFFF0000,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xC0FFFFFF,0x00000000,0xDFFF7F00,0xFFFFFFFF,
0xFFFBFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0000F8FF,0xFFFFFF3F,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xC0FFFFFF,0x00000000,0x87FF7F00,
0xFC3FC0FF,0xFFE1FF03,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x000000FF,0xFFFFFF01,
0xFFFFFFFF,0xFFFF03C0,0xFFFFFFFF,0x00000000,0xFFFF0000,0xC0FFFFFF,0x00000000,
0x80FF7F00,0xF00F0070,0xFF010E00,0x0000F8FF,0x00000000,0xFFFFFF3F,0x000000F0,
0xFFFF1F00,0xF0FFFFFF,0xFF0F0000,0xFFFFFFFF,0x00000000,0xFFFF0000,0xC0FFFFFF,
0x00000000,0x00FF7F00,0xC0030000,0xFF000000,0x0000F8FF,0x00000000,0xFFFFFF3F,
0x000000C0,0xFFFF0700,0x00FFFFFF,0xFF000000,0xFFFFFFFF,0x00000000,0xFFFF0000,
0xC0FFFFFF,0x00000000,0x00FF7F00,0x80010000,0xFF000000,0x0000F8FF,0x00000000,
0xFFFFFF3F,0x00000000,0xFFFF0100,0x00F8FFFF,0x1F000000,0xFFFFFFFF,0x00000000,
0xFFFF0000,0xC0FFFFFF,0x00000000,0x00FE7F00,0x80010000,0x7F000000,0x0000F8FF,
0x00000000,0xFFFFFF3F,0x00000000,0xFFFF0100,0x00E0FFFF,0x07000000,0xFFFFFFFF,
0x00000000,0xFFFF0000,0xC0FFFFFF,0x00000000,0x00FE7F00,0x00000000,0x7F000000,
0x0000F8FF,0x00000000,0xFFFFFF3F,0x00000080,0xFFFF0300,0x00C0FFFF,0x03000000,
0xFFFFFFFF,0x00000000,0xFFFF0000,0xE0FFFFFF,0x00000000,0x00FC7F00,0x00000000,
0x3F000000,0x0000F8FF,0x00000000,0xFFFFFF3F,0x00000080,0xFFFF0300,0x0080FFFF,
0x01000000,0xFFFFFFFF,0x00000000,0xFFFF0000,0xE0FFFFFF,0x00000000,0x00FE7F00,
0x00000000,0x7F000000,0x0000F8FF,0x00000000,0xFFFFFF3F,0x000000C0,0xFFFF0700,
0x00C0FFFF,0x03000000,0xFFFFFFFF,0x00000000,0xFFFF0000,0xE0FFFFFF,0x00000000,
0x00FF7F00,0x00000000,0xFF000000,0x0000F8FF,0x00000000,0xFFFFFF3F,0x000000C0,
0xFFFF0700,0x00C0FFFF,0x03000000,0xFFFFFFFF,0x00000000,0xFFFF0000,0xF0FFFFFF,
0x00000000,0xC0FF7F00,0x0000FC00,0xFF03003F,0x00C0FFFF,0x07000000,0xFFFFFFFF,
0x000000E0,0xFFFF0F00,0x00E0FFFF,0x07000000,0xFFFFFFFF,0x00000000,0xFFFF0000,
0xF0FFFFFF,0x00000000,0xF8FF7F00,0x0000FF1F,0xFF1FF8FF,0x00C0FFFF,0x07000000,
0xFFFFFFFF,0x000000E0,0xFFFF0F00,0x00E0FFFF,0x07000000,0xFFFFFFFF,0x00000080,
0xFFFF0100,0xF8FFFFFF,0x00000000,0xFFFF7F00,0x0180FFFF,0xFFFFFFFF,0x00C0FFFF,
0x07000000,0xFFFFFFFF,0x000000E0,0xFFFF0F00,0x00E0FFFF,0x07000000,0xFFFFFFFF,
0x00000080,0xFFFF0100,0xFC9FFFFF,0x00000000,0xFFFFFF00,0x0180FFFF,0xFFFFFFFF,
0x00C0FFFF,0x07000000,0xFFFFFFFF,0x000000E0,0xFFFF0F00,0x00E0FFFF,0x07000000,
0xFFFFFFFF,0x00000080,0xFFFF0100,0xFE07FCFF,0x00000000,0xFFFFFF00,0x0000F0FF,
0xFFFFFF0F,0x00C0FFFF,0x07000000,0xFFFFFFFF,0x000000E0,0xFFFF0F00,0x00E0FFFF,
0x07000000,0xFFFFFFFF,0x000000C0,0xFFFF0300,0xFF03F0FF,0x00000000,0xFFFFFF00,
0x0000C0FF,0xFFFFFF03,0x00C0FFFF,0x07000000,0xFFFFFFFF,0x000000C0,0xFFFF0700,
0x00E0FFFF,0x07000000,0xFFFFFFFF,0x000000C0,0xFFFF0300,0xFF01E0FF,0x00000080,
0xFFFFFF00,0x000080FF,0xFFFFFF01,0x00C0FFFF,0x07000000,0xFFFFFFFF,0x000000C0,
0xFFFF0700,0x00C0FFFF,0x03000000,0xFFFFFFFF,0x000000E0,0xFFFF0700,0xFF00C0FF,
0x000000C0,0xFFFFFF00,0x000080FF,0xFFFFFF01,0x00E0FFFF,0x0F000000,0xFFFFFFFF,
0x00000080,0xFFFF0300,0x00C0FFFF,0x03000000,0xFFFFFFFF,0x000000E0,0xFFFF0700,
0x7F0080FF,0x000000E0,0xFFFFFF00,0x000080FF,0xFFFFFF01,0x00F8FFFF,0x3F000000,
0xFFFFFFFF,0x00000000,0xFFFF0100,0x00C0FFFF,0x03000000,0xFFFFFFFF,0x000000F0,
0xFFFF0F00,0x7F0000FF,0x000000F0,0xFFFFFF00,0x0000C0FF,0xFFFFFF03,0x00FCFFFF,
0x7F000000,0xFEFFFFFF,0x00000000,0xFFFF0000,0x0080FFFF,0x01000000,0xFFFFFFFF,
0x000000F0,0xFFFF0F00,0x3F0000FF,0x000000F8,0xFFFFFF00,0x0000C0FF,0xFFFFFF03,
0x00FEFFFF,0xFF000000,0xFEFFFFFF,0x00000000,0xFFFF0000,0x0000FFFF,0x00000000,
0xFFFFFFFF,0x000000F8,0xFFFF1F00,0x1F0000FE,0x000000FC,0xFFFFFF00,0x0000C0FF,
0xFFFFFF03,0x00FFFFFF,0xFF010000,0xFCFFFFFF,0x00000000,0xFF7F0000,0x0000FEFF,
0x00000000,0xFFFFFF7F,0x000000FC,0xFFFF3F00,0x0F0000FE,0x000000FC,0xFFFFFF01,
0x0000C0FF,0xFFFFFF03,0x00FFFFFF,0xFF010000,0xFCFFFFFF,0x00000000,0xFF7F0000,
0x0000FCFF,0x00000000,0xFFFFFF3F,0x000000FE,0xFFFF7F00,0x070000FE,0x000000FE,
0xFFFFFF01,0x0000E0FF,0xFFFFFF07,0x00FFFFFF,0xFF010000,0xFCFFFFFF,0x00000000,
0xFF7F0000,0x0000F8FF,0x00000000,0xFFFFFF1F,0x000000FF,0xFFFFFF00,0x030000FE,
0x000000FE,0xFFFFFF01,0x0000E0FF,0xFFFFFF07,0x00FFFFFF,0xFF010000,0xFCFFFFFF,
0x00000000,0xFF7F0000,0x0000F0FF,0x00000000,0xFFFFFF0F,0x0000C0FF,0xFFFFFF03,
0x010000FE,0x000000FF,0xFFFFFF01,0x0000E0FF,0xFFFFFF07,0x00FFFFFF,0xFF010000,
0xF8FFFFFF,0x00000000,0xFF3F0000,0x0000E0FF,0x00000000,0xFFFFFF07,0x0000F0FF,
0xFFFFFF0F,0x000000FE,0x0000001F,0xFFFFFF01,0x0000E0FF,0xFFFFFF07,0x00FFFFFF,
0xFF010000,0xF8FFFFFF,0x00000000,0xFF3F0000,0x0000C0FF,0x00000000,0xFFFFFF03,
0x0000FCFF,0xFFFFFF3F,0x000000FE,0x00008007,0xFFFFFF03,0x0000C0FF,0xFFFFFF03,
0x00FFFFFF,0xFF010000,0xF8FFFFFF,0x00000000,0xFF3F0000,0x0000C0FF,0x00000000,
0xFFFFFF03,0x0000FFFF,0xFFFFFFFF,0x000000FF,0x00008003,0xFFFFFF03,0x000080FF,
0xFFFFFF01,0x00FFFFFF,0xFF010000,0xF8FFFFFF,0x00000000,0xFF3F0000,0x000080FF,
0x00000000,0xFFFFFF01,0x0000FCFF,0xFFFFFF3F,0x000000FF,0x00008001,0xFFFFFF03,
0x000000FF,0xFFFFFF00,0x00FFFFFF,0xFF010000,0xF0FFFFFF,0x00000000,0xFF1F0000,
0x000080FF,0x00000000,0xFFFFFF01,0x0000F8FF,0xFFFFFF1F,0x000080FF,0x00008000,
0xFFFFFF03,0x000000FF,0xFFFFFF00,0x00FFFFFF,0xFF010000,0xF0FFFFFF,0x00000004,
0xFF1F4000,0x000080FF,0x00000000,0xFFFFFF01,0x0000F0FF,0xFFFFFF0F,0x000080FF,
0x00000000,0xFFFFFF07,0x000000FE,0xFFFF7F00,0x00FFFFFF,0xFF010000,0xF0FFFFFF,
0x00000004,0xFF1F4000,0x000000FF,0x00000000,0xFFFFFF00,0x0000E0FF,0xFFFFFF07,
0x0000C0FF,0x00000000,0xFFFFFF07,0x000000FE,0xFFFF7F00,0x00FFFFFF,0xFF010000,
0xF0FFFFFF,0x0000000C,0xFF1F6000,0x000000FF,0x00000000,0xFFFFFF00,0x0000E0FF,
0xFFFFFF07,0x0000E0FF,0x00000000,0xFFFFFF07,0x000000FC,0xFFFF3F00,0x00FFFFFF,
0xFF010000,0xF0FFFFFF,0x06C0000C,0xFF1F6000,0x000000FF,0x00000000,0xFFFFFF00,
0x0000C0FF,0xFFFFFF03,0x0000E0FF,0x00000000,0xFFFFFF0F,0x000000FC,0xFFFF3F00,
0x00FFFFFF,0xFF010000,0xE0FFFFFF,0x06C0001C,0xFF0F7000,0x000000FF,0x00000000,
0xFFFFFF00,0x0000C0FF,0xFFFFFF03,0x0000F0FF,0x00000000,0xFFFFFF0F,0x000000FC,
0xFFFF3F00,0x00FFFFFF,0xFF010000,0xE0FFFFFF,0x06C0001C,0xFF0F7000,0x000000FF,
0x00000000,0xFFFFFF00,0x000080FF,0xFFFFFF01,0x0000F0FF,0x00000000,0xFFFFFF0F,
0x000000F8,0xFFFF1F00,0x00FFFFFF,0xFF010000,0xE0FFFFFF,0x07C0013C,0xFF0F7800,
0x000000FF,0x00000000,0xFFFFFF00,0x000080FF,0xFFFFFF01,0x0000F8FF,0x00000000,
0xFFFFFF1F,0x000000F8,0xFFFF1F00,0x00FFFFFF,0xFF010000,0xE0FFFFFF,0x07C0013C,
0xFF0F7800,0x000000FF,0x00000000,0xFFFFFF00,0x000080FF,0xFFFFFF01,0x0000FCFF,
0x00000000,0xFFFFFF1F,0x000000F8,0xFFFF1F00,0x00FFFFFF,0xFF010000,0xE0FFFFFF,
0x0FE0017C,0xFF0F7C00,0x000000FF,0x00000000,0xFFFFFF00,0x000080FF,0xFFFFFF01,
0x0000FCFF,0x00000000,0xFFFFFF3F,0x000000F8,0xFFFF1F00,0x00FFFFFF,0xFF010000,
0xC0FFFFFF,0x0FE0037C,0xFF077C80,0x000080FF,0x00000000,0xFFFFFF01,0x000080FF,
0xFFFFFF01,0x0000FEFF,0x00000000,0xFFFFFF3F,0x000000F8,0xFFFF1F00,0x00FFFFFF,
0xFF010000,0xC0FFFFFF,0x0FE003FC,0xFF077E80,0x000080FF,0x00000000,0xFFFFFF01,
0x000080FF,0xFFFFFF01,0x0000FEFF,0x00000000,0xFFFFFF7F,0x000000F8,0xFFFF1F00,
0x00FFFFFF,0xFF010000,0xC0FFFFFF,0x0FE003FC,0xFF077E80,0x000080FF,0x00000420,
0xFFFFFF01,0x0000C0FF,0xFFFFFF03,0x0000FFFF,0x00000000,0xFFFFFF7F,0x000000FC,
0xFFFF3F00,0x00FFFFFF,0xFF010000,0xC1FFFFFF,0x0FE007FC,0xFF077FC0,0x0000C0FF,
0x00000660,0xFFFFFF03,0x0000C0FF,0xFFFFFF03,0x0000FFFF,0x00000000,0xFFFFFFFF,
0x000000FC,0xFFFF3F00,0x00FFFFFF,0xFF010000,0xC1FFFFFF,0x1FF007FC,0xFF077FC0,
0x0000E0FF,0x000003C0,0xFFFFFF07,0x0000E0FF,0xFFFFFF07,0x0000FFFF,0x00000000,
0xFFFFFFFF,0x000000FC,0xFFFF3F00,0x00FFFFFF,0xFF010000,0x83FFFFFF,0x1FF007FC,
0xFF837FC0,0x0100F0FF,0x008003C0,0xFFFFFF0F,0x0000E0FF,0xFFFFFF07,0x0000FFFF,
0x01000000,0xFFFFFFFF,0x000000FE,0xFFFF7F00,0x00FFFFFF,0xFF010000,0x83FFFFFF,
0x1FF00FFC,0xFF837FE0,0x0300F8FF,0x00C00180,0xFFFFFF1F,0x0000F0FF,0xFFFFFF0F,
0x0000FFFF,0x01000000,0xFFFFFFFF,0x000000FE,0xFFFF7F00,0x00FEFFFF,0xFF000000,
0x87FFFFFF,0x1FF00FFC,0xFFC37FE0,0x0F00FEFF,0x00F00180,0xFFFFFF7F,0x0000F8FF,
0xFFFFFF1F,0x0000FFFF,0x03000000,0xFFFFFFFF,0x000000FF,0xFFFFFF00,0x00FCFFFF,
0x7F000000,0x87FFFFFF,0x1FF00FFC,0xFFC37FE0,0x7FC0FFFF,0x03FE0180,0xFFFFFFFF,
0x0000FCFF,0xFFFFFF3F,0x0080FFFF,0x07000000,0xFFFFFFFF,0x000080FF,0xFFFFFF01,
0x00F8FFFF,0x3F000000,0x0FFFFFFF,0x3FF81FFC,0xFFE17FF0,0xFFFFFFFF,0xFFFF0180,
0xFFFFFFFF,0x0000FFFF,0xFFFFFFFF,0x0080FFFF,0x0F000000,0xFFFFFFFF,0x0000C0FF,
0xFFFFFF03,0x00F0FFFF,0x1F000000,0x1FFCFFFF,0x3FF81FFC,0x7FF07FF0,0xFFFFFFFF,
0xFFFF0180,0xFFFFFFFF,0x07E0FFFF,0xFFFFFFFF,0x00C0FFFF,0x1F000000,0xFFFFFFFF,
0x0000E0FF,0xFFFFFF07,0x00E0FFFF,0x0F000000,0x0FF8FFFF,0x3FF81FFC,0x3FE07FF0,
0xFFFFFFFF,0xFFFF03C0,0xFFFFFFFF,0x03C0FFFF,0xFFFFFFFF,0x00C0FFFF,0x3F000000,
0xFFFFFFFF,0x0000F8FF,0xFFFFFF1F,0x00C0FFFF,0x07000000,0x07F0FFFF,0x3FF83FFC,
0x1FC07FF8,0xFFFFFFFF,0xFFFF03C0,0xFFFFFFFF,0x0180FFFF,0xFFFFFFFF,0x00E0FFFF,
0x7F000000,0xFFFFFFFF,0x0000FEFF,0xFFFFFF7F,0x00C0FFFF,0x07000000,0x07F0FFFF,
0x3FF83FFC,0x1FC07FF8,0xFFFFFFFF,0xFFFF07E0,0xFFFFFFFF,0x0180FFFF,0xFFFFFFFF,
0x00E0FFFF,0xFF000000,0xFFFFFFFF,0x0000FFFF,0xFFFFFFFF,0x00C0FFFF,0x07000000,
0x07F0FFFF,0x7FFC3FFC,0x1FC07FF8,0xFFFFFFFF,0xFFFF0FF0,0xFFFFFFFF,0x0000FFFF,
0xFFFFFFFF,0x00F0FFFF,0xFF030000,0xFFFFFFFF,0x03C0FFFF,0xFFFFFFFF,0x00C0FFFF,
0x07000000,0x07F0FFFF,0x7FFC7FFC,0x1FC07FFC,0xFFFFFFFF,0xFFFF3FFC,0xFFFFFFFF,
0x0000FFFF,0xFFFFFFFF,0x00F8FFFF,0xFF070000,0xFFFFFFFF,0x07E0FFFF,0xFFFFFFFF,
0x00C0FFFF,0x07000000,0x07F0FFFF,0x7FFC7FFC,0x1FC07FFC,0xFFFFFFFF,0xFFFF7FFE,
0xFFFFFFFF,0x0000FFFF,0xFFFFFFFF,0x00F8FFFF,0xFF1F0000,0xFFFFFFFF,0x0FF0FFFF,
0xFFFFFFFF,0x00C0FFFF,0x07000000,0x0FF8FFFF,0x7FFC3FF8,0x3FE03FF8,0xFFFFFFFF,
0xFFFF7FFE,0xFFFFFFFF,0x0000FFFF,0xFFFFFFFF,0x00F8FFFF,0xFFFF0000,0xFFFFFFFF,
0x3FFCFFFF,0xFFFFFFFF,0x00C0FFFF,0x07000000,0x1FFCFFFF,0x7FFC1FF0,0x7FF01FF0,
0xFFFFFFFF,0xFFFF7FFE,0xFFFFFFFF,0x0000FFFF,0xFFFFFFFF,0x07F8FFFF,0xFFFF7F00,
0xFFFFFFFF,0x0FF0FFFF,0xFFFFFFFF,0x00C0FFFF,0x07000000,0xFFFFFFFF,0x3FF80FE0,
0xFFFF0FE0,0xFFFFFFFF,0xFFFF7FFE,0xFFFFFFFF,0x0000FFFF,0xFFFFFFFF,0x0FF0FFFF,
0xFFFFFF00,0xFFFFFFFF,0x07E0FFFF,0xFFFFFFFF,0x0FC0FFFF,0x07E007C0,0xFFFFFFFF,
0x1FF00FE0,0xFFFF0FE0,0xFFFFFFFF,0xFFFF7FFE,0xFFFFFFFF,0x0180FFFF,0xFFFFFFFF,
0x1FF0FFFF,0xFFFFFF80,0xFFFFFFFF,0x07E0FFFF,0xFFFFFFFF,0x0FC0FFFF,0x07E007C0,
0xFFFFFFFF,0x0FE00FE0,0xFFFF0FE0,0xFFFFFFFF,0xFFFF07E0,0xFFFFFFFF,0x0180FFFF,
0xFFFFFFFF,0x3FF0FFFF,0xFFFFFF81,0xFFFFFFFF,0x03C0FFFF,0xFFFFFFFF,0x0FC0FFFF,
0x07E007C0,0xFFFFFFFF,0x0FE00FE0,0xFFFF0FE0,0xFFFFFFFF,0xFFFF07E0,0xFFFFFFFF,
0x03C0FFFF,0xFFFFFFFF,0x7FF0FFFF,0xFFFFFFC1,0xFFFFFFFF,0x03C0FFFF,0xFFFFFFFF,
0x0FC0FFFF,0x07E007C0,0xFFFFFFFF,0x0FE00FE0,0xFFFF0FE0,0xFFFFFFFF,0xFFFF7FFE,
0xFFFFFFFF,0x07E0FFFF,0xFFFFFFFF,0xFFF8FFFF,0xFFFFFFC3,0xFFFFFFFF,0x03C0FFFF,
0xFFFFFFFF,0x0FC0FFFF,0x07E007C0,0xFFFFFFFF,0x0FE01FF0,0xFFFF1FF0,0xFFFFFFFF,
0xFFFF7FFE,0xFFFFFFFF,0x1FF8FFFF,0xFFFFFFFF,0xFFF9FFFF,0xFFFFFFC3,0xFFFFFFFF,
0x07E0FFFF,0xFFFFFFFF,0x0FC0FFFF,0x07E007C0,0xFFFFFFFF,0x0FE03FF8,0xFFFF3FF8,
0xFFFFFFFF,0xFFFF7FFE,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFE7,
0xFFFFFFFF,0x07E0FFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x1FF0FFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFF7FFE,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFE7,0xFFFFFFFF,0x0FF0FFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0x3FF8FFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFF7FFE,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x3FFCFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xC0FFFFFF,
0x00000000,0xDFFF7F00,0xFFFFFFFF,0xFFFBFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0x0000F8FF,0xFFFFFF3F,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xC0FFFFFF,0x00000000,0x87FF7F00,0xFC3FC0FF,0xFFE1FF03,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0x000000FF,0xFFFFFF01,0xFFFFFFFF,0xFFFF03C0,0xFFFFFFFF,0x00000000,
0xFFFF0000,0xC0FFFFFF,0x00000000,0x80FF7F00,0xF00F0070,0xFF010E00,0x0000F8FF,
0x00000000,0xFFFFFF3F,0x000000F0,0xFFFF1F00,0xF0FFFFFF,0xFF0F0000,0xFFFFFFFF,
0x00000000,0xFFFF0000,0xC0FFFFFF,0x00000000,0x00FF7F38,0xC0030000,0xFF000000,
0x0000F8FF,0x00000000,0xFFFFFF3F,0x000000C0,0xFFFF0700,0x00FFFFFF,0xFF000000,
0xFFFFFFFF,0x00000000,0xFFFF0000,0xC0FFFFFF,0x00000000,0x00FF7F38,0x80010000,
0xFF000000,0x0000F8FF,0x00000000,0xFFFFFF3F,0x00000000,0xFFFF0100,0x00F8FFFF,
0x1F000000,0xFFFFFFFF,0x00000000,0xFFFF0000,0xC0FFFFFF,0x00000000,0x00FE7F38,
0x80010000,0x7F000000,0x0000F8FF,0x00000000,0xFFFFFF3F,0x0000001C,0xFFFF7100,
0x00E0FFFF,0x07000000,0xFFFFFFFF,0x00000000,0xFFFF0000,0xC0FFFFFF,0x00000000,
0x00FE7F38,0x00000000,0x7F000000,0x0000F8FF,0x00000000,0xFFFFFF3F,0x0000809F,
0xFFFFF303,0x00C6FFFF,0x63000000,0xFFFFFFFF,0x00000000,0xFFFF0000,0xE0FFFFFF,
0x00000000,0x00FC7F38,0x00000000,0x3F000000,0x0000F8FF,0x00000000,0xFFFFFF3F,
0x0000FE8F,0xFFFFE3FF,0xE08FFFFF,0xF1070000,0xFFFFFFFF,0x00000000,0xFFFF0000,
0xE0FFFFFF,0x00000000,0x00FE7F38,0x00000000,0x7F000000,0xFF1FF8FF,0xF0FFFFFF,
0xFFFFFF3F,0xFFFFFFC7,0xFFFFC7FF,0xFFC7FFFF,0xE3FF03C0,0xFFFFFFFF,0x00000000,
0xFFFF0000,0xE0FFFFFF,0x00000000,0x00FF7F38,0x00000000,0xFF000000,0xFF1FF8FF,
0xF0FFFFFF,0xFFFFFF3F,0xFFFFFFC0,0xFFFF07FE,0xFFC1FFFF,0x83FFFFFF,0xFFFFFFFF,
0x00000000,0xFFFF0000,0xF0FFFFFF,0x00000000,0xC0FF7F38,0x781EFC00,0xFF03003F,
0xFFCFFFFF,0xE7FFFFFF,0xFFFFFFFF,0xFFFF03E0,0xFFFF0F80,0x1FE0FFFF,0x07F8FFFF,
0xFFFFFFFF,0x00000000,0xFFFF0000,0xF0FFFFFF,0x00000000,0xF8FF7F38,0x781EFF1F,
0xFF1FF8FF,0x00C0FFFF,0x07000000,0xFFFFFFFF,0x000000E0,0xFFFF0F00,0x00E6FFFF,
0x6700FC3F,0xFFFFFFFF,0x00000080,0xFFFF0100,0xF8FFFFFF,0x00000000,0xFFFF7F78,
0x718EFFFF,0xFFFFFFFF,0x00C0FFFF,0x07000000,0xFFFFFFFF,0x000000E6,0xFFFFCF00,
0xE0E7FFFF,0xE7070000,0xFFFFFFFF,0x00000080,0xFFFF0100,0xFC9FFFFF,0x00000000,
0xFFFFFF70,0x0180FFFF,0xFFFFFFFF,0x00C0FFFF,0x07000000,0xFFFFFFFF,0x0000E0E7,
0xFFFFCF0F,0xFFE7FFFF,0xE7FF0180,0xFFFFFFFF,0x00000080,0xFFFF0100,0xFE07FCFF,
0x00000000,0xFFFFFF70,0x0000F0FF,0xFFFFFF0F,0xFFCFFFFF,0xE7FFFFFF,0xFFFFFFFF,
0x0380FFE7,0xFFFFCFFF,0xFFE1FFFF,0x87FFFFFF,0xFFFFFFFF,0x000000C0,0xFFFF0300,
0xFF03F0FF,0x00000000,0xFFFFFF70,0x0000C0FF,0xFFFFFF03,0xFFCFFFFF,0xE7FFFFFF,
0xFFFFFFFF,0xFFFFFFC3,0xFFFF87FF,0x1FE0FFFF,0x07F8FFFF,0xFFFFFFFF,0x000000C0,
0xFFFF0300,0xFF41E0FF,0x00000080,0xFFFFFF70,0x000080FF,0xFFFFFF01,0xFFCFFFFF,
0xE7FFFFFF,0xFFFFFFFF,0xFFFF3FC0,0xFFFF07F8,0x00C0FFFF,0x0300FE7F,0xFFFFFFFF,
0x000000E0,0xFFFF0700,0xFFC0C0FF,0x000000C0,0xFFFFFF70,0x00009CFF,0xFFFFFF39,
0x00E0FFFF,0x0F000000,0xFFFFFFFF,0xFEFF0080,0xFFFF0300,0x00C0FFFF,0x03000000,
0xFFFFFFFF,0x000000E0,0xFFFF0700,0x7FE080FF,0x000000E0,0xFFFFFF70,0x0FF09FFF,
0xFFFFFFF9,0x00F8FFFF,0x3F000000,0xFFFFFFFF,0x00000018,0xFFFF3100,0x00C0FFFF,
0x03000000,0xFFFFFFFF,0x000000F0,0xFFFF0F00,0x7F7000FF,0x000000F0,0xFFFFFF70,
0xFFFFCFFF,0xFFFFFFF3,0x00FCFFFF,0x7F000000,0xFEFFFFFF,0x0000803F,0xFFFFF803,
0x008EFFFF,0x71000000,0xFFFFFFFF,0x000000F0,0xFFFF0F00,0x3F3000FF,0x000000F8,
0xFFFFFF70,0xFFFFC7FF,0xFFFFFFE3,0x7FFEFFFF,0xFFFCFFFF,0xFEFFFFFF,0x0100FF1F,
0xFFFFF0FF,0xE01FFFFF,0xF8070000,0xFFFFFFFF,0x000000F8,0xFFFF1F00,0x1F2000FE,
0x000000FC,0xFFFFFFF0,0xF81FC0FF,0xFFFFFF03,0x3FFFFFFF,0xFFF9FFFF,0xFCFFFFFF,
0xFFFFFF0F,0xFF7FE0FF,0xFF3FFEFF,0xFCFF0180,0xFFFFFF7F,0x000000FC,0xFFFF3F00,
0x0F0018FE,0x000000FC,0xFFFFFFE1,0x0000C0FF,0xFFFFFF03,0x3FFFFFFF,0xFFF9FFFF,
0xFCFFFFFF,0xFFFFFF00,0xFF7F00FE,0xFF7BFCFF,0xDEFF7FFE,0xFFFFFF3F,0x000000FE,
0xFFFF7F00,0x07003CFE,0x000000FE,0xFFFFFFE1,0x0000E4FF,0xFFFFFF27,0x00FFFFFF,
0xFF010000,0xFCFFFFFF,0xFFFF0100,0xFF7F0000,0x3FF0F8FF,0x0FFC7FFE,0xFFFFFF1F,
0x000000FF,0xFFFFFF00,0x03001CFE,0x000000FE,0xFFFFFFE1,0x07E0E7FF,0xFFFFFFE7,
0x00FFFFFF,0xFF010000,0xFCFFFFFF,0x00000000,0xFF7F0000,0x00E0F1FF,0x07007FFE,
0xFFFFFF8F,0x0000C0FF,0xFFFFFF03,0x01001EFE,0x000000FF,0xFFFFFFE1,0xFFFFE7FF,
0xFFFFFFE7,0x00FFFFFF,0xFF010000,0xF8FFFFFF,0x00000000,0xFF3F0000,0x00C0E3FF,
0x0300700E,0xFFFFFFC7,0x0000F0FF,0xFFFFFF0F,0x00000EFE,0x0100001F,0xFFFFFFE1,
0xFFFFE3FF,0xFFFFFFC7,0x00FFFFFF,0xFF010000,0xF8FFFFFF,0x00000000,0xFF3F0000,
0x0080C7FF,0x0100700E,0xFFFFFFE3,0x0000FCFF,0xFFFFFF3F,0x000006FE,0x01008007,
0xFFFFFFC3,0xFC3FC0FF,0xFFFFFF03,0x00FFFFFF,0xFF010000,0xF8FFFFFF,0x00000000,
0xFF3F0000,0x0000CFFF,0x0000700E,0xFFFFFFF3,0x0000FFFF,0xFFFFFFFF,0x000000FF,
0x01008003,0xFFFFFFC3,0x000080FF,0xFFFFFF01,0x00FFFFFF,0xFF010000,0xF8FFFFFF,
0x00000000,0xFF3F0000,0x00008EFF,0x0000781E,0xFFFFFF71,0x0000FCFF,0xFFFFFF3F,
0x000000FF,0x01008001,0xFFFFFFC3,0x000000FF,0xFFFFFF00,0x00FFFFFF,0xFF010000,
0xF0FFFFFF,0x00000000,0xFF1F0000,0x00009EFF,0x0000381C,0xFFFFFF79,0x0000F8FF,
0xFFFFFF1F,0x000080FF,0x03008000,0xFFFFFFC3,0x000000FF,0xFFFFFF00,0x00FFFFFF,
0xFF010000,0xF0FFFFFF,0x00000004,0xFF1F4000,0x00009CFF,0x0000381C,0xFFFFFF39,
0x0000F0FF,0xFFFFFF0F,0x000080FF,0x03000000,0xFFFFFF87,0x000000FE,0xFFFF7F00,
0x00FFFFFF,0xFF010000,0xF0FFFFFF,0x00000004,0xFF1F4000,0x00001CFF,0x0000381C,
0xFFFFFF38,0x0000E0FF,0xFFFFFF07,0x0000C0FF,0x03000000,0xFFFFFF87,0x000000FE,
0xFFFF7F00,0x00FFFFFF,0xFF010000,0xF0FFFFFF,0x0000000C,0xFF1F6000,0x00003CFF,
0x00003C3C,0xFFFFFF3C,0x0000E0FF,0xFFFFFF07,0x0000E0FF,0x0700E000,0xFFFFFF87,
0x000000FC,0xFFFF3F00,0x00FFFFFF,0xFF010000,0xF0FFFFFF,0x06C0000C,0xFF1F6000,
0x000038FF,0x00001C38,0xFFFFFF1C,0x0000C0FF,0xFFFFFF03,0x0000E0FF,0x0700E000,
0xFFFFFF0F,0xC00100FC,0xFFFF3F00,0x00FFFFFF,0xFF010000,0xE0FFFFFF,0x06C0001C,
0xFF0F7000,0x000038FF,0x00009E79,0xFFFFFF1C,0x0000C0FF,0xFFFFFF03,0x0000F0FF,
0x07006000,0xFFFFFF0F,0xC00100FC,0xFFFF3F00,0x00FFFFFF,0xFF010000,0xE0FFFFFF,
0x06C0001C,0xFF0F7000,0x000038FF,0x00008E71,0xFFFFFF1C,0x000080FF,0xFFFFFF01,
0x0000F0FF,0x0F007000,0xFFFFFF0F,0xC00100F8,0xFFFF1F00,0x00FFFFFF,0xFF010000,
0xE0FFFFFF,0x07C0013C,0xFF0F7800,0x000038FF,0x00008FF1,0xFFFFFF1C,0x000080FF,
0xFFFFFF01,0x0000F8FF,0x0E007000,0xFFFFFF1F,0xC00100F8,0xFFFF1F00,0x00FFFFFF,
0xFF010000,0xE0FFFFFF,0x07C0013C,0xFF0F7800,0x01003CFF,0x0080C7E3,0xFFFFFF3C,
0x000080FF,0xFFFFFF01,0x0000FCFF,0x1E003000,0xFFFFFF1F,0xC00100F8,0xFFFF1F00,
0x00FFFFFF,0xFF010000,0xE0FFFFFF,0x0FE0017C,0xFF0F7C00,0x03001CFF,0x00C0C3C3,
0xFFFFFF38,0x000080FF,0xFFFFFF01,0x0000FCFF,0x1C003000,0xFFFFFF3F,0xC00100F8,
0xFFFF1F00,0x00FFFFFF,0xFF010000,0xC0FFFFFF,0x0FE0037C,0xFF077C80,0x07009CFF,
0x00E0C183,0xFFFFFF39,0x000080FF,0xFFFFFF01,0x0000FEFF,0x3C003000,0xFFFFFF3F,
0xFF7F00F8,0xFFFF1F00,0x00FFFFFF,0xFF010000,0xC0FFFFFF,0x0FE003FC,0xFF077E80,
0x0F009EFF,0x00F0E007,0xFFFFFF79,0x000080FF,0xFFFFFF01,0x0008FEFF,0x38003000,
0xFFFFFF7F,0xFF7F00F8,0xFFFF1F00,0x00FFFFFF,0xFF010000,0xC0FFFFFF,0x0FE003FC,
0xFF077E80,0x3E808FFF,0x017C6426,0xFFFFFFF1,0x0000C0FF,0xFFFFFF03,0xC00CFFFF,
0x78000000,0xFFFFFF7F,0xFF7F00FC,0xFFFF3F00,0x00FFFFFF,0xFF010000,0xC1FFFFFF,
0x0FE007FC,0xFF077FC0,0xFCF1C7FF,0x8F3F6666,0xFFFFFFE3,0x0000C0FF,0xFFFFFF03,
0xC00EFFFF,0x70000000,0xFFFFFFFF,0xC00100FC,0xFFFF3F00,0x00FFFFFF,0xFF010000,
0xC1FFFFFF,0x1FF007FC,0xFF077FC0,0xF8FFE3FF,0xFF1F73CE,0xFFFFFFC7,0x0000E0FF,
0xFFFFFF07,0xE007FFFF,0xF0000000,0xFFFFFFFF,0xC00100FC,0xFFFF3F00,0x3FFFFFFF,
0xFFF9FFFF,0x83FFFFFF,0x1FF007FC,0xFF837FC0,0xE1FFF0FF,0xFF8733CC,0xFFFFFF0F,
0x0000E0FF,0xFFFFFF07,0xC003FFFF,0xE1010000,0xFFFFFFFF,0xC00100FE,0xFFFF7F00,
0x3FFFFFFF,0xFFF9FFFF,0x83FFFFFF,0x1FF00FFC,0xFF837FE0,0x031FF8FF,0xF8C0318C,
0xFFFFFF1F,0x0000F0FF,0xFFFFFF0F,0xE001FFFF,0xE1010000,0xFFFFFFFF,0xC00100FE,
0xFFFF7F00,0x7FFEFFFF,0xFFFCFFFF,0x87FFFFFF,0x1FF00FFC,0xFFC37FE0,0x0F00FEFF,
0x00F0399C,0xFFFFFF7F,0x0000F8FF,0xFFFFFF1F,0xF000FFFF,0xC3030000,0xFFFFFFFF,
0xC00100FF,0xFFFFFF00,0x00FCFFFF,0x7F000000,0x87FFFFFF,0x1FF00FFC,0xFFC37FE0,
0x7FC0FFFF,0x03FE1998,0xFFFFFFFF,0x0000FCFF,0xFFFFFF3F,0x3080FFFF,0x87070000,
0xFFFFFFFF,0xC00180FF,0xFFFFFF01,0x00F8FFFF,0x3F000000,0x0FFFFFFF,0x3FF81FFC,
0xFFE17FF0,0xFFFFFFFF,0xFFFF399C,0xFFFFFFFF,0x0000FFFF,0xFFFFFFFF,0x0080FFFF,
0x0F0F0000,0xFFFFFFFF,0x0000C0FF,0xFFFFFF03,0x00F0FFFF,0x1F000000,0x1FFCFFFF,
0x3FF81FFC,0x7FF07FF0,0xFFFFFFFF,0xFFFF718E,0xFFFFFFFF,0x07E0FFFF,0xFFFFFFFF,
0x00C0FFFF,0x1F1E0000,0xFFFFFFFF,0x0000E0FF,0xFFFFFF07,0x00E0FFFF,0x0F000000,
0x0FF8FFFF,0x3FF81FFC,0x3FE07FF0,0xFFFFFFFF,0xFFFFF3CF,0xFFFFFFFF,0x03C0FFFF,
0xFFFFFFFF,0x00C0FFFF,0x3F3C0000,0xFFFFFFFF,0x0000F8FF,0xFFFFFF1F,0xFFCFFFFF,
0xE7FFFFFF,0x07F0FFFF,0x3FF83FFC,0x1FC07FF8,0xFFFFFFFF,0xFFFFE3C7,0xFFFFFFFF,
0x0180FFFF,0xFFFFFFFF,0xC0E1FFFF,0x7FF80000,0xFFFFFFFF,0x0000FEFF,0xFFFFFF7F,
0xFFCFFFFF,0xE7FFFFFF,0x07F0FFFF,0x3FF83FFC,0x1FC07FF8,0xFFFFFFFF,0xFFFF07E0,
0xFFFFFFFF,0x0180FFFF,0xFFFFFFFF,0xF8E1FFFF,0xFFE00700,0xFFFFFFFF,0x0000FFFF,
0xFFFFFFFF,0xFFCFFFFF,0xE7FFFFFF,0x07F0FFFF,0x7FFC3FFC,0x1FC07FF8,0xFFFFFFFF,
0xFFFF0FF0,0xFFFFFFFF,0x0000FFFF,0xFFFFFFFF,0x3EF0FFFF,0xFF837F00,0xFFFFFFFF,
0x03C0FFFF,0xFFFFFFFF,0x00C0FFFF,0x07000000,0x07F0FFFF,0x7FFC7FFC,0x1FC07FFC,
0xFFFFFFFF,0xFFFF3FFC,0xFFFFFFFF,0x0000FFFF,0xFFFFFFFF,0x07F8FFFF,0xFF077C00,
0xFFFFFFFF,0x07E0FFFF,0xFFFFFFFF,0x00C0FFFF,0x07000000,0x07F0FFFF,0x7FFC7FFC,
0x1FC07FFC,0xFFFFFFFF,0xFFFF7FFE,0xFFFFFFFF,0x0000FFFF,0xFFFFFFFF,0x00F8FFFF,
0xFF1F0000,0xFFFFFFFF,0x0FF0FFFF,0xFFFFFFFF,0x00C0FFFF,0x07000000,0x0FF8FFFF,
0x7FFC3FF8,0x3FE03FF8,0xFFFFFFFF,0xFFFF7FFE,0xFFFFFFFF,0x0000FFFF,0xFFFFFFFF,
0x00F8FFFF,0xFFFF0000,0xFFFFFFFF,0x3FFCFFFF,0xFFFFFFFF,0x00C0FFFF,0x07000000,
0x1FFCFFFF,0x7FFC1FF0,0x7FF01FF0,0xFFFFFFFF,0xFFFF7FFE,0xFFFFFFFF,0x0000FFFF,
0xFFFFFFFF,0x07F8FFFF,0xFFFF7F00,0xFFFFFFFF,0x0FF0FFFF,0xFFFFFFFF,0x00C0FFFF,
0x07000000,0xFFFFFFFF,0x3FF80FE0,0xFFFF0FE0,0xFFFFFFFF,0xFFFF7FFE,0xFFFFFFFF,
0x0000FFFF,0xFFFFFFFF,0x0FF0FFFF,0xFFFFFF00,0xFFFFFFFF,0x07E0FFFF,0xFFFFFFFF,
0x0FC0FFFF,0x07E007C0,0xFFFFFFFF,0x1FF00FE0,0xFFFF0FE0,0xFFFFFFFF,0xFFFF7FFE,
0xFFFFFFFF,0x0180FFFF,0xFFFFFFFF,0x1FF0FFFF,0xFFFFFF80,0xFFFFFFFF,0x07E0FFFF,
0xFFFFFFFF,0x0FC0FFFF,0x07E007C0,0xFFFFFFFF,0x0FE00FE0,0xFFFF0FE0,0xFFFFFFFF,
0xFFFF07E0,0xFFFFFFFF,0x0180FFFF,0xFFFFFFFF,0x3FF0FFFF,0xFFFFFF81,0xFFFFFFFF,
0x03C0FFFF,0xFFFFFFFF,0x0FC0FFFF,0x07E007C0,0xFFFFFFFF,0x0FE00FE0,0xFFFF0FE0,
0xFFFFFFFF,0xFFFF07E0,0xFFFFFFFF,0x03C0FFFF,0xFFFFFFFF,0x7FF0FFFF,0xFFFFFFC1,
0xFFFFFFFF,0x03C0FFFF,0xFFFFFFFF,0x0FC0FFFF,0x07E007C0,0xFFFFFFFF,0x0FE00FE0,
0xFFFF0FE0,0xFFFFFFFF,0xFFFF7FFE,0xFFFFFFFF,0x07E0FFFF,0xFFFFFFFF,0xFFF8FFFF,
0xFFFFFFC3,0xFFFFFFFF,0x03C0FFFF,0xFFFFFFFF,0x0FC0FFFF,0x07E007C0,0xFFFFFFFF,
0x0FE01FF0,0xFFFF1FF0,0xFFFFFFFF,0xFFFF7FFE,0xFFFFFFFF,0x1FF8FFFF,0xFFFFFFFF,
0xFFF9FFFF,0xFFFFFFC3,0xFFFFFFFF,0x07E0FFFF,0xFFFFFFFF,0x0FC0FFFF,0x07E007C0,
0xFFFFFFFF,0x0FE03FF8,0xFFFF3FF8,0xFFFFFFFF,0xFFFF7FFE,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFE7,0xFFFFFFFF,0x07E0FFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0x1FF0FFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFF7FFE,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFE7,0xFFFFFFFF,0x0FF0FFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x3FF8FFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFF7FFE,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x3FFCFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xC0FFFFFF,0x00000000,0xDFFF7F00,0xFFFFFFFF,0xFFFBFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0000F8FF,0xFFFFFF3F,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xC0FFFFFF,0x00000000,0x87FF7F00,0xFC3FC0FF,
0xFFE1FF03,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x000000FF,0xFFFFFF01,0xFFFFFFFF,
0xFFFF03C0,0xFFFFFFFF,0x00000000,0xFFFF0000,0xC0FFFFFF,0x00000000,0x80FF7F00,
0xF00F0070,0xFF010E00,0x0000F8FF,0x00000000,0xFFFFFF3F,0x000000F0,0xFFFF1F00,
0xF0FFFFFF,0xFF0F0000,0xFFFFFFFF,0x00000000,0xFFFF0000,0xC0FFFFFF,0x00000000,
0x00FF7F00,0xC0030000,0xFF000000,0x0000F8FF,0x00000000,0xFFFFFF3F,0x000000C0,
0xFFFF0700,0x00FFFFFF,0xFF000000,0xFFFFFFFF,0x00000000,0xFFFF0000,0xC0FFFFFF,
0x00000000,0x00FF7F00,0x80010000,0xFF000000,0x0000F8FF,0x00000000,0xFFFFFF3F,
0x00000000,0xFFFF0100,0x00F8FFFF,0x1F000000,0xFFFFFFFF,0x00000000,0xFFFF0000,
0xC0FFFFFF,0x00000000,0x00FE7F00,0x80010000,0x7F000000,0x0000F8FF,0x00000000,
0xFFFFFF3F,0x00000000,0xFFFF0100,0x00E0FFFF,0x07000000,0xFFFFFFFF,0x00000000,
0xFFFF0000,0xC0FFFFFF,0x00000000,0x00FE7F00,0x00000000,0x7F000000,0x0000F8FF,
0x00000000,0xFFFFFF3F,0x00000080,0xFFFF0300,0x00C0FFFF,0x03000000,0xFFFFFFFF,
0x00000000,0xFFFF0000,0xE0FFFFFF,0x00000000,0x00FC7F00,0x00000000,0x3F000000,
0x0000F8FF,0x00000000,0xFFFFFF3F,0x00000080,0xFFFF0300,0x0080FFFF,0x01000000,
0xFFFFFFFF,0x00000000,0xFFFF0000,0xE0FFFFFF,0x00000000,0x00FE7F00,0x00000000,
0x7F000000,0x0000F8FF,0x00000000,0xFFFFFF3F,0x000000C0,0xFFFF0700,0x00C0FFFF,
0x03000000,0xFFFFFFFF,0x00000000,0xFFFF0000,0xE0FFFFFF,0x00000000,0x00FF7F00,
0x00000000,0xFF000000,0x0000F8FF,0x00000000,0xFFFFFF3F,0x000000C0,0xFFFF0700,
0x00C0FFFF,0x03000000,0xFFFFFFFF,0x00000000,0xFFFF0000,0xF0FFFFFF,0x00000000,
0xC0FF7F00,0x0000FC00,0xFF03003F,0x00C0FFFF,0x07000000,0xFFFFFFFF,0x000000E0,
0xFFFF0F00,0x00E0FFFF,0x07000000,0xFFFFFFFF,0x00000000,0xFFFF0000,0xF0FFFFFF,
0x00000000,0xF8FF7F00,0x0000FF1F,0xFF1FF8FF,0x00C0FFFF,0x07000000,0xFFFFFFFF,
0x000000E0,0xFFFF0F00,0x00E0FFFF,0x07000000,0xFFFFFFFF,0x00000080,0xFFFF0100,
0xF8FFFFFF,0x00000000,0xFFFF7F00,0x0180FFFF,0xFFFFFFFF,0x00C0FFFF,0x07000000,
0xFFFFFFFF,0x000000E0,0xFFFF0F00,0x00E0FFFF,0x07000000,0xFFFFFFFF,0x00000080,
0xFFFF0100,0xFC9FFFFF,0x00000000,0xFFFFFF00,0x0180FFFF,0xFFFFFFFF,0x00C0FFFF,
0x07000000,0xFFFFFFFF,0x000000E0,0xFFFF0F00,0x00E0FFFF,0x07000000,0xFFFFFFFF,
0x00000080,0xFFFF0100,0xFE07FCFF,0x00000000,0xFFFFFF00,0x0000F0FF,0xFFFFFF0F,
0x00C0FFFF,0x07000000,0xFFFFFFFF,0x000000E0,0xFFFF0F00,0x00E0FFFF,0x07000000,
0xFFFFFFFF,0x000000C0,0xFFFF0300,0xFF03F0FF,0x00000000,0xFFFFFF00,0x0000C0FF,
0xFFFFFF03,0x00C0FFFF,0x07000000,0xFFFFFFFF,0x000000C0,0xFFFF0700,0x00E0FFFF,
0x07000000,0xFFFFFFFF,0x000000C0,0xFFFF0300,0xFF01E0FF,0x00000080,0xFFFFFF00,
0x000080FF,0xFFFFFF01,0x00C0FFFF,0x07000000,0xFFFFFFFF,0x000000C0,0xFFFF0700,
0x00C0FFFF,0x03000000,0xFFFFFFFF,0x000000E0,0xFFFF0700,0xFF00C0FF,0x000000C0,
0xFFFFFF00,0x000080FF,0xFFFFFF01,0x00E0FFFF,0x0F000000,0xFFFFFFFF,0x00000080,
0xFFFF0300,0x00C0FFFF,0x03000000,0xFFFFFFFF,0x000000E0,0xFFFF0700,0x7F0080FF,
0x000000E0,0xFFFFFF00,0x000080FF,0xFFFFFF01,0x00F8FFFF,0x3F000000,0xFFFFFFFF,
0x00000000,0xFFFF0100,0x00C0FFFF,0x03000000,0xFFFFFFFF,0x000000F0,0xFFFF0F00,
0x7F0000FF,0x000000F0,0xFFFFFF00,0x0000C0FF,0xFFFFFF03,0x00FCFFFF,0x7F000000,
0xFEFFFFFF,0x00000000,0xFFFF0000,0x0080FFFF,0x01000000,0xFFFFFFFF,0x000000F0,
0xFFFF0F00,0x3F0000FF,0x000000F8,0xFFFFFF00,0x0000C0FF,0xFFFFFF03,0x00FEFFFF,
0xFF000000,0xFEFFFFFF,0x00000000,0xFFFF0000,0x0000FFFF,0x00000000,0xFFFFFFFF,
0x000000F8,0xFFFF1F00,0x1F0000FE,0x000000FC,0xFFFFFF00,0x0000C0FF,0xFFFFFF03,
0x00FFFFFF,0xFF010000,0xFCFFFFFF,0x00000000,0xFF7F0000,0x0000FEFF,0x00000000,
0xFFFFFF7F,0x000000FC,0xFFFF3F00,0x0F0000FE,0x000000FC,0xFFFFFF01,0x0000C0FF,
0xFFFFFF03,0x00FFFFFF,0xFF010000,0xFCFFFFFF,0x00000000,0xFF7F0000,0x0000FCFF,
0x00000000,0xFFFFFF3F,0x000000FE,0xFFFF7F00,0x070000FE,0x000000FE,0xFFFFFF01,
0x0000E0FF,0xFFFFFF07,0x00FFFFFF,0xFF010000,0xFCFFFFFF,0x00000000,0xFF7F0000,
0x0000F8FF,0x00000000,0xFFFFFF1F,0x000000FF,0xFFFFFF00,0x030000FE,0x000000FE,
0xFFFFFF01,0x0000E0FF,0xFFFFFF07,0x00FFFFFF,0xFF010000,0xFCFFFFFF,0x00000000,
0xFF7F0000,0x0000F0FF,0x00000000,0xFFFFFF0F,0x0000C0FF,0xFFFFFF03,0x010000FE,
0x000000FF,0xFFFFFF01,0x0000E0FF,0xFFFFFF07,0x00FFFFFF,0xFF010000,0xF8FFFFFF,
0x00000000,0xFF3F0000,0x0000E0FF,0x00000000,0xFFFFFF07,0x0000F0FF,0xFFFFFF0F,
0x000000FE,0x0000001F,0xFFFFFF01,0x0000E0FF,0xFFFFFF07,0x00FFFFFF,0xFF010000,
0xF8FFFFFF,0x00000000,0xFF3F0000,0x0000C0FF,0x00000000,0xFFFFFF03,0x0000FCFF,
0xFFFFFF3F,0x000000FE,0x00008007,0xFFFFFF03,0x0000C0FF,0xFFFFFF03,0x00FFFFFF,
0xFF010000,0xF8FFFFFF,0x00000000,0xFF3F0000,0x0000C0FF,0x00000000,0xFFFFFF03,
0x0000FFFF,0xFFFFFFFF,0x000000FF,0x00008003,0xFFFFFF03,0x000080FF,0xFFFFFF01,
0x00FFFFFF,0xFF010000,0xF8FFFFFF,0x00000000,0xFF3F0000,0x000080FF,0x00000000,
0xFFFFFF01,0x0000FCFF,0xFFFFFF3F,0x000000FF,0x00008001,0xFFFFFF03,0x000000FF,
0xFFFFFF00,0x00FFFFFF,0xFF010000,0xF0FFFFFF,0x00000000,0xFF1F0000,0x000080FF,
0x00000000,0xFFFFFF01,0x0000F8FF,0xFFFFFF1F,0x000080FF,0x00008000,0xFFFFFF03,
0x000000FF,0xFFFFFF00,0x00FFFFFF,0xFF010000,0xF0FFFFFF,0x00000004,0xFF1F4000,
0x000080FF,0x00000000,0xFFFFFF01,0x0000F0FF,0xFFFFFF0F,0x000080FF,0x00000000,
0xFFFFFF07,0x000000FE,0xFFFF7F00,0x00FFFFFF,0xFF010000,0xF0FFFFFF,0x00000004,
0xFF1F4000,0x000000FF,0x00000000,0xFFFFFF00,0x0000E0FF,0xFFFFFF07,0x0000C0FF,
0x00000000,0xFFFFFF07,0x000000FE,0xFFFF7F00,0x00FFFFFF,0xFF010000,0xF0FFFFFF,
0x0000000C,0xFF1F6000,0x000000FF,0x00000000,0xFFFFFF00,0x0000E0FF,0xFFFFFF07,
0x0000E0FF,0x00000000,0xFFFFFF07,0x000000FC,0xFFFF3F00,0x00FFFFFF,0xFF010000,
0xF0FFFFFF,0x06C0000C,0xFF1F6000,0x000000FF,0x00000000,0xFFFFFF00,0x0000C0FF,
0xFFFFFF03,0x0000E0FF,0x00000000,0xFFFFFF0F,0x000000FC,0xFFFF3F00,0x00FFFFFF,
0xFF010000,0xE0FFFFFF,0x06C0001C,0xFF0F7000,0x000000FF,0x00000000,0xFFFFFF00,
0x0000C0FF,0xFFFFFF03,0x0000F0FF,0x00000000,0xFFFFFF0F,0x000000FC,0xFFFF3F00,
0x00FFFFFF,0xFF010000,0xE0FFFFFF,0x06C0001C,0xFF0F7000,0x000000FF,0x00000000,
0xFFFFFF00,0x000080FF,0xFFFFFF01,0x0000F0FF,0x00000000,0xFFFFFF0F,0x000000F8,
0xFFFF1F00,0x00FFFFFF,0xFF010000,0xE0FFFFFF,0x07C0013C,0xFF0F7800,0x000000FF,
0x00000000,0xFFFFFF00,0x000080FF,0xFFFFFF01,0x0000F8FF,0x00000000,0xFFFFFF1F,
0x000000F8,0xFFFF1F00,0x00FFFFFF,0xFF010000,0xE0FFFFFF,0x07C0013C,0xFF0F7800,
0x000000FF,0x00000000,0xFFFFFF00,0x000080FF,0xFFFFFF01,0x0000FCFF,0x00000000,
0xFFFFFF1F,0x000000F8,0xFFFF1F00,0x00FFFFFF,0xFF010000,0xE0FFFFFF,0x0FE0017C,
0xFF0F7C00,0x000000FF,0x00000000,0xFFFFFF00,0x000080FF,0xFFFFFF01,0x0000FCFF,
0x00000000,0xFFFFFF3F,0x000000F8,0xFFFF1F00,0x00FFFFFF,0xFF010000,0xC0FFFFFF,
0x0FE0037C,0xFF077C80,0x000080FF,0x00000000,0xFFFFFF01,0x000080FF,0xFFFFFF01,
0x0000FEFF,0x00000000,0xFFFFFF3F,0x000000F8,0xFFFF1F00,0x00FFFFFF,0xFF010000,
0xC0FFFFFF,0x0FE003FC,0xFF077E80,0x000080FF,0x00000000,0xFFFFFF01,0x000080FF,
0xFFFFFF01,0x0000FEFF,0x00000000,0xFFFFFF7F,0x000000F8,0xFFFF1F00,0x00FFFFFF,
0xFF010000,0xC0FFFFFF,0x0FE003FC,0xFF077E80,0x000080FF,0x00000420,0xFFFFFF01,
0x0000C0FF,0xFFFFFF03,0x0000FFFF,0x00000000,0xFFFFFF7F,0x000000FC,0xFFFF3F00,
0x00FFFFFF,0xFF010000,0xC1FFFFFF,0x0FE007FC,0xFF077FC0,0x0000C0FF,0x00000660,
0xFFFFFF03,0x0000C0FF,0xFFFFFF03,0x0000FFFF,0x00000000,0xFFFFFFFF,0x000000FC,
0xFFFF3F00,0x00FFFFFF,0xFF010000,0xC1FFFFFF,0x1FF007FC,0xFF077FC0,0x0000E0FF,
0x000003C0,0xFFFFFF07,0x0000E0FF,0xFFFFFF07,0x0000FFFF,0x00000000,0xFFFFFFFF,
0x000000FC,0xFFFF3F00,0x00FFFFFF,0xFF010000,0x83FFFFFF,0x1FF007FC,0xFF837FC0,
0x0100F0FF,0x008003C0,0xFFFFFF0F,0x0000E0FF,0xFFFFFF07,0x0000FFFF,0x01000000,
0xFFFFFFFF,0x000000FE,0xFFFF7F00,0x00FFFFFF,0xFF010000,0x83FFFFFF,0x1FF00FFC,
0xFF837FE0,0x0300F8FF,0x00C00180,0xFFFFFF1F,0x0000F0FF,0xFFFFFF0F,0x0000FFFF,
0x01000000,0xFFFFFFFF,0x000000FE,0xFFFF7F00,0x00FEFFFF,0xFF000000,0x87FFFFFF,
0x1FF00FFC,0xFFC37FE0,0x0F00FEFF,0x00F00180,0xFFFFFF7F,0x0000F8FF,0xFFFFFF1F,
0x0000FFFF,0x03000000,0xFFFFFFFF,0x000000FF,0xFFFFFF00,0x00FCFFFF,0x7F000000,
0x87FFFFFF,0x1FF00FFC,0xFFC37FE0,0x7FC0FFFF,0x03FE0180,0xFFFFFFFF,0x0000FCFF,
0xFFFFFF3F,0x0080FFFF,0x07000000,0xFFFFFFFF,0x000080FF,0xFFFFFF01,0x00F8FFFF,
0x3F000000,0x0FFFFFFF,0x3FF81FFC,0xFFE17FF0,0xFFFFFFFF,0xFFFF0180,0xFFFFFFFF,
0x0000FFFF,0xFFFFFFFF,0x0080FFFF,0x0F000000,0xFFFFFFFF,0x0000C0FF,0xFFFFFF03,
0x00F0FFFF,0x1F000000,0x1FFCFFFF,0x3FF81FFC,0x7FF07FF0,0xFFFFFFFF,0xFFFF0180,
0xFFFFFFFF,0x07E0FFFF,0xFFFFFFFF,0x00C0FFFF,0x1F000000,0xFFFFFFFF,0x0000E0FF,
0xFFFFFF07,0x00E0FFFF,0x0F000000,0x0FF8FFFF,0x3FF81FFC,0x3FE07FF0,0xFFFFFFFF,
0xFFFF03C0,0xFFFFFFFF,0x03C0FFFF,0xFFFFFFFF,0x00C0FFFF,0x3F000000,0xFFFFFFFF,
0x0000F8FF,0xFFFFFF1F,0x00C0FFFF,0x07000000,0x07F0FFFF,0x3FF83FFC,0x1FC07FF8,
0xFFFFFFFF,0xFFFF03C0,0xFFFFFFFF,0x0180FFFF,0xFFFFFFFF,0x00E0FFFF,0x7F000000,
0xFFFFFFFF,0x0000FEFF,0xFFFFFF7F,0x00C0FFFF,0x07000000,0x07F0FFFF,0x3FF83FFC,
0x1FC07FF8,0xFFFFFFFF,0xFFFF07E0,0xFFFFFFFF,0x0180FFFF,0xFFFFFFFF,0x00E0FFFF,
0xFF000000,0xFFFFFFFF,0x0000FFFF,0xFFFFFFFF,0x00C0FFFF,0x07000000,0x07F0FFFF,
0x7FFC3FFC,0x1FC07FF8,0xFFFFFFFF,0xFFFF0FF0,0xFFFFFFFF,0x0000FFFF,0xFFFFFFFF,
0x00F0FFFF,0xFF030000,0xFFFFFFFF,0x03C0FFFF,0xFFFFFFFF,0x00C0FFFF,0x07000000,
0x07F0FFFF,0x7FFC7FFC,0x1FC07FFC,0xFFFFFFFF,0xFFFF3FFC,0xFFFFFFFF,0x0000FFFF,
0xFFFFFFFF,0x00F8FFFF,0xFF070000,0xFFFFFFFF,0x07E0FFFF,0xFFFFFFFF,0x00C0FFFF,
0x07000000,0x07F0FFFF,0x7FFC7FFC,0x1FC07FFC,0xFFFFFFFF,0xFFFF7FFE,0xFFFFFFFF,
0x0000FFFF,0xFFFFFFFF,0x00F8FFFF,0xFF1F0000,0xFFFFFFFF,0x0FF0FFFF,0xFFFFFFFF,
0x00C0FFFF,0x07000000,0x0FF8FFFF,0x7FFC3FF8,0x3FE03FF8,0xFFFFFFFF,0xFFFF7FFE,
0xFFFFFFFF,0x0000FFFF,0xFFFFFFFF,0x00F8FFFF,0xFFFF0000,0xFFFFFFFF,0x3FFCFFFF,
0xFFFFFFFF,0x00C0FFFF,0x07000000,0x1FFCFFFF,0x7FFC1FF0,0x7FF01FF0,0xFFFFFFFF,
0xFFFF7FFE,0xFFFFFFFF,0x0000FFFF,0xFFFFFFFF,0x07F8FFFF,0xFFFF7F00,0xFFFFFFFF,
0x0FF0FFFF,0xFFFFFFFF,0x00C0FFFF,0x07000000,0xFFFFFFFF,0x3FF80FE0,0xFFFF0FE0,
0xFFFFFFFF,0xFFFF7FFE,0xFFFFFFFF,0x0000FFFF,0xFFFFFFFF,0x0FF0FFFF,0xFFFFFF00,
0xFFFFFFFF,0x07E0FFFF,0xFFFFFFFF,0x0FC0FFFF,0x07E007C0,0xFFFFFFFF,0x1FF00FE0,
0xFFFF0FE0,0xFFFFFFFF,0xFFFF7FFE,0xFFFFFFFF,0x0180FFFF,0xFFFFFFFF,0x1FF0FFFF,
0xFFFFFF80,0xFFFFFFFF,0x07E0FFFF,0xFFFFFFFF,0x0FC0FFFF,0x07E007C0,0xFFFFFFFF,
0x0FE00FE0,0xFFFF0FE0,0xFFFFFFFF,0xFFFF07E0,0xFFFFFFFF,0x0180FFFF,0xFFFFFFFF,
0x3FF0FFFF,0xFFFFFF81,0xFFFFFFFF,0x03C0FFFF,0xFFFFFFFF,0x0FC0FFFF,0x07E007C0,
0xFFFFFFFF,0x0FE00FE0,0xFFFF0FE0,0xFFFFFFFF,0xFFFF07E0,0xFFFFFFFF,0x03C0FFFF,
0xFFFFFFFF,0x7FF0FFFF,0xFFFFFFC1,0xFFFFFFFF,0x03C0FFFF,0xFFFFFFFF,0x0FC0FFFF,
0x07E007C0,0xFFFFFFFF,0x0FE00FE0,0xFFFF0FE0,0xFFFFFFFF,0xFFFF7FFE,0xFFFFFFFF,
0x07E0FFFF,0xFFFFFFFF,0xFFF8FFFF,0xFFFFFFC3,0xFFFFFFFF,0x03C0FFFF,0xFFFFFFFF,
0x0FC0FFFF,0x07E007C0,0xFFFFFFFF,0x0FE01FF0,0xFFFF1FF0,0xFFFFFFFF,0xFFFF7FFE,
0xFFFFFFFF,0x1FF8FFFF,0xFFFFFFFF,0xFFF9FFFF,0xFFFFFFC3,0xFFFFFFFF,0x07E0FFFF,
0xFFFFFFFF,0x0FC0FFFF,0x07E007C0,0xFFFFFFFF,0x0FE03FF8,0xFFFF3FF8,0xFFFFFFFF,
0xFFFF7FFE,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFE7,0xFFFFFFFF,
0x07E0FFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x1FF0FFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFF7FFE,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFE7,
0xFFFFFFFF,0x0FF0FFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x3FF8FFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFF7FFE,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0x3FFCFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xC0FFFFFF,0x00000000,
0xDFFF7F00,0xFFFFFFFF,0xFFFBFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0000F8FF,
0xFFFFFF3F,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xC0FFFFFF,
0x00000000,0x87FF7F00,0xFC3FC0FF,0xFFE1FF03,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0x000000FF,0xFFFFFF01,0xFFFFFFFF,0xFFFF03C0,0xFFFFFFFF,0x00000000,0xFFFF0000,
0xCFFFFFFF,0xFFFFFFFF,0x80FF7FF8,0xF00F0070,0xFF010E00,0x0000F8FF,0x00000000,
0xFFFFFF3F,0xFFFF03F0,0xFFFF1F80,0xF0FFFFFF,0xFF0F0000,0xFFFFFFFF,0x00000000,
0xFFFF0000,0xCFFFFFFF,0xFFFFFFFF,0x30FF7FF8,0xC1831F00,0xFF0C00F8,0x0000F8FF,
0x00000000,0xFFFFFF3F,0xFFFF7FC0,0xFFFF07FC,0x00FFFFFF,0xFF00F81F,0xFFFFFFFF,
0xFFFFFF3F,0xFFFFFCFF,0xCFFFFFFF,0xFFFFFFFF,0x3FFF7FF8,0x87E1FF07,0xFFFCE0FF,
0xFFFFF9FF,0xFFFFFFFF,0xFFFFFF3F,0xFFFFFF03,0xFFFF81FF,0x07F8FFFF,0x1FE0FFFF,
0xFFFFFFFF,0xFFFFFF3F,0xFFFFFCFF,0xCFFFFFFF,0xFFFFFFFF,0x7FFE7FF8,0x8FF1FFFF,
0x7FFEFFFF,0xFFFFF9FF,0xFFFFFFFF,0xFFFFFF3F,0xFFFFFF03,0xFFFF81FF,0x7FE0FFFF,
0x07FEFFFF,0xFFFFFFFF,0xFFFFFF3F,0xFFFFFCFF,0xCFFFFFFF,0xFFFFFFFF,0x7FFE7FF8,
0x3FFCFFFF,0x7FFEFFFF,0xFFFFF9FF,0xFFFFFFFF,0xFFFFFF3F,0xFFFF7F80,0xFFFF03FC,
0xFFC0FFFF,0x03FFFFFF,0xFFFFFFFF,0xFFFFFF3F,0xFFFFFCFF,0xE7FFFFFF,0xFFFFFFFF,
0x7FFC7FF8,0x7FFEFFFF,0x3FFEFFFF,0xFFFFF9FF,0xFFFFFFFF,0xFFFFFF3F,0xFFFF0198,
0xFFFF3300,0x1F80FFFF,0x01F8FFFF,0xFFFFFFFF,0xFFFFFF3F,0xFFFFFCFF,0xE7FFFFFF,
0xFFFFFFFF,0x1FFE7FF8,0x7FFE01FE,0x7FF87F80,0x0000F8FF,0x00000000,0xFFFFFF3F,
0x000000CF,0xFFFFE701,0x00CEFFFF,0x7300FC3F,0xFFFFFFFF,0xFFFFFF3F,0xFFFFFCFF,
0xE7FFFFFF,0xFFFFFFFF,0x03FF7FF8,0x7E7E00C0,0xFFC00300,0x0000F8FF,0x00000000,
0xFFFFFF3F,0x0000FCCF,0xFFFFE77F,0xE0C7FFFF,0xE3070000,0xFFFFFFFF,0xFFFFFF3F,
0xFFFFFCFF,0xF3FFFFFF,0xFFFFFFFF,0xC0FF7FF8,0x7C3EFC00,0xFF03003F,0xFFCFFFFF,
0xE7FFFFFF,0xFFFFFFFF,0xFFFFFFE7,0xFFFFCFFF,0xFFE7FFFF,0xE7FF03C0,0xFFFFFFFF,
0xFFFFFF1F,0xFFFFF8FF,0xF1FFFFFF,0xFFFFFFFF,0xF8FF7FF8,0x781EFF1F,0xFF1FF8FF,
0xFFCFFFFF,0xE7FFFFFF,0xFFFFFFFF,0xFFFFFFE7,0xFFFFCFFF,0xFFE1FFFF,0x87FFFFFF,
0xFFFFFFFF,0xFFFFFF9F,0xFFFFF9FF,0xF8FFFFFF,0xFFFFFFFF,0xFFFF7FF8,0x799EFFFF,
0xFFFFFFFF,0xFFCFFFFF,0xE7FFFFFF,0xFFFFFFFF,0xFFFFFFE1,0xFFFF0FFF,0x1FE0FFFF,
0x07F8FFFF,0xFFFFFFFF,0xFFFFFF9F,0xFFFFF9FF,0xFC9FFFFF,0xFFFFFF7F,0xFFFFFFF0,
0x0180FFFF,0xFFFFFFFF,0xFFCFFFFF,0xE7FFFFFF,0xFFFFFFFF,0xFFFF1FE0,0xFFFF0FF0,
0x00E6FFFF,0x6700FE7F,0xFFFFFFFF,0xFFFFFF8F,0xFFFFF1FF,0xFE07FCFF,0xFFFFFF3F,
0xFFFFFFF0,0x0000F0FF,0xFFFFFF0F,0xFFCFFFFF,0xE7FFFFFF,0xFFFFFFFF,0xFC7F00E4,
0xFFFF4F00,0xE0E7FFFF,0xE7070000,0xFFFFFFFF,0xFFFFFFCF,0xFFFFF3FF,0xFF03F0FF,
0xFFFFFF1F,0xFFFFFFF0,0xFC3FC0FF,0xFFFFFF03,0x00C0FFFF,0x07000000,0xFFFFFFFF,
0x0000C0CF,0xFFFFE707,0xFFE7FFFF,0xE7FF0180,0xFFFFFFFF,0xFFFFFFC7,0xFFFFE3FF,
0xFF31E3FF,0xFFFFFF8F,0xFFFFFFF0,0xFFFF8FFF,0xFFFFFFF1,0x00C0FFFF,0x07000000,
0xFFFFFFFF,0x0100FFCF,0xFFFFE7FF,0xFFC7FFFF,0xE3FFFFFF,0xFFFFFFFF,0xFFFFFFE7,
0xFFFFE7FF,0xFF38CFFF,0xFFFFFFC7,0xFFFFFFF0,0xFFFF83FF,0xFFFFFFC1,0xFFE3FFFF,
0x8FFFFFFF,0xFFFFFFFF,0xFFFFFF8F,0xFFFFE3FF,0xFFCFFFFF,0xF3FFFFFF,0xFFFFFFFF,
0xFFFFFFE3,0xFFFFC7FF,0x7F1C9FFF,0xFFFFFFE3,0xFFFFFFF0,0xF00F80FF,0xFFFFFF01,
0xFFF8FFFF,0x3FFEFFFF,0xFFFFFFFF,0xFFFFFF07,0xFFFFC1FF,0xFFC7FFFF,0xE3FFFFFF,
0xFFFFFFFF,0xFFFFFFF1,0xFFFF8FFF,0x7F8E3FFF,0xFFFFFFF1,0xFFFFFFF0,0x0000C8FF,
0xFFFFFF13,0x7FFCFFFF,0x7FFCFFFF,0xFEFFFFFF,0xFFFF7F20,0xFFFF08FC,0xFF81FFFF,
0x81FFFFFF,0xFFFFFFFF,0xFFFFFFF1,0xFFFF8FFF,0x3FCE3FFF,0xFFFFFFF8,0xFFFFFFF0,
0x07E0CFFF,0xFFFFFFF3,0x00FEFFFF,0xFF000000,0xFEFFFFFF,0xFEFF0070,0xFFFF1C00,
0x1F18FFFF,0x18F8FFFF,0xFFFFFFFF,0xFFFFFFF8,0xFFFF1FFF,0x1FDF7FFE,0xFFFFFFFC,
0xFFFFFFF0,0xFFFFCFFF,0xFFFFFFF3,0x00FFFFFF,0xFF010000,0xFCFFFFFF,0x000000FF,
0xFF7FFE01,0x003EFEFF,0x7C00FE7F,0xFFFFFF7F,0xFFFF7FFC,0xFFFF3FFE,0x8FFF67FE,
0xFFFFFFFC,0xFFFFFFE1,0xFFFFCFFF,0xFFFFFFF3,0x3FFFFFFF,0xFFF9FFFF,0xFCFFFFFF,
0x0000FEFF,0xFF7FFEFF,0xE07FFCFF,0xFE070000,0xFFFFFF3F,0xFFFF1FFE,0xFFFF7FF8,
0xC7FF43FE,0xFFFF7FFE,0xFFFFFFE1,0xFFFFE7FF,0xFFFFFFE7,0x3FFFFFFF,0xFFF9FFFF,
0xFCFFFFFF,0xFFFFFFFF,0xFF7FFEFF,0xFFFFF8FF,0xFFFF0180,0xFFFFFF1F,0xFFFF07FF,
0xFFFFFFE0,0xE3FF63FE,0xFFFF7FFE,0xFFFFFFE1,0xFFFFE3FF,0xFFFFFFC7,0x3FFFFFFF,
0xFFF9FFFF,0xFCFFFFFF,0xFFFFFFCF,0xFF7FE6FF,0xFFFFF1FF,0xFFFF7FFE,0xFFFFFF8F,
0xFFFFC1FF,0xFFFFFF83,0xF1FF61FE,0xFFFF3FFF,0xFFFFFFE1,0xF81FE0FF,0xFFFFFF07,
0x3FFFFFFF,0xFFF9FFFF,0xF8FFFFFF,0xFFFFFF07,0xFF3FC0FF,0xFFFFE3FF,0xFFFF7FFE,
0xFFFFFFC7,0xFE7FF0FF,0xFFFFFF0F,0xF8FF71FE,0xFFFF3F1F,0xFFFFFFE1,0x0000E4FF,
0xFFFFFF27,0x3FFFFFFF,0xFFF9FFFF,0xF8FFFFFF,0xFFFFFF30,0xFF3F18FE,0xFFFFC7FF,
0xFFFF7FFE,0xFFFFFFE3,0xFC3FFCFF,0xFFFFFF3F,0xFEFF79FE,0xFFFF9F07,0xFFFFFFC3,
0x03C0C7FF,0xFFFFFFE3,0x3FFFFFFF,0xFFF9FFFF,0xF9FFFFFF,0xF01F7CF8,0xFF3F3F7C,
0xFFFFCFFF,0xFFFF7FFE,0xFFFFFFF3,0xF81FFFFF,0xFFFFFFFF,0xFFFF3FFF,0xFFFF9FC3,
0xFFFFFFC3,0xFFFF8FFF,0xFFFFFFF1,0x3FFFFFFF,0xFFF9FFFF,0xF9FFFFFF,0xC00720F0,
0xFF3F1F08,0xFFFF8FFF,0xFFFF7FFE,0xFFFFFFF1,0xFC3FFCFF,0xFFFFFF3F,0xFFFF3FFF,
0xFFFF9FF1,0xFFFFFFC3,0xFFFF1FFF,0xFFFFFFF8,0x3FFFFFFF,0xFFF9FFFF,0xF3FFFFFF,
0x010183F0,0xFF9F1F82,0xFFFF9FFF,0xFFFF3FFC,0xFFFFFFF9,0xFFFFF8FF,0xFFFFFF1F,
0xFFFF9FFF,0xFFFF9FF8,0xFFFFFFC3,0xFFFF3FFF,0xFFFFFFFC,0x3FFFFFFF,0xFFF9FFFF,
0xF3FFFFFF,0x3018DEE4,0xFF9F4FF6,0xFFFF9FFF,0xFFFF3FFC,0xFFFFFFF9,0xFFFFF1FF,
0xFFFFFF8F,0xFFFF9FFF,0xFFFF1FFC,0xFFFFFF87,0xFFFF7FFE,0xFFFF7FFE,0x3FFFFFFF,
0xFFF9FFFF,0xF3FFFFFF,0xF01EFEE4,0xFF9F4FFE,0xFFFF1FFF,0xFFFF3FFC,0xFFFFFFF8,
0xFFFFE3FF,0xFFFFFFC7,0xFFFFCFFF,0xFFFF1FFE,0xFFFFFF87,0xFFFF7FFE,0xFFFF7FFE,
0x3FFFFFFF,0xFFF9FFFF,0xF3FFFFFF,0xF01FFECC,0xFF9F67FE,0xFFFF3FFF,0xFFFF3FFC,
0xFFFFFFFC,0xFFFFE7FF,0xFFFFFFE7,0xFFFFE7FF,0xFFFF1FFF,0xFFFFFF87,0xFFFFFFFC,
0xFFFF3FFF,0x3FFFFFFF,0xFFF9FFFF,0xF3FFFFFF,0xE6CFFCCC,0xFF9F677E,0xFFFF3FFF,
0xFFFF1FF8,0xFFFFFFFC,0xFFFFC7FF,0xFFFFFFE3,0xFFFFE7FF,0xFFFF1FFF,0xFFFFFF0F,
0x7FFEFFFC,0xFFFF3FFF,0x3FFFFFFF,0xFFF9FFFF,0xE7FFFFFF,0xE6CFFC9C,0xFFCF737E,
0xFFFF3FFF,0xFFFF9FF9,0xFFFFFFFC,0xFFFFCFFF,0xFFFFFFF3,0xFFFFF3FF,0xFFFF9FFF,
0xFFFFFF0F,0x7FFEFFFC,0xFFFF3FFF,0x3FFFFFFF,0xFFF9FFFF,0xE7FFFFFF,0xE6CFFC9C,
0xFFCF737E,0xFFFF3FFF,0xFFFF8FF1,0xFFFFFFFC,0xFFFF8FFF,0xFFFFFFF1,0xFFFFF3FF,
0xFFFFCFFF,0xFFFFFF0F,0x7FFEFFF9,0xFFFF9FFF,0x3FFFFFFF,0xFFF9FFFF,0xE7FFFFFF,
0xE7CFF93C,0xFFCF793E,0xFFFF3FFF,0xFFFF8FF1,0xFFFFFFFC,0xFFFF9FFF,0xFFFFFFF9,
0xFFFFF9FF,0xFEFFCFFF,0xFFFFFF1F,0x7FFEFFF9,0xFFFF9FFF,0x3FFFFFFF,0xFFF9FFFF,
0xE7FFFFFF,0xE7CFF93C,0xFFCF793E,0xFFFF3FFF,0xFFFFC7E3,0xFFFFFFFC,0xFFFF9FFF,
0xFFFFFFF9,0xFFFFFCFF,0xFEFFCFFF,0xFFFFFF1F,0x7FFEFFF9,0xFFFF9FFF,0x3FFFFFFF,
0xFFF9FFFF,0xE6FFFFFF,0xCFE7F97C,0xFFCF7C3E,0xFFFF1FFF,0xFFFFC3C3,0xFFFFFFF8,
0xFFFF9FFF,0xFFFFFFF9,0xFFFFFCFF,0xFCFFCFFF,0xFFFFFF3F,0x7FFEFFF9,0xFFFF9FFF,
0x3FFFFFFF,0xFFF9FFFF,0xCEFFFFFF,0xCFE7F37C,0xFFE77C9E,0xFFFF9FFF,0xFFFFC183,
0xFFFFFFF9,0xFFFF9FFF,0xFFFFFFF9,0xFF7FFEFF,0xFCFFCFFF,0xFFFFFF3F,0x0180FFF9,
0xFFFF9FFF,0x3FFFFFFF,0xFFF9FFFF,0xCCFFFFFF,0xCFE7F3FC,0xFF677E9E,0xFFFF9FFF,
0xFFFFE007,0xFFFFFFF9,0xFFFF8FFF,0xFFFFFFF1,0xFF77FEFF,0xF8FFCFFF,0xFFFFFF7F,
0x0180FFF9,0xFFFF9FFF,0x3FFFFFFF,0xFFF9FFFF,0xCCFFFFFF,0xCFE7F3FC,0xFF677E9E,
0xFEFF8FFF,0xFF7FE427,0xFFFFFFF1,0xFFFFCFFF,0xFFFFFFF3,0x3F33FFFF,0xF8FFFFFF,
0xFFFFFF7F,0x7FFEFFFC,0xFFFF3FFF,0x3FFFFFFF,0xFFF9FFFF,0xC9FFFFFF,0xCFE7E7FC,
0xFF277FCE,0xFCFFC7FF,0xFF3FE667,0xFFFFFFE3,0xFFFFC7FF,0xFFFFFFE3,0x3F31FFFF,
0xF0FFFFFF,0xFFFFFFFF,0x7FFEFFFC,0xFFFF3FFF,0x3FFFFFFF,0xFFF9FFFF,0xC9FFFFFF,
0x9FF3E7FC,0xFF277FCE,0xF8FFE3FF,0xFF1FF3CF,0xFFFFFFC7,0xFFFFE7FF,0xFFFFFFE7,
0x1F38FFFF,0xF0FFFFFF,0xFFFFFFFF,0x7FFEFFFC,0xFFFF3FFF,0x3FFFFFFF,0xFFF9FFFF,
0x93FFFFFF,0x9FF3E7FC,0xFF937FCE,0xE1FFF0FF,0xFF87F3CF,0xFFFFFF0F,0xFFFFE3FF,
0xFFFFFFC7,0x3F3CFFFF,0xE1FFFFFF,0xFFFFFFFF,0x7FFE7FFE,0xFFFF7FFE,0x00FFFFFF,
0xFF010000,0x93FFFFFF,0x9FF3CFFC,0xFF937FE6,0x031FF8FF,0xF8C0F18F,0xFFFFFF1F,
0xFFFFF1FF,0xFFFFFF8F,0x1F3EFFFF,0xE1FFFFFF,0xFFFFFFFF,0x7FFE3FFE,0xFFFF7FFC,
0x00FEFFFF,0xFF000000,0x87FFFFFF,0x9FF3CFFC,0xFFC37FE6,0x0F00FEFF,0x00F0F99F,
0xFFFFFF7F,0xFE7FF8FF,0xFFFFFF1F,0x0F1FFFFF,0xC3FFFFFF,0xFFFFFFFF,0x7FFE1FFF,
0xFFFFFFF8,0x7FFCFFFF,0x7FFCFFFF,0x87FFFFFF,0x9FF3CFFC,0xFFC37FE6,0x7FC0FFFF,
0x03FEF99F,0xFFFFFFFF,0xF81FFCFF,0xFFFFFF3F,0xCF9FFFFF,0x87FFFFFF,0xFFFFFFFF,
0xFFFF8FFF,0xFFFFFFF1,0xFFF8FFFF,0x3FFEFFFF,0x0FFFFFFF,0x3FF99FFC,0xFFE17FF2,
0xFFFFFFFF,0xFFFFF99F,0xFFFFFFFF,0xE007FFFF,0xFFFFFFFF,0xFF8FFFFF,0x0FFFFFFF,
0xFFFFFFFF,0xFFFFC3FF,0xFFFFFFC3,0xFFF1FFFF,0x1FFFFFFF,0x1FFCFFFF,0x3FF99FFC,
0x7FF07FF2,0xFFFFFFFF,0xFFFFF18F,0xFFFFFFFF,0xE7E7FFFF,0xFFFFFFFF,0x3FCFFFFF,
0x1FFEFFFF,0xFFFFFFFF,0xFFFFE0FF,0xFFFFFF07,0xFFE3FFFF,0x8FFFFFFF,0x0FF8FFFF,
0x3FF99FFC,0x3FE07FF2,0xFFFFFFFF,0xFFFFF3CF,0xFFFFFFFF,0xE3C7FFFF,0xFFFFFFFF,
0x3FCFFFFF,0x3FFCFFFF,0xFFFFFFFF,0xFE7FF8FF,0xFFFFFF1F,0x00C0FFFF,0x07000000,
0xC7F1FFFF,0x3FF93FFC,0x1FC77FF8,0xFFFFFFFF,0xFFFFE3C7,0xFFFFFFFF,0xF18FFFFF,
0xFFFFFFFF,0x1FE7FFFF,0x7FF8FFFC,0xFFFFFFFF,0xF81FFEFF,0xFFFFFF7F,0x00C0FFFF,
0x07000000,0xE7F3FFFF,0x3FF93FFC,0x9FCF7FF8,0xFFFFFFFF,0xFFFF07E0,0xFFFFFFFF,
0xF99FFFFF,0xFFFFFFFF,0x9FE7FFFF,0xFFE0FF3C,0xFFFFFFFF,0xF00FFFFF,0xFFFFFFFF,
0xFFCFFFFF,0xE7FFFFFF,0xE7F3FFFF,0x7FFC3FFC,0x9FCF7FF8,0xFFFFFFFF,0xFFFF0FF0,
0xFFFFFFFF,0xF81FFFFF,0xFFFFFFFF,0xC7F1FFFF,0xFF837F3E,0xFFFFFFFF,0xE3C7FFFF,
0xFFFFFFFF,0xFFCFFFFF,0xE7FFFFFF,0xE7F3FFFF,0x7FFC7FFC,0x9FCF7FFC,0xFFFFFFFF,
0xFFFF3FFC,0xFFFFFFFF,0xFC3FFFFF,0xFFFFFFFF,0xE0F8FFFF,0xFF077C3E,0xFFFFFFFF,
0xC7E3FFFF,0xFFFFFFFF,0xFFCFFFFF,0xE7FFFFFF,0xC7F1FFFF,0x7FFC7FFC,0x1FC77FFC,
0xFFFFFFFF,0xFFFF7FFE,0xFFFFFFFF,0xFC3FFFFF,0xFFFFFFFF,0xE0F9FFFF,0xFF1F003E,
0xFFFFFFFF,0x8FF1FFFF,0xFFFFFFFF,0xFFCFFFFF,0xE7FFFFFF,0x0FF8FFFF,0x7FFC3FF8,
0x3FE03FF8,0xFFFFFFFF,0xFFFF7FFE,0xFFFFFFFF,0xFC3FFFFF,0xFFFFFFFF,0xC0F9FFFF,
0xFFFF003E,0xFFFFFFFF,0x3FFCFFFF,0xFFFFFFFF,0xC0CFFFFF,0xE707E00F,0x1FFCFFFF,
0x7FFC1FF0,0x7FF01FF0,0xFFFFFFFF,0xFFFF7FFE,0xFFFFFFFF,0xFC3FFFFF,0xFFFFFFFF,
0xC7F9FFFF,0xFFFF7F3C,0xFFFFFFFF,0x0FF0FFFF,0xFFFFFFFF,0xC0CFFFFF,0xE707E00F,
0xFFFFFFFF,0x3FF88FE3,0xFFFF8FE3,0xFFFFFFFF,0xFFFF7FFE,0xFFFFFFFF,0xF81FFFFF,
0xFFFFFFFF,0x8FF3FFFF,0xFFFFFF1C,0xFFFFFFFF,0x07E0FFFF,0xFFFFFFFF,0xCFCFFFFF,
0xE7E7E7CF,0xFFFFFFFF,0x1FF0CFE7,0xFFFFCFE7,0xFFFFFFFF,0xFFFF7FFE,0xFFFFFFFF,
0xF99FFFFF,0xFFFFFFFF,0x1FF3FFFF,0xFFFFFF9C,0xFFFFFFFF,0xC7E3FFFF,0xFFFFFFFF,
0xCFCFFFFF,0xE7E7E7CF,0xFFFFFFFF,0x8FE3CFE7,0xFFFFCFE7,0xFFFFFFFF,0xFFFF07E0,
0xFFFFFFFF,0xF18FFFFF,0xFFFFFFFF,0x3FF2FFFF,0xFFFFFF89,0xFFFFFFFF,0xE3C7FFFF,
0xFFFFFFFF,0xCFCFFFFF,0xE7E7E7CF,0xFFFFFFFF,0xCFE7CFE7,0xFFFFCFE7,0xFFFFFFFF,
0xFFFF07E0,0xFFFFFFFF,0xC3C3FFFF,0xFFFFFFFF,0x7FF0FFFF,0xFFFFFFC9,0xFFFFFFFF,
0xE3C7FFFF,0xFFFFFFFF,0xCFCFFFFF,0xE7E7E7CF,0xFFFFFFFF,0xCFE78FE3,0xFFFF8FE3,
0xFFFFFFFF,0xFFFF7FFE,0xFFFFFFFF,0x07E0FFFF,0xFFFFFFFF,0xFFF8FFFF,0xFFFFFFC3,
0xFFFFFFFF,0xE3C7FFFF,0xFFFFFFFF,0x0FC0FFFF,0x07E007C0,0xFFFFFFFF,0xCFE71FF0,
0xFFFF1FF0,0xFFFFFFFF,0xFFFF7FFE,0xFFFFFFFF,0x1FF8FFFF,0xFFFFFFFF,0xFFF9FFFF,
0xFFFFFFC3,0xFFFFFFFF,0xC7E3FFFF,0xFFFFFFFF,0x0FC0FFFF,0x07E007C0,0xFFFFFFFF,
0x8FE33FF8,0xFFFF3FF8,0xFFFFFFFF,0xFFFF7FFE,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFE7,0xFFFFFFFF,0x07E0FFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0x1FF0FFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFF7FFE,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFE7,0xFFFFFFFF,0x0FF0FFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0x3FF8FFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFF7FFE,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x3FFCFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0x0000FFFF};

    unsigned long *p;
    int size;

    switch (_StandardSize)
    {
        case Size32: {size=12406; p=&set32[0]; break;}
        case Size40: {size=19318; p=&set40[0]; break;}
        case Size64: {size=12350; p=&set64[0]; break;}
        case Size80: {size=19262; p=&set80[0]; break;}
        default:{ return;}
    }

    TMemoryStream *str=new TMemoryStream();

    str->SetSize(size);
    str->WriteBuffer(p,size);
    str->Seek(0,soFromBeginning);
    Default->LoadFromStream(str);

    delete str;
}



