//---------------------------------------------------------------------------
#ifndef ChThreadH
#define ChThreadH
//---------------------------------------------------------------------------
#include <vcl\Classes.hpp>
#include "CHTYPES.H"

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

class ChessThread : public TThread
{
private:
        //From Tom's Simple Chess Program:

        void __fastcall init(void);
        BOOL __fastcall in_check(int s);
        BOOL __fastcall attack(int sq,int s);
        void __fastcall gen(void);
        void __fastcall gen_caps(void);
        void __fastcall gen_push(int from,int to,int bits);
        void __fastcall gen_promote(int from,int to,int bits);
        BOOL __fastcall makemove(move_bytes m);
        void __fastcall takeback(void);
        void __fastcall sort_pv(void);
        void __fastcall sort(int from);
        int  __fastcall quiesce(int alpha,int beta);
        int  __fastcall search(int alpha,int beta,int depth);
        void __fastcall think(void);
        int  __fastcall eval(void);
        void __fastcall init_eval(void);

         /* pcsq stands for piece/square table. It's indexed by the piece's color,
        type, and square. The value of pcsq[LIGHT][KNIGHT][e5] might be 310
        instead of just 300 because a knight on e5 is better than one on
        one of the outer squares. */
        int pcsq[2][6][64];

        int flip[64];
        int pawn_pcsq[64];
        int kingside_pawn_pcsq[64];
        int queenside_pawn_pcsq[64];
        int minor_pcsq[64];
        int king_pcsq[64];
        int endgame_king_pcsq[64];

        int color[64];  /* LIGHT, DARK, or EMPTY */
        int piece[64];  /* PAWN, KNIGHT, BISHOP, ROOK, QUEEN, KING, or EMPTY */
        int side;  /* the side to move */
        int xside;  /* the side not to move */
        int castle;  /* a bitfield with the castle permissions. if 1 is set,
                        white can still castle kingside. 2 is white queenside.
                        4 is black kingside. 8 is black queenside. */
        int ep;  /* the en passant square. if white moves e2e4, the en passant
                    square is set to e3, because that's where a pawn would move
                    in an en passant capture */
        int fifty;  /* the number of moves since a capture or pawn move, used
                       to handle the fifty-move-draw rule */
        int ply;  /* the half-move that we're on */

        /* this is the move stack. gen_dat is basically a list of move lists,
           all stored back to back. gen_begin[x] is where the first move of the
           ply x move list is (in gen_dat). gen_end is right after the last move. */
        gen_rec gen_dat[MOVE_STACK];
        int gen_begin[HIST_STACK],gen_end[HIST_STACK];

        int history[64][64];

        /* we need an array of hist_rec's so we can take back the
           moves we make */
        hist_rec hist_dat[HIST_STACK];

        int nodes;  /* the number of nodes we've searched */

        /* a triangular PV array */
        move pv[HIST_STACK][HIST_STACK];
        int pv_length[HIST_STACK];
        BOOL follow_pv;


        /* Now we have the mailbox array, so called because it looks like a
           mailbox, at least according to Bob Hyatt. This is useful when we
           need to figure out what pieces can go where. Let's say we have a
           rook on square a4 (32) and we want to know if it can move one
           square to the left. We subtract 1, and we get 31 (h5). The rook
           obviously can't move to h5, but we don't know that without doing
           a lot of annoying work. Sooooo, what we do is figure out a4's
           mailbox number, which is 61. Then we subtract 1 from 61 (60) and
           see what mailbox[60] is. In this case, it's -1, so it's out of
           bounds and we can forget it. You can see how mailbox[] is used
           in attack() in board.c. */

        int mailbox[120];
        int mailbox64[64];


        /* slide, offsets, and offset are basically the vectors that
           pieces can move in. If slide for the piece is FALSE, it can
           only move one square in any one direction. offsets is the
           number of directions it can move in, and offset is an array
           of the actual directions. */

        BOOL slide[6];
        int offsets[6];
        int offset[6][8];


        /* This is the castle_mask array. We can use it to determine
           the castling permissions after a move. What we do is
           logical-AND the castle bits with the castle_mask bits for
           both of the move's squares. Let's say castle is 1, meaning
           that white can still castle kingside. Now we play a move
           where the rook on h1 gets captured. We AND castle with
           castle_mask[63], so we have 1&14, and castle becomes 0 and
           white can't castle kingside anymore. */

        int castle_mask[64];

        /* values of the pieces */
        int value[6];

        /* the piece letters, for print_board() */
        char piece_char[6];

        /* the initial board state */

        int init_color[64];
        int init_piece[64];

        //---------------------------------------------------------------------
        bool StopThinkingNow;
        bool *Thinking;
        bool *WhiteToMove;
        char *Position;
        Square *EnPassant;
        CastleSet *Castling;
        int *SearchDepth;
        MoveFunc Move;

        void __fastcall IntCopy (int *dest, const int *source, int count);
        int  __fastcall ColorOfPiece (Square sq);
        void __fastcall InitValues();
        void __fastcall PerformMove(void);

protected:
        void __fastcall Execute();

public:
        __fastcall ChessThread(char *position, bool *whitetomove,
            Square *enpassant, CastleSet *castling, bool *thinking,
            int *searchdepth, MoveFunc move);
        void __fastcall CancelThinking(void);

};

#endif
