/////////////////////////////////
// Main source file for FCRYPT.VxD
// FileName: FCRYPT.c - created by VxDWriter
// Copyright (c) 1997 by Somnath Kundu.  All Rights Reserved.

#include <vxdlib.h>
#pragma hdrstop
#include "fcrypt.h"
#include "ifshook.h"
#include <vxdmain.h>		// To be included in this file only

#ifdef __cplusplus
extern "C" {
#endif

static CONTROL_PROC Device_Init, W32_DeviceIoControl;

BEGIN_CONTROL_DISPATCH_MAP (FCRYPT)

    DEVICE_INIT,              Device_Init,
    SYS_DYNAMIC_DEVICE_INIT,  Device_Init,
    W32_DEVICEIOCONTROL,      W32_DeviceIoControl

END_CONTROL_DISPATCH_MAP()

#ifdef __cplusplus
}
#endif

//================ Put your locked code/data here ===========================
#pragma VxD_LOCKED_DATA_SEG
#pragma VxD_LOCKED_CODE_SEG

typedef DIOCPARAMETERS *PDIOC;

extern IFSHook FileHook;

DWORD _stdcall W32_GetVersion (PDIOC);

DWORD ( _stdcall *FCRYPT_W32_Proc[] )(PDIOC) = {
	W32_GetVersion,
	// Put other W32 APIs here as per requirment
};

#define MAX_FCRYPT_W32_API (sizeof(FCRYPT_W32_Proc)/sizeof(FCRYPT_W32_Proc[0]))

//================ Put your pageable code/data here =========================
#pragma VxD_PAGEABLE_CODE_SEG
#pragma VxD_PAGEABLE_DATA_SEG

//---------------------------------------------------------------------------
int _stdcall W32_DeviceIoControl (DECLARE_PREGS)
{
    DWORD dwRetVal = 0;

    if (_ECX == DIOC_OPEN )
       dwRetVal = 0;
    else if (_ECX == DIOC_CLOSEHANDLE )
       dwRetVal = VXD_SUCCESS;
    else if (_ECX > MAX_FCRYPT_W32_API )
       dwRetVal = ERROR_NOT_SUPPORTED;
    else
       dwRetVal = (*FCRYPT_W32_Proc[_ECX-1])((PDIOC)_ESI);

    return dwRetVal;
}

//---------------------------------------------------------------------------
DWORD _stdcall W32_GetVersion (PDIOC pDIOParam)
{
    *(WORD*)pDIOParam->lpvOutBuffer = (FCRYPT_MAJOR_VER << 8) | FCRYPT_MINOR_VER;
    return NO_ERROR;
}

//============ Put your initialization code/data here =======================
#pragma VxD_IDATA_SEG
#pragma VxD_ICODE_SEG

int _stdcall Device_Init (DECLARE_PREGS)
{
    // TODO: Add code here to handle SYS_DYNAMIC_DEVICE_INIT control message
    FileHook.HookIFS();
    return VXD_SUCCESS;
}
//---------------------------------------------------------------------------
