// Test program for loading/opening a VxD

#include <stdio.h>
#include <windows.h>

HANDLE OpenVxD (char *pDeviceName);
BOOL CloseVxD (HANDLE hVxD);
DWORD GetVxDVersion (HANDLE hVxD);

int main (int argc, char *argv[])
{
    HANDLE hVxD;
    char devName[64];

    if (argc > 1 && strlen( argv[1]) > 0)
      strcpy( devName, argv[1]);
    else
    {
       printf( "TestVxD: Program to open/load a VxD\n");
       printf( "Device Name: ");
       gets( devName);
    }

    hVxD = OpenVxD( devName);
    GetVxDVersion( hVxD);
	printf( "Press ENTER to close VxD . . . ");getchar();
    CloseVxD( hVxD);

    return 0;
}

HANDLE OpenVxD (char *pDeviceName)
{
    char* pExt;
    HANDLE hVxD = 0;
	char device[64];

    pExt = strrchr( pDeviceName, '.');
    if (pExt && stricmp( pExt, ".vxd") == 0)
       *pExt = 0;
    sprintf( device,"\\\\.\\%s", pDeviceName);

    hVxD = CreateFile( device,0,0,0,0,0,0);
    if (hVxD == INVALID_HANDLE_VALUE)
    {
        strcat( device, ".vxd");
        hVxD = CreateFile( device,0,0,0,CREATE_NEW,FILE_FLAG_DELETE_ON_CLOSE,0);
        if (hVxD == INVALID_HANDLE_VALUE)
        {
		   printf("Unable to open VxD: %s\n",strerror( GetLastError()));
           return hVxD;
        }
        printf( "Device %s is loaded successfully!\n",pDeviceName);
        return hVxD;
    }
    printf( "Device %s is opened successfully!\n",pDeviceName);
    return hVxD;
}

BOOL CloseVxD (HANDLE hVxD)
{
   BOOL retval;

   if (hVxD == INVALID_HANDLE_VALUE)
	   return 0;

   retval = CloseHandle( hVxD);
   if (!retval)
	  printf( "Error Closing VxD: %s",strerror( GetLastError()));
   else
	  printf( "Device is closed successfully!\n");

   return retval;
}

DWORD GetVxDVersion (HANDLE hVxD)
{
    DWORD  cbBytesReturned;
    struct { BYTE minor; BYTE major; WORD product; } verinfo = {0,0,0};

   	if (hVxD == INVALID_HANDLE_VALUE)
	   return 0;

    if (DeviceIoControl( hVxD,1,0,0,&verinfo,sizeof(verinfo),&cbBytesReturned,NULL))
       printf( "MajorVer: %u\tMinorVer: %u\n",verinfo.major,verinfo.minor);
    else
       printf( "Unable to call 1st API of VxD\n");

    return ( (verinfo.major << 8) | verinfo.minor);
}


