//////////////////////////////
// Declares IFSHook class
// FileName: IFSHook.hpp
// Copyright (c) 1997 by Somnath Kundu.  All Rights Reserved.

#ifndef _IFSHOOK_HPP
#define _IFSHOOK_HPP

struct IFSHookParams
{
    pIFSFunc FSDFnAddr;         // Pointer FSD function
    int FunctionNum;            // IFSFN function number
    int Drive;                  // Drive number (1-based)
    int ResourceFlags;          // Resource flag
    int CodePage;               // Code page WANSI/OEM
    pioreq pir;                 // Pointer IO request structure
    // DO NOT add any additional member variables or virtual functions here

    BOOL IsNetworkCall () { return (ResourceFlags & IFSFH_RES_NETWORK); }
    BOOL IsServerCall () { return ((pir->ir_pid & 0x80000000) && (pir->ir_pid != -1)); }
    
    int CallFSD () { return FSDFnAddr( pir); }
    int GetBCSPath (char* pPathBuff, int Len=MAX_PATH)
           { return BCSPath( pPathBuff, Len, pir->ir_ppath->pp_elements); }
    int GetBCSPath2 (char* pPathBuff, int Len=MAX_PATH)
           { return BCSPath( pPathBuff, Len, pir->ir_ppath2->pp_elements); }
    int GetBCSFName (char* pFNameBuff, int Len=MAX_PATH);

    BOOL Open ();
    BOOL Read ();
    BOOL Write ();
    BOOL Close ();
    BOOL Rename ();

 private:
    int BCSPath (char* pPathBuff, int len, PathElement* pp_elements);
    
};

struct FileHandleInfo
{
   fh_t     ir_fh;          // FSD file handle
   rh_t     ir_rh;          // FSD resource handle
   pos_t    ir_size;        // File size
};

struct IFSHook
{
    ppIFSFileHookFunc PrevHookFunc; // Previous hook function
    pIFSFileHookFunc  CurHookFunc;  // Current hook function
    FileHandleInfo* pFileHandle;    //
    int FileHandleNo;               // No. of handle present
    int MaxFileHandle;              // Max. No. of file handle present

    IFSHook (pIFSFileHookFunc HookFunc) { CurHookFunc = HookFunc; }
    ~IFSHook () { if (PrevHookFunc) UnhookIFS(); PrevHookFunc = NULL; }

    BOOL HookIFS (pIFSFileHookFunc HookFunc=NULL);  // Install hook
    BOOL UnhookIFS ();                              // Remove hook

    int CallPrevHook (IFSHookParams* pHookParams);

    BOOL SaveHandle (IFSHookParams* pHookParams);    // save file handle info
    BOOL RemoveHandle (IFSHookParams* pHookParams); // remove it
    FileHandleInfo* CheckHandle (IFSHookParams* pHookParams);
};

int __cdecl DispatchHook (pIFSFunc,int,int,int,int,pioreq);
BOOL IsEncryptedPath (const char* pFileName);
void ComplementBuff (BYTE* pInBuff, BYTE* pOutBuff, DWORD len);
int MoveFile (CSTR pExistingFile, CSTR pNewFile);

enum IFSMgr_Service { __IFSMgr_GetHeap = 0x40000D, __IFSMgr_RetHeap = 0x40000E,
                      __UniToBCS = 0x400040, __UniToBCSPath = 0x400041,
                      __IFSMgr_InstallFileSystemApiHook = 0x400067,
                      __IFSMgr_RemoveFileSystemApiHook = 0x400068 };

#endif  // #ifdef _IFSHOOK_HPP
