//////////////////////////////
// Implementation IFSHook class
// FileName: IFSHook.cpp
// Copyright (c) 1997 by Somnath Kundu.  All Rights Reserved.

#define WANTVXDWRAPS
#include <vxdlib.h>
#pragma  hdrstop
#include "fcrypt.h"
#include "ifshook.h"

IFSHook FileHook = &DispatchHook;       // Instantiated file hook

int __cdecl DispatchHook (pIFSFunc pFSD,int fn,int drv,int rf,int cp,pioreq pir)
{
   int iscalled = FALSE;
   IFSHookParams* pHookParam;

   pHookParam = (IFSHookParams*)&pFSD;
   switch (fn)
   {
   case IFSFN_OPEN:
      iscalled = pHookParam->Open();
      break;

   case IFSFN_READ:
      iscalled = pHookParam->Read();
      break;

   case IFSFN_WRITE:
      iscalled = pHookParam->Write();
      break;

   case IFSFN_CLOSE:
      iscalled = pHookParam->Close();
      break;

   case IFSFN_RENAME:
      iscalled = pHookParam->Rename();
      break;

   default:
      break;
   }
   if (iscalled)
      return pir->ir_error;

   return FileHook.CallPrevHook( pHookParam);
}

BOOL IFSHookParams::Open ()
{
    char path[MAX_PATH];

    GetBCSPath( path);
    if (!IsEncryptedPath( path))
      return FALSE;

    if (ACCESS_WRITEONLY == (pir->ir_flags & ACCESS_MODE_MASK))
       ++pir->ir_flags;                // make it READWRITE

    FileHook.CallPrevHook( this);

    if (pir->ir_error || (pir->ir_attr & FILE_ATTRIBUTE_DIRECTORY)
        || (pir->ir_attr & FILE_ATTRIBUTE_LABEL))
       return TRUE;

    FileHook.SaveHandle( this);

    return TRUE;
}

BOOL IFSHookParams::Read ()
{
    FileHandleInfo* pFHInfo;
    if (!(pFHInfo = FileHook.CheckHandle( this)))
       return FALSE;

    if (!pir->ir_length)
       return FALSE;

    BYTE* ir_data = (BYTE*)pir->ir_data;       // save the pointer
    FileHook.CallPrevHook( this);       // do actual reading
    ComplementBuff( ir_data, ir_data, pir->ir_length);  // decrypt buffer

    return TRUE;
}


BOOL IFSHookParams::Write ()
{
    FileHandleInfo* pFHInfo;
    if (!(pFHInfo = FileHook.CheckHandle( this)))
       return FALSE;

    if (!pir->ir_length)        // end of file marking
       return FALSE;            // no problem, we are doing it byte by byte

    DWORD ir_length = pir->ir_length;   // save length
    DWORD ir_pos = pir->ir_pos;         // save position
    BYTE* ir_data = (BYTE*)pir->ir_data;       // save data pointer

    DWORD len = ir_length;
    DWORD pcount = len / PAGESIZE;   // break it in 4096 byte block
    if (len % PAGESIZE)
       ++pcount;

    BYTE* ir_data1;
    if (len >= PAGESIZE)        // allocate IFSMgr's heap of Max.4096 bytes
       ir_data1 = (BYTE*)CVXDCALL2( IFSMgr_GetHeap, PAGESIZE);
    else
       ir_data1 = (BYTE*)CVXDCALL2( IFSMgr_GetHeap, len);
    assert( ir_data1);

    DWORD len1;

    while (pcount--)
    {
        len1 = len > PAGESIZE ? PAGESIZE : len;
        ComplementBuff( ir_data, ir_data1, len1);  // encrypt the buffer

        pir->ir_data = ir_data1;        // setup new packet data
        pir->ir_pos = ir_pos;
        pir->ir_length = len1;
        FileHook.CallPrevHook( this);
        assert( pir->ir_error == 0 && pir->ir_length == len1);

        len -= len1;            // subtract from total length
        ir_pos += len1;         // advance file position
        ir_data += len1;        // advance data pointer
    }
    assert( len == 0);          // must be zero if there is no error
    CVXDCALL2( IFSMgr_RetHeap, ir_data1);  // return IFSMgr's heap

    pir->ir_length = ir_length-len; // actual length written
    pir->ir_pos = ir_pos;           // current position
    pir->ir_data = ir_data;         // data pointer (not required)

    return TRUE;
}

BOOL IFSHookParams::Close ()
{
    if (pir->ir_flags == CLOSE_FINAL && FileHook.CheckHandle( this))
    {
        FileHook.CallPrevHook( this);
        if (!pir->ir_error)
           FileHook.RemoveHandle( this);
        return TRUE;
    }
    return FALSE;
}

#define XOR(b1,b2)  ( (b1 && !b2) || (!b1 && b2) )   // No ^^ operator!

BOOL IFSHookParams::Rename ()
{
    char path[MAX_PATH];
    char path2[MAX_PATH];

    GetBCSPath( path);
    GetBCSPath2( path2);

    BOOL p = IsEncryptedPath( path);
    BOOL p2 = IsEncryptedPath( path2);
    if (!XOR(p,p2))                    
       return FALSE;

    int attr;
    if ((attr = GetFileAttr( path)) != -1 && (attr & FILE_ATTRIBUTE_DIRECTORY))
    {
       pir->ir_error = ERROR_FILE_EXISTS;     // prevent renaming directory
       return TRUE;                           // altenative is copy files recursively!
    }
    
    if (MoveFile( path, path2))
       pir->ir_error = ERROR_SUCCESS;
    else
       pir->ir_error = ERROR_FILE_EXISTS;

    return TRUE;
}

BOOL IFSHook::SaveHandle (IFSHookParams* pHookParams)
{
   int i;
   pioreq pir;

   pir = pHookParams->pir;
   for (i=0; i < MaxFileHandle; i++)   // search for free file handle slot
      if (pFileHandle[i].ir_fh == 0)
         break;

   // Keep free slot earlier rather than when needed
   if (!(pir->ir_options & (R0_SWAPPER_CALL | R0_MM_READ_WRITE))
       && (i+10) > MaxFileHandle)
   {
       pFileHandle = (FileHandleInfo *)_HeapReAllocate( pFileHandle,
                          (i+20) * sizeof(FileHandleInfo), HEAPZEROINIT);
       MaxFileHandle = i+20;
   }
   if (i == FileHandleNo)
      ++FileHandleNo;
   pFileHandle[i].ir_fh   = pir->ir_fh;
   pFileHandle[i].ir_rh   = pir->ir_rh;
   pFileHandle[i].ir_size = pir->ir_size;

   return TRUE;
}

FileHandleInfo* IFSHook::CheckHandle (IFSHookParams* pHookParams)
{
   int i;

   for (i=0; i < FileHandleNo; i++)
      if (pHookParams->pir->ir_fh == pFileHandle[i].ir_fh
          && pHookParams->pir->ir_rh == pFileHandle[i].ir_rh)
         break;

   if (i == FileHandleNo)
      return NULL;

   return &pFileHandle[i];
}


BOOL IFSHook::RemoveHandle (IFSHookParams* pHookParams)
{
   int i;

   for (i=0; i < FileHandleNo; i++)
      if (pHookParams->pir->ir_fh == pFileHandle[i].ir_fh
          && pHookParams->pir->ir_rh == pFileHandle[i].ir_rh)
         break;

   if (i == FileHandleNo)
      return FALSE;

   pFileHandle[i].ir_rh  = 0;
   pFileHandle[i].ir_fh  = 0;
   if (i == FileHandleNo-1)
      --FileHandleNo;

   return TRUE;
}

char* EncryptedDir = "c:\\EncrFile";      // Encrypted directory name
int EncryptedDirLen = 11;

BOOL IsEncryptedPath (const char* pFileName)
{
    int len;

    len = strlen( pFileName);
    if ((pFileName[len] == '\\' || pFileName[len] == '\0')
        && strnicmp( pFileName, EncryptedDir, EncryptedDirLen) == 0)
      return TRUE;
    return FALSE;
}

// This function is used for both encryption and decryption
void ComplementBuff (BYTE* pInBuff, BYTE* pOutBuff, DWORD len)
{
   for (DWORD i=0; i < len; i++)
      pOutBuff[i] = ~pInBuff[i];
   return;
}
