//////////////////////////////
// Implementation of MsgMon class
// FileName: MsgMonCl.cpp
// Copyright (c) 1997 by Somnath Kundu.  All Rights Reserved.

#include <vxdlib.h>
#pragma  hdrstop
#include "msgmon.h"
#include "msgmoncl.h"

#pragma VxD_LOCKED_DATA_SEG
#pragma VxD_LOCKED_CODE_SEG

// String value for all control messages
const char* MsgMon::MsgStr[] = { 
    "SYS_CRITICAL_INIT","DEVICE_INIT","INIT_COMPLETE","SYS_VM_INIT",
    "SYS_VM_TERMINATE","SYSTEM_EXIT","SYS_CRITICAL_EXIT","CREATE_VM",
    "VM_CRITICAL_INIT","VM_INIT","VM_TERMINATE","VM_NOT_EXECUTEABLE",
    "DESTROY_VM","VM_SUSPEND","VM_RESUME","SET_DEVICE_FOCUS",
    "BEGIN_MESSAGE_MODE","END_MESSAGE_MODE","REBOOT_PROCESSOR",
    "QUERY_DESTROY","DEBUG_QUERY","BEGIN_PM_APP","END_PM_APP",
    "DEVICE_REBOOT_NOTIFY","CRIT_REBOOT_NOTIFY","CLOSE_VM_NOTIFY",
    "POWER_EVENT","SYS_DYNAMIC_DEVICE_INIT","SYS_DYNAMIC_DEVICE_EXIT",
    "CREATE_THREAD","THREAD_INIT","TERMINATE_THREAD","THREAD_Not_Executeable",
    "DESTROY_THREAD","PNP_NEW_DEVNODE","W32_DEVICEIOCONTROL",
    "SYS_VM_TERMINATE2","SYSTEM_EXIT2","SYS_CRITICAL_EXIT2","VM_TERMINATE2",
    "VM_NOT_EXECUTEABLE2","DESTROY_VM2","VM_SUSPEND2","END_MESSAGE_MODE2",
    "END_PM_APP2","DEVICE_REBOOT_NOTIFY2","CRIT_REBOOT_NOTIFY2",
    "CLOSE_VM_NOTIFY2","GET_CONTENTION_HANDLER","KERNEL32_INITIALIZED",
    "KERNEL32_SHUTDOWN"};

FNVOID *OrgControlProc;         // Real control proc
MsgMon SysMsgMon;               // Instantiated the class

const char* LogFile = "c:\\MsgMon.Log";

NAKED void ControlProc ()
{
   ENTER;
   SysMsgMon.Save( _EAX);
   JUMP_SERVICE( OrgControlProc);   // jump to original control proc
}

MsgMon::~MsgMon ()
{
    int hfile = open( LogFile, ACCESS_READWRITE, ACTION_OPENALWAYS);
    if (hfile != -1)
    {
       lseek( hfile, 0, SEEK_END);
       char msg[128];
       sprintf( msg, "\n%s\n", GetTimeStr());
       write( hfile, msg, strlen( msg));
       for (int len=0,i=0; i < MsgCount; i++)
       {
          len = GetMsg( i, msg);
          write( hfile, msg, len);
       }
       close( hfile);
    }
    thisDDB.DDB_Control_Proc = (DWORD)OrgControlProc;
    delete [] MsgTime;
}

// Save control mesage and its time stamp
void MsgMon::Save (int msg)
{
    if (MsgCount >= MaxCount)
    {
        MaxCount += 50;
        MsgTime = new( HEAPZEROINIT, MsgTime) MSGTIME [MaxCount];
    }
    MsgTime[MsgCount].Msg = msg;
    MsgTime[MsgCount++].Time = pSysTime[0];

    return;
}

int MsgMon::GetMsg (int msgno, char* pMsg)
{
    return sprintf( pMsg, "Time: %d.%2d\t%s\n",MsgTime[msgno].Time/1000,
                     MsgTime[msgno].Time%1000, MsgStr[MsgTime[msgno].Msg]);
}

#pragma VxD_IDATA_SEG
#pragma VxD_ICODE_SEG
    
// Constructor: Insert our custom control proc and allocate memory
MsgMon::MsgMon ()
{
    MaxCount = 1;
    MsgTime = new( HEAPZEROINIT) MSGTIME [MaxCount];
    MsgCount = 0;

    OrgControlProc = (FNVOID *)thisDDB.DDB_Control_Proc;
    thisDDB.DDB_Control_Proc = (DWORD)ControlProc;

    pSysTime = (DWORD*)CVXDCALL1( Get_System_Time_Address);
}
    

