/////////////////////////////////
// Main source file for MSGMON.VxD
// FileName: MsgMon.cpp - created by VxDWriter
// Copyright (c) 1997 by Somnath Kundu.  All Rights Reserved.
#include <vxdlib.h>
#pragma hdrstop
#include "MsgMon.h"
#include "msgmoncl.h"
#include <vxdmain.h>		// To be included in this file only

#ifdef __cplusplus
extern "C" {
#endif

static CONTROL_PROC W32_DeviceIoControl,Initialize,Terminate;

BEGIN_CONTROL_DISPATCH_MAP (MSGMON)

    DEVICE_INIT,              Initialize,
    SYS_DYNAMIC_DEVICE_INIT,  Initialize,
    W32_DEVICEIOCONTROL,      W32_DeviceIoControl,
    SYS_VM_TERMINATE,         Terminate

END_CONTROL_DISPATCH_MAP()

#ifdef __cplusplus
}
#endif

//================ Put your locked code/data here ===========================
#pragma VxD_LOCKED_DATA_SEG
#pragma VxD_LOCKED_CODE_SEG

typedef DIOCPARAMETERS *PDIOC;

DWORD _stdcall W32_GetVersion (PDIOC);

DWORD ( _stdcall *MSGMON_W32_Proc[] )(PDIOC) = {
	W32_GetVersion,
	// Put other W32 APIs here as per requirment
};

#define MAX_MSGMON_W32_API (sizeof(MSGMON_W32_Proc)/sizeof(MSGMON_W32_Proc[0]))

//================ Put your pageable code/data here =========================
#pragma VxD_PAGEABLE_CODE_SEG
#pragma VxD_PAGEABLE_DATA_SEG

//---------------------------------------------------------------------------
int _stdcall W32_DeviceIoControl (DECLARE_PREGS)
{
    DWORD dwRetVal = 0;

    if (_ECX == DIOC_OPEN )
       dwRetVal = 0;
    else if (_ECX == DIOC_CLOSEHANDLE )
       dwRetVal = VXD_SUCCESS;
    else if (_ECX > MAX_MSGMON_W32_API )
       dwRetVal = ERROR_NOT_SUPPORTED;
    else
       dwRetVal = (*MSGMON_W32_Proc[_ECX-1])((PDIOC)_ESI);

    return dwRetVal;
}

//---------------------------------------------------------------------------
DWORD _stdcall W32_GetVersion (PDIOC pDIOParam)
{
    *(WORD*)pDIOParam->lpvOutBuffer = (MSGMON_MAJOR_VER << 8) | MSGMON_MINOR_VER;
    return NO_ERROR;
}

int _stdcall Terminate (DECLARE_PREGS)
{
    SysMsgMon.MsgMon::~MsgMon();      // call destructor for static VxD
    return VXD_SUCCESS;               
}   


//============ Put your initialization code/data here =======================
#pragma VxD_IDATA_SEG
#pragma VxD_ICODE_SEG

int _stdcall Initialize (DECLARE_PREGS)
{
    SysMsgMon.Save( _EAX);
    return VXD_SUCCESS;
}   
//---------------------------------------------------------------------------
